/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.fest.util.CollectionFilter;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collections {
    public static <T> List<T> list(T ... elements) {
        if (elements == null) {
            return null;
        }
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> Collection<T> duplicatesFrom(Collection<T> c) {
        HashSet<T> duplicates = new HashSet<T>();
        if (Collections.isEmpty(c)) {
            return duplicates;
        }
        HashSet<T> onlyOne = new HashSet<T>();
        for (T e : c) {
            if (onlyOne.contains(e)) {
                duplicates.add(e);
                continue;
            }
            onlyOne.add(e);
        }
        return duplicates;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    private Collections() {
    }

    public static <T> List<T> filter(Collection<?> target, CollectionFilter<T> filter) {
        return filter.filter(target);
    }

    public static String format(Collection<?> c) {
        if (c == null) {
            return null;
        }
        Iterator<?> i = c.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        while (true) {
            Object e;
            b.append((e = i.next()) == c ? "(this Collection)" : Strings.quote(e));
            if (!i.hasNext()) {
                return b.append(']').toString();
            }
            b.append(", ");
        }
    }
}

