/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.orfjackal.retrolambda.ClassAnalyzer;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.interfaces.MethodInfo;
import net.orfjackal.retrolambda.interfaces.MethodSignature;
import net.orfjackal.retrolambda.lambdas.EnclosingClass;
import net.orfjackal.retrolambda.lambdas.LambdaFactoryMethod;
import net.orfjackal.retrolambda.lambdas.LambdaNaming;
import net.orfjackal.retrolambda.lambdas.LambdaReifier;
import net.orfjackal.retrolambda.lambdas.Types;
import net.orfjackal.retrolambda.minlog.Log;
import net.orfjackal.retrolambda.util.Bytecode;
import net.orfjackal.retrolambda.util.Flags;

public class BackportLambdaInvocations
extends ClassVisitor {
    private int classAccess;
    private String className;
    private final ClassAnalyzer analyzer;
    private final Map<Handle, Handle> lambdaAccessToImplMethods = new LinkedHashMap<Handle, Handle>();
    private final EnclosingClass enclosingClass = new EnclosingClass();

    public BackportLambdaInvocations(ClassVisitor next, ClassAnalyzer analyzer) {
        super(327680, next);
        this.analyzer = analyzer;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        BackportLambdaInvocations.resetLambdaClassSequenceNumber();
        this.classAccess = access;
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.enclosingClass.sourceFile = source;
        super.visitSource(source, debug);
    }

    private static void resetLambdaClassSequenceNumber() {
        try {
            Field counterField = Class.forName("java.lang.invoke.InnerClassLambdaMetafactory").getDeclaredField("counter");
            counterField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)counterField.get(null);
            counter.set(0);
        }
        catch (Throwable t) {
            Log.warn("Failed to start class numbering from one. Don't worry, it's cosmetic, but please file a bug report and tell on which JDK version this happened.", t);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (LambdaNaming.isBodyMethod(access, name) && Flags.isPrivateMethod(access) && Flags.isInstanceMethod(access &= 0xFFFFFFFD)) {
            access |= 8;
            desc = Types.prependArgumentType(Type.getObjectType(this.className), desc);
        }
        if (LambdaNaming.isDeserializationHook(access, name, desc)) {
            return null;
        }
        return new InvokeDynamicInsnConverter(super.visitMethod(access, name, desc, signature, exceptions));
    }

    Handle getLambdaAccessMethod(Handle implMethod) {
        if (!implMethod.getOwner().equals(this.className)) {
            if (this.isNonOwnedMethodVisible(implMethod)) {
                return implMethod;
            }
        } else {
            if (Flags.isInterface(this.classAccess)) {
                return implMethod;
            }
            if (this.isOwnedMethodVisible(implMethod)) {
                return implMethod;
            }
            if (LambdaNaming.isBodyMethodName(implMethod.getName())) {
                if (implMethod.getTag() == 7) {
                    String desc = Types.prependArgumentType(Type.getObjectType(implMethod.getOwner()), implMethod.getDesc());
                    return new Handle(6, implMethod.getOwner(), implMethod.getName(), desc, false);
                }
                return implMethod;
            }
        }
        String name = "access$lambda$" + this.lambdaAccessToImplMethods.size();
        String desc = this.getLambdaAccessMethodDesc(implMethod);
        Handle accessMethod = new Handle(6, this.className, name, desc, false);
        this.lambdaAccessToImplMethods.put(accessMethod, implMethod);
        return accessMethod;
    }

    private boolean isOwnedMethodVisible(Handle implMethod) {
        MethodSignature implSignature = new MethodSignature(implMethod.getName(), implMethod.getDesc());
        Collection<MethodInfo> methods = this.analyzer.getMethods(Type.getObjectType(implMethod.getOwner()));
        for (MethodInfo method : methods) {
            if (!method.signature.equals(implSignature)) continue;
            return (method.access & 2) == 0;
        }
        throw new IllegalStateException("Non-analyzed method " + implMethod + ". Report this as a bug.");
    }

    private boolean isNonOwnedMethodVisible(Handle implMethod) {
        if (BackportLambdaInvocations.getPackage(this.className).equals(BackportLambdaInvocations.getPackage(implMethod.getOwner()))) {
            return true;
        }
        MethodSignature implSignature = new MethodSignature(implMethod.getName(), implMethod.getDesc());
        Collection<MethodInfo> methods = this.analyzer.getMethods(Type.getObjectType(implMethod.getOwner()));
        for (MethodInfo method : methods) {
            if (!method.signature.equals(implSignature)) continue;
            return (method.access & 4) == 0;
        }
        return true;
    }

    private static String getPackage(String className) {
        int lastSlash = className.lastIndexOf(47);
        return lastSlash == -1 ? "" : className.substring(0, lastSlash);
    }

    private String getLambdaAccessMethodDesc(Handle implMethod) {
        if (implMethod.getTag() == 6) {
            return implMethod.getDesc();
        }
        if (implMethod.getTag() == 8) {
            return Types.changeReturnType(Type.getObjectType(implMethod.getOwner()), implMethod.getDesc());
        }
        return Types.prependArgumentType(Type.getObjectType(this.className), implMethod.getDesc());
    }

    @Override
    public void visitEnd() {
        for (Map.Entry<Handle, Handle> entry : this.lambdaAccessToImplMethods.entrySet()) {
            Handle accessMethod = entry.getKey();
            Handle implMethod = entry.getValue();
            Bytecode.generateDelegateMethod(this.cv, 4104, accessMethod, implMethod);
        }
        super.visitEnd();
    }

    private static Class<?> loadClass(String className) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.loadClass(className.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private class InvokeDynamicInsnConverter
    extends MethodVisitor {
        public InvokeDynamicInsnConverter(MethodVisitor next) {
            super(327680, next);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory")) {
                this.backportLambda(name, Type.getType(desc), bsm, bsmArgs);
            } else {
                super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
            }
        }

        private void backportLambda(String invokedName, Type invokedType, Handle bsm, Object[] bsmArgs) {
            Class invoker = BackportLambdaInvocations.loadClass(BackportLambdaInvocations.this.className);
            Handle implMethod = (Handle)bsmArgs[1];
            Handle accessMethod = BackportLambdaInvocations.this.getLambdaAccessMethod(implMethod);
            LambdaFactoryMethod factory = LambdaReifier.reifyLambdaClass(BackportLambdaInvocations.this.enclosingClass, implMethod, accessMethod, invoker, invokedName, invokedType, bsm, bsmArgs);
            super.visitMethodInsn(184, factory.getOwner(), factory.getName(), factory.getDesc(), false);
        }
    }
}

