/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.ImageLoaderListener;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;

public class ImageLoader {
    public ImageData[] data;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int backgroundPixel;
    public int repeatCount;
    public int compression;
    static final int PNG_INTERLACE_METHOD_OFFSET = 28;
    List<ImageLoaderListener> imageLoaderListeners;

    public ImageLoader() {
        this.reset();
    }

    void reset() {
        this.data = null;
        this.logicalScreenWidth = 0;
        this.logicalScreenHeight = 0;
        this.backgroundPixel = -1;
        this.repeatCount = 1;
        this.compression = -1;
    }

    public ImageData[] load(InputStream stream) {
        if (stream == null) {
            SWT.error(4);
        }
        this.reset();
        ImageData[] imgDataArray = this.getImageDataArrayFromStream(stream);
        this.data = imgDataArray;
        return imgDataArray;
    }

    boolean isInterlacedPNG(byte[] imageAsByteArray) {
        return imageAsByteArray.length > 28 && imageAsByteArray[28] != 0;
    }

    ImageData[] getImageDataArrayFromStream(InputStream stream) {
        byte[] buffer = new byte[2048];
        long loader = GDK.gdk_pixbuf_loader_new();
        ArrayList<ImageData> imgDataList = new ArrayList<ImageData>();
        try {
            boolean isStatic;
            int length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((length = stream.read(buffer)) > -1) {
                baos.write(buffer, 0, length);
            }
            baos.flush();
            byte[] data_buffer = baos.toByteArray();
            if (data_buffer.length == 0) {
                SWT.error(42);
            }
            long buffer_ptr = OS.g_malloc(data_buffer.length);
            C.memmove(buffer_ptr, data_buffer, (long)data_buffer.length);
            GDK.gdk_pixbuf_loader_write(loader, buffer_ptr, data_buffer.length, null);
            GDK.gdk_pixbuf_loader_close(loader, null);
            long pixbuf_animation = GDK.gdk_pixbuf_loader_get_animation(loader);
            if (pixbuf_animation == 0L) {
                SWT.error(40);
            }
            if (isStatic = GDK.gdk_pixbuf_animation_is_static_image(pixbuf_animation)) {
                long pixbuf = GDK.gdk_pixbuf_animation_get_static_image(pixbuf_animation);
                ImageData imgData = ImageLoader.pixbufToImageData(pixbuf);
                imgData.type = this.getImageFormat(loader);
                imgDataList.add(imgData);
            } else {
                long start_time = OS.g_malloc(8L);
                OS.g_get_current_time(start_time);
                long animation_iter = GDK.gdk_pixbuf_animation_get_iter(pixbuf_animation, start_time);
                int delay_time = 0;
                int time_offset = 0;
                int num_frames = 32;
                for (int i = 0; i < num_frames; ++i) {
                    delay_time = GDK.gdk_pixbuf_animation_iter_get_delay_time(animation_iter);
                    OS.g_time_val_add(start_time, (time_offset += delay_time) * 1000);
                    boolean update = GDK.gdk_pixbuf_animation_iter_advance(animation_iter, start_time);
                    if (!update) break;
                    long curr_pixbuf = GDK.gdk_pixbuf_animation_iter_get_pixbuf(animation_iter);
                    long pixbuf_copy = GDK.gdk_pixbuf_copy(curr_pixbuf);
                    ImageData imgData = ImageLoader.pixbufToImageData(pixbuf_copy);
                    if (this.logicalScreenHeight == 0 && this.logicalScreenWidth == 0) {
                        this.logicalScreenHeight = imgData.height;
                        this.logicalScreenWidth = imgData.width;
                    }
                    OS.g_object_unref(pixbuf_copy);
                    imgData.type = this.getImageFormat(loader);
                    imgData.delayTime = delay_time;
                    imgDataList.add(imgData);
                }
            }
            ImageData[] imgDataArray = new ImageData[imgDataList.size()];
            for (int i = 0; i < imgDataList.size(); ++i) {
                imgDataArray[i] = (ImageData)imgDataList.get(i);
                ImageData data = (ImageData)imgDataArray[i].clone();
                if (!this.hasListeners() || imgDataArray == null) continue;
                if (data.type == 5 && this.isInterlacedPNG(data_buffer)) {
                    this.notifyListeners(new ImageLoaderEvent(this, data, i, true));
                    continue;
                }
                if (data.type == 5) continue;
                this.notifyListeners(new ImageLoaderEvent(this, data, i, true));
            }
            OS.g_free(buffer_ptr);
            OS.g_object_unref(loader);
            stream.close();
            return imgDataArray;
        }
        catch (IOException e) {
            SWT.error(39);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData[] load(String filename) {
        if (filename == null) {
            SWT.error(4);
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(filename);
            ImageData[] imageDataArray = this.load(stream);
            return imageDataArray;
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        finally {
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    ImageData[] loadFromFile(String filename) {
        long pixbuf = ImageLoader.gdk_pixbuf_new_from_file(filename);
        if (pixbuf == 0L) {
            return null;
        }
        ImageData imgData = ImageLoader.pixbufToImageData(pixbuf);
        this.data = new ImageData[]{imgData};
        return this.data;
    }

    int getImageFormat(long loader) {
        String nameStr;
        long format = GDK.gdk_pixbuf_loader_get_format(loader);
        long name = GDK.gdk_pixbuf_format_get_name(format);
        switch (nameStr = Converter.cCharPtrToJavaString(name, false)) {
            case "bmp": {
                return 0;
            }
            case "gif": {
                return 2;
            }
            case "ico": {
                return 3;
            }
            case "jpeg": {
                return 4;
            }
            case "png": {
                return 5;
            }
        }
        return -1;
    }

    static ImageData pixbufToImageData(long pixbuf) {
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        int width = GDK.gdk_pixbuf_get_width(pixbuf);
        int height = GDK.gdk_pixbuf_get_height(pixbuf);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        int n_channels = GDK.gdk_pixbuf_get_n_channels(pixbuf);
        int bits_per_sample = GDK.gdk_pixbuf_get_bits_per_sample(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        int lastRowWidth = width * ((n_channels * bits_per_sample + 7) / 8);
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, pixels, (long)(stride * (height - 1) + lastRowWidth));
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData imgData = new ImageData(width, height, bits_per_sample * n_channels, palette, stride, srcData);
        if (hasAlpha) {
            imgData.alphaData = new byte[width * height];
            byte[] alphaData = imgData.alphaData;
            int offset = 0;
            int alphaOffset = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    byte a = srcData[offset + 3];
                    srcData[offset + 0] = 0;
                    alphaData[alphaOffset++] = a;
                    if (a != 0) {
                        srcData[offset + 1] = r;
                        srcData[offset + 2] = g;
                        srcData[offset + 3] = b;
                    }
                    ++x;
                    offset += n_channels;
                }
            }
        } else {
            int offset = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    srcData[offset + 0] = r;
                    srcData[offset + 1] = g;
                    srcData[offset + 2] = b;
                    ++x;
                    offset += n_channels;
                }
            }
        }
        return imgData;
    }

    static long gdk_pixbuf_new_from_file(String filename) {
        int length = filename.length();
        char[] chars = new char[length];
        filename.getChars(0, length, chars, 0);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        return GDK.gdk_pixbuf_new_from_file(buffer, null);
    }

    public void save(OutputStream stream, int format) {
        int y;
        int new_offset;
        int alpha_offset;
        if (stream == null) {
            SWT.error(4);
        }
        if (format == -1) {
            SWT.error(42);
        }
        if (this.data == null) {
            SWT.error(4);
        }
        ImageData imgData = this.data[0];
        int colorspace = 0;
        boolean alpha_supported = format == 6 || format == 5 || format == 3;
        boolean has_alpha = imgData.alphaData != null && alpha_supported;
        int width = imgData.width;
        int height = imgData.height;
        int n_channels = imgData.bytesPerLine / width;
        int bytes_per_pixel = imgData.bytesPerLine / width;
        int da = 3;
        int dr = 0;
        int dg = 1;
        int db = 2;
        int or = 0;
        int og = 1;
        int ob = 2;
        PaletteData palette = imgData.palette;
        if (palette.isDirect && palette.blueShift < 0) {
            or = 2;
            og = 1;
            ob = 0;
        }
        if (has_alpha && bytes_per_pixel == 3) {
            bytes_per_pixel = 4;
        }
        byte[] srcData = new byte[width * height * 4];
        int n = alpha_offset = n_channels == 4 ? 1 : 0;
        if (has_alpha) {
            int offset = 0;
            new_offset = 0;
            int alphaOffset = 0;
            for (y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    byte b;
                    byte a = imgData.alphaData[alphaOffset++];
                    byte r = imgData.data[offset + alpha_offset + or];
                    byte g = imgData.data[offset + alpha_offset + og];
                    srcData[new_offset + db] = b = imgData.data[offset + alpha_offset + ob];
                    srcData[new_offset + dg] = g;
                    srcData[new_offset + dr] = r;
                    srcData[new_offset + da] = a;
                    ++x;
                    offset += n_channels;
                    new_offset += bytes_per_pixel;
                }
            }
        } else {
            int offset = 0;
            new_offset = 0;
            for (y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    byte r = imgData.data[offset + alpha_offset + or];
                    byte g = imgData.data[offset + alpha_offset + og];
                    byte b = imgData.data[offset + alpha_offset + ob];
                    int a = -1;
                    srcData[new_offset + db] = b;
                    srcData[new_offset + dg] = g;
                    srcData[new_offset + dr] = r;
                    srcData[new_offset + da] = a;
                    ++x;
                    offset += n_channels;
                    new_offset += bytes_per_pixel;
                }
            }
        }
        long buffer_ptr = OS.g_malloc(srcData.length);
        C.memmove(buffer_ptr, srcData, (long)srcData.length);
        int rowstride = srcData.length / height;
        long pixbuf = GDK.gdk_pixbuf_new_from_data(buffer_ptr, colorspace, true, 8, width, height, rowstride, 0L, 0L);
        if (pixbuf == 0L) {
            OS.g_free(buffer_ptr);
            SWT.error(4);
        }
        String typeStr = "";
        switch (format) {
            case 1: {
                typeStr = "bmp";
                break;
            }
            case 0: {
                typeStr = "bmp";
                break;
            }
            case 2: {
                typeStr = "gif";
                break;
            }
            case 3: {
                typeStr = "ico";
                break;
            }
            case 4: {
                typeStr = "jpeg";
                break;
            }
            case 5: {
                typeStr = "png";
                break;
            }
            case 6: {
                typeStr = "tiff";
            }
        }
        byte[] type = Converter.wcsToMbcs(typeStr, true);
        long[] buffer = new long[1];
        if (type == null || typeStr == "") {
            OS.g_free(buffer_ptr);
            SWT.error(42);
        }
        long[] len = new long[1];
        GDK.gdk_pixbuf_save_to_bufferv(pixbuf, buffer, len, type, null, null, null);
        byte[] byteArray = new byte[(int)len[0]];
        C.memmove(byteArray, buffer[0], (long)byteArray.length);
        try {
            stream.write(byteArray);
        }
        catch (IOException e) {
            OS.g_free(buffer_ptr);
            SWT.error(39);
        }
        OS.g_free(buffer_ptr);
    }

    public void save(String filename, int format) {
        if (filename == null) {
            SWT.error(4);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename);
        }
        catch (IOException e) {
            SWT.error(39, e);
        }
        this.save(stream, format);
        try {
            ((OutputStream)stream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            this.imageLoaderListeners = new ArrayList<ImageLoaderListener>();
        }
        this.imageLoaderListeners.add(listener);
    }

    public void removeImageLoaderListener(ImageLoaderListener listener) {
        if (listener == null) {
            SWT.error(4);
        }
        if (this.imageLoaderListeners == null) {
            return;
        }
        this.imageLoaderListeners.remove(listener);
    }

    public boolean hasListeners() {
        return this.imageLoaderListeners != null && this.imageLoaderListeners.size() > 0;
    }

    public void notifyListeners(ImageLoaderEvent event) {
        if (!this.hasListeners()) {
            return;
        }
        int size = this.imageLoaderListeners.size();
        for (int i = 0; i < size; ++i) {
            ImageLoaderListener listener = this.imageLoaderListeners.get(i);
            listener.imageDataLoaded(event);
        }
    }
}

