/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.util;

import java.util.HashMap;
import java.util.Map;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.lambdas.Handles;

public class Bytecode {
    private static final Map<Integer, String> bytecodeVersionNames = new HashMap<Integer, String>();

    public static String getJavaVersion(int bytecodeVersion) {
        return bytecodeVersionNames.getOrDefault(bytecodeVersion, "unknown version");
    }

    public static void generateDelegateMethod(ClassVisitor cv, int access, Handle method, Handle target) {
        MethodVisitor mv = cv.visitMethod(access, method.getName(), method.getDesc(), null, null);
        mv.visitCode();
        if (target.getTag() == 8) {
            mv.visitTypeInsn(187, target.getOwner());
            mv.visitInsn(89);
        }
        Type[] args = Bytecode.longest(Type.getArgumentTypes(method.getDesc()), Type.getArgumentTypes(target.getDesc()));
        int varIndex = 0;
        for (Type arg : args) {
            mv.visitVarInsn(arg.getOpcode(21), varIndex);
            varIndex += arg.getSize();
        }
        mv.visitMethodInsn(Handles.getOpcode(target), target.getOwner(), target.getName(), target.getDesc(), target.getTag() == 9);
        mv.visitInsn(Type.getReturnType(method.getDesc()).getOpcode(172));
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private static Type[] longest(Type[] t1, Type[] t2) {
        return t1.length > t2.length ? t1 : t2;
    }

    public static String prependArgumentType(String desc, Type type) {
        Type returnType = Type.getReturnType(desc);
        Type[] args = Type.getArgumentTypes(desc);
        Type[] newArgs = new Type[args.length + 1];
        newArgs[0] = type;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return Type.getMethodDescriptor(returnType, newArgs);
    }

    static {
        bytecodeVersionNames.put(196653, "Java 1.1");
        bytecodeVersionNames.put(46, "Java 1.2");
        bytecodeVersionNames.put(47, "Java 1.3");
        bytecodeVersionNames.put(48, "Java 1.4");
        bytecodeVersionNames.put(49, "Java 5");
        bytecodeVersionNames.put(50, "Java 6");
        bytecodeVersionNames.put(51, "Java 7");
        bytecodeVersionNames.put(52, "Java 8");
    }
}

