/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.lambdas;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.Type;

public class Types {
    public static Object asmToJdkType(Object arg, ClassLoader classLoader, MethodHandles.Lookup caller) throws Exception {
        if (arg instanceof Type) {
            Type type = (Type)arg;
            if (type.getSort() == 11) {
                return Types.toMethodType(type, classLoader);
            }
            if (type.getSort() == 10) {
                return Types.toClass(type, classLoader);
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        if (arg instanceof Handle) {
            return Types.toMethodHandle((Handle)arg, classLoader, caller);
        }
        return arg;
    }

    public static MethodType toMethodType(Type type, ClassLoader classLoader) {
        return MethodType.fromMethodDescriptorString(type.getInternalName(), classLoader);
    }

    private static Class<?> toClass(Type type, ClassLoader classLoader) throws ClassNotFoundException {
        return classLoader.loadClass(type.getInternalName().replace('/', '.'));
    }

    public static MethodHandle toMethodHandle(Handle handle, ClassLoader classLoader, MethodHandles.Lookup lookup) throws Exception {
        MethodType type = MethodType.fromMethodDescriptorString(handle.getDesc(), classLoader);
        Class<?> owner = classLoader.loadClass(handle.getOwner().replace('/', '.'));
        switch (handle.getTag()) {
            case 6: {
                return lookup.findStatic(owner, handle.getName(), type);
            }
            case 5: 
            case 9: {
                return lookup.findVirtual(owner, handle.getName(), type);
            }
            case 7: {
                return lookup.findSpecial(owner, handle.getName(), type, owner);
            }
            case 8: {
                return lookup.findConstructor(owner, type);
            }
        }
        throw new AssertionError((Object)("Unexpected handle type: " + handle));
    }

    public static String changeReturnType(Type returnType, String methodDescriptor) {
        Type[] argumentTypes = Type.getArgumentTypes(methodDescriptor);
        return Type.getMethodDescriptor(returnType, argumentTypes);
    }

    public static String prependArgumentType(Type argumentType, String methodDescriptor) {
        Type returnType = Type.getReturnType(methodDescriptor);
        Type[] argumentTypes = Type.getArgumentTypes(methodDescriptor);
        return Type.getMethodDescriptor(returnType, Types.conj(argumentType, argumentTypes));
    }

    private static Type[] conj(Type type, Type[] types) {
        Type[] result = new Type[types.length + 1];
        result[0] = type;
        System.arraycopy(types, 0, result, 1, types.length);
        return result;
    }
}

