/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.files;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.ext.ow2asm.EnhancedClassReader;

public class OutputDirectory {
    private final Path outputDir;

    public OutputDirectory(Path outputDir) {
        this.outputDir = outputDir;
    }

    public void writeClass(byte[] bytecode, boolean isJavacHacksEnabled) throws IOException {
        if (bytecode == null) {
            return;
        }
        ClassReader cr = EnhancedClassReader.create(bytecode, isJavacHacksEnabled);
        Path relativePath = this.outputDir.getFileSystem().getPath(cr.getClassName() + ".class", new String[0]);
        this.writeFile(relativePath, bytecode);
    }

    public void writeFile(Path relativePath, byte[] content) throws IOException {
        Path outputFile = this.outputDir.resolve(relativePath);
        Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        Files.write(outputFile, content, new OpenOption[0]);
    }
}

