<p align="center">
  <img src="https://cloud.githubusercontent.com/assets/499192/10754100/c0e1cc4c-7c95-11e5-9d3b-842d3acc2fd5.gif">
</p>

# Aerial - Apple TV Aerial Views Screen Saver

Aerial is a Mac screensaver based on the new Apple TV screensaver that displays the Aerial movies Apple shot over New York, San Francisco, Hawaii, China, etc. Starting with version 2.0.0, it also includes videos shared by Joshua Michaels & Hal Bergman!

Aerial is completely open source, so feel free to contribute to its development.

# For downloads and instructions, please go to our new website, hosted on GitHub Page: https://aerialscreensaver.github.io

> New to GitHub or Aerial? [Let us walk you through the installation!](https://github.com/JohnCoates/Aerial/blob/master/Documentation/FAQs.md#how-do-i-install-aerial) <br>
> Don't want automatic updates? [Download Aerial without Aerial Companion](https://github.com/JohnCoates/Aerial/releases) <br>
> Windows user? Try [OrangeJedi/Aerial](https://github.com/OrangeJedi/Aerial) <br>
> Linux user? Try [graysky2/xscreensaver-aerial](https://github.com/graysky2/xscreensaver-aerial/)

## About Aerial 

Aerial was started in 2015 by John Coates ([Twitter](https://twitter.com/JohnCoatesDev), [Email](mailto:john@johncoates.me))

Starting with version 1.4, Aerial is maintained by [Guillaume Louel](https://github.com/glouel) ([Twitter](https://twitter.com/C_Wiz)). If you are looking to support the development of Aerial, feel free to donate using the following button [![Support via PayPal][paypal-button]][paypal-glouel].

[paypal-button]: https://img.shields.io/badge/Donate-PayPal-green.svg
[paypal-glouel]: https://www.paypal.me/glouel/

![Github All Releases](https://img.shields.io/github/downloads/johncoates/aerial/total.svg?maxAge=86400)
![GitHub contributors](https://img.shields.io/github/contributors/johncoates/aerial.svg?maxAge=2592000)

**Trying Big Sur? Very bold of you!** Please *[read this to get your settings and videos back](https://github.com/JohnCoates/Aerial/issues/1036).*

## Have a question?

- Check our [Frequently Asked Questions](https://github.com/JohnCoates/Aerial/blob/master/Documentation/FAQs.md)
- Hop on our [Discord Server](https://discord.gg/TPuA5WG)
- Check out [additional documentation](https://github.com/JohnCoates/Aerial#more-documentation)

## Installation

With changes in Catalina and Big Sur, a screen saver can no longer update itself, so I've made a separate companion app that can update Aerial in the background or when you manually choose to update it. This is the preferred way to install and keep Aerial up to date!

**Installation instructions:**
- Download AerialInstaller.dmg [from here](https://github.com/glouel/AerialCompanion/releases/latest) 
- Open the .dmg and follow the instructions (for more information, [click here](https://github.com/JohnCoates/Aerial/blob/master/Documentation/FAQs.md#how-do-i-install-aerial)
- This will install both the companion app and the screen saver (or update you to the current version if you already have it installed)

Need more information on install, setup, or uninstall? Or want to install via homebrew or manually? Check our extended [instructions here](Documentation/Installation.md). 

## What's New in Aerial 2.0.0+ (Aug 19, 2020)?

- 20 new videos! Starting with version 2.0, Aerial includes new videos kindly shared by Joshua Michaels & Hal Bergman: 

<p align="center">
  <a href="https://vimeo.com/453430619">
  <img src="https://user-images.githubusercontent.com/37544189/90661757-d7d77b00-e247-11ea-8b92-7301c39bfced.jpg">
  </a>
</p>

If you enjoy those videos, please consider supporting them by checking the video packs they have [created especially for Aerial on their website](https://www.jetsoncreative.com/aerial). 

![newui](https://user-images.githubusercontent.com/37544189/90673393-f6de0900-e257-11ea-8e00-4357aca4214e.jpg)

- A whole new UI, that feels just right at home on macOS Big Sur. It still looks great on other macOS versions, don't worry! It includes large live previews of videos, and new easy ways to found the videos you like, and don't like! It's even resizable!

![Capture d’écran 2020-08-19 à 21 53 20](https://user-images.githubusercontent.com/37544189/90683362-b639bc00-e266-11ea-9edb-b97a656a8fc3.png)

- New cache options! You can *finally* set a cache size limit, so Aerial will not fill up your disk. Aerial can also periodically replace videos in your cache, say after a week, so things stay fresh. 

You can still opt to manually download your videos, or simply grab them all. All up to you. If you allow automatic downloads, you can even specify a list of trusted WiFi networks!

- A new "On rotation" feature, so you can quickly switch from watching space videos, to only sunset videos: 

![Capture d’écran 2020-08-19 à 22 12 03](https://user-images.githubusercontent.com/37544189/90685367-f8b0c800-e269-11ea-85f2-fcd27428aeb7.jpg)

- You can also favorite and hide videos now, based on your preferences. 

- There are many other new options, including vibrance control if you want to make your non HDR videos pop a bit more, sunset and sunrise video at appropriate time, and more!

You can find more about [version changes here](Documentation/ChangeLog.md).

## Compatibility

- Minimum OS X Mavericks (10.9) - Some features will not work below OS X Sierra (10.12)
- Aerial 2 is optimized for macOS Big Sur (macOS 11.x) and macOS Catalina (macOS 10.15)
- Aerial 2 has been tested and supports Apple Silicon

## Community

- **Found a bug?** Sorry about that! Make sure you are running the latest version and please check our [troubleshooting page](Documentation/Troubleshooting.md) and [our issues](https://github.com/JohnCoates/Aerial/issues), as someone may already have reported it (a beta may be available with the fix you need). Feel free to [open an issue](https://github.com/JohnCoates/Aerial/issues/new), try to be as specific as possible.
- **Have you fixed a bug?** Or want to implement a feature? Check instructions on how to compile Aerial and more on [contributing here](Documentation/Contribute.md).
- **Can you translate videos names and their descriptions?** Awesome! [Read here for details](Resources/Community/Readme.md) on how to help us.
- **Have a feature request?** [Open an issue](https://github.com/JohnCoates/Aerial/issues/new). Tell us why it would be useful, and why you and others would want it.
- **Curious about the videos and on a slow connection?** Check [this guide](https://paper.dropbox.com/doc/Aerial-macOS-screen-saver-list-with-version-1.4.6-HvOeL0gNhLpqpIFgmLHaS) by [Hidehiro Nagaoka](https://github.com/hidehiro98).
- **Just want to see the videos?** [A complete list of available wallpapers  is available online](https://aerial-screensavers.netlify.com). From [TawfiqH](https://github.com/Tawfiqh/aerialWallpapers).
- **Join our [Community Discord server](https://discord.gg/TPuA5WG)** for technical support, feature requests, and a fun time!

## Multilingual Support

Aerial features overlay descriptions of the main geographical features displayed in the videos.

![Community Strings example](https://user-images.githubusercontent.com/4295/52958947-75bd6180-3395-11e9-947f-3c77d9f41928.jpg)

Video descriptions are available in many languages (Spanish, French, Polish… [check the complete list here](Resources/Community/Readme.md)) and that is only possible thanks to the collaboration and interested work of many volunteers. To best serve the international community we've defined a translation workflow that allows any person, even with **no technical background** to help translate the descriptions.

If you want to collaborate, please [read the details here](Resources/Community/Readme.md).

## More Documentation

Looking for more information?

- [Frequently Asked Questions](https://github.com/JohnCoates/Aerial/blob/master/Documentation/FAQs.md)
- [Having an issue? Check our list of common issues right here, including workaround for common macOS bugs (like "You cannot use the Aerial screen saver with this version of macOS.")!](Documentation/Troubleshooting.md)
- [Learn more about configuring and running Aerial in offline mode with no network access](Documentation/OfflineMode.md)
- [Information about HEVC, HDR and hardware decoding](Documentation/HardwareDecoding.md) 
- [How to add your own videos to Aerial](Documentation/CustomVideos.md)
- [More details than you need on the auto-update mechanisms](Documentation/AutoUpdates.md)

## License

[MIT License](https://raw.githubusercontent.com/JohnCoates/Aerial/master/LICENSE)
