/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "gl" locale.
 */
public class LocalizedNamesImpl_gl extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ES",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AQ",
        "AR",
        "AZ",
        "CN",
        "AF",
        "GW",
        "IN",
        "AL",
        "DE",
        "DZ",
        "AD",
        "AO",
        "AI",
        "AG",
        "PF",
        "SA",
        "AM",
        "AW",
        "AU",
        "AT",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BO",
        "BA",
        "BW",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "BQ",
        "KZ",
        "EA",
        "TD",
        "CZ",
        "CL",
        "CY",
        "VA",
        "CO",
        "KM",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DJ",
        "DM",
        "EC",
        "ER",
        "SK",
        "SI",
        "ES",
        "EE",
        "ET",
        "EZ",
        "EG",
        "PH",
        "FI",
        "FJ",
        "FR",
        "GA",
        "GM",
        "GH",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GY",
        "GF",
        "GN",
        "GQ",
        "HT",
        "HN",
        "HK",
        "HU",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "HM",
        "NF",
        "AX",
        "BM",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "FK",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "GS",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IS",
        "IL",
        "IT",
        "JE",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "UN",
        "NA",
        "NR",
        "NP",
        "NI",
        "NU",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "BR",
        "CA",
        "YE",
        "LB",
        "OM",
        "PY",
        "PE",
        "GB",
        "EH",
        "SV",
        "AE",
        "US",
        "SD",
        "SS",
        "UY",
        "JP",
        "NL",
        "PW",
        "PA",
        "PG",
        "PK",
        "PL",
        "PR",
        "PT",
        "QA",
        "CF",
        "CD",
        "CG",
        "DO",
        "RE",
        "RO",
        "RW",
        "RU",
        "BL",
        "KN",
        "MF",
        "PM",
        "WS",
        "AS",
        "SM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SN",
        "RS",
        "SL",
        "SC",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SZ",
        "SE",
        "CH",
        "ZA",
        "SR",
        "SJ",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "QO",
        "TF",
        "PS",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "XA",
        "JM",
        "XB",
        "GE",
        "GI",
        "JO",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Mundo");
    namesMap.put("002", "África");
    namesMap.put("003", "Norteamérica");
    namesMap.put("005", "Suramérica");
    namesMap.put("009", "Oceanía");
    namesMap.put("011", "África Occidental");
    namesMap.put("013", "América Central");
    namesMap.put("014", "África Oriental");
    namesMap.put("015", "África Setentrional");
    namesMap.put("017", "África Central");
    namesMap.put("018", "África Meridional");
    namesMap.put("019", "América");
    namesMap.put("021", "América do Norte");
    namesMap.put("029", "Caribe");
    namesMap.put("030", "Asia Oriental");
    namesMap.put("034", "Asia Meridional");
    namesMap.put("035", "Sueste Asiático");
    namesMap.put("039", "Europa Meridional");
    namesMap.put("057", "Rexión da Micronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Central");
    namesMap.put("145", "Asia Occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa do Leste");
    namesMap.put("154", "Europa Setentrional");
    namesMap.put("155", "Europa Occidental");
    namesMap.put("202", "África subsahariana");
    namesMap.put("419", "América Latina");
    namesMap.put("AC", "Illa de Ascensión");
    namesMap.put("AE", "Os Emiratos Árabes Unidos");
    namesMap.put("AF", "Afganistán");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AQ", "A Antártida");
    namesMap.put("AR", "A Arxentina");
    namesMap.put("AS", "Samoa Americana");
    namesMap.put("AX", "Illas Åland");
    namesMap.put("AZ", "Acerbaixán");
    namesMap.put("BA", "Bosnia e Hercegovina");
    namesMap.put("BE", "Bélxica");
    namesMap.put("BJ", "Benín");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BM", "Illas Bermudas");
    namesMap.put("BQ", "Caribe Neerlandés");
    namesMap.put("BR", "O Brasil");
    namesMap.put("BT", "Bután");
    namesMap.put("BV", "Illa Bouvet");
    namesMap.put("BY", "Belarús");
    namesMap.put("CA", "O Canadá");
    namesMap.put("CC", "Illas Cocos (Keeling)");
    namesMap.put("CD", "República Democrática do Congo");
    namesMap.put("CF", "República Centroafricana");
    namesMap.put("CG", "República do Congo");
    namesMap.put("CH", "Suíza");
    namesMap.put("CI", "Costa do Marfil");
    namesMap.put("CK", "Illas Cook");
    namesMap.put("CM", "Camerún");
    namesMap.put("CN", "A China");
    namesMap.put("CP", "Illa Clipperton");
    namesMap.put("CV", "Cabo Verde");
    namesMap.put("CX", "Illa Christmas");
    namesMap.put("CY", "Chipre");
    namesMap.put("CZ", "Chequia");
    namesMap.put("DE", "Alemaña");
    namesMap.put("DG", "Diego García");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Dinamarca");
    namesMap.put("DO", "República Dominicana");
    namesMap.put("DZ", "Alxeria");
    namesMap.put("EA", "Ceuta e Melilla");
    namesMap.put("EG", "Exipto");
    namesMap.put("EH", "O Sáhara Occidental");
    namesMap.put("ES", "España");
    namesMap.put("ET", "Etiopía");
    namesMap.put("EU", "Unión Europea");
    namesMap.put("EZ", "Eurozona");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FJ", "Fixi");
    namesMap.put("FK", "Illas Malvinas");
    namesMap.put("FO", "Illas Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GA", "Gabón");
    namesMap.put("GB", "O Reino Unido");
    namesMap.put("GD", "Granada");
    namesMap.put("GE", "Xeorxia");
    namesMap.put("GF", "Güiana Francesa");
    namesMap.put("GI", "Xibraltar");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GP", "Guadalupe");
    namesMap.put("GQ", "Guinea Ecuatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("GS", "Illas Xeorxia do Sur e Sandwich do Sur");
    namesMap.put("GW", "A Guinea Bissau");
    namesMap.put("GY", "Güiana");
    namesMap.put("HK", "Hong Kong RAE da China");
    namesMap.put("HM", "Illa Heard e Illas McDonald");
    namesMap.put("HR", "Croacia");
    namesMap.put("HT", "Haití");
    namesMap.put("HU", "Hungría");
    namesMap.put("IC", "Illas Canarias");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Illa de Man");
    namesMap.put("IN", "A India");
    namesMap.put("IO", "Territorio Británico do Océano Índico");
    namesMap.put("IR", "Irán");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Xamaica");
    namesMap.put("JO", "Xordania");
    namesMap.put("JP", "O Xapón");
    namesMap.put("KG", "Kirguizistán");
    namesMap.put("KH", "Camboxa");
    namesMap.put("KM", "Comores");
    namesMap.put("KN", "Saint Kitts e Nevis");
    namesMap.put("KP", "Corea do Norte");
    namesMap.put("KR", "Corea do Sur");
    namesMap.put("KY", "Illas Caimán");
    namesMap.put("KZ", "Casaquistán");
    namesMap.put("LB", "O Líbano");
    namesMap.put("LC", "Santa Lucía");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburgo");
    namesMap.put("LV", "Letonia");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Marrocos");
    namesMap.put("MC", "Mónaco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MF", "Saint Martin");
    namesMap.put("MH", "Illas Marshall");
    namesMap.put("ML", "Malí");
    namesMap.put("MM", "Myanmar (Birmania)");
    namesMap.put("MO", "Macau RAE da China");
    namesMap.put("MP", "Illas Marianas do Norte");
    namesMap.put("MQ", "Martinica");
    namesMap.put("MU", "Mauricio");
    namesMap.put("MV", "Maldivas");
    namesMap.put("MX", "México");
    namesMap.put("MY", "Malaisia");
    namesMap.put("NC", "Nova Caledonia");
    namesMap.put("NE", "Níxer");
    namesMap.put("NF", "Illa Norfolk");
    namesMap.put("NG", "Nixeria");
    namesMap.put("NL", "Países Baixos");
    namesMap.put("NO", "Noruega");
    namesMap.put("NZ", "Nova Zelandia");
    namesMap.put("OM", "Omán");
    namesMap.put("PA", "Panamá");
    namesMap.put("PE", "O Perú");
    namesMap.put("PF", "A Polinesia Francesa");
    namesMap.put("PG", "Papúa-Nova Guinea");
    namesMap.put("PH", "Filipinas");
    namesMap.put("PK", "Paquistán");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "Saint Pierre et Miquelon");
    namesMap.put("PN", "Illas Pitcairn");
    namesMap.put("PR", "Porto Rico");
    namesMap.put("PS", "Territorios Palestinos");
    namesMap.put("PY", "O Paraguai");
    namesMap.put("QO", "Territorios afastados de Oceanía");
    namesMap.put("RE", "Reunión");
    namesMap.put("RO", "Romanía");
    namesMap.put("RU", "Rusia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Illas Salomón");
    namesMap.put("SD", "O Sudán");
    namesMap.put("SE", "Suecia");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Santa Helena");
    namesMap.put("SI", "Eslovenia");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Eslovaquia");
    namesMap.put("SL", "Serra Leoa");
    namesMap.put("SS", "O Sudán do Sur");
    namesMap.put("ST", "San Tomé e Príncipe");
    namesMap.put("SV", "O Salvador");
    namesMap.put("SY", "Siria");
    namesMap.put("SZ", "Suazilandia");
    namesMap.put("TA", "Tristán da Cunha");
    namesMap.put("TC", "Illas Turks e Caicos");
    namesMap.put("TF", "Territorios Austrais Franceses");
    namesMap.put("TH", "Tailandia");
    namesMap.put("TJ", "Taxiquistán");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turkmenistán");
    namesMap.put("TR", "Turquía");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("TW", "Taiwán");
    namesMap.put("UA", "Ucraína");
    namesMap.put("UM", "Illas Menores Distantes dos Estados Unidos");
    namesMap.put("UN", "Nacións Unidas");
    namesMap.put("US", "Os Estados Unidos");
    namesMap.put("UY", "O Uruguai");
    namesMap.put("UZ", "Uzbequistán");
    namesMap.put("VA", "Cidade do Vaticano");
    namesMap.put("VC", "San Vicente e As Granadinas");
    namesMap.put("VG", "Illas Virxes Británicas");
    namesMap.put("VI", "Illas Virxes Estadounidenses");
    namesMap.put("WF", "Wallis e Futuna");
    namesMap.put("YE", "O Iemen");
    namesMap.put("ZA", "Suráfrica");
    namesMap.put("ZZ", "Rexión descoñecida");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Mundo",
        "002": "África",
        "003": "Norteamérica",
        "005": "Suramérica",
        "009": "Oceanía",
        "011": "África Occidental",
        "013": "América Central",
        "014": "África Oriental",
        "015": "África Setentrional",
        "017": "África Central",
        "018": "África Meridional",
        "019": "América",
        "021": "América do Norte",
        "029": "Caribe",
        "030": "Asia Oriental",
        "034": "Asia Meridional",
        "035": "Sueste Asiático",
        "039": "Europa Meridional",
        "057": "Rexión da Micronesia",
        "061": "Polinesia",
        "143": "Asia Central",
        "145": "Asia Occidental",
        "150": "Europa",
        "151": "Europa do Leste",
        "154": "Europa Setentrional",
        "155": "Europa Occidental",
        "202": "África subsahariana",
        "419": "América Latina",
        "AC": "Illa de Ascensión",
        "AE": "Os Emiratos Árabes Unidos",
        "AF": "Afganistán",
        "AG": "Antigua e Barbuda",
        "AI": "Anguila",
        "AQ": "A Antártida",
        "AR": "A Arxentina",
        "AS": "Samoa Americana",
        "AX": "Illas Åland",
        "AZ": "Acerbaixán",
        "BA": "Bosnia e Hercegovina",
        "BE": "Bélxica",
        "BJ": "Benín",
        "BL": "Saint Barthélemy",
        "BM": "Illas Bermudas",
        "BQ": "Caribe Neerlandés",
        "BR": "O Brasil",
        "BT": "Bután",
        "BV": "Illa Bouvet",
        "BY": "Belarús",
        "CA": "O Canadá",
        "CC": "Illas Cocos (Keeling)",
        "CD": "República Democrática do Congo",
        "CF": "República Centroafricana",
        "CG": "República do Congo",
        "CH": "Suíza",
        "CI": "Costa do Marfil",
        "CK": "Illas Cook",
        "CM": "Camerún",
        "CN": "A China",
        "CP": "Illa Clipperton",
        "CV": "Cabo Verde",
        "CX": "Illa Christmas",
        "CY": "Chipre",
        "CZ": "Chequia",
        "DE": "Alemaña",
        "DG": "Diego García",
        "DJ": "Djibuti",
        "DK": "Dinamarca",
        "DO": "República Dominicana",
        "DZ": "Alxeria",
        "EA": "Ceuta e Melilla",
        "EG": "Exipto",
        "EH": "O Sáhara Occidental",
        "ES": "España",
        "ET": "Etiopía",
        "EU": "Unión Europea",
        "EZ": "Eurozona",
        "FI": "Finlandia",
        "FJ": "Fixi",
        "FK": "Illas Malvinas",
        "FO": "Illas Feroe",
        "FR": "Francia",
        "GA": "Gabón",
        "GB": "O Reino Unido",
        "GD": "Granada",
        "GE": "Xeorxia",
        "GF": "Güiana Francesa",
        "GI": "Xibraltar",
        "GL": "Groenlandia",
        "GP": "Guadalupe",
        "GQ": "Guinea Ecuatorial",
        "GR": "Grecia",
        "GS": "Illas Xeorxia do Sur e Sandwich do Sur",
        "GW": "A Guinea Bissau",
        "GY": "Güiana",
        "HK": "Hong Kong RAE da China",
        "HM": "Illa Heard e Illas McDonald",
        "HR": "Croacia",
        "HT": "Haití",
        "HU": "Hungría",
        "IC": "Illas Canarias",
        "IE": "Irlanda",
        "IM": "Illa de Man",
        "IN": "A India",
        "IO": "Territorio Británico do Océano Índico",
        "IR": "Irán",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Xamaica",
        "JO": "Xordania",
        "JP": "O Xapón",
        "KG": "Kirguizistán",
        "KH": "Camboxa",
        "KM": "Comores",
        "KN": "Saint Kitts e Nevis",
        "KP": "Corea do Norte",
        "KR": "Corea do Sur",
        "KY": "Illas Caimán",
        "KZ": "Casaquistán",
        "LB": "O Líbano",
        "LC": "Santa Lucía",
        "LT": "Lituania",
        "LU": "Luxemburgo",
        "LV": "Letonia",
        "LY": "Libia",
        "MA": "Marrocos",
        "MC": "Mónaco",
        "MD": "Moldavia",
        "MF": "Saint Martin",
        "MH": "Illas Marshall",
        "ML": "Malí",
        "MM": "Myanmar (Birmania)",
        "MO": "Macau RAE da China",
        "MP": "Illas Marianas do Norte",
        "MQ": "Martinica",
        "MU": "Mauricio",
        "MV": "Maldivas",
        "MX": "México",
        "MY": "Malaisia",
        "NC": "Nova Caledonia",
        "NE": "Níxer",
        "NF": "Illa Norfolk",
        "NG": "Nixeria",
        "NL": "Países Baixos",
        "NO": "Noruega",
        "NZ": "Nova Zelandia",
        "OM": "Omán",
        "PA": "Panamá",
        "PE": "O Perú",
        "PF": "A Polinesia Francesa",
        "PG": "Papúa-Nova Guinea",
        "PH": "Filipinas",
        "PK": "Paquistán",
        "PL": "Polonia",
        "PM": "Saint Pierre et Miquelon",
        "PN": "Illas Pitcairn",
        "PR": "Porto Rico",
        "PS": "Territorios Palestinos",
        "PY": "O Paraguai",
        "QO": "Territorios afastados de Oceanía",
        "RE": "Reunión",
        "RO": "Romanía",
        "RU": "Rusia",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Illas Salomón",
        "SD": "O Sudán",
        "SE": "Suecia",
        "SG": "Singapur",
        "SH": "Santa Helena",
        "SI": "Eslovenia",
        "SJ": "Svalbard e Jan Mayen",
        "SK": "Eslovaquia",
        "SL": "Serra Leoa",
        "SS": "O Sudán do Sur",
        "ST": "San Tomé e Príncipe",
        "SV": "O Salvador",
        "SY": "Siria",
        "SZ": "Suazilandia",
        "TA": "Tristán da Cunha",
        "TC": "Illas Turks e Caicos",
        "TF": "Territorios Austrais Franceses",
        "TH": "Tailandia",
        "TJ": "Taxiquistán",
        "TL": "Timor Leste",
        "TM": "Turkmenistán",
        "TR": "Turquía",
        "TT": "Trinidad e Tobago",
        "TW": "Taiwán",
        "UA": "Ucraína",
        "UM": "Illas Menores Distantes dos Estados Unidos",
        "UN": "Nacións Unidas",
        "US": "Os Estados Unidos",
        "UY": "O Uruguai",
        "UZ": "Uzbequistán",
        "VA": "Cidade do Vaticano",
        "VC": "San Vicente e As Granadinas",
        "VG": "Illas Virxes Británicas",
        "VI": "Illas Virxes Estadounidenses",
        "WF": "Wallis e Futuna",
        "YE": "O Iemen",
        "ZA": "Suráfrica",
        "ZZ": "Rexión descoñecida"
    };
  }-*/;
}
