# إرشادات التنسيق

تستعرض هذه الصفحة إرشادات التنسيق لصفحات `tldr` الخاصة باللغة العربية.

## التنسيق العام

يجب أن يتبع الشكل الأساسي لكل صفحة القالب التالي وألا يتجاوز 8 أمثلة للأمر الواحد:

```md
# اسم الأمر

> وصف مختصر وواضح للأمر.
> يفضل أن يكون في سطر واحد؛ سطرين مقبولين إذا لزم الأمر.
> لمزيد من التفاصيل: <https://example.com/command_name/help/page>.

- وصف الكود:

`command_name options`

- وصف الكود:

`command_name options`

...
```

مثال:

```md
# krita

> برنامج للرسم والتلوين مصمم للفنانين الرقميين.
> انظر أيضًا: `gimp`.
> مزيد من التفاصيل: <https://docs.krita.org/en/reference_manual/linux_command_line.html>.

- بدء Krita:

`krita`

- فتح ملفات محددة:

`krita {{path/to/image1 path/to/image2 ...}}`

- بدء بدون شاشة بداية:

`krita --nosplash`

- بدء مع مساحة عمل معينة:

`krita --workspace {{Animation}}`

- بدء في وضع ملء الشاشة:

`krita --fullscreen`
```

> [!NOTE]
> يجب أن يتطابق اسم ملف الصفحة والعنوان مع اسم الأمر تمامًا. يمكن أن يكون عنوان الصفحة بأي حالة حروف، بينما يجب أن تكون أسماء ملفات Markdown الخاصة بالصفحات بحروف صغيرة.

هناك أداة "linter" تفرض هذا التنسيق.
يتم تشغيلها تلقائيًا مع كل "Pull Request"،
ولكن يمكنك تثبيتها لاختبار مساهماتك محليًا قبل تقديمها:

```sh
npm install --global tldr-lint
tldr-lint path/to/tldr_page.md
```

لطرق أخرى لاستخدام `tldr-lint`، مثل فحص مجلد كامل، يمكنك الاطلاع على
[صفحة `tldr-lint` على `tldr`](https://github.com/tldr-pages/tldr/blob/main/pages/common/tldr-lint.md). بدلاً من ذلك، يمكنك أيضًا استخدام اختصارها `tldrl`.

اعتمادًا على عميلك، قد تتمكن من معاينة الصفحة محليًا باستخدام خيار `--render`:

```sh
tldr --render path/to/tldr_page.md
```

### القواعد الخاصة بـ PowerShell

عند توثيق أوامر PowerShell، يرجى ملاحظة قواعد التسمية التالية.

- يجب أن يكون اسم الملف مكتوبًا بحروف صغيرة، مثل `invoke-webrequest.md` بدلاً من `Invoke-WebRequest.md`.
- يجب أن يكون عنوان/رأس الصفحة مكتوبًا كما هو (بما يتطابق مع التهجئة التي يقصدها مايكروسوفت أو مؤلف الأمر PowerShell)، مثل `Invoke-WebRequest` بدلاً من `invoke-webrequest`.
- يجب أيضًا كتابة اسم الأمر والخيارات في الأمثلة كما هي، مثل `Command-Name {{input}} -CommandParameter {{value}}` بدلاً من `command-name {{input}} -commandparameter {{value}}`.

نظرًا للاختلافات في التوافق بين الإصدارات [وإزالة الأوامر الخاصة بـ Windows](https://learn.microsoft.com/powershell/scripting/whats-new/differences-from-windows-powershell) في PowerShell 6.x، تأكد من أن
الأمر يعمل بين **PowerShell 5.1** (المعروف أيضًا باسم "PowerShell Windows القديم" كما هو مثبت في Windows 10 و11) و **أحدث إصدار من PowerShell متعدد المنصات** (المعروف سابقًا باسم PowerShell Core).

لذا، إذا كان الأمر أو خياراته غير متوفرة أو تحتوي على سلوكيات مختلفة بين كل إصدار، يرجى ملاحظة ذلك بلطف في الوصف. على سبيل المثال:

```md
# Clear-RecycleBin

> حذف العناصر من سلة المهملات.
> ملاحظة: يمكن استخدام هذا الأمر فقط من خلال إصدارات PowerShell 5.1 وما دون، أو 7.1 وما فوق.
> المزيد من التفاصيل: <https://learn.microsoft.com/powershell/module/microsoft.powershell.management/clear-recyclebin>.
```

## الصفحات

### اختلافات المنصات

إذا كنت قلقًا من أن الأوامر قد تختلف بين المنصات أو أنظمة التشغيل (مثل Windows مقابل macOS)،
فإن معظم [عملاء صفحات tldr](https://github.com/tldr-pages/tldr/wiki/Clients) سيختارون النسخة الأنسب من الأمر لعرضها للمستخدم النهائي.

في هذه الحالة، سيتم عرض معلومات النسخة الخاصة بـ Windows من أمر `cd` (المخزنة في `pages.ar/windows/cd.md`) بشكل افتراضي لمستخدمي Windows،
وسيتم عرض النسخة العامة/المشتركة (المخزنة في `pages.ar/common/cd.md`) للمستخدمين على أنظمة Linux وmacOS ومنصات أخرى.

### الألقاب

إذا كان يمكن استدعاء أمر ما باستخدام أسماء بديلة (مثلًا، يمكن استدعاء `vim` باستخدام `vi`)، يمكن إنشاء صفحات ألقاب للإشارة إلى اسم الأمر الأصلي للمستخدم.

```md
# command_name

> هذا الأمر هو لقب لـ `اسم-الأمر-الأصلي`.

- عرض التوثيقات للأمر الأصلي:

`tldr original_command_name`
```

مثال:

```md
# vi

> هذا الأمر هو لقب لـ `vim`.

- عرض التوثيقات للأمر الأصلي:

`tldr vim`
```

- يمكن العثور على قوالب صفحات الألقاب المترجمة مسبقًا [هنا](https://github.com/tldr-pages/tldr/blob/main/contributing-guides/translation-templates/alias-pages.md).

#### الألقاب الخاصة بـ PowerShell

قد تقدم بعض أوامر PowerShell ألقابًا تقع في واحدة من هذه الفئات الثلاث:

1. **استبدال أمر موجود في موجه أوامر Windows (`cmd`)**، مثل استبدال `cd` بـ `Set-Location` مع خيارات أوامر مختلفة. في هذه الحالة، أضف ملاحظة اللقب التالية في السطر الثاني من وصف أمر tldr للأمر الأصلي في موجه الأوامر، على سبيل المثال:

```md
# cd

> عرض الدليل الحالي أو الانتقال إلى دليل آخر.
> في PowerShell، هذا الأمر هو لقب لـ `Set-Location`. هذه الوثائق تستند إلى النسخة الخاصة بـ Command Prompt (`cmd`) من `cd`.
> مزيد من التفاصيل: <https://learn.microsoft.com/windows-server/administration/windows-commands/cd>.

- عرض التوثيقات الخاصة بالأمر المقابل في PowerShell:

`tldr set-location`
```

> [!NOTE]
> مثال "عرض التوثيقات للأمر المعادل في PowerShell" اختياري ويجب استبعاده إذا كانت الصفحة تحتوي بالفعل على الحد الأقصى من الأمثلة (8).

2. **يوفر لقبًا جديدًا يمكن تنفيذه فقط في PowerShell**، مثل `ni` لـ `New-Item`. في هذه الحالة، استخدم [قالب اللقب القياسي](https://github.com/tldr-pages/tldr/blob/main/contributing-guides/translation-templates/alias-pages.md)، ولكن أضف كلمة "في PowerShell" (أو ما يعادلها) للإشارة إلى أن الأمر حصري لـ PowerShell. على سبيل المثال:

```md
# ni

> في PowerShell، هذا الأمر هو لقب لـ `New-Item`.
> مزيد من التفاصيل: <https://learn.microsoft.com/powershell/module/microsoft.powershell.management/new-item>.

- عرض التوثيقات للأمر الأصلي:

`tldr new-item`
```

3. **يوفر لقبًا جديدًا يتعارض مع برامج أخرى، وأشهر مثال هو تضمين** curl و wget كألقاب لـ Invoke-WebRequest (مع مجموعة غير متوافقة من خيارات الأوامر).
   لاحظ أن الألقاب الخاصة بـ PowerShell التي تقع في هذه الفئة غالبًا ما تكون حصرية لـ Windows.

في هذه الحالة، قدم ملاحظة وطريقة لتحديد ما إذا كان الأمر يشير حاليًا إلى أمر PowerShell (من خلال اللقب) أو إلى أمر آخر. على سبيل المثال:

```md
# curl

> في PowerShell، قد يكون هذا الأمر هو لقب لـ `Invoke-WebRequest` عندما لا يكون البرنامج الأصلي `curl` (<https://curl.se>) مثبتًا بشكل صحيح.
> لمزيد من التفاصيل: <https://learn.microsoft.com/powershell/module/microsoft.powershell.utility/invoke-webrequest>.

- تحقق مما إذا كان `curl` مثبتًا بشكل صحيح عن طريق طباعة رقم الإصدار الخاص به. إذا أظهرت هذه الأوامر خطأ، قد تكون PowerShell قد استبدلت هذا الأمر بـ `Invoke-WebRequest`:

`curl --version`

- عرض التوثيقات الخاصة بأمر `curl` الأصلي:

`tldr curl -p common`

- عرض التوثيقات الخاصة بأمر `Invoke-WebRequest` في PowerShell:

`tldr invoke-webrequest`
```

## الكتابة العامة

### التأكيد

لا تستخدم _الخط المائل_ (Italic) أو **الخط العريض** (Bold) أو أي تنسيق نصي آخر في الصفحات. هذه محجوزة لتأكيد العميل على العناصر القابلة للتغيير.

### صيغة الأمر

- **يجب أن تكون جميع الأوصاف مكتوبة بصيغة الأمر.**

عند كتابة الأوصاف لأمثلة الأوامر، تحقق من أي أخطاء نحوية. يُفضل استخدام "اذهب إلى المجلد المحدد" بدلاً من:

- `سيذهب هذا الأمر إلى المجلد المحدد`
- `لنذهب إلى المجلد المحدد!`

### الحالات الخاصة

- إذا كان الأمر يقوم بإجراء تغييرات لا رجعة فيها على نظام الملفات أو الأجهزة،  
  فاكتب كل مثال بطريقة لا يمكن نسخها ولصقها بشكل متهور.  
  على سبيل المثال، بدلاً من `ddrescue --force --no-scrape /dev/sda /dev/sdb`  
  اكتب `ddrescue --force --no-scrape {{/dev/sdX}} {{/dev/sdY}}`  
  واستخدم القالب `{{/dev/sdXY}}` لأجهزة الكتل بدلاً من `/dev/sda1`.

بشكل عام، يجب أن تجعل القوالب من السهل فهم كيفية استخدام الأمر وملء القيم.

> [!NOTE]
> لا تترجم الplaceholders مثل `{{path/to/file}}` إلى `{{المسار/إلى/الملف}}` لتجنب الإلتباس

يجب استخدام صياغة تقنية على خطوط الوصف باستخدام تنسيق `backtick`.  
استخدم الخطوط المائلة الخلفية `backticks` مع التالي:

- المسارات، مثل `package.json`، `/etc/package.json`.
- الامتدادات، مثل `.dll`.
- الأوامر، مثل `ls`.
- التدفقات القياسية: `stdout`، `stdin`، `stderr`.  
  **لا تستخدم** الأسماء الكاملة (مثل: standard output).
- خوارزميات الضغط، مثل `zip`، `7z`، `xz`.

### الفاصلة التسلسلية

- عند الإعلان عن قائمة تحتوي على 3 عناصر أو أكثر،  
  استخدم [الفاصلة التسلسلية](https://en.wikipedia.org/wiki/Serial_comma)،  
  والمعروفة أيضًا باسم فاصلة أكسفورد،  
  حيث أن حذفها يمكن أن يؤدي إلى التباس.

> حذف فروع Git، tags، و remotes.

المثال أعلاه لا يستخدم فاصلة تسلسلية، لذا قد يعني أحد الأمرين التاليين:

- حذف فروع Git المسماة `tags` و`remotes`.
- حذف جميع الفروع، tags، وremotes الخاصة بـGit.

يمكن حل هذا الالتباس بإضافة فاصلة قبل كلمة "و" أو "أو" في العنصر الأخير من القائمة.

> حذف فروع Git وtags وremotes.

> [!NOTE]  
> يمكن كتابة أسماء العلامات التجارية والمشاريع بحروف كبيرة في الوصف عند الاقتضاء  
> (على سبيل المثال، استخدم `أداة للتعامل مع مستودع Git` بدلاً من `أداة للتفاعل مع مستودع git`).

## أوامر للمثال

### صيغة الخيارات

- من أجل سهولة الاستخدام، افضل **خيارات GNU الطويلة** (مثل `--help` بدلاً من `-h`). تأكد من أن الخيارات متوافقة عبر المنصات (مصممة لتعمل بنفس الطريقة عبر منصات متعددة) للصفحات في دليل `common`.
- إذا كان الأمر يدعم فقط الخيارات القصيرة أو كان الخيار القصير يختلف بشكل كبير عن الخيار الطويل، حاول توثيق ما يرمز إليه الحرف باستخدام [مساعد ذاكري](#short-option-mnemonics).
- للسماح للعميل بتحديد ما إذا كان سيظهر الخيارات الطويلة أو القصيرة في الأوامر، استخدم عنصر نائب للخيار مثل `{{[-o|--output]}}`.
- افضل تجميع خيارات العلم معًا عندما يدعم البرنامج ذلك (مثل `{{[-it|--interactive --tty]}}` بدلاً من `{{[-i|--interactive]}} {{[-t|--tty]}}`).
- افضل عدم تجميع الخيارات التي تأخذ وسائط (مثل `{{[-it|--interactive --tty]}} {{[-w|--workdir]}} {{path/to/directory}}` بدلاً من `{{[-itw|--interactive --tty --workdir]}} {{path/to/directory}}`).
- افضل استخدام مسافة بدلاً من علامة التساوي (`=`) لفصل الخيارات عن وسائطها (مثل استخدام `--opt arg` بدلاً من `--opt=arg`)، ما لم يكن البرنامج لا يدعم ذلك.
- كذلك افضل فصل الخيارات القصيرة عن وسائطها بمسافة (مثل استخدام `-o arg` بدلاً من `-oarg`)، ما لم يكن البرنامج لا يدعم ذلك.

### صيغة العناصر النائبة

يجب أن تستخدم القيم التي يوفرها المستخدم تركيب `{{عنصر نائب}}`
للسماح لعملاء `tldr` بإبرازها.

> [!TIP]
> يُقترح وضع العناصر النائبة التي تقبل السلاسل كمدخلات ضمن علامات اقتباس. أي استخدم `"{{عنصر نائب}}"` بدلاً من `{{"عنصر نائب"}}`.

ضع الإرشادات التالية في الاعتبار عند اختيار العناصر النائبة:

#### التسمية

- استخدم عناصر نائبة قصيرة لكن وصفية،
  مثل `{{path/to/source_file}}` أو `{{path/to/wallet.txt}}`.
- استخدم [`snake_case`](https://wikipedia.org/wiki/snake_case) للعناصر النائبة متعددة الكلمات.

#### المسارات

- استخدم `{{filename}}` عندما يكون متوقعًا اسم الملف فقط.
- لأي إشارة إلى مسارات الملفات أو الدلائل،
  استخدم الصيغة `{{path/to/عنصر نائب}}`،
  إلا عندما يكون الموقع ضمنيًا.
- عندما لا يمكن أن يكون المسار نسبيًا
  ويجب أن يبدأ من جذر نظام الملفات،
  ضع شرطة مائلة في البداية،
  مثل `get {{/path/to/remote_file}}`.
- في حالة الإشارة المحتملة إلى ملف أو دليل،
  استخدم `{{path/to/file_or_directory}}`.

> [!NOTE]\
> إذا كان الأمر خاصًا بـ Windows، استخدم الشرطات المائلة للخلف (`\`) بدلاً من ذلك، مثل `{{path\to\file_or_directory}}`. حروف الأقراص مثل `C:` اختيارية ما لم يتطلب إدخال الأمر مسارًا مطلقًا
> أو نطاقًا محددًا لحروف الأقراص، مثل `cd /d {{C}}:{{path\to\directory}}`.

#### الامتدادات

- إذا كان متوقعًا امتداد معين للملف، أضفه.
  على سبيل المثال، `unrar x {{path/to/compressed.rar}}`.
- في حالة الحاجة إلى امتداد عام، استخدم `{{.ext}}`، ولكن **فقط** إذا كان الامتداد مطلوبًا.
  على سبيل المثال، في مثال `find.md` "البحث عن الملفات حسب الامتداد" (`find {{path/to/root}} -name '{{*.ext}}'`)
  استخدام `{{*.ext}}` يشرح الأمر دون أن يكون محددًا بشكل غير ضروري؛
  بينما في `wc -l {{path/to/file}}` استخدام `{{path/to/file}}` (بدون امتداد) كافٍ.

#### تجميع العناصر النائبة

- إذا كان بإمكان الأمر أن يأخذ اختياريًا واحدًا أو أكثر من الوسائط من نفس النوع، استخدم النقاط الثلاث: `{{عنصر نائب1 عنصر نائب2 ...}}`.
  على سبيل المثال، إذا كان متوقعًا مسارات متعددة، استخدم `{{path/to/directory1 path/to/directory2 ...}}`.
- إذا كان خيار واحد فقط من بين خيارات متعددة ممكنًا، اكتبه كـ: `{{عنصر نائب1|عنصر نائب2|عنصر نائب3}}`. إذا كان هناك أكثر من 4 قيم محتملة، يمكنك استخدام `|...` بعد العنصر الأخير.
- استخدم نقطتين لتعليم نطاق من القيم المحتملة، على سبيل المثال `{{1..5}}` أو `{{a..z}}`.

#### العناصر النائبة الاختيارية

عند توثيق العناصر النائبة الاختيارية مثل المسارات أو امتدادات الملفات، يُقترح تحديدها في وصف الصفحة أو الأمثلة بدلاً من العنصر النائب نفسه. على سبيل المثال:

- استخدم `{{path/to/source.ext}}` بدلاً من `{{path/to/source.tar[.gz|.bz2|.xz]}}`.

### ضغطات المفاتيح

لتعليم ضغطات المفاتيح لبرامج TUI أو GUI، استخدم الأقواس الزاوية `<` و `>`.

- مثال على حرف واحد: `<a>`.
- المفاتيح الخاصة يجب كتابتها باستخدام [`PascalCase`](https://www.theserverside.com/definition/Pascal-case): `<Ctrl>`, `<Super>`, `<Alt>`, `<Shift>`, `<Cmd>`, `<Option>`, `<Windows>`, `<Enter>`, `<Home>`, `<Space>`, `<Esc>`, `<ArrowUp>`, `<ArrowLeft>`, `<ArrowKeys>`, `<PageUp>`, `<F5>`, `<F12>`, `<LeftClick>`, `<MiddleClick>`, ...
- المفاتيح الخاصة يمكن ترجمتها إذا كانت لها ترجمات ذات صلة ثقافية.
- عندما يأخذ البرنامج حروفًا كبيرة بشكل حرفي، قم بتعليمها كـ `<A>` بدلاً من تعليمها باستخدام Shift. بخلاف ذلك، قم دائمًا بتعليم الحروف بحروف صغيرة.
- قم بتعليم ضغطات المفاتيح المتزامنة داخل نفس الأقواس الزاوية مفصولة بمسافة واحدة: `<Ctrl c>`, `<Alt F4>`, `<Ctrl Shift k>`, `<Super Shift PrtSc>`.
- عند كتابة ضغطات المفاتيح المتزامنة، حافظ على الترتيب التالي: `<Ctrl Super Windows Alt AltGr Shift كل_شيء_آخر>`.
- ضغطات المفاتيح المتتالية يجب أن تُحصر في أقواس زاوية خاصة بها دون مسافة بينهما: `<Esc><u>`, `<Ctrl k><Ctrl s>`, `<Enter><~><.>`, `<d><o>`.
- المفاتيح التي يتم كتابتها في موجه لا تحتاج إلى تعليمها كضغطات مفاتيح: `<:>help<Enter>`. لاحظ أن مفتاح تبديل السياق معلم في أقواس زاوية على الرغم من طباعته في الموجه.

### أوامر المساعدة والإصدار

- عادةً ما نضع، **بهذا الترتيب**، أوامر المساعدة والإصدار كـ **آخر مثالين** في الصفحة لإبراز الأوامر العملية أكثر في بداية الصفحة. يمكن استبدالها لاستيعاب أمثلة مفيدة أخرى إذا لزم الأمر.
- للحفاظ على التناسق، نفضل الصياغة العامة `عرض المساعدة` و `عرض الإصدار` لهذه الأوامر.
- يُقترح توثيق أمثلة المساعدة والإصدار إذا كان الأمر يتبع علامات غير تقليدية في منصات مثل Windows.

## قواعد اللغة والترجمة

القسم أدناه يحتوي على قواعد إضافية خاصة باللغة والترجمة:

### عام

لا تترجم `example.com`. النطاق محجوز من قبل IANA لأغراض التوثيق ولن يتم تأجيره لأي شخص. ترجمة اسم الموقع قد تعرض المستخدمين غير المتأنين للخطر.

### قواعد خاصة باللغة الإنجليزية

يجب استخدام الواصلة العادية (`-`) في الأماكن التي قد توصي فيها أدلة الأسلوب المختلفة باستخدام الشرطة المتوسطة (`–`) أو الشرطة الطويلة (`—`).

- على سبيل المثال، استخدم `for lengths 3-12` بدلاً من `for lengths 3–12`

السبب في ذلك رباعي:

1. لا يوجد معيار مقبول على نطاق واسع بين أدلة الأسلوب المختلفة حول متى يجب استخدام كل من هذه الشرطات.
2. الواصلة (`-`) هي الشخصية الشبيهة بالشرطة الوحيدة في ASCII، مما يقلل من احتمالية مشكلات التوافق.
3. الواصلة (`-`) هي الأسهل في الكتابة بفارق كبير.
4. العديد من المتحدثين بالإنجليزية، وخاصة غير الناطقين بها كلغة أم، لا يدركون الفرق.

## قواعد اللغة والترجمة

القسم أدناه يحتوي على قواعد إضافية خاصة باللغة والترجمة:

### عام

لا تترجم `example.com`. النطاق محجوز من قبل IANA لأغراض التوثيق ولن يتم تأجيره لأي شخص. ترجمة اسم الموقع قد تعرض المستخدمين غير المتأنين للخطر.
