// -*- mode: c++; indent-tabs-mode: nil -*-
//! @file XmlRpcConnection.qm XML-RPC client connection module implementation

/*  XmlRpcConnections.qm Copyright 2013 - 2022 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version

// require type definitions everywhere

// enable all warnings


//%requires Util >= 1.0



/** @mainpage XmlRpcConnection Module

    @tableofcontents

    @section xmlrpcconnectionintro Introduction to the XmlRpcConnection Module

    The %XmlRpcConnection module provides an XML-RPC client connection definition
    for the @ref connectionproviderintro "ConnectionProvider"
    module in %Qore.

    To use this module, use \c "%requires XmlRpcConnection" in your code.

    This module automatically uses the <a href="../../xml/html/index.html">xml</a> binary module.

    All the public symbols in the module are defined in the XmlRpcConnection namespace.

    Currently the module provides the following classes:
    - @ref XmlRpcConnection::XmlRpcConnection "XmlRpcConnection"

    @section xmlrpcconnection_relnotes XmlRpcConnection Module Release History

    @subsection xmlrpcconnection_v1_4 XmlRpcConnection v1.4
    - implemented support for a data provider scheme cache and rich option information for connections
      (<a href="https://github.com/qorelanguage/qore/issues/4025">issue 4025</a>)

    @subsection xmlrpcconnection_v1_3 XmlRpcConnection v1.3
    - removed the obsolete \c XmlRpcConnection::getConstructorInfo() method as connection serialization is a
      much more elegant and maintainable solution
      (<a href="https://github.com/qorelanguage/qore/issues/3696">issue 3696</a>)

    @subsection xmlrpcconnection_v1_2 XmlRpcConnection v1.2
    - new AbstractConnection infrastructure

    @subsection xmlrpcconnection_v1_1 XmlRpcConnection v1.1
    - the @ref XmlRpcConnection::XmlRpcConnection::getConstructorInfo() "XmlRpcConnection::getConstructorInfo()"
      method was added to allow connections to be created dynamically, potentially in another process from a network
      call (<a href="https://github.com/qorelanguage/qore/issues/2628">issue 2628</a>)

    @subsection xmlrpcconnection_v1_0_1 XmlRpcConnection v1.0.1
    - fixed a bug handling default options including timeouts in @ref XmlRpcConnection::XmlRpcConnection "XmlRpcConnection"
      (<a href="https://github.com/qorelanguage/qore/issues/3321">issue 3321</a>)

    @subsection xmlrpcconnection_v1_0 XmlRpcConnection v1.0
    - the initial version of the XmlRpcConnection module
*/

//! the XmlRpcConnection namespace contains all the definitions in the XmlRpcConnection module
namespace XmlRpcConnection {
//! class for XML-RPC connections; returns @ref Qore::Xml::XmlRpcClient objects
/** supports the following options:
    - \c "http_version": HTTP version to use (\c "1.0" or \c "1.1", defaults to \c "1.1")
    - \c "max_redirects": maximum redirects to support
    - \c "proxy": proxy URL to use
    - \c "timeout": transfer timeout to use in milliseconds
    - \c "connect_timeout": connection timeout to use in milliseconds

    @see @ref Qore::Xml::XmlRpcClient::constructor() "XmlRpcClient::constructor()" for more information on the above options
*/
class XmlRpcConnection : public ConnectionProvider::HttpBasedConnection {

public:
        hash<auto> real_opts;

        //! Connection entry info
        const ConnectionScheme = ...;


    //! creates the XmlRpcConnection object
    /** @param name the name of the connection
        @param description connection description
        @param url connection URL (potentially with password info)
        @param attributes various attributes. See below
        @param options connection options

        See @ref AbstractConnection::constructor() for \c attributes and \c options reference.
    */
    constructor(string name, string description, string url, hash<auto> attributes = {}, hash<auto> options = {})
 ;


    //! Creates the object from the arguments
    /** @param config with the following keys:
        - name (required string): the connection name
        - display_name (optional string): the display name
        - short_desc (optional string): a short description in plain text
        - desc (optional string): a long description with markdown formatting
        - url (required string): the connection URL
        - opts (optional hash): connection options
        - logger (optional LoggerInterface object): logger for the connection
        @param attr optional connection attributes
        - monitor (optional bool): should the connection be monitored? Default: True
        - enabled (optional bool): is the connection enabled? Default: True
        - locked (optional bool): is the connection locked? Default: False
        - debug_data (optional bool): debug data? Default: False
        - tags (optional hash): tags for the connection; no default value

        @throw CONNECTION-OPTION-ERROR missing or invalid connection option or attribute
    */
    constructor(hash<auto> config, __7_ hash<auto> attr) ;


    //! returns \c "xmlrpc"
    string getType();


    //! returns a @ref Qore::Xml::XmlRpcClient object
    /** @param connect if @ref Qore::True "True", then the connection is returned already connected
        @param rtopts this connection type does not accept any runtime options, so this parameter is ignored

        @return a @ref Qore::Xml::XmlRpcClient object
    */
protected:
     Qore::Xml::XmlRpcClient getImpl(bool connect = True, __7_ hash<auto> rtopts);
public:


    //! Returns the ConnectionSchemeInfo hash for this object
protected:
     hash<ConnectionSchemeInfo> getConnectionSchemeInfoImpl();
public:

};
};
