'use strict';

/**
 * Often used conditions.
 *
 * @module conditions
 */

/**
 * @template T
 * @param {T|null|undefined} v
 * @return {T|null}
 */
/* c8 ignore next */
const undefinedToNull = v => v === undefined ? null : v;

var conditions = /*#__PURE__*/Object.freeze({
	__proto__: null,
	undefinedToNull: undefinedToNull
});

exports.conditions = conditions;
exports.undefinedToNull = undefinedToNull;
//# sourceMappingURL=conditions-f5c0c102.cjs.map
