// _gen/display/pretty.asdl.cc is generated by asdl_main.py

#include "_gen/display/pretty.asdl.h"
#include <assert.h>
#include "prebuilt/asdl/runtime.mycpp.h"  // generated code uses wrappers here

// Generated code uses these types
using hnode_asdl::hnode;
using hnode_asdl::Field;
using hnode_asdl::color_e;


namespace pretty_asdl {


hnode_t* MeasuredDoc::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("MeasuredDoc"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->doc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("doc"), x0));

  hnode_t* x1 = this->measure->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("measure"), x1));

  return out_node;
}


hnode_t* Measure::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("Measure"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->flat);
  L->append(Alloc<Field>(StrFromC("flat"), x0));

  hnode_t* x1 = ToPretty(this->nonflat);
  L->append(Alloc<Field>(StrFromC("nonflat"), x1));

  return out_node;
}


hnode_t* List_Measured::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Array* out_node = Alloc<hnode::Array>(Alloc<List<hnode_t*>>());
  for (ListIter<MeasuredDoc*> it(this); !it.Done(); it.Next()) {
    MeasuredDoc* v_ = it.Value();
    hnode_t* h = (v_ == nullptr) ? Alloc<hnode::Leaf>(StrFromC("_"),
                  color_e::OtherConst) : v_->PrettyTree(do_abbrev, seen);
    out_node->children->append(h);
  }
  return out_node;
}

BigStr* doc_str(int tag, bool dot) {
  char buf[32];
  const char* v = nullptr;
  switch (tag) {
  case doc_e::Break:
    v = "Break"; break;
  case doc_e::Text:
    v = "Text"; break;
  case doc_e::Indent:
    v = "Indent"; break;
  case doc_e::Group:
    v = "Group"; break;
  case doc_e::Flat:
    v = "Flat"; break;
  case doc_e::IfFlat:
    v = "IfFlat"; break;
  case doc_e::Concat:
    v = "Concat"; break;
  default:
    assert(0);
  }
  if (dot) {
    snprintf(buf, 32, "doc.%s", v);
    return StrFromC(buf);
  } else {
    return StrFromC(v);
  }
}

hnode_t* doc__Break::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(doc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->string);
  L->append(Alloc<Field>(StrFromC("string"), x0));

  return out_node;
}


hnode_t* doc__Text::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(doc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->string);
  L->append(Alloc<Field>(StrFromC("string"), x0));

  return out_node;
}


hnode_t* doc__Indent::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(doc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = ToPretty(this->indent);
  L->append(Alloc<Field>(StrFromC("indent"), x0));

  hnode_t* x1 = this->mdoc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("mdoc"), x1));

  return out_node;
}


hnode_t* doc__Flat::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(doc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->mdoc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("mdoc"), x0));

  return out_node;
}


hnode_t* doc__IfFlat::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(doc_str(this->tag()));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->flat_mdoc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("flat_mdoc"), x0));

  hnode_t* x1 = this->nonflat_mdoc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("nonflat_mdoc"), x1));

  return out_node;
}


hnode_t* doc_t::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  switch (this->tag()) {
  case doc_e::Break: {
    doc__Break* obj = static_cast<doc__Break*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::Text: {
    doc__Text* obj = static_cast<doc__Text*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::Indent: {
    doc__Indent* obj = static_cast<doc__Indent*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::Group: {
    MeasuredDoc* obj = static_cast<MeasuredDoc*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::Flat: {
    doc__Flat* obj = static_cast<doc__Flat*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::IfFlat: {
    doc__IfFlat* obj = static_cast<doc__IfFlat*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  case doc_e::Concat: {
    List_Measured* obj = static_cast<List_Measured*>(this);
    return obj->PrettyTree(do_abbrev, seen);
  }
  default:
    assert(0);
  }
}

hnode_t* DocFragment::PrettyTree(bool do_abbrev, Dict<int, bool>* seen) {
  seen = seen ? seen : Alloc<Dict<int, bool>>();
  int heap_id = ObjectId(this);
  if (dict_contains(seen, heap_id)) {
    return Alloc<hnode::AlreadySeen>(heap_id);
  }
  seen->set(heap_id, true);

  hnode::Record* out_node = runtime::NewRecord(StrFromC("DocFragment"));
  List<Field*>* L = out_node->fields;

  hnode_t* x0 = this->mdoc->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("mdoc"), x0));

  hnode_t* x1 = ToPretty(this->indent);
  L->append(Alloc<Field>(StrFromC("indent"), x1));

  hnode_t* x2 = ToPretty(this->is_flat);
  L->append(Alloc<Field>(StrFromC("is_flat"), x2));

  hnode_t* x3 = this->measure->PrettyTree(do_abbrev, seen);
  L->append(Alloc<Field>(StrFromC("measure"), x3));

  return out_node;
}


}  // namespace pretty_asdl
