<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/physical_and_logical_disk_performance_metrics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "Physical and Logical Disk Performance Metrics"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Physical and Logical Disk Performance Metrics


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibStorage

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Detailed statistics for all disk devices and volumes.


It queries 'LogicalDisk' and 'PhysicalDisk' objects from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per System

These metrics refer to the entire System.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.io | reads, writes | KiB/s |

### Per Logical Disk

These metrics refer to Logical Disks.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mount_point | Drive letter or mount point path assigned by Windows (e.g., 'C:', 'D:'). |
| driver_type | Classification of the disk device (e.g., norootdir, removable, cdrom, ramdisk). |
| filesystem | File system format used on the volume (e.g., NTFS, FAT32). |
| rw_mode | Current read/write permissions status of the volume (read-only access, read and write access). |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.space | avail, used | GiB |

### Per Physical Disk

These metrics refer to Physical Disks.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| mount_point | Drive letter or mount point path assigned by Windows (e.g., 'C:', 'D:'). |
| device | Manufacturer model name. |
| model | The device model. |
| device_id | Unique hardware identifier for the storage device within the system. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| disk.io | reads, writes | KiB/s |
| disk.avgsz | reads, writes | KiB/operation |
| disk.ops | reads, writes | operations/s |
| disk.split | discards | operations/s |
| disk.await | reads, writes | milliseconds/operation |
| disk.svctm | svctm | milliseconds/operation |
| disk.util | utilization | percent |
| disk.busy | busy | milliseconds |
| disk.iotime | reads, writes | milliseconds/s |
| disk.qops | operations | operations |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

No action required.

### Configuration

#### Options





| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 1 | no |




#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:PerflibStorage]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


