<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/ntfy/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/ntfy/metadata.yaml"
sidebar_label: "ntfy"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# ntfy


<img src="https://netdata.cloud/img/ntfy.svg" width="150"/>


[ntfy](https://ntfy.sh/) (pronounce: notify) is a simple HTTP-based [pub-sub](https://en.wikipedia.org/wiki/Publish%E2%80%93subscribe_pattern) notification service. It allows you to send notifications to your phone or desktop via scripts from any computer, entirely without signup, cost or setup. It's also [open source](https://github.com/binwiederhier/ntfy) if you want to run your own server.
You can send alerts to an ntfy server using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- (Optional) A [self-hosted ntfy server](https://docs.ntfy.sh/faq/#can-i-self-host-it), in case you don't want to use https://ntfy.sh
- A new [topic](https://ntfy.sh/#subscribe) for the notifications to be published to
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SEND_NTFY | Set `SEND_NTFY` to YES | YES | yes |
| DEFAULT_RECIPIENT_NTFY | URL formed by the server-topic combination you want the alert notifications to be sent to. Unless hosting your own server, the server should always be set to https://ntfy.sh. |  | yes |
| NTFY_USERNAME | The username for netdata to use to authenticate with an ntfy server. |  | no |
| NTFY_PASSWORD | The password for netdata to use to authenticate with an ntfy server. |  | no |
| NTFY_ACCESS_TOKEN | The access token for netdata to use to authenticate with an ntfy server. |  | no |

##### DEFAULT_RECIPIENT_NTFY

You can define multiple recipient URLs like this: `https://SERVER1/TOPIC1` `https://SERVER2/TOPIC2`

All roles will default to this variable if left unconfigured.

You can then have different servers and/or topics per role, by editing DEFAULT_RECIPIENT_NTFY with the server-topic combination you want, in the following entries at the bottom of the same file:
```text
role_recipients_ntfy[sysadmin]="https://SERVER1/TOPIC1"
role_recipients_ntfy[domainadmin]="https://SERVER2/TOPIC2"
role_recipients_ntfy[dba]="https://SERVER3/TOPIC3"
role_recipients_ntfy[webmaster]="https://SERVER4/TOPIC4"
role_recipients_ntfy[proxyadmin]="https://SERVER5/TOPIC5"
role_recipients_ntfy[sitemgr]="https://SERVER6/TOPIC6"
```


##### NTFY_USERNAME

Only useful on self-hosted ntfy instances. See [users and roles](https://docs.ntfy.sh/config/#users-and-roles) for details.
Ensure that your user has proper read/write access to the provided topic in `DEFAULT_RECIPIENT_NTFY`


##### NTFY_PASSWORD

Only useful on self-hosted ntfy instances. See [users and roles](https://docs.ntfy.sh/config/#users-and-roles) for details.
Ensure that your user has proper read/write access to the provided topic in `DEFAULT_RECIPIENT_NTFY`


##### NTFY_ACCESS_TOKEN

This can be used in place of `NTFY_USERNAME` and `NTFY_PASSWORD` to authenticate with a self-hosted ntfy instance. See [access tokens](https://docs.ntfy.sh/config/?h=access+to#access-tokens) for details.
Ensure that the token user has proper read/write access to the provided topic in `DEFAULT_RECIPIENT_NTFY`


</details>

#### Examples

##### Basic Configuration



```yaml
SEND_NTFY="YES"
DEFAULT_RECIPIENT_NTFY="https://ntfy.sh/netdata-X7seHg7d3Tw9zGOk https://ntfy.sh/netdata-oIPm4IK1IlUtlA30"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


