/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.jdk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import org.eclipse.aether.spi.connector.transport.http.HttpTransporterException;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Reporter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdkRFC9457Reporter
extends RFC9457Reporter<HttpURLConnection, HttpTransporterException> {
    public static final JdkRFC9457Reporter INSTANCE = new JdkRFC9457Reporter();

    private JdkRFC9457Reporter() {
    }

    protected boolean isRFC9457Message(HttpURLConnection response) {
        String contentType = response.getContentType();
        return this.hasRFC9457ContentType(contentType);
    }

    protected int getStatusCode(HttpURLConnection response) {
        try {
            return response.getResponseCode();
        }
        catch (IOException e) {
            return -1;
        }
    }

    protected String getReasonPhrase(HttpURLConnection response) {
        return null;
    }

    protected String getBody(HttpURLConnection response) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }
}

