/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.cli.logging;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.api.cli.Logger;

public class AccumulatingLogger
implements Logger {
    private final AtomicReference<List<Logger.Entry>> entries = new AtomicReference(new CopyOnWriteArrayList());

    @Override
    public void log(Logger.Level level, String message, Throwable error) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(message, "message");
        this.entries.get().add(new Logger.Entry(level, message, error));
    }

    @Override
    public List<Logger.Entry> drain() {
        return this.entries.getAndSet(new CopyOnWriteArrayList());
    }
}

