/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Contributor
implements Serializable,
InputLocationTracker {
    final String name;
    final String email;
    final String url;
    final String organization;
    final String organizationUrl;
    final List<String> roles;
    final String timezone;
    final Map<String, String> properties;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Contributor(Builder builder) {
        String string = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string2 = builder.email != null ? builder.email : (this.email = builder.base != null ? builder.base.email : null);
        String string3 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        String string4 = builder.organization != null ? builder.organization : (this.organization = builder.base != null ? builder.base.organization : null);
        String string5 = builder.organizationUrl != null ? builder.organizationUrl : (this.organizationUrl = builder.base != null ? builder.base.organizationUrl : null);
        this.roles = ImmutableCollections.copy(builder.roles != null ? builder.roles : (builder.base != null ? builder.base.roles : null));
        String string6 = builder.timezone != null ? builder.timezone : (this.timezone = builder.base != null ? builder.base.timezone : null);
        this.properties = ImmutableCollections.copy(builder.properties != null ? builder.properties : (builder.base != null ? builder.base.properties : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUrl() {
        return this.url;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    public String getTimezone() {
        return this.timezone;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Contributor.newBuilder(this);
    }

    @Nonnull
    public Contributor withName(String name) {
        return Contributor.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Contributor withEmail(String email) {
        return Contributor.newBuilder(this, true).email(email).build();
    }

    @Nonnull
    public Contributor withUrl(String url) {
        return Contributor.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Contributor withOrganization(String organization) {
        return Contributor.newBuilder(this, true).organization(organization).build();
    }

    @Nonnull
    public Contributor withOrganizationUrl(String organizationUrl) {
        return Contributor.newBuilder(this, true).organizationUrl(organizationUrl).build();
    }

    @Nonnull
    public Contributor withRoles(Collection<String> roles) {
        return Contributor.newBuilder(this, true).roles(roles).build();
    }

    @Nonnull
    public Contributor withTimezone(String timezone) {
        return Contributor.newBuilder(this, true).timezone(timezone).build();
    }

    @Nonnull
    public Contributor withProperties(Map<String, String> properties) {
        return Contributor.newBuilder(this, true).properties(properties).build();
    }

    @Nonnull
    public static Contributor newInstance() {
        return Contributor.newInstance(true);
    }

    @Nonnull
    public static Contributor newInstance(boolean withDefaults) {
        return Contributor.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Contributor.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Contributor from) {
        return Contributor.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Contributor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return "Contributor {name=" + this.getName() + ", email=" + this.getEmail() + "}";
    }

    @NotThreadSafe
    public static class Builder {
        Contributor base;
        String name;
        String email;
        String url;
        String organization;
        String organizationUrl;
        Collection<String> roles;
        String timezone;
        Map<String, String> properties;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Contributor base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.email = base.email;
                this.url = base.url;
                this.organization = base.organization;
                this.organizationUrl = base.organizationUrl;
                this.roles = base.roles;
                this.timezone = base.timezone;
                this.properties = base.properties;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Contributor build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.email != null && this.email != this.base.email || this.url != null && this.url != this.base.url || this.organization != null && this.organization != this.base.organization || this.organizationUrl != null && this.organizationUrl != this.base.organizationUrl || this.roles != null && this.roles != this.base.roles || this.timezone != null && this.timezone != this.base.timezone || this.properties != null && this.properties != this.base.properties)) {
                return this.base;
            }
            return new Contributor(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

