%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: September 30, 2012
%
%  Original Unicode file header comments follow

/*
# DerivedCoreProperties-6.2.0.txt
# Date: 2012-05-20, 00:42:31 GMT [MD]
#
# Unicode Character Database
# Copyright (c) 1991-2012 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/

% ================================================
*/

unicode_core_property(CodePoint, Property) :-
	(	var(CodePoint) ->
		% generate code point pairs
		unicode_core_property(CodePointStart, CodePointEnd, Property),
		between(CodePointStart, CodePointEnd, CodePoint)
	;	% try first-argument indexing first
		unicode_core_property(CodePoint, _, CodePointProperty) ->
		Property = CodePointProperty
	;	% look for a code point range that includes the given code point
		unicode_core_property(CodePointStart, CodePointEnd, CodePointProperty),
		between(CodePointStart, CodePointEnd, CodePoint) ->
		Property = CodePointProperty
	).

% Derived Property: Math
%  Generated from: Sm + Other_Math

unicode_core_property(0x002B, 0x002B, 'Math').	% Sm       PLUS SIGN
unicode_core_property(0x003C, 0x003E, 'Math').	% Sm   [3] LESS-THAN SIGN..GREATER-THAN SIGN
unicode_core_property(0x005E, 0x005E, 'Math').	% Sk       CIRCUMFLEX ACCENT
unicode_core_property(0x007C, 0x007C, 'Math').	% Sm       VERTICAL LINE
unicode_core_property(0x007E, 0x007E, 'Math').	% Sm       TILDE
unicode_core_property(0x00AC, 0x00AC, 'Math').	% Sm       NOT SIGN
unicode_core_property(0x00B1, 0x00B1, 'Math').	% Sm       PLUS-MINUS SIGN
unicode_core_property(0x00D7, 0x00D7, 'Math').	% Sm       MULTIPLICATION SIGN
unicode_core_property(0x00F7, 0x00F7, 'Math').	% Sm       DIVISION SIGN
unicode_core_property(0x03D0, 0x03D2, 'Math').	% L&   [3] GREEK BETA SYMBOL..GREEK UPSILON WITH HOOK SYMBOL
unicode_core_property(0x03D5, 0x03D5, 'Math').	% L&       GREEK PHI SYMBOL
unicode_core_property(0x03F0, 0x03F1, 'Math').	% L&   [2] GREEK KAPPA SYMBOL..GREEK RHO SYMBOL
unicode_core_property(0x03F4, 0x03F5, 'Math').	% L&   [2] GREEK CAPITAL THETA SYMBOL..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F6, 0x03F6, 'Math').	% Sm       GREEK REVERSED LUNATE EPSILON SYMBOL
unicode_core_property(0x0606, 0x0608, 'Math').	% Sm   [3] ARABIC-INDIC CUBE ROOT..ARABIC RAY
unicode_core_property(0x2016, 0x2016, 'Math').	% Po       DOUBLE VERTICAL LINE
unicode_core_property(0x2032, 0x2034, 'Math').	% Po   [3] PRIME..TRIPLE PRIME
unicode_core_property(0x2040, 0x2040, 'Math').	% Pc       CHARACTER TIE
unicode_core_property(0x2044, 0x2044, 'Math').	% Sm       FRACTION SLASH
unicode_core_property(0x2052, 0x2052, 'Math').	% Sm       COMMERCIAL MINUS SIGN
unicode_core_property(0x2061, 0x2064, 'Math').	% Cf   [4] FUNCTION APPLICATION..INVISIBLE PLUS
unicode_core_property(0x207A, 0x207C, 'Math').	% Sm   [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
unicode_core_property(0x207D, 0x207D, 'Math').	% Ps       SUPERSCRIPT LEFT PARENTHESIS
unicode_core_property(0x207E, 0x207E, 'Math').	% Pe       SUPERSCRIPT RIGHT PARENTHESIS
unicode_core_property(0x208A, 0x208C, 'Math').	% Sm   [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
unicode_core_property(0x208D, 0x208D, 'Math').	% Ps       SUBSCRIPT LEFT PARENTHESIS
unicode_core_property(0x208E, 0x208E, 'Math').	% Pe       SUBSCRIPT RIGHT PARENTHESIS
unicode_core_property(0x20D0, 0x20DC, 'Math').	% Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_core_property(0x20E1, 0x20E1, 'Math').	% Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_core_property(0x20E5, 0x20E6, 'Math').	% Mn   [2] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING DOUBLE VERTICAL STROKE OVERLAY
unicode_core_property(0x20EB, 0x20EF, 'Math').	% Mn   [5] COMBINING LONG DOUBLE SOLIDUS OVERLAY..COMBINING RIGHT ARROW BELOW
unicode_core_property(0x2102, 0x2102, 'Math').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'Math').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'Math').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'Math').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2118, 0x2118, 'Math').	% Sm       SCRIPT CAPITAL P
unicode_core_property(0x2119, 0x211D, 'Math').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'Math').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2128, 0x2128, 'Math').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x2129, 0x2129, 'Math').	% So       TURNED GREEK SMALL LETTER IOTA
unicode_core_property(0x212C, 0x212D, 'Math').	% L&   [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
unicode_core_property(0x212F, 0x2131, 'Math').	% L&   [3] SCRIPT SMALL E..SCRIPT CAPITAL F
unicode_core_property(0x2133, 0x2134, 'Math').	% L&   [2] SCRIPT CAPITAL M..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'Math').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x213C, 0x213F, 'Math').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2140, 0x2144, 'Math').	% Sm   [5] DOUBLE-STRUCK N-ARY SUMMATION..TURNED SANS-SERIF CAPITAL Y
unicode_core_property(0x2145, 0x2149, 'Math').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214B, 0x214B, 'Math').	% Sm       TURNED AMPERSAND
unicode_core_property(0x2190, 0x2194, 'Math').	% Sm   [5] LEFTWARDS ARROW..LEFT RIGHT ARROW
unicode_core_property(0x2195, 0x2199, 'Math').	% So   [5] UP DOWN ARROW..SOUTH WEST ARROW
unicode_core_property(0x219A, 0x219B, 'Math').	% Sm   [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
unicode_core_property(0x219C, 0x219F, 'Math').	% So   [4] LEFTWARDS WAVE ARROW..UPWARDS TWO HEADED ARROW
unicode_core_property(0x21A0, 0x21A0, 'Math').	% Sm       RIGHTWARDS TWO HEADED ARROW
unicode_core_property(0x21A1, 0x21A2, 'Math').	% So   [2] DOWNWARDS TWO HEADED ARROW..LEFTWARDS ARROW WITH TAIL
unicode_core_property(0x21A3, 0x21A3, 'Math').	% Sm       RIGHTWARDS ARROW WITH TAIL
unicode_core_property(0x21A4, 0x21A5, 'Math').	% So   [2] LEFTWARDS ARROW FROM BAR..UPWARDS ARROW FROM BAR
unicode_core_property(0x21A6, 0x21A6, 'Math').	% Sm       RIGHTWARDS ARROW FROM BAR
unicode_core_property(0x21A7, 0x21A7, 'Math').	% So       DOWNWARDS ARROW FROM BAR
unicode_core_property(0x21A9, 0x21AD, 'Math').	% So   [5] LEFTWARDS ARROW WITH HOOK..LEFT RIGHT WAVE ARROW
unicode_core_property(0x21AE, 0x21AE, 'Math').	% Sm       LEFT RIGHT ARROW WITH STROKE
unicode_core_property(0x21B0, 0x21B1, 'Math').	% So   [2] UPWARDS ARROW WITH TIP LEFTWARDS..UPWARDS ARROW WITH TIP RIGHTWARDS
unicode_core_property(0x21B6, 0x21B7, 'Math').	% So   [2] ANTICLOCKWISE TOP SEMICIRCLE ARROW..CLOCKWISE TOP SEMICIRCLE ARROW
unicode_core_property(0x21BC, 0x21CD, 'Math').	% So  [18] LEFTWARDS HARPOON WITH BARB UPWARDS..LEFTWARDS DOUBLE ARROW WITH STROKE
unicode_core_property(0x21CE, 0x21CF, 'Math').	% Sm   [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
unicode_core_property(0x21D0, 0x21D1, 'Math').	% So   [2] LEFTWARDS DOUBLE ARROW..UPWARDS DOUBLE ARROW
unicode_core_property(0x21D2, 0x21D2, 'Math').	% Sm       RIGHTWARDS DOUBLE ARROW
unicode_core_property(0x21D3, 0x21D3, 'Math').	% So       DOWNWARDS DOUBLE ARROW
unicode_core_property(0x21D4, 0x21D4, 'Math').	% Sm       LEFT RIGHT DOUBLE ARROW
unicode_core_property(0x21D5, 0x21DB, 'Math').	% So   [7] UP DOWN DOUBLE ARROW..RIGHTWARDS TRIPLE ARROW
unicode_core_property(0x21DD, 0x21DD, 'Math').	% So       RIGHTWARDS SQUIGGLE ARROW
unicode_core_property(0x21E4, 0x21E5, 'Math').	% So   [2] LEFTWARDS ARROW TO BAR..RIGHTWARDS ARROW TO BAR
unicode_core_property(0x21F4, 0x22FF, 'Math').	% Sm [268] RIGHT ARROW WITH SMALL CIRCLE..Z NOTATION BAG MEMBERSHIP
unicode_core_property(0x2308, 0x230B, 'Math').	% Sm   [4] LEFT CEILING..RIGHT FLOOR
unicode_core_property(0x2320, 0x2321, 'Math').	% Sm   [2] TOP HALF INTEGRAL..BOTTOM HALF INTEGRAL
unicode_core_property(0x237C, 0x237C, 'Math').	% Sm       RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
unicode_core_property(0x239B, 0x23B3, 'Math').	% Sm  [25] LEFT PARENTHESIS UPPER HOOK..SUMMATION BOTTOM
unicode_core_property(0x23B4, 0x23B5, 'Math').	% So   [2] TOP SQUARE BRACKET..BOTTOM SQUARE BRACKET
unicode_core_property(0x23B7, 0x23B7, 'Math').	% So       RADICAL SYMBOL BOTTOM
unicode_core_property(0x23D0, 0x23D0, 'Math').	% So       VERTICAL LINE EXTENSION
unicode_core_property(0x23DC, 0x23E1, 'Math').	% Sm   [6] TOP PARENTHESIS..BOTTOM TORTOISE SHELL BRACKET
unicode_core_property(0x23E2, 0x23E2, 'Math').	% So       WHITE TRAPEZIUM
unicode_core_property(0x25A0, 0x25A1, 'Math').	% So   [2] BLACK SQUARE..WHITE SQUARE
unicode_core_property(0x25AE, 0x25B6, 'Math').	% So   [9] BLACK VERTICAL RECTANGLE..BLACK RIGHT-POINTING TRIANGLE
unicode_core_property(0x25B7, 0x25B7, 'Math').	% Sm       WHITE RIGHT-POINTING TRIANGLE
unicode_core_property(0x25BC, 0x25C0, 'Math').	% So   [5] BLACK DOWN-POINTING TRIANGLE..BLACK LEFT-POINTING TRIANGLE
unicode_core_property(0x25C1, 0x25C1, 'Math').	% Sm       WHITE LEFT-POINTING TRIANGLE
unicode_core_property(0x25C6, 0x25C7, 'Math').	% So   [2] BLACK DIAMOND..WHITE DIAMOND
unicode_core_property(0x25CA, 0x25CB, 'Math').	% So   [2] LOZENGE..WHITE CIRCLE
unicode_core_property(0x25CF, 0x25D3, 'Math').	% So   [5] BLACK CIRCLE..CIRCLE WITH UPPER HALF BLACK
unicode_core_property(0x25E2, 0x25E2, 'Math').	% So       BLACK LOWER RIGHT TRIANGLE
unicode_core_property(0x25E4, 0x25E4, 'Math').	% So       BLACK UPPER LEFT TRIANGLE
unicode_core_property(0x25E7, 0x25EC, 'Math').	% So   [6] SQUARE WITH LEFT HALF BLACK..WHITE UP-POINTING TRIANGLE WITH DOT
unicode_core_property(0x25F8, 0x25FF, 'Math').	% Sm   [8] UPPER LEFT TRIANGLE..LOWER RIGHT TRIANGLE
unicode_core_property(0x2605, 0x2606, 'Math').	% So   [2] BLACK STAR..WHITE STAR
unicode_core_property(0x2640, 0x2640, 'Math').	% So       FEMALE SIGN
unicode_core_property(0x2642, 0x2642, 'Math').	% So       MALE SIGN
unicode_core_property(0x2660, 0x2663, 'Math').	% So   [4] BLACK SPADE SUIT..BLACK CLUB SUIT
unicode_core_property(0x266D, 0x266E, 'Math').	% So   [2] MUSIC FLAT SIGN..MUSIC NATURAL SIGN
unicode_core_property(0x266F, 0x266F, 'Math').	% Sm       MUSIC SHARP SIGN
unicode_core_property(0x27C0, 0x27C4, 'Math').	% Sm   [5] THREE DIMENSIONAL ANGLE..OPEN SUPERSET
unicode_core_property(0x27C5, 0x27C5, 'Math').	% Ps       LEFT S-SHAPED BAG DELIMITER
unicode_core_property(0x27C6, 0x27C6, 'Math').	% Pe       RIGHT S-SHAPED BAG DELIMITER
unicode_core_property(0x27C7, 0x27E5, 'Math').	% Sm  [31] OR WITH DOT INSIDE..WHITE SQUARE WITH RIGHTWARDS TICK
unicode_core_property(0x27E6, 0x27E6, 'Math').	% Ps       MATHEMATICAL LEFT WHITE SQUARE BRACKET
unicode_core_property(0x27E7, 0x27E7, 'Math').	% Pe       MATHEMATICAL RIGHT WHITE SQUARE BRACKET
unicode_core_property(0x27E8, 0x27E8, 'Math').	% Ps       MATHEMATICAL LEFT ANGLE BRACKET
unicode_core_property(0x27E9, 0x27E9, 'Math').	% Pe       MATHEMATICAL RIGHT ANGLE BRACKET
unicode_core_property(0x27EA, 0x27EA, 'Math').	% Ps       MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
unicode_core_property(0x27EB, 0x27EB, 'Math').	% Pe       MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
unicode_core_property(0x27EC, 0x27EC, 'Math').	% Ps       MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
unicode_core_property(0x27ED, 0x27ED, 'Math').	% Pe       MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
unicode_core_property(0x27EE, 0x27EE, 'Math').	% Ps       MATHEMATICAL LEFT FLATTENED PARENTHESIS
unicode_core_property(0x27EF, 0x27EF, 'Math').	% Pe       MATHEMATICAL RIGHT FLATTENED PARENTHESIS
unicode_core_property(0x27F0, 0x27FF, 'Math').	% Sm  [16] UPWARDS QUADRUPLE ARROW..LONG RIGHTWARDS SQUIGGLE ARROW
unicode_core_property(0x2900, 0x2982, 'Math').	% Sm [131] RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE..Z NOTATION TYPE COLON
unicode_core_property(0x2983, 0x2983, 'Math').	% Ps       LEFT WHITE CURLY BRACKET
unicode_core_property(0x2984, 0x2984, 'Math').	% Pe       RIGHT WHITE CURLY BRACKET
unicode_core_property(0x2985, 0x2985, 'Math').	% Ps       LEFT WHITE PARENTHESIS
unicode_core_property(0x2986, 0x2986, 'Math').	% Pe       RIGHT WHITE PARENTHESIS
unicode_core_property(0x2987, 0x2987, 'Math').	% Ps       Z NOTATION LEFT IMAGE BRACKET
unicode_core_property(0x2988, 0x2988, 'Math').	% Pe       Z NOTATION RIGHT IMAGE BRACKET
unicode_core_property(0x2989, 0x2989, 'Math').	% Ps       Z NOTATION LEFT BINDING BRACKET
unicode_core_property(0x298A, 0x298A, 'Math').	% Pe       Z NOTATION RIGHT BINDING BRACKET
unicode_core_property(0x298B, 0x298B, 'Math').	% Ps       LEFT SQUARE BRACKET WITH UNDERBAR
unicode_core_property(0x298C, 0x298C, 'Math').	% Pe       RIGHT SQUARE BRACKET WITH UNDERBAR
unicode_core_property(0x298D, 0x298D, 'Math').	% Ps       LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
unicode_core_property(0x298E, 0x298E, 'Math').	% Pe       RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
unicode_core_property(0x298F, 0x298F, 'Math').	% Ps       LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
unicode_core_property(0x2990, 0x2990, 'Math').	% Pe       RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
unicode_core_property(0x2991, 0x2991, 'Math').	% Ps       LEFT ANGLE BRACKET WITH DOT
unicode_core_property(0x2992, 0x2992, 'Math').	% Pe       RIGHT ANGLE BRACKET WITH DOT
unicode_core_property(0x2993, 0x2993, 'Math').	% Ps       LEFT ARC LESS-THAN BRACKET
unicode_core_property(0x2994, 0x2994, 'Math').	% Pe       RIGHT ARC GREATER-THAN BRACKET
unicode_core_property(0x2995, 0x2995, 'Math').	% Ps       DOUBLE LEFT ARC GREATER-THAN BRACKET
unicode_core_property(0x2996, 0x2996, 'Math').	% Pe       DOUBLE RIGHT ARC LESS-THAN BRACKET
unicode_core_property(0x2997, 0x2997, 'Math').	% Ps       LEFT BLACK TORTOISE SHELL BRACKET
unicode_core_property(0x2998, 0x2998, 'Math').	% Pe       RIGHT BLACK TORTOISE SHELL BRACKET
unicode_core_property(0x2999, 0x29D7, 'Math').	% Sm  [63] DOTTED FENCE..BLACK HOURGLASS
unicode_core_property(0x29D8, 0x29D8, 'Math').	% Ps       LEFT WIGGLY FENCE
unicode_core_property(0x29D9, 0x29D9, 'Math').	% Pe       RIGHT WIGGLY FENCE
unicode_core_property(0x29DA, 0x29DA, 'Math').	% Ps       LEFT DOUBLE WIGGLY FENCE
unicode_core_property(0x29DB, 0x29DB, 'Math').	% Pe       RIGHT DOUBLE WIGGLY FENCE
unicode_core_property(0x29DC, 0x29FB, 'Math').	% Sm  [32] INCOMPLETE INFINITY..TRIPLE PLUS
unicode_core_property(0x29FC, 0x29FC, 'Math').	% Ps       LEFT-POINTING CURVED ANGLE BRACKET
unicode_core_property(0x29FD, 0x29FD, 'Math').	% Pe       RIGHT-POINTING CURVED ANGLE BRACKET
unicode_core_property(0x29FE, 0x2AFF, 'Math').	% Sm [258] TINY..N-ARY WHITE VERTICAL BAR
unicode_core_property(0x2B30, 0x2B44, 'Math').	% Sm  [21] LEFT ARROW WITH SMALL CIRCLE..RIGHTWARDS ARROW THROUGH SUPERSET
unicode_core_property(0x2B47, 0x2B4C, 'Math').	% Sm   [6] REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW..RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
unicode_core_property(0xFB29, 0xFB29, 'Math').	% Sm       HEBREW LETTER ALTERNATIVE PLUS SIGN
unicode_core_property(0xFE61, 0xFE61, 'Math').	% Po       SMALL ASTERISK
unicode_core_property(0xFE62, 0xFE62, 'Math').	% Sm       SMALL PLUS SIGN
unicode_core_property(0xFE63, 0xFE63, 'Math').	% Pd       SMALL HYPHEN-MINUS
unicode_core_property(0xFE64, 0xFE66, 'Math').	% Sm   [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
unicode_core_property(0xFE68, 0xFE68, 'Math').	% Po       SMALL REVERSE SOLIDUS
unicode_core_property(0xFF0B, 0xFF0B, 'Math').	% Sm       FULLWIDTH PLUS SIGN
unicode_core_property(0xFF1C, 0xFF1E, 'Math').	% Sm   [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
unicode_core_property(0xFF3C, 0xFF3C, 'Math').	% Po       FULLWIDTH REVERSE SOLIDUS
unicode_core_property(0xFF3E, 0xFF3E, 'Math').	% Sk       FULLWIDTH CIRCUMFLEX ACCENT
unicode_core_property(0xFF5C, 0xFF5C, 'Math').	% Sm       FULLWIDTH VERTICAL LINE
unicode_core_property(0xFF5E, 0xFF5E, 'Math').	% Sm       FULLWIDTH TILDE
unicode_core_property(0xFFE2, 0xFFE2, 'Math').	% Sm       FULLWIDTH NOT SIGN
unicode_core_property(0xFFE9, 0xFFEC, 'Math').	% Sm   [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
unicode_core_property(0x1D400, 0x1D454, 'Math').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'Math').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'Math').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'Math').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'Math').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'Math').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'Math').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'Math').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'Math').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'Math').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'Math').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'Math').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'Math').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'Math').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'Math').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'Math').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'Math').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'Math').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'Math').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'Math').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C1, 0x1D6C1, 'Math').	% Sm       MATHEMATICAL BOLD NABLA
unicode_core_property(0x1D6C2, 0x1D6DA, 'Math').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DB, 0x1D6DB, 'Math').	% Sm       MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
unicode_core_property(0x1D6DC, 0x1D6FA, 'Math').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FB, 0x1D6FB, 'Math').	% Sm       MATHEMATICAL ITALIC NABLA
unicode_core_property(0x1D6FC, 0x1D714, 'Math').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D715, 0x1D715, 'Math').	% Sm       MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
unicode_core_property(0x1D716, 0x1D734, 'Math').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D735, 0x1D735, 'Math').	% Sm       MATHEMATICAL BOLD ITALIC NABLA
unicode_core_property(0x1D736, 0x1D74E, 'Math').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D74F, 0x1D74F, 'Math').	% Sm       MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_core_property(0x1D750, 0x1D76E, 'Math').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D76F, 0x1D76F, 'Math').	% Sm       MATHEMATICAL SANS-SERIF BOLD NABLA
unicode_core_property(0x1D770, 0x1D788, 'Math').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D789, 0x1D789, 'Math').	% Sm       MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
unicode_core_property(0x1D78A, 0x1D7A8, 'Math').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7A9, 0x1D7A9, 'Math').	% Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
unicode_core_property(0x1D7AA, 0x1D7C2, 'Math').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C3, 0x1D7C3, 'Math').	% Sm       MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
unicode_core_property(0x1D7C4, 0x1D7CB, 'Math').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1D7CE, 0x1D7FF, 'Math').	% Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_core_property(0x1EE00, 0x1EE03, 'Math').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'Math').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'Math').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'Math').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'Math').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'Math').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'Math').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'Math').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'Math').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'Math').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'Math').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'Math').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'Math').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'Math').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'Math').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'Math').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'Math').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'Math').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'Math').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'Math').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'Math').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'Math').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'Math').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'Math').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x1EEF0, 0x1EEF1, 'Math').	% Sm   [2] ARABIC MATHEMATICAL OPERATOR MEEM WITH HAH WITH TATWEEL..ARABIC MATHEMATICAL OPERATOR HAH WITH DAL

% Total code points: 2310

% ================================================

% Derived Property: Alphabetic
%  Generated from: Lu+Ll+Lt+Lm+Lo+Nl + Other_Alphabetic

unicode_core_property(0x0041, 0x005A, 'Alphabetic').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x0061, 0x007A, 'Alphabetic').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'Alphabetic').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'Alphabetic').	% L&       MICRO SIGN
unicode_core_property(0x00BA, 0x00BA, 'Alphabetic').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'Alphabetic').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'Alphabetic').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'Alphabetic').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'Alphabetic').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'Alphabetic').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'Alphabetic').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'Alphabetic').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'Alphabetic').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'Alphabetic').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'Alphabetic').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C6, 0x02D1, 'Alphabetic').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02E0, 0x02E4, 'Alphabetic').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02EC, 0x02EC, 'Alphabetic').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02EE, 0x02EE, 'Alphabetic').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x0345, 0x0345, 'Alphabetic').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0370, 0x0373, 'Alphabetic').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'Alphabetic').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'Alphabetic').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'Alphabetic').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'Alphabetic').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'Alphabetic').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Alphabetic').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Alphabetic').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'Alphabetic').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'Alphabetic').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'Alphabetic').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048A, 0x0527, 'Alphabetic').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Alphabetic').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'Alphabetic').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0561, 0x0587, 'Alphabetic').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x05B0, 0x05BD, 'Alphabetic').	% Mn  [14] HEBREW POINT SHEVA..HEBREW POINT METEG
unicode_core_property(0x05BF, 0x05BF, 'Alphabetic').	% Mn       HEBREW POINT RAFE
unicode_core_property(0x05C1, 0x05C2, 'Alphabetic').	% Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
unicode_core_property(0x05C4, 0x05C5, 'Alphabetic').	% Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
unicode_core_property(0x05C7, 0x05C7, 'Alphabetic').	% Mn       HEBREW POINT QAMATS QATAN
unicode_core_property(0x05D0, 0x05EA, 'Alphabetic').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'Alphabetic').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x0610, 0x061A, 'Alphabetic').	% Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
unicode_core_property(0x0620, 0x063F, 'Alphabetic').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'Alphabetic').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'Alphabetic').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x064B, 0x0657, 'Alphabetic').	% Mn  [13] ARABIC FATHATAN..ARABIC INVERTED DAMMA
unicode_core_property(0x0659, 0x065F, 'Alphabetic').	% Mn   [7] ARABIC ZWARAKAY..ARABIC WAVY HAMZA BELOW
unicode_core_property(0x066E, 0x066F, 'Alphabetic').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0670, 0x0670, 'Alphabetic').	% Mn       ARABIC LETTER SUPERSCRIPT ALEF
unicode_core_property(0x0671, 0x06D3, 'Alphabetic').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D5, 0x06D5, 'Alphabetic').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06D6, 0x06DC, 'Alphabetic').	% Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
unicode_core_property(0x06E1, 0x06E4, 'Alphabetic').	% Mn   [4] ARABIC SMALL HIGH DOTLESS HEAD OF KHAH..ARABIC SMALL HIGH MADDA
unicode_core_property(0x06E5, 0x06E6, 'Alphabetic').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06E7, 0x06E8, 'Alphabetic').	% Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
unicode_core_property(0x06ED, 0x06ED, 'Alphabetic').	% Mn       ARABIC SMALL LOW MEEM
unicode_core_property(0x06EE, 0x06EF, 'Alphabetic').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06FA, 0x06FC, 'Alphabetic').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FF, 0x06FF, 'Alphabetic').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0710, 0x0710, 'Alphabetic').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0711, 0x0711, 'Alphabetic').	% Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
unicode_core_property(0x0712, 0x072F, 'Alphabetic').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x0730, 0x073F, 'Alphabetic').	% Mn  [16] SYRIAC PTHAHA ABOVE..SYRIAC RWAHA
unicode_core_property(0x074D, 0x07A5, 'Alphabetic').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07A6, 0x07B0, 'Alphabetic').	% Mn  [11] THAANA ABAFILI..THAANA SUKUN
unicode_core_property(0x07B1, 0x07B1, 'Alphabetic').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07CA, 0x07EA, 'Alphabetic').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07F4, 0x07F5, 'Alphabetic').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'Alphabetic').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'Alphabetic').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x0816, 0x0817, 'Alphabetic').	% Mn   [2] SAMARITAN MARK IN..SAMARITAN MARK IN-ALAF
unicode_core_property(0x081A, 0x081A, 'Alphabetic').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x081B, 0x0823, 'Alphabetic').	% Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
unicode_core_property(0x0824, 0x0824, 'Alphabetic').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0825, 0x0827, 'Alphabetic').	% Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
unicode_core_property(0x0828, 0x0828, 'Alphabetic').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0829, 0x082C, 'Alphabetic').	% Mn   [4] SAMARITAN VOWEL SIGN LONG I..SAMARITAN VOWEL SIGN SUKUN
unicode_core_property(0x0840, 0x0858, 'Alphabetic').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x08A0, 0x08A0, 'Alphabetic').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'Alphabetic').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x08E4, 0x08E9, 'Alphabetic').	% Mn   [6] ARABIC CURLY FATHA..ARABIC CURLY KASRATAN
unicode_core_property(0x08F0, 0x08FE, 'Alphabetic').	% Mn  [15] ARABIC OPEN FATHATAN..ARABIC DAMMA WITH DOT
unicode_core_property(0x0900, 0x0902, 'Alphabetic').	% Mn   [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
unicode_core_property(0x0903, 0x0903, 'Alphabetic').	% Mc       DEVANAGARI SIGN VISARGA
unicode_core_property(0x0904, 0x0939, 'Alphabetic').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093A, 0x093A, 'Alphabetic').	% Mn       DEVANAGARI VOWEL SIGN OE
unicode_core_property(0x093B, 0x093B, 'Alphabetic').	% Mc       DEVANAGARI VOWEL SIGN OOE
unicode_core_property(0x093D, 0x093D, 'Alphabetic').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x093E, 0x0940, 'Alphabetic').	% Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
unicode_core_property(0x0941, 0x0948, 'Alphabetic').	% Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
unicode_core_property(0x0949, 0x094C, 'Alphabetic').	% Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
unicode_core_property(0x094E, 0x094F, 'Alphabetic').	% Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
unicode_core_property(0x0950, 0x0950, 'Alphabetic').	% Lo       DEVANAGARI OM
unicode_core_property(0x0955, 0x0957, 'Alphabetic').	% Mn   [3] DEVANAGARI VOWEL SIGN CANDRA LONG E..DEVANAGARI VOWEL SIGN UUE
unicode_core_property(0x0958, 0x0961, 'Alphabetic').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0962, 0x0963, 'Alphabetic').	% Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0971, 0x0971, 'Alphabetic').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'Alphabetic').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'Alphabetic').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0981, 0x0981, 'Alphabetic').	% Mn       BENGALI SIGN CANDRABINDU
unicode_core_property(0x0982, 0x0983, 'Alphabetic').	% Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
unicode_core_property(0x0985, 0x098C, 'Alphabetic').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'Alphabetic').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'Alphabetic').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'Alphabetic').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'Alphabetic').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'Alphabetic').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BD, 0x09BD, 'Alphabetic').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09BE, 0x09C0, 'Alphabetic').	% Mc   [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
unicode_core_property(0x09C1, 0x09C4, 'Alphabetic').	% Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
unicode_core_property(0x09C7, 0x09C8, 'Alphabetic').	% Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
unicode_core_property(0x09CB, 0x09CC, 'Alphabetic').	% Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
unicode_core_property(0x09CE, 0x09CE, 'Alphabetic').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09D7, 0x09D7, 'Alphabetic').	% Mc       BENGALI AU LENGTH MARK
unicode_core_property(0x09DC, 0x09DD, 'Alphabetic').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'Alphabetic').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09E2, 0x09E3, 'Alphabetic').	% Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
unicode_core_property(0x09F0, 0x09F1, 'Alphabetic').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x0A01, 0x0A02, 'Alphabetic').	% Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
unicode_core_property(0x0A03, 0x0A03, 'Alphabetic').	% Mc       GURMUKHI SIGN VISARGA
unicode_core_property(0x0A05, 0x0A0A, 'Alphabetic').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'Alphabetic').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'Alphabetic').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'Alphabetic').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'Alphabetic').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'Alphabetic').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'Alphabetic').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A3E, 0x0A40, 'Alphabetic').	% Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
unicode_core_property(0x0A41, 0x0A42, 'Alphabetic').	% Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
unicode_core_property(0x0A47, 0x0A48, 'Alphabetic').	% Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
unicode_core_property(0x0A4B, 0x0A4C, 'Alphabetic').	% Mn   [2] GURMUKHI VOWEL SIGN OO..GURMUKHI VOWEL SIGN AU
unicode_core_property(0x0A51, 0x0A51, 'Alphabetic').	% Mn       GURMUKHI SIGN UDAAT
unicode_core_property(0x0A59, 0x0A5C, 'Alphabetic').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'Alphabetic').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A70, 0x0A71, 'Alphabetic').	% Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
unicode_core_property(0x0A72, 0x0A74, 'Alphabetic').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A75, 0x0A75, 'Alphabetic').	% Mn       GURMUKHI SIGN YAKASH
unicode_core_property(0x0A81, 0x0A82, 'Alphabetic').	% Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
unicode_core_property(0x0A83, 0x0A83, 'Alphabetic').	% Mc       GUJARATI SIGN VISARGA
unicode_core_property(0x0A85, 0x0A8D, 'Alphabetic').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'Alphabetic').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'Alphabetic').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'Alphabetic').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'Alphabetic').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'Alphabetic').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABD, 0x0ABD, 'Alphabetic').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0ABE, 0x0AC0, 'Alphabetic').	% Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
unicode_core_property(0x0AC1, 0x0AC5, 'Alphabetic').	% Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
unicode_core_property(0x0AC7, 0x0AC8, 'Alphabetic').	% Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
unicode_core_property(0x0AC9, 0x0AC9, 'Alphabetic').	% Mc       GUJARATI VOWEL SIGN CANDRA O
unicode_core_property(0x0ACB, 0x0ACC, 'Alphabetic').	% Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
unicode_core_property(0x0AD0, 0x0AD0, 'Alphabetic').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'Alphabetic').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0AE2, 0x0AE3, 'Alphabetic').	% Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B01, 0x0B01, 'Alphabetic').	% Mn       ORIYA SIGN CANDRABINDU
unicode_core_property(0x0B02, 0x0B03, 'Alphabetic').	% Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
unicode_core_property(0x0B05, 0x0B0C, 'Alphabetic').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'Alphabetic').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'Alphabetic').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'Alphabetic').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'Alphabetic').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'Alphabetic').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3D, 0x0B3D, 'Alphabetic').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B3E, 0x0B3E, 'Alphabetic').	% Mc       ORIYA VOWEL SIGN AA
unicode_core_property(0x0B3F, 0x0B3F, 'Alphabetic').	% Mn       ORIYA VOWEL SIGN I
unicode_core_property(0x0B40, 0x0B40, 'Alphabetic').	% Mc       ORIYA VOWEL SIGN II
unicode_core_property(0x0B41, 0x0B44, 'Alphabetic').	% Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0B47, 0x0B48, 'Alphabetic').	% Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
unicode_core_property(0x0B4B, 0x0B4C, 'Alphabetic').	% Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
unicode_core_property(0x0B56, 0x0B56, 'Alphabetic').	% Mn       ORIYA AI LENGTH MARK
unicode_core_property(0x0B57, 0x0B57, 'Alphabetic').	% Mc       ORIYA AU LENGTH MARK
unicode_core_property(0x0B5C, 0x0B5D, 'Alphabetic').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'Alphabetic').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B62, 0x0B63, 'Alphabetic').	% Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B71, 0x0B71, 'Alphabetic').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B82, 0x0B82, 'Alphabetic').	% Mn       TAMIL SIGN ANUSVARA
unicode_core_property(0x0B83, 0x0B83, 'Alphabetic').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'Alphabetic').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'Alphabetic').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'Alphabetic').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'Alphabetic').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'Alphabetic').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'Alphabetic').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'Alphabetic').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'Alphabetic').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'Alphabetic').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BBE, 0x0BBF, 'Alphabetic').	% Mc   [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
unicode_core_property(0x0BC0, 0x0BC0, 'Alphabetic').	% Mn       TAMIL VOWEL SIGN II
unicode_core_property(0x0BC1, 0x0BC2, 'Alphabetic').	% Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
unicode_core_property(0x0BC6, 0x0BC8, 'Alphabetic').	% Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
unicode_core_property(0x0BCA, 0x0BCC, 'Alphabetic').	% Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
unicode_core_property(0x0BD0, 0x0BD0, 'Alphabetic').	% Lo       TAMIL OM
unicode_core_property(0x0BD7, 0x0BD7, 'Alphabetic').	% Mc       TAMIL AU LENGTH MARK
unicode_core_property(0x0C01, 0x0C03, 'Alphabetic').	% Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
unicode_core_property(0x0C05, 0x0C0C, 'Alphabetic').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'Alphabetic').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'Alphabetic').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'Alphabetic').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'Alphabetic').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'Alphabetic').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C3E, 0x0C40, 'Alphabetic').	% Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
unicode_core_property(0x0C41, 0x0C44, 'Alphabetic').	% Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
unicode_core_property(0x0C46, 0x0C48, 'Alphabetic').	% Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
unicode_core_property(0x0C4A, 0x0C4C, 'Alphabetic').	% Mn   [3] TELUGU VOWEL SIGN O..TELUGU VOWEL SIGN AU
unicode_core_property(0x0C55, 0x0C56, 'Alphabetic').	% Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
unicode_core_property(0x0C58, 0x0C59, 'Alphabetic').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'Alphabetic').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C62, 0x0C63, 'Alphabetic').	% Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
unicode_core_property(0x0C82, 0x0C83, 'Alphabetic').	% Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
unicode_core_property(0x0C85, 0x0C8C, 'Alphabetic').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'Alphabetic').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'Alphabetic').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'Alphabetic').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'Alphabetic').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBD, 0x0CBD, 'Alphabetic').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CBE, 0x0CBE, 'Alphabetic').	% Mc       KANNADA VOWEL SIGN AA
unicode_core_property(0x0CBF, 0x0CBF, 'Alphabetic').	% Mn       KANNADA VOWEL SIGN I
unicode_core_property(0x0CC0, 0x0CC4, 'Alphabetic').	% Mc   [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0CC6, 0x0CC6, 'Alphabetic').	% Mn       KANNADA VOWEL SIGN E
unicode_core_property(0x0CC7, 0x0CC8, 'Alphabetic').	% Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
unicode_core_property(0x0CCA, 0x0CCB, 'Alphabetic').	% Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
unicode_core_property(0x0CCC, 0x0CCC, 'Alphabetic').	% Mn       KANNADA VOWEL SIGN AU
unicode_core_property(0x0CD5, 0x0CD6, 'Alphabetic').	% Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
unicode_core_property(0x0CDE, 0x0CDE, 'Alphabetic').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'Alphabetic').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CE2, 0x0CE3, 'Alphabetic').	% Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0CF1, 0x0CF2, 'Alphabetic').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D02, 0x0D03, 'Alphabetic').	% Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
unicode_core_property(0x0D05, 0x0D0C, 'Alphabetic').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'Alphabetic').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'Alphabetic').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'Alphabetic').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D3E, 0x0D40, 'Alphabetic').	% Mc   [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
unicode_core_property(0x0D41, 0x0D44, 'Alphabetic').	% Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
unicode_core_property(0x0D46, 0x0D48, 'Alphabetic').	% Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
unicode_core_property(0x0D4A, 0x0D4C, 'Alphabetic').	% Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
unicode_core_property(0x0D4E, 0x0D4E, 'Alphabetic').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D57, 0x0D57, 'Alphabetic').	% Mc       MALAYALAM AU LENGTH MARK
unicode_core_property(0x0D60, 0x0D61, 'Alphabetic').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D62, 0x0D63, 'Alphabetic').	% Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
unicode_core_property(0x0D7A, 0x0D7F, 'Alphabetic').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D82, 0x0D83, 'Alphabetic').	% Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
unicode_core_property(0x0D85, 0x0D96, 'Alphabetic').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'Alphabetic').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'Alphabetic').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'Alphabetic').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'Alphabetic').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0DCF, 0x0DD1, 'Alphabetic').	% Mc   [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
unicode_core_property(0x0DD2, 0x0DD4, 'Alphabetic').	% Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
unicode_core_property(0x0DD6, 0x0DD6, 'Alphabetic').	% Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
unicode_core_property(0x0DD8, 0x0DDF, 'Alphabetic').	% Mc   [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
unicode_core_property(0x0DF2, 0x0DF3, 'Alphabetic').	% Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
unicode_core_property(0x0E01, 0x0E30, 'Alphabetic').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E31, 0x0E31, 'Alphabetic').	% Mn       THAI CHARACTER MAI HAN-AKAT
unicode_core_property(0x0E32, 0x0E33, 'Alphabetic').	% Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_core_property(0x0E34, 0x0E3A, 'Alphabetic').	% Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
unicode_core_property(0x0E40, 0x0E45, 'Alphabetic').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'Alphabetic').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E4D, 0x0E4D, 'Alphabetic').	% Mn       THAI CHARACTER NIKHAHIT
unicode_core_property(0x0E81, 0x0E82, 'Alphabetic').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'Alphabetic').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'Alphabetic').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'Alphabetic').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'Alphabetic').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'Alphabetic').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'Alphabetic').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'Alphabetic').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'Alphabetic').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'Alphabetic').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'Alphabetic').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'Alphabetic').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB1, 0x0EB1, 'Alphabetic').	% Mn       LAO VOWEL SIGN MAI KAN
unicode_core_property(0x0EB2, 0x0EB3, 'Alphabetic').	% Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_core_property(0x0EB4, 0x0EB9, 'Alphabetic').	% Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
unicode_core_property(0x0EBB, 0x0EBC, 'Alphabetic').	% Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
unicode_core_property(0x0EBD, 0x0EBD, 'Alphabetic').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'Alphabetic').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'Alphabetic').	% Lm       LAO KO LA
unicode_core_property(0x0ECD, 0x0ECD, 'Alphabetic').	% Mn       LAO NIGGAHITA
unicode_core_property(0x0EDC, 0x0EDF, 'Alphabetic').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'Alphabetic').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F40, 0x0F47, 'Alphabetic').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'Alphabetic').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F71, 0x0F7E, 'Alphabetic').	% Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
unicode_core_property(0x0F7F, 0x0F7F, 'Alphabetic').	% Mc       TIBETAN SIGN RNAM BCAD
unicode_core_property(0x0F80, 0x0F81, 'Alphabetic').	% Mn   [2] TIBETAN VOWEL SIGN REVERSED I..TIBETAN VOWEL SIGN REVERSED II
unicode_core_property(0x0F88, 0x0F8C, 'Alphabetic').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x0F8D, 0x0F97, 'Alphabetic').	% Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
unicode_core_property(0x0F99, 0x0FBC, 'Alphabetic').	% Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
unicode_core_property(0x1000, 0x102A, 'Alphabetic').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x102B, 0x102C, 'Alphabetic').	% Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
unicode_core_property(0x102D, 0x1030, 'Alphabetic').	% Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
unicode_core_property(0x1031, 0x1031, 'Alphabetic').	% Mc       MYANMAR VOWEL SIGN E
unicode_core_property(0x1032, 0x1036, 'Alphabetic').	% Mn   [5] MYANMAR VOWEL SIGN AI..MYANMAR SIGN ANUSVARA
unicode_core_property(0x1038, 0x1038, 'Alphabetic').	% Mc       MYANMAR SIGN VISARGA
unicode_core_property(0x103B, 0x103C, 'Alphabetic').	% Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
unicode_core_property(0x103D, 0x103E, 'Alphabetic').	% Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
unicode_core_property(0x103F, 0x103F, 'Alphabetic').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1050, 0x1055, 'Alphabetic').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x1056, 0x1057, 'Alphabetic').	% Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
unicode_core_property(0x1058, 0x1059, 'Alphabetic').	% Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
unicode_core_property(0x105A, 0x105D, 'Alphabetic').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x105E, 0x1060, 'Alphabetic').	% Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
unicode_core_property(0x1061, 0x1061, 'Alphabetic').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1062, 0x1062, 'Alphabetic').	% Mc       MYANMAR VOWEL SIGN SGAW KAREN EU
unicode_core_property(0x1065, 0x1066, 'Alphabetic').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x1067, 0x1068, 'Alphabetic').	% Mc   [2] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR VOWEL SIGN WESTERN PWO KAREN UE
unicode_core_property(0x106E, 0x1070, 'Alphabetic').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1071, 0x1074, 'Alphabetic').	% Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
unicode_core_property(0x1075, 0x1081, 'Alphabetic').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x1082, 0x1082, 'Alphabetic').	% Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
unicode_core_property(0x1083, 0x1084, 'Alphabetic').	% Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
unicode_core_property(0x1085, 0x1086, 'Alphabetic').	% Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
unicode_core_property(0x108E, 0x108E, 'Alphabetic').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x109C, 0x109C, 'Alphabetic').	% Mc       MYANMAR VOWEL SIGN AITON A
unicode_core_property(0x109D, 0x109D, 'Alphabetic').	% Mn       MYANMAR VOWEL SIGN AITON AI
unicode_core_property(0x10A0, 0x10C5, 'Alphabetic').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Alphabetic').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Alphabetic').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'Alphabetic').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FC, 0x10FC, 'Alphabetic').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'Alphabetic').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'Alphabetic').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'Alphabetic').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'Alphabetic').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'Alphabetic').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'Alphabetic').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'Alphabetic').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'Alphabetic').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'Alphabetic').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x135F, 0x135F, 'Alphabetic').	% Mn       ETHIOPIC COMBINING GEMINATION MARK
unicode_core_property(0x1380, 0x138F, 'Alphabetic').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x13A0, 0x13F4, 'Alphabetic').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1401, 0x166C, 'Alphabetic').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166F, 0x167F, 'Alphabetic').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1681, 0x169A, 'Alphabetic').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x16A0, 0x16EA, 'Alphabetic').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EE, 0x16F0, 'Alphabetic').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'Alphabetic').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'Alphabetic').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1712, 0x1713, 'Alphabetic').	% Mn   [2] TAGALOG VOWEL SIGN I..TAGALOG VOWEL SIGN U
unicode_core_property(0x1720, 0x1731, 'Alphabetic').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1732, 0x1733, 'Alphabetic').	% Mn   [2] HANUNOO VOWEL SIGN I..HANUNOO VOWEL SIGN U
unicode_core_property(0x1740, 0x1751, 'Alphabetic').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1752, 0x1753, 'Alphabetic').	% Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
unicode_core_property(0x1760, 0x176C, 'Alphabetic').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'Alphabetic').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1772, 0x1773, 'Alphabetic').	% Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
unicode_core_property(0x1780, 0x17B3, 'Alphabetic').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17B6, 0x17B6, 'Alphabetic').	% Mc       KHMER VOWEL SIGN AA
unicode_core_property(0x17B7, 0x17BD, 'Alphabetic').	% Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
unicode_core_property(0x17BE, 0x17C5, 'Alphabetic').	% Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
unicode_core_property(0x17C6, 0x17C6, 'Alphabetic').	% Mn       KHMER SIGN NIKAHIT
unicode_core_property(0x17C7, 0x17C8, 'Alphabetic').	% Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
unicode_core_property(0x17D7, 0x17D7, 'Alphabetic').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DC, 0x17DC, 'Alphabetic').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x1820, 0x1842, 'Alphabetic').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'Alphabetic').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'Alphabetic').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'Alphabetic').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18A9, 0x18A9, 'Alphabetic').	% Mn       MONGOLIAN LETTER ALI GALI DAGALGA
unicode_core_property(0x18AA, 0x18AA, 'Alphabetic').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'Alphabetic').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'Alphabetic').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1920, 0x1922, 'Alphabetic').	% Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
unicode_core_property(0x1923, 0x1926, 'Alphabetic').	% Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
unicode_core_property(0x1927, 0x1928, 'Alphabetic').	% Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
unicode_core_property(0x1929, 0x192B, 'Alphabetic').	% Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
unicode_core_property(0x1930, 0x1931, 'Alphabetic').	% Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
unicode_core_property(0x1932, 0x1932, 'Alphabetic').	% Mn       LIMBU SMALL LETTER ANUSVARA
unicode_core_property(0x1933, 0x1938, 'Alphabetic').	% Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
unicode_core_property(0x1950, 0x196D, 'Alphabetic').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'Alphabetic').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'Alphabetic').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19B0, 0x19C0, 'Alphabetic').	% Mc  [17] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE VOWEL SIGN IY
unicode_core_property(0x19C1, 0x19C7, 'Alphabetic').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x19C8, 0x19C9, 'Alphabetic').	% Mc   [2] NEW TAI LUE TONE MARK-1..NEW TAI LUE TONE MARK-2
unicode_core_property(0x1A00, 0x1A16, 'Alphabetic').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A17, 0x1A18, 'Alphabetic').	% Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
unicode_core_property(0x1A19, 0x1A1B, 'Alphabetic').	% Mc   [3] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN AE
unicode_core_property(0x1A20, 0x1A54, 'Alphabetic').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1A55, 0x1A55, 'Alphabetic').	% Mc       TAI THAM CONSONANT SIGN MEDIAL RA
unicode_core_property(0x1A56, 0x1A56, 'Alphabetic').	% Mn       TAI THAM CONSONANT SIGN MEDIAL LA
unicode_core_property(0x1A57, 0x1A57, 'Alphabetic').	% Mc       TAI THAM CONSONANT SIGN LA TANG LAI
unicode_core_property(0x1A58, 0x1A5E, 'Alphabetic').	% Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
unicode_core_property(0x1A61, 0x1A61, 'Alphabetic').	% Mc       TAI THAM VOWEL SIGN A
unicode_core_property(0x1A62, 0x1A62, 'Alphabetic').	% Mn       TAI THAM VOWEL SIGN MAI SAT
unicode_core_property(0x1A63, 0x1A64, 'Alphabetic').	% Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
unicode_core_property(0x1A65, 0x1A6C, 'Alphabetic').	% Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
unicode_core_property(0x1A6D, 0x1A72, 'Alphabetic').	% Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
unicode_core_property(0x1A73, 0x1A74, 'Alphabetic').	% Mn   [2] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN MAI KANG
unicode_core_property(0x1AA7, 0x1AA7, 'Alphabetic').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B00, 0x1B03, 'Alphabetic').	% Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
unicode_core_property(0x1B04, 0x1B04, 'Alphabetic').	% Mc       BALINESE SIGN BISAH
unicode_core_property(0x1B05, 0x1B33, 'Alphabetic').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B35, 0x1B35, 'Alphabetic').	% Mc       BALINESE VOWEL SIGN TEDUNG
unicode_core_property(0x1B36, 0x1B3A, 'Alphabetic').	% Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
unicode_core_property(0x1B3B, 0x1B3B, 'Alphabetic').	% Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
unicode_core_property(0x1B3C, 0x1B3C, 'Alphabetic').	% Mn       BALINESE VOWEL SIGN LA LENGA
unicode_core_property(0x1B3D, 0x1B41, 'Alphabetic').	% Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
unicode_core_property(0x1B42, 0x1B42, 'Alphabetic').	% Mn       BALINESE VOWEL SIGN PEPET
unicode_core_property(0x1B43, 0x1B43, 'Alphabetic').	% Mc       BALINESE VOWEL SIGN PEPET TEDUNG
unicode_core_property(0x1B45, 0x1B4B, 'Alphabetic').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B80, 0x1B81, 'Alphabetic').	% Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
unicode_core_property(0x1B82, 0x1B82, 'Alphabetic').	% Mc       SUNDANESE SIGN PANGWISAD
unicode_core_property(0x1B83, 0x1BA0, 'Alphabetic').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BA1, 0x1BA1, 'Alphabetic').	% Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
unicode_core_property(0x1BA2, 0x1BA5, 'Alphabetic').	% Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
unicode_core_property(0x1BA6, 0x1BA7, 'Alphabetic').	% Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
unicode_core_property(0x1BA8, 0x1BA9, 'Alphabetic').	% Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
unicode_core_property(0x1BAC, 0x1BAD, 'Alphabetic').	% Mc   [2] SUNDANESE CONSONANT SIGN PASANGAN MA..SUNDANESE CONSONANT SIGN PASANGAN WA
unicode_core_property(0x1BAE, 0x1BAF, 'Alphabetic').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BBA, 0x1BE5, 'Alphabetic').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1BE7, 0x1BE7, 'Alphabetic').	% Mc       BATAK VOWEL SIGN E
unicode_core_property(0x1BE8, 0x1BE9, 'Alphabetic').	% Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
unicode_core_property(0x1BEA, 0x1BEC, 'Alphabetic').	% Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
unicode_core_property(0x1BED, 0x1BED, 'Alphabetic').	% Mn       BATAK VOWEL SIGN KARO O
unicode_core_property(0x1BEE, 0x1BEE, 'Alphabetic').	% Mc       BATAK VOWEL SIGN U
unicode_core_property(0x1BEF, 0x1BF1, 'Alphabetic').	% Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
unicode_core_property(0x1C00, 0x1C23, 'Alphabetic').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C24, 0x1C2B, 'Alphabetic').	% Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
unicode_core_property(0x1C2C, 0x1C33, 'Alphabetic').	% Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
unicode_core_property(0x1C34, 0x1C35, 'Alphabetic').	% Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
unicode_core_property(0x1C4D, 0x1C4F, 'Alphabetic').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C5A, 0x1C77, 'Alphabetic').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'Alphabetic').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CE9, 0x1CEC, 'Alphabetic').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_core_property(0x1CEE, 0x1CF1, 'Alphabetic').	% Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_core_property(0x1CF2, 0x1CF3, 'Alphabetic').	% Mc   [2] VEDIC SIGN ARDHAVISARGA..VEDIC SIGN ROTATED ARDHAVISARGA
unicode_core_property(0x1CF5, 0x1CF6, 'Alphabetic').	% Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_core_property(0x1D00, 0x1D2B, 'Alphabetic').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'Alphabetic').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'Alphabetic').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'Alphabetic').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'Alphabetic').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'Alphabetic').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1E00, 0x1F15, 'Alphabetic').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'Alphabetic').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'Alphabetic').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'Alphabetic').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Alphabetic').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'Alphabetic').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Alphabetic').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Alphabetic').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'Alphabetic').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'Alphabetic').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'Alphabetic').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Alphabetic').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Alphabetic').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'Alphabetic').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Alphabetic').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'Alphabetic').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'Alphabetic').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'Alphabetic').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'Alphabetic').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2071, 0x2071, 'Alphabetic').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'Alphabetic').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'Alphabetic').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x2102, 0x2102, 'Alphabetic').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'Alphabetic').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'Alphabetic').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'Alphabetic').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2119, 0x211D, 'Alphabetic').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'Alphabetic').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'Alphabetic').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'Alphabetic').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'Alphabetic').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212F, 0x2134, 'Alphabetic').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'Alphabetic').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x2139, 0x2139, 'Alphabetic').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'Alphabetic').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'Alphabetic').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'Alphabetic').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x2182, 'Alphabetic').	% Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_core_property(0x2183, 0x2184, 'Alphabetic').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x2185, 0x2188, 'Alphabetic').	% Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_core_property(0x24B6, 0x24E9, 'Alphabetic').	% So  [52] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Alphabetic').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'Alphabetic').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'Alphabetic').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'Alphabetic').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'Alphabetic').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'Alphabetic').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF3, 'Alphabetic').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Alphabetic').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Alphabetic').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Alphabetic').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0x2D30, 0x2D67, 'Alphabetic').	% Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_core_property(0x2D6F, 0x2D6F, 'Alphabetic').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D80, 0x2D96, 'Alphabetic').	% Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_core_property(0x2DA0, 0x2DA6, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_core_property(0x2DA8, 0x2DAE, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_core_property(0x2DB0, 0x2DB6, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_core_property(0x2DB8, 0x2DBE, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_core_property(0x2DC0, 0x2DC6, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_core_property(0x2DC8, 0x2DCE, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_core_property(0x2DD0, 0x2DD6, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_core_property(0x2DD8, 0x2DDE, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_core_property(0x2DE0, 0x2DFF, 'Alphabetic').	% Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
unicode_core_property(0x2E2F, 0x2E2F, 'Alphabetic').	% Lm       VERTICAL TILDE
unicode_core_property(0x3005, 0x3005, 'Alphabetic').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3006, 0x3006, 'Alphabetic').	% Lo       IDEOGRAPHIC CLOSING MARK
unicode_core_property(0x3007, 0x3007, 'Alphabetic').	% Nl       IDEOGRAPHIC NUMBER ZERO
unicode_core_property(0x3021, 0x3029, 'Alphabetic').	% Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_core_property(0x3031, 0x3035, 'Alphabetic').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x3038, 0x303A, 'Alphabetic').	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_core_property(0x303B, 0x303B, 'Alphabetic').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x303C, 0x303C, 'Alphabetic').	% Lo       MASU MARK
unicode_core_property(0x3041, 0x3096, 'Alphabetic').	% Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_core_property(0x309D, 0x309E, 'Alphabetic').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x309F, 0x309F, 'Alphabetic').	% Lo       HIRAGANA DIGRAPH YORI
unicode_core_property(0x30A1, 0x30FA, 'Alphabetic').	% Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_core_property(0x30FC, 0x30FE, 'Alphabetic').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0x30FF, 0x30FF, 'Alphabetic').	% Lo       KATAKANA DIGRAPH KOTO
unicode_core_property(0x3105, 0x312D, 'Alphabetic').	% Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_core_property(0x3131, 0x318E, 'Alphabetic').	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_core_property(0x31A0, 0x31BA, 'Alphabetic').	% Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_core_property(0x31F0, 0x31FF, 'Alphabetic').	% Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_core_property(0x3400, 0x4DB5, 'Alphabetic').	% Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_core_property(0x4E00, 0x9FCC, 'Alphabetic').	% Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_core_property(0xA000, 0xA014, 'Alphabetic').	% Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_core_property(0xA015, 0xA015, 'Alphabetic').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA016, 0xA48C, 'Alphabetic').	% Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_core_property(0xA4D0, 0xA4F7, 'Alphabetic').	% Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_core_property(0xA4F8, 0xA4FD, 'Alphabetic').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA500, 0xA60B, 'Alphabetic').	% Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_core_property(0xA60C, 0xA60C, 'Alphabetic').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA610, 0xA61F, 'Alphabetic').	% Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_core_property(0xA62A, 0xA62B, 'Alphabetic').	% Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_core_property(0xA640, 0xA66D, 'Alphabetic').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA66E, 0xA66E, 'Alphabetic').	% Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_core_property(0xA674, 0xA67B, 'Alphabetic').	% Mn   [8] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC LETTER OMEGA
unicode_core_property(0xA67F, 0xA67F, 'Alphabetic').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA680, 0xA697, 'Alphabetic').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA69F, 0xA69F, 'Alphabetic').	% Mn       COMBINING CYRILLIC LETTER IOTIFIED E
unicode_core_property(0xA6A0, 0xA6E5, 'Alphabetic').	% Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_core_property(0xA6E6, 0xA6EF, 'Alphabetic').	% Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_core_property(0xA717, 0xA71F, 'Alphabetic').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA722, 0xA76F, 'Alphabetic').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'Alphabetic').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'Alphabetic').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA788, 0xA788, 'Alphabetic').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA78B, 0xA78E, 'Alphabetic').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'Alphabetic').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'Alphabetic').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'Alphabetic').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'Alphabetic').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xA7FB, 0xA801, 'Alphabetic').	% Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_core_property(0xA803, 0xA805, 'Alphabetic').	% Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_core_property(0xA807, 0xA80A, 'Alphabetic').	% Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_core_property(0xA80C, 0xA822, 'Alphabetic').	% Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_core_property(0xA823, 0xA824, 'Alphabetic').	% Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
unicode_core_property(0xA825, 0xA826, 'Alphabetic').	% Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
unicode_core_property(0xA827, 0xA827, 'Alphabetic').	% Mc       SYLOTI NAGRI VOWEL SIGN OO
unicode_core_property(0xA840, 0xA873, 'Alphabetic').	% Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_core_property(0xA880, 0xA881, 'Alphabetic').	% Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
unicode_core_property(0xA882, 0xA8B3, 'Alphabetic').	% Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_core_property(0xA8B4, 0xA8C3, 'Alphabetic').	% Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
unicode_core_property(0xA8F2, 0xA8F7, 'Alphabetic').	% Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_core_property(0xA8FB, 0xA8FB, 'Alphabetic').	% Lo       DEVANAGARI HEADSTROKE
unicode_core_property(0xA90A, 0xA925, 'Alphabetic').	% Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_core_property(0xA926, 0xA92A, 'Alphabetic').	% Mn   [5] KAYAH LI VOWEL UE..KAYAH LI VOWEL O
unicode_core_property(0xA930, 0xA946, 'Alphabetic').	% Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_core_property(0xA947, 0xA951, 'Alphabetic').	% Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
unicode_core_property(0xA952, 0xA952, 'Alphabetic').	% Mc       REJANG CONSONANT SIGN H
unicode_core_property(0xA960, 0xA97C, 'Alphabetic').	% Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_core_property(0xA980, 0xA982, 'Alphabetic').	% Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
unicode_core_property(0xA983, 0xA983, 'Alphabetic').	% Mc       JAVANESE SIGN WIGNYAN
unicode_core_property(0xA984, 0xA9B2, 'Alphabetic').	% Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_core_property(0xA9B4, 0xA9B5, 'Alphabetic').	% Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
unicode_core_property(0xA9B6, 0xA9B9, 'Alphabetic').	% Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
unicode_core_property(0xA9BA, 0xA9BB, 'Alphabetic').	% Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
unicode_core_property(0xA9BC, 0xA9BC, 'Alphabetic').	% Mn       JAVANESE VOWEL SIGN PEPET
unicode_core_property(0xA9BD, 0xA9BF, 'Alphabetic').	% Mc   [3] JAVANESE CONSONANT SIGN KERET..JAVANESE CONSONANT SIGN CAKRA
unicode_core_property(0xA9CF, 0xA9CF, 'Alphabetic').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xAA00, 0xAA28, 'Alphabetic').	% Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_core_property(0xAA29, 0xAA2E, 'Alphabetic').	% Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
unicode_core_property(0xAA2F, 0xAA30, 'Alphabetic').	% Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
unicode_core_property(0xAA31, 0xAA32, 'Alphabetic').	% Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
unicode_core_property(0xAA33, 0xAA34, 'Alphabetic').	% Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
unicode_core_property(0xAA35, 0xAA36, 'Alphabetic').	% Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
unicode_core_property(0xAA40, 0xAA42, 'Alphabetic').	% Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_core_property(0xAA43, 0xAA43, 'Alphabetic').	% Mn       CHAM CONSONANT SIGN FINAL NG
unicode_core_property(0xAA44, 0xAA4B, 'Alphabetic').	% Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_core_property(0xAA4C, 0xAA4C, 'Alphabetic').	% Mn       CHAM CONSONANT SIGN FINAL M
unicode_core_property(0xAA4D, 0xAA4D, 'Alphabetic').	% Mc       CHAM CONSONANT SIGN FINAL H
unicode_core_property(0xAA60, 0xAA6F, 'Alphabetic').	% Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_core_property(0xAA70, 0xAA70, 'Alphabetic').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAA71, 0xAA76, 'Alphabetic').	% Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_core_property(0xAA7A, 0xAA7A, 'Alphabetic').	% Lo       MYANMAR LETTER AITON RA
unicode_core_property(0xAA80, 0xAAAF, 'Alphabetic').	% Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_core_property(0xAAB0, 0xAAB0, 'Alphabetic').	% Mn       TAI VIET MAI KANG
unicode_core_property(0xAAB1, 0xAAB1, 'Alphabetic').	% Lo       TAI VIET VOWEL AA
unicode_core_property(0xAAB2, 0xAAB4, 'Alphabetic').	% Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
unicode_core_property(0xAAB5, 0xAAB6, 'Alphabetic').	% Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_core_property(0xAAB7, 0xAAB8, 'Alphabetic').	% Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
unicode_core_property(0xAAB9, 0xAABD, 'Alphabetic').	% Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_core_property(0xAABE, 0xAABE, 'Alphabetic').	% Mn       TAI VIET VOWEL AM
unicode_core_property(0xAAC0, 0xAAC0, 'Alphabetic').	% Lo       TAI VIET TONE MAI NUENG
unicode_core_property(0xAAC2, 0xAAC2, 'Alphabetic').	% Lo       TAI VIET TONE MAI SONG
unicode_core_property(0xAADB, 0xAADC, 'Alphabetic').	% Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_core_property(0xAADD, 0xAADD, 'Alphabetic').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAE0, 0xAAEA, 'Alphabetic').	% Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_core_property(0xAAEB, 0xAAEB, 'Alphabetic').	% Mc       MEETEI MAYEK VOWEL SIGN II
unicode_core_property(0xAAEC, 0xAAED, 'Alphabetic').	% Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
unicode_core_property(0xAAEE, 0xAAEF, 'Alphabetic').	% Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
unicode_core_property(0xAAF2, 0xAAF2, 'Alphabetic').	% Lo       MEETEI MAYEK ANJI
unicode_core_property(0xAAF3, 0xAAF4, 'Alphabetic').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAAF5, 0xAAF5, 'Alphabetic').	% Mc       MEETEI MAYEK VOWEL SIGN VISARGA
unicode_core_property(0xAB01, 0xAB06, 'Alphabetic').	% Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_core_property(0xAB09, 0xAB0E, 'Alphabetic').	% Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_core_property(0xAB11, 0xAB16, 'Alphabetic').	% Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_core_property(0xAB20, 0xAB26, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_core_property(0xAB28, 0xAB2E, 'Alphabetic').	% Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_core_property(0xABC0, 0xABE2, 'Alphabetic').	% Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_core_property(0xABE3, 0xABE4, 'Alphabetic').	% Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
unicode_core_property(0xABE5, 0xABE5, 'Alphabetic').	% Mn       MEETEI MAYEK VOWEL SIGN ANAP
unicode_core_property(0xABE6, 0xABE7, 'Alphabetic').	% Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
unicode_core_property(0xABE8, 0xABE8, 'Alphabetic').	% Mn       MEETEI MAYEK VOWEL SIGN UNAP
unicode_core_property(0xABE9, 0xABEA, 'Alphabetic').	% Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
unicode_core_property(0xAC00, 0xD7A3, 'Alphabetic').	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_core_property(0xD7B0, 0xD7C6, 'Alphabetic').	% Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_core_property(0xD7CB, 0xD7FB, 'Alphabetic').	% Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_core_property(0xF900, 0xFA6D, 'Alphabetic').	% Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_core_property(0xFA70, 0xFAD9, 'Alphabetic').	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_core_property(0xFB00, 0xFB06, 'Alphabetic').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Alphabetic').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFB1D, 0xFB1D, 'Alphabetic').	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_core_property(0xFB1E, 0xFB1E, 'Alphabetic').	% Mn       HEBREW POINT JUDEO-SPANISH VARIKA
unicode_core_property(0xFB1F, 0xFB28, 'Alphabetic').	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_core_property(0xFB2A, 0xFB36, 'Alphabetic').	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_core_property(0xFB38, 0xFB3C, 'Alphabetic').	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_core_property(0xFB3E, 0xFB3E, 'Alphabetic').	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_core_property(0xFB40, 0xFB41, 'Alphabetic').	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_core_property(0xFB43, 0xFB44, 'Alphabetic').	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_core_property(0xFB46, 0xFBB1, 'Alphabetic').	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_core_property(0xFBD3, 0xFD3D, 'Alphabetic').	% Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_core_property(0xFD50, 0xFD8F, 'Alphabetic').	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_core_property(0xFD92, 0xFDC7, 'Alphabetic').	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_core_property(0xFDF0, 0xFDFB, 'Alphabetic').	% Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
unicode_core_property(0xFE70, 0xFE74, 'Alphabetic').	% Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
unicode_core_property(0xFE76, 0xFEFC, 'Alphabetic').	% Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_core_property(0xFF21, 0xFF3A, 'Alphabetic').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF41, 0xFF5A, 'Alphabetic').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0xFF66, 0xFF6F, 'Alphabetic').	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_core_property(0xFF70, 0xFF70, 'Alphabetic').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF71, 0xFF9D, 'Alphabetic').	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_core_property(0xFF9E, 0xFF9F, 'Alphabetic').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0xFFA0, 0xFFBE, 'Alphabetic').	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_core_property(0xFFC2, 0xFFC7, 'Alphabetic').	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_core_property(0xFFCA, 0xFFCF, 'Alphabetic').	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_core_property(0xFFD2, 0xFFD7, 'Alphabetic').	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_core_property(0xFFDA, 0xFFDC, 'Alphabetic').	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_core_property(0x10000, 0x1000B, 'Alphabetic').	% Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_core_property(0x1000D, 0x10026, 'Alphabetic').	% Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_core_property(0x10028, 0x1003A, 'Alphabetic').	% Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_core_property(0x1003C, 0x1003D, 'Alphabetic').	% Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_core_property(0x1003F, 0x1004D, 'Alphabetic').	% Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_core_property(0x10050, 0x1005D, 'Alphabetic').	% Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_core_property(0x10080, 0x100FA, 'Alphabetic').	% Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_core_property(0x10140, 0x10174, 'Alphabetic').	% Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_core_property(0x10280, 0x1029C, 'Alphabetic').	% Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_core_property(0x102A0, 0x102D0, 'Alphabetic').	% Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_core_property(0x10300, 0x1031E, 'Alphabetic').	% Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_core_property(0x10330, 0x10340, 'Alphabetic').	% Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_core_property(0x10341, 0x10341, 'Alphabetic').	% Nl       GOTHIC LETTER NINETY
unicode_core_property(0x10342, 0x10349, 'Alphabetic').	% Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_core_property(0x1034A, 0x1034A, 'Alphabetic').	% Nl       GOTHIC LETTER NINE HUNDRED
unicode_core_property(0x10380, 0x1039D, 'Alphabetic').	% Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_core_property(0x103A0, 0x103C3, 'Alphabetic').	% Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_core_property(0x103C8, 0x103CF, 'Alphabetic').	% Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_core_property(0x103D1, 0x103D5, 'Alphabetic').	% Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_core_property(0x10400, 0x1044F, 'Alphabetic').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x10450, 0x1049D, 'Alphabetic').	% Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_core_property(0x10800, 0x10805, 'Alphabetic').	% Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_core_property(0x10808, 0x10808, 'Alphabetic').	% Lo       CYPRIOT SYLLABLE JO
unicode_core_property(0x1080A, 0x10835, 'Alphabetic').	% Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_core_property(0x10837, 0x10838, 'Alphabetic').	% Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_core_property(0x1083C, 0x1083C, 'Alphabetic').	% Lo       CYPRIOT SYLLABLE ZA
unicode_core_property(0x1083F, 0x10855, 'Alphabetic').	% Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_core_property(0x10900, 0x10915, 'Alphabetic').	% Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_core_property(0x10920, 0x10939, 'Alphabetic').	% Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_core_property(0x10980, 0x109B7, 'Alphabetic').	% Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_core_property(0x109BE, 0x109BF, 'Alphabetic').	% Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_core_property(0x10A00, 0x10A00, 'Alphabetic').	% Lo       KHAROSHTHI LETTER A
unicode_core_property(0x10A01, 0x10A03, 'Alphabetic').	% Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
unicode_core_property(0x10A05, 0x10A06, 'Alphabetic').	% Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
unicode_core_property(0x10A0C, 0x10A0F, 'Alphabetic').	% Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
unicode_core_property(0x10A10, 0x10A13, 'Alphabetic').	% Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_core_property(0x10A15, 0x10A17, 'Alphabetic').	% Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_core_property(0x10A19, 0x10A33, 'Alphabetic').	% Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_core_property(0x10A60, 0x10A7C, 'Alphabetic').	% Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_core_property(0x10B00, 0x10B35, 'Alphabetic').	% Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_core_property(0x10B40, 0x10B55, 'Alphabetic').	% Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_core_property(0x10B60, 0x10B72, 'Alphabetic').	% Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_core_property(0x10C00, 0x10C48, 'Alphabetic').	% Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_core_property(0x11000, 0x11000, 'Alphabetic').	% Mc       BRAHMI SIGN CANDRABINDU
unicode_core_property(0x11001, 0x11001, 'Alphabetic').	% Mn       BRAHMI SIGN ANUSVARA
unicode_core_property(0x11002, 0x11002, 'Alphabetic').	% Mc       BRAHMI SIGN VISARGA
unicode_core_property(0x11003, 0x11037, 'Alphabetic').	% Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_core_property(0x11038, 0x11045, 'Alphabetic').	% Mn  [14] BRAHMI VOWEL SIGN AA..BRAHMI VOWEL SIGN AU
unicode_core_property(0x11082, 0x11082, 'Alphabetic').	% Mc       KAITHI SIGN VISARGA
unicode_core_property(0x11083, 0x110AF, 'Alphabetic').	% Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_core_property(0x110B0, 0x110B2, 'Alphabetic').	% Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
unicode_core_property(0x110B3, 0x110B6, 'Alphabetic').	% Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
unicode_core_property(0x110B7, 0x110B8, 'Alphabetic').	% Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
unicode_core_property(0x110D0, 0x110E8, 'Alphabetic').	% Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_core_property(0x11100, 0x11102, 'Alphabetic').	% Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
unicode_core_property(0x11103, 0x11126, 'Alphabetic').	% Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_core_property(0x11127, 0x1112B, 'Alphabetic').	% Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
unicode_core_property(0x1112C, 0x1112C, 'Alphabetic').	% Mc       CHAKMA VOWEL SIGN E
unicode_core_property(0x1112D, 0x11132, 'Alphabetic').	% Mn   [6] CHAKMA VOWEL SIGN AI..CHAKMA AU MARK
unicode_core_property(0x11180, 0x11181, 'Alphabetic').	% Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
unicode_core_property(0x11182, 0x11182, 'Alphabetic').	% Mc       SHARADA SIGN VISARGA
unicode_core_property(0x11183, 0x111B2, 'Alphabetic').	% Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_core_property(0x111B3, 0x111B5, 'Alphabetic').	% Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
unicode_core_property(0x111B6, 0x111BE, 'Alphabetic').	% Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
unicode_core_property(0x111BF, 0x111BF, 'Alphabetic').	% Mc       SHARADA VOWEL SIGN AU
unicode_core_property(0x111C1, 0x111C4, 'Alphabetic').	% Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_core_property(0x11680, 0x116AA, 'Alphabetic').	% Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_core_property(0x116AB, 0x116AB, 'Alphabetic').	% Mn       TAKRI SIGN ANUSVARA
unicode_core_property(0x116AC, 0x116AC, 'Alphabetic').	% Mc       TAKRI SIGN VISARGA
unicode_core_property(0x116AD, 0x116AD, 'Alphabetic').	% Mn       TAKRI VOWEL SIGN AA
unicode_core_property(0x116AE, 0x116AF, 'Alphabetic').	% Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
unicode_core_property(0x116B0, 0x116B5, 'Alphabetic').	% Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
unicode_core_property(0x12000, 0x1236E, 'Alphabetic').	% Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_core_property(0x12400, 0x12462, 'Alphabetic').	% Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_core_property(0x13000, 0x1342E, 'Alphabetic').	% Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_core_property(0x16800, 0x16A38, 'Alphabetic').	% Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_core_property(0x16F00, 0x16F44, 'Alphabetic').	% Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_core_property(0x16F50, 0x16F50, 'Alphabetic').	% Lo       MIAO LETTER NASALIZATION
unicode_core_property(0x16F51, 0x16F7E, 'Alphabetic').	% Mc  [46] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN NG
unicode_core_property(0x16F93, 0x16F9F, 'Alphabetic').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1B000, 0x1B001, 'Alphabetic').	% Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_core_property(0x1D400, 0x1D454, 'Alphabetic').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'Alphabetic').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'Alphabetic').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'Alphabetic').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'Alphabetic').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'Alphabetic').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'Alphabetic').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'Alphabetic').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'Alphabetic').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'Alphabetic').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'Alphabetic').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'Alphabetic').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'Alphabetic').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'Alphabetic').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'Alphabetic').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'Alphabetic').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'Alphabetic').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'Alphabetic').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'Alphabetic').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'Alphabetic').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'Alphabetic').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'Alphabetic').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'Alphabetic').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'Alphabetic').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'Alphabetic').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'Alphabetic').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'Alphabetic').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'Alphabetic').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'Alphabetic').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'Alphabetic').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1EE00, 0x1EE03, 'Alphabetic').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'Alphabetic').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'Alphabetic').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'Alphabetic').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'Alphabetic').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'Alphabetic').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'Alphabetic').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'Alphabetic').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'Alphabetic').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'Alphabetic').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'Alphabetic').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'Alphabetic').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'Alphabetic').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'Alphabetic').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'Alphabetic').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'Alphabetic').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'Alphabetic').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'Alphabetic').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x20000, 0x2A6D6, 'Alphabetic').	% Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_core_property(0x2A700, 0x2B734, 'Alphabetic').	% Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_core_property(0x2B740, 0x2B81D, 'Alphabetic').	% Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_core_property(0x2F800, 0x2FA1D, 'Alphabetic').	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 102159

% ================================================

% Derived Property: Lowercase
%  Generated from: Ll + Other_Lowercase

unicode_core_property(0x0061, 0x007A, 'Lowercase').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'Lowercase').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'Lowercase').	% L&       MICRO SIGN
unicode_core_property(0x00BA, 0x00BA, 'Lowercase').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00DF, 0x00F6, 'Lowercase').	% L&  [24] LATIN SMALL LETTER SHARP S..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x00FF, 'Lowercase').	% L&   [8] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER Y WITH DIAERESIS
unicode_core_property(0x0101, 0x0101, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH MACRON
unicode_core_property(0x0103, 0x0103, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE
unicode_core_property(0x0105, 0x0105, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH OGONEK
unicode_core_property(0x0107, 0x0107, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH ACUTE
unicode_core_property(0x0109, 0x0109, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010B, 0x010B, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH DOT ABOVE
unicode_core_property(0x010D, 0x010D, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH CARON
unicode_core_property(0x010F, 0x010F, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH CARON
unicode_core_property(0x0111, 0x0111, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH STROKE
unicode_core_property(0x0113, 0x0113, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH MACRON
unicode_core_property(0x0115, 0x0115, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH BREVE
unicode_core_property(0x0117, 0x0117, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH DOT ABOVE
unicode_core_property(0x0119, 0x0119, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH OGONEK
unicode_core_property(0x011B, 0x011B, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CARON
unicode_core_property(0x011D, 0x011D, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011F, 0x011F, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH BREVE
unicode_core_property(0x0121, 0x0121, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH DOT ABOVE
unicode_core_property(0x0123, 0x0123, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH CEDILLA
unicode_core_property(0x0125, 0x0125, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0127, 0x0127, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH STROKE
unicode_core_property(0x0129, 0x0129, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH TILDE
unicode_core_property(0x012B, 0x012B, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH MACRON
unicode_core_property(0x012D, 0x012D, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH BREVE
unicode_core_property(0x012F, 0x012F, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH OGONEK
unicode_core_property(0x0131, 0x0131, 'Lowercase').	% L&       LATIN SMALL LETTER DOTLESS I
unicode_core_property(0x0133, 0x0133, 'Lowercase').	% L&       LATIN SMALL LIGATURE IJ
unicode_core_property(0x0135, 0x0135, 'Lowercase').	% L&       LATIN SMALL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0137, 0x0138, 'Lowercase').	% L&   [2] LATIN SMALL LETTER K WITH CEDILLA..LATIN SMALL LETTER KRA
unicode_core_property(0x013A, 0x013A, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH ACUTE
unicode_core_property(0x013C, 0x013C, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH CEDILLA
unicode_core_property(0x013E, 0x013E, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH CARON
unicode_core_property(0x0140, 0x0140, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0142, 0x0142, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH STROKE
unicode_core_property(0x0144, 0x0144, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH ACUTE
unicode_core_property(0x0146, 0x0146, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH CEDILLA
unicode_core_property(0x0148, 0x0149, 'Lowercase').	% L&   [2] LATIN SMALL LETTER N WITH CARON..LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
unicode_core_property(0x014B, 0x014B, 'Lowercase').	% L&       LATIN SMALL LETTER ENG
unicode_core_property(0x014D, 0x014D, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH MACRON
unicode_core_property(0x014F, 0x014F, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH BREVE
unicode_core_property(0x0151, 0x0151, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0153, 0x0153, 'Lowercase').	% L&       LATIN SMALL LIGATURE OE
unicode_core_property(0x0155, 0x0155, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH ACUTE
unicode_core_property(0x0157, 0x0157, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH CEDILLA
unicode_core_property(0x0159, 0x0159, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH CARON
unicode_core_property(0x015B, 0x015B, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH ACUTE
unicode_core_property(0x015D, 0x015D, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015F, 0x015F, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH CEDILLA
unicode_core_property(0x0161, 0x0161, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH CARON
unicode_core_property(0x0163, 0x0163, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH CEDILLA
unicode_core_property(0x0165, 0x0165, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH CARON
unicode_core_property(0x0167, 0x0167, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH STROKE
unicode_core_property(0x0169, 0x0169, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH TILDE
unicode_core_property(0x016B, 0x016B, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH MACRON
unicode_core_property(0x016D, 0x016D, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH BREVE
unicode_core_property(0x016F, 0x016F, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH RING ABOVE
unicode_core_property(0x0171, 0x0171, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0173, 0x0173, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH OGONEK
unicode_core_property(0x0175, 0x0175, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0177, 0x0177, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x017A, 0x017A, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH ACUTE
unicode_core_property(0x017C, 0x017C, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017E, 0x0180, 'Lowercase').	% L&   [3] LATIN SMALL LETTER Z WITH CARON..LATIN SMALL LETTER B WITH STROKE
unicode_core_property(0x0183, 0x0183, 'Lowercase').	% L&       LATIN SMALL LETTER B WITH TOPBAR
unicode_core_property(0x0185, 0x0185, 'Lowercase').	% L&       LATIN SMALL LETTER TONE SIX
unicode_core_property(0x0188, 0x0188, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH HOOK
unicode_core_property(0x018C, 0x018D, 'Lowercase').	% L&   [2] LATIN SMALL LETTER D WITH TOPBAR..LATIN SMALL LETTER TURNED DELTA
unicode_core_property(0x0192, 0x0192, 'Lowercase').	% L&       LATIN SMALL LETTER F WITH HOOK
unicode_core_property(0x0195, 0x0195, 'Lowercase').	% L&       LATIN SMALL LETTER HV
unicode_core_property(0x0199, 0x019B, 'Lowercase').	% L&   [3] LATIN SMALL LETTER K WITH HOOK..LATIN SMALL LETTER LAMBDA WITH STROKE
unicode_core_property(0x019E, 0x019E, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x01A1, 0x01A1, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN
unicode_core_property(0x01A3, 0x01A3, 'Lowercase').	% L&       LATIN SMALL LETTER OI
unicode_core_property(0x01A5, 0x01A5, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH HOOK
unicode_core_property(0x01A8, 0x01A8, 'Lowercase').	% L&       LATIN SMALL LETTER TONE TWO
unicode_core_property(0x01AA, 0x01AB, 'Lowercase').	% L&   [2] LATIN LETTER REVERSED ESH LOOP..LATIN SMALL LETTER T WITH PALATAL HOOK
unicode_core_property(0x01AD, 0x01AD, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH HOOK
unicode_core_property(0x01B0, 0x01B0, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN
unicode_core_property(0x01B4, 0x01B4, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH HOOK
unicode_core_property(0x01B6, 0x01B6, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH STROKE
unicode_core_property(0x01B9, 0x01BA, 'Lowercase').	% L&   [2] LATIN SMALL LETTER EZH REVERSED..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BD, 0x01BF, 'Lowercase').	% L&   [3] LATIN SMALL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C6, 0x01C6, 'Lowercase').	% L&       LATIN SMALL LETTER DZ WITH CARON
unicode_core_property(0x01C9, 0x01C9, 'Lowercase').	% L&       LATIN SMALL LETTER LJ
unicode_core_property(0x01CC, 0x01CC, 'Lowercase').	% L&       LATIN SMALL LETTER NJ
unicode_core_property(0x01CE, 0x01CE, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CARON
unicode_core_property(0x01D0, 0x01D0, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH CARON
unicode_core_property(0x01D2, 0x01D2, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CARON
unicode_core_property(0x01D4, 0x01D4, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH CARON
unicode_core_property(0x01D6, 0x01D6, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D8, 0x01D8, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01DA, 0x01DA, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DC, 0x01DD, 'Lowercase').	% L&   [2] LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE..LATIN SMALL LETTER TURNED E
unicode_core_property(0x01DF, 0x01DF, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E1, 0x01E1, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E3, 0x01E3, 'Lowercase').	% L&       LATIN SMALL LETTER AE WITH MACRON
unicode_core_property(0x01E5, 0x01E5, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH STROKE
unicode_core_property(0x01E7, 0x01E7, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH CARON
unicode_core_property(0x01E9, 0x01E9, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH CARON
unicode_core_property(0x01EB, 0x01EB, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH OGONEK
unicode_core_property(0x01ED, 0x01ED, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EF, 0x01F0, 'Lowercase').	% L&   [2] LATIN SMALL LETTER EZH WITH CARON..LATIN SMALL LETTER J WITH CARON
unicode_core_property(0x01F3, 0x01F3, 'Lowercase').	% L&       LATIN SMALL LETTER DZ
unicode_core_property(0x01F5, 0x01F5, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH ACUTE
unicode_core_property(0x01F9, 0x01F9, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH GRAVE
unicode_core_property(0x01FB, 0x01FB, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FD, 0x01FD, 'Lowercase').	% L&       LATIN SMALL LETTER AE WITH ACUTE
unicode_core_property(0x01FF, 0x01FF, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0201, 0x0201, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0203, 0x0203, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0205, 0x0205, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0207, 0x0207, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0209, 0x0209, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020B, 0x020B, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020D, 0x020D, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020F, 0x020F, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0211, 0x0211, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0213, 0x0213, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0215, 0x0215, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0217, 0x0217, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0219, 0x0219, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH COMMA BELOW
unicode_core_property(0x021B, 0x021B, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH COMMA BELOW
unicode_core_property(0x021D, 0x021D, 'Lowercase').	% L&       LATIN SMALL LETTER YOGH
unicode_core_property(0x021F, 0x021F, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH CARON
unicode_core_property(0x0221, 0x0221, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH CURL
unicode_core_property(0x0223, 0x0223, 'Lowercase').	% L&       LATIN SMALL LETTER OU
unicode_core_property(0x0225, 0x0225, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH HOOK
unicode_core_property(0x0227, 0x0227, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE
unicode_core_property(0x0229, 0x0229, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CEDILLA
unicode_core_property(0x022B, 0x022B, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022D, 0x022D, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022F, 0x022F, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE
unicode_core_property(0x0231, 0x0231, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0233, 0x0239, 'Lowercase').	% L&   [7] LATIN SMALL LETTER Y WITH MACRON..LATIN SMALL LETTER QP DIGRAPH
unicode_core_property(0x023C, 0x023C, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH STROKE
unicode_core_property(0x023F, 0x0240, 'Lowercase').	% L&   [2] LATIN SMALL LETTER S WITH SWASH TAIL..LATIN SMALL LETTER Z WITH SWASH TAIL
unicode_core_property(0x0242, 0x0242, 'Lowercase').	% L&       LATIN SMALL LETTER GLOTTAL STOP
unicode_core_property(0x0247, 0x0247, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH STROKE
unicode_core_property(0x0249, 0x0249, 'Lowercase').	% L&       LATIN SMALL LETTER J WITH STROKE
unicode_core_property(0x024B, 0x024B, 'Lowercase').	% L&       LATIN SMALL LETTER Q WITH HOOK TAIL
unicode_core_property(0x024D, 0x024D, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH STROKE
unicode_core_property(0x024F, 0x0293, 'Lowercase').	% L&  [69] LATIN SMALL LETTER Y WITH STROKE..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0295, 0x02AF, 'Lowercase').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02B8, 'Lowercase').	% Lm   [9] MODIFIER LETTER SMALL H..MODIFIER LETTER SMALL Y
unicode_core_property(0x02C0, 0x02C1, 'Lowercase').	% Lm   [2] MODIFIER LETTER GLOTTAL STOP..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02E0, 0x02E4, 'Lowercase').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x0345, 0x0345, 'Lowercase').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0371, 0x0371, 'Lowercase').	% L&       GREEK SMALL LETTER HETA
unicode_core_property(0x0373, 0x0373, 'Lowercase').	% L&       GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0377, 0x0377, 'Lowercase').	% L&       GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'Lowercase').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'Lowercase').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0390, 0x0390, 'Lowercase').	% L&       GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
unicode_core_property(0x03AC, 0x03CE, 'Lowercase').	% L&  [35] GREEK SMALL LETTER ALPHA WITH TONOS..GREEK SMALL LETTER OMEGA WITH TONOS
unicode_core_property(0x03D0, 0x03D1, 'Lowercase').	% L&   [2] GREEK BETA SYMBOL..GREEK THETA SYMBOL
unicode_core_property(0x03D5, 0x03D7, 'Lowercase').	% L&   [3] GREEK PHI SYMBOL..GREEK KAI SYMBOL
unicode_core_property(0x03D9, 0x03D9, 'Lowercase').	% L&       GREEK SMALL LETTER ARCHAIC KOPPA
unicode_core_property(0x03DB, 0x03DB, 'Lowercase').	% L&       GREEK SMALL LETTER STIGMA
unicode_core_property(0x03DD, 0x03DD, 'Lowercase').	% L&       GREEK SMALL LETTER DIGAMMA
unicode_core_property(0x03DF, 0x03DF, 'Lowercase').	% L&       GREEK SMALL LETTER KOPPA
unicode_core_property(0x03E1, 0x03E1, 'Lowercase').	% L&       GREEK SMALL LETTER SAMPI
unicode_core_property(0x03E3, 0x03E3, 'Lowercase').	% L&       COPTIC SMALL LETTER SHEI
unicode_core_property(0x03E5, 0x03E5, 'Lowercase').	% L&       COPTIC SMALL LETTER FEI
unicode_core_property(0x03E7, 0x03E7, 'Lowercase').	% L&       COPTIC SMALL LETTER KHEI
unicode_core_property(0x03E9, 0x03E9, 'Lowercase').	% L&       COPTIC SMALL LETTER HORI
unicode_core_property(0x03EB, 0x03EB, 'Lowercase').	% L&       COPTIC SMALL LETTER GANGIA
unicode_core_property(0x03ED, 0x03ED, 'Lowercase').	% L&       COPTIC SMALL LETTER SHIMA
unicode_core_property(0x03EF, 0x03F3, 'Lowercase').	% L&   [5] COPTIC SMALL LETTER DEI..GREEK LETTER YOT
unicode_core_property(0x03F5, 0x03F5, 'Lowercase').	% L&       GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F8, 0x03F8, 'Lowercase').	% L&       GREEK SMALL LETTER SHO
unicode_core_property(0x03FB, 0x03FC, 'Lowercase').	% L&   [2] GREEK SMALL LETTER SAN..GREEK RHO WITH STROKE SYMBOL
unicode_core_property(0x0430, 0x045F, 'Lowercase').	% L&  [48] CYRILLIC SMALL LETTER A..CYRILLIC SMALL LETTER DZHE
unicode_core_property(0x0461, 0x0461, 'Lowercase').	% L&       CYRILLIC SMALL LETTER OMEGA
unicode_core_property(0x0463, 0x0463, 'Lowercase').	% L&       CYRILLIC SMALL LETTER YAT
unicode_core_property(0x0465, 0x0465, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED E
unicode_core_property(0x0467, 0x0467, 'Lowercase').	% L&       CYRILLIC SMALL LETTER LITTLE YUS
unicode_core_property(0x0469, 0x0469, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046B, 0x046B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BIG YUS
unicode_core_property(0x046D, 0x046D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046F, 0x046F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KSI
unicode_core_property(0x0471, 0x0471, 'Lowercase').	% L&       CYRILLIC SMALL LETTER PSI
unicode_core_property(0x0473, 0x0473, 'Lowercase').	% L&       CYRILLIC SMALL LETTER FITA
unicode_core_property(0x0475, 0x0475, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IZHITSA
unicode_core_property(0x0477, 0x0477, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0479, 0x0479, 'Lowercase').	% L&       CYRILLIC SMALL LETTER UK
unicode_core_property(0x047B, 0x047B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ROUND OMEGA
unicode_core_property(0x047D, 0x047D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER OMEGA WITH TITLO
unicode_core_property(0x047F, 0x047F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER OT
unicode_core_property(0x0481, 0x0481, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048B, 0x048B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SHORT I WITH TAIL
unicode_core_property(0x048D, 0x048D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SEMISOFT SIGN
unicode_core_property(0x048F, 0x048F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ER WITH TICK
unicode_core_property(0x0491, 0x0491, 'Lowercase').	% L&       CYRILLIC SMALL LETTER GHE WITH UPTURN
unicode_core_property(0x0493, 0x0493, 'Lowercase').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE
unicode_core_property(0x0495, 0x0495, 'Lowercase').	% L&       CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0497, 0x0497, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0499, 0x0499, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZE WITH DESCENDER
unicode_core_property(0x049B, 0x049B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KA WITH DESCENDER
unicode_core_property(0x049D, 0x049D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049F, 0x049F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KA WITH STROKE
unicode_core_property(0x04A1, 0x04A1, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BASHKIR KA
unicode_core_property(0x04A3, 0x04A3, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EN WITH DESCENDER
unicode_core_property(0x04A5, 0x04A5, 'Lowercase').	% L&       CYRILLIC SMALL LIGATURE EN GHE
unicode_core_property(0x04A7, 0x04A7, 'Lowercase').	% L&       CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A9, 0x04A9, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ABKHASIAN HA
unicode_core_property(0x04AB, 0x04AB, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ES WITH DESCENDER
unicode_core_property(0x04AD, 0x04AD, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TE WITH DESCENDER
unicode_core_property(0x04AF, 0x04AF, 'Lowercase').	% L&       CYRILLIC SMALL LETTER STRAIGHT U
unicode_core_property(0x04B1, 0x04B1, 'Lowercase').	% L&       CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B3, 0x04B3, 'Lowercase').	% L&       CYRILLIC SMALL LETTER HA WITH DESCENDER
unicode_core_property(0x04B5, 0x04B5, 'Lowercase').	% L&       CYRILLIC SMALL LIGATURE TE TSE
unicode_core_property(0x04B7, 0x04B7, 'Lowercase').	% L&       CYRILLIC SMALL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B9, 0x04B9, 'Lowercase').	% L&       CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BB, 0x04BB, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SHHA
unicode_core_property(0x04BD, 0x04BD, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE
unicode_core_property(0x04BF, 0x04BF, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C2, 0x04C2, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZHE WITH BREVE
unicode_core_property(0x04C4, 0x04C4, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KA WITH HOOK
unicode_core_property(0x04C6, 0x04C6, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EL WITH TAIL
unicode_core_property(0x04C8, 0x04C8, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EN WITH HOOK
unicode_core_property(0x04CA, 0x04CA, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EN WITH TAIL
unicode_core_property(0x04CC, 0x04CC, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CE, 0x04CF, 'Lowercase').	% L&   [2] CYRILLIC SMALL LETTER EM WITH TAIL..CYRILLIC SMALL LETTER PALOCHKA
unicode_core_property(0x04D1, 0x04D1, 'Lowercase').	% L&       CYRILLIC SMALL LETTER A WITH BREVE
unicode_core_property(0x04D3, 0x04D3, 'Lowercase').	% L&       CYRILLIC SMALL LETTER A WITH DIAERESIS
unicode_core_property(0x04D5, 0x04D5, 'Lowercase').	% L&       CYRILLIC SMALL LIGATURE A IE
unicode_core_property(0x04D7, 0x04D7, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IE WITH BREVE
unicode_core_property(0x04D9, 0x04D9, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SCHWA
unicode_core_property(0x04DB, 0x04DB, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DD, 0x04DD, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DF, 0x04DF, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E1, 0x04E1, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ABKHASIAN DZE
unicode_core_property(0x04E3, 0x04E3, 'Lowercase').	% L&       CYRILLIC SMALL LETTER I WITH MACRON
unicode_core_property(0x04E5, 0x04E5, 'Lowercase').	% L&       CYRILLIC SMALL LETTER I WITH DIAERESIS
unicode_core_property(0x04E7, 0x04E7, 'Lowercase').	% L&       CYRILLIC SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x04E9, 0x04E9, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BARRED O
unicode_core_property(0x04EB, 0x04EB, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04ED, 0x04ED, 'Lowercase').	% L&       CYRILLIC SMALL LETTER E WITH DIAERESIS
unicode_core_property(0x04EF, 0x04EF, 'Lowercase').	% L&       CYRILLIC SMALL LETTER U WITH MACRON
unicode_core_property(0x04F1, 0x04F1, 'Lowercase').	% L&       CYRILLIC SMALL LETTER U WITH DIAERESIS
unicode_core_property(0x04F3, 0x04F3, 'Lowercase').	% L&       CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F5, 0x04F5, 'Lowercase').	% L&       CYRILLIC SMALL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F7, 0x04F7, 'Lowercase').	% L&       CYRILLIC SMALL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F9, 0x04F9, 'Lowercase').	% L&       CYRILLIC SMALL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FB, 0x04FB, 'Lowercase').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FD, 0x04FD, 'Lowercase').	% L&       CYRILLIC SMALL LETTER HA WITH HOOK
unicode_core_property(0x04FF, 0x04FF, 'Lowercase').	% L&       CYRILLIC SMALL LETTER HA WITH STROKE
unicode_core_property(0x0501, 0x0501, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI DE
unicode_core_property(0x0503, 0x0503, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI DJE
unicode_core_property(0x0505, 0x0505, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI ZJE
unicode_core_property(0x0507, 0x0507, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI DZJE
unicode_core_property(0x0509, 0x0509, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI LJE
unicode_core_property(0x050B, 0x050B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI NJE
unicode_core_property(0x050D, 0x050D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI SJE
unicode_core_property(0x050F, 0x050F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER KOMI TJE
unicode_core_property(0x0511, 0x0511, 'Lowercase').	% L&       CYRILLIC SMALL LETTER REVERSED ZE
unicode_core_property(0x0513, 0x0513, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EL WITH HOOK
unicode_core_property(0x0515, 0x0515, 'Lowercase').	% L&       CYRILLIC SMALL LETTER LHA
unicode_core_property(0x0517, 0x0517, 'Lowercase').	% L&       CYRILLIC SMALL LETTER RHA
unicode_core_property(0x0519, 0x0519, 'Lowercase').	% L&       CYRILLIC SMALL LETTER YAE
unicode_core_property(0x051B, 0x051B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER QA
unicode_core_property(0x051D, 0x051D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER WE
unicode_core_property(0x051F, 0x051F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ALEUT KA
unicode_core_property(0x0521, 0x0521, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0523, 0x0523, 'Lowercase').	% L&       CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0525, 0x0525, 'Lowercase').	% L&       CYRILLIC SMALL LETTER PE WITH DESCENDER
unicode_core_property(0x0527, 0x0527, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0561, 0x0587, 'Lowercase').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x1D00, 0x1D2B, 'Lowercase').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'Lowercase').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'Lowercase').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'Lowercase').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'Lowercase').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'Lowercase').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1E01, 0x1E01, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH RING BELOW
unicode_core_property(0x1E03, 0x1E03, 'Lowercase').	% L&       LATIN SMALL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E05, 0x1E05, 'Lowercase').	% L&       LATIN SMALL LETTER B WITH DOT BELOW
unicode_core_property(0x1E07, 0x1E07, 'Lowercase').	% L&       LATIN SMALL LETTER B WITH LINE BELOW
unicode_core_property(0x1E09, 0x1E09, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0B, 0x1E0B, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0D, 0x1E0D, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0F, 0x1E0F, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH LINE BELOW
unicode_core_property(0x1E11, 0x1E11, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH CEDILLA
unicode_core_property(0x1E13, 0x1E13, 'Lowercase').	% L&       LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E15, 0x1E15, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E17, 0x1E17, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E19, 0x1E19, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1B, 0x1E1B, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1D, 0x1E1D, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1F, 0x1E1F, 'Lowercase').	% L&       LATIN SMALL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E21, 0x1E21, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH MACRON
unicode_core_property(0x1E23, 0x1E23, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E25, 0x1E25, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH DOT BELOW
unicode_core_property(0x1E27, 0x1E27, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH DIAERESIS
unicode_core_property(0x1E29, 0x1E29, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH CEDILLA
unicode_core_property(0x1E2B, 0x1E2B, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2D, 0x1E2D, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2F, 0x1E2F, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E31, 0x1E31, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH ACUTE
unicode_core_property(0x1E33, 0x1E33, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH DOT BELOW
unicode_core_property(0x1E35, 0x1E35, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH LINE BELOW
unicode_core_property(0x1E37, 0x1E37, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH DOT BELOW
unicode_core_property(0x1E39, 0x1E39, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3B, 0x1E3B, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3D, 0x1E3D, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3F, 0x1E3F, 'Lowercase').	% L&       LATIN SMALL LETTER M WITH ACUTE
unicode_core_property(0x1E41, 0x1E41, 'Lowercase').	% L&       LATIN SMALL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E43, 0x1E43, 'Lowercase').	% L&       LATIN SMALL LETTER M WITH DOT BELOW
unicode_core_property(0x1E45, 0x1E45, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E47, 0x1E47, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH DOT BELOW
unicode_core_property(0x1E49, 0x1E49, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4B, 0x1E4B, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4D, 0x1E4D, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4F, 0x1E4F, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E51, 0x1E51, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E53, 0x1E53, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E55, 0x1E55, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH ACUTE
unicode_core_property(0x1E57, 0x1E57, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E59, 0x1E59, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5B, 0x1E5B, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5D, 0x1E5D, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5F, 0x1E5F, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH LINE BELOW
unicode_core_property(0x1E61, 0x1E61, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E63, 0x1E63, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH DOT BELOW
unicode_core_property(0x1E65, 0x1E65, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E67, 0x1E67, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E69, 0x1E69, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6B, 0x1E6B, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6D, 0x1E6D, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6F, 0x1E6F, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH LINE BELOW
unicode_core_property(0x1E71, 0x1E71, 'Lowercase').	% L&       LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E73, 0x1E73, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E75, 0x1E75, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E77, 0x1E77, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E79, 0x1E79, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7B, 0x1E7B, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7D, 0x1E7D, 'Lowercase').	% L&       LATIN SMALL LETTER V WITH TILDE
unicode_core_property(0x1E7F, 0x1E7F, 'Lowercase').	% L&       LATIN SMALL LETTER V WITH DOT BELOW
unicode_core_property(0x1E81, 0x1E81, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH GRAVE
unicode_core_property(0x1E83, 0x1E83, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH ACUTE
unicode_core_property(0x1E85, 0x1E85, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH DIAERESIS
unicode_core_property(0x1E87, 0x1E87, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E89, 0x1E89, 'Lowercase').	% L&       LATIN SMALL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8B, 0x1E8B, 'Lowercase').	% L&       LATIN SMALL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8D, 0x1E8D, 'Lowercase').	% L&       LATIN SMALL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8F, 0x1E8F, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E91, 0x1E91, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E93, 0x1E93, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E95, 0x1E9D, 'Lowercase').	% L&   [9] LATIN SMALL LETTER Z WITH LINE BELOW..LATIN SMALL LETTER LONG S WITH HIGH STROKE
unicode_core_property(0x1E9F, 0x1E9F, 'Lowercase').	% L&       LATIN SMALL LETTER DELTA
unicode_core_property(0x1EA1, 0x1EA1, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA3, 0x1EA3, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA5, 0x1EA5, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA7, 0x1EA7, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA9, 0x1EA9, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAB, 0x1EAB, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAD, 0x1EAD, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAF, 0x1EAF, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB1, 0x1EB1, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB3, 0x1EB3, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB5, 0x1EB5, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB7, 0x1EB7, 'Lowercase').	% L&       LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB9, 0x1EB9, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBB, 0x1EBB, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBD, 0x1EBD, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH TILDE
unicode_core_property(0x1EBF, 0x1EBF, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC1, 0x1EC1, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC3, 0x1EC3, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC5, 0x1EC5, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC7, 0x1EC7, 'Lowercase').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC9, 0x1EC9, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECB, 0x1ECB, 'Lowercase').	% L&       LATIN SMALL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECD, 0x1ECD, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECF, 0x1ECF, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED1, 0x1ED1, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED3, 0x1ED3, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED5, 0x1ED5, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED7, 0x1ED7, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED9, 0x1ED9, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDB, 0x1EDB, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDD, 0x1EDD, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDF, 0x1EDF, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE1, 0x1EE1, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE3, 0x1EE3, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE5, 0x1EE5, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE7, 0x1EE7, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE9, 0x1EE9, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEB, 0x1EEB, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EED, 0x1EED, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEF, 0x1EEF, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF1, 0x1EF1, 'Lowercase').	% L&       LATIN SMALL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF3, 0x1EF3, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH GRAVE
unicode_core_property(0x1EF5, 0x1EF5, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF7, 0x1EF7, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF9, 0x1EF9, 'Lowercase').	% L&       LATIN SMALL LETTER Y WITH TILDE
unicode_core_property(0x1EFB, 0x1EFB, 'Lowercase').	% L&       LATIN SMALL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFD, 0x1EFD, 'Lowercase').	% L&       LATIN SMALL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFF, 0x1F07, 'Lowercase').	% L&   [9] LATIN SMALL LETTER Y WITH LOOP..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F10, 0x1F15, 'Lowercase').	% L&   [6] GREEK SMALL LETTER EPSILON WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F27, 'Lowercase').	% L&   [8] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F30, 0x1F37, 'Lowercase').	% L&   [8] GREEK SMALL LETTER IOTA WITH PSILI..GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F40, 0x1F45, 'Lowercase').	% L&   [6] GREEK SMALL LETTER OMICRON WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Lowercase').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F60, 0x1F67, 'Lowercase').	% L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F70, 0x1F7D, 'Lowercase').	% L&  [14] GREEK SMALL LETTER ALPHA WITH VARIA..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1F87, 'Lowercase').	% L&   [8] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1F90, 0x1F97, 'Lowercase').	% L&   [8] GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FA0, 0x1FA7, 'Lowercase').	% L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FB0, 0x1FB4, 'Lowercase').	% L&   [5] GREEK SMALL LETTER ALPHA WITH VRACHY..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FB7, 'Lowercase').	% L&   [2] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Lowercase').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Lowercase').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FC7, 'Lowercase').	% L&   [2] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Lowercase').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FD7, 'Lowercase').	% L&   [2] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FE0, 0x1FE7, 'Lowercase').	% L&   [8] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FF2, 0x1FF4, 'Lowercase').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FF7, 'Lowercase').	% L&   [2] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x2071, 0x2071, 'Lowercase').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'Lowercase').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'Lowercase').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x210A, 0x210A, 'Lowercase').	% L&       SCRIPT SMALL G
unicode_core_property(0x210E, 0x210F, 'Lowercase').	% L&   [2] PLANCK CONSTANT..PLANCK CONSTANT OVER TWO PI
unicode_core_property(0x2113, 0x2113, 'Lowercase').	% L&       SCRIPT SMALL L
unicode_core_property(0x212F, 0x212F, 'Lowercase').	% L&       SCRIPT SMALL E
unicode_core_property(0x2134, 0x2134, 'Lowercase').	% L&       SCRIPT SMALL O
unicode_core_property(0x2139, 0x2139, 'Lowercase').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213D, 'Lowercase').	% L&   [2] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK SMALL GAMMA
unicode_core_property(0x2146, 0x2149, 'Lowercase').	% L&   [4] DOUBLE-STRUCK ITALIC SMALL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'Lowercase').	% L&       TURNED SMALL F
unicode_core_property(0x2170, 0x217F, 'Lowercase').	% Nl  [16] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2184, 0x2184, 'Lowercase').	% L&       LATIN SMALL LETTER REVERSED C
unicode_core_property(0x24D0, 0x24E9, 'Lowercase').	% So  [26] CIRCLED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C30, 0x2C5E, 'Lowercase').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C61, 0x2C61, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C65, 0x2C66, 'Lowercase').	% L&   [2] LATIN SMALL LETTER A WITH STROKE..LATIN SMALL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x2C68, 0x2C68, 'Lowercase').	% L&       LATIN SMALL LETTER H WITH DESCENDER
unicode_core_property(0x2C6A, 0x2C6A, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH DESCENDER
unicode_core_property(0x2C6C, 0x2C6C, 'Lowercase').	% L&       LATIN SMALL LETTER Z WITH DESCENDER
unicode_core_property(0x2C71, 0x2C71, 'Lowercase').	% L&       LATIN SMALL LETTER V WITH RIGHT HOOK
unicode_core_property(0x2C73, 0x2C74, 'Lowercase').	% L&   [2] LATIN SMALL LETTER W WITH HOOK..LATIN SMALL LETTER V WITH CURL
unicode_core_property(0x2C76, 0x2C7B, 'Lowercase').	% L&   [6] LATIN SMALL LETTER HALF H..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'Lowercase').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C81, 0x2C81, 'Lowercase').	% L&       COPTIC SMALL LETTER ALFA
unicode_core_property(0x2C83, 0x2C83, 'Lowercase').	% L&       COPTIC SMALL LETTER VIDA
unicode_core_property(0x2C85, 0x2C85, 'Lowercase').	% L&       COPTIC SMALL LETTER GAMMA
unicode_core_property(0x2C87, 0x2C87, 'Lowercase').	% L&       COPTIC SMALL LETTER DALDA
unicode_core_property(0x2C89, 0x2C89, 'Lowercase').	% L&       COPTIC SMALL LETTER EIE
unicode_core_property(0x2C8B, 0x2C8B, 'Lowercase').	% L&       COPTIC SMALL LETTER SOU
unicode_core_property(0x2C8D, 0x2C8D, 'Lowercase').	% L&       COPTIC SMALL LETTER ZATA
unicode_core_property(0x2C8F, 0x2C8F, 'Lowercase').	% L&       COPTIC SMALL LETTER HATE
unicode_core_property(0x2C91, 0x2C91, 'Lowercase').	% L&       COPTIC SMALL LETTER THETHE
unicode_core_property(0x2C93, 0x2C93, 'Lowercase').	% L&       COPTIC SMALL LETTER IAUDA
unicode_core_property(0x2C95, 0x2C95, 'Lowercase').	% L&       COPTIC SMALL LETTER KAPA
unicode_core_property(0x2C97, 0x2C97, 'Lowercase').	% L&       COPTIC SMALL LETTER LAULA
unicode_core_property(0x2C99, 0x2C99, 'Lowercase').	% L&       COPTIC SMALL LETTER MI
unicode_core_property(0x2C9B, 0x2C9B, 'Lowercase').	% L&       COPTIC SMALL LETTER NI
unicode_core_property(0x2C9D, 0x2C9D, 'Lowercase').	% L&       COPTIC SMALL LETTER KSI
unicode_core_property(0x2C9F, 0x2C9F, 'Lowercase').	% L&       COPTIC SMALL LETTER O
unicode_core_property(0x2CA1, 0x2CA1, 'Lowercase').	% L&       COPTIC SMALL LETTER PI
unicode_core_property(0x2CA3, 0x2CA3, 'Lowercase').	% L&       COPTIC SMALL LETTER RO
unicode_core_property(0x2CA5, 0x2CA5, 'Lowercase').	% L&       COPTIC SMALL LETTER SIMA
unicode_core_property(0x2CA7, 0x2CA7, 'Lowercase').	% L&       COPTIC SMALL LETTER TAU
unicode_core_property(0x2CA9, 0x2CA9, 'Lowercase').	% L&       COPTIC SMALL LETTER UA
unicode_core_property(0x2CAB, 0x2CAB, 'Lowercase').	% L&       COPTIC SMALL LETTER FI
unicode_core_property(0x2CAD, 0x2CAD, 'Lowercase').	% L&       COPTIC SMALL LETTER KHI
unicode_core_property(0x2CAF, 0x2CAF, 'Lowercase').	% L&       COPTIC SMALL LETTER PSI
unicode_core_property(0x2CB1, 0x2CB1, 'Lowercase').	% L&       COPTIC SMALL LETTER OOU
unicode_core_property(0x2CB3, 0x2CB3, 'Lowercase').	% L&       COPTIC SMALL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB5, 0x2CB5, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB7, 0x2CB7, 'Lowercase').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB9, 0x2CB9, 'Lowercase').	% L&       COPTIC SMALL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBB, 0x2CBB, 'Lowercase').	% L&       COPTIC SMALL LETTER DIALECT-P NI
unicode_core_property(0x2CBD, 0x2CBD, 'Lowercase').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBF, 0x2CBF, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC1, 0x2CC1, 'Lowercase').	% L&       COPTIC SMALL LETTER SAMPI
unicode_core_property(0x2CC3, 0x2CC3, 'Lowercase').	% L&       COPTIC SMALL LETTER CROSSED SHEI
unicode_core_property(0x2CC5, 0x2CC5, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC7, 0x2CC7, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC9, 0x2CC9, 'Lowercase').	% L&       COPTIC SMALL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCB, 0x2CCB, 'Lowercase').	% L&       COPTIC SMALL LETTER DIALECT-P HORI
unicode_core_property(0x2CCD, 0x2CCD, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCF, 0x2CCF, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC HA
unicode_core_property(0x2CD1, 0x2CD1, 'Lowercase').	% L&       COPTIC SMALL LETTER L-SHAPED HA
unicode_core_property(0x2CD3, 0x2CD3, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD5, 0x2CD5, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD7, 0x2CD7, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD9, 0x2CD9, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDB, 0x2CDB, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDD, 0x2CDD, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDF, 0x2CDF, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE1, 0x2CE1, 'Lowercase').	% L&       COPTIC SMALL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE3, 0x2CE4, 'Lowercase').	% L&   [2] COPTIC SMALL LETTER OLD NUBIAN WAU..COPTIC SYMBOL KAI
unicode_core_property(0x2CEC, 0x2CEC, 'Lowercase').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CEE, 0x2CEE, 'Lowercase').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF3, 0x2CF3, 'Lowercase').	% L&       COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Lowercase').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Lowercase').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Lowercase').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0xA641, 0xA641, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZEMLYA
unicode_core_property(0xA643, 0xA643, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DZELO
unicode_core_property(0xA645, 0xA645, 'Lowercase').	% L&       CYRILLIC SMALL LETTER REVERSED DZE
unicode_core_property(0xA647, 0xA647, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTA
unicode_core_property(0xA649, 0xA649, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DJERV
unicode_core_property(0xA64B, 0xA64B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER MONOGRAPH UK
unicode_core_property(0xA64D, 0xA64D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BROAD OMEGA
unicode_core_property(0xA64F, 0xA64F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER NEUTRAL YER
unicode_core_property(0xA651, 0xA651, 'Lowercase').	% L&       CYRILLIC SMALL LETTER YERU WITH BACK YER
unicode_core_property(0xA653, 0xA653, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED YAT
unicode_core_property(0xA655, 0xA655, 'Lowercase').	% L&       CYRILLIC SMALL LETTER REVERSED YU
unicode_core_property(0xA657, 0xA657, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED A
unicode_core_property(0xA659, 0xA659, 'Lowercase').	% L&       CYRILLIC SMALL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65B, 0xA65B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BLENDED YUS
unicode_core_property(0xA65D, 0xA65D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65F, 0xA65F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER YN
unicode_core_property(0xA661, 0xA661, 'Lowercase').	% L&       CYRILLIC SMALL LETTER REVERSED TSE
unicode_core_property(0xA663, 0xA663, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SOFT DE
unicode_core_property(0xA665, 0xA665, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SOFT EL
unicode_core_property(0xA667, 0xA667, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SOFT EM
unicode_core_property(0xA669, 0xA669, 'Lowercase').	% L&       CYRILLIC SMALL LETTER MONOCULAR O
unicode_core_property(0xA66B, 0xA66B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER BINOCULAR O
unicode_core_property(0xA66D, 0xA66D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA681, 0xA681, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DWE
unicode_core_property(0xA683, 0xA683, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DZWE
unicode_core_property(0xA685, 0xA685, 'Lowercase').	% L&       CYRILLIC SMALL LETTER ZHWE
unicode_core_property(0xA687, 0xA687, 'Lowercase').	% L&       CYRILLIC SMALL LETTER CCHE
unicode_core_property(0xA689, 0xA689, 'Lowercase').	% L&       CYRILLIC SMALL LETTER DZZE
unicode_core_property(0xA68B, 0xA68B, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68D, 0xA68D, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TWE
unicode_core_property(0xA68F, 0xA68F, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TSWE
unicode_core_property(0xA691, 0xA691, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TSSE
unicode_core_property(0xA693, 0xA693, 'Lowercase').	% L&       CYRILLIC SMALL LETTER TCHE
unicode_core_property(0xA695, 0xA695, 'Lowercase').	% L&       CYRILLIC SMALL LETTER HWE
unicode_core_property(0xA697, 0xA697, 'Lowercase').	% L&       CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA723, 0xA723, 'Lowercase').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA725, 0xA725, 'Lowercase').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA727, 0xA727, 'Lowercase').	% L&       LATIN SMALL LETTER HENG
unicode_core_property(0xA729, 0xA729, 'Lowercase').	% L&       LATIN SMALL LETTER TZ
unicode_core_property(0xA72B, 0xA72B, 'Lowercase').	% L&       LATIN SMALL LETTER TRESILLO
unicode_core_property(0xA72D, 0xA72D, 'Lowercase').	% L&       LATIN SMALL LETTER CUATRILLO
unicode_core_property(0xA72F, 0xA731, 'Lowercase').	% L&   [3] LATIN SMALL LETTER CUATRILLO WITH COMMA..LATIN LETTER SMALL CAPITAL S
unicode_core_property(0xA733, 0xA733, 'Lowercase').	% L&       LATIN SMALL LETTER AA
unicode_core_property(0xA735, 0xA735, 'Lowercase').	% L&       LATIN SMALL LETTER AO
unicode_core_property(0xA737, 0xA737, 'Lowercase').	% L&       LATIN SMALL LETTER AU
unicode_core_property(0xA739, 0xA739, 'Lowercase').	% L&       LATIN SMALL LETTER AV
unicode_core_property(0xA73B, 0xA73B, 'Lowercase').	% L&       LATIN SMALL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73D, 0xA73D, 'Lowercase').	% L&       LATIN SMALL LETTER AY
unicode_core_property(0xA73F, 0xA73F, 'Lowercase').	% L&       LATIN SMALL LETTER REVERSED C WITH DOT
unicode_core_property(0xA741, 0xA741, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH STROKE
unicode_core_property(0xA743, 0xA743, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA745, 0xA745, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA747, 0xA747, 'Lowercase').	% L&       LATIN SMALL LETTER BROKEN L
unicode_core_property(0xA749, 0xA749, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74B, 0xA74B, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74D, 0xA74D, 'Lowercase').	% L&       LATIN SMALL LETTER O WITH LOOP
unicode_core_property(0xA74F, 0xA74F, 'Lowercase').	% L&       LATIN SMALL LETTER OO
unicode_core_property(0xA751, 0xA751, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA753, 0xA753, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH FLOURISH
unicode_core_property(0xA755, 0xA755, 'Lowercase').	% L&       LATIN SMALL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA757, 0xA757, 'Lowercase').	% L&       LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA759, 0xA759, 'Lowercase').	% L&       LATIN SMALL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75B, 0xA75B, 'Lowercase').	% L&       LATIN SMALL LETTER R ROTUNDA
unicode_core_property(0xA75D, 0xA75D, 'Lowercase').	% L&       LATIN SMALL LETTER RUM ROTUNDA
unicode_core_property(0xA75F, 0xA75F, 'Lowercase').	% L&       LATIN SMALL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA761, 0xA761, 'Lowercase').	% L&       LATIN SMALL LETTER VY
unicode_core_property(0xA763, 0xA763, 'Lowercase').	% L&       LATIN SMALL LETTER VISIGOTHIC Z
unicode_core_property(0xA765, 0xA765, 'Lowercase').	% L&       LATIN SMALL LETTER THORN WITH STROKE
unicode_core_property(0xA767, 0xA767, 'Lowercase').	% L&       LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA769, 0xA769, 'Lowercase').	% L&       LATIN SMALL LETTER VEND
unicode_core_property(0xA76B, 0xA76B, 'Lowercase').	% L&       LATIN SMALL LETTER ET
unicode_core_property(0xA76D, 0xA76D, 'Lowercase').	% L&       LATIN SMALL LETTER IS
unicode_core_property(0xA76F, 0xA76F, 'Lowercase').	% L&       LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'Lowercase').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA778, 'Lowercase').	% L&   [8] LATIN SMALL LETTER DUM..LATIN SMALL LETTER UM
unicode_core_property(0xA77A, 0xA77A, 'Lowercase').	% L&       LATIN SMALL LETTER INSULAR D
unicode_core_property(0xA77C, 0xA77C, 'Lowercase').	% L&       LATIN SMALL LETTER INSULAR F
unicode_core_property(0xA77F, 0xA77F, 'Lowercase').	% L&       LATIN SMALL LETTER TURNED INSULAR G
unicode_core_property(0xA781, 0xA781, 'Lowercase').	% L&       LATIN SMALL LETTER TURNED L
unicode_core_property(0xA783, 0xA783, 'Lowercase').	% L&       LATIN SMALL LETTER INSULAR R
unicode_core_property(0xA785, 0xA785, 'Lowercase').	% L&       LATIN SMALL LETTER INSULAR S
unicode_core_property(0xA787, 0xA787, 'Lowercase').	% L&       LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA78C, 0xA78C, 'Lowercase').	% L&       LATIN SMALL LETTER SALTILLO
unicode_core_property(0xA78E, 0xA78E, 'Lowercase').	% L&       LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA791, 0xA791, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH DESCENDER
unicode_core_property(0xA793, 0xA793, 'Lowercase').	% L&       LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A1, 0xA7A1, 'Lowercase').	% L&       LATIN SMALL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A3, 0xA7A3, 'Lowercase').	% L&       LATIN SMALL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A5, 0xA7A5, 'Lowercase').	% L&       LATIN SMALL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A7, 0xA7A7, 'Lowercase').	% L&       LATIN SMALL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A9, 0xA7A9, 'Lowercase').	% L&       LATIN SMALL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xA7F8, 0xA7F9, 'Lowercase').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'Lowercase').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xFB00, 0xFB06, 'Lowercase').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Lowercase').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF41, 0xFF5A, 'Lowercase').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0x10428, 0x1044F, 'Lowercase').	% L&  [40] DESERET SMALL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x1D41A, 0x1D433, 'Lowercase').	% L&  [26] MATHEMATICAL BOLD SMALL A..MATHEMATICAL BOLD SMALL Z
unicode_core_property(0x1D44E, 0x1D454, 'Lowercase').	% L&   [7] MATHEMATICAL ITALIC SMALL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D467, 'Lowercase').	% L&  [18] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL ITALIC SMALL Z
unicode_core_property(0x1D482, 0x1D49B, 'Lowercase').	% L&  [26] MATHEMATICAL BOLD ITALIC SMALL A..MATHEMATICAL BOLD ITALIC SMALL Z
unicode_core_property(0x1D4B6, 0x1D4B9, 'Lowercase').	% L&   [4] MATHEMATICAL SCRIPT SMALL A..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'Lowercase').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'Lowercase').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D4CF, 'Lowercase').	% L&  [11] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL SCRIPT SMALL Z
unicode_core_property(0x1D4EA, 0x1D503, 'Lowercase').	% L&  [26] MATHEMATICAL BOLD SCRIPT SMALL A..MATHEMATICAL BOLD SCRIPT SMALL Z
unicode_core_property(0x1D51E, 0x1D537, 'Lowercase').	% L&  [26] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL FRAKTUR SMALL Z
unicode_core_property(0x1D552, 0x1D56B, 'Lowercase').	% L&  [26] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL DOUBLE-STRUCK SMALL Z
unicode_core_property(0x1D586, 0x1D59F, 'Lowercase').	% L&  [26] MATHEMATICAL BOLD FRAKTUR SMALL A..MATHEMATICAL BOLD FRAKTUR SMALL Z
unicode_core_property(0x1D5BA, 0x1D5D3, 'Lowercase').	% L&  [26] MATHEMATICAL SANS-SERIF SMALL A..MATHEMATICAL SANS-SERIF SMALL Z
unicode_core_property(0x1D5EE, 0x1D607, 'Lowercase').	% L&  [26] MATHEMATICAL SANS-SERIF BOLD SMALL A..MATHEMATICAL SANS-SERIF BOLD SMALL Z
unicode_core_property(0x1D622, 0x1D63B, 'Lowercase').	% L&  [26] MATHEMATICAL SANS-SERIF ITALIC SMALL A..MATHEMATICAL SANS-SERIF ITALIC SMALL Z
unicode_core_property(0x1D656, 0x1D66F, 'Lowercase').	% L&  [26] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
unicode_core_property(0x1D68A, 0x1D6A5, 'Lowercase').	% L&  [28] MATHEMATICAL MONOSPACE SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6C2, 0x1D6DA, 'Lowercase').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6E1, 'Lowercase').	% L&   [6] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL BOLD PI SYMBOL
unicode_core_property(0x1D6FC, 0x1D714, 'Lowercase').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D71B, 'Lowercase').	% L&   [6] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL ITALIC PI SYMBOL
unicode_core_property(0x1D736, 0x1D74E, 'Lowercase').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D755, 'Lowercase').	% L&   [6] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC PI SYMBOL
unicode_core_property(0x1D770, 0x1D788, 'Lowercase').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D78F, 'Lowercase').	% L&   [6] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
unicode_core_property(0x1D7AA, 0x1D7C2, 'Lowercase').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7C9, 'Lowercase').	% L&   [6] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
unicode_core_property(0x1D7CB, 0x1D7CB, 'Lowercase').	% L&       MATHEMATICAL BOLD SMALL DIGAMMA

% Total code points: 1934

% ================================================

% Derived Property: Uppercase
%  Generated from: Lu + Other_Uppercase

unicode_core_property(0x0041, 0x005A, 'Uppercase').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x00C0, 0x00D6, 'Uppercase').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00DE, 'Uppercase').	% L&   [7] LATIN CAPITAL LETTER O WITH STROKE..LATIN CAPITAL LETTER THORN
unicode_core_property(0x0100, 0x0100, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH MACRON
unicode_core_property(0x0102, 0x0102, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE
unicode_core_property(0x0104, 0x0104, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH OGONEK
unicode_core_property(0x0106, 0x0106, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH ACUTE
unicode_core_property(0x0108, 0x0108, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010A, 0x010A, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH DOT ABOVE
unicode_core_property(0x010C, 0x010C, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH CARON
unicode_core_property(0x010E, 0x010E, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH CARON
unicode_core_property(0x0110, 0x0110, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH STROKE
unicode_core_property(0x0112, 0x0112, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH MACRON
unicode_core_property(0x0114, 0x0114, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH BREVE
unicode_core_property(0x0116, 0x0116, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH DOT ABOVE
unicode_core_property(0x0118, 0x0118, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH OGONEK
unicode_core_property(0x011A, 0x011A, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CARON
unicode_core_property(0x011C, 0x011C, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011E, 0x011E, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH BREVE
unicode_core_property(0x0120, 0x0120, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH DOT ABOVE
unicode_core_property(0x0122, 0x0122, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH CEDILLA
unicode_core_property(0x0124, 0x0124, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0126, 0x0126, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH STROKE
unicode_core_property(0x0128, 0x0128, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH TILDE
unicode_core_property(0x012A, 0x012A, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH MACRON
unicode_core_property(0x012C, 0x012C, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH BREVE
unicode_core_property(0x012E, 0x012E, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH OGONEK
unicode_core_property(0x0130, 0x0130, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH DOT ABOVE
unicode_core_property(0x0132, 0x0132, 'Uppercase').	% L&       LATIN CAPITAL LIGATURE IJ
unicode_core_property(0x0134, 0x0134, 'Uppercase').	% L&       LATIN CAPITAL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0136, 0x0136, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH CEDILLA
unicode_core_property(0x0139, 0x0139, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH ACUTE
unicode_core_property(0x013B, 0x013B, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH CEDILLA
unicode_core_property(0x013D, 0x013D, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH CARON
unicode_core_property(0x013F, 0x013F, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0141, 0x0141, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH STROKE
unicode_core_property(0x0143, 0x0143, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH ACUTE
unicode_core_property(0x0145, 0x0145, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH CEDILLA
unicode_core_property(0x0147, 0x0147, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH CARON
unicode_core_property(0x014A, 0x014A, 'Uppercase').	% L&       LATIN CAPITAL LETTER ENG
unicode_core_property(0x014C, 0x014C, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH MACRON
unicode_core_property(0x014E, 0x014E, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH BREVE
unicode_core_property(0x0150, 0x0150, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0152, 0x0152, 'Uppercase').	% L&       LATIN CAPITAL LIGATURE OE
unicode_core_property(0x0154, 0x0154, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH ACUTE
unicode_core_property(0x0156, 0x0156, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH CEDILLA
unicode_core_property(0x0158, 0x0158, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH CARON
unicode_core_property(0x015A, 0x015A, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH ACUTE
unicode_core_property(0x015C, 0x015C, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015E, 0x015E, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH CEDILLA
unicode_core_property(0x0160, 0x0160, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH CARON
unicode_core_property(0x0162, 0x0162, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH CEDILLA
unicode_core_property(0x0164, 0x0164, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH CARON
unicode_core_property(0x0166, 0x0166, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH STROKE
unicode_core_property(0x0168, 0x0168, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH TILDE
unicode_core_property(0x016A, 0x016A, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH MACRON
unicode_core_property(0x016C, 0x016C, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH BREVE
unicode_core_property(0x016E, 0x016E, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH RING ABOVE
unicode_core_property(0x0170, 0x0170, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0172, 0x0172, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH OGONEK
unicode_core_property(0x0174, 0x0174, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0176, 0x0176, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x0178, 0x0179, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER Y WITH DIAERESIS..LATIN CAPITAL LETTER Z WITH ACUTE
unicode_core_property(0x017B, 0x017B, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017D, 0x017D, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH CARON
unicode_core_property(0x0181, 0x0182, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER B WITH HOOK..LATIN CAPITAL LETTER B WITH TOPBAR
unicode_core_property(0x0184, 0x0184, 'Uppercase').	% L&       LATIN CAPITAL LETTER TONE SIX
unicode_core_property(0x0186, 0x0187, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER OPEN O..LATIN CAPITAL LETTER C WITH HOOK
unicode_core_property(0x0189, 0x018B, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER AFRICAN D..LATIN CAPITAL LETTER D WITH TOPBAR
unicode_core_property(0x018E, 0x0191, 'Uppercase').	% L&   [4] LATIN CAPITAL LETTER REVERSED E..LATIN CAPITAL LETTER F WITH HOOK
unicode_core_property(0x0193, 0x0194, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER G WITH HOOK..LATIN CAPITAL LETTER GAMMA
unicode_core_property(0x0196, 0x0198, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER IOTA..LATIN CAPITAL LETTER K WITH HOOK
unicode_core_property(0x019C, 0x019D, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER N WITH LEFT HOOK
unicode_core_property(0x019F, 0x01A0, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER O WITH MIDDLE TILDE..LATIN CAPITAL LETTER O WITH HORN
unicode_core_property(0x01A2, 0x01A2, 'Uppercase').	% L&       LATIN CAPITAL LETTER OI
unicode_core_property(0x01A4, 0x01A4, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH HOOK
unicode_core_property(0x01A6, 0x01A7, 'Uppercase').	% L&   [2] LATIN LETTER YR..LATIN CAPITAL LETTER TONE TWO
unicode_core_property(0x01A9, 0x01A9, 'Uppercase').	% L&       LATIN CAPITAL LETTER ESH
unicode_core_property(0x01AC, 0x01AC, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH HOOK
unicode_core_property(0x01AE, 0x01AF, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER T WITH RETROFLEX HOOK..LATIN CAPITAL LETTER U WITH HORN
unicode_core_property(0x01B1, 0x01B3, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER UPSILON..LATIN CAPITAL LETTER Y WITH HOOK
unicode_core_property(0x01B5, 0x01B5, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH STROKE
unicode_core_property(0x01B7, 0x01B8, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER EZH..LATIN CAPITAL LETTER EZH REVERSED
unicode_core_property(0x01BC, 0x01BC, 'Uppercase').	% L&       LATIN CAPITAL LETTER TONE FIVE
unicode_core_property(0x01C4, 0x01C4, 'Uppercase').	% L&       LATIN CAPITAL LETTER DZ WITH CARON
unicode_core_property(0x01C7, 0x01C7, 'Uppercase').	% L&       LATIN CAPITAL LETTER LJ
unicode_core_property(0x01CA, 0x01CA, 'Uppercase').	% L&       LATIN CAPITAL LETTER NJ
unicode_core_property(0x01CD, 0x01CD, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CARON
unicode_core_property(0x01CF, 0x01CF, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH CARON
unicode_core_property(0x01D1, 0x01D1, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CARON
unicode_core_property(0x01D3, 0x01D3, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH CARON
unicode_core_property(0x01D5, 0x01D5, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D7, 0x01D7, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01D9, 0x01D9, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DB, 0x01DB, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
unicode_core_property(0x01DE, 0x01DE, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E0, 0x01E0, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E2, 0x01E2, 'Uppercase').	% L&       LATIN CAPITAL LETTER AE WITH MACRON
unicode_core_property(0x01E4, 0x01E4, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH STROKE
unicode_core_property(0x01E6, 0x01E6, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH CARON
unicode_core_property(0x01E8, 0x01E8, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH CARON
unicode_core_property(0x01EA, 0x01EA, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH OGONEK
unicode_core_property(0x01EC, 0x01EC, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EE, 0x01EE, 'Uppercase').	% L&       LATIN CAPITAL LETTER EZH WITH CARON
unicode_core_property(0x01F1, 0x01F1, 'Uppercase').	% L&       LATIN CAPITAL LETTER DZ
unicode_core_property(0x01F4, 0x01F4, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH ACUTE
unicode_core_property(0x01F6, 0x01F8, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER HWAIR..LATIN CAPITAL LETTER N WITH GRAVE
unicode_core_property(0x01FA, 0x01FA, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FC, 0x01FC, 'Uppercase').	% L&       LATIN CAPITAL LETTER AE WITH ACUTE
unicode_core_property(0x01FE, 0x01FE, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0200, 0x0200, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0202, 0x0202, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0204, 0x0204, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0206, 0x0206, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0208, 0x0208, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020A, 0x020A, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020C, 0x020C, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020E, 0x020E, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0210, 0x0210, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0212, 0x0212, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0214, 0x0214, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0216, 0x0216, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0218, 0x0218, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH COMMA BELOW
unicode_core_property(0x021A, 0x021A, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH COMMA BELOW
unicode_core_property(0x021C, 0x021C, 'Uppercase').	% L&       LATIN CAPITAL LETTER YOGH
unicode_core_property(0x021E, 0x021E, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH CARON
unicode_core_property(0x0220, 0x0220, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x0222, 0x0222, 'Uppercase').	% L&       LATIN CAPITAL LETTER OU
unicode_core_property(0x0224, 0x0224, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH HOOK
unicode_core_property(0x0226, 0x0226, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE
unicode_core_property(0x0228, 0x0228, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA
unicode_core_property(0x022A, 0x022A, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022C, 0x022C, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022E, 0x022E, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE
unicode_core_property(0x0230, 0x0230, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0232, 0x0232, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH MACRON
unicode_core_property(0x023A, 0x023B, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER A WITH STROKE..LATIN CAPITAL LETTER C WITH STROKE
unicode_core_property(0x023D, 0x023E, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER L WITH BAR..LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x0241, 0x0241, 'Uppercase').	% L&       LATIN CAPITAL LETTER GLOTTAL STOP
unicode_core_property(0x0243, 0x0246, 'Uppercase').	% L&   [4] LATIN CAPITAL LETTER B WITH STROKE..LATIN CAPITAL LETTER E WITH STROKE
unicode_core_property(0x0248, 0x0248, 'Uppercase').	% L&       LATIN CAPITAL LETTER J WITH STROKE
unicode_core_property(0x024A, 0x024A, 'Uppercase').	% L&       LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
unicode_core_property(0x024C, 0x024C, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH STROKE
unicode_core_property(0x024E, 0x024E, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH STROKE
unicode_core_property(0x0370, 0x0370, 'Uppercase').	% L&       GREEK CAPITAL LETTER HETA
unicode_core_property(0x0372, 0x0372, 'Uppercase').	% L&       GREEK CAPITAL LETTER ARCHAIC SAMPI
unicode_core_property(0x0376, 0x0376, 'Uppercase').	% L&       GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x0386, 0x0386, 'Uppercase').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Uppercase').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Uppercase').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x038F, 'Uppercase').	% L&   [2] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER OMEGA WITH TONOS
unicode_core_property(0x0391, 0x03A1, 'Uppercase').	% L&  [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03AB, 'Uppercase').	% L&   [9] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
unicode_core_property(0x03CF, 0x03CF, 'Uppercase').	% L&       GREEK CAPITAL KAI SYMBOL
unicode_core_property(0x03D2, 0x03D4, 'Uppercase').	% L&   [3] GREEK UPSILON WITH HOOK SYMBOL..GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
unicode_core_property(0x03D8, 0x03D8, 'Uppercase').	% L&       GREEK LETTER ARCHAIC KOPPA
unicode_core_property(0x03DA, 0x03DA, 'Uppercase').	% L&       GREEK LETTER STIGMA
unicode_core_property(0x03DC, 0x03DC, 'Uppercase').	% L&       GREEK LETTER DIGAMMA
unicode_core_property(0x03DE, 0x03DE, 'Uppercase').	% L&       GREEK LETTER KOPPA
unicode_core_property(0x03E0, 0x03E0, 'Uppercase').	% L&       GREEK LETTER SAMPI
unicode_core_property(0x03E2, 0x03E2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER SHEI
unicode_core_property(0x03E4, 0x03E4, 'Uppercase').	% L&       COPTIC CAPITAL LETTER FEI
unicode_core_property(0x03E6, 0x03E6, 'Uppercase').	% L&       COPTIC CAPITAL LETTER KHEI
unicode_core_property(0x03E8, 0x03E8, 'Uppercase').	% L&       COPTIC CAPITAL LETTER HORI
unicode_core_property(0x03EA, 0x03EA, 'Uppercase').	% L&       COPTIC CAPITAL LETTER GANGIA
unicode_core_property(0x03EC, 0x03EC, 'Uppercase').	% L&       COPTIC CAPITAL LETTER SHIMA
unicode_core_property(0x03EE, 0x03EE, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DEI
unicode_core_property(0x03F4, 0x03F4, 'Uppercase').	% L&       GREEK CAPITAL THETA SYMBOL
unicode_core_property(0x03F7, 0x03F7, 'Uppercase').	% L&       GREEK CAPITAL LETTER SHO
unicode_core_property(0x03F9, 0x03FA, 'Uppercase').	% L&   [2] GREEK CAPITAL LUNATE SIGMA SYMBOL..GREEK CAPITAL LETTER SAN
unicode_core_property(0x03FD, 0x042F, 'Uppercase').	% L&  [51] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC CAPITAL LETTER YA
unicode_core_property(0x0460, 0x0460, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER OMEGA
unicode_core_property(0x0462, 0x0462, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER YAT
unicode_core_property(0x0464, 0x0464, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED E
unicode_core_property(0x0466, 0x0466, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER LITTLE YUS
unicode_core_property(0x0468, 0x0468, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046A, 0x046A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BIG YUS
unicode_core_property(0x046C, 0x046C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046E, 0x046E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KSI
unicode_core_property(0x0470, 0x0470, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER PSI
unicode_core_property(0x0472, 0x0472, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER FITA
unicode_core_property(0x0474, 0x0474, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IZHITSA
unicode_core_property(0x0476, 0x0476, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0478, 0x0478, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER UK
unicode_core_property(0x047A, 0x047A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ROUND OMEGA
unicode_core_property(0x047C, 0x047C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
unicode_core_property(0x047E, 0x047E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER OT
unicode_core_property(0x0480, 0x0480, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOPPA
unicode_core_property(0x048A, 0x048A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
unicode_core_property(0x048C, 0x048C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SEMISOFT SIGN
unicode_core_property(0x048E, 0x048E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ER WITH TICK
unicode_core_property(0x0490, 0x0490, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER GHE WITH UPTURN
unicode_core_property(0x0492, 0x0492, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE
unicode_core_property(0x0494, 0x0494, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0496, 0x0496, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0498, 0x0498, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
unicode_core_property(0x049A, 0x049A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KA WITH DESCENDER
unicode_core_property(0x049C, 0x049C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049E, 0x049E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KA WITH STROKE
unicode_core_property(0x04A0, 0x04A0, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BASHKIR KA
unicode_core_property(0x04A2, 0x04A2, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EN WITH DESCENDER
unicode_core_property(0x04A4, 0x04A4, 'Uppercase').	% L&       CYRILLIC CAPITAL LIGATURE EN GHE
unicode_core_property(0x04A6, 0x04A6, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A8, 0x04A8, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN HA
unicode_core_property(0x04AA, 0x04AA, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ES WITH DESCENDER
unicode_core_property(0x04AC, 0x04AC, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TE WITH DESCENDER
unicode_core_property(0x04AE, 0x04AE, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U
unicode_core_property(0x04B0, 0x04B0, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B2, 0x04B2, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER HA WITH DESCENDER
unicode_core_property(0x04B4, 0x04B4, 'Uppercase').	% L&       CYRILLIC CAPITAL LIGATURE TE TSE
unicode_core_property(0x04B6, 0x04B6, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B8, 0x04B8, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BA, 0x04BA, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SHHA
unicode_core_property(0x04BC, 0x04BC, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE
unicode_core_property(0x04BE, 0x04BE, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C0, 0x04C1, 'Uppercase').	% L&   [2] CYRILLIC LETTER PALOCHKA..CYRILLIC CAPITAL LETTER ZHE WITH BREVE
unicode_core_property(0x04C3, 0x04C3, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KA WITH HOOK
unicode_core_property(0x04C5, 0x04C5, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EL WITH TAIL
unicode_core_property(0x04C7, 0x04C7, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EN WITH HOOK
unicode_core_property(0x04C9, 0x04C9, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EN WITH TAIL
unicode_core_property(0x04CB, 0x04CB, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CD, 0x04CD, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EM WITH TAIL
unicode_core_property(0x04D0, 0x04D0, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER A WITH BREVE
unicode_core_property(0x04D2, 0x04D2, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER A WITH DIAERESIS
unicode_core_property(0x04D4, 0x04D4, 'Uppercase').	% L&       CYRILLIC CAPITAL LIGATURE A IE
unicode_core_property(0x04D6, 0x04D6, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IE WITH BREVE
unicode_core_property(0x04D8, 0x04D8, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SCHWA
unicode_core_property(0x04DA, 0x04DA, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DC, 0x04DC, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DE, 0x04DE, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E0, 0x04E0, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN DZE
unicode_core_property(0x04E2, 0x04E2, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER I WITH MACRON
unicode_core_property(0x04E4, 0x04E4, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER I WITH DIAERESIS
unicode_core_property(0x04E6, 0x04E6, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x04E8, 0x04E8, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BARRED O
unicode_core_property(0x04EA, 0x04EA, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04EC, 0x04EC, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER E WITH DIAERESIS
unicode_core_property(0x04EE, 0x04EE, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER U WITH MACRON
unicode_core_property(0x04F0, 0x04F0, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER U WITH DIAERESIS
unicode_core_property(0x04F2, 0x04F2, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F4, 0x04F4, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F6, 0x04F6, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F8, 0x04F8, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FA, 0x04FA, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FC, 0x04FC, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER HA WITH HOOK
unicode_core_property(0x04FE, 0x04FE, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER HA WITH STROKE
unicode_core_property(0x0500, 0x0500, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI DE
unicode_core_property(0x0502, 0x0502, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI DJE
unicode_core_property(0x0504, 0x0504, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI ZJE
unicode_core_property(0x0506, 0x0506, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI DZJE
unicode_core_property(0x0508, 0x0508, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI LJE
unicode_core_property(0x050A, 0x050A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI NJE
unicode_core_property(0x050C, 0x050C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI SJE
unicode_core_property(0x050E, 0x050E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER KOMI TJE
unicode_core_property(0x0510, 0x0510, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER REVERSED ZE
unicode_core_property(0x0512, 0x0512, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EL WITH HOOK
unicode_core_property(0x0514, 0x0514, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER LHA
unicode_core_property(0x0516, 0x0516, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER RHA
unicode_core_property(0x0518, 0x0518, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER YAE
unicode_core_property(0x051A, 0x051A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER QA
unicode_core_property(0x051C, 0x051C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER WE
unicode_core_property(0x051E, 0x051E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ALEUT KA
unicode_core_property(0x0520, 0x0520, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0522, 0x0522, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0524, 0x0524, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER PE WITH DESCENDER
unicode_core_property(0x0526, 0x0526, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Uppercase').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x10A0, 0x10C5, 'Uppercase').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Uppercase').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Uppercase').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x1E00, 0x1E00, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH RING BELOW
unicode_core_property(0x1E02, 0x1E02, 'Uppercase').	% L&       LATIN CAPITAL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E04, 0x1E04, 'Uppercase').	% L&       LATIN CAPITAL LETTER B WITH DOT BELOW
unicode_core_property(0x1E06, 0x1E06, 'Uppercase').	% L&       LATIN CAPITAL LETTER B WITH LINE BELOW
unicode_core_property(0x1E08, 0x1E08, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0A, 0x1E0A, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0C, 0x1E0C, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0E, 0x1E0E, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH LINE BELOW
unicode_core_property(0x1E10, 0x1E10, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH CEDILLA
unicode_core_property(0x1E12, 0x1E12, 'Uppercase').	% L&       LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E14, 0x1E14, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E16, 0x1E16, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E18, 0x1E18, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1A, 0x1E1A, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1C, 0x1E1C, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1E, 0x1E1E, 'Uppercase').	% L&       LATIN CAPITAL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E20, 0x1E20, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH MACRON
unicode_core_property(0x1E22, 0x1E22, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E24, 0x1E24, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH DOT BELOW
unicode_core_property(0x1E26, 0x1E26, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH DIAERESIS
unicode_core_property(0x1E28, 0x1E28, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH CEDILLA
unicode_core_property(0x1E2A, 0x1E2A, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2C, 0x1E2C, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2E, 0x1E2E, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E30, 0x1E30, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH ACUTE
unicode_core_property(0x1E32, 0x1E32, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH DOT BELOW
unicode_core_property(0x1E34, 0x1E34, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH LINE BELOW
unicode_core_property(0x1E36, 0x1E36, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW
unicode_core_property(0x1E38, 0x1E38, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3A, 0x1E3A, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3C, 0x1E3C, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3E, 0x1E3E, 'Uppercase').	% L&       LATIN CAPITAL LETTER M WITH ACUTE
unicode_core_property(0x1E40, 0x1E40, 'Uppercase').	% L&       LATIN CAPITAL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E42, 0x1E42, 'Uppercase').	% L&       LATIN CAPITAL LETTER M WITH DOT BELOW
unicode_core_property(0x1E44, 0x1E44, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E46, 0x1E46, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH DOT BELOW
unicode_core_property(0x1E48, 0x1E48, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4A, 0x1E4A, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4C, 0x1E4C, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4E, 0x1E4E, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E50, 0x1E50, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E52, 0x1E52, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E54, 0x1E54, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH ACUTE
unicode_core_property(0x1E56, 0x1E56, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E58, 0x1E58, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5A, 0x1E5A, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5C, 0x1E5C, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5E, 0x1E5E, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH LINE BELOW
unicode_core_property(0x1E60, 0x1E60, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E62, 0x1E62, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW
unicode_core_property(0x1E64, 0x1E64, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E66, 0x1E66, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E68, 0x1E68, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6A, 0x1E6A, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6C, 0x1E6C, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6E, 0x1E6E, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH LINE BELOW
unicode_core_property(0x1E70, 0x1E70, 'Uppercase').	% L&       LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E72, 0x1E72, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E74, 0x1E74, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E76, 0x1E76, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E78, 0x1E78, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7A, 0x1E7A, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7C, 0x1E7C, 'Uppercase').	% L&       LATIN CAPITAL LETTER V WITH TILDE
unicode_core_property(0x1E7E, 0x1E7E, 'Uppercase').	% L&       LATIN CAPITAL LETTER V WITH DOT BELOW
unicode_core_property(0x1E80, 0x1E80, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH GRAVE
unicode_core_property(0x1E82, 0x1E82, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH ACUTE
unicode_core_property(0x1E84, 0x1E84, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH DIAERESIS
unicode_core_property(0x1E86, 0x1E86, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E88, 0x1E88, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8A, 0x1E8A, 'Uppercase').	% L&       LATIN CAPITAL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8C, 0x1E8C, 'Uppercase').	% L&       LATIN CAPITAL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8E, 0x1E8E, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E90, 0x1E90, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E92, 0x1E92, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E94, 0x1E94, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH LINE BELOW
unicode_core_property(0x1E9E, 0x1E9E, 'Uppercase').	% L&       LATIN CAPITAL LETTER SHARP S
unicode_core_property(0x1EA0, 0x1EA0, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA2, 0x1EA2, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA4, 0x1EA4, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA6, 0x1EA6, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA8, 0x1EA8, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAA, 0x1EAA, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAC, 0x1EAC, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAE, 0x1EAE, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB0, 0x1EB0, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB2, 0x1EB2, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB4, 0x1EB4, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB6, 0x1EB6, 'Uppercase').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB8, 0x1EB8, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBA, 0x1EBA, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBC, 0x1EBC, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH TILDE
unicode_core_property(0x1EBE, 0x1EBE, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC0, 0x1EC0, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC2, 0x1EC2, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC4, 0x1EC4, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC6, 0x1EC6, 'Uppercase').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC8, 0x1EC8, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECA, 0x1ECA, 'Uppercase').	% L&       LATIN CAPITAL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECC, 0x1ECC, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECE, 0x1ECE, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED0, 0x1ED0, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED2, 0x1ED2, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED4, 0x1ED4, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED6, 0x1ED6, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED8, 0x1ED8, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDA, 0x1EDA, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDC, 0x1EDC, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDE, 0x1EDE, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE0, 0x1EE0, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE2, 0x1EE2, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE4, 0x1EE4, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE6, 0x1EE6, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE8, 0x1EE8, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEA, 0x1EEA, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EEC, 0x1EEC, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEE, 0x1EEE, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF0, 0x1EF0, 'Uppercase').	% L&       LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF2, 0x1EF2, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH GRAVE
unicode_core_property(0x1EF4, 0x1EF4, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF6, 0x1EF6, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF8, 0x1EF8, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH TILDE
unicode_core_property(0x1EFA, 0x1EFA, 'Uppercase').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFC, 0x1EFC, 'Uppercase').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFE, 0x1EFE, 'Uppercase').	% L&       LATIN CAPITAL LETTER Y WITH LOOP
unicode_core_property(0x1F08, 0x1F0F, 'Uppercase').	% L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F18, 0x1F1D, 'Uppercase').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F28, 0x1F2F, 'Uppercase').	% L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F38, 0x1F3F, 'Uppercase').	% L&   [8] GREEK CAPITAL LETTER IOTA WITH PSILI..GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F48, 0x1F4D, 'Uppercase').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F59, 0x1F59, 'Uppercase').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Uppercase').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Uppercase').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F5F, 'Uppercase').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F68, 0x1F6F, 'Uppercase').	% L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1FB8, 0x1FBB, 'Uppercase').	% L&   [4] GREEK CAPITAL LETTER ALPHA WITH VRACHY..GREEK CAPITAL LETTER ALPHA WITH OXIA
unicode_core_property(0x1FC8, 0x1FCB, 'Uppercase').	% L&   [4] GREEK CAPITAL LETTER EPSILON WITH VARIA..GREEK CAPITAL LETTER ETA WITH OXIA
unicode_core_property(0x1FD8, 0x1FDB, 'Uppercase').	% L&   [4] GREEK CAPITAL LETTER IOTA WITH VRACHY..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE8, 0x1FEC, 'Uppercase').	% L&   [5] GREEK CAPITAL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF8, 0x1FFB, 'Uppercase').	% L&   [4] GREEK CAPITAL LETTER OMICRON WITH VARIA..GREEK CAPITAL LETTER OMEGA WITH OXIA
unicode_core_property(0x2102, 0x2102, 'Uppercase').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'Uppercase').	% L&       EULER CONSTANT
unicode_core_property(0x210B, 0x210D, 'Uppercase').	% L&   [3] SCRIPT CAPITAL H..DOUBLE-STRUCK CAPITAL H
unicode_core_property(0x2110, 0x2112, 'Uppercase').	% L&   [3] SCRIPT CAPITAL I..SCRIPT CAPITAL L
unicode_core_property(0x2115, 0x2115, 'Uppercase').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2119, 0x211D, 'Uppercase').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'Uppercase').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'Uppercase').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'Uppercase').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'Uppercase').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x2130, 0x2133, 'Uppercase').	% L&   [4] SCRIPT CAPITAL E..SCRIPT CAPITAL M
unicode_core_property(0x213E, 0x213F, 'Uppercase').	% L&   [2] DOUBLE-STRUCK CAPITAL GAMMA..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2145, 'Uppercase').	% L&       DOUBLE-STRUCK ITALIC CAPITAL D
unicode_core_property(0x2160, 0x216F, 'Uppercase').	% Nl  [16] ROMAN NUMERAL ONE..ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2183, 0x2183, 'Uppercase').	% L&       ROMAN NUMERAL REVERSED ONE HUNDRED
unicode_core_property(0x24B6, 0x24CF, 'Uppercase').	% So  [26] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN CAPITAL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Uppercase').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C60, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C62, 0x2C64, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER L WITH MIDDLE TILDE..LATIN CAPITAL LETTER R WITH TAIL
unicode_core_property(0x2C67, 0x2C67, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH DESCENDER
unicode_core_property(0x2C69, 0x2C69, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH DESCENDER
unicode_core_property(0x2C6B, 0x2C6B, 'Uppercase').	% L&       LATIN CAPITAL LETTER Z WITH DESCENDER
unicode_core_property(0x2C6D, 0x2C70, 'Uppercase').	% L&   [4] LATIN CAPITAL LETTER ALPHA..LATIN CAPITAL LETTER TURNED ALPHA
unicode_core_property(0x2C72, 0x2C72, 'Uppercase').	% L&       LATIN CAPITAL LETTER W WITH HOOK
unicode_core_property(0x2C75, 0x2C75, 'Uppercase').	% L&       LATIN CAPITAL LETTER HALF H
unicode_core_property(0x2C7E, 0x2C80, 'Uppercase').	% L&   [3] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC CAPITAL LETTER ALFA
unicode_core_property(0x2C82, 0x2C82, 'Uppercase').	% L&       COPTIC CAPITAL LETTER VIDA
unicode_core_property(0x2C84, 0x2C84, 'Uppercase').	% L&       COPTIC CAPITAL LETTER GAMMA
unicode_core_property(0x2C86, 0x2C86, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DALDA
unicode_core_property(0x2C88, 0x2C88, 'Uppercase').	% L&       COPTIC CAPITAL LETTER EIE
unicode_core_property(0x2C8A, 0x2C8A, 'Uppercase').	% L&       COPTIC CAPITAL LETTER SOU
unicode_core_property(0x2C8C, 0x2C8C, 'Uppercase').	% L&       COPTIC CAPITAL LETTER ZATA
unicode_core_property(0x2C8E, 0x2C8E, 'Uppercase').	% L&       COPTIC CAPITAL LETTER HATE
unicode_core_property(0x2C90, 0x2C90, 'Uppercase').	% L&       COPTIC CAPITAL LETTER THETHE
unicode_core_property(0x2C92, 0x2C92, 'Uppercase').	% L&       COPTIC CAPITAL LETTER IAUDA
unicode_core_property(0x2C94, 0x2C94, 'Uppercase').	% L&       COPTIC CAPITAL LETTER KAPA
unicode_core_property(0x2C96, 0x2C96, 'Uppercase').	% L&       COPTIC CAPITAL LETTER LAULA
unicode_core_property(0x2C98, 0x2C98, 'Uppercase').	% L&       COPTIC CAPITAL LETTER MI
unicode_core_property(0x2C9A, 0x2C9A, 'Uppercase').	% L&       COPTIC CAPITAL LETTER NI
unicode_core_property(0x2C9C, 0x2C9C, 'Uppercase').	% L&       COPTIC CAPITAL LETTER KSI
unicode_core_property(0x2C9E, 0x2C9E, 'Uppercase').	% L&       COPTIC CAPITAL LETTER O
unicode_core_property(0x2CA0, 0x2CA0, 'Uppercase').	% L&       COPTIC CAPITAL LETTER PI
unicode_core_property(0x2CA2, 0x2CA2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER RO
unicode_core_property(0x2CA4, 0x2CA4, 'Uppercase').	% L&       COPTIC CAPITAL LETTER SIMA
unicode_core_property(0x2CA6, 0x2CA6, 'Uppercase').	% L&       COPTIC CAPITAL LETTER TAU
unicode_core_property(0x2CA8, 0x2CA8, 'Uppercase').	% L&       COPTIC CAPITAL LETTER UA
unicode_core_property(0x2CAA, 0x2CAA, 'Uppercase').	% L&       COPTIC CAPITAL LETTER FI
unicode_core_property(0x2CAC, 0x2CAC, 'Uppercase').	% L&       COPTIC CAPITAL LETTER KHI
unicode_core_property(0x2CAE, 0x2CAE, 'Uppercase').	% L&       COPTIC CAPITAL LETTER PSI
unicode_core_property(0x2CB0, 0x2CB0, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OOU
unicode_core_property(0x2CB2, 0x2CB2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB4, 0x2CB4, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB6, 0x2CB6, 'Uppercase').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB8, 0x2CB8, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBA, 0x2CBA, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DIALECT-P NI
unicode_core_property(0x2CBC, 0x2CBC, 'Uppercase').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBE, 0x2CBE, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC0, 0x2CC0, 'Uppercase').	% L&       COPTIC CAPITAL LETTER SAMPI
unicode_core_property(0x2CC2, 0x2CC2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER CROSSED SHEI
unicode_core_property(0x2CC4, 0x2CC4, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC6, 0x2CC6, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC8, 0x2CC8, 'Uppercase').	% L&       COPTIC CAPITAL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCA, 0x2CCA, 'Uppercase').	% L&       COPTIC CAPITAL LETTER DIALECT-P HORI
unicode_core_property(0x2CCC, 0x2CCC, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCE, 0x2CCE, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HA
unicode_core_property(0x2CD0, 0x2CD0, 'Uppercase').	% L&       COPTIC CAPITAL LETTER L-SHAPED HA
unicode_core_property(0x2CD2, 0x2CD2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD4, 0x2CD4, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD6, 0x2CD6, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD8, 0x2CD8, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDA, 0x2CDA, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDC, 0x2CDC, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDE, 0x2CDE, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE0, 0x2CE0, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE2, 0x2CE2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEB, 0x2CEB, 'Uppercase').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CED, 0x2CED, 'Uppercase').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF2, 'Uppercase').	% L&       COPTIC CAPITAL LETTER BOHAIRIC KHEI
unicode_core_property(0xA640, 0xA640, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZEMLYA
unicode_core_property(0xA642, 0xA642, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DZELO
unicode_core_property(0xA644, 0xA644, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER REVERSED DZE
unicode_core_property(0xA646, 0xA646, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTA
unicode_core_property(0xA648, 0xA648, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DJERV
unicode_core_property(0xA64A, 0xA64A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER MONOGRAPH UK
unicode_core_property(0xA64C, 0xA64C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BROAD OMEGA
unicode_core_property(0xA64E, 0xA64E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER NEUTRAL YER
unicode_core_property(0xA650, 0xA650, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER YERU WITH BACK YER
unicode_core_property(0xA652, 0xA652, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED YAT
unicode_core_property(0xA654, 0xA654, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER REVERSED YU
unicode_core_property(0xA656, 0xA656, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED A
unicode_core_property(0xA658, 0xA658, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65A, 0xA65A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BLENDED YUS
unicode_core_property(0xA65C, 0xA65C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65E, 0xA65E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER YN
unicode_core_property(0xA660, 0xA660, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER REVERSED TSE
unicode_core_property(0xA662, 0xA662, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SOFT DE
unicode_core_property(0xA664, 0xA664, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SOFT EL
unicode_core_property(0xA666, 0xA666, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SOFT EM
unicode_core_property(0xA668, 0xA668, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER MONOCULAR O
unicode_core_property(0xA66A, 0xA66A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER BINOCULAR O
unicode_core_property(0xA66C, 0xA66C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA680, 0xA680, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DWE
unicode_core_property(0xA682, 0xA682, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DZWE
unicode_core_property(0xA684, 0xA684, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER ZHWE
unicode_core_property(0xA686, 0xA686, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER CCHE
unicode_core_property(0xA688, 0xA688, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER DZZE
unicode_core_property(0xA68A, 0xA68A, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68C, 0xA68C, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TWE
unicode_core_property(0xA68E, 0xA68E, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TSWE
unicode_core_property(0xA690, 0xA690, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TSSE
unicode_core_property(0xA692, 0xA692, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER TCHE
unicode_core_property(0xA694, 0xA694, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER HWE
unicode_core_property(0xA696, 0xA696, 'Uppercase').	% L&       CYRILLIC CAPITAL LETTER SHWE
unicode_core_property(0xA722, 0xA722, 'Uppercase').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA724, 0xA724, 'Uppercase').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA726, 0xA726, 'Uppercase').	% L&       LATIN CAPITAL LETTER HENG
unicode_core_property(0xA728, 0xA728, 'Uppercase').	% L&       LATIN CAPITAL LETTER TZ
unicode_core_property(0xA72A, 0xA72A, 'Uppercase').	% L&       LATIN CAPITAL LETTER TRESILLO
unicode_core_property(0xA72C, 0xA72C, 'Uppercase').	% L&       LATIN CAPITAL LETTER CUATRILLO
unicode_core_property(0xA72E, 0xA72E, 'Uppercase').	% L&       LATIN CAPITAL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA732, 0xA732, 'Uppercase').	% L&       LATIN CAPITAL LETTER AA
unicode_core_property(0xA734, 0xA734, 'Uppercase').	% L&       LATIN CAPITAL LETTER AO
unicode_core_property(0xA736, 0xA736, 'Uppercase').	% L&       LATIN CAPITAL LETTER AU
unicode_core_property(0xA738, 0xA738, 'Uppercase').	% L&       LATIN CAPITAL LETTER AV
unicode_core_property(0xA73A, 0xA73A, 'Uppercase').	% L&       LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73C, 0xA73C, 'Uppercase').	% L&       LATIN CAPITAL LETTER AY
unicode_core_property(0xA73E, 0xA73E, 'Uppercase').	% L&       LATIN CAPITAL LETTER REVERSED C WITH DOT
unicode_core_property(0xA740, 0xA740, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH STROKE
unicode_core_property(0xA742, 0xA742, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA744, 0xA744, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA746, 0xA746, 'Uppercase').	% L&       LATIN CAPITAL LETTER BROKEN L
unicode_core_property(0xA748, 0xA748, 'Uppercase').	% L&       LATIN CAPITAL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74A, 0xA74A, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74C, 0xA74C, 'Uppercase').	% L&       LATIN CAPITAL LETTER O WITH LOOP
unicode_core_property(0xA74E, 0xA74E, 'Uppercase').	% L&       LATIN CAPITAL LETTER OO
unicode_core_property(0xA750, 0xA750, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA752, 0xA752, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH FLOURISH
unicode_core_property(0xA754, 0xA754, 'Uppercase').	% L&       LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA756, 0xA756, 'Uppercase').	% L&       LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA758, 0xA758, 'Uppercase').	% L&       LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75A, 0xA75A, 'Uppercase').	% L&       LATIN CAPITAL LETTER R ROTUNDA
unicode_core_property(0xA75C, 0xA75C, 'Uppercase').	% L&       LATIN CAPITAL LETTER RUM ROTUNDA
unicode_core_property(0xA75E, 0xA75E, 'Uppercase').	% L&       LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA760, 0xA760, 'Uppercase').	% L&       LATIN CAPITAL LETTER VY
unicode_core_property(0xA762, 0xA762, 'Uppercase').	% L&       LATIN CAPITAL LETTER VISIGOTHIC Z
unicode_core_property(0xA764, 0xA764, 'Uppercase').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE
unicode_core_property(0xA766, 0xA766, 'Uppercase').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA768, 0xA768, 'Uppercase').	% L&       LATIN CAPITAL LETTER VEND
unicode_core_property(0xA76A, 0xA76A, 'Uppercase').	% L&       LATIN CAPITAL LETTER ET
unicode_core_property(0xA76C, 0xA76C, 'Uppercase').	% L&       LATIN CAPITAL LETTER IS
unicode_core_property(0xA76E, 0xA76E, 'Uppercase').	% L&       LATIN CAPITAL LETTER CON
unicode_core_property(0xA779, 0xA779, 'Uppercase').	% L&       LATIN CAPITAL LETTER INSULAR D
unicode_core_property(0xA77B, 0xA77B, 'Uppercase').	% L&       LATIN CAPITAL LETTER INSULAR F
unicode_core_property(0xA77D, 0xA77E, 'Uppercase').	% L&   [2] LATIN CAPITAL LETTER INSULAR G..LATIN CAPITAL LETTER TURNED INSULAR G
unicode_core_property(0xA780, 0xA780, 'Uppercase').	% L&       LATIN CAPITAL LETTER TURNED L
unicode_core_property(0xA782, 0xA782, 'Uppercase').	% L&       LATIN CAPITAL LETTER INSULAR R
unicode_core_property(0xA784, 0xA784, 'Uppercase').	% L&       LATIN CAPITAL LETTER INSULAR S
unicode_core_property(0xA786, 0xA786, 'Uppercase').	% L&       LATIN CAPITAL LETTER INSULAR T
unicode_core_property(0xA78B, 0xA78B, 'Uppercase').	% L&       LATIN CAPITAL LETTER SALTILLO
unicode_core_property(0xA78D, 0xA78D, 'Uppercase').	% L&       LATIN CAPITAL LETTER TURNED H
unicode_core_property(0xA790, 0xA790, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH DESCENDER
unicode_core_property(0xA792, 0xA792, 'Uppercase').	% L&       LATIN CAPITAL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7A0, 'Uppercase').	% L&       LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A2, 0xA7A2, 'Uppercase').	% L&       LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A4, 0xA7A4, 'Uppercase').	% L&       LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A6, 0xA7A6, 'Uppercase').	% L&       LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A8, 0xA7A8, 'Uppercase').	% L&       LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xA7AA, 0xA7AA, 'Uppercase').	% L&       LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xFF21, 0xFF3A, 'Uppercase').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0x10400, 0x10427, 'Uppercase').	% L&  [40] DESERET CAPITAL LETTER LONG I..DESERET CAPITAL LETTER EW
unicode_core_property(0x1D400, 0x1D419, 'Uppercase').	% L&  [26] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL BOLD CAPITAL Z
unicode_core_property(0x1D434, 0x1D44D, 'Uppercase').	% L&  [26] MATHEMATICAL ITALIC CAPITAL A..MATHEMATICAL ITALIC CAPITAL Z
unicode_core_property(0x1D468, 0x1D481, 'Uppercase').	% L&  [26] MATHEMATICAL BOLD ITALIC CAPITAL A..MATHEMATICAL BOLD ITALIC CAPITAL Z
unicode_core_property(0x1D49C, 0x1D49C, 'Uppercase').	% L&       MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'Uppercase').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'Uppercase').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'Uppercase').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'Uppercase').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B5, 'Uppercase').	% L&   [8] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT CAPITAL Z
unicode_core_property(0x1D4D0, 0x1D4E9, 'Uppercase').	% L&  [26] MATHEMATICAL BOLD SCRIPT CAPITAL A..MATHEMATICAL BOLD SCRIPT CAPITAL Z
unicode_core_property(0x1D504, 0x1D505, 'Uppercase').	% L&   [2] MATHEMATICAL FRAKTUR CAPITAL A..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'Uppercase').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'Uppercase').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'Uppercase').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D538, 0x1D539, 'Uppercase').	% L&   [2] MATHEMATICAL DOUBLE-STRUCK CAPITAL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'Uppercase').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'Uppercase').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'Uppercase').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'Uppercase').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D56C, 0x1D585, 'Uppercase').	% L&  [26] MATHEMATICAL BOLD FRAKTUR CAPITAL A..MATHEMATICAL BOLD FRAKTUR CAPITAL Z
unicode_core_property(0x1D5A0, 0x1D5B9, 'Uppercase').	% L&  [26] MATHEMATICAL SANS-SERIF CAPITAL A..MATHEMATICAL SANS-SERIF CAPITAL Z
unicode_core_property(0x1D5D4, 0x1D5ED, 'Uppercase').	% L&  [26] MATHEMATICAL SANS-SERIF BOLD CAPITAL A..MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
unicode_core_property(0x1D608, 0x1D621, 'Uppercase').	% L&  [26] MATHEMATICAL SANS-SERIF ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
unicode_core_property(0x1D63C, 0x1D655, 'Uppercase').	% L&  [26] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
unicode_core_property(0x1D670, 0x1D689, 'Uppercase').	% L&  [26] MATHEMATICAL MONOSPACE CAPITAL A..MATHEMATICAL MONOSPACE CAPITAL Z
unicode_core_property(0x1D6A8, 0x1D6C0, 'Uppercase').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6E2, 0x1D6FA, 'Uppercase').	% L&  [25] MATHEMATICAL ITALIC CAPITAL ALPHA..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D71C, 0x1D734, 'Uppercase').	% L&  [25] MATHEMATICAL BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D756, 0x1D76E, 'Uppercase').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D790, 0x1D7A8, 'Uppercase').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7CA, 0x1D7CA, 'Uppercase').	% L&       MATHEMATICAL BOLD CAPITAL DIGAMMA

% Total code points: 1483

% ================================================

% Derived Property:   Cased (Cased)
%  As defined by Unicode Standard Definition D120
%  C has the Lowercase or Uppercase property or has a General_Category value of Titlecase_Letter.

unicode_core_property(0x0041, 0x005A, 'Cased').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x0061, 0x007A, 'Cased').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'Cased').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'Cased').	% L&       MICRO SIGN
unicode_core_property(0x00BA, 0x00BA, 'Cased').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'Cased').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'Cased').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'Cased').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BC, 0x01BF, 'Cased').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C4, 0x0293, 'Cased').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0295, 0x02AF, 'Cased').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02B8, 'Cased').	% Lm   [9] MODIFIER LETTER SMALL H..MODIFIER LETTER SMALL Y
unicode_core_property(0x02C0, 0x02C1, 'Cased').	% Lm   [2] MODIFIER LETTER GLOTTAL STOP..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02E0, 0x02E4, 'Cased').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x0345, 0x0345, 'Cased').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0370, 0x0373, 'Cased').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0376, 0x0377, 'Cased').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'Cased').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'Cased').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'Cased').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Cased').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Cased').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'Cased').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'Cased').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'Cased').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048A, 0x0527, 'Cased').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Cased').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0561, 0x0587, 'Cased').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x10A0, 0x10C5, 'Cased').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Cased').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Cased').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x1D00, 0x1D2B, 'Cased').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'Cased').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'Cased').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'Cased').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'Cased').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'Cased').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1E00, 0x1F15, 'Cased').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'Cased').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'Cased').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'Cased').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Cased').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'Cased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Cased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Cased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'Cased').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'Cased').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'Cased').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Cased').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Cased').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'Cased').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Cased').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'Cased').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'Cased').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'Cased').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'Cased').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2071, 0x2071, 'Cased').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'Cased').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'Cased').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x2102, 0x2102, 'Cased').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'Cased').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'Cased').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'Cased').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2119, 0x211D, 'Cased').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'Cased').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'Cased').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'Cased').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'Cased').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212F, 0x2134, 'Cased').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2139, 0x2139, 'Cased').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'Cased').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'Cased').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'Cased').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x217F, 'Cased').	% Nl  [32] ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2183, 0x2184, 'Cased').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x24B6, 0x24E9, 'Cased').	% So  [52] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Cased').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'Cased').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'Cased').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'Cased').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'Cased').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'Cased').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF3, 'Cased').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Cased').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Cased').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Cased').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0xA640, 0xA66D, 'Cased').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA680, 0xA697, 'Cased').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA722, 0xA76F, 'Cased').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'Cased').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'Cased').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA78B, 0xA78E, 'Cased').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'Cased').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'Cased').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'Cased').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'Cased').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xFB00, 0xFB06, 'Cased').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Cased').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF21, 0xFF3A, 'Cased').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF41, 0xFF5A, 'Cased').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0x10400, 0x1044F, 'Cased').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x1D400, 0x1D454, 'Cased').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'Cased').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'Cased').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'Cased').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'Cased').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'Cased').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'Cased').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'Cased').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'Cased').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'Cased').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'Cased').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'Cased').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'Cased').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'Cased').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'Cased').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'Cased').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'Cased').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'Cased').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'Cased').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'Cased').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'Cased').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'Cased').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'Cased').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'Cased').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'Cased').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'Cased').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'Cased').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'Cased').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'Cased').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'Cased').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA

% Total code points: 3448

% ================================================

% Derived Property:   Case_Ignorable (CI)
%  As defined by Unicode Standard Definition D121
%  C is defined to be case-ignorable if
%    Word_Break(C) = MidLetter or MidNumLet, or
%    General_Category(C) = Nonspacing_Mark (Mn), Enclosing_Mark (Me), Format (Cf), Modifier_Letter (Lm), or Modifier_Symbol (Sk).

unicode_core_property(0x0027, 0x0027, 'Case_Ignorable').	% Po       APOSTROPHE
unicode_core_property(0x002E, 0x002E, 'Case_Ignorable').	% Po       FULL STOP
unicode_core_property(0x003A, 0x003A, 'Case_Ignorable').	% Po       COLON
unicode_core_property(0x005E, 0x005E, 'Case_Ignorable').	% Sk       CIRCUMFLEX ACCENT
unicode_core_property(0x0060, 0x0060, 'Case_Ignorable').	% Sk       GRAVE ACCENT
unicode_core_property(0x00A8, 0x00A8, 'Case_Ignorable').	% Sk       DIAERESIS
unicode_core_property(0x00AD, 0x00AD, 'Case_Ignorable').	% Cf       SOFT HYPHEN
unicode_core_property(0x00AF, 0x00AF, 'Case_Ignorable').	% Sk       MACRON
unicode_core_property(0x00B4, 0x00B4, 'Case_Ignorable').	% Sk       ACUTE ACCENT
unicode_core_property(0x00B7, 0x00B7, 'Case_Ignorable').	% Po       MIDDLE DOT
unicode_core_property(0x00B8, 0x00B8, 'Case_Ignorable').	% Sk       CEDILLA
unicode_core_property(0x02B0, 0x02C1, 'Case_Ignorable').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C2, 0x02C5, 'Case_Ignorable').	% Sk   [4] MODIFIER LETTER LEFT ARROWHEAD..MODIFIER LETTER DOWN ARROWHEAD
unicode_core_property(0x02C6, 0x02D1, 'Case_Ignorable').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02D2, 0x02DF, 'Case_Ignorable').	% Sk  [14] MODIFIER LETTER CENTRED RIGHT HALF RING..MODIFIER LETTER CROSS ACCENT
unicode_core_property(0x02E0, 0x02E4, 'Case_Ignorable').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02E5, 0x02EB, 'Case_Ignorable').	% Sk   [7] MODIFIER LETTER EXTRA-HIGH TONE BAR..MODIFIER LETTER YANG DEPARTING TONE MARK
unicode_core_property(0x02EC, 0x02EC, 'Case_Ignorable').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02ED, 0x02ED, 'Case_Ignorable').	% Sk       MODIFIER LETTER UNASPIRATED
unicode_core_property(0x02EE, 0x02EE, 'Case_Ignorable').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x02EF, 0x02FF, 'Case_Ignorable').	% Sk  [17] MODIFIER LETTER LOW DOWN ARROWHEAD..MODIFIER LETTER LOW LEFT ARROW
unicode_core_property(0x0300, 0x036F, 'Case_Ignorable').	% Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
unicode_core_property(0x0374, 0x0374, 'Case_Ignorable').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0375, 0x0375, 'Case_Ignorable').	% Sk       GREEK LOWER NUMERAL SIGN
unicode_core_property(0x037A, 0x037A, 'Case_Ignorable').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x0384, 0x0385, 'Case_Ignorable').	% Sk   [2] GREEK TONOS..GREEK DIALYTIKA TONOS
unicode_core_property(0x0387, 0x0387, 'Case_Ignorable').	% Po       GREEK ANO TELEIA
unicode_core_property(0x0483, 0x0487, 'Case_Ignorable').	% Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
unicode_core_property(0x0488, 0x0489, 'Case_Ignorable').	% Me   [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
unicode_core_property(0x0559, 0x0559, 'Case_Ignorable').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0591, 0x05BD, 'Case_Ignorable').	% Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
unicode_core_property(0x05BF, 0x05BF, 'Case_Ignorable').	% Mn       HEBREW POINT RAFE
unicode_core_property(0x05C1, 0x05C2, 'Case_Ignorable').	% Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
unicode_core_property(0x05C4, 0x05C5, 'Case_Ignorable').	% Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
unicode_core_property(0x05C7, 0x05C7, 'Case_Ignorable').	% Mn       HEBREW POINT QAMATS QATAN
unicode_core_property(0x05F4, 0x05F4, 'Case_Ignorable').	% Po       HEBREW PUNCTUATION GERSHAYIM
unicode_core_property(0x0600, 0x0604, 'Case_Ignorable').	% Cf   [5] ARABIC NUMBER SIGN..ARABIC SIGN SAMVAT
unicode_core_property(0x0610, 0x061A, 'Case_Ignorable').	% Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
unicode_core_property(0x0640, 0x0640, 'Case_Ignorable').	% Lm       ARABIC TATWEEL
unicode_core_property(0x064B, 0x065F, 'Case_Ignorable').	% Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
unicode_core_property(0x0670, 0x0670, 'Case_Ignorable').	% Mn       ARABIC LETTER SUPERSCRIPT ALEF
unicode_core_property(0x06D6, 0x06DC, 'Case_Ignorable').	% Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
unicode_core_property(0x06DD, 0x06DD, 'Case_Ignorable').	% Cf       ARABIC END OF AYAH
unicode_core_property(0x06DF, 0x06E4, 'Case_Ignorable').	% Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
unicode_core_property(0x06E5, 0x06E6, 'Case_Ignorable').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06E7, 0x06E8, 'Case_Ignorable').	% Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
unicode_core_property(0x06EA, 0x06ED, 'Case_Ignorable').	% Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
unicode_core_property(0x070F, 0x070F, 'Case_Ignorable').	% Cf       SYRIAC ABBREVIATION MARK
unicode_core_property(0x0711, 0x0711, 'Case_Ignorable').	% Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
unicode_core_property(0x0730, 0x074A, 'Case_Ignorable').	% Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
unicode_core_property(0x07A6, 0x07B0, 'Case_Ignorable').	% Mn  [11] THAANA ABAFILI..THAANA SUKUN
unicode_core_property(0x07EB, 0x07F3, 'Case_Ignorable').	% Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
unicode_core_property(0x07F4, 0x07F5, 'Case_Ignorable').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'Case_Ignorable').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0816, 0x0819, 'Case_Ignorable').	% Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
unicode_core_property(0x081A, 0x07FA, 'Case_Ignorable').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x081B, 0x0823, 'Case_Ignorable').	% Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
unicode_core_property(0x0824, 0x0824, 'Case_Ignorable').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0825, 0x0827, 'Case_Ignorable').	% Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
unicode_core_property(0x0828, 0x0828, 'Case_Ignorable').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0829, 0x082D, 'Case_Ignorable').	% Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
unicode_core_property(0x0859, 0x085B, 'Case_Ignorable').	% Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
unicode_core_property(0x08E4, 0x08FE, 'Case_Ignorable').	% Mn  [27] ARABIC CURLY FATHA..ARABIC DAMMA WITH DOT
unicode_core_property(0x0900, 0x0902, 'Case_Ignorable').	% Mn   [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
unicode_core_property(0x093A, 0x093A, 'Case_Ignorable').	% Mn       DEVANAGARI VOWEL SIGN OE
unicode_core_property(0x093C, 0x093C, 'Case_Ignorable').	% Mn       DEVANAGARI SIGN NUKTA
unicode_core_property(0x0941, 0x0948, 'Case_Ignorable').	% Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
unicode_core_property(0x094D, 0x094D, 'Case_Ignorable').	% Mn       DEVANAGARI SIGN VIRAMA
unicode_core_property(0x0951, 0x0957, 'Case_Ignorable').	% Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
unicode_core_property(0x0962, 0x0963, 'Case_Ignorable').	% Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0971, 0x0971, 'Case_Ignorable').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0981, 0x0981, 'Case_Ignorable').	% Mn       BENGALI SIGN CANDRABINDU
unicode_core_property(0x09BC, 0x09BC, 'Case_Ignorable').	% Mn       BENGALI SIGN NUKTA
unicode_core_property(0x09C1, 0x09C4, 'Case_Ignorable').	% Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
unicode_core_property(0x09CD, 0x09CD, 'Case_Ignorable').	% Mn       BENGALI SIGN VIRAMA
unicode_core_property(0x09E2, 0x09E3, 'Case_Ignorable').	% Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0A01, 0x0A02, 'Case_Ignorable').	% Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
unicode_core_property(0x0A3C, 0x0A3C, 'Case_Ignorable').	% Mn       GURMUKHI SIGN NUKTA
unicode_core_property(0x0A41, 0x0A42, 'Case_Ignorable').	% Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
unicode_core_property(0x0A47, 0x0A48, 'Case_Ignorable').	% Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
unicode_core_property(0x0A4B, 0x0A4D, 'Case_Ignorable').	% Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
unicode_core_property(0x0A51, 0x0A51, 'Case_Ignorable').	% Mn       GURMUKHI SIGN UDAAT
unicode_core_property(0x0A70, 0x0A71, 'Case_Ignorable').	% Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
unicode_core_property(0x0A75, 0x0A75, 'Case_Ignorable').	% Mn       GURMUKHI SIGN YAKASH
unicode_core_property(0x0A81, 0x0A82, 'Case_Ignorable').	% Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
unicode_core_property(0x0ABC, 0x0ABC, 'Case_Ignorable').	% Mn       GUJARATI SIGN NUKTA
unicode_core_property(0x0AC1, 0x0AC5, 'Case_Ignorable').	% Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
unicode_core_property(0x0AC7, 0x0AC8, 'Case_Ignorable').	% Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
unicode_core_property(0x0ACD, 0x0ACD, 'Case_Ignorable').	% Mn       GUJARATI SIGN VIRAMA
unicode_core_property(0x0AE2, 0x0AE3, 'Case_Ignorable').	% Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B01, 0x0B01, 'Case_Ignorable').	% Mn       ORIYA SIGN CANDRABINDU
unicode_core_property(0x0B3C, 0x0B3C, 'Case_Ignorable').	% Mn       ORIYA SIGN NUKTA
unicode_core_property(0x0B3F, 0x0B3F, 'Case_Ignorable').	% Mn       ORIYA VOWEL SIGN I
unicode_core_property(0x0B41, 0x0B44, 'Case_Ignorable').	% Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0B4D, 0x0B4D, 'Case_Ignorable').	% Mn       ORIYA SIGN VIRAMA
unicode_core_property(0x0B56, 0x0B56, 'Case_Ignorable').	% Mn       ORIYA AI LENGTH MARK
unicode_core_property(0x0B62, 0x0B63, 'Case_Ignorable').	% Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B82, 0x0B82, 'Case_Ignorable').	% Mn       TAMIL SIGN ANUSVARA
unicode_core_property(0x0BC0, 0x0BC0, 'Case_Ignorable').	% Mn       TAMIL VOWEL SIGN II
unicode_core_property(0x0BCD, 0x0BCD, 'Case_Ignorable').	% Mn       TAMIL SIGN VIRAMA
unicode_core_property(0x0C3E, 0x0C40, 'Case_Ignorable').	% Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
unicode_core_property(0x0C46, 0x0C48, 'Case_Ignorable').	% Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
unicode_core_property(0x0C4A, 0x0C4D, 'Case_Ignorable').	% Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
unicode_core_property(0x0C55, 0x0C56, 'Case_Ignorable').	% Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
unicode_core_property(0x0C62, 0x0C63, 'Case_Ignorable').	% Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
unicode_core_property(0x0CBC, 0x0CBC, 'Case_Ignorable').	% Mn       KANNADA SIGN NUKTA
unicode_core_property(0x0CBF, 0x0CBF, 'Case_Ignorable').	% Mn       KANNADA VOWEL SIGN I
unicode_core_property(0x0CC6, 0x0CC6, 'Case_Ignorable').	% Mn       KANNADA VOWEL SIGN E
unicode_core_property(0x0CCC, 0x0CCD, 'Case_Ignorable').	% Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
unicode_core_property(0x0CE2, 0x0CE3, 'Case_Ignorable').	% Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0D41, 0x0D44, 'Case_Ignorable').	% Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
unicode_core_property(0x0D4D, 0x0D4D, 'Case_Ignorable').	% Mn       MALAYALAM SIGN VIRAMA
unicode_core_property(0x0D62, 0x0D63, 'Case_Ignorable').	% Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
unicode_core_property(0x0DCA, 0x0DCA, 'Case_Ignorable').	% Mn       SINHALA SIGN AL-LAKUNA
unicode_core_property(0x0DD2, 0x0DD4, 'Case_Ignorable').	% Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
unicode_core_property(0x0DD6, 0x0DD6, 'Case_Ignorable').	% Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
unicode_core_property(0x0E31, 0x0E31, 'Case_Ignorable').	% Mn       THAI CHARACTER MAI HAN-AKAT
unicode_core_property(0x0E34, 0x0E3A, 'Case_Ignorable').	% Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
unicode_core_property(0x0E46, 0x0E46, 'Case_Ignorable').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E47, 0x0E4E, 'Case_Ignorable').	% Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
unicode_core_property(0x0EB1, 0x0EB1, 'Case_Ignorable').	% Mn       LAO VOWEL SIGN MAI KAN
unicode_core_property(0x0EB4, 0x0EB9, 'Case_Ignorable').	% Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
unicode_core_property(0x0EBB, 0x0EBC, 'Case_Ignorable').	% Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
unicode_core_property(0x0EC6, 0x0EC6, 'Case_Ignorable').	% Lm       LAO KO LA
unicode_core_property(0x0EC8, 0x0ECD, 'Case_Ignorable').	% Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
unicode_core_property(0x0F18, 0x0F19, 'Case_Ignorable').	% Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
unicode_core_property(0x0F35, 0x0F35, 'Case_Ignorable').	% Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
unicode_core_property(0x0F37, 0x0F37, 'Case_Ignorable').	% Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
unicode_core_property(0x0F39, 0x0F39, 'Case_Ignorable').	% Mn       TIBETAN MARK TSA -PHRU
unicode_core_property(0x0F71, 0x0F7E, 'Case_Ignorable').	% Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
unicode_core_property(0x0F80, 0x0F84, 'Case_Ignorable').	% Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
unicode_core_property(0x0F86, 0x0F87, 'Case_Ignorable').	% Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
unicode_core_property(0x0F8D, 0x0F97, 'Case_Ignorable').	% Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
unicode_core_property(0x0F99, 0x0FBC, 'Case_Ignorable').	% Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
unicode_core_property(0x0FC6, 0x0FC6, 'Case_Ignorable').	% Mn       TIBETAN SYMBOL PADMA GDAN
unicode_core_property(0x102D, 0x1030, 'Case_Ignorable').	% Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
unicode_core_property(0x1032, 0x1037, 'Case_Ignorable').	% Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
unicode_core_property(0x1039, 0x103A, 'Case_Ignorable').	% Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
unicode_core_property(0x103D, 0x103E, 'Case_Ignorable').	% Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
unicode_core_property(0x1058, 0x1059, 'Case_Ignorable').	% Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
unicode_core_property(0x105E, 0x1060, 'Case_Ignorable').	% Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
unicode_core_property(0x1071, 0x1074, 'Case_Ignorable').	% Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
unicode_core_property(0x1082, 0x1082, 'Case_Ignorable').	% Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
unicode_core_property(0x1085, 0x1086, 'Case_Ignorable').	% Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
unicode_core_property(0x108D, 0x108D, 'Case_Ignorable').	% Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
unicode_core_property(0x109D, 0x109D, 'Case_Ignorable').	% Mn       MYANMAR VOWEL SIGN AITON AI
unicode_core_property(0x10FC, 0x10FC, 'Case_Ignorable').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x135D, 0x135F, 'Case_Ignorable').	% Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
unicode_core_property(0x1712, 0x1714, 'Case_Ignorable').	% Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
unicode_core_property(0x1732, 0x1734, 'Case_Ignorable').	% Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN PAMUDPOD
unicode_core_property(0x1752, 0x1753, 'Case_Ignorable').	% Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
unicode_core_property(0x1772, 0x1773, 'Case_Ignorable').	% Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
unicode_core_property(0x17B4, 0x17B5, 'Case_Ignorable').	% Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
unicode_core_property(0x17B7, 0x17BD, 'Case_Ignorable').	% Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
unicode_core_property(0x17C6, 0x17C6, 'Case_Ignorable').	% Mn       KHMER SIGN NIKAHIT
unicode_core_property(0x17C9, 0x17D3, 'Case_Ignorable').	% Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
unicode_core_property(0x17D7, 0x17D7, 'Case_Ignorable').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DD, 0x17DD, 'Case_Ignorable').	% Mn       KHMER SIGN ATTHACAN
unicode_core_property(0x180B, 0x180D, 'Case_Ignorable').	% Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
unicode_core_property(0x1843, 0x1843, 'Case_Ignorable').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x18A9, 0x18A9, 'Case_Ignorable').	% Mn       MONGOLIAN LETTER ALI GALI DAGALGA
unicode_core_property(0x1920, 0x1922, 'Case_Ignorable').	% Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
unicode_core_property(0x1927, 0x1928, 'Case_Ignorable').	% Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
unicode_core_property(0x1932, 0x1932, 'Case_Ignorable').	% Mn       LIMBU SMALL LETTER ANUSVARA
unicode_core_property(0x1939, 0x193B, 'Case_Ignorable').	% Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
unicode_core_property(0x1A17, 0x1A18, 'Case_Ignorable').	% Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
unicode_core_property(0x1A56, 0x1A56, 'Case_Ignorable').	% Mn       TAI THAM CONSONANT SIGN MEDIAL LA
unicode_core_property(0x1A58, 0x1A5E, 'Case_Ignorable').	% Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
unicode_core_property(0x1A60, 0x1A60, 'Case_Ignorable').	% Mn       TAI THAM SIGN SAKOT
unicode_core_property(0x1A62, 0x1A62, 'Case_Ignorable').	% Mn       TAI THAM VOWEL SIGN MAI SAT
unicode_core_property(0x1A65, 0x1A6C, 'Case_Ignorable').	% Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
unicode_core_property(0x1A73, 0x1A7C, 'Case_Ignorable').	% Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
unicode_core_property(0x1A7F, 0x1A7F, 'Case_Ignorable').	% Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
unicode_core_property(0x1AA7, 0x1AA7, 'Case_Ignorable').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B00, 0x1B03, 'Case_Ignorable').	% Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
unicode_core_property(0x1B34, 0x1B34, 'Case_Ignorable').	% Mn       BALINESE SIGN REREKAN
unicode_core_property(0x1B36, 0x1B3A, 'Case_Ignorable').	% Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
unicode_core_property(0x1B3C, 0x1B3C, 'Case_Ignorable').	% Mn       BALINESE VOWEL SIGN LA LENGA
unicode_core_property(0x1B42, 0x1B42, 'Case_Ignorable').	% Mn       BALINESE VOWEL SIGN PEPET
unicode_core_property(0x1B6B, 0x1B73, 'Case_Ignorable').	% Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
unicode_core_property(0x1B80, 0x1B81, 'Case_Ignorable').	% Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
unicode_core_property(0x1BA2, 0x1BA5, 'Case_Ignorable').	% Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
unicode_core_property(0x1BA8, 0x1BA9, 'Case_Ignorable').	% Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
unicode_core_property(0x1BAB, 0x1BAB, 'Case_Ignorable').	% Mn       SUNDANESE SIGN VIRAMA
unicode_core_property(0x1BE6, 0x1BE6, 'Case_Ignorable').	% Mn       BATAK SIGN TOMPI
unicode_core_property(0x1BE8, 0x1BE9, 'Case_Ignorable').	% Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
unicode_core_property(0x1BED, 0x1BED, 'Case_Ignorable').	% Mn       BATAK VOWEL SIGN KARO O
unicode_core_property(0x1BEF, 0x1BF1, 'Case_Ignorable').	% Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
unicode_core_property(0x1C2C, 0x1C33, 'Case_Ignorable').	% Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
unicode_core_property(0x1C36, 0x1C37, 'Case_Ignorable').	% Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
unicode_core_property(0x1C78, 0x1C7D, 'Case_Ignorable').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CD0, 0x1CD2, 'Case_Ignorable').	% Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
unicode_core_property(0x1CD4, 0x1CE0, 'Case_Ignorable').	% Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
unicode_core_property(0x1CE2, 0x1CE8, 'Case_Ignorable').	% Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
unicode_core_property(0x1CED, 0x1CED, 'Case_Ignorable').	% Mn       VEDIC SIGN TIRYAK
unicode_core_property(0x1CF4, 0x1CF4, 'Case_Ignorable').	% Mn       VEDIC TONE CANDRA ABOVE
unicode_core_property(0x1D2C, 0x1D6A, 'Case_Ignorable').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D78, 0x1D78, 'Case_Ignorable').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D9B, 0x1DBF, 'Case_Ignorable').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1DC0, 0x1DE6, 'Case_Ignorable').	% Mn  [39] COMBINING DOTTED GRAVE ACCENT..COMBINING LATIN SMALL LETTER Z
unicode_core_property(0x1DFC, 0x1DFF, 'Case_Ignorable').	% Mn   [4] COMBINING DOUBLE INVERTED BREVE BELOW..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
unicode_core_property(0x1FBD, 0x1FBD, 'Case_Ignorable').	% Sk       GREEK KORONIS
unicode_core_property(0x1FBF, 0x1FC1, 'Case_Ignorable').	% Sk   [3] GREEK PSILI..GREEK DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FCD, 0x1FCF, 'Case_Ignorable').	% Sk   [3] GREEK PSILI AND VARIA..GREEK PSILI AND PERISPOMENI
unicode_core_property(0x1FDD, 0x1FDF, 'Case_Ignorable').	% Sk   [3] GREEK DASIA AND VARIA..GREEK DASIA AND PERISPOMENI
unicode_core_property(0x1FED, 0x1FEF, 'Case_Ignorable').	% Sk   [3] GREEK DIALYTIKA AND VARIA..GREEK VARIA
unicode_core_property(0x1FFD, 0x1FFE, 'Case_Ignorable').	% Sk   [2] GREEK OXIA..GREEK DASIA
unicode_core_property(0x200B, 0x200F, 'Case_Ignorable').	% Cf   [5] ZERO WIDTH SPACE..RIGHT-TO-LEFT MARK
unicode_core_property(0x2018, 0x2018, 'Case_Ignorable').	% Pi       LEFT SINGLE QUOTATION MARK
unicode_core_property(0x2019, 0x2019, 'Case_Ignorable').	% Pf       RIGHT SINGLE QUOTATION MARK
unicode_core_property(0x2024, 0x2024, 'Case_Ignorable').	% Po       ONE DOT LEADER
unicode_core_property(0x2027, 0x2027, 'Case_Ignorable').	% Po       HYPHENATION POINT
unicode_core_property(0x202A, 0x202E, 'Case_Ignorable').	% Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
unicode_core_property(0x2060, 0x2064, 'Case_Ignorable').	% Cf   [5] WORD JOINER..INVISIBLE PLUS
unicode_core_property(0x206A, 0x206F, 'Case_Ignorable').	% Cf   [6] INHIBIT SYMMETRIC SWAPPING..NOMINAL DIGIT SHAPES
unicode_core_property(0x2071, 0x2071, 'Case_Ignorable').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'Case_Ignorable').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'Case_Ignorable').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x20D0, 0x20DC, 'Case_Ignorable').	% Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_core_property(0x20DD, 0x20E0, 'Case_Ignorable').	% Me   [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
unicode_core_property(0x20E1, 0x20E1, 'Case_Ignorable').	% Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_core_property(0x20E2, 0x20E4, 'Case_Ignorable').	% Me   [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
unicode_core_property(0x20E5, 0x20F0, 'Case_Ignorable').	% Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
unicode_core_property(0x2C7C, 0x2C7D, 'Case_Ignorable').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2CEF, 0x2CF1, 'Case_Ignorable').	% Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
unicode_core_property(0x2D6F, 0x2D6F, 'Case_Ignorable').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D7F, 0x2D7F, 'Case_Ignorable').	% Mn       TIFINAGH CONSONANT JOINER
unicode_core_property(0x2DE0, 0x2DFF, 'Case_Ignorable').	% Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
unicode_core_property(0x2E2F, 0x2E2F, 'Case_Ignorable').	% Lm       VERTICAL TILDE
unicode_core_property(0x3005, 0x3005, 'Case_Ignorable').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x302A, 0x302D, 'Case_Ignorable').	% Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
unicode_core_property(0x3031, 0x3035, 'Case_Ignorable').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x303B, 0x303B, 'Case_Ignorable').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3099, 0x309A, 'Case_Ignorable').	% Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309B, 0x309C, 'Case_Ignorable').	% Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309D, 0x309E, 'Case_Ignorable').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x30FC, 0x30FE, 'Case_Ignorable').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0xA015, 0xA015, 'Case_Ignorable').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA4F8, 0xA4FD, 'Case_Ignorable').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA60C, 0xA60C, 'Case_Ignorable').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA66F, 0xA66F, 'Case_Ignorable').	% Mn       COMBINING CYRILLIC VZMET
unicode_core_property(0xA670, 0xA672, 'Case_Ignorable').	% Me   [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
unicode_core_property(0xA674, 0xA67D, 'Case_Ignorable').	% Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
unicode_core_property(0xA67F, 0xA67F, 'Case_Ignorable').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA69F, 0xA69F, 'Case_Ignorable').	% Mn       COMBINING CYRILLIC LETTER IOTIFIED E
unicode_core_property(0xA6F0, 0xA6F1, 'Case_Ignorable').	% Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
unicode_core_property(0xA700, 0xA716, 'Case_Ignorable').	% Sk  [23] MODIFIER LETTER CHINESE TONE YIN PING..MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR
unicode_core_property(0xA717, 0xA71F, 'Case_Ignorable').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA720, 0xA721, 'Case_Ignorable').	% Sk   [2] MODIFIER LETTER STRESS AND HIGH TONE..MODIFIER LETTER STRESS AND LOW TONE
unicode_core_property(0xA770, 0xA770, 'Case_Ignorable').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA788, 0xA788, 'Case_Ignorable').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA789, 0xA78A, 'Case_Ignorable').	% Sk   [2] MODIFIER LETTER COLON..MODIFIER LETTER SHORT EQUALS SIGN
unicode_core_property(0xA7F8, 0xA7F9, 'Case_Ignorable').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA802, 0xA802, 'Case_Ignorable').	% Mn       SYLOTI NAGRI SIGN DVISVARA
unicode_core_property(0xA806, 0xA806, 'Case_Ignorable').	% Mn       SYLOTI NAGRI SIGN HASANTA
unicode_core_property(0xA80B, 0xA80B, 'Case_Ignorable').	% Mn       SYLOTI NAGRI SIGN ANUSVARA
unicode_core_property(0xA825, 0xA826, 'Case_Ignorable').	% Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
unicode_core_property(0xA8C4, 0xA8C4, 'Case_Ignorable').	% Mn       SAURASHTRA SIGN VIRAMA
unicode_core_property(0xA8E0, 0xA8F1, 'Case_Ignorable').	% Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0xA926, 0xA92D, 'Case_Ignorable').	% Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
unicode_core_property(0xA947, 0xA951, 'Case_Ignorable').	% Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
unicode_core_property(0xA980, 0xA982, 'Case_Ignorable').	% Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
unicode_core_property(0xA9B3, 0xA9B3, 'Case_Ignorable').	% Mn       JAVANESE SIGN CECAK TELU
unicode_core_property(0xA9B6, 0xA9B9, 'Case_Ignorable').	% Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
unicode_core_property(0xA9BC, 0xA9BC, 'Case_Ignorable').	% Mn       JAVANESE VOWEL SIGN PEPET
unicode_core_property(0xA9CF, 0xA9CF, 'Case_Ignorable').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xAA29, 0xAA2E, 'Case_Ignorable').	% Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
unicode_core_property(0xAA31, 0xAA32, 'Case_Ignorable').	% Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
unicode_core_property(0xAA35, 0xAA36, 'Case_Ignorable').	% Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
unicode_core_property(0xAA43, 0xAA43, 'Case_Ignorable').	% Mn       CHAM CONSONANT SIGN FINAL NG
unicode_core_property(0xAA4C, 0xAA4C, 'Case_Ignorable').	% Mn       CHAM CONSONANT SIGN FINAL M
unicode_core_property(0xAA70, 0xAA70, 'Case_Ignorable').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAAB0, 0xAAB0, 'Case_Ignorable').	% Mn       TAI VIET MAI KANG
unicode_core_property(0xAAB2, 0xAAB4, 'Case_Ignorable').	% Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
unicode_core_property(0xAAB7, 0xAAB8, 'Case_Ignorable').	% Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
unicode_core_property(0xAABE, 0xAABF, 'Case_Ignorable').	% Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
unicode_core_property(0xAAC1, 0xAAC1, 'Case_Ignorable').	% Mn       TAI VIET TONE MAI THO
unicode_core_property(0xAADD, 0xAADD, 'Case_Ignorable').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAEC, 0xAAED, 'Case_Ignorable').	% Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
unicode_core_property(0xAAF3, 0xAAF4, 'Case_Ignorable').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAAF6, 0xAAF6, 'Case_Ignorable').	% Mn       MEETEI MAYEK VIRAMA
unicode_core_property(0xABE5, 0xABE5, 'Case_Ignorable').	% Mn       MEETEI MAYEK VOWEL SIGN ANAP
unicode_core_property(0xABE8, 0xABE8, 'Case_Ignorable').	% Mn       MEETEI MAYEK VOWEL SIGN UNAP
unicode_core_property(0xABED, 0xABED, 'Case_Ignorable').	% Mn       MEETEI MAYEK APUN IYEK
unicode_core_property(0xFB1E, 0xFB1E, 'Case_Ignorable').	% Mn       HEBREW POINT JUDEO-SPANISH VARIKA
unicode_core_property(0xFBB2, 0xFBC1, 'Case_Ignorable').	% Sk  [16] ARABIC SYMBOL DOT ABOVE..ARABIC SYMBOL SMALL TAH BELOW
unicode_core_property(0xFE00, 0xFE0F, 'Case_Ignorable').	% Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
unicode_core_property(0xFE13, 0xFE13, 'Case_Ignorable').	% Po       PRESENTATION FORM FOR VERTICAL COLON
unicode_core_property(0xFE20, 0xFE26, 'Case_Ignorable').	% Mn   [7] COMBINING LIGATURE LEFT HALF..COMBINING CONJOINING MACRON
unicode_core_property(0xFE52, 0xFE52, 'Case_Ignorable').	% Po       SMALL FULL STOP
unicode_core_property(0xFE55, 0xFE55, 'Case_Ignorable').	% Po       SMALL COLON
unicode_core_property(0xFEFF, 0xFEFF, 'Case_Ignorable').	% Cf       ZERO WIDTH NO-BREAK SPACE
unicode_core_property(0xFF07, 0xFF07, 'Case_Ignorable').	% Po       FULLWIDTH APOSTROPHE
unicode_core_property(0xFF0E, 0xFF0E, 'Case_Ignorable').	% Po       FULLWIDTH FULL STOP
unicode_core_property(0xFF1A, 0xFF1A, 'Case_Ignorable').	% Po       FULLWIDTH COLON
unicode_core_property(0xFF3E, 0xFF3E, 'Case_Ignorable').	% Sk       FULLWIDTH CIRCUMFLEX ACCENT
unicode_core_property(0xFF40, 0xFF40, 'Case_Ignorable').	% Sk       FULLWIDTH GRAVE ACCENT
unicode_core_property(0xFF70, 0xFF70, 'Case_Ignorable').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF9E, 0xFF9F, 'Case_Ignorable').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0xFFE3, 0xFFE3, 'Case_Ignorable').	% Sk       FULLWIDTH MACRON
unicode_core_property(0xFFF9, 0xFFFB, 'Case_Ignorable').	% Cf   [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
unicode_core_property(0x101FD, 0x101FD, 'Case_Ignorable').	% Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
unicode_core_property(0x10A01, 0x10A03, 'Case_Ignorable').	% Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
unicode_core_property(0x10A05, 0x10A06, 'Case_Ignorable').	% Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
unicode_core_property(0x10A0C, 0x10A0F, 'Case_Ignorable').	% Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
unicode_core_property(0x10A38, 0x10A3A, 'Case_Ignorable').	% Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
unicode_core_property(0x10A3F, 0x10A3F, 'Case_Ignorable').	% Mn       KHAROSHTHI VIRAMA
unicode_core_property(0x11001, 0x11001, 'Case_Ignorable').	% Mn       BRAHMI SIGN ANUSVARA
unicode_core_property(0x11038, 0x11046, 'Case_Ignorable').	% Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
unicode_core_property(0x11080, 0x11081, 'Case_Ignorable').	% Mn   [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
unicode_core_property(0x110B3, 0x110B6, 'Case_Ignorable').	% Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
unicode_core_property(0x110B9, 0x110BA, 'Case_Ignorable').	% Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
unicode_core_property(0x110BD, 0x110BD, 'Case_Ignorable').	% Cf       KAITHI NUMBER SIGN
unicode_core_property(0x11100, 0x11102, 'Case_Ignorable').	% Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
unicode_core_property(0x11127, 0x1112B, 'Case_Ignorable').	% Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
unicode_core_property(0x1112D, 0x11134, 'Case_Ignorable').	% Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
unicode_core_property(0x11180, 0x11181, 'Case_Ignorable').	% Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
unicode_core_property(0x111B6, 0x111BE, 'Case_Ignorable').	% Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
unicode_core_property(0x116AB, 0x116AB, 'Case_Ignorable').	% Mn       TAKRI SIGN ANUSVARA
unicode_core_property(0x116AD, 0x116AD, 'Case_Ignorable').	% Mn       TAKRI VOWEL SIGN AA
unicode_core_property(0x116B0, 0x116B5, 'Case_Ignorable').	% Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
unicode_core_property(0x116B7, 0x116B7, 'Case_Ignorable').	% Mn       TAKRI SIGN NUKTA
unicode_core_property(0x16F8F, 0x16F92, 'Case_Ignorable').	% Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
unicode_core_property(0x16F93, 0x16F9F, 'Case_Ignorable').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1D167, 0x1D169, 'Case_Ignorable').	% Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
unicode_core_property(0x1D173, 0x1D17A, 'Case_Ignorable').	% Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
unicode_core_property(0x1D17B, 0x1D182, 'Case_Ignorable').	% Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
unicode_core_property(0x1D185, 0x1D18B, 'Case_Ignorable').	% Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
unicode_core_property(0x1D1AA, 0x1D1AD, 'Case_Ignorable').	% Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
unicode_core_property(0x1D242, 0x1D244, 'Case_Ignorable').	% Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
unicode_core_property(0xE0001, 0xE0001, 'Case_Ignorable').	% Cf       LANGUAGE TAG
unicode_core_property(0xE0020, 0xE007F, 'Case_Ignorable').	% Cf  [96] TAG SPACE..CANCEL TAG
unicode_core_property(0xE0100, 0xE01EF, 'Case_Ignorable').	% Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256

% Total code points: 1799

% ================================================

% Derived Property:   Changes_When_Lowercased (CWL)
%  Characters whose normalized forms are not stable under a toLowercase mapping.
%  For more information, see D124 in Section 3.13, "Default Case Algorithms".
%  Changes_When_Lowercased(X) is true when toLowercase(toNFD(X)) != toNFD(X)

unicode_core_property(0x0041, 0x005A, 'Changes_When_Lowercased').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x00C0, 0x00D6, 'Changes_When_Lowercased').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00DE, 'Changes_When_Lowercased').	% L&   [7] LATIN CAPITAL LETTER O WITH STROKE..LATIN CAPITAL LETTER THORN
unicode_core_property(0x0100, 0x0100, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH MACRON
unicode_core_property(0x0102, 0x0102, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE
unicode_core_property(0x0104, 0x0104, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH OGONEK
unicode_core_property(0x0106, 0x0106, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH ACUTE
unicode_core_property(0x0108, 0x0108, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010A, 0x010A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH DOT ABOVE
unicode_core_property(0x010C, 0x010C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH CARON
unicode_core_property(0x010E, 0x010E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH CARON
unicode_core_property(0x0110, 0x0110, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH STROKE
unicode_core_property(0x0112, 0x0112, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH MACRON
unicode_core_property(0x0114, 0x0114, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH BREVE
unicode_core_property(0x0116, 0x0116, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH DOT ABOVE
unicode_core_property(0x0118, 0x0118, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH OGONEK
unicode_core_property(0x011A, 0x011A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CARON
unicode_core_property(0x011C, 0x011C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011E, 0x011E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH BREVE
unicode_core_property(0x0120, 0x0120, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH DOT ABOVE
unicode_core_property(0x0122, 0x0122, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH CEDILLA
unicode_core_property(0x0124, 0x0124, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0126, 0x0126, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH STROKE
unicode_core_property(0x0128, 0x0128, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH TILDE
unicode_core_property(0x012A, 0x012A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH MACRON
unicode_core_property(0x012C, 0x012C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH BREVE
unicode_core_property(0x012E, 0x012E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH OGONEK
unicode_core_property(0x0130, 0x0130, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH DOT ABOVE
unicode_core_property(0x0132, 0x0132, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LIGATURE IJ
unicode_core_property(0x0134, 0x0134, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0136, 0x0136, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH CEDILLA
unicode_core_property(0x0139, 0x0139, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH ACUTE
unicode_core_property(0x013B, 0x013B, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH CEDILLA
unicode_core_property(0x013D, 0x013D, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH CARON
unicode_core_property(0x013F, 0x013F, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0141, 0x0141, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH STROKE
unicode_core_property(0x0143, 0x0143, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH ACUTE
unicode_core_property(0x0145, 0x0145, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH CEDILLA
unicode_core_property(0x0147, 0x0147, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH CARON
unicode_core_property(0x014A, 0x014A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER ENG
unicode_core_property(0x014C, 0x014C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH MACRON
unicode_core_property(0x014E, 0x014E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH BREVE
unicode_core_property(0x0150, 0x0150, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0152, 0x0152, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LIGATURE OE
unicode_core_property(0x0154, 0x0154, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH ACUTE
unicode_core_property(0x0156, 0x0156, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH CEDILLA
unicode_core_property(0x0158, 0x0158, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH CARON
unicode_core_property(0x015A, 0x015A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH ACUTE
unicode_core_property(0x015C, 0x015C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015E, 0x015E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH CEDILLA
unicode_core_property(0x0160, 0x0160, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH CARON
unicode_core_property(0x0162, 0x0162, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH CEDILLA
unicode_core_property(0x0164, 0x0164, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH CARON
unicode_core_property(0x0166, 0x0166, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH STROKE
unicode_core_property(0x0168, 0x0168, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH TILDE
unicode_core_property(0x016A, 0x016A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH MACRON
unicode_core_property(0x016C, 0x016C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH BREVE
unicode_core_property(0x016E, 0x016E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH RING ABOVE
unicode_core_property(0x0170, 0x0170, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0172, 0x0172, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH OGONEK
unicode_core_property(0x0174, 0x0174, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0176, 0x0176, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x0178, 0x0179, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER Y WITH DIAERESIS..LATIN CAPITAL LETTER Z WITH ACUTE
unicode_core_property(0x017B, 0x017B, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017D, 0x017D, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH CARON
unicode_core_property(0x0181, 0x0182, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER B WITH HOOK..LATIN CAPITAL LETTER B WITH TOPBAR
unicode_core_property(0x0184, 0x0184, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TONE SIX
unicode_core_property(0x0186, 0x0187, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER OPEN O..LATIN CAPITAL LETTER C WITH HOOK
unicode_core_property(0x0189, 0x018B, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER AFRICAN D..LATIN CAPITAL LETTER D WITH TOPBAR
unicode_core_property(0x018E, 0x0191, 'Changes_When_Lowercased').	% L&   [4] LATIN CAPITAL LETTER REVERSED E..LATIN CAPITAL LETTER F WITH HOOK
unicode_core_property(0x0193, 0x0194, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER G WITH HOOK..LATIN CAPITAL LETTER GAMMA
unicode_core_property(0x0196, 0x0198, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER IOTA..LATIN CAPITAL LETTER K WITH HOOK
unicode_core_property(0x019C, 0x019D, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER N WITH LEFT HOOK
unicode_core_property(0x019F, 0x01A0, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER O WITH MIDDLE TILDE..LATIN CAPITAL LETTER O WITH HORN
unicode_core_property(0x01A2, 0x01A2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER OI
unicode_core_property(0x01A4, 0x01A4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH HOOK
unicode_core_property(0x01A6, 0x01A7, 'Changes_When_Lowercased').	% L&   [2] LATIN LETTER YR..LATIN CAPITAL LETTER TONE TWO
unicode_core_property(0x01A9, 0x01A9, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER ESH
unicode_core_property(0x01AC, 0x01AC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH HOOK
unicode_core_property(0x01AE, 0x01AF, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER T WITH RETROFLEX HOOK..LATIN CAPITAL LETTER U WITH HORN
unicode_core_property(0x01B1, 0x01B3, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER UPSILON..LATIN CAPITAL LETTER Y WITH HOOK
unicode_core_property(0x01B5, 0x01B5, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH STROKE
unicode_core_property(0x01B7, 0x01B8, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER EZH..LATIN CAPITAL LETTER EZH REVERSED
unicode_core_property(0x01BC, 0x01BC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TONE FIVE
unicode_core_property(0x01C4, 0x01C5, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER DZ WITH CARON..LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
unicode_core_property(0x01C7, 0x01C8, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER LJ..LATIN CAPITAL LETTER L WITH SMALL LETTER J
unicode_core_property(0x01CA, 0x01CB, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER NJ..LATIN CAPITAL LETTER N WITH SMALL LETTER J
unicode_core_property(0x01CD, 0x01CD, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CARON
unicode_core_property(0x01CF, 0x01CF, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH CARON
unicode_core_property(0x01D1, 0x01D1, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CARON
unicode_core_property(0x01D3, 0x01D3, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH CARON
unicode_core_property(0x01D5, 0x01D5, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D7, 0x01D7, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01D9, 0x01D9, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DB, 0x01DB, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
unicode_core_property(0x01DE, 0x01DE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E0, 0x01E0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E2, 0x01E2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AE WITH MACRON
unicode_core_property(0x01E4, 0x01E4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH STROKE
unicode_core_property(0x01E6, 0x01E6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH CARON
unicode_core_property(0x01E8, 0x01E8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH CARON
unicode_core_property(0x01EA, 0x01EA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH OGONEK
unicode_core_property(0x01EC, 0x01EC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EE, 0x01EE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER EZH WITH CARON
unicode_core_property(0x01F1, 0x01F2, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER DZ..LATIN CAPITAL LETTER D WITH SMALL LETTER Z
unicode_core_property(0x01F4, 0x01F4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH ACUTE
unicode_core_property(0x01F6, 0x01F8, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER HWAIR..LATIN CAPITAL LETTER N WITH GRAVE
unicode_core_property(0x01FA, 0x01FA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FC, 0x01FC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AE WITH ACUTE
unicode_core_property(0x01FE, 0x01FE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0200, 0x0200, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0202, 0x0202, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0204, 0x0204, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0206, 0x0206, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0208, 0x0208, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020A, 0x020A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020C, 0x020C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020E, 0x020E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0210, 0x0210, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0212, 0x0212, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0214, 0x0214, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0216, 0x0216, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0218, 0x0218, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH COMMA BELOW
unicode_core_property(0x021A, 0x021A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH COMMA BELOW
unicode_core_property(0x021C, 0x021C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER YOGH
unicode_core_property(0x021E, 0x021E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH CARON
unicode_core_property(0x0220, 0x0220, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x0222, 0x0222, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER OU
unicode_core_property(0x0224, 0x0224, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH HOOK
unicode_core_property(0x0226, 0x0226, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE
unicode_core_property(0x0228, 0x0228, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA
unicode_core_property(0x022A, 0x022A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022C, 0x022C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022E, 0x022E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE
unicode_core_property(0x0230, 0x0230, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0232, 0x0232, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH MACRON
unicode_core_property(0x023A, 0x023B, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER A WITH STROKE..LATIN CAPITAL LETTER C WITH STROKE
unicode_core_property(0x023D, 0x023E, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER L WITH BAR..LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x0241, 0x0241, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER GLOTTAL STOP
unicode_core_property(0x0243, 0x0246, 'Changes_When_Lowercased').	% L&   [4] LATIN CAPITAL LETTER B WITH STROKE..LATIN CAPITAL LETTER E WITH STROKE
unicode_core_property(0x0248, 0x0248, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER J WITH STROKE
unicode_core_property(0x024A, 0x024A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
unicode_core_property(0x024C, 0x024C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH STROKE
unicode_core_property(0x024E, 0x024E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH STROKE
unicode_core_property(0x0370, 0x0370, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER HETA
unicode_core_property(0x0372, 0x0372, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER ARCHAIC SAMPI
unicode_core_property(0x0376, 0x0376, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x0386, 0x0386, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Changes_When_Lowercased').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x038F, 'Changes_When_Lowercased').	% L&   [2] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER OMEGA WITH TONOS
unicode_core_property(0x0391, 0x03A1, 'Changes_When_Lowercased').	% L&  [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03AB, 'Changes_When_Lowercased').	% L&   [9] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
unicode_core_property(0x03CF, 0x03CF, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL KAI SYMBOL
unicode_core_property(0x03D8, 0x03D8, 'Changes_When_Lowercased').	% L&       GREEK LETTER ARCHAIC KOPPA
unicode_core_property(0x03DA, 0x03DA, 'Changes_When_Lowercased').	% L&       GREEK LETTER STIGMA
unicode_core_property(0x03DC, 0x03DC, 'Changes_When_Lowercased').	% L&       GREEK LETTER DIGAMMA
unicode_core_property(0x03DE, 0x03DE, 'Changes_When_Lowercased').	% L&       GREEK LETTER KOPPA
unicode_core_property(0x03E0, 0x03E0, 'Changes_When_Lowercased').	% L&       GREEK LETTER SAMPI
unicode_core_property(0x03E2, 0x03E2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER SHEI
unicode_core_property(0x03E4, 0x03E4, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER FEI
unicode_core_property(0x03E6, 0x03E6, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER KHEI
unicode_core_property(0x03E8, 0x03E8, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER HORI
unicode_core_property(0x03EA, 0x03EA, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER GANGIA
unicode_core_property(0x03EC, 0x03EC, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER SHIMA
unicode_core_property(0x03EE, 0x03EE, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DEI
unicode_core_property(0x03F4, 0x03F4, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL THETA SYMBOL
unicode_core_property(0x03F7, 0x03F7, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER SHO
unicode_core_property(0x03F9, 0x03FA, 'Changes_When_Lowercased').	% L&   [2] GREEK CAPITAL LUNATE SIGMA SYMBOL..GREEK CAPITAL LETTER SAN
unicode_core_property(0x03FD, 0x042F, 'Changes_When_Lowercased').	% L&  [51] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC CAPITAL LETTER YA
unicode_core_property(0x0460, 0x0460, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER OMEGA
unicode_core_property(0x0462, 0x0462, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER YAT
unicode_core_property(0x0464, 0x0464, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED E
unicode_core_property(0x0466, 0x0466, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER LITTLE YUS
unicode_core_property(0x0468, 0x0468, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046A, 0x046A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BIG YUS
unicode_core_property(0x046C, 0x046C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046E, 0x046E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KSI
unicode_core_property(0x0470, 0x0470, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER PSI
unicode_core_property(0x0472, 0x0472, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER FITA
unicode_core_property(0x0474, 0x0474, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IZHITSA
unicode_core_property(0x0476, 0x0476, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0478, 0x0478, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER UK
unicode_core_property(0x047A, 0x047A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ROUND OMEGA
unicode_core_property(0x047C, 0x047C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
unicode_core_property(0x047E, 0x047E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER OT
unicode_core_property(0x0480, 0x0480, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOPPA
unicode_core_property(0x048A, 0x048A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
unicode_core_property(0x048C, 0x048C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SEMISOFT SIGN
unicode_core_property(0x048E, 0x048E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ER WITH TICK
unicode_core_property(0x0490, 0x0490, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER GHE WITH UPTURN
unicode_core_property(0x0492, 0x0492, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE
unicode_core_property(0x0494, 0x0494, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0496, 0x0496, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0498, 0x0498, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
unicode_core_property(0x049A, 0x049A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KA WITH DESCENDER
unicode_core_property(0x049C, 0x049C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049E, 0x049E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KA WITH STROKE
unicode_core_property(0x04A0, 0x04A0, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BASHKIR KA
unicode_core_property(0x04A2, 0x04A2, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EN WITH DESCENDER
unicode_core_property(0x04A4, 0x04A4, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LIGATURE EN GHE
unicode_core_property(0x04A6, 0x04A6, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A8, 0x04A8, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN HA
unicode_core_property(0x04AA, 0x04AA, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ES WITH DESCENDER
unicode_core_property(0x04AC, 0x04AC, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TE WITH DESCENDER
unicode_core_property(0x04AE, 0x04AE, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U
unicode_core_property(0x04B0, 0x04B0, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B2, 0x04B2, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER HA WITH DESCENDER
unicode_core_property(0x04B4, 0x04B4, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LIGATURE TE TSE
unicode_core_property(0x04B6, 0x04B6, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B8, 0x04B8, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BA, 0x04BA, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SHHA
unicode_core_property(0x04BC, 0x04BC, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE
unicode_core_property(0x04BE, 0x04BE, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C0, 0x04C1, 'Changes_When_Lowercased').	% L&   [2] CYRILLIC LETTER PALOCHKA..CYRILLIC CAPITAL LETTER ZHE WITH BREVE
unicode_core_property(0x04C3, 0x04C3, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KA WITH HOOK
unicode_core_property(0x04C5, 0x04C5, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EL WITH TAIL
unicode_core_property(0x04C7, 0x04C7, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EN WITH HOOK
unicode_core_property(0x04C9, 0x04C9, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EN WITH TAIL
unicode_core_property(0x04CB, 0x04CB, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CD, 0x04CD, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EM WITH TAIL
unicode_core_property(0x04D0, 0x04D0, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER A WITH BREVE
unicode_core_property(0x04D2, 0x04D2, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER A WITH DIAERESIS
unicode_core_property(0x04D4, 0x04D4, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LIGATURE A IE
unicode_core_property(0x04D6, 0x04D6, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IE WITH BREVE
unicode_core_property(0x04D8, 0x04D8, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SCHWA
unicode_core_property(0x04DA, 0x04DA, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DC, 0x04DC, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DE, 0x04DE, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E0, 0x04E0, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN DZE
unicode_core_property(0x04E2, 0x04E2, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER I WITH MACRON
unicode_core_property(0x04E4, 0x04E4, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER I WITH DIAERESIS
unicode_core_property(0x04E6, 0x04E6, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x04E8, 0x04E8, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BARRED O
unicode_core_property(0x04EA, 0x04EA, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04EC, 0x04EC, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER E WITH DIAERESIS
unicode_core_property(0x04EE, 0x04EE, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER U WITH MACRON
unicode_core_property(0x04F0, 0x04F0, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER U WITH DIAERESIS
unicode_core_property(0x04F2, 0x04F2, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F4, 0x04F4, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F6, 0x04F6, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F8, 0x04F8, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FA, 0x04FA, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FC, 0x04FC, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER HA WITH HOOK
unicode_core_property(0x04FE, 0x04FE, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER HA WITH STROKE
unicode_core_property(0x0500, 0x0500, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI DE
unicode_core_property(0x0502, 0x0502, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI DJE
unicode_core_property(0x0504, 0x0504, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI ZJE
unicode_core_property(0x0506, 0x0506, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI DZJE
unicode_core_property(0x0508, 0x0508, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI LJE
unicode_core_property(0x050A, 0x050A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI NJE
unicode_core_property(0x050C, 0x050C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI SJE
unicode_core_property(0x050E, 0x050E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER KOMI TJE
unicode_core_property(0x0510, 0x0510, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER REVERSED ZE
unicode_core_property(0x0512, 0x0512, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EL WITH HOOK
unicode_core_property(0x0514, 0x0514, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER LHA
unicode_core_property(0x0516, 0x0516, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER RHA
unicode_core_property(0x0518, 0x0518, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER YAE
unicode_core_property(0x051A, 0x051A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER QA
unicode_core_property(0x051C, 0x051C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER WE
unicode_core_property(0x051E, 0x051E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ALEUT KA
unicode_core_property(0x0520, 0x0520, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0522, 0x0522, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0524, 0x0524, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER PE WITH DESCENDER
unicode_core_property(0x0526, 0x0526, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Changes_When_Lowercased').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x10A0, 0x10C5, 'Changes_When_Lowercased').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Changes_When_Lowercased').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Changes_When_Lowercased').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x1E00, 0x1E00, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH RING BELOW
unicode_core_property(0x1E02, 0x1E02, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E04, 0x1E04, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER B WITH DOT BELOW
unicode_core_property(0x1E06, 0x1E06, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER B WITH LINE BELOW
unicode_core_property(0x1E08, 0x1E08, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0A, 0x1E0A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0C, 0x1E0C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0E, 0x1E0E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH LINE BELOW
unicode_core_property(0x1E10, 0x1E10, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH CEDILLA
unicode_core_property(0x1E12, 0x1E12, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E14, 0x1E14, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E16, 0x1E16, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E18, 0x1E18, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1A, 0x1E1A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1C, 0x1E1C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1E, 0x1E1E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E20, 0x1E20, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH MACRON
unicode_core_property(0x1E22, 0x1E22, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E24, 0x1E24, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH DOT BELOW
unicode_core_property(0x1E26, 0x1E26, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH DIAERESIS
unicode_core_property(0x1E28, 0x1E28, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH CEDILLA
unicode_core_property(0x1E2A, 0x1E2A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2C, 0x1E2C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2E, 0x1E2E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E30, 0x1E30, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH ACUTE
unicode_core_property(0x1E32, 0x1E32, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH DOT BELOW
unicode_core_property(0x1E34, 0x1E34, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH LINE BELOW
unicode_core_property(0x1E36, 0x1E36, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW
unicode_core_property(0x1E38, 0x1E38, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3A, 0x1E3A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3C, 0x1E3C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3E, 0x1E3E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER M WITH ACUTE
unicode_core_property(0x1E40, 0x1E40, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E42, 0x1E42, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER M WITH DOT BELOW
unicode_core_property(0x1E44, 0x1E44, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E46, 0x1E46, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH DOT BELOW
unicode_core_property(0x1E48, 0x1E48, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4A, 0x1E4A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4C, 0x1E4C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4E, 0x1E4E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E50, 0x1E50, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E52, 0x1E52, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E54, 0x1E54, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH ACUTE
unicode_core_property(0x1E56, 0x1E56, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E58, 0x1E58, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5A, 0x1E5A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5C, 0x1E5C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5E, 0x1E5E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH LINE BELOW
unicode_core_property(0x1E60, 0x1E60, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E62, 0x1E62, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW
unicode_core_property(0x1E64, 0x1E64, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E66, 0x1E66, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E68, 0x1E68, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6A, 0x1E6A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6C, 0x1E6C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6E, 0x1E6E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH LINE BELOW
unicode_core_property(0x1E70, 0x1E70, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E72, 0x1E72, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E74, 0x1E74, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E76, 0x1E76, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E78, 0x1E78, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7A, 0x1E7A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7C, 0x1E7C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER V WITH TILDE
unicode_core_property(0x1E7E, 0x1E7E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER V WITH DOT BELOW
unicode_core_property(0x1E80, 0x1E80, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH GRAVE
unicode_core_property(0x1E82, 0x1E82, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH ACUTE
unicode_core_property(0x1E84, 0x1E84, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH DIAERESIS
unicode_core_property(0x1E86, 0x1E86, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E88, 0x1E88, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8A, 0x1E8A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8C, 0x1E8C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8E, 0x1E8E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E90, 0x1E90, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E92, 0x1E92, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E94, 0x1E94, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH LINE BELOW
unicode_core_property(0x1E9E, 0x1E9E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER SHARP S
unicode_core_property(0x1EA0, 0x1EA0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA2, 0x1EA2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA4, 0x1EA4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA6, 0x1EA6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA8, 0x1EA8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAA, 0x1EAA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAC, 0x1EAC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAE, 0x1EAE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB0, 0x1EB0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB2, 0x1EB2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB4, 0x1EB4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB6, 0x1EB6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB8, 0x1EB8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBA, 0x1EBA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBC, 0x1EBC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH TILDE
unicode_core_property(0x1EBE, 0x1EBE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC0, 0x1EC0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC2, 0x1EC2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC4, 0x1EC4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC6, 0x1EC6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC8, 0x1EC8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECA, 0x1ECA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECC, 0x1ECC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECE, 0x1ECE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED0, 0x1ED0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED2, 0x1ED2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED4, 0x1ED4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED6, 0x1ED6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED8, 0x1ED8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDA, 0x1EDA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDC, 0x1EDC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDE, 0x1EDE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE0, 0x1EE0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE2, 0x1EE2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE4, 0x1EE4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE6, 0x1EE6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE8, 0x1EE8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEA, 0x1EEA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EEC, 0x1EEC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEE, 0x1EEE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF0, 0x1EF0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF2, 0x1EF2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH GRAVE
unicode_core_property(0x1EF4, 0x1EF4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF6, 0x1EF6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF8, 0x1EF8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH TILDE
unicode_core_property(0x1EFA, 0x1EFA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFC, 0x1EFC, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFE, 0x1EFE, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Y WITH LOOP
unicode_core_property(0x1F08, 0x1F0F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F18, 0x1F1D, 'Changes_When_Lowercased').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F28, 0x1F2F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F38, 0x1F3F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER IOTA WITH PSILI..GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F48, 0x1F4D, 'Changes_When_Lowercased').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F59, 0x1F59, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F5F, 'Changes_When_Lowercased').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F68, 0x1F6F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F88, 0x1F8F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
unicode_core_property(0x1F98, 0x1F9F, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
unicode_core_property(0x1FA8, 0x1FAF, 'Changes_When_Lowercased').	% L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
unicode_core_property(0x1FB8, 0x1FBC, 'Changes_When_Lowercased').	% L&   [5] GREEK CAPITAL LETTER ALPHA WITH VRACHY..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FC8, 0x1FCC, 'Changes_When_Lowercased').	% L&   [5] GREEK CAPITAL LETTER EPSILON WITH VARIA..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD8, 0x1FDB, 'Changes_When_Lowercased').	% L&   [4] GREEK CAPITAL LETTER IOTA WITH VRACHY..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE8, 0x1FEC, 'Changes_When_Lowercased').	% L&   [5] GREEK CAPITAL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF8, 0x1FFC, 'Changes_When_Lowercased').	% L&   [5] GREEK CAPITAL LETTER OMICRON WITH VARIA..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2126, 0x2126, 'Changes_When_Lowercased').	% L&       OHM SIGN
unicode_core_property(0x212A, 0x212B, 'Changes_When_Lowercased').	% L&   [2] KELVIN SIGN..ANGSTROM SIGN
unicode_core_property(0x2132, 0x2132, 'Changes_When_Lowercased').	% L&       TURNED CAPITAL F
unicode_core_property(0x2160, 0x216F, 'Changes_When_Lowercased').	% Nl  [16] ROMAN NUMERAL ONE..ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2183, 0x2183, 'Changes_When_Lowercased').	% L&       ROMAN NUMERAL REVERSED ONE HUNDRED
unicode_core_property(0x24B6, 0x24CF, 'Changes_When_Lowercased').	% So  [26] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN CAPITAL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Changes_When_Lowercased').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C60, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C62, 0x2C64, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER L WITH MIDDLE TILDE..LATIN CAPITAL LETTER R WITH TAIL
unicode_core_property(0x2C67, 0x2C67, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH DESCENDER
unicode_core_property(0x2C69, 0x2C69, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH DESCENDER
unicode_core_property(0x2C6B, 0x2C6B, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Z WITH DESCENDER
unicode_core_property(0x2C6D, 0x2C70, 'Changes_When_Lowercased').	% L&   [4] LATIN CAPITAL LETTER ALPHA..LATIN CAPITAL LETTER TURNED ALPHA
unicode_core_property(0x2C72, 0x2C72, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER W WITH HOOK
unicode_core_property(0x2C75, 0x2C75, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER HALF H
unicode_core_property(0x2C7E, 0x2C80, 'Changes_When_Lowercased').	% L&   [3] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC CAPITAL LETTER ALFA
unicode_core_property(0x2C82, 0x2C82, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER VIDA
unicode_core_property(0x2C84, 0x2C84, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER GAMMA
unicode_core_property(0x2C86, 0x2C86, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DALDA
unicode_core_property(0x2C88, 0x2C88, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER EIE
unicode_core_property(0x2C8A, 0x2C8A, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER SOU
unicode_core_property(0x2C8C, 0x2C8C, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER ZATA
unicode_core_property(0x2C8E, 0x2C8E, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER HATE
unicode_core_property(0x2C90, 0x2C90, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER THETHE
unicode_core_property(0x2C92, 0x2C92, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER IAUDA
unicode_core_property(0x2C94, 0x2C94, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER KAPA
unicode_core_property(0x2C96, 0x2C96, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER LAULA
unicode_core_property(0x2C98, 0x2C98, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER MI
unicode_core_property(0x2C9A, 0x2C9A, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER NI
unicode_core_property(0x2C9C, 0x2C9C, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER KSI
unicode_core_property(0x2C9E, 0x2C9E, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER O
unicode_core_property(0x2CA0, 0x2CA0, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER PI
unicode_core_property(0x2CA2, 0x2CA2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER RO
unicode_core_property(0x2CA4, 0x2CA4, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER SIMA
unicode_core_property(0x2CA6, 0x2CA6, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER TAU
unicode_core_property(0x2CA8, 0x2CA8, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER UA
unicode_core_property(0x2CAA, 0x2CAA, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER FI
unicode_core_property(0x2CAC, 0x2CAC, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER KHI
unicode_core_property(0x2CAE, 0x2CAE, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER PSI
unicode_core_property(0x2CB0, 0x2CB0, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OOU
unicode_core_property(0x2CB2, 0x2CB2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB4, 0x2CB4, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB6, 0x2CB6, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB8, 0x2CB8, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBA, 0x2CBA, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DIALECT-P NI
unicode_core_property(0x2CBC, 0x2CBC, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBE, 0x2CBE, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC0, 0x2CC0, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER SAMPI
unicode_core_property(0x2CC2, 0x2CC2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER CROSSED SHEI
unicode_core_property(0x2CC4, 0x2CC4, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC6, 0x2CC6, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC8, 0x2CC8, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCA, 0x2CCA, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER DIALECT-P HORI
unicode_core_property(0x2CCC, 0x2CCC, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCE, 0x2CCE, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HA
unicode_core_property(0x2CD0, 0x2CD0, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER L-SHAPED HA
unicode_core_property(0x2CD2, 0x2CD2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD4, 0x2CD4, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD6, 0x2CD6, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD8, 0x2CD8, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDA, 0x2CDA, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDC, 0x2CDC, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDE, 0x2CDE, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE0, 0x2CE0, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE2, 0x2CE2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEB, 0x2CEB, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CED, 0x2CED, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF2, 'Changes_When_Lowercased').	% L&       COPTIC CAPITAL LETTER BOHAIRIC KHEI
unicode_core_property(0xA640, 0xA640, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZEMLYA
unicode_core_property(0xA642, 0xA642, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DZELO
unicode_core_property(0xA644, 0xA644, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER REVERSED DZE
unicode_core_property(0xA646, 0xA646, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTA
unicode_core_property(0xA648, 0xA648, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DJERV
unicode_core_property(0xA64A, 0xA64A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER MONOGRAPH UK
unicode_core_property(0xA64C, 0xA64C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BROAD OMEGA
unicode_core_property(0xA64E, 0xA64E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER NEUTRAL YER
unicode_core_property(0xA650, 0xA650, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER YERU WITH BACK YER
unicode_core_property(0xA652, 0xA652, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED YAT
unicode_core_property(0xA654, 0xA654, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER REVERSED YU
unicode_core_property(0xA656, 0xA656, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED A
unicode_core_property(0xA658, 0xA658, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65A, 0xA65A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BLENDED YUS
unicode_core_property(0xA65C, 0xA65C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65E, 0xA65E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER YN
unicode_core_property(0xA660, 0xA660, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER REVERSED TSE
unicode_core_property(0xA662, 0xA662, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SOFT DE
unicode_core_property(0xA664, 0xA664, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SOFT EL
unicode_core_property(0xA666, 0xA666, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SOFT EM
unicode_core_property(0xA668, 0xA668, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER MONOCULAR O
unicode_core_property(0xA66A, 0xA66A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER BINOCULAR O
unicode_core_property(0xA66C, 0xA66C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA680, 0xA680, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DWE
unicode_core_property(0xA682, 0xA682, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DZWE
unicode_core_property(0xA684, 0xA684, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER ZHWE
unicode_core_property(0xA686, 0xA686, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER CCHE
unicode_core_property(0xA688, 0xA688, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER DZZE
unicode_core_property(0xA68A, 0xA68A, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68C, 0xA68C, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TWE
unicode_core_property(0xA68E, 0xA68E, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TSWE
unicode_core_property(0xA690, 0xA690, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TSSE
unicode_core_property(0xA692, 0xA692, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER TCHE
unicode_core_property(0xA694, 0xA694, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER HWE
unicode_core_property(0xA696, 0xA696, 'Changes_When_Lowercased').	% L&       CYRILLIC CAPITAL LETTER SHWE
unicode_core_property(0xA722, 0xA722, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA724, 0xA724, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA726, 0xA726, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER HENG
unicode_core_property(0xA728, 0xA728, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TZ
unicode_core_property(0xA72A, 0xA72A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TRESILLO
unicode_core_property(0xA72C, 0xA72C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER CUATRILLO
unicode_core_property(0xA72E, 0xA72E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA732, 0xA732, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AA
unicode_core_property(0xA734, 0xA734, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AO
unicode_core_property(0xA736, 0xA736, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AU
unicode_core_property(0xA738, 0xA738, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AV
unicode_core_property(0xA73A, 0xA73A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73C, 0xA73C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER AY
unicode_core_property(0xA73E, 0xA73E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER REVERSED C WITH DOT
unicode_core_property(0xA740, 0xA740, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH STROKE
unicode_core_property(0xA742, 0xA742, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA744, 0xA744, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA746, 0xA746, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER BROKEN L
unicode_core_property(0xA748, 0xA748, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74A, 0xA74A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74C, 0xA74C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER O WITH LOOP
unicode_core_property(0xA74E, 0xA74E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER OO
unicode_core_property(0xA750, 0xA750, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA752, 0xA752, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH FLOURISH
unicode_core_property(0xA754, 0xA754, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA756, 0xA756, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA758, 0xA758, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75A, 0xA75A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R ROTUNDA
unicode_core_property(0xA75C, 0xA75C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER RUM ROTUNDA
unicode_core_property(0xA75E, 0xA75E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA760, 0xA760, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER VY
unicode_core_property(0xA762, 0xA762, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER VISIGOTHIC Z
unicode_core_property(0xA764, 0xA764, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE
unicode_core_property(0xA766, 0xA766, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA768, 0xA768, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER VEND
unicode_core_property(0xA76A, 0xA76A, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER ET
unicode_core_property(0xA76C, 0xA76C, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER IS
unicode_core_property(0xA76E, 0xA76E, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER CON
unicode_core_property(0xA779, 0xA779, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER INSULAR D
unicode_core_property(0xA77B, 0xA77B, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER INSULAR F
unicode_core_property(0xA77D, 0xA77E, 'Changes_When_Lowercased').	% L&   [2] LATIN CAPITAL LETTER INSULAR G..LATIN CAPITAL LETTER TURNED INSULAR G
unicode_core_property(0xA780, 0xA780, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TURNED L
unicode_core_property(0xA782, 0xA782, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER INSULAR R
unicode_core_property(0xA784, 0xA784, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER INSULAR S
unicode_core_property(0xA786, 0xA786, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER INSULAR T
unicode_core_property(0xA78B, 0xA78B, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER SALTILLO
unicode_core_property(0xA78D, 0xA78D, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER TURNED H
unicode_core_property(0xA790, 0xA790, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH DESCENDER
unicode_core_property(0xA792, 0xA792, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7A0, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A2, 0xA7A2, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A4, 0xA7A4, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A6, 0xA7A6, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A8, 0xA7A8, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xA7AA, 0xA7AA, 'Changes_When_Lowercased').	% L&       LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xFF21, 0xFF3A, 'Changes_When_Lowercased').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0x10400, 0x10427, 'Changes_When_Lowercased').	% L&  [40] DESERET CAPITAL LETTER LONG I..DESERET CAPITAL LETTER EW

% Total code points: 1043

% ================================================

% Derived Property:   Changes_When_Uppercased (CWU)
%  Characters whose normalized forms are not stable under a toUppercase mapping.
%  For more information, see D125 in Section 3.13, "Default Case Algorithms".
%  Changes_When_Uppercased(X) is true when toUppercase(toNFD(X)) != toNFD(X)

unicode_core_property(0x0061, 0x007A, 'Changes_When_Uppercased').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00B5, 0x00B5, 'Changes_When_Uppercased').	% L&       MICRO SIGN
unicode_core_property(0x00DF, 0x00F6, 'Changes_When_Uppercased').	% L&  [24] LATIN SMALL LETTER SHARP S..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x00FF, 'Changes_When_Uppercased').	% L&   [8] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER Y WITH DIAERESIS
unicode_core_property(0x0101, 0x0101, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH MACRON
unicode_core_property(0x0103, 0x0103, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE
unicode_core_property(0x0105, 0x0105, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH OGONEK
unicode_core_property(0x0107, 0x0107, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH ACUTE
unicode_core_property(0x0109, 0x0109, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010B, 0x010B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH DOT ABOVE
unicode_core_property(0x010D, 0x010D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH CARON
unicode_core_property(0x010F, 0x010F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH CARON
unicode_core_property(0x0111, 0x0111, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH STROKE
unicode_core_property(0x0113, 0x0113, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH MACRON
unicode_core_property(0x0115, 0x0115, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH BREVE
unicode_core_property(0x0117, 0x0117, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH DOT ABOVE
unicode_core_property(0x0119, 0x0119, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH OGONEK
unicode_core_property(0x011B, 0x011B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CARON
unicode_core_property(0x011D, 0x011D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011F, 0x011F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH BREVE
unicode_core_property(0x0121, 0x0121, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH DOT ABOVE
unicode_core_property(0x0123, 0x0123, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH CEDILLA
unicode_core_property(0x0125, 0x0125, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0127, 0x0127, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH STROKE
unicode_core_property(0x0129, 0x0129, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH TILDE
unicode_core_property(0x012B, 0x012B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH MACRON
unicode_core_property(0x012D, 0x012D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH BREVE
unicode_core_property(0x012F, 0x012F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH OGONEK
unicode_core_property(0x0131, 0x0131, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER DOTLESS I
unicode_core_property(0x0133, 0x0133, 'Changes_When_Uppercased').	% L&       LATIN SMALL LIGATURE IJ
unicode_core_property(0x0135, 0x0135, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0137, 0x0137, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH CEDILLA
unicode_core_property(0x013A, 0x013A, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH ACUTE
unicode_core_property(0x013C, 0x013C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH CEDILLA
unicode_core_property(0x013E, 0x013E, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH CARON
unicode_core_property(0x0140, 0x0140, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0142, 0x0142, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH STROKE
unicode_core_property(0x0144, 0x0144, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH ACUTE
unicode_core_property(0x0146, 0x0146, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH CEDILLA
unicode_core_property(0x0148, 0x0149, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER N WITH CARON..LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
unicode_core_property(0x014B, 0x014B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER ENG
unicode_core_property(0x014D, 0x014D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH MACRON
unicode_core_property(0x014F, 0x014F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH BREVE
unicode_core_property(0x0151, 0x0151, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0153, 0x0153, 'Changes_When_Uppercased').	% L&       LATIN SMALL LIGATURE OE
unicode_core_property(0x0155, 0x0155, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH ACUTE
unicode_core_property(0x0157, 0x0157, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH CEDILLA
unicode_core_property(0x0159, 0x0159, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH CARON
unicode_core_property(0x015B, 0x015B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH ACUTE
unicode_core_property(0x015D, 0x015D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015F, 0x015F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH CEDILLA
unicode_core_property(0x0161, 0x0161, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH CARON
unicode_core_property(0x0163, 0x0163, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH CEDILLA
unicode_core_property(0x0165, 0x0165, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH CARON
unicode_core_property(0x0167, 0x0167, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH STROKE
unicode_core_property(0x0169, 0x0169, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH TILDE
unicode_core_property(0x016B, 0x016B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH MACRON
unicode_core_property(0x016D, 0x016D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH BREVE
unicode_core_property(0x016F, 0x016F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH RING ABOVE
unicode_core_property(0x0171, 0x0171, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0173, 0x0173, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH OGONEK
unicode_core_property(0x0175, 0x0175, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0177, 0x0177, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x017A, 0x017A, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH ACUTE
unicode_core_property(0x017C, 0x017C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017E, 0x0180, 'Changes_When_Uppercased').	% L&   [3] LATIN SMALL LETTER Z WITH CARON..LATIN SMALL LETTER B WITH STROKE
unicode_core_property(0x0183, 0x0183, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER B WITH TOPBAR
unicode_core_property(0x0185, 0x0185, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TONE SIX
unicode_core_property(0x0188, 0x0188, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH HOOK
unicode_core_property(0x018C, 0x018C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH TOPBAR
unicode_core_property(0x0192, 0x0192, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER F WITH HOOK
unicode_core_property(0x0195, 0x0195, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER HV
unicode_core_property(0x0199, 0x019A, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER K WITH HOOK..LATIN SMALL LETTER L WITH BAR
unicode_core_property(0x019E, 0x019E, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x01A1, 0x01A1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN
unicode_core_property(0x01A3, 0x01A3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER OI
unicode_core_property(0x01A5, 0x01A5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH HOOK
unicode_core_property(0x01A8, 0x01A8, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TONE TWO
unicode_core_property(0x01AD, 0x01AD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH HOOK
unicode_core_property(0x01B0, 0x01B0, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN
unicode_core_property(0x01B4, 0x01B4, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH HOOK
unicode_core_property(0x01B6, 0x01B6, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH STROKE
unicode_core_property(0x01B9, 0x01B9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER EZH REVERSED
unicode_core_property(0x01BD, 0x01BD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TONE FIVE
unicode_core_property(0x01BF, 0x01BF, 'Changes_When_Uppercased').	% L&       LATIN LETTER WYNN
unicode_core_property(0x01C5, 0x01C6, 'Changes_When_Uppercased').	% L&   [2] LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON..LATIN SMALL LETTER DZ WITH CARON
unicode_core_property(0x01C8, 0x01C9, 'Changes_When_Uppercased').	% L&   [2] LATIN CAPITAL LETTER L WITH SMALL LETTER J..LATIN SMALL LETTER LJ
unicode_core_property(0x01CB, 0x01CC, 'Changes_When_Uppercased').	% L&   [2] LATIN CAPITAL LETTER N WITH SMALL LETTER J..LATIN SMALL LETTER NJ
unicode_core_property(0x01CE, 0x01CE, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CARON
unicode_core_property(0x01D0, 0x01D0, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH CARON
unicode_core_property(0x01D2, 0x01D2, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CARON
unicode_core_property(0x01D4, 0x01D4, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH CARON
unicode_core_property(0x01D6, 0x01D6, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D8, 0x01D8, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01DA, 0x01DA, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DC, 0x01DD, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE..LATIN SMALL LETTER TURNED E
unicode_core_property(0x01DF, 0x01DF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E1, 0x01E1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E3, 0x01E3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AE WITH MACRON
unicode_core_property(0x01E5, 0x01E5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH STROKE
unicode_core_property(0x01E7, 0x01E7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH CARON
unicode_core_property(0x01E9, 0x01E9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH CARON
unicode_core_property(0x01EB, 0x01EB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH OGONEK
unicode_core_property(0x01ED, 0x01ED, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EF, 0x01F0, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER EZH WITH CARON..LATIN SMALL LETTER J WITH CARON
unicode_core_property(0x01F2, 0x01F3, 'Changes_When_Uppercased').	% L&   [2] LATIN CAPITAL LETTER D WITH SMALL LETTER Z..LATIN SMALL LETTER DZ
unicode_core_property(0x01F5, 0x01F5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH ACUTE
unicode_core_property(0x01F9, 0x01F9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH GRAVE
unicode_core_property(0x01FB, 0x01FB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FD, 0x01FD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AE WITH ACUTE
unicode_core_property(0x01FF, 0x01FF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0201, 0x0201, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0203, 0x0203, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0205, 0x0205, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0207, 0x0207, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0209, 0x0209, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020B, 0x020B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020D, 0x020D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020F, 0x020F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0211, 0x0211, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0213, 0x0213, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0215, 0x0215, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0217, 0x0217, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0219, 0x0219, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH COMMA BELOW
unicode_core_property(0x021B, 0x021B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH COMMA BELOW
unicode_core_property(0x021D, 0x021D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER YOGH
unicode_core_property(0x021F, 0x021F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH CARON
unicode_core_property(0x0223, 0x0223, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER OU
unicode_core_property(0x0225, 0x0225, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH HOOK
unicode_core_property(0x0227, 0x0227, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE
unicode_core_property(0x0229, 0x0229, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CEDILLA
unicode_core_property(0x022B, 0x022B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022D, 0x022D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022F, 0x022F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE
unicode_core_property(0x0231, 0x0231, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0233, 0x0233, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH MACRON
unicode_core_property(0x023C, 0x023C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH STROKE
unicode_core_property(0x023F, 0x0240, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER S WITH SWASH TAIL..LATIN SMALL LETTER Z WITH SWASH TAIL
unicode_core_property(0x0242, 0x0242, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER GLOTTAL STOP
unicode_core_property(0x0247, 0x0247, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH STROKE
unicode_core_property(0x0249, 0x0249, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER J WITH STROKE
unicode_core_property(0x024B, 0x024B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Q WITH HOOK TAIL
unicode_core_property(0x024D, 0x024D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH STROKE
unicode_core_property(0x024F, 0x0254, 'Changes_When_Uppercased').	% L&   [6] LATIN SMALL LETTER Y WITH STROKE..LATIN SMALL LETTER OPEN O
unicode_core_property(0x0256, 0x0257, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER D WITH TAIL..LATIN SMALL LETTER D WITH HOOK
unicode_core_property(0x0259, 0x0259, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER SCHWA
unicode_core_property(0x025B, 0x025B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER OPEN E
unicode_core_property(0x0260, 0x0260, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH HOOK
unicode_core_property(0x0263, 0x0263, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER GAMMA
unicode_core_property(0x0265, 0x0266, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER TURNED H..LATIN SMALL LETTER H WITH HOOK
unicode_core_property(0x0268, 0x0269, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER I WITH STROKE..LATIN SMALL LETTER IOTA
unicode_core_property(0x026B, 0x026B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH MIDDLE TILDE
unicode_core_property(0x026F, 0x026F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TURNED M
unicode_core_property(0x0271, 0x0272, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER M WITH HOOK..LATIN SMALL LETTER N WITH LEFT HOOK
unicode_core_property(0x0275, 0x0275, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER BARRED O
unicode_core_property(0x027D, 0x027D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH TAIL
unicode_core_property(0x0280, 0x0280, 'Changes_When_Uppercased').	% L&       LATIN LETTER SMALL CAPITAL R
unicode_core_property(0x0283, 0x0283, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER ESH
unicode_core_property(0x0288, 0x028C, 'Changes_When_Uppercased').	% L&   [5] LATIN SMALL LETTER T WITH RETROFLEX HOOK..LATIN SMALL LETTER TURNED V
unicode_core_property(0x0292, 0x0292, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER EZH
unicode_core_property(0x0345, 0x0345, 'Changes_When_Uppercased').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0371, 0x0371, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER HETA
unicode_core_property(0x0373, 0x0373, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0377, 0x0377, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037B, 0x037D, 'Changes_When_Uppercased').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0390, 0x0390, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
unicode_core_property(0x03AC, 0x03CE, 'Changes_When_Uppercased').	% L&  [35] GREEK SMALL LETTER ALPHA WITH TONOS..GREEK SMALL LETTER OMEGA WITH TONOS
unicode_core_property(0x03D0, 0x03D1, 'Changes_When_Uppercased').	% L&   [2] GREEK BETA SYMBOL..GREEK THETA SYMBOL
unicode_core_property(0x03D5, 0x03D7, 'Changes_When_Uppercased').	% L&   [3] GREEK PHI SYMBOL..GREEK KAI SYMBOL
unicode_core_property(0x03D9, 0x03D9, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER ARCHAIC KOPPA
unicode_core_property(0x03DB, 0x03DB, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER STIGMA
unicode_core_property(0x03DD, 0x03DD, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER DIGAMMA
unicode_core_property(0x03DF, 0x03DF, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER KOPPA
unicode_core_property(0x03E1, 0x03E1, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER SAMPI
unicode_core_property(0x03E3, 0x03E3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER SHEI
unicode_core_property(0x03E5, 0x03E5, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER FEI
unicode_core_property(0x03E7, 0x03E7, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER KHEI
unicode_core_property(0x03E9, 0x03E9, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER HORI
unicode_core_property(0x03EB, 0x03EB, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER GANGIA
unicode_core_property(0x03ED, 0x03ED, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER SHIMA
unicode_core_property(0x03EF, 0x03F2, 'Changes_When_Uppercased').	% L&   [4] COPTIC SMALL LETTER DEI..GREEK LUNATE SIGMA SYMBOL
unicode_core_property(0x03F5, 0x03F5, 'Changes_When_Uppercased').	% L&       GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F8, 0x03F8, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER SHO
unicode_core_property(0x03FB, 0x03FB, 'Changes_When_Uppercased').	% L&       GREEK SMALL LETTER SAN
unicode_core_property(0x0430, 0x045F, 'Changes_When_Uppercased').	% L&  [48] CYRILLIC SMALL LETTER A..CYRILLIC SMALL LETTER DZHE
unicode_core_property(0x0461, 0x0461, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER OMEGA
unicode_core_property(0x0463, 0x0463, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER YAT
unicode_core_property(0x0465, 0x0465, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED E
unicode_core_property(0x0467, 0x0467, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER LITTLE YUS
unicode_core_property(0x0469, 0x0469, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046B, 0x046B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BIG YUS
unicode_core_property(0x046D, 0x046D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046F, 0x046F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KSI
unicode_core_property(0x0471, 0x0471, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER PSI
unicode_core_property(0x0473, 0x0473, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER FITA
unicode_core_property(0x0475, 0x0475, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IZHITSA
unicode_core_property(0x0477, 0x0477, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0479, 0x0479, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER UK
unicode_core_property(0x047B, 0x047B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ROUND OMEGA
unicode_core_property(0x047D, 0x047D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER OMEGA WITH TITLO
unicode_core_property(0x047F, 0x047F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER OT
unicode_core_property(0x0481, 0x0481, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048B, 0x048B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SHORT I WITH TAIL
unicode_core_property(0x048D, 0x048D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SEMISOFT SIGN
unicode_core_property(0x048F, 0x048F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ER WITH TICK
unicode_core_property(0x0491, 0x0491, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER GHE WITH UPTURN
unicode_core_property(0x0493, 0x0493, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE
unicode_core_property(0x0495, 0x0495, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0497, 0x0497, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0499, 0x0499, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZE WITH DESCENDER
unicode_core_property(0x049B, 0x049B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KA WITH DESCENDER
unicode_core_property(0x049D, 0x049D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049F, 0x049F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KA WITH STROKE
unicode_core_property(0x04A1, 0x04A1, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BASHKIR KA
unicode_core_property(0x04A3, 0x04A3, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EN WITH DESCENDER
unicode_core_property(0x04A5, 0x04A5, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LIGATURE EN GHE
unicode_core_property(0x04A7, 0x04A7, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A9, 0x04A9, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN HA
unicode_core_property(0x04AB, 0x04AB, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ES WITH DESCENDER
unicode_core_property(0x04AD, 0x04AD, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TE WITH DESCENDER
unicode_core_property(0x04AF, 0x04AF, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER STRAIGHT U
unicode_core_property(0x04B1, 0x04B1, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B3, 0x04B3, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER HA WITH DESCENDER
unicode_core_property(0x04B5, 0x04B5, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LIGATURE TE TSE
unicode_core_property(0x04B7, 0x04B7, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B9, 0x04B9, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BB, 0x04BB, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SHHA
unicode_core_property(0x04BD, 0x04BD, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE
unicode_core_property(0x04BF, 0x04BF, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C2, 0x04C2, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZHE WITH BREVE
unicode_core_property(0x04C4, 0x04C4, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KA WITH HOOK
unicode_core_property(0x04C6, 0x04C6, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EL WITH TAIL
unicode_core_property(0x04C8, 0x04C8, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EN WITH HOOK
unicode_core_property(0x04CA, 0x04CA, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EN WITH TAIL
unicode_core_property(0x04CC, 0x04CC, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CE, 0x04CF, 'Changes_When_Uppercased').	% L&   [2] CYRILLIC SMALL LETTER EM WITH TAIL..CYRILLIC SMALL LETTER PALOCHKA
unicode_core_property(0x04D1, 0x04D1, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER A WITH BREVE
unicode_core_property(0x04D3, 0x04D3, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER A WITH DIAERESIS
unicode_core_property(0x04D5, 0x04D5, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LIGATURE A IE
unicode_core_property(0x04D7, 0x04D7, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IE WITH BREVE
unicode_core_property(0x04D9, 0x04D9, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SCHWA
unicode_core_property(0x04DB, 0x04DB, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DD, 0x04DD, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DF, 0x04DF, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E1, 0x04E1, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN DZE
unicode_core_property(0x04E3, 0x04E3, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER I WITH MACRON
unicode_core_property(0x04E5, 0x04E5, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER I WITH DIAERESIS
unicode_core_property(0x04E7, 0x04E7, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x04E9, 0x04E9, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BARRED O
unicode_core_property(0x04EB, 0x04EB, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04ED, 0x04ED, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER E WITH DIAERESIS
unicode_core_property(0x04EF, 0x04EF, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER U WITH MACRON
unicode_core_property(0x04F1, 0x04F1, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER U WITH DIAERESIS
unicode_core_property(0x04F3, 0x04F3, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F5, 0x04F5, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F7, 0x04F7, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F9, 0x04F9, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FB, 0x04FB, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FD, 0x04FD, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER HA WITH HOOK
unicode_core_property(0x04FF, 0x04FF, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER HA WITH STROKE
unicode_core_property(0x0501, 0x0501, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI DE
unicode_core_property(0x0503, 0x0503, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI DJE
unicode_core_property(0x0505, 0x0505, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI ZJE
unicode_core_property(0x0507, 0x0507, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI DZJE
unicode_core_property(0x0509, 0x0509, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI LJE
unicode_core_property(0x050B, 0x050B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI NJE
unicode_core_property(0x050D, 0x050D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI SJE
unicode_core_property(0x050F, 0x050F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER KOMI TJE
unicode_core_property(0x0511, 0x0511, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER REVERSED ZE
unicode_core_property(0x0513, 0x0513, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EL WITH HOOK
unicode_core_property(0x0515, 0x0515, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER LHA
unicode_core_property(0x0517, 0x0517, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER RHA
unicode_core_property(0x0519, 0x0519, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER YAE
unicode_core_property(0x051B, 0x051B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER QA
unicode_core_property(0x051D, 0x051D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER WE
unicode_core_property(0x051F, 0x051F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ALEUT KA
unicode_core_property(0x0521, 0x0521, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0523, 0x0523, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0525, 0x0525, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER PE WITH DESCENDER
unicode_core_property(0x0527, 0x0527, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0561, 0x0587, 'Changes_When_Uppercased').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x1D79, 0x1D79, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR G
unicode_core_property(0x1D7D, 0x1D7D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH STROKE
unicode_core_property(0x1E01, 0x1E01, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH RING BELOW
unicode_core_property(0x1E03, 0x1E03, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E05, 0x1E05, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER B WITH DOT BELOW
unicode_core_property(0x1E07, 0x1E07, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER B WITH LINE BELOW
unicode_core_property(0x1E09, 0x1E09, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0B, 0x1E0B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0D, 0x1E0D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0F, 0x1E0F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH LINE BELOW
unicode_core_property(0x1E11, 0x1E11, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH CEDILLA
unicode_core_property(0x1E13, 0x1E13, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E15, 0x1E15, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E17, 0x1E17, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E19, 0x1E19, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1B, 0x1E1B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1D, 0x1E1D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1F, 0x1E1F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E21, 0x1E21, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH MACRON
unicode_core_property(0x1E23, 0x1E23, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E25, 0x1E25, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH DOT BELOW
unicode_core_property(0x1E27, 0x1E27, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH DIAERESIS
unicode_core_property(0x1E29, 0x1E29, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH CEDILLA
unicode_core_property(0x1E2B, 0x1E2B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2D, 0x1E2D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2F, 0x1E2F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E31, 0x1E31, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH ACUTE
unicode_core_property(0x1E33, 0x1E33, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH DOT BELOW
unicode_core_property(0x1E35, 0x1E35, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH LINE BELOW
unicode_core_property(0x1E37, 0x1E37, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH DOT BELOW
unicode_core_property(0x1E39, 0x1E39, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3B, 0x1E3B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3D, 0x1E3D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3F, 0x1E3F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER M WITH ACUTE
unicode_core_property(0x1E41, 0x1E41, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E43, 0x1E43, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER M WITH DOT BELOW
unicode_core_property(0x1E45, 0x1E45, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E47, 0x1E47, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH DOT BELOW
unicode_core_property(0x1E49, 0x1E49, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4B, 0x1E4B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4D, 0x1E4D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4F, 0x1E4F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E51, 0x1E51, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E53, 0x1E53, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E55, 0x1E55, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH ACUTE
unicode_core_property(0x1E57, 0x1E57, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E59, 0x1E59, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5B, 0x1E5B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5D, 0x1E5D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5F, 0x1E5F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH LINE BELOW
unicode_core_property(0x1E61, 0x1E61, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E63, 0x1E63, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH DOT BELOW
unicode_core_property(0x1E65, 0x1E65, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E67, 0x1E67, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E69, 0x1E69, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6B, 0x1E6B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6D, 0x1E6D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6F, 0x1E6F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH LINE BELOW
unicode_core_property(0x1E71, 0x1E71, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E73, 0x1E73, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E75, 0x1E75, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E77, 0x1E77, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E79, 0x1E79, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7B, 0x1E7B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7D, 0x1E7D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER V WITH TILDE
unicode_core_property(0x1E7F, 0x1E7F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER V WITH DOT BELOW
unicode_core_property(0x1E81, 0x1E81, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH GRAVE
unicode_core_property(0x1E83, 0x1E83, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH ACUTE
unicode_core_property(0x1E85, 0x1E85, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH DIAERESIS
unicode_core_property(0x1E87, 0x1E87, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E89, 0x1E89, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8B, 0x1E8B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8D, 0x1E8D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8F, 0x1E8F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E91, 0x1E91, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E93, 0x1E93, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E95, 0x1E9B, 'Changes_When_Uppercased').	% L&   [7] LATIN SMALL LETTER Z WITH LINE BELOW..LATIN SMALL LETTER LONG S WITH DOT ABOVE
unicode_core_property(0x1EA1, 0x1EA1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA3, 0x1EA3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA5, 0x1EA5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA7, 0x1EA7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA9, 0x1EA9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAB, 0x1EAB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAD, 0x1EAD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAF, 0x1EAF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB1, 0x1EB1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB3, 0x1EB3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB5, 0x1EB5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB7, 0x1EB7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB9, 0x1EB9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBB, 0x1EBB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBD, 0x1EBD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH TILDE
unicode_core_property(0x1EBF, 0x1EBF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC1, 0x1EC1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC3, 0x1EC3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC5, 0x1EC5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC7, 0x1EC7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC9, 0x1EC9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECB, 0x1ECB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECD, 0x1ECD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECF, 0x1ECF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED1, 0x1ED1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED3, 0x1ED3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED5, 0x1ED5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED7, 0x1ED7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED9, 0x1ED9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDB, 0x1EDB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDD, 0x1EDD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDF, 0x1EDF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE1, 0x1EE1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE3, 0x1EE3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE5, 0x1EE5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE7, 0x1EE7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE9, 0x1EE9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEB, 0x1EEB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EED, 0x1EED, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEF, 0x1EEF, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF1, 0x1EF1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF3, 0x1EF3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH GRAVE
unicode_core_property(0x1EF5, 0x1EF5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF7, 0x1EF7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF9, 0x1EF9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Y WITH TILDE
unicode_core_property(0x1EFB, 0x1EFB, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFD, 0x1EFD, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFF, 0x1F07, 'Changes_When_Uppercased').	% L&   [9] LATIN SMALL LETTER Y WITH LOOP..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F10, 0x1F15, 'Changes_When_Uppercased').	% L&   [6] GREEK SMALL LETTER EPSILON WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F27, 'Changes_When_Uppercased').	% L&   [8] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F30, 0x1F37, 'Changes_When_Uppercased').	% L&   [8] GREEK SMALL LETTER IOTA WITH PSILI..GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F40, 0x1F45, 'Changes_When_Uppercased').	% L&   [6] GREEK SMALL LETTER OMICRON WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Changes_When_Uppercased').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F60, 0x1F67, 'Changes_When_Uppercased').	% L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F70, 0x1F7D, 'Changes_When_Uppercased').	% L&  [14] GREEK SMALL LETTER ALPHA WITH VARIA..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'Changes_When_Uppercased').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FB7, 'Changes_When_Uppercased').	% L&   [2] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FBC, 0x1FBC, 'Changes_When_Uppercased').	% L&       GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Changes_When_Uppercased').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Changes_When_Uppercased').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FC7, 'Changes_When_Uppercased').	% L&   [2] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FCC, 0x1FCC, 'Changes_When_Uppercased').	% L&       GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Changes_When_Uppercased').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FD7, 'Changes_When_Uppercased').	% L&   [2] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FE0, 0x1FE7, 'Changes_When_Uppercased').	% L&   [8] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FF2, 0x1FF4, 'Changes_When_Uppercased').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FF7, 'Changes_When_Uppercased').	% L&   [2] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FFC, 0x1FFC, 'Changes_When_Uppercased').	% L&       GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x214E, 0x214E, 'Changes_When_Uppercased').	% L&       TURNED SMALL F
unicode_core_property(0x2170, 0x217F, 'Changes_When_Uppercased').	% Nl  [16] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2184, 0x2184, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER REVERSED C
unicode_core_property(0x24D0, 0x24E9, 'Changes_When_Uppercased').	% So  [26] CIRCLED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C30, 0x2C5E, 'Changes_When_Uppercased').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C61, 0x2C61, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C65, 0x2C66, 'Changes_When_Uppercased').	% L&   [2] LATIN SMALL LETTER A WITH STROKE..LATIN SMALL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x2C68, 0x2C68, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER H WITH DESCENDER
unicode_core_property(0x2C6A, 0x2C6A, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH DESCENDER
unicode_core_property(0x2C6C, 0x2C6C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Z WITH DESCENDER
unicode_core_property(0x2C73, 0x2C73, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER W WITH HOOK
unicode_core_property(0x2C76, 0x2C76, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER HALF H
unicode_core_property(0x2C81, 0x2C81, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER ALFA
unicode_core_property(0x2C83, 0x2C83, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER VIDA
unicode_core_property(0x2C85, 0x2C85, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER GAMMA
unicode_core_property(0x2C87, 0x2C87, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER DALDA
unicode_core_property(0x2C89, 0x2C89, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER EIE
unicode_core_property(0x2C8B, 0x2C8B, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER SOU
unicode_core_property(0x2C8D, 0x2C8D, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER ZATA
unicode_core_property(0x2C8F, 0x2C8F, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER HATE
unicode_core_property(0x2C91, 0x2C91, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER THETHE
unicode_core_property(0x2C93, 0x2C93, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER IAUDA
unicode_core_property(0x2C95, 0x2C95, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER KAPA
unicode_core_property(0x2C97, 0x2C97, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER LAULA
unicode_core_property(0x2C99, 0x2C99, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER MI
unicode_core_property(0x2C9B, 0x2C9B, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER NI
unicode_core_property(0x2C9D, 0x2C9D, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER KSI
unicode_core_property(0x2C9F, 0x2C9F, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER O
unicode_core_property(0x2CA1, 0x2CA1, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER PI
unicode_core_property(0x2CA3, 0x2CA3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER RO
unicode_core_property(0x2CA5, 0x2CA5, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER SIMA
unicode_core_property(0x2CA7, 0x2CA7, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER TAU
unicode_core_property(0x2CA9, 0x2CA9, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER UA
unicode_core_property(0x2CAB, 0x2CAB, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER FI
unicode_core_property(0x2CAD, 0x2CAD, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER KHI
unicode_core_property(0x2CAF, 0x2CAF, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER PSI
unicode_core_property(0x2CB1, 0x2CB1, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OOU
unicode_core_property(0x2CB3, 0x2CB3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB5, 0x2CB5, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB7, 0x2CB7, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB9, 0x2CB9, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBB, 0x2CBB, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER DIALECT-P NI
unicode_core_property(0x2CBD, 0x2CBD, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBF, 0x2CBF, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC1, 0x2CC1, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER SAMPI
unicode_core_property(0x2CC3, 0x2CC3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER CROSSED SHEI
unicode_core_property(0x2CC5, 0x2CC5, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC7, 0x2CC7, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC9, 0x2CC9, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCB, 0x2CCB, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER DIALECT-P HORI
unicode_core_property(0x2CCD, 0x2CCD, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCF, 0x2CCF, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC HA
unicode_core_property(0x2CD1, 0x2CD1, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER L-SHAPED HA
unicode_core_property(0x2CD3, 0x2CD3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD5, 0x2CD5, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD7, 0x2CD7, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD9, 0x2CD9, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDB, 0x2CDB, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDD, 0x2CDD, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDF, 0x2CDF, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE1, 0x2CE1, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE3, 0x2CE3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEC, 0x2CEC, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CEE, 0x2CEE, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF3, 0x2CF3, 'Changes_When_Uppercased').	% L&       COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Changes_When_Uppercased').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Changes_When_Uppercased').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Changes_When_Uppercased').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0xA641, 0xA641, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZEMLYA
unicode_core_property(0xA643, 0xA643, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DZELO
unicode_core_property(0xA645, 0xA645, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER REVERSED DZE
unicode_core_property(0xA647, 0xA647, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTA
unicode_core_property(0xA649, 0xA649, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DJERV
unicode_core_property(0xA64B, 0xA64B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER MONOGRAPH UK
unicode_core_property(0xA64D, 0xA64D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BROAD OMEGA
unicode_core_property(0xA64F, 0xA64F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER NEUTRAL YER
unicode_core_property(0xA651, 0xA651, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER YERU WITH BACK YER
unicode_core_property(0xA653, 0xA653, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED YAT
unicode_core_property(0xA655, 0xA655, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER REVERSED YU
unicode_core_property(0xA657, 0xA657, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED A
unicode_core_property(0xA659, 0xA659, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65B, 0xA65B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BLENDED YUS
unicode_core_property(0xA65D, 0xA65D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65F, 0xA65F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER YN
unicode_core_property(0xA661, 0xA661, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER REVERSED TSE
unicode_core_property(0xA663, 0xA663, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SOFT DE
unicode_core_property(0xA665, 0xA665, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SOFT EL
unicode_core_property(0xA667, 0xA667, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SOFT EM
unicode_core_property(0xA669, 0xA669, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER MONOCULAR O
unicode_core_property(0xA66B, 0xA66B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER BINOCULAR O
unicode_core_property(0xA66D, 0xA66D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA681, 0xA681, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DWE
unicode_core_property(0xA683, 0xA683, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DZWE
unicode_core_property(0xA685, 0xA685, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER ZHWE
unicode_core_property(0xA687, 0xA687, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER CCHE
unicode_core_property(0xA689, 0xA689, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER DZZE
unicode_core_property(0xA68B, 0xA68B, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68D, 0xA68D, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TWE
unicode_core_property(0xA68F, 0xA68F, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TSWE
unicode_core_property(0xA691, 0xA691, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TSSE
unicode_core_property(0xA693, 0xA693, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER TCHE
unicode_core_property(0xA695, 0xA695, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER HWE
unicode_core_property(0xA697, 0xA697, 'Changes_When_Uppercased').	% L&       CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA723, 0xA723, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA725, 0xA725, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA727, 0xA727, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER HENG
unicode_core_property(0xA729, 0xA729, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TZ
unicode_core_property(0xA72B, 0xA72B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TRESILLO
unicode_core_property(0xA72D, 0xA72D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER CUATRILLO
unicode_core_property(0xA72F, 0xA72F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA733, 0xA733, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AA
unicode_core_property(0xA735, 0xA735, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AO
unicode_core_property(0xA737, 0xA737, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AU
unicode_core_property(0xA739, 0xA739, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AV
unicode_core_property(0xA73B, 0xA73B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73D, 0xA73D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER AY
unicode_core_property(0xA73F, 0xA73F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER REVERSED C WITH DOT
unicode_core_property(0xA741, 0xA741, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH STROKE
unicode_core_property(0xA743, 0xA743, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA745, 0xA745, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA747, 0xA747, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER BROKEN L
unicode_core_property(0xA749, 0xA749, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74B, 0xA74B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74D, 0xA74D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER O WITH LOOP
unicode_core_property(0xA74F, 0xA74F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER OO
unicode_core_property(0xA751, 0xA751, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA753, 0xA753, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH FLOURISH
unicode_core_property(0xA755, 0xA755, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA757, 0xA757, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA759, 0xA759, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75B, 0xA75B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R ROTUNDA
unicode_core_property(0xA75D, 0xA75D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER RUM ROTUNDA
unicode_core_property(0xA75F, 0xA75F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA761, 0xA761, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER VY
unicode_core_property(0xA763, 0xA763, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER VISIGOTHIC Z
unicode_core_property(0xA765, 0xA765, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER THORN WITH STROKE
unicode_core_property(0xA767, 0xA767, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA769, 0xA769, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER VEND
unicode_core_property(0xA76B, 0xA76B, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER ET
unicode_core_property(0xA76D, 0xA76D, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER IS
unicode_core_property(0xA76F, 0xA76F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER CON
unicode_core_property(0xA77A, 0xA77A, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR D
unicode_core_property(0xA77C, 0xA77C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR F
unicode_core_property(0xA77F, 0xA77F, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TURNED INSULAR G
unicode_core_property(0xA781, 0xA781, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER TURNED L
unicode_core_property(0xA783, 0xA783, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR R
unicode_core_property(0xA785, 0xA785, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR S
unicode_core_property(0xA787, 0xA787, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA78C, 0xA78C, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER SALTILLO
unicode_core_property(0xA791, 0xA791, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH DESCENDER
unicode_core_property(0xA793, 0xA793, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A1, 0xA7A1, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A3, 0xA7A3, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A5, 0xA7A5, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A7, 0xA7A7, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A9, 0xA7A9, 'Changes_When_Uppercased').	% L&       LATIN SMALL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xFB00, 0xFB06, 'Changes_When_Uppercased').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Changes_When_Uppercased').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF41, 0xFF5A, 'Changes_When_Uppercased').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0x10428, 0x1044F, 'Changes_When_Uppercased').	% L&  [40] DESERET SMALL LETTER LONG I..DESERET SMALL LETTER EW

% Total code points: 1126

% ================================================

% Derived Property:   Changes_When_Titlecased (CWT)
%  Characters whose normalized forms are not stable under a toTitlecase mapping.
%  For more information, see D126 in Section 3.13, "Default Case Algorithms".
%  Changes_When_Titlecased(X) is true when toTitlecase(toNFD(X)) != toNFD(X)

unicode_core_property(0x0061, 0x007A, 'Changes_When_Titlecased').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00B5, 0x00B5, 'Changes_When_Titlecased').	% L&       MICRO SIGN
unicode_core_property(0x00DF, 0x00F6, 'Changes_When_Titlecased').	% L&  [24] LATIN SMALL LETTER SHARP S..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x00FF, 'Changes_When_Titlecased').	% L&   [8] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER Y WITH DIAERESIS
unicode_core_property(0x0101, 0x0101, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH MACRON
unicode_core_property(0x0103, 0x0103, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE
unicode_core_property(0x0105, 0x0105, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH OGONEK
unicode_core_property(0x0107, 0x0107, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH ACUTE
unicode_core_property(0x0109, 0x0109, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010B, 0x010B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH DOT ABOVE
unicode_core_property(0x010D, 0x010D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH CARON
unicode_core_property(0x010F, 0x010F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH CARON
unicode_core_property(0x0111, 0x0111, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH STROKE
unicode_core_property(0x0113, 0x0113, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH MACRON
unicode_core_property(0x0115, 0x0115, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH BREVE
unicode_core_property(0x0117, 0x0117, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH DOT ABOVE
unicode_core_property(0x0119, 0x0119, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH OGONEK
unicode_core_property(0x011B, 0x011B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CARON
unicode_core_property(0x011D, 0x011D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011F, 0x011F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH BREVE
unicode_core_property(0x0121, 0x0121, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH DOT ABOVE
unicode_core_property(0x0123, 0x0123, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH CEDILLA
unicode_core_property(0x0125, 0x0125, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0127, 0x0127, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH STROKE
unicode_core_property(0x0129, 0x0129, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH TILDE
unicode_core_property(0x012B, 0x012B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH MACRON
unicode_core_property(0x012D, 0x012D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH BREVE
unicode_core_property(0x012F, 0x012F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH OGONEK
unicode_core_property(0x0131, 0x0131, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER DOTLESS I
unicode_core_property(0x0133, 0x0133, 'Changes_When_Titlecased').	% L&       LATIN SMALL LIGATURE IJ
unicode_core_property(0x0135, 0x0135, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0137, 0x0137, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH CEDILLA
unicode_core_property(0x013A, 0x013A, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH ACUTE
unicode_core_property(0x013C, 0x013C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH CEDILLA
unicode_core_property(0x013E, 0x013E, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH CARON
unicode_core_property(0x0140, 0x0140, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0142, 0x0142, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH STROKE
unicode_core_property(0x0144, 0x0144, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH ACUTE
unicode_core_property(0x0146, 0x0146, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH CEDILLA
unicode_core_property(0x0148, 0x0149, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER N WITH CARON..LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
unicode_core_property(0x014B, 0x014B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER ENG
unicode_core_property(0x014D, 0x014D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH MACRON
unicode_core_property(0x014F, 0x014F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH BREVE
unicode_core_property(0x0151, 0x0151, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0153, 0x0153, 'Changes_When_Titlecased').	% L&       LATIN SMALL LIGATURE OE
unicode_core_property(0x0155, 0x0155, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH ACUTE
unicode_core_property(0x0157, 0x0157, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH CEDILLA
unicode_core_property(0x0159, 0x0159, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH CARON
unicode_core_property(0x015B, 0x015B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH ACUTE
unicode_core_property(0x015D, 0x015D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015F, 0x015F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH CEDILLA
unicode_core_property(0x0161, 0x0161, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH CARON
unicode_core_property(0x0163, 0x0163, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH CEDILLA
unicode_core_property(0x0165, 0x0165, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH CARON
unicode_core_property(0x0167, 0x0167, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH STROKE
unicode_core_property(0x0169, 0x0169, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH TILDE
unicode_core_property(0x016B, 0x016B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH MACRON
unicode_core_property(0x016D, 0x016D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH BREVE
unicode_core_property(0x016F, 0x016F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH RING ABOVE
unicode_core_property(0x0171, 0x0171, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0173, 0x0173, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH OGONEK
unicode_core_property(0x0175, 0x0175, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0177, 0x0177, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x017A, 0x017A, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH ACUTE
unicode_core_property(0x017C, 0x017C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017E, 0x0180, 'Changes_When_Titlecased').	% L&   [3] LATIN SMALL LETTER Z WITH CARON..LATIN SMALL LETTER B WITH STROKE
unicode_core_property(0x0183, 0x0183, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER B WITH TOPBAR
unicode_core_property(0x0185, 0x0185, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TONE SIX
unicode_core_property(0x0188, 0x0188, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH HOOK
unicode_core_property(0x018C, 0x018C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH TOPBAR
unicode_core_property(0x0192, 0x0192, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER F WITH HOOK
unicode_core_property(0x0195, 0x0195, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER HV
unicode_core_property(0x0199, 0x019A, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER K WITH HOOK..LATIN SMALL LETTER L WITH BAR
unicode_core_property(0x019E, 0x019E, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x01A1, 0x01A1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN
unicode_core_property(0x01A3, 0x01A3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER OI
unicode_core_property(0x01A5, 0x01A5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH HOOK
unicode_core_property(0x01A8, 0x01A8, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TONE TWO
unicode_core_property(0x01AD, 0x01AD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH HOOK
unicode_core_property(0x01B0, 0x01B0, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN
unicode_core_property(0x01B4, 0x01B4, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH HOOK
unicode_core_property(0x01B6, 0x01B6, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH STROKE
unicode_core_property(0x01B9, 0x01B9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER EZH REVERSED
unicode_core_property(0x01BD, 0x01BD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TONE FIVE
unicode_core_property(0x01BF, 0x01BF, 'Changes_When_Titlecased').	% L&       LATIN LETTER WYNN
unicode_core_property(0x01C4, 0x01C4, 'Changes_When_Titlecased').	% L&       LATIN CAPITAL LETTER DZ WITH CARON
unicode_core_property(0x01C6, 0x01C7, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER DZ WITH CARON..LATIN CAPITAL LETTER LJ
unicode_core_property(0x01C9, 0x01CA, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER LJ..LATIN CAPITAL LETTER NJ
unicode_core_property(0x01CC, 0x01CC, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER NJ
unicode_core_property(0x01CE, 0x01CE, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CARON
unicode_core_property(0x01D0, 0x01D0, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH CARON
unicode_core_property(0x01D2, 0x01D2, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CARON
unicode_core_property(0x01D4, 0x01D4, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH CARON
unicode_core_property(0x01D6, 0x01D6, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D8, 0x01D8, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01DA, 0x01DA, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DC, 0x01DD, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE..LATIN SMALL LETTER TURNED E
unicode_core_property(0x01DF, 0x01DF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E1, 0x01E1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E3, 0x01E3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AE WITH MACRON
unicode_core_property(0x01E5, 0x01E5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH STROKE
unicode_core_property(0x01E7, 0x01E7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH CARON
unicode_core_property(0x01E9, 0x01E9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH CARON
unicode_core_property(0x01EB, 0x01EB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH OGONEK
unicode_core_property(0x01ED, 0x01ED, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EF, 0x01F1, 'Changes_When_Titlecased').	% L&   [3] LATIN SMALL LETTER EZH WITH CARON..LATIN CAPITAL LETTER DZ
unicode_core_property(0x01F3, 0x01F3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER DZ
unicode_core_property(0x01F5, 0x01F5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH ACUTE
unicode_core_property(0x01F9, 0x01F9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH GRAVE
unicode_core_property(0x01FB, 0x01FB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FD, 0x01FD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AE WITH ACUTE
unicode_core_property(0x01FF, 0x01FF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0201, 0x0201, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0203, 0x0203, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0205, 0x0205, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0207, 0x0207, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0209, 0x0209, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020B, 0x020B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020D, 0x020D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020F, 0x020F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0211, 0x0211, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0213, 0x0213, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0215, 0x0215, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0217, 0x0217, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0219, 0x0219, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH COMMA BELOW
unicode_core_property(0x021B, 0x021B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH COMMA BELOW
unicode_core_property(0x021D, 0x021D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER YOGH
unicode_core_property(0x021F, 0x021F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH CARON
unicode_core_property(0x0223, 0x0223, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER OU
unicode_core_property(0x0225, 0x0225, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH HOOK
unicode_core_property(0x0227, 0x0227, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH DOT ABOVE
unicode_core_property(0x0229, 0x0229, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CEDILLA
unicode_core_property(0x022B, 0x022B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022D, 0x022D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022F, 0x022F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE
unicode_core_property(0x0231, 0x0231, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0233, 0x0233, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH MACRON
unicode_core_property(0x023C, 0x023C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH STROKE
unicode_core_property(0x023F, 0x0240, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER S WITH SWASH TAIL..LATIN SMALL LETTER Z WITH SWASH TAIL
unicode_core_property(0x0242, 0x0242, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER GLOTTAL STOP
unicode_core_property(0x0247, 0x0247, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH STROKE
unicode_core_property(0x0249, 0x0249, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER J WITH STROKE
unicode_core_property(0x024B, 0x024B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Q WITH HOOK TAIL
unicode_core_property(0x024D, 0x024D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH STROKE
unicode_core_property(0x024F, 0x0254, 'Changes_When_Titlecased').	% L&   [6] LATIN SMALL LETTER Y WITH STROKE..LATIN SMALL LETTER OPEN O
unicode_core_property(0x0256, 0x0257, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER D WITH TAIL..LATIN SMALL LETTER D WITH HOOK
unicode_core_property(0x0259, 0x0259, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER SCHWA
unicode_core_property(0x025B, 0x025B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER OPEN E
unicode_core_property(0x0260, 0x0260, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH HOOK
unicode_core_property(0x0263, 0x0263, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER GAMMA
unicode_core_property(0x0265, 0x0266, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER TURNED H..LATIN SMALL LETTER H WITH HOOK
unicode_core_property(0x0268, 0x0269, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER I WITH STROKE..LATIN SMALL LETTER IOTA
unicode_core_property(0x026B, 0x026B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH MIDDLE TILDE
unicode_core_property(0x026F, 0x026F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TURNED M
unicode_core_property(0x0271, 0x0272, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER M WITH HOOK..LATIN SMALL LETTER N WITH LEFT HOOK
unicode_core_property(0x0275, 0x0275, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER BARRED O
unicode_core_property(0x027D, 0x027D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH TAIL
unicode_core_property(0x0280, 0x0280, 'Changes_When_Titlecased').	% L&       LATIN LETTER SMALL CAPITAL R
unicode_core_property(0x0283, 0x0283, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER ESH
unicode_core_property(0x0288, 0x028C, 'Changes_When_Titlecased').	% L&   [5] LATIN SMALL LETTER T WITH RETROFLEX HOOK..LATIN SMALL LETTER TURNED V
unicode_core_property(0x0292, 0x0292, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER EZH
unicode_core_property(0x0345, 0x0345, 'Changes_When_Titlecased').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0371, 0x0371, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER HETA
unicode_core_property(0x0373, 0x0373, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0377, 0x0377, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037B, 0x037D, 'Changes_When_Titlecased').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0390, 0x0390, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
unicode_core_property(0x03AC, 0x03CE, 'Changes_When_Titlecased').	% L&  [35] GREEK SMALL LETTER ALPHA WITH TONOS..GREEK SMALL LETTER OMEGA WITH TONOS
unicode_core_property(0x03D0, 0x03D1, 'Changes_When_Titlecased').	% L&   [2] GREEK BETA SYMBOL..GREEK THETA SYMBOL
unicode_core_property(0x03D5, 0x03D7, 'Changes_When_Titlecased').	% L&   [3] GREEK PHI SYMBOL..GREEK KAI SYMBOL
unicode_core_property(0x03D9, 0x03D9, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER ARCHAIC KOPPA
unicode_core_property(0x03DB, 0x03DB, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER STIGMA
unicode_core_property(0x03DD, 0x03DD, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER DIGAMMA
unicode_core_property(0x03DF, 0x03DF, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER KOPPA
unicode_core_property(0x03E1, 0x03E1, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER SAMPI
unicode_core_property(0x03E3, 0x03E3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER SHEI
unicode_core_property(0x03E5, 0x03E5, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER FEI
unicode_core_property(0x03E7, 0x03E7, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER KHEI
unicode_core_property(0x03E9, 0x03E9, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER HORI
unicode_core_property(0x03EB, 0x03EB, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER GANGIA
unicode_core_property(0x03ED, 0x03ED, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER SHIMA
unicode_core_property(0x03EF, 0x03F2, 'Changes_When_Titlecased').	% L&   [4] COPTIC SMALL LETTER DEI..GREEK LUNATE SIGMA SYMBOL
unicode_core_property(0x03F5, 0x03F5, 'Changes_When_Titlecased').	% L&       GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F8, 0x03F8, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER SHO
unicode_core_property(0x03FB, 0x03FB, 'Changes_When_Titlecased').	% L&       GREEK SMALL LETTER SAN
unicode_core_property(0x0430, 0x045F, 'Changes_When_Titlecased').	% L&  [48] CYRILLIC SMALL LETTER A..CYRILLIC SMALL LETTER DZHE
unicode_core_property(0x0461, 0x0461, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER OMEGA
unicode_core_property(0x0463, 0x0463, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER YAT
unicode_core_property(0x0465, 0x0465, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED E
unicode_core_property(0x0467, 0x0467, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER LITTLE YUS
unicode_core_property(0x0469, 0x0469, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046B, 0x046B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BIG YUS
unicode_core_property(0x046D, 0x046D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046F, 0x046F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KSI
unicode_core_property(0x0471, 0x0471, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER PSI
unicode_core_property(0x0473, 0x0473, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER FITA
unicode_core_property(0x0475, 0x0475, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IZHITSA
unicode_core_property(0x0477, 0x0477, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0479, 0x0479, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER UK
unicode_core_property(0x047B, 0x047B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ROUND OMEGA
unicode_core_property(0x047D, 0x047D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER OMEGA WITH TITLO
unicode_core_property(0x047F, 0x047F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER OT
unicode_core_property(0x0481, 0x0481, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048B, 0x048B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SHORT I WITH TAIL
unicode_core_property(0x048D, 0x048D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SEMISOFT SIGN
unicode_core_property(0x048F, 0x048F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ER WITH TICK
unicode_core_property(0x0491, 0x0491, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER GHE WITH UPTURN
unicode_core_property(0x0493, 0x0493, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE
unicode_core_property(0x0495, 0x0495, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0497, 0x0497, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0499, 0x0499, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZE WITH DESCENDER
unicode_core_property(0x049B, 0x049B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KA WITH DESCENDER
unicode_core_property(0x049D, 0x049D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049F, 0x049F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KA WITH STROKE
unicode_core_property(0x04A1, 0x04A1, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BASHKIR KA
unicode_core_property(0x04A3, 0x04A3, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EN WITH DESCENDER
unicode_core_property(0x04A5, 0x04A5, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LIGATURE EN GHE
unicode_core_property(0x04A7, 0x04A7, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A9, 0x04A9, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN HA
unicode_core_property(0x04AB, 0x04AB, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ES WITH DESCENDER
unicode_core_property(0x04AD, 0x04AD, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TE WITH DESCENDER
unicode_core_property(0x04AF, 0x04AF, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER STRAIGHT U
unicode_core_property(0x04B1, 0x04B1, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B3, 0x04B3, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER HA WITH DESCENDER
unicode_core_property(0x04B5, 0x04B5, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LIGATURE TE TSE
unicode_core_property(0x04B7, 0x04B7, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B9, 0x04B9, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BB, 0x04BB, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SHHA
unicode_core_property(0x04BD, 0x04BD, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE
unicode_core_property(0x04BF, 0x04BF, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C2, 0x04C2, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZHE WITH BREVE
unicode_core_property(0x04C4, 0x04C4, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KA WITH HOOK
unicode_core_property(0x04C6, 0x04C6, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EL WITH TAIL
unicode_core_property(0x04C8, 0x04C8, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EN WITH HOOK
unicode_core_property(0x04CA, 0x04CA, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EN WITH TAIL
unicode_core_property(0x04CC, 0x04CC, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CE, 0x04CF, 'Changes_When_Titlecased').	% L&   [2] CYRILLIC SMALL LETTER EM WITH TAIL..CYRILLIC SMALL LETTER PALOCHKA
unicode_core_property(0x04D1, 0x04D1, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER A WITH BREVE
unicode_core_property(0x04D3, 0x04D3, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER A WITH DIAERESIS
unicode_core_property(0x04D5, 0x04D5, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LIGATURE A IE
unicode_core_property(0x04D7, 0x04D7, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IE WITH BREVE
unicode_core_property(0x04D9, 0x04D9, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SCHWA
unicode_core_property(0x04DB, 0x04DB, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DD, 0x04DD, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DF, 0x04DF, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E1, 0x04E1, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ABKHASIAN DZE
unicode_core_property(0x04E3, 0x04E3, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER I WITH MACRON
unicode_core_property(0x04E5, 0x04E5, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER I WITH DIAERESIS
unicode_core_property(0x04E7, 0x04E7, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x04E9, 0x04E9, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BARRED O
unicode_core_property(0x04EB, 0x04EB, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04ED, 0x04ED, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER E WITH DIAERESIS
unicode_core_property(0x04EF, 0x04EF, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER U WITH MACRON
unicode_core_property(0x04F1, 0x04F1, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER U WITH DIAERESIS
unicode_core_property(0x04F3, 0x04F3, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F5, 0x04F5, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F7, 0x04F7, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F9, 0x04F9, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FB, 0x04FB, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FD, 0x04FD, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER HA WITH HOOK
unicode_core_property(0x04FF, 0x04FF, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER HA WITH STROKE
unicode_core_property(0x0501, 0x0501, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI DE
unicode_core_property(0x0503, 0x0503, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI DJE
unicode_core_property(0x0505, 0x0505, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI ZJE
unicode_core_property(0x0507, 0x0507, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI DZJE
unicode_core_property(0x0509, 0x0509, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI LJE
unicode_core_property(0x050B, 0x050B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI NJE
unicode_core_property(0x050D, 0x050D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI SJE
unicode_core_property(0x050F, 0x050F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER KOMI TJE
unicode_core_property(0x0511, 0x0511, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER REVERSED ZE
unicode_core_property(0x0513, 0x0513, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EL WITH HOOK
unicode_core_property(0x0515, 0x0515, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER LHA
unicode_core_property(0x0517, 0x0517, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER RHA
unicode_core_property(0x0519, 0x0519, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER YAE
unicode_core_property(0x051B, 0x051B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER QA
unicode_core_property(0x051D, 0x051D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER WE
unicode_core_property(0x051F, 0x051F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ALEUT KA
unicode_core_property(0x0521, 0x0521, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0523, 0x0523, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0525, 0x0525, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER PE WITH DESCENDER
unicode_core_property(0x0527, 0x0527, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0561, 0x0587, 'Changes_When_Titlecased').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x1D79, 0x1D79, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR G
unicode_core_property(0x1D7D, 0x1D7D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH STROKE
unicode_core_property(0x1E01, 0x1E01, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH RING BELOW
unicode_core_property(0x1E03, 0x1E03, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E05, 0x1E05, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER B WITH DOT BELOW
unicode_core_property(0x1E07, 0x1E07, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER B WITH LINE BELOW
unicode_core_property(0x1E09, 0x1E09, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0B, 0x1E0B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0D, 0x1E0D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0F, 0x1E0F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH LINE BELOW
unicode_core_property(0x1E11, 0x1E11, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH CEDILLA
unicode_core_property(0x1E13, 0x1E13, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E15, 0x1E15, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E17, 0x1E17, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E19, 0x1E19, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1B, 0x1E1B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1D, 0x1E1D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1F, 0x1E1F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E21, 0x1E21, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH MACRON
unicode_core_property(0x1E23, 0x1E23, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E25, 0x1E25, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH DOT BELOW
unicode_core_property(0x1E27, 0x1E27, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH DIAERESIS
unicode_core_property(0x1E29, 0x1E29, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH CEDILLA
unicode_core_property(0x1E2B, 0x1E2B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2D, 0x1E2D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2F, 0x1E2F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E31, 0x1E31, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH ACUTE
unicode_core_property(0x1E33, 0x1E33, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH DOT BELOW
unicode_core_property(0x1E35, 0x1E35, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH LINE BELOW
unicode_core_property(0x1E37, 0x1E37, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH DOT BELOW
unicode_core_property(0x1E39, 0x1E39, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3B, 0x1E3B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3D, 0x1E3D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3F, 0x1E3F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER M WITH ACUTE
unicode_core_property(0x1E41, 0x1E41, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E43, 0x1E43, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER M WITH DOT BELOW
unicode_core_property(0x1E45, 0x1E45, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E47, 0x1E47, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH DOT BELOW
unicode_core_property(0x1E49, 0x1E49, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4B, 0x1E4B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4D, 0x1E4D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4F, 0x1E4F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E51, 0x1E51, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E53, 0x1E53, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E55, 0x1E55, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH ACUTE
unicode_core_property(0x1E57, 0x1E57, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E59, 0x1E59, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5B, 0x1E5B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5D, 0x1E5D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5F, 0x1E5F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH LINE BELOW
unicode_core_property(0x1E61, 0x1E61, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E63, 0x1E63, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH DOT BELOW
unicode_core_property(0x1E65, 0x1E65, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E67, 0x1E67, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E69, 0x1E69, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6B, 0x1E6B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6D, 0x1E6D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6F, 0x1E6F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH LINE BELOW
unicode_core_property(0x1E71, 0x1E71, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E73, 0x1E73, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E75, 0x1E75, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E77, 0x1E77, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E79, 0x1E79, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7B, 0x1E7B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7D, 0x1E7D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER V WITH TILDE
unicode_core_property(0x1E7F, 0x1E7F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER V WITH DOT BELOW
unicode_core_property(0x1E81, 0x1E81, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH GRAVE
unicode_core_property(0x1E83, 0x1E83, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH ACUTE
unicode_core_property(0x1E85, 0x1E85, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH DIAERESIS
unicode_core_property(0x1E87, 0x1E87, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E89, 0x1E89, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8B, 0x1E8B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8D, 0x1E8D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8F, 0x1E8F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E91, 0x1E91, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E93, 0x1E93, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E95, 0x1E9B, 'Changes_When_Titlecased').	% L&   [7] LATIN SMALL LETTER Z WITH LINE BELOW..LATIN SMALL LETTER LONG S WITH DOT ABOVE
unicode_core_property(0x1EA1, 0x1EA1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA3, 0x1EA3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA5, 0x1EA5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA7, 0x1EA7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA9, 0x1EA9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAB, 0x1EAB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAD, 0x1EAD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAF, 0x1EAF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB1, 0x1EB1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB3, 0x1EB3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB5, 0x1EB5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB7, 0x1EB7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB9, 0x1EB9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBB, 0x1EBB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBD, 0x1EBD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH TILDE
unicode_core_property(0x1EBF, 0x1EBF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC1, 0x1EC1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC3, 0x1EC3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC5, 0x1EC5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC7, 0x1EC7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC9, 0x1EC9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECB, 0x1ECB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECD, 0x1ECD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECF, 0x1ECF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED1, 0x1ED1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED3, 0x1ED3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED5, 0x1ED5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED7, 0x1ED7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED9, 0x1ED9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDB, 0x1EDB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDD, 0x1EDD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDF, 0x1EDF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE1, 0x1EE1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE3, 0x1EE3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE5, 0x1EE5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE7, 0x1EE7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE9, 0x1EE9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEB, 0x1EEB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EED, 0x1EED, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEF, 0x1EEF, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF1, 0x1EF1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF3, 0x1EF3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH GRAVE
unicode_core_property(0x1EF5, 0x1EF5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF7, 0x1EF7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF9, 0x1EF9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Y WITH TILDE
unicode_core_property(0x1EFB, 0x1EFB, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFD, 0x1EFD, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFF, 0x1F07, 'Changes_When_Titlecased').	% L&   [9] LATIN SMALL LETTER Y WITH LOOP..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F10, 0x1F15, 'Changes_When_Titlecased').	% L&   [6] GREEK SMALL LETTER EPSILON WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F27, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F30, 0x1F37, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER IOTA WITH PSILI..GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F40, 0x1F45, 'Changes_When_Titlecased').	% L&   [6] GREEK SMALL LETTER OMICRON WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F60, 0x1F67, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F70, 0x1F7D, 'Changes_When_Titlecased').	% L&  [14] GREEK SMALL LETTER ALPHA WITH VARIA..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1F87, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1F90, 0x1F97, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FA0, 0x1FA7, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FB0, 0x1FB4, 'Changes_When_Titlecased').	% L&   [5] GREEK SMALL LETTER ALPHA WITH VRACHY..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FB7, 'Changes_When_Titlecased').	% L&   [2] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Changes_When_Titlecased').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Changes_When_Titlecased').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FC7, 'Changes_When_Titlecased').	% L&   [2] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Changes_When_Titlecased').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FD7, 'Changes_When_Titlecased').	% L&   [2] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FE0, 0x1FE7, 'Changes_When_Titlecased').	% L&   [8] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
unicode_core_property(0x1FF2, 0x1FF4, 'Changes_When_Titlecased').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FF7, 'Changes_When_Titlecased').	% L&   [2] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
unicode_core_property(0x214E, 0x214E, 'Changes_When_Titlecased').	% L&       TURNED SMALL F
unicode_core_property(0x2170, 0x217F, 'Changes_When_Titlecased').	% Nl  [16] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2184, 0x2184, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER REVERSED C
unicode_core_property(0x24D0, 0x24E9, 'Changes_When_Titlecased').	% So  [26] CIRCLED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C30, 0x2C5E, 'Changes_When_Titlecased').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C61, 0x2C61, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C65, 0x2C66, 'Changes_When_Titlecased').	% L&   [2] LATIN SMALL LETTER A WITH STROKE..LATIN SMALL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x2C68, 0x2C68, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER H WITH DESCENDER
unicode_core_property(0x2C6A, 0x2C6A, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH DESCENDER
unicode_core_property(0x2C6C, 0x2C6C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Z WITH DESCENDER
unicode_core_property(0x2C73, 0x2C73, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER W WITH HOOK
unicode_core_property(0x2C76, 0x2C76, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER HALF H
unicode_core_property(0x2C81, 0x2C81, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER ALFA
unicode_core_property(0x2C83, 0x2C83, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER VIDA
unicode_core_property(0x2C85, 0x2C85, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER GAMMA
unicode_core_property(0x2C87, 0x2C87, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER DALDA
unicode_core_property(0x2C89, 0x2C89, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER EIE
unicode_core_property(0x2C8B, 0x2C8B, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER SOU
unicode_core_property(0x2C8D, 0x2C8D, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER ZATA
unicode_core_property(0x2C8F, 0x2C8F, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER HATE
unicode_core_property(0x2C91, 0x2C91, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER THETHE
unicode_core_property(0x2C93, 0x2C93, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER IAUDA
unicode_core_property(0x2C95, 0x2C95, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER KAPA
unicode_core_property(0x2C97, 0x2C97, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER LAULA
unicode_core_property(0x2C99, 0x2C99, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER MI
unicode_core_property(0x2C9B, 0x2C9B, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER NI
unicode_core_property(0x2C9D, 0x2C9D, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER KSI
unicode_core_property(0x2C9F, 0x2C9F, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER O
unicode_core_property(0x2CA1, 0x2CA1, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER PI
unicode_core_property(0x2CA3, 0x2CA3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER RO
unicode_core_property(0x2CA5, 0x2CA5, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER SIMA
unicode_core_property(0x2CA7, 0x2CA7, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER TAU
unicode_core_property(0x2CA9, 0x2CA9, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER UA
unicode_core_property(0x2CAB, 0x2CAB, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER FI
unicode_core_property(0x2CAD, 0x2CAD, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER KHI
unicode_core_property(0x2CAF, 0x2CAF, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER PSI
unicode_core_property(0x2CB1, 0x2CB1, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OOU
unicode_core_property(0x2CB3, 0x2CB3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB5, 0x2CB5, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB7, 0x2CB7, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB9, 0x2CB9, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBB, 0x2CBB, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER DIALECT-P NI
unicode_core_property(0x2CBD, 0x2CBD, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBF, 0x2CBF, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC1, 0x2CC1, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER SAMPI
unicode_core_property(0x2CC3, 0x2CC3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER CROSSED SHEI
unicode_core_property(0x2CC5, 0x2CC5, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC7, 0x2CC7, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC9, 0x2CC9, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCB, 0x2CCB, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER DIALECT-P HORI
unicode_core_property(0x2CCD, 0x2CCD, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCF, 0x2CCF, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC HA
unicode_core_property(0x2CD1, 0x2CD1, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER L-SHAPED HA
unicode_core_property(0x2CD3, 0x2CD3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD5, 0x2CD5, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD7, 0x2CD7, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD9, 0x2CD9, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDB, 0x2CDB, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDD, 0x2CDD, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDF, 0x2CDF, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE1, 0x2CE1, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE3, 0x2CE3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEC, 0x2CEC, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CEE, 0x2CEE, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF3, 0x2CF3, 'Changes_When_Titlecased').	% L&       COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Changes_When_Titlecased').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Changes_When_Titlecased').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Changes_When_Titlecased').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0xA641, 0xA641, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZEMLYA
unicode_core_property(0xA643, 0xA643, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DZELO
unicode_core_property(0xA645, 0xA645, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER REVERSED DZE
unicode_core_property(0xA647, 0xA647, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTA
unicode_core_property(0xA649, 0xA649, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DJERV
unicode_core_property(0xA64B, 0xA64B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER MONOGRAPH UK
unicode_core_property(0xA64D, 0xA64D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BROAD OMEGA
unicode_core_property(0xA64F, 0xA64F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER NEUTRAL YER
unicode_core_property(0xA651, 0xA651, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER YERU WITH BACK YER
unicode_core_property(0xA653, 0xA653, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED YAT
unicode_core_property(0xA655, 0xA655, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER REVERSED YU
unicode_core_property(0xA657, 0xA657, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED A
unicode_core_property(0xA659, 0xA659, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65B, 0xA65B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BLENDED YUS
unicode_core_property(0xA65D, 0xA65D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65F, 0xA65F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER YN
unicode_core_property(0xA661, 0xA661, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER REVERSED TSE
unicode_core_property(0xA663, 0xA663, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SOFT DE
unicode_core_property(0xA665, 0xA665, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SOFT EL
unicode_core_property(0xA667, 0xA667, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SOFT EM
unicode_core_property(0xA669, 0xA669, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER MONOCULAR O
unicode_core_property(0xA66B, 0xA66B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER BINOCULAR O
unicode_core_property(0xA66D, 0xA66D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA681, 0xA681, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DWE
unicode_core_property(0xA683, 0xA683, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DZWE
unicode_core_property(0xA685, 0xA685, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER ZHWE
unicode_core_property(0xA687, 0xA687, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER CCHE
unicode_core_property(0xA689, 0xA689, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER DZZE
unicode_core_property(0xA68B, 0xA68B, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68D, 0xA68D, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TWE
unicode_core_property(0xA68F, 0xA68F, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TSWE
unicode_core_property(0xA691, 0xA691, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TSSE
unicode_core_property(0xA693, 0xA693, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER TCHE
unicode_core_property(0xA695, 0xA695, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER HWE
unicode_core_property(0xA697, 0xA697, 'Changes_When_Titlecased').	% L&       CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA723, 0xA723, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA725, 0xA725, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA727, 0xA727, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER HENG
unicode_core_property(0xA729, 0xA729, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TZ
unicode_core_property(0xA72B, 0xA72B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TRESILLO
unicode_core_property(0xA72D, 0xA72D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER CUATRILLO
unicode_core_property(0xA72F, 0xA72F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA733, 0xA733, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AA
unicode_core_property(0xA735, 0xA735, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AO
unicode_core_property(0xA737, 0xA737, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AU
unicode_core_property(0xA739, 0xA739, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AV
unicode_core_property(0xA73B, 0xA73B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73D, 0xA73D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER AY
unicode_core_property(0xA73F, 0xA73F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER REVERSED C WITH DOT
unicode_core_property(0xA741, 0xA741, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH STROKE
unicode_core_property(0xA743, 0xA743, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA745, 0xA745, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA747, 0xA747, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER BROKEN L
unicode_core_property(0xA749, 0xA749, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74B, 0xA74B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74D, 0xA74D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER O WITH LOOP
unicode_core_property(0xA74F, 0xA74F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER OO
unicode_core_property(0xA751, 0xA751, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA753, 0xA753, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH FLOURISH
unicode_core_property(0xA755, 0xA755, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA757, 0xA757, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA759, 0xA759, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75B, 0xA75B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R ROTUNDA
unicode_core_property(0xA75D, 0xA75D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER RUM ROTUNDA
unicode_core_property(0xA75F, 0xA75F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA761, 0xA761, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER VY
unicode_core_property(0xA763, 0xA763, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER VISIGOTHIC Z
unicode_core_property(0xA765, 0xA765, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER THORN WITH STROKE
unicode_core_property(0xA767, 0xA767, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA769, 0xA769, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER VEND
unicode_core_property(0xA76B, 0xA76B, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER ET
unicode_core_property(0xA76D, 0xA76D, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER IS
unicode_core_property(0xA76F, 0xA76F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER CON
unicode_core_property(0xA77A, 0xA77A, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR D
unicode_core_property(0xA77C, 0xA77C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR F
unicode_core_property(0xA77F, 0xA77F, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TURNED INSULAR G
unicode_core_property(0xA781, 0xA781, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER TURNED L
unicode_core_property(0xA783, 0xA783, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR R
unicode_core_property(0xA785, 0xA785, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR S
unicode_core_property(0xA787, 0xA787, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA78C, 0xA78C, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER SALTILLO
unicode_core_property(0xA791, 0xA791, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH DESCENDER
unicode_core_property(0xA793, 0xA793, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A1, 0xA7A1, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A3, 0xA7A3, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A5, 0xA7A5, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A7, 0xA7A7, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A9, 0xA7A9, 'Changes_When_Titlecased').	% L&       LATIN SMALL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xFB00, 0xFB06, 'Changes_When_Titlecased').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Changes_When_Titlecased').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF41, 0xFF5A, 'Changes_When_Titlecased').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0x10428, 0x1044F, 'Changes_When_Titlecased').	% L&  [40] DESERET SMALL LETTER LONG I..DESERET SMALL LETTER EW

% Total code points: 1099

% ================================================

% Derived Property:   Changes_When_Casefolded (CWCF)
%  Characters whose normalized forms are not stable under case folding.
%  For more information, see D127 in Section 3.13, "Default Case Algorithms".
%  Changes_When_Casefolded(X) is true when toCasefold(toNFD(X)) != toNFD(X)

unicode_core_property(0x0041, 0x005A, 'Changes_When_Casefolded').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x00B5, 0x00B5, 'Changes_When_Casefolded').	% L&       MICRO SIGN
unicode_core_property(0x00C0, 0x00D6, 'Changes_When_Casefolded').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00DF, 'Changes_When_Casefolded').	% L&   [8] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER SHARP S
unicode_core_property(0x0100, 0x0100, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH MACRON
unicode_core_property(0x0102, 0x0102, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE
unicode_core_property(0x0104, 0x0104, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH OGONEK
unicode_core_property(0x0106, 0x0106, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH ACUTE
unicode_core_property(0x0108, 0x0108, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH CIRCUMFLEX
unicode_core_property(0x010A, 0x010A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH DOT ABOVE
unicode_core_property(0x010C, 0x010C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH CARON
unicode_core_property(0x010E, 0x010E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH CARON
unicode_core_property(0x0110, 0x0110, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH STROKE
unicode_core_property(0x0112, 0x0112, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH MACRON
unicode_core_property(0x0114, 0x0114, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH BREVE
unicode_core_property(0x0116, 0x0116, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH DOT ABOVE
unicode_core_property(0x0118, 0x0118, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH OGONEK
unicode_core_property(0x011A, 0x011A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CARON
unicode_core_property(0x011C, 0x011C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH CIRCUMFLEX
unicode_core_property(0x011E, 0x011E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH BREVE
unicode_core_property(0x0120, 0x0120, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH DOT ABOVE
unicode_core_property(0x0122, 0x0122, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH CEDILLA
unicode_core_property(0x0124, 0x0124, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH CIRCUMFLEX
unicode_core_property(0x0126, 0x0126, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH STROKE
unicode_core_property(0x0128, 0x0128, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH TILDE
unicode_core_property(0x012A, 0x012A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH MACRON
unicode_core_property(0x012C, 0x012C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH BREVE
unicode_core_property(0x012E, 0x012E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH OGONEK
unicode_core_property(0x0130, 0x0130, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH DOT ABOVE
unicode_core_property(0x0132, 0x0132, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LIGATURE IJ
unicode_core_property(0x0134, 0x0134, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER J WITH CIRCUMFLEX
unicode_core_property(0x0136, 0x0136, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH CEDILLA
unicode_core_property(0x0139, 0x0139, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH ACUTE
unicode_core_property(0x013B, 0x013B, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH CEDILLA
unicode_core_property(0x013D, 0x013D, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH CARON
unicode_core_property(0x013F, 0x013F, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH MIDDLE DOT
unicode_core_property(0x0141, 0x0141, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH STROKE
unicode_core_property(0x0143, 0x0143, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH ACUTE
unicode_core_property(0x0145, 0x0145, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH CEDILLA
unicode_core_property(0x0147, 0x0147, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH CARON
unicode_core_property(0x0149, 0x014A, 'Changes_When_Casefolded').	% L&   [2] LATIN SMALL LETTER N PRECEDED BY APOSTROPHE..LATIN CAPITAL LETTER ENG
unicode_core_property(0x014C, 0x014C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH MACRON
unicode_core_property(0x014E, 0x014E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH BREVE
unicode_core_property(0x0150, 0x0150, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
unicode_core_property(0x0152, 0x0152, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LIGATURE OE
unicode_core_property(0x0154, 0x0154, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH ACUTE
unicode_core_property(0x0156, 0x0156, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH CEDILLA
unicode_core_property(0x0158, 0x0158, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH CARON
unicode_core_property(0x015A, 0x015A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH ACUTE
unicode_core_property(0x015C, 0x015C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH CIRCUMFLEX
unicode_core_property(0x015E, 0x015E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH CEDILLA
unicode_core_property(0x0160, 0x0160, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH CARON
unicode_core_property(0x0162, 0x0162, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH CEDILLA
unicode_core_property(0x0164, 0x0164, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH CARON
unicode_core_property(0x0166, 0x0166, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH STROKE
unicode_core_property(0x0168, 0x0168, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH TILDE
unicode_core_property(0x016A, 0x016A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH MACRON
unicode_core_property(0x016C, 0x016C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH BREVE
unicode_core_property(0x016E, 0x016E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH RING ABOVE
unicode_core_property(0x0170, 0x0170, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x0172, 0x0172, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH OGONEK
unicode_core_property(0x0174, 0x0174, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH CIRCUMFLEX
unicode_core_property(0x0176, 0x0176, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
unicode_core_property(0x0178, 0x0179, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER Y WITH DIAERESIS..LATIN CAPITAL LETTER Z WITH ACUTE
unicode_core_property(0x017B, 0x017B, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH DOT ABOVE
unicode_core_property(0x017D, 0x017D, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH CARON
unicode_core_property(0x017F, 0x017F, 'Changes_When_Casefolded').	% L&       LATIN SMALL LETTER LONG S
unicode_core_property(0x0181, 0x0182, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER B WITH HOOK..LATIN CAPITAL LETTER B WITH TOPBAR
unicode_core_property(0x0184, 0x0184, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TONE SIX
unicode_core_property(0x0186, 0x0187, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER OPEN O..LATIN CAPITAL LETTER C WITH HOOK
unicode_core_property(0x0189, 0x018B, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER AFRICAN D..LATIN CAPITAL LETTER D WITH TOPBAR
unicode_core_property(0x018E, 0x0191, 'Changes_When_Casefolded').	% L&   [4] LATIN CAPITAL LETTER REVERSED E..LATIN CAPITAL LETTER F WITH HOOK
unicode_core_property(0x0193, 0x0194, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER G WITH HOOK..LATIN CAPITAL LETTER GAMMA
unicode_core_property(0x0196, 0x0198, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER IOTA..LATIN CAPITAL LETTER K WITH HOOK
unicode_core_property(0x019C, 0x019D, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER N WITH LEFT HOOK
unicode_core_property(0x019F, 0x01A0, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER O WITH MIDDLE TILDE..LATIN CAPITAL LETTER O WITH HORN
unicode_core_property(0x01A2, 0x01A2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER OI
unicode_core_property(0x01A4, 0x01A4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH HOOK
unicode_core_property(0x01A6, 0x01A7, 'Changes_When_Casefolded').	% L&   [2] LATIN LETTER YR..LATIN CAPITAL LETTER TONE TWO
unicode_core_property(0x01A9, 0x01A9, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER ESH
unicode_core_property(0x01AC, 0x01AC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH HOOK
unicode_core_property(0x01AE, 0x01AF, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER T WITH RETROFLEX HOOK..LATIN CAPITAL LETTER U WITH HORN
unicode_core_property(0x01B1, 0x01B3, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER UPSILON..LATIN CAPITAL LETTER Y WITH HOOK
unicode_core_property(0x01B5, 0x01B5, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH STROKE
unicode_core_property(0x01B7, 0x01B8, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER EZH..LATIN CAPITAL LETTER EZH REVERSED
unicode_core_property(0x01BC, 0x01BC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TONE FIVE
unicode_core_property(0x01C4, 0x01C5, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER DZ WITH CARON..LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
unicode_core_property(0x01C7, 0x01C8, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER LJ..LATIN CAPITAL LETTER L WITH SMALL LETTER J
unicode_core_property(0x01CA, 0x01CB, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER NJ..LATIN CAPITAL LETTER N WITH SMALL LETTER J
unicode_core_property(0x01CD, 0x01CD, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CARON
unicode_core_property(0x01CF, 0x01CF, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH CARON
unicode_core_property(0x01D1, 0x01D1, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CARON
unicode_core_property(0x01D3, 0x01D3, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH CARON
unicode_core_property(0x01D5, 0x01D5, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
unicode_core_property(0x01D7, 0x01D7, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
unicode_core_property(0x01D9, 0x01D9, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
unicode_core_property(0x01DB, 0x01DB, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
unicode_core_property(0x01DE, 0x01DE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
unicode_core_property(0x01E0, 0x01E0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
unicode_core_property(0x01E2, 0x01E2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AE WITH MACRON
unicode_core_property(0x01E4, 0x01E4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH STROKE
unicode_core_property(0x01E6, 0x01E6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH CARON
unicode_core_property(0x01E8, 0x01E8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH CARON
unicode_core_property(0x01EA, 0x01EA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH OGONEK
unicode_core_property(0x01EC, 0x01EC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
unicode_core_property(0x01EE, 0x01EE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER EZH WITH CARON
unicode_core_property(0x01F1, 0x01F2, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER DZ..LATIN CAPITAL LETTER D WITH SMALL LETTER Z
unicode_core_property(0x01F4, 0x01F4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH ACUTE
unicode_core_property(0x01F6, 0x01F8, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER HWAIR..LATIN CAPITAL LETTER N WITH GRAVE
unicode_core_property(0x01FA, 0x01FA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
unicode_core_property(0x01FC, 0x01FC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AE WITH ACUTE
unicode_core_property(0x01FE, 0x01FE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
unicode_core_property(0x0200, 0x0200, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
unicode_core_property(0x0202, 0x0202, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH INVERTED BREVE
unicode_core_property(0x0204, 0x0204, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
unicode_core_property(0x0206, 0x0206, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH INVERTED BREVE
unicode_core_property(0x0208, 0x0208, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
unicode_core_property(0x020A, 0x020A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH INVERTED BREVE
unicode_core_property(0x020C, 0x020C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
unicode_core_property(0x020E, 0x020E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH INVERTED BREVE
unicode_core_property(0x0210, 0x0210, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
unicode_core_property(0x0212, 0x0212, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH INVERTED BREVE
unicode_core_property(0x0214, 0x0214, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
unicode_core_property(0x0216, 0x0216, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH INVERTED BREVE
unicode_core_property(0x0218, 0x0218, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH COMMA BELOW
unicode_core_property(0x021A, 0x021A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH COMMA BELOW
unicode_core_property(0x021C, 0x021C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER YOGH
unicode_core_property(0x021E, 0x021E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH CARON
unicode_core_property(0x0220, 0x0220, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x0222, 0x0222, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER OU
unicode_core_property(0x0224, 0x0224, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH HOOK
unicode_core_property(0x0226, 0x0226, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH DOT ABOVE
unicode_core_property(0x0228, 0x0228, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA
unicode_core_property(0x022A, 0x022A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
unicode_core_property(0x022C, 0x022C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND MACRON
unicode_core_property(0x022E, 0x022E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE
unicode_core_property(0x0230, 0x0230, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
unicode_core_property(0x0232, 0x0232, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH MACRON
unicode_core_property(0x023A, 0x023B, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER A WITH STROKE..LATIN CAPITAL LETTER C WITH STROKE
unicode_core_property(0x023D, 0x023E, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER L WITH BAR..LATIN CAPITAL LETTER T WITH DIAGONAL STROKE
unicode_core_property(0x0241, 0x0241, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER GLOTTAL STOP
unicode_core_property(0x0243, 0x0246, 'Changes_When_Casefolded').	% L&   [4] LATIN CAPITAL LETTER B WITH STROKE..LATIN CAPITAL LETTER E WITH STROKE
unicode_core_property(0x0248, 0x0248, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER J WITH STROKE
unicode_core_property(0x024A, 0x024A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL
unicode_core_property(0x024C, 0x024C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH STROKE
unicode_core_property(0x024E, 0x024E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH STROKE
unicode_core_property(0x0345, 0x0345, 'Changes_When_Casefolded').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0370, 0x0370, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER HETA
unicode_core_property(0x0372, 0x0372, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER ARCHAIC SAMPI
unicode_core_property(0x0376, 0x0376, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x0386, 0x0386, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Changes_When_Casefolded').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x038F, 'Changes_When_Casefolded').	% L&   [2] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER OMEGA WITH TONOS
unicode_core_property(0x0391, 0x03A1, 'Changes_When_Casefolded').	% L&  [17] GREEK CAPITAL LETTER ALPHA..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03AB, 'Changes_When_Casefolded').	% L&   [9] GREEK CAPITAL LETTER SIGMA..GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
unicode_core_property(0x03C2, 0x03C2, 'Changes_When_Casefolded').	% L&       GREEK SMALL LETTER FINAL SIGMA
unicode_core_property(0x03CF, 0x03D1, 'Changes_When_Casefolded').	% L&   [3] GREEK CAPITAL KAI SYMBOL..GREEK THETA SYMBOL
unicode_core_property(0x03D5, 0x03D6, 'Changes_When_Casefolded').	% L&   [2] GREEK PHI SYMBOL..GREEK PI SYMBOL
unicode_core_property(0x03D8, 0x03D8, 'Changes_When_Casefolded').	% L&       GREEK LETTER ARCHAIC KOPPA
unicode_core_property(0x03DA, 0x03DA, 'Changes_When_Casefolded').	% L&       GREEK LETTER STIGMA
unicode_core_property(0x03DC, 0x03DC, 'Changes_When_Casefolded').	% L&       GREEK LETTER DIGAMMA
unicode_core_property(0x03DE, 0x03DE, 'Changes_When_Casefolded').	% L&       GREEK LETTER KOPPA
unicode_core_property(0x03E0, 0x03E0, 'Changes_When_Casefolded').	% L&       GREEK LETTER SAMPI
unicode_core_property(0x03E2, 0x03E2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER SHEI
unicode_core_property(0x03E4, 0x03E4, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER FEI
unicode_core_property(0x03E6, 0x03E6, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER KHEI
unicode_core_property(0x03E8, 0x03E8, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER HORI
unicode_core_property(0x03EA, 0x03EA, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER GANGIA
unicode_core_property(0x03EC, 0x03EC, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER SHIMA
unicode_core_property(0x03EE, 0x03EE, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DEI
unicode_core_property(0x03F0, 0x03F1, 'Changes_When_Casefolded').	% L&   [2] GREEK KAPPA SYMBOL..GREEK RHO SYMBOL
unicode_core_property(0x03F4, 0x03F5, 'Changes_When_Casefolded').	% L&   [2] GREEK CAPITAL THETA SYMBOL..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x03F7, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER SHO
unicode_core_property(0x03F9, 0x03FA, 'Changes_When_Casefolded').	% L&   [2] GREEK CAPITAL LUNATE SIGMA SYMBOL..GREEK CAPITAL LETTER SAN
unicode_core_property(0x03FD, 0x042F, 'Changes_When_Casefolded').	% L&  [51] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC CAPITAL LETTER YA
unicode_core_property(0x0460, 0x0460, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER OMEGA
unicode_core_property(0x0462, 0x0462, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER YAT
unicode_core_property(0x0464, 0x0464, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED E
unicode_core_property(0x0466, 0x0466, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER LITTLE YUS
unicode_core_property(0x0468, 0x0468, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
unicode_core_property(0x046A, 0x046A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BIG YUS
unicode_core_property(0x046C, 0x046C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
unicode_core_property(0x046E, 0x046E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KSI
unicode_core_property(0x0470, 0x0470, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER PSI
unicode_core_property(0x0472, 0x0472, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER FITA
unicode_core_property(0x0474, 0x0474, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IZHITSA
unicode_core_property(0x0476, 0x0476, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
unicode_core_property(0x0478, 0x0478, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER UK
unicode_core_property(0x047A, 0x047A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ROUND OMEGA
unicode_core_property(0x047C, 0x047C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
unicode_core_property(0x047E, 0x047E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER OT
unicode_core_property(0x0480, 0x0480, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOPPA
unicode_core_property(0x048A, 0x048A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
unicode_core_property(0x048C, 0x048C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SEMISOFT SIGN
unicode_core_property(0x048E, 0x048E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ER WITH TICK
unicode_core_property(0x0490, 0x0490, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER GHE WITH UPTURN
unicode_core_property(0x0492, 0x0492, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE
unicode_core_property(0x0494, 0x0494, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
unicode_core_property(0x0496, 0x0496, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
unicode_core_property(0x0498, 0x0498, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
unicode_core_property(0x049A, 0x049A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KA WITH DESCENDER
unicode_core_property(0x049C, 0x049C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
unicode_core_property(0x049E, 0x049E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KA WITH STROKE
unicode_core_property(0x04A0, 0x04A0, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BASHKIR KA
unicode_core_property(0x04A2, 0x04A2, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EN WITH DESCENDER
unicode_core_property(0x04A4, 0x04A4, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LIGATURE EN GHE
unicode_core_property(0x04A6, 0x04A6, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
unicode_core_property(0x04A8, 0x04A8, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN HA
unicode_core_property(0x04AA, 0x04AA, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ES WITH DESCENDER
unicode_core_property(0x04AC, 0x04AC, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TE WITH DESCENDER
unicode_core_property(0x04AE, 0x04AE, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U
unicode_core_property(0x04B0, 0x04B0, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
unicode_core_property(0x04B2, 0x04B2, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER HA WITH DESCENDER
unicode_core_property(0x04B4, 0x04B4, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LIGATURE TE TSE
unicode_core_property(0x04B6, 0x04B6, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
unicode_core_property(0x04B8, 0x04B8, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
unicode_core_property(0x04BA, 0x04BA, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SHHA
unicode_core_property(0x04BC, 0x04BC, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE
unicode_core_property(0x04BE, 0x04BE, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
unicode_core_property(0x04C0, 0x04C1, 'Changes_When_Casefolded').	% L&   [2] CYRILLIC LETTER PALOCHKA..CYRILLIC CAPITAL LETTER ZHE WITH BREVE
unicode_core_property(0x04C3, 0x04C3, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KA WITH HOOK
unicode_core_property(0x04C5, 0x04C5, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EL WITH TAIL
unicode_core_property(0x04C7, 0x04C7, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EN WITH HOOK
unicode_core_property(0x04C9, 0x04C9, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EN WITH TAIL
unicode_core_property(0x04CB, 0x04CB, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
unicode_core_property(0x04CD, 0x04CD, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EM WITH TAIL
unicode_core_property(0x04D0, 0x04D0, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER A WITH BREVE
unicode_core_property(0x04D2, 0x04D2, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER A WITH DIAERESIS
unicode_core_property(0x04D4, 0x04D4, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LIGATURE A IE
unicode_core_property(0x04D6, 0x04D6, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IE WITH BREVE
unicode_core_property(0x04D8, 0x04D8, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SCHWA
unicode_core_property(0x04DA, 0x04DA, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
unicode_core_property(0x04DC, 0x04DC, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
unicode_core_property(0x04DE, 0x04DE, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
unicode_core_property(0x04E0, 0x04E0, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ABKHASIAN DZE
unicode_core_property(0x04E2, 0x04E2, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER I WITH MACRON
unicode_core_property(0x04E4, 0x04E4, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER I WITH DIAERESIS
unicode_core_property(0x04E6, 0x04E6, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x04E8, 0x04E8, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BARRED O
unicode_core_property(0x04EA, 0x04EA, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
unicode_core_property(0x04EC, 0x04EC, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER E WITH DIAERESIS
unicode_core_property(0x04EE, 0x04EE, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER U WITH MACRON
unicode_core_property(0x04F0, 0x04F0, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER U WITH DIAERESIS
unicode_core_property(0x04F2, 0x04F2, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
unicode_core_property(0x04F4, 0x04F4, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
unicode_core_property(0x04F6, 0x04F6, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER GHE WITH DESCENDER
unicode_core_property(0x04F8, 0x04F8, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
unicode_core_property(0x04FA, 0x04FA, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK
unicode_core_property(0x04FC, 0x04FC, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER HA WITH HOOK
unicode_core_property(0x04FE, 0x04FE, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER HA WITH STROKE
unicode_core_property(0x0500, 0x0500, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI DE
unicode_core_property(0x0502, 0x0502, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI DJE
unicode_core_property(0x0504, 0x0504, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI ZJE
unicode_core_property(0x0506, 0x0506, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI DZJE
unicode_core_property(0x0508, 0x0508, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI LJE
unicode_core_property(0x050A, 0x050A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI NJE
unicode_core_property(0x050C, 0x050C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI SJE
unicode_core_property(0x050E, 0x050E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER KOMI TJE
unicode_core_property(0x0510, 0x0510, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER REVERSED ZE
unicode_core_property(0x0512, 0x0512, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EL WITH HOOK
unicode_core_property(0x0514, 0x0514, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER LHA
unicode_core_property(0x0516, 0x0516, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER RHA
unicode_core_property(0x0518, 0x0518, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER YAE
unicode_core_property(0x051A, 0x051A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER QA
unicode_core_property(0x051C, 0x051C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER WE
unicode_core_property(0x051E, 0x051E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ALEUT KA
unicode_core_property(0x0520, 0x0520, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK
unicode_core_property(0x0522, 0x0522, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK
unicode_core_property(0x0524, 0x0524, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER PE WITH DESCENDER
unicode_core_property(0x0526, 0x0526, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Changes_When_Casefolded').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0587, 0x0587, 'Changes_When_Casefolded').	% L&       ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x10A0, 0x10C5, 'Changes_When_Casefolded').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Changes_When_Casefolded').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Changes_When_Casefolded').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x1E00, 0x1E00, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH RING BELOW
unicode_core_property(0x1E02, 0x1E02, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER B WITH DOT ABOVE
unicode_core_property(0x1E04, 0x1E04, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER B WITH DOT BELOW
unicode_core_property(0x1E06, 0x1E06, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER B WITH LINE BELOW
unicode_core_property(0x1E08, 0x1E08, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
unicode_core_property(0x1E0A, 0x1E0A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH DOT ABOVE
unicode_core_property(0x1E0C, 0x1E0C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH DOT BELOW
unicode_core_property(0x1E0E, 0x1E0E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH LINE BELOW
unicode_core_property(0x1E10, 0x1E10, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH CEDILLA
unicode_core_property(0x1E12, 0x1E12, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E14, 0x1E14, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
unicode_core_property(0x1E16, 0x1E16, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
unicode_core_property(0x1E18, 0x1E18, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E1A, 0x1E1A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH TILDE BELOW
unicode_core_property(0x1E1C, 0x1E1C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
unicode_core_property(0x1E1E, 0x1E1E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER F WITH DOT ABOVE
unicode_core_property(0x1E20, 0x1E20, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH MACRON
unicode_core_property(0x1E22, 0x1E22, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH DOT ABOVE
unicode_core_property(0x1E24, 0x1E24, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH DOT BELOW
unicode_core_property(0x1E26, 0x1E26, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH DIAERESIS
unicode_core_property(0x1E28, 0x1E28, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH CEDILLA
unicode_core_property(0x1E2A, 0x1E2A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH BREVE BELOW
unicode_core_property(0x1E2C, 0x1E2C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH TILDE BELOW
unicode_core_property(0x1E2E, 0x1E2E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
unicode_core_property(0x1E30, 0x1E30, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH ACUTE
unicode_core_property(0x1E32, 0x1E32, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH DOT BELOW
unicode_core_property(0x1E34, 0x1E34, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH LINE BELOW
unicode_core_property(0x1E36, 0x1E36, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW
unicode_core_property(0x1E38, 0x1E38, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
unicode_core_property(0x1E3A, 0x1E3A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH LINE BELOW
unicode_core_property(0x1E3C, 0x1E3C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E3E, 0x1E3E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER M WITH ACUTE
unicode_core_property(0x1E40, 0x1E40, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER M WITH DOT ABOVE
unicode_core_property(0x1E42, 0x1E42, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER M WITH DOT BELOW
unicode_core_property(0x1E44, 0x1E44, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH DOT ABOVE
unicode_core_property(0x1E46, 0x1E46, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH DOT BELOW
unicode_core_property(0x1E48, 0x1E48, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH LINE BELOW
unicode_core_property(0x1E4A, 0x1E4A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E4C, 0x1E4C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
unicode_core_property(0x1E4E, 0x1E4E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
unicode_core_property(0x1E50, 0x1E50, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
unicode_core_property(0x1E52, 0x1E52, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
unicode_core_property(0x1E54, 0x1E54, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH ACUTE
unicode_core_property(0x1E56, 0x1E56, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH DOT ABOVE
unicode_core_property(0x1E58, 0x1E58, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH DOT ABOVE
unicode_core_property(0x1E5A, 0x1E5A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW
unicode_core_property(0x1E5C, 0x1E5C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
unicode_core_property(0x1E5E, 0x1E5E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH LINE BELOW
unicode_core_property(0x1E60, 0x1E60, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH DOT ABOVE
unicode_core_property(0x1E62, 0x1E62, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW
unicode_core_property(0x1E64, 0x1E64, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
unicode_core_property(0x1E66, 0x1E66, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
unicode_core_property(0x1E68, 0x1E68, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
unicode_core_property(0x1E6A, 0x1E6A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH DOT ABOVE
unicode_core_property(0x1E6C, 0x1E6C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH DOT BELOW
unicode_core_property(0x1E6E, 0x1E6E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH LINE BELOW
unicode_core_property(0x1E70, 0x1E70, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E72, 0x1E72, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
unicode_core_property(0x1E74, 0x1E74, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH TILDE BELOW
unicode_core_property(0x1E76, 0x1E76, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
unicode_core_property(0x1E78, 0x1E78, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
unicode_core_property(0x1E7A, 0x1E7A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
unicode_core_property(0x1E7C, 0x1E7C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER V WITH TILDE
unicode_core_property(0x1E7E, 0x1E7E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER V WITH DOT BELOW
unicode_core_property(0x1E80, 0x1E80, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH GRAVE
unicode_core_property(0x1E82, 0x1E82, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH ACUTE
unicode_core_property(0x1E84, 0x1E84, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH DIAERESIS
unicode_core_property(0x1E86, 0x1E86, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH DOT ABOVE
unicode_core_property(0x1E88, 0x1E88, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH DOT BELOW
unicode_core_property(0x1E8A, 0x1E8A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER X WITH DOT ABOVE
unicode_core_property(0x1E8C, 0x1E8C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER X WITH DIAERESIS
unicode_core_property(0x1E8E, 0x1E8E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH DOT ABOVE
unicode_core_property(0x1E90, 0x1E90, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
unicode_core_property(0x1E92, 0x1E92, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH DOT BELOW
unicode_core_property(0x1E94, 0x1E94, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH LINE BELOW
unicode_core_property(0x1E9A, 0x1E9B, 'Changes_When_Casefolded').	% L&   [2] LATIN SMALL LETTER A WITH RIGHT HALF RING..LATIN SMALL LETTER LONG S WITH DOT ABOVE
unicode_core_property(0x1E9E, 0x1E9E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER SHARP S
unicode_core_property(0x1EA0, 0x1EA0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH DOT BELOW
unicode_core_property(0x1EA2, 0x1EA2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH HOOK ABOVE
unicode_core_property(0x1EA4, 0x1EA4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EA6, 0x1EA6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EA8, 0x1EA8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EAA, 0x1EAA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EAC, 0x1EAC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EAE, 0x1EAE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
unicode_core_property(0x1EB0, 0x1EB0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
unicode_core_property(0x1EB2, 0x1EB2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
unicode_core_property(0x1EB4, 0x1EB4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND TILDE
unicode_core_property(0x1EB6, 0x1EB6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
unicode_core_property(0x1EB8, 0x1EB8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH DOT BELOW
unicode_core_property(0x1EBA, 0x1EBA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH HOOK ABOVE
unicode_core_property(0x1EBC, 0x1EBC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH TILDE
unicode_core_property(0x1EBE, 0x1EBE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1EC0, 0x1EC0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1EC2, 0x1EC2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1EC4, 0x1EC4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1EC6, 0x1EC6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EC8, 0x1EC8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH HOOK ABOVE
unicode_core_property(0x1ECA, 0x1ECA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER I WITH DOT BELOW
unicode_core_property(0x1ECC, 0x1ECC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH DOT BELOW
unicode_core_property(0x1ECE, 0x1ECE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HOOK ABOVE
unicode_core_property(0x1ED0, 0x1ED0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
unicode_core_property(0x1ED2, 0x1ED2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
unicode_core_property(0x1ED4, 0x1ED4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
unicode_core_property(0x1ED6, 0x1ED6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
unicode_core_property(0x1ED8, 0x1ED8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
unicode_core_property(0x1EDA, 0x1EDA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HORN AND ACUTE
unicode_core_property(0x1EDC, 0x1EDC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HORN AND GRAVE
unicode_core_property(0x1EDE, 0x1EDE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EE0, 0x1EE0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HORN AND TILDE
unicode_core_property(0x1EE2, 0x1EE2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
unicode_core_property(0x1EE4, 0x1EE4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH DOT BELOW
unicode_core_property(0x1EE6, 0x1EE6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HOOK ABOVE
unicode_core_property(0x1EE8, 0x1EE8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HORN AND ACUTE
unicode_core_property(0x1EEA, 0x1EEA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HORN AND GRAVE
unicode_core_property(0x1EEC, 0x1EEC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
unicode_core_property(0x1EEE, 0x1EEE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HORN AND TILDE
unicode_core_property(0x1EF0, 0x1EF0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
unicode_core_property(0x1EF2, 0x1EF2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH GRAVE
unicode_core_property(0x1EF4, 0x1EF4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH DOT BELOW
unicode_core_property(0x1EF6, 0x1EF6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH HOOK ABOVE
unicode_core_property(0x1EF8, 0x1EF8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH TILDE
unicode_core_property(0x1EFA, 0x1EFA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH LL
unicode_core_property(0x1EFC, 0x1EFC, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER MIDDLE-WELSH V
unicode_core_property(0x1EFE, 0x1EFE, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Y WITH LOOP
unicode_core_property(0x1F08, 0x1F0F, 'Changes_When_Casefolded').	% L&   [8] GREEK CAPITAL LETTER ALPHA WITH PSILI..GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F18, 0x1F1D, 'Changes_When_Casefolded').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F28, 0x1F2F, 'Changes_When_Casefolded').	% L&   [8] GREEK CAPITAL LETTER ETA WITH PSILI..GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F38, 0x1F3F, 'Changes_When_Casefolded').	% L&   [8] GREEK CAPITAL LETTER IOTA WITH PSILI..GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F48, 0x1F4D, 'Changes_When_Casefolded').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F59, 0x1F59, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F5F, 'Changes_When_Casefolded').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F68, 0x1F6F, 'Changes_When_Casefolded').	% L&   [8] GREEK CAPITAL LETTER OMEGA WITH PSILI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F80, 0x1FAF, 'Changes_When_Casefolded').	% L&  [48] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
unicode_core_property(0x1FB2, 0x1FB4, 'Changes_When_Casefolded').	% L&   [3] GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB7, 0x1FBC, 'Changes_When_Casefolded').	% L&   [6] GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Changes_When_Casefolded').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC7, 0x1FCC, 'Changes_When_Casefolded').	% L&   [6] GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD8, 0x1FDB, 'Changes_When_Casefolded').	% L&   [4] GREEK CAPITAL LETTER IOTA WITH VRACHY..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE8, 0x1FEC, 'Changes_When_Casefolded').	% L&   [5] GREEK CAPITAL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'Changes_When_Casefolded').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF7, 0x1FFC, 'Changes_When_Casefolded').	% L&   [6] GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2126, 0x2126, 'Changes_When_Casefolded').	% L&       OHM SIGN
unicode_core_property(0x212A, 0x212B, 'Changes_When_Casefolded').	% L&   [2] KELVIN SIGN..ANGSTROM SIGN
unicode_core_property(0x2132, 0x2132, 'Changes_When_Casefolded').	% L&       TURNED CAPITAL F
unicode_core_property(0x2160, 0x216F, 'Changes_When_Casefolded').	% Nl  [16] ROMAN NUMERAL ONE..ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2183, 0x2183, 'Changes_When_Casefolded').	% L&       ROMAN NUMERAL REVERSED ONE HUNDRED
unicode_core_property(0x24B6, 0x24CF, 'Changes_When_Casefolded').	% So  [26] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN CAPITAL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Changes_When_Casefolded').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C60, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH DOUBLE BAR
unicode_core_property(0x2C62, 0x2C64, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER L WITH MIDDLE TILDE..LATIN CAPITAL LETTER R WITH TAIL
unicode_core_property(0x2C67, 0x2C67, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH DESCENDER
unicode_core_property(0x2C69, 0x2C69, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH DESCENDER
unicode_core_property(0x2C6B, 0x2C6B, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Z WITH DESCENDER
unicode_core_property(0x2C6D, 0x2C70, 'Changes_When_Casefolded').	% L&   [4] LATIN CAPITAL LETTER ALPHA..LATIN CAPITAL LETTER TURNED ALPHA
unicode_core_property(0x2C72, 0x2C72, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER W WITH HOOK
unicode_core_property(0x2C75, 0x2C75, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER HALF H
unicode_core_property(0x2C7E, 0x2C80, 'Changes_When_Casefolded').	% L&   [3] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC CAPITAL LETTER ALFA
unicode_core_property(0x2C82, 0x2C82, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER VIDA
unicode_core_property(0x2C84, 0x2C84, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER GAMMA
unicode_core_property(0x2C86, 0x2C86, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DALDA
unicode_core_property(0x2C88, 0x2C88, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER EIE
unicode_core_property(0x2C8A, 0x2C8A, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER SOU
unicode_core_property(0x2C8C, 0x2C8C, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER ZATA
unicode_core_property(0x2C8E, 0x2C8E, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER HATE
unicode_core_property(0x2C90, 0x2C90, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER THETHE
unicode_core_property(0x2C92, 0x2C92, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER IAUDA
unicode_core_property(0x2C94, 0x2C94, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER KAPA
unicode_core_property(0x2C96, 0x2C96, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER LAULA
unicode_core_property(0x2C98, 0x2C98, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER MI
unicode_core_property(0x2C9A, 0x2C9A, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER NI
unicode_core_property(0x2C9C, 0x2C9C, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER KSI
unicode_core_property(0x2C9E, 0x2C9E, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER O
unicode_core_property(0x2CA0, 0x2CA0, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER PI
unicode_core_property(0x2CA2, 0x2CA2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER RO
unicode_core_property(0x2CA4, 0x2CA4, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER SIMA
unicode_core_property(0x2CA6, 0x2CA6, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER TAU
unicode_core_property(0x2CA8, 0x2CA8, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER UA
unicode_core_property(0x2CAA, 0x2CAA, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER FI
unicode_core_property(0x2CAC, 0x2CAC, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER KHI
unicode_core_property(0x2CAE, 0x2CAE, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER PSI
unicode_core_property(0x2CB0, 0x2CB0, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OOU
unicode_core_property(0x2CB2, 0x2CB2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DIALECT-P ALEF
unicode_core_property(0x2CB4, 0x2CB4, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC AIN
unicode_core_property(0x2CB6, 0x2CB6, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE
unicode_core_property(0x2CB8, 0x2CB8, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DIALECT-P KAPA
unicode_core_property(0x2CBA, 0x2CBA, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DIALECT-P NI
unicode_core_property(0x2CBC, 0x2CBC, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI
unicode_core_property(0x2CBE, 0x2CBE, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC OOU
unicode_core_property(0x2CC0, 0x2CC0, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER SAMPI
unicode_core_property(0x2CC2, 0x2CC2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER CROSSED SHEI
unicode_core_property(0x2CC4, 0x2CC4, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHEI
unicode_core_property(0x2CC6, 0x2CC6, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC ESH
unicode_core_property(0x2CC8, 0x2CC8, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER AKHMIMIC KHEI
unicode_core_property(0x2CCA, 0x2CCA, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER DIALECT-P HORI
unicode_core_property(0x2CCC, 0x2CCC, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HORI
unicode_core_property(0x2CCE, 0x2CCE, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HA
unicode_core_property(0x2CD0, 0x2CD0, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER L-SHAPED HA
unicode_core_property(0x2CD2, 0x2CD2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HEI
unicode_core_property(0x2CD4, 0x2CD4, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC HAT
unicode_core_property(0x2CD6, 0x2CD6, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC GANGIA
unicode_core_property(0x2CD8, 0x2CD8, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC DJA
unicode_core_property(0x2CDA, 0x2CDA, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD COPTIC SHIMA
unicode_core_property(0x2CDC, 0x2CDC, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN SHIMA
unicode_core_property(0x2CDE, 0x2CDE, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NGI
unicode_core_property(0x2CE0, 0x2CE0, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN NYI
unicode_core_property(0x2CE2, 0x2CE2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEB, 0x2CEB, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI
unicode_core_property(0x2CED, 0x2CED, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF2, 'Changes_When_Casefolded').	% L&       COPTIC CAPITAL LETTER BOHAIRIC KHEI
unicode_core_property(0xA640, 0xA640, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZEMLYA
unicode_core_property(0xA642, 0xA642, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DZELO
unicode_core_property(0xA644, 0xA644, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER REVERSED DZE
unicode_core_property(0xA646, 0xA646, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTA
unicode_core_property(0xA648, 0xA648, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DJERV
unicode_core_property(0xA64A, 0xA64A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER MONOGRAPH UK
unicode_core_property(0xA64C, 0xA64C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BROAD OMEGA
unicode_core_property(0xA64E, 0xA64E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER NEUTRAL YER
unicode_core_property(0xA650, 0xA650, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER YERU WITH BACK YER
unicode_core_property(0xA652, 0xA652, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED YAT
unicode_core_property(0xA654, 0xA654, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER REVERSED YU
unicode_core_property(0xA656, 0xA656, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED A
unicode_core_property(0xA658, 0xA658, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS
unicode_core_property(0xA65A, 0xA65A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BLENDED YUS
unicode_core_property(0xA65C, 0xA65C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS
unicode_core_property(0xA65E, 0xA65E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER YN
unicode_core_property(0xA660, 0xA660, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER REVERSED TSE
unicode_core_property(0xA662, 0xA662, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SOFT DE
unicode_core_property(0xA664, 0xA664, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SOFT EL
unicode_core_property(0xA666, 0xA666, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SOFT EM
unicode_core_property(0xA668, 0xA668, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER MONOCULAR O
unicode_core_property(0xA66A, 0xA66A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER BINOCULAR O
unicode_core_property(0xA66C, 0xA66C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA680, 0xA680, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DWE
unicode_core_property(0xA682, 0xA682, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DZWE
unicode_core_property(0xA684, 0xA684, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER ZHWE
unicode_core_property(0xA686, 0xA686, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER CCHE
unicode_core_property(0xA688, 0xA688, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER DZZE
unicode_core_property(0xA68A, 0xA68A, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK
unicode_core_property(0xA68C, 0xA68C, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TWE
unicode_core_property(0xA68E, 0xA68E, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TSWE
unicode_core_property(0xA690, 0xA690, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TSSE
unicode_core_property(0xA692, 0xA692, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER TCHE
unicode_core_property(0xA694, 0xA694, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER HWE
unicode_core_property(0xA696, 0xA696, 'Changes_When_Casefolded').	% L&       CYRILLIC CAPITAL LETTER SHWE
unicode_core_property(0xA722, 0xA722, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF
unicode_core_property(0xA724, 0xA724, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER EGYPTOLOGICAL AIN
unicode_core_property(0xA726, 0xA726, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER HENG
unicode_core_property(0xA728, 0xA728, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TZ
unicode_core_property(0xA72A, 0xA72A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TRESILLO
unicode_core_property(0xA72C, 0xA72C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER CUATRILLO
unicode_core_property(0xA72E, 0xA72E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA732, 0xA732, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AA
unicode_core_property(0xA734, 0xA734, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AO
unicode_core_property(0xA736, 0xA736, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AU
unicode_core_property(0xA738, 0xA738, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AV
unicode_core_property(0xA73A, 0xA73A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR
unicode_core_property(0xA73C, 0xA73C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER AY
unicode_core_property(0xA73E, 0xA73E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER REVERSED C WITH DOT
unicode_core_property(0xA740, 0xA740, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH STROKE
unicode_core_property(0xA742, 0xA742, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH DIAGONAL STROKE
unicode_core_property(0xA744, 0xA744, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE
unicode_core_property(0xA746, 0xA746, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER BROKEN L
unicode_core_property(0xA748, 0xA748, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER L WITH HIGH STROKE
unicode_core_property(0xA74A, 0xA74A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY
unicode_core_property(0xA74C, 0xA74C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER O WITH LOOP
unicode_core_property(0xA74E, 0xA74E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER OO
unicode_core_property(0xA750, 0xA750, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA752, 0xA752, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH FLOURISH
unicode_core_property(0xA754, 0xA754, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER P WITH SQUIRREL TAIL
unicode_core_property(0xA756, 0xA756, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA758, 0xA758, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE
unicode_core_property(0xA75A, 0xA75A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R ROTUNDA
unicode_core_property(0xA75C, 0xA75C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER RUM ROTUNDA
unicode_core_property(0xA75E, 0xA75E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER V WITH DIAGONAL STROKE
unicode_core_property(0xA760, 0xA760, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER VY
unicode_core_property(0xA762, 0xA762, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER VISIGOTHIC Z
unicode_core_property(0xA764, 0xA764, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE
unicode_core_property(0xA766, 0xA766, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER
unicode_core_property(0xA768, 0xA768, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER VEND
unicode_core_property(0xA76A, 0xA76A, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER ET
unicode_core_property(0xA76C, 0xA76C, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER IS
unicode_core_property(0xA76E, 0xA76E, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER CON
unicode_core_property(0xA779, 0xA779, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER INSULAR D
unicode_core_property(0xA77B, 0xA77B, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER INSULAR F
unicode_core_property(0xA77D, 0xA77E, 'Changes_When_Casefolded').	% L&   [2] LATIN CAPITAL LETTER INSULAR G..LATIN CAPITAL LETTER TURNED INSULAR G
unicode_core_property(0xA780, 0xA780, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TURNED L
unicode_core_property(0xA782, 0xA782, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER INSULAR R
unicode_core_property(0xA784, 0xA784, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER INSULAR S
unicode_core_property(0xA786, 0xA786, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER INSULAR T
unicode_core_property(0xA78B, 0xA78B, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER SALTILLO
unicode_core_property(0xA78D, 0xA78D, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER TURNED H
unicode_core_property(0xA790, 0xA790, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH DESCENDER
unicode_core_property(0xA792, 0xA792, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7A0, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER G WITH OBLIQUE STROKE
unicode_core_property(0xA7A2, 0xA7A2, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER K WITH OBLIQUE STROKE
unicode_core_property(0xA7A4, 0xA7A4, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER N WITH OBLIQUE STROKE
unicode_core_property(0xA7A6, 0xA7A6, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER R WITH OBLIQUE STROKE
unicode_core_property(0xA7A8, 0xA7A8, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER S WITH OBLIQUE STROKE
unicode_core_property(0xA7AA, 0xA7AA, 'Changes_When_Casefolded').	% L&       LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xFB00, 0xFB06, 'Changes_When_Casefolded').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Changes_When_Casefolded').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF21, 0xFF3A, 'Changes_When_Casefolded').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0x10400, 0x10427, 'Changes_When_Casefolded').	% L&  [40] DESERET CAPITAL LETTER LONG I..DESERET CAPITAL LETTER EW

% Total code points: 1107

% ================================================

% Derived Property:   Changes_When_Casemapped (CWCM)
%  Characters whose normalized forms are not stable under case mapping.
%  For more information, see D128 in Section 3.13, "Default Case Algorithms".
%  Changes_When_Casemapped(X) is true when CWL(X), or CWT(X), or CWU(X)

unicode_core_property(0x0041, 0x005A, 'Changes_When_Casemapped').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x0061, 0x007A, 'Changes_When_Casemapped').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00B5, 0x00B5, 'Changes_When_Casemapped').	% L&       MICRO SIGN
unicode_core_property(0x00C0, 0x00D6, 'Changes_When_Casemapped').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'Changes_When_Casemapped').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x0137, 'Changes_When_Casemapped').	% L&  [64] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER K WITH CEDILLA
unicode_core_property(0x0139, 0x018C, 'Changes_When_Casemapped').	% L&  [84] LATIN CAPITAL LETTER L WITH ACUTE..LATIN SMALL LETTER D WITH TOPBAR
unicode_core_property(0x018E, 0x019A, 'Changes_When_Casemapped').	% L&  [13] LATIN CAPITAL LETTER REVERSED E..LATIN SMALL LETTER L WITH BAR
unicode_core_property(0x019C, 0x01A9, 'Changes_When_Casemapped').	% L&  [14] LATIN CAPITAL LETTER TURNED M..LATIN CAPITAL LETTER ESH
unicode_core_property(0x01AC, 0x01B9, 'Changes_When_Casemapped').	% L&  [14] LATIN CAPITAL LETTER T WITH HOOK..LATIN SMALL LETTER EZH REVERSED
unicode_core_property(0x01BC, 0x01BD, 'Changes_When_Casemapped').	% L&   [2] LATIN CAPITAL LETTER TONE FIVE..LATIN SMALL LETTER TONE FIVE
unicode_core_property(0x01BF, 0x01BF, 'Changes_When_Casemapped').	% L&       LATIN LETTER WYNN
unicode_core_property(0x01C4, 0x0220, 'Changes_When_Casemapped').	% L&  [93] LATIN CAPITAL LETTER DZ WITH CARON..LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
unicode_core_property(0x0222, 0x0233, 'Changes_When_Casemapped').	% L&  [18] LATIN CAPITAL LETTER OU..LATIN SMALL LETTER Y WITH MACRON
unicode_core_property(0x023A, 0x0254, 'Changes_When_Casemapped').	% L&  [27] LATIN CAPITAL LETTER A WITH STROKE..LATIN SMALL LETTER OPEN O
unicode_core_property(0x0256, 0x0257, 'Changes_When_Casemapped').	% L&   [2] LATIN SMALL LETTER D WITH TAIL..LATIN SMALL LETTER D WITH HOOK
unicode_core_property(0x0259, 0x0259, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER SCHWA
unicode_core_property(0x025B, 0x025B, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER OPEN E
unicode_core_property(0x0260, 0x0260, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER G WITH HOOK
unicode_core_property(0x0263, 0x0263, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER GAMMA
unicode_core_property(0x0265, 0x0266, 'Changes_When_Casemapped').	% L&   [2] LATIN SMALL LETTER TURNED H..LATIN SMALL LETTER H WITH HOOK
unicode_core_property(0x0268, 0x0269, 'Changes_When_Casemapped').	% L&   [2] LATIN SMALL LETTER I WITH STROKE..LATIN SMALL LETTER IOTA
unicode_core_property(0x026B, 0x026B, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER L WITH MIDDLE TILDE
unicode_core_property(0x026F, 0x026F, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER TURNED M
unicode_core_property(0x0271, 0x0272, 'Changes_When_Casemapped').	% L&   [2] LATIN SMALL LETTER M WITH HOOK..LATIN SMALL LETTER N WITH LEFT HOOK
unicode_core_property(0x0275, 0x0275, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER BARRED O
unicode_core_property(0x027D, 0x027D, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER R WITH TAIL
unicode_core_property(0x0280, 0x0280, 'Changes_When_Casemapped').	% L&       LATIN LETTER SMALL CAPITAL R
unicode_core_property(0x0283, 0x0283, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER ESH
unicode_core_property(0x0288, 0x028C, 'Changes_When_Casemapped').	% L&   [5] LATIN SMALL LETTER T WITH RETROFLEX HOOK..LATIN SMALL LETTER TURNED V
unicode_core_property(0x0292, 0x0292, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER EZH
unicode_core_property(0x0345, 0x0345, 'Changes_When_Casemapped').	% Mn       COMBINING GREEK YPOGEGRAMMENI
unicode_core_property(0x0370, 0x0373, 'Changes_When_Casemapped').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0376, 0x0377, 'Changes_When_Casemapped').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037B, 0x037D, 'Changes_When_Casemapped').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'Changes_When_Casemapped').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'Changes_When_Casemapped').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Changes_When_Casemapped').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'Changes_When_Casemapped').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03D1, 'Changes_When_Casemapped').	% L&  [47] GREEK CAPITAL LETTER SIGMA..GREEK THETA SYMBOL
unicode_core_property(0x03D5, 0x03F2, 'Changes_When_Casemapped').	% L&  [30] GREEK PHI SYMBOL..GREEK LUNATE SIGMA SYMBOL
unicode_core_property(0x03F4, 0x03F5, 'Changes_When_Casemapped').	% L&   [2] GREEK CAPITAL THETA SYMBOL..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x03FB, 'Changes_When_Casemapped').	% L&   [5] GREEK CAPITAL LETTER SHO..GREEK SMALL LETTER SAN
unicode_core_property(0x03FD, 0x0481, 'Changes_When_Casemapped').	% L& [133] GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048A, 0x0527, 'Changes_When_Casemapped').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Changes_When_Casemapped').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0561, 0x0587, 'Changes_When_Casemapped').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x10A0, 0x10C5, 'Changes_When_Casemapped').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Changes_When_Casemapped').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Changes_When_Casemapped').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x1D79, 0x1D79, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER INSULAR G
unicode_core_property(0x1D7D, 0x1D7D, 'Changes_When_Casemapped').	% L&       LATIN SMALL LETTER P WITH STROKE
unicode_core_property(0x1E00, 0x1E9B, 'Changes_When_Casemapped').	% L& [156] LATIN CAPITAL LETTER A WITH RING BELOW..LATIN SMALL LETTER LONG S WITH DOT ABOVE
unicode_core_property(0x1E9E, 0x1E9E, 'Changes_When_Casemapped').	% L&       LATIN CAPITAL LETTER SHARP S
unicode_core_property(0x1EA0, 0x1F15, 'Changes_When_Casemapped').	% L& [118] LATIN CAPITAL LETTER A WITH DOT BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'Changes_When_Casemapped').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'Changes_When_Casemapped').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'Changes_When_Casemapped').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'Changes_When_Casemapped').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'Changes_When_Casemapped').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'Changes_When_Casemapped').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'Changes_When_Casemapped').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'Changes_When_Casemapped').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'Changes_When_Casemapped').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'Changes_When_Casemapped').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'Changes_When_Casemapped').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'Changes_When_Casemapped').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'Changes_When_Casemapped').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'Changes_When_Casemapped').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'Changes_When_Casemapped').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'Changes_When_Casemapped').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'Changes_When_Casemapped').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'Changes_When_Casemapped').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2126, 0x2126, 'Changes_When_Casemapped').	% L&       OHM SIGN
unicode_core_property(0x212A, 0x212B, 'Changes_When_Casemapped').	% L&   [2] KELVIN SIGN..ANGSTROM SIGN
unicode_core_property(0x2132, 0x2132, 'Changes_When_Casemapped').	% L&       TURNED CAPITAL F
unicode_core_property(0x214E, 0x214E, 'Changes_When_Casemapped').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x217F, 'Changes_When_Casemapped').	% Nl  [32] ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL ONE THOUSAND
unicode_core_property(0x2183, 0x2184, 'Changes_When_Casemapped').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x24B6, 0x24E9, 'Changes_When_Casemapped').	% So  [52] CIRCLED LATIN CAPITAL LETTER A..CIRCLED LATIN SMALL LETTER Z
unicode_core_property(0x2C00, 0x2C2E, 'Changes_When_Casemapped').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'Changes_When_Casemapped').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C70, 'Changes_When_Casemapped').	% L&  [17] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN CAPITAL LETTER TURNED ALPHA
unicode_core_property(0x2C72, 0x2C73, 'Changes_When_Casemapped').	% L&   [2] LATIN CAPITAL LETTER W WITH HOOK..LATIN SMALL LETTER W WITH HOOK
unicode_core_property(0x2C75, 0x2C76, 'Changes_When_Casemapped').	% L&   [2] LATIN CAPITAL LETTER HALF H..LATIN SMALL LETTER HALF H
unicode_core_property(0x2C7E, 0x2CE3, 'Changes_When_Casemapped').	% L& [102] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SMALL LETTER OLD NUBIAN WAU
unicode_core_property(0x2CEB, 0x2CEE, 'Changes_When_Casemapped').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF3, 'Changes_When_Casemapped').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'Changes_When_Casemapped').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'Changes_When_Casemapped').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'Changes_When_Casemapped').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0xA640, 0xA66D, 'Changes_When_Casemapped').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA680, 0xA697, 'Changes_When_Casemapped').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA722, 0xA72F, 'Changes_When_Casemapped').	% L&  [14] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CUATRILLO WITH COMMA
unicode_core_property(0xA732, 0xA76F, 'Changes_When_Casemapped').	% L&  [62] LATIN CAPITAL LETTER AA..LATIN SMALL LETTER CON
unicode_core_property(0xA779, 0xA787, 'Changes_When_Casemapped').	% L&  [15] LATIN CAPITAL LETTER INSULAR D..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA78B, 0xA78D, 'Changes_When_Casemapped').	% L&   [3] LATIN CAPITAL LETTER SALTILLO..LATIN CAPITAL LETTER TURNED H
unicode_core_property(0xA790, 0xA793, 'Changes_When_Casemapped').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'Changes_When_Casemapped').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xFB00, 0xFB06, 'Changes_When_Casemapped').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'Changes_When_Casemapped').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFF21, 0xFF3A, 'Changes_When_Casemapped').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF41, 0xFF5A, 'Changes_When_Casemapped').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0x10400, 0x1044F, 'Changes_When_Casemapped').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW

% Total code points: 2138

% ================================================

% Derived Property: ID_Start
%  Characters that can start an identifier.
%  Generated from:
%      Lu + Ll + Lt + Lm + Lo + Nl
%    + Other_ID_Start
%    - Pattern_Syntax
%    - Pattern_White_Space
%  NOTE: See UAX #31 for more information

unicode_core_property(0x0041, 0x005A, 'ID_Start').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x0061, 0x007A, 'ID_Start').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'ID_Start').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'ID_Start').	% L&       MICRO SIGN
unicode_core_property(0x00BA, 0x00BA, 'ID_Start').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'ID_Start').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'ID_Start').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'ID_Start').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'ID_Start').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'ID_Start').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'ID_Start').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'ID_Start').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'ID_Start').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'ID_Start').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'ID_Start').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C6, 0x02D1, 'ID_Start').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02E0, 0x02E4, 'ID_Start').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02EC, 0x02EC, 'ID_Start').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02EE, 0x02EE, 'ID_Start').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x0370, 0x0373, 'ID_Start').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'ID_Start').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'ID_Start').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'ID_Start').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'ID_Start').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'ID_Start').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'ID_Start').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'ID_Start').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'ID_Start').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'ID_Start').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'ID_Start').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048A, 0x0527, 'ID_Start').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'ID_Start').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'ID_Start').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0561, 0x0587, 'ID_Start').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x05D0, 0x05EA, 'ID_Start').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'ID_Start').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x0620, 0x063F, 'ID_Start').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'ID_Start').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'ID_Start').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x066E, 0x066F, 'ID_Start').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0671, 0x06D3, 'ID_Start').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D5, 0x06D5, 'ID_Start').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06E5, 0x06E6, 'ID_Start').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06EE, 0x06EF, 'ID_Start').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06FA, 0x06FC, 'ID_Start').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FF, 0x06FF, 'ID_Start').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0710, 0x0710, 'ID_Start').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0712, 0x072F, 'ID_Start').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x074D, 0x07A5, 'ID_Start').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07B1, 0x07B1, 'ID_Start').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07CA, 0x07EA, 'ID_Start').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07F4, 0x07F5, 'ID_Start').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'ID_Start').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'ID_Start').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x081A, 0x081A, 'ID_Start').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x0824, 0x0824, 'ID_Start').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0828, 0x0828, 'ID_Start').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0840, 0x0858, 'ID_Start').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x08A0, 0x08A0, 'ID_Start').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'ID_Start').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x0904, 0x0939, 'ID_Start').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093D, 0x093D, 'ID_Start').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x0950, 0x0950, 'ID_Start').	% Lo       DEVANAGARI OM
unicode_core_property(0x0958, 0x0961, 'ID_Start').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0971, 0x0971, 'ID_Start').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'ID_Start').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'ID_Start').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0985, 0x098C, 'ID_Start').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'ID_Start').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'ID_Start').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'ID_Start').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'ID_Start').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'ID_Start').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BD, 0x09BD, 'ID_Start').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09CE, 0x09CE, 'ID_Start').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09DC, 0x09DD, 'ID_Start').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'ID_Start').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09F0, 0x09F1, 'ID_Start').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x0A05, 0x0A0A, 'ID_Start').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'ID_Start').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'ID_Start').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'ID_Start').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'ID_Start').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'ID_Start').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'ID_Start').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A59, 0x0A5C, 'ID_Start').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'ID_Start').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A72, 0x0A74, 'ID_Start').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A85, 0x0A8D, 'ID_Start').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'ID_Start').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'ID_Start').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'ID_Start').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'ID_Start').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'ID_Start').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABD, 0x0ABD, 'ID_Start').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0AD0, 0x0AD0, 'ID_Start').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'ID_Start').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0B05, 0x0B0C, 'ID_Start').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'ID_Start').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'ID_Start').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'ID_Start').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'ID_Start').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'ID_Start').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3D, 0x0B3D, 'ID_Start').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B5C, 0x0B5D, 'ID_Start').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'ID_Start').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B71, 0x0B71, 'ID_Start').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B83, 0x0B83, 'ID_Start').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'ID_Start').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'ID_Start').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'ID_Start').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'ID_Start').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'ID_Start').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'ID_Start').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'ID_Start').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'ID_Start').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'ID_Start').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BD0, 0x0BD0, 'ID_Start').	% Lo       TAMIL OM
unicode_core_property(0x0C05, 0x0C0C, 'ID_Start').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'ID_Start').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'ID_Start').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'ID_Start').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'ID_Start').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'ID_Start').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C58, 0x0C59, 'ID_Start').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'ID_Start').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C85, 0x0C8C, 'ID_Start').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'ID_Start').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'ID_Start').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'ID_Start').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'ID_Start').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBD, 0x0CBD, 'ID_Start').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CDE, 0x0CDE, 'ID_Start').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'ID_Start').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CF1, 0x0CF2, 'ID_Start').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D05, 0x0D0C, 'ID_Start').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'ID_Start').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'ID_Start').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'ID_Start').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D4E, 0x0D4E, 'ID_Start').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D60, 0x0D61, 'ID_Start').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D7A, 0x0D7F, 'ID_Start').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D85, 0x0D96, 'ID_Start').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'ID_Start').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'ID_Start').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'ID_Start').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'ID_Start').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0E01, 0x0E30, 'ID_Start').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E32, 0x0E33, 'ID_Start').	% Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_core_property(0x0E40, 0x0E45, 'ID_Start').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'ID_Start').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E81, 0x0E82, 'ID_Start').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'ID_Start').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'ID_Start').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'ID_Start').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'ID_Start').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'ID_Start').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'ID_Start').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'ID_Start').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'ID_Start').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'ID_Start').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'ID_Start').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'ID_Start').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB2, 0x0EB3, 'ID_Start').	% Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_core_property(0x0EBD, 0x0EBD, 'ID_Start').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'ID_Start').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'ID_Start').	% Lm       LAO KO LA
unicode_core_property(0x0EDC, 0x0EDF, 'ID_Start').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'ID_Start').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F40, 0x0F47, 'ID_Start').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'ID_Start').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F88, 0x0F8C, 'ID_Start').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x1000, 0x102A, 'ID_Start').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x103F, 0x103F, 'ID_Start').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1050, 0x1055, 'ID_Start').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x105A, 0x105D, 'ID_Start').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x1061, 0x1061, 'ID_Start').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1065, 0x1066, 'ID_Start').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x106E, 0x1070, 'ID_Start').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1075, 0x1081, 'ID_Start').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x108E, 0x108E, 'ID_Start').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x10A0, 0x10C5, 'ID_Start').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'ID_Start').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'ID_Start').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'ID_Start').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FC, 0x10FC, 'ID_Start').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'ID_Start').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'ID_Start').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'ID_Start').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'ID_Start').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'ID_Start').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'ID_Start').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'ID_Start').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'ID_Start').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'ID_Start').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x1380, 0x138F, 'ID_Start').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x13A0, 0x13F4, 'ID_Start').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1401, 0x166C, 'ID_Start').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166F, 0x167F, 'ID_Start').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1681, 0x169A, 'ID_Start').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x16A0, 0x16EA, 'ID_Start').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EE, 0x16F0, 'ID_Start').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'ID_Start').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'ID_Start').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1720, 0x1731, 'ID_Start').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1740, 0x1751, 'ID_Start').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1760, 0x176C, 'ID_Start').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'ID_Start').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1780, 0x17B3, 'ID_Start').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17D7, 0x17D7, 'ID_Start').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DC, 0x17DC, 'ID_Start').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x1820, 0x1842, 'ID_Start').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'ID_Start').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'ID_Start').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'ID_Start').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18AA, 0x18AA, 'ID_Start').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'ID_Start').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'ID_Start').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1950, 0x196D, 'ID_Start').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'ID_Start').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'ID_Start').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19C1, 0x19C7, 'ID_Start').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x1A00, 0x1A16, 'ID_Start').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A20, 0x1A54, 'ID_Start').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1AA7, 0x1AA7, 'ID_Start').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B05, 0x1B33, 'ID_Start').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B45, 0x1B4B, 'ID_Start').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B83, 0x1BA0, 'ID_Start').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BAE, 0x1BAF, 'ID_Start').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BBA, 0x1BE5, 'ID_Start').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1C00, 0x1C23, 'ID_Start').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C4D, 0x1C4F, 'ID_Start').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C5A, 0x1C77, 'ID_Start').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'ID_Start').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CE9, 0x1CEC, 'ID_Start').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_core_property(0x1CEE, 0x1CF1, 'ID_Start').	% Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_core_property(0x1CF5, 0x1CF6, 'ID_Start').	% Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_core_property(0x1D00, 0x1D2B, 'ID_Start').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'ID_Start').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'ID_Start').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'ID_Start').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'ID_Start').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'ID_Start').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1E00, 0x1F15, 'ID_Start').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'ID_Start').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'ID_Start').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'ID_Start').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'ID_Start').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'ID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'ID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'ID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'ID_Start').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'ID_Start').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'ID_Start').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'ID_Start').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'ID_Start').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'ID_Start').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'ID_Start').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'ID_Start').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'ID_Start').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'ID_Start').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'ID_Start').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2071, 0x2071, 'ID_Start').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'ID_Start').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'ID_Start').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x2102, 0x2102, 'ID_Start').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'ID_Start').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'ID_Start').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'ID_Start').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2118, 0x2118, 'ID_Start').	% Sm       SCRIPT CAPITAL P
unicode_core_property(0x2119, 0x211D, 'ID_Start').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'ID_Start').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'ID_Start').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'ID_Start').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'ID_Start').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212E, 0x212E, 'ID_Start').	% So       ESTIMATED SYMBOL
unicode_core_property(0x212F, 0x2134, 'ID_Start').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'ID_Start').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x2139, 0x2139, 'ID_Start').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'ID_Start').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'ID_Start').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'ID_Start').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x2182, 'ID_Start').	% Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_core_property(0x2183, 0x2184, 'ID_Start').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x2185, 0x2188, 'ID_Start').	% Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_core_property(0x2C00, 0x2C2E, 'ID_Start').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'ID_Start').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'ID_Start').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'ID_Start').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'ID_Start').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'ID_Start').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF3, 'ID_Start').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'ID_Start').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'ID_Start').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'ID_Start').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0x2D30, 0x2D67, 'ID_Start').	% Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_core_property(0x2D6F, 0x2D6F, 'ID_Start').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D80, 0x2D96, 'ID_Start').	% Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_core_property(0x2DA0, 0x2DA6, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_core_property(0x2DA8, 0x2DAE, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_core_property(0x2DB0, 0x2DB6, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_core_property(0x2DB8, 0x2DBE, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_core_property(0x2DC0, 0x2DC6, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_core_property(0x2DC8, 0x2DCE, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_core_property(0x2DD0, 0x2DD6, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_core_property(0x2DD8, 0x2DDE, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_core_property(0x3005, 0x3005, 'ID_Start').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3006, 0x3006, 'ID_Start').	% Lo       IDEOGRAPHIC CLOSING MARK
unicode_core_property(0x3007, 0x3007, 'ID_Start').	% Nl       IDEOGRAPHIC NUMBER ZERO
unicode_core_property(0x3021, 0x3029, 'ID_Start').	% Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_core_property(0x3031, 0x3035, 'ID_Start').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x3038, 0x303A, 'ID_Start').	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_core_property(0x303B, 0x303B, 'ID_Start').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x303C, 0x303C, 'ID_Start').	% Lo       MASU MARK
unicode_core_property(0x3041, 0x3096, 'ID_Start').	% Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_core_property(0x309B, 0x309C, 'ID_Start').	% Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309D, 0x309E, 'ID_Start').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x309F, 0x309F, 'ID_Start').	% Lo       HIRAGANA DIGRAPH YORI
unicode_core_property(0x30A1, 0x30FA, 'ID_Start').	% Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_core_property(0x30FC, 0x30FE, 'ID_Start').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0x30FF, 0x30FF, 'ID_Start').	% Lo       KATAKANA DIGRAPH KOTO
unicode_core_property(0x3105, 0x312D, 'ID_Start').	% Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_core_property(0x3131, 0x318E, 'ID_Start').	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_core_property(0x31A0, 0x31BA, 'ID_Start').	% Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_core_property(0x31F0, 0x31FF, 'ID_Start').	% Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_core_property(0x3400, 0x4DB5, 'ID_Start').	% Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_core_property(0x4E00, 0x9FCC, 'ID_Start').	% Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_core_property(0xA000, 0xA014, 'ID_Start').	% Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_core_property(0xA015, 0xA015, 'ID_Start').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA016, 0xA48C, 'ID_Start').	% Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_core_property(0xA4D0, 0xA4F7, 'ID_Start').	% Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_core_property(0xA4F8, 0xA4FD, 'ID_Start').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA500, 0xA60B, 'ID_Start').	% Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_core_property(0xA60C, 0xA60C, 'ID_Start').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA610, 0xA61F, 'ID_Start').	% Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_core_property(0xA62A, 0xA62B, 'ID_Start').	% Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_core_property(0xA640, 0xA66D, 'ID_Start').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA66E, 0xA66E, 'ID_Start').	% Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_core_property(0xA67F, 0xA67F, 'ID_Start').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA680, 0xA697, 'ID_Start').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA6A0, 0xA6E5, 'ID_Start').	% Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_core_property(0xA6E6, 0xA6EF, 'ID_Start').	% Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_core_property(0xA717, 0xA71F, 'ID_Start').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA722, 0xA76F, 'ID_Start').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'ID_Start').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'ID_Start').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA788, 0xA788, 'ID_Start').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA78B, 0xA78E, 'ID_Start').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'ID_Start').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'ID_Start').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'ID_Start').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'ID_Start').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xA7FB, 0xA801, 'ID_Start').	% Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_core_property(0xA803, 0xA805, 'ID_Start').	% Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_core_property(0xA807, 0xA80A, 'ID_Start').	% Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_core_property(0xA80C, 0xA822, 'ID_Start').	% Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_core_property(0xA840, 0xA873, 'ID_Start').	% Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_core_property(0xA882, 0xA8B3, 'ID_Start').	% Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_core_property(0xA8F2, 0xA8F7, 'ID_Start').	% Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_core_property(0xA8FB, 0xA8FB, 'ID_Start').	% Lo       DEVANAGARI HEADSTROKE
unicode_core_property(0xA90A, 0xA925, 'ID_Start').	% Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_core_property(0xA930, 0xA946, 'ID_Start').	% Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_core_property(0xA960, 0xA97C, 'ID_Start').	% Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_core_property(0xA984, 0xA9B2, 'ID_Start').	% Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_core_property(0xA9CF, 0xA9CF, 'ID_Start').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xAA00, 0xAA28, 'ID_Start').	% Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_core_property(0xAA40, 0xAA42, 'ID_Start').	% Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_core_property(0xAA44, 0xAA4B, 'ID_Start').	% Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_core_property(0xAA60, 0xAA6F, 'ID_Start').	% Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_core_property(0xAA70, 0xAA70, 'ID_Start').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAA71, 0xAA76, 'ID_Start').	% Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_core_property(0xAA7A, 0xAA7A, 'ID_Start').	% Lo       MYANMAR LETTER AITON RA
unicode_core_property(0xAA80, 0xAAAF, 'ID_Start').	% Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_core_property(0xAAB1, 0xAAB1, 'ID_Start').	% Lo       TAI VIET VOWEL AA
unicode_core_property(0xAAB5, 0xAAB6, 'ID_Start').	% Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_core_property(0xAAB9, 0xAABD, 'ID_Start').	% Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_core_property(0xAAC0, 0xAAC0, 'ID_Start').	% Lo       TAI VIET TONE MAI NUENG
unicode_core_property(0xAAC2, 0xAAC2, 'ID_Start').	% Lo       TAI VIET TONE MAI SONG
unicode_core_property(0xAADB, 0xAADC, 'ID_Start').	% Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_core_property(0xAADD, 0xAADD, 'ID_Start').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAE0, 0xAAEA, 'ID_Start').	% Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_core_property(0xAAF2, 0xAAF2, 'ID_Start').	% Lo       MEETEI MAYEK ANJI
unicode_core_property(0xAAF3, 0xAAF4, 'ID_Start').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAB01, 0xAB06, 'ID_Start').	% Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_core_property(0xAB09, 0xAB0E, 'ID_Start').	% Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_core_property(0xAB11, 0xAB16, 'ID_Start').	% Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_core_property(0xAB20, 0xAB26, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_core_property(0xAB28, 0xAB2E, 'ID_Start').	% Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_core_property(0xABC0, 0xABE2, 'ID_Start').	% Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_core_property(0xAC00, 0xD7A3, 'ID_Start').	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_core_property(0xD7B0, 0xD7C6, 'ID_Start').	% Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_core_property(0xD7CB, 0xD7FB, 'ID_Start').	% Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_core_property(0xF900, 0xFA6D, 'ID_Start').	% Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_core_property(0xFA70, 0xFAD9, 'ID_Start').	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_core_property(0xFB00, 0xFB06, 'ID_Start').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'ID_Start').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFB1D, 0xFB1D, 'ID_Start').	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_core_property(0xFB1F, 0xFB28, 'ID_Start').	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_core_property(0xFB2A, 0xFB36, 'ID_Start').	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_core_property(0xFB38, 0xFB3C, 'ID_Start').	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_core_property(0xFB3E, 0xFB3E, 'ID_Start').	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_core_property(0xFB40, 0xFB41, 'ID_Start').	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_core_property(0xFB43, 0xFB44, 'ID_Start').	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_core_property(0xFB46, 0xFBB1, 'ID_Start').	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_core_property(0xFBD3, 0xFD3D, 'ID_Start').	% Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_core_property(0xFD50, 0xFD8F, 'ID_Start').	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_core_property(0xFD92, 0xFDC7, 'ID_Start').	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_core_property(0xFDF0, 0xFDFB, 'ID_Start').	% Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
unicode_core_property(0xFE70, 0xFE74, 'ID_Start').	% Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
unicode_core_property(0xFE76, 0xFEFC, 'ID_Start').	% Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_core_property(0xFF21, 0xFF3A, 'ID_Start').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF41, 0xFF5A, 'ID_Start').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0xFF66, 0xFF6F, 'ID_Start').	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_core_property(0xFF70, 0xFF70, 'ID_Start').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF71, 0xFF9D, 'ID_Start').	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_core_property(0xFF9E, 0xFF9F, 'ID_Start').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0xFFA0, 0xFFBE, 'ID_Start').	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_core_property(0xFFC2, 0xFFC7, 'ID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_core_property(0xFFCA, 0xFFCF, 'ID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_core_property(0xFFD2, 0xFFD7, 'ID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_core_property(0xFFDA, 0xFFDC, 'ID_Start').	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_core_property(0x10000, 0x1000B, 'ID_Start').	% Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_core_property(0x1000D, 0x10026, 'ID_Start').	% Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_core_property(0x10028, 0x1003A, 'ID_Start').	% Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_core_property(0x1003C, 0x1003D, 'ID_Start').	% Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_core_property(0x1003F, 0x1004D, 'ID_Start').	% Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_core_property(0x10050, 0x1005D, 'ID_Start').	% Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_core_property(0x10080, 0x100FA, 'ID_Start').	% Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_core_property(0x10140, 0x10174, 'ID_Start').	% Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_core_property(0x10280, 0x1029C, 'ID_Start').	% Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_core_property(0x102A0, 0x102D0, 'ID_Start').	% Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_core_property(0x10300, 0x1031E, 'ID_Start').	% Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_core_property(0x10330, 0x10340, 'ID_Start').	% Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_core_property(0x10341, 0x10341, 'ID_Start').	% Nl       GOTHIC LETTER NINETY
unicode_core_property(0x10342, 0x10349, 'ID_Start').	% Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_core_property(0x1034A, 0x1034A, 'ID_Start').	% Nl       GOTHIC LETTER NINE HUNDRED
unicode_core_property(0x10380, 0x1039D, 'ID_Start').	% Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_core_property(0x103A0, 0x103C3, 'ID_Start').	% Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_core_property(0x103C8, 0x103CF, 'ID_Start').	% Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_core_property(0x103D1, 0x103D5, 'ID_Start').	% Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_core_property(0x10400, 0x1044F, 'ID_Start').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x10450, 0x1049D, 'ID_Start').	% Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_core_property(0x10800, 0x10805, 'ID_Start').	% Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_core_property(0x10808, 0x10808, 'ID_Start').	% Lo       CYPRIOT SYLLABLE JO
unicode_core_property(0x1080A, 0x10835, 'ID_Start').	% Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_core_property(0x10837, 0x10838, 'ID_Start').	% Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_core_property(0x1083C, 0x1083C, 'ID_Start').	% Lo       CYPRIOT SYLLABLE ZA
unicode_core_property(0x1083F, 0x10855, 'ID_Start').	% Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_core_property(0x10900, 0x10915, 'ID_Start').	% Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_core_property(0x10920, 0x10939, 'ID_Start').	% Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_core_property(0x10980, 0x109B7, 'ID_Start').	% Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_core_property(0x109BE, 0x109BF, 'ID_Start').	% Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_core_property(0x10A00, 0x10A00, 'ID_Start').	% Lo       KHAROSHTHI LETTER A
unicode_core_property(0x10A10, 0x10A13, 'ID_Start').	% Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_core_property(0x10A15, 0x10A17, 'ID_Start').	% Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_core_property(0x10A19, 0x10A33, 'ID_Start').	% Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_core_property(0x10A60, 0x10A7C, 'ID_Start').	% Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_core_property(0x10B00, 0x10B35, 'ID_Start').	% Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_core_property(0x10B40, 0x10B55, 'ID_Start').	% Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_core_property(0x10B60, 0x10B72, 'ID_Start').	% Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_core_property(0x10C00, 0x10C48, 'ID_Start').	% Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_core_property(0x11003, 0x11037, 'ID_Start').	% Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_core_property(0x11083, 0x110AF, 'ID_Start').	% Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_core_property(0x110D0, 0x110E8, 'ID_Start').	% Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_core_property(0x11103, 0x11126, 'ID_Start').	% Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_core_property(0x11183, 0x111B2, 'ID_Start').	% Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_core_property(0x111C1, 0x111C4, 'ID_Start').	% Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_core_property(0x11680, 0x116AA, 'ID_Start').	% Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_core_property(0x12000, 0x1236E, 'ID_Start').	% Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_core_property(0x12400, 0x12462, 'ID_Start').	% Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_core_property(0x13000, 0x1342E, 'ID_Start').	% Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_core_property(0x16800, 0x16A38, 'ID_Start').	% Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_core_property(0x16F00, 0x16F44, 'ID_Start').	% Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_core_property(0x16F50, 0x16F50, 'ID_Start').	% Lo       MIAO LETTER NASALIZATION
unicode_core_property(0x16F93, 0x16F9F, 'ID_Start').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1B000, 0x1B001, 'ID_Start').	% Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_core_property(0x1D400, 0x1D454, 'ID_Start').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'ID_Start').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'ID_Start').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'ID_Start').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'ID_Start').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'ID_Start').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'ID_Start').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'ID_Start').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'ID_Start').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'ID_Start').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'ID_Start').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'ID_Start').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'ID_Start').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'ID_Start').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'ID_Start').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'ID_Start').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'ID_Start').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'ID_Start').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'ID_Start').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'ID_Start').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'ID_Start').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'ID_Start').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'ID_Start').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'ID_Start').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'ID_Start').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'ID_Start').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'ID_Start').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'ID_Start').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'ID_Start').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'ID_Start').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1EE00, 0x1EE03, 'ID_Start').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'ID_Start').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'ID_Start').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'ID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'ID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'ID_Start').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'ID_Start').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'ID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'ID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'ID_Start').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'ID_Start').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'ID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'ID_Start').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'ID_Start').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'ID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'ID_Start').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'ID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'ID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'ID_Start').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'ID_Start').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'ID_Start').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'ID_Start').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'ID_Start').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'ID_Start').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x20000, 0x2A6D6, 'ID_Start').	% Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_core_property(0x2A700, 0x2B734, 'ID_Start').	% Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_core_property(0x2B740, 0x2B81D, 'ID_Start').	% Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_core_property(0x2F800, 0x2FA1D, 'ID_Start').	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 101240

% ================================================

% Derived Property: ID_Continue
%  Characters that can continue an identifier.
%  Generated from:
%      ID_Start
%    + Mn + Mc + Nd + Pc
%    + Other_ID_Continue
%    - Pattern_Syntax
%    - Pattern_White_Space
%  NOTE: See UAX #31 for more information

unicode_core_property(0x0030, 0x0039, 'ID_Continue').	% Nd  [10] DIGIT ZERO..DIGIT NINE
unicode_core_property(0x0041, 0x005A, 'ID_Continue').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x005F, 0x005F, 'ID_Continue').	% Pc       LOW LINE
unicode_core_property(0x0061, 0x007A, 'ID_Continue').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'ID_Continue').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'ID_Continue').	% L&       MICRO SIGN
unicode_core_property(0x00B7, 0x00B7, 'ID_Continue').	% Po       MIDDLE DOT
unicode_core_property(0x00BA, 0x00BA, 'ID_Continue').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'ID_Continue').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'ID_Continue').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'ID_Continue').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'ID_Continue').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'ID_Continue').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'ID_Continue').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'ID_Continue').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'ID_Continue').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'ID_Continue').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'ID_Continue').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C6, 0x02D1, 'ID_Continue').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02E0, 0x02E4, 'ID_Continue').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02EC, 0x02EC, 'ID_Continue').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02EE, 0x02EE, 'ID_Continue').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x0300, 0x036F, 'ID_Continue').	% Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
unicode_core_property(0x0370, 0x0373, 'ID_Continue').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'ID_Continue').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'ID_Continue').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'ID_Continue').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'ID_Continue').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'ID_Continue').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0387, 0x0387, 'ID_Continue').	% Po       GREEK ANO TELEIA
unicode_core_property(0x0388, 0x038A, 'ID_Continue').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'ID_Continue').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'ID_Continue').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'ID_Continue').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'ID_Continue').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x0483, 0x0487, 'ID_Continue').	% Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
unicode_core_property(0x048A, 0x0527, 'ID_Continue').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'ID_Continue').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'ID_Continue').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0561, 0x0587, 'ID_Continue').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x0591, 0x05BD, 'ID_Continue').	% Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
unicode_core_property(0x05BF, 0x05BF, 'ID_Continue').	% Mn       HEBREW POINT RAFE
unicode_core_property(0x05C1, 0x05C2, 'ID_Continue').	% Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
unicode_core_property(0x05C4, 0x05C5, 'ID_Continue').	% Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
unicode_core_property(0x05C7, 0x05C7, 'ID_Continue').	% Mn       HEBREW POINT QAMATS QATAN
unicode_core_property(0x05D0, 0x05EA, 'ID_Continue').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'ID_Continue').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x0610, 0x061A, 'ID_Continue').	% Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
unicode_core_property(0x0620, 0x063F, 'ID_Continue').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'ID_Continue').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'ID_Continue').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x064B, 0x065F, 'ID_Continue').	% Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
unicode_core_property(0x0660, 0x0669, 'ID_Continue').	% Nd  [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
unicode_core_property(0x066E, 0x066F, 'ID_Continue').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0670, 0x0670, 'ID_Continue').	% Mn       ARABIC LETTER SUPERSCRIPT ALEF
unicode_core_property(0x0671, 0x06D3, 'ID_Continue').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D5, 0x06D5, 'ID_Continue').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06D6, 0x06DC, 'ID_Continue').	% Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
unicode_core_property(0x06DF, 0x06E4, 'ID_Continue').	% Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
unicode_core_property(0x06E5, 0x06E6, 'ID_Continue').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06E7, 0x06E8, 'ID_Continue').	% Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
unicode_core_property(0x06EA, 0x06ED, 'ID_Continue').	% Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
unicode_core_property(0x06EE, 0x06EF, 'ID_Continue').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06F0, 0x06F9, 'ID_Continue').	% Nd  [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
unicode_core_property(0x06FA, 0x06FC, 'ID_Continue').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FF, 0x06FF, 'ID_Continue').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0710, 0x0710, 'ID_Continue').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0711, 0x0711, 'ID_Continue').	% Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
unicode_core_property(0x0712, 0x072F, 'ID_Continue').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x0730, 0x074A, 'ID_Continue').	% Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
unicode_core_property(0x074D, 0x07A5, 'ID_Continue').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07A6, 0x07B0, 'ID_Continue').	% Mn  [11] THAANA ABAFILI..THAANA SUKUN
unicode_core_property(0x07B1, 0x07B1, 'ID_Continue').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07C0, 0x07C9, 'ID_Continue').	% Nd  [10] NKO DIGIT ZERO..NKO DIGIT NINE
unicode_core_property(0x07CA, 0x07EA, 'ID_Continue').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07EB, 0x07F3, 'ID_Continue').	% Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
unicode_core_property(0x07F4, 0x07F5, 'ID_Continue').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'ID_Continue').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'ID_Continue').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x0816, 0x0819, 'ID_Continue').	% Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
unicode_core_property(0x081A, 0x081A, 'ID_Continue').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x081B, 0x0823, 'ID_Continue').	% Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
unicode_core_property(0x0824, 0x0824, 'ID_Continue').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0825, 0x0827, 'ID_Continue').	% Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
unicode_core_property(0x0828, 0x0828, 'ID_Continue').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0829, 0x082D, 'ID_Continue').	% Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
unicode_core_property(0x0840, 0x0858, 'ID_Continue').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x0859, 0x085B, 'ID_Continue').	% Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
unicode_core_property(0x08A0, 0x08A0, 'ID_Continue').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'ID_Continue').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x08E4, 0x08FE, 'ID_Continue').	% Mn  [27] ARABIC CURLY FATHA..ARABIC DAMMA WITH DOT
unicode_core_property(0x0900, 0x0902, 'ID_Continue').	% Mn   [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
unicode_core_property(0x0903, 0x0903, 'ID_Continue').	% Mc       DEVANAGARI SIGN VISARGA
unicode_core_property(0x0904, 0x0939, 'ID_Continue').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093A, 0x093A, 'ID_Continue').	% Mn       DEVANAGARI VOWEL SIGN OE
unicode_core_property(0x093B, 0x093B, 'ID_Continue').	% Mc       DEVANAGARI VOWEL SIGN OOE
unicode_core_property(0x093C, 0x093C, 'ID_Continue').	% Mn       DEVANAGARI SIGN NUKTA
unicode_core_property(0x093D, 0x093D, 'ID_Continue').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x093E, 0x0940, 'ID_Continue').	% Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
unicode_core_property(0x0941, 0x0948, 'ID_Continue').	% Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
unicode_core_property(0x0949, 0x094C, 'ID_Continue').	% Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
unicode_core_property(0x094D, 0x094D, 'ID_Continue').	% Mn       DEVANAGARI SIGN VIRAMA
unicode_core_property(0x094E, 0x094F, 'ID_Continue').	% Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
unicode_core_property(0x0950, 0x0950, 'ID_Continue').	% Lo       DEVANAGARI OM
unicode_core_property(0x0951, 0x0957, 'ID_Continue').	% Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
unicode_core_property(0x0958, 0x0961, 'ID_Continue').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0962, 0x0963, 'ID_Continue').	% Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0966, 0x096F, 'ID_Continue').	% Nd  [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
unicode_core_property(0x0971, 0x0971, 'ID_Continue').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'ID_Continue').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'ID_Continue').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0981, 0x0981, 'ID_Continue').	% Mn       BENGALI SIGN CANDRABINDU
unicode_core_property(0x0982, 0x0983, 'ID_Continue').	% Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
unicode_core_property(0x0985, 0x098C, 'ID_Continue').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'ID_Continue').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'ID_Continue').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'ID_Continue').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'ID_Continue').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'ID_Continue').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BC, 0x09BC, 'ID_Continue').	% Mn       BENGALI SIGN NUKTA
unicode_core_property(0x09BD, 0x09BD, 'ID_Continue').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09BE, 0x09C0, 'ID_Continue').	% Mc   [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
unicode_core_property(0x09C1, 0x09C4, 'ID_Continue').	% Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
unicode_core_property(0x09C7, 0x09C8, 'ID_Continue').	% Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
unicode_core_property(0x09CB, 0x09CC, 'ID_Continue').	% Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
unicode_core_property(0x09CD, 0x09CD, 'ID_Continue').	% Mn       BENGALI SIGN VIRAMA
unicode_core_property(0x09CE, 0x09CE, 'ID_Continue').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09D7, 0x09D7, 'ID_Continue').	% Mc       BENGALI AU LENGTH MARK
unicode_core_property(0x09DC, 0x09DD, 'ID_Continue').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'ID_Continue').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09E2, 0x09E3, 'ID_Continue').	% Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
unicode_core_property(0x09E6, 0x09EF, 'ID_Continue').	% Nd  [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
unicode_core_property(0x09F0, 0x09F1, 'ID_Continue').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x0A01, 0x0A02, 'ID_Continue').	% Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
unicode_core_property(0x0A03, 0x0A03, 'ID_Continue').	% Mc       GURMUKHI SIGN VISARGA
unicode_core_property(0x0A05, 0x0A0A, 'ID_Continue').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'ID_Continue').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'ID_Continue').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'ID_Continue').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'ID_Continue').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'ID_Continue').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'ID_Continue').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A3C, 0x0A3C, 'ID_Continue').	% Mn       GURMUKHI SIGN NUKTA
unicode_core_property(0x0A3E, 0x0A40, 'ID_Continue').	% Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
unicode_core_property(0x0A41, 0x0A42, 'ID_Continue').	% Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
unicode_core_property(0x0A47, 0x0A48, 'ID_Continue').	% Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
unicode_core_property(0x0A4B, 0x0A4D, 'ID_Continue').	% Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
unicode_core_property(0x0A51, 0x0A51, 'ID_Continue').	% Mn       GURMUKHI SIGN UDAAT
unicode_core_property(0x0A59, 0x0A5C, 'ID_Continue').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'ID_Continue').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A66, 0x0A6F, 'ID_Continue').	% Nd  [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
unicode_core_property(0x0A70, 0x0A71, 'ID_Continue').	% Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
unicode_core_property(0x0A72, 0x0A74, 'ID_Continue').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A75, 0x0A75, 'ID_Continue').	% Mn       GURMUKHI SIGN YAKASH
unicode_core_property(0x0A81, 0x0A82, 'ID_Continue').	% Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
unicode_core_property(0x0A83, 0x0A83, 'ID_Continue').	% Mc       GUJARATI SIGN VISARGA
unicode_core_property(0x0A85, 0x0A8D, 'ID_Continue').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'ID_Continue').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'ID_Continue').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'ID_Continue').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'ID_Continue').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'ID_Continue').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABC, 0x0ABC, 'ID_Continue').	% Mn       GUJARATI SIGN NUKTA
unicode_core_property(0x0ABD, 0x0ABD, 'ID_Continue').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0ABE, 0x0AC0, 'ID_Continue').	% Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
unicode_core_property(0x0AC1, 0x0AC5, 'ID_Continue').	% Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
unicode_core_property(0x0AC7, 0x0AC8, 'ID_Continue').	% Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
unicode_core_property(0x0AC9, 0x0AC9, 'ID_Continue').	% Mc       GUJARATI VOWEL SIGN CANDRA O
unicode_core_property(0x0ACB, 0x0ACC, 'ID_Continue').	% Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
unicode_core_property(0x0ACD, 0x0ACD, 'ID_Continue').	% Mn       GUJARATI SIGN VIRAMA
unicode_core_property(0x0AD0, 0x0AD0, 'ID_Continue').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'ID_Continue').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0AE2, 0x0AE3, 'ID_Continue').	% Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0AE6, 0x0AEF, 'ID_Continue').	% Nd  [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
unicode_core_property(0x0B01, 0x0B01, 'ID_Continue').	% Mn       ORIYA SIGN CANDRABINDU
unicode_core_property(0x0B02, 0x0B03, 'ID_Continue').	% Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
unicode_core_property(0x0B05, 0x0B0C, 'ID_Continue').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'ID_Continue').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'ID_Continue').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'ID_Continue').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'ID_Continue').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'ID_Continue').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3C, 0x0B3C, 'ID_Continue').	% Mn       ORIYA SIGN NUKTA
unicode_core_property(0x0B3D, 0x0B3D, 'ID_Continue').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B3E, 0x0B3E, 'ID_Continue').	% Mc       ORIYA VOWEL SIGN AA
unicode_core_property(0x0B3F, 0x0B3F, 'ID_Continue').	% Mn       ORIYA VOWEL SIGN I
unicode_core_property(0x0B40, 0x0B40, 'ID_Continue').	% Mc       ORIYA VOWEL SIGN II
unicode_core_property(0x0B41, 0x0B44, 'ID_Continue').	% Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0B47, 0x0B48, 'ID_Continue').	% Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
unicode_core_property(0x0B4B, 0x0B4C, 'ID_Continue').	% Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
unicode_core_property(0x0B4D, 0x0B4D, 'ID_Continue').	% Mn       ORIYA SIGN VIRAMA
unicode_core_property(0x0B56, 0x0B56, 'ID_Continue').	% Mn       ORIYA AI LENGTH MARK
unicode_core_property(0x0B57, 0x0B57, 'ID_Continue').	% Mc       ORIYA AU LENGTH MARK
unicode_core_property(0x0B5C, 0x0B5D, 'ID_Continue').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'ID_Continue').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B62, 0x0B63, 'ID_Continue').	% Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B66, 0x0B6F, 'ID_Continue').	% Nd  [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
unicode_core_property(0x0B71, 0x0B71, 'ID_Continue').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B82, 0x0B82, 'ID_Continue').	% Mn       TAMIL SIGN ANUSVARA
unicode_core_property(0x0B83, 0x0B83, 'ID_Continue').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'ID_Continue').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'ID_Continue').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'ID_Continue').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'ID_Continue').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'ID_Continue').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'ID_Continue').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'ID_Continue').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'ID_Continue').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'ID_Continue').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BBE, 0x0BBF, 'ID_Continue').	% Mc   [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
unicode_core_property(0x0BC0, 0x0BC0, 'ID_Continue').	% Mn       TAMIL VOWEL SIGN II
unicode_core_property(0x0BC1, 0x0BC2, 'ID_Continue').	% Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
unicode_core_property(0x0BC6, 0x0BC8, 'ID_Continue').	% Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
unicode_core_property(0x0BCA, 0x0BCC, 'ID_Continue').	% Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
unicode_core_property(0x0BCD, 0x0BCD, 'ID_Continue').	% Mn       TAMIL SIGN VIRAMA
unicode_core_property(0x0BD0, 0x0BD0, 'ID_Continue').	% Lo       TAMIL OM
unicode_core_property(0x0BD7, 0x0BD7, 'ID_Continue').	% Mc       TAMIL AU LENGTH MARK
unicode_core_property(0x0BE6, 0x0BEF, 'ID_Continue').	% Nd  [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
unicode_core_property(0x0C01, 0x0C03, 'ID_Continue').	% Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
unicode_core_property(0x0C05, 0x0C0C, 'ID_Continue').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'ID_Continue').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'ID_Continue').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'ID_Continue').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'ID_Continue').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'ID_Continue').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C3E, 0x0C40, 'ID_Continue').	% Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
unicode_core_property(0x0C41, 0x0C44, 'ID_Continue').	% Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
unicode_core_property(0x0C46, 0x0C48, 'ID_Continue').	% Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
unicode_core_property(0x0C4A, 0x0C4D, 'ID_Continue').	% Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
unicode_core_property(0x0C55, 0x0C56, 'ID_Continue').	% Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
unicode_core_property(0x0C58, 0x0C59, 'ID_Continue').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'ID_Continue').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C62, 0x0C63, 'ID_Continue').	% Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
unicode_core_property(0x0C66, 0x0C6F, 'ID_Continue').	% Nd  [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
unicode_core_property(0x0C82, 0x0C83, 'ID_Continue').	% Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
unicode_core_property(0x0C85, 0x0C8C, 'ID_Continue').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'ID_Continue').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'ID_Continue').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'ID_Continue').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'ID_Continue').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBC, 0x0CBC, 'ID_Continue').	% Mn       KANNADA SIGN NUKTA
unicode_core_property(0x0CBD, 0x0CBD, 'ID_Continue').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CBE, 0x0CBE, 'ID_Continue').	% Mc       KANNADA VOWEL SIGN AA
unicode_core_property(0x0CBF, 0x0CBF, 'ID_Continue').	% Mn       KANNADA VOWEL SIGN I
unicode_core_property(0x0CC0, 0x0CC4, 'ID_Continue').	% Mc   [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0CC6, 0x0CC6, 'ID_Continue').	% Mn       KANNADA VOWEL SIGN E
unicode_core_property(0x0CC7, 0x0CC8, 'ID_Continue').	% Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
unicode_core_property(0x0CCA, 0x0CCB, 'ID_Continue').	% Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
unicode_core_property(0x0CCC, 0x0CCD, 'ID_Continue').	% Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
unicode_core_property(0x0CD5, 0x0CD6, 'ID_Continue').	% Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
unicode_core_property(0x0CDE, 0x0CDE, 'ID_Continue').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'ID_Continue').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CE2, 0x0CE3, 'ID_Continue').	% Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0CE6, 0x0CEF, 'ID_Continue').	% Nd  [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
unicode_core_property(0x0CF1, 0x0CF2, 'ID_Continue').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D02, 0x0D03, 'ID_Continue').	% Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
unicode_core_property(0x0D05, 0x0D0C, 'ID_Continue').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'ID_Continue').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'ID_Continue').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'ID_Continue').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D3E, 0x0D40, 'ID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
unicode_core_property(0x0D41, 0x0D44, 'ID_Continue').	% Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
unicode_core_property(0x0D46, 0x0D48, 'ID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
unicode_core_property(0x0D4A, 0x0D4C, 'ID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
unicode_core_property(0x0D4D, 0x0D4D, 'ID_Continue').	% Mn       MALAYALAM SIGN VIRAMA
unicode_core_property(0x0D4E, 0x0D4E, 'ID_Continue').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D57, 0x0D57, 'ID_Continue').	% Mc       MALAYALAM AU LENGTH MARK
unicode_core_property(0x0D60, 0x0D61, 'ID_Continue').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D62, 0x0D63, 'ID_Continue').	% Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
unicode_core_property(0x0D66, 0x0D6F, 'ID_Continue').	% Nd  [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
unicode_core_property(0x0D7A, 0x0D7F, 'ID_Continue').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D82, 0x0D83, 'ID_Continue').	% Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
unicode_core_property(0x0D85, 0x0D96, 'ID_Continue').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'ID_Continue').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'ID_Continue').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'ID_Continue').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'ID_Continue').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0DCA, 0x0DCA, 'ID_Continue').	% Mn       SINHALA SIGN AL-LAKUNA
unicode_core_property(0x0DCF, 0x0DD1, 'ID_Continue').	% Mc   [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
unicode_core_property(0x0DD2, 0x0DD4, 'ID_Continue').	% Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
unicode_core_property(0x0DD6, 0x0DD6, 'ID_Continue').	% Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
unicode_core_property(0x0DD8, 0x0DDF, 'ID_Continue').	% Mc   [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
unicode_core_property(0x0DF2, 0x0DF3, 'ID_Continue').	% Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
unicode_core_property(0x0E01, 0x0E30, 'ID_Continue').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E31, 0x0E31, 'ID_Continue').	% Mn       THAI CHARACTER MAI HAN-AKAT
unicode_core_property(0x0E32, 0x0E33, 'ID_Continue').	% Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_core_property(0x0E34, 0x0E3A, 'ID_Continue').	% Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
unicode_core_property(0x0E40, 0x0E45, 'ID_Continue').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'ID_Continue').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E47, 0x0E4E, 'ID_Continue').	% Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
unicode_core_property(0x0E50, 0x0E59, 'ID_Continue').	% Nd  [10] THAI DIGIT ZERO..THAI DIGIT NINE
unicode_core_property(0x0E81, 0x0E82, 'ID_Continue').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'ID_Continue').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'ID_Continue').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'ID_Continue').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'ID_Continue').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'ID_Continue').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'ID_Continue').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'ID_Continue').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'ID_Continue').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'ID_Continue').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'ID_Continue').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'ID_Continue').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB1, 0x0EB1, 'ID_Continue').	% Mn       LAO VOWEL SIGN MAI KAN
unicode_core_property(0x0EB2, 0x0EB3, 'ID_Continue').	% Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_core_property(0x0EB4, 0x0EB9, 'ID_Continue').	% Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
unicode_core_property(0x0EBB, 0x0EBC, 'ID_Continue').	% Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
unicode_core_property(0x0EBD, 0x0EBD, 'ID_Continue').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'ID_Continue').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'ID_Continue').	% Lm       LAO KO LA
unicode_core_property(0x0EC8, 0x0ECD, 'ID_Continue').	% Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
unicode_core_property(0x0ED0, 0x0ED9, 'ID_Continue').	% Nd  [10] LAO DIGIT ZERO..LAO DIGIT NINE
unicode_core_property(0x0EDC, 0x0EDF, 'ID_Continue').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'ID_Continue').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F18, 0x0F19, 'ID_Continue').	% Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
unicode_core_property(0x0F20, 0x0F29, 'ID_Continue').	% Nd  [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
unicode_core_property(0x0F35, 0x0F35, 'ID_Continue').	% Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
unicode_core_property(0x0F37, 0x0F37, 'ID_Continue').	% Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
unicode_core_property(0x0F39, 0x0F39, 'ID_Continue').	% Mn       TIBETAN MARK TSA -PHRU
unicode_core_property(0x0F3E, 0x0F3F, 'ID_Continue').	% Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
unicode_core_property(0x0F40, 0x0F47, 'ID_Continue').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'ID_Continue').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F71, 0x0F7E, 'ID_Continue').	% Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
unicode_core_property(0x0F7F, 0x0F7F, 'ID_Continue').	% Mc       TIBETAN SIGN RNAM BCAD
unicode_core_property(0x0F80, 0x0F84, 'ID_Continue').	% Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
unicode_core_property(0x0F86, 0x0F87, 'ID_Continue').	% Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
unicode_core_property(0x0F88, 0x0F8C, 'ID_Continue').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x0F8D, 0x0F97, 'ID_Continue').	% Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
unicode_core_property(0x0F99, 0x0FBC, 'ID_Continue').	% Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
unicode_core_property(0x0FC6, 0x0FC6, 'ID_Continue').	% Mn       TIBETAN SYMBOL PADMA GDAN
unicode_core_property(0x1000, 0x102A, 'ID_Continue').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x102B, 0x102C, 'ID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
unicode_core_property(0x102D, 0x1030, 'ID_Continue').	% Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
unicode_core_property(0x1031, 0x1031, 'ID_Continue').	% Mc       MYANMAR VOWEL SIGN E
unicode_core_property(0x1032, 0x1037, 'ID_Continue').	% Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
unicode_core_property(0x1038, 0x1038, 'ID_Continue').	% Mc       MYANMAR SIGN VISARGA
unicode_core_property(0x1039, 0x103A, 'ID_Continue').	% Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
unicode_core_property(0x103B, 0x103C, 'ID_Continue').	% Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
unicode_core_property(0x103D, 0x103E, 'ID_Continue').	% Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
unicode_core_property(0x103F, 0x103F, 'ID_Continue').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1040, 0x1049, 'ID_Continue').	% Nd  [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
unicode_core_property(0x1050, 0x1055, 'ID_Continue').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x1056, 0x1057, 'ID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
unicode_core_property(0x1058, 0x1059, 'ID_Continue').	% Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
unicode_core_property(0x105A, 0x105D, 'ID_Continue').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x105E, 0x1060, 'ID_Continue').	% Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
unicode_core_property(0x1061, 0x1061, 'ID_Continue').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1062, 0x1064, 'ID_Continue').	% Mc   [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
unicode_core_property(0x1065, 0x1066, 'ID_Continue').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x1067, 0x106D, 'ID_Continue').	% Mc   [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
unicode_core_property(0x106E, 0x1070, 'ID_Continue').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1071, 0x1074, 'ID_Continue').	% Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
unicode_core_property(0x1075, 0x1081, 'ID_Continue').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x1082, 0x1082, 'ID_Continue').	% Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
unicode_core_property(0x1083, 0x1084, 'ID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
unicode_core_property(0x1085, 0x1086, 'ID_Continue').	% Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
unicode_core_property(0x1087, 0x108C, 'ID_Continue').	% Mc   [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
unicode_core_property(0x108D, 0x108D, 'ID_Continue').	% Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
unicode_core_property(0x108E, 0x108E, 'ID_Continue').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x108F, 0x108F, 'ID_Continue').	% Mc       MYANMAR SIGN RUMAI PALAUNG TONE-5
unicode_core_property(0x1090, 0x1099, 'ID_Continue').	% Nd  [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
unicode_core_property(0x109A, 0x109C, 'ID_Continue').	% Mc   [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
unicode_core_property(0x109D, 0x109D, 'ID_Continue').	% Mn       MYANMAR VOWEL SIGN AITON AI
unicode_core_property(0x10A0, 0x10C5, 'ID_Continue').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'ID_Continue').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'ID_Continue').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'ID_Continue').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FC, 0x10FC, 'ID_Continue').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'ID_Continue').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'ID_Continue').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'ID_Continue').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'ID_Continue').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'ID_Continue').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'ID_Continue').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'ID_Continue').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'ID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'ID_Continue').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x135D, 0x135F, 'ID_Continue').	% Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
unicode_core_property(0x1369, 0x1371, 'ID_Continue').	% No   [9] ETHIOPIC DIGIT ONE..ETHIOPIC DIGIT NINE
unicode_core_property(0x1380, 0x138F, 'ID_Continue').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x13A0, 0x13F4, 'ID_Continue').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1401, 0x166C, 'ID_Continue').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166F, 0x167F, 'ID_Continue').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1681, 0x169A, 'ID_Continue').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x16A0, 0x16EA, 'ID_Continue').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EE, 0x16F0, 'ID_Continue').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'ID_Continue').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'ID_Continue').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1712, 0x1714, 'ID_Continue').	% Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
unicode_core_property(0x1720, 0x1731, 'ID_Continue').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1732, 0x1734, 'ID_Continue').	% Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN PAMUDPOD
unicode_core_property(0x1740, 0x1751, 'ID_Continue').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1752, 0x1753, 'ID_Continue').	% Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
unicode_core_property(0x1760, 0x176C, 'ID_Continue').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'ID_Continue').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1772, 0x1773, 'ID_Continue').	% Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
unicode_core_property(0x1780, 0x17B3, 'ID_Continue').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17B4, 0x17B5, 'ID_Continue').	% Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
unicode_core_property(0x17B6, 0x17B6, 'ID_Continue').	% Mc       KHMER VOWEL SIGN AA
unicode_core_property(0x17B7, 0x17BD, 'ID_Continue').	% Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
unicode_core_property(0x17BE, 0x17C5, 'ID_Continue').	% Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
unicode_core_property(0x17C6, 0x17C6, 'ID_Continue').	% Mn       KHMER SIGN NIKAHIT
unicode_core_property(0x17C7, 0x17C8, 'ID_Continue').	% Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
unicode_core_property(0x17C9, 0x17D3, 'ID_Continue').	% Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
unicode_core_property(0x17D7, 0x17D7, 'ID_Continue').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DC, 0x17DC, 'ID_Continue').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x17DD, 0x17DD, 'ID_Continue').	% Mn       KHMER SIGN ATTHACAN
unicode_core_property(0x17E0, 0x17E9, 'ID_Continue').	% Nd  [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
unicode_core_property(0x180B, 0x180D, 'ID_Continue').	% Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
unicode_core_property(0x1810, 0x1819, 'ID_Continue').	% Nd  [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
unicode_core_property(0x1820, 0x1842, 'ID_Continue').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'ID_Continue').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'ID_Continue').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'ID_Continue').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18A9, 0x18A9, 'ID_Continue').	% Mn       MONGOLIAN LETTER ALI GALI DAGALGA
unicode_core_property(0x18AA, 0x18AA, 'ID_Continue').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'ID_Continue').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'ID_Continue').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1920, 0x1922, 'ID_Continue').	% Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
unicode_core_property(0x1923, 0x1926, 'ID_Continue').	% Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
unicode_core_property(0x1927, 0x1928, 'ID_Continue').	% Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
unicode_core_property(0x1929, 0x192B, 'ID_Continue').	% Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
unicode_core_property(0x1930, 0x1931, 'ID_Continue').	% Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
unicode_core_property(0x1932, 0x1932, 'ID_Continue').	% Mn       LIMBU SMALL LETTER ANUSVARA
unicode_core_property(0x1933, 0x1938, 'ID_Continue').	% Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
unicode_core_property(0x1939, 0x193B, 'ID_Continue').	% Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
unicode_core_property(0x1946, 0x194F, 'ID_Continue').	% Nd  [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
unicode_core_property(0x1950, 0x196D, 'ID_Continue').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'ID_Continue').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'ID_Continue').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19B0, 0x19C0, 'ID_Continue').	% Mc  [17] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE VOWEL SIGN IY
unicode_core_property(0x19C1, 0x19C7, 'ID_Continue').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x19C8, 0x19C9, 'ID_Continue').	% Mc   [2] NEW TAI LUE TONE MARK-1..NEW TAI LUE TONE MARK-2
unicode_core_property(0x19D0, 0x19D9, 'ID_Continue').	% Nd  [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
unicode_core_property(0x19DA, 0x19DA, 'ID_Continue').	% No       NEW TAI LUE THAM DIGIT ONE
unicode_core_property(0x1A00, 0x1A16, 'ID_Continue').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A17, 0x1A18, 'ID_Continue').	% Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
unicode_core_property(0x1A19, 0x1A1B, 'ID_Continue').	% Mc   [3] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN AE
unicode_core_property(0x1A20, 0x1A54, 'ID_Continue').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1A55, 0x1A55, 'ID_Continue').	% Mc       TAI THAM CONSONANT SIGN MEDIAL RA
unicode_core_property(0x1A56, 0x1A56, 'ID_Continue').	% Mn       TAI THAM CONSONANT SIGN MEDIAL LA
unicode_core_property(0x1A57, 0x1A57, 'ID_Continue').	% Mc       TAI THAM CONSONANT SIGN LA TANG LAI
unicode_core_property(0x1A58, 0x1A5E, 'ID_Continue').	% Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
unicode_core_property(0x1A60, 0x1A60, 'ID_Continue').	% Mn       TAI THAM SIGN SAKOT
unicode_core_property(0x1A61, 0x1A61, 'ID_Continue').	% Mc       TAI THAM VOWEL SIGN A
unicode_core_property(0x1A62, 0x1A62, 'ID_Continue').	% Mn       TAI THAM VOWEL SIGN MAI SAT
unicode_core_property(0x1A63, 0x1A64, 'ID_Continue').	% Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
unicode_core_property(0x1A65, 0x1A6C, 'ID_Continue').	% Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
unicode_core_property(0x1A6D, 0x1A72, 'ID_Continue').	% Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
unicode_core_property(0x1A73, 0x1A7C, 'ID_Continue').	% Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
unicode_core_property(0x1A7F, 0x1A7F, 'ID_Continue').	% Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
unicode_core_property(0x1A80, 0x1A89, 'ID_Continue').	% Nd  [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
unicode_core_property(0x1A90, 0x1A99, 'ID_Continue').	% Nd  [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
unicode_core_property(0x1AA7, 0x1AA7, 'ID_Continue').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B00, 0x1B03, 'ID_Continue').	% Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
unicode_core_property(0x1B04, 0x1B04, 'ID_Continue').	% Mc       BALINESE SIGN BISAH
unicode_core_property(0x1B05, 0x1B33, 'ID_Continue').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B34, 0x1B34, 'ID_Continue').	% Mn       BALINESE SIGN REREKAN
unicode_core_property(0x1B35, 0x1B35, 'ID_Continue').	% Mc       BALINESE VOWEL SIGN TEDUNG
unicode_core_property(0x1B36, 0x1B3A, 'ID_Continue').	% Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
unicode_core_property(0x1B3B, 0x1B3B, 'ID_Continue').	% Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
unicode_core_property(0x1B3C, 0x1B3C, 'ID_Continue').	% Mn       BALINESE VOWEL SIGN LA LENGA
unicode_core_property(0x1B3D, 0x1B41, 'ID_Continue').	% Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
unicode_core_property(0x1B42, 0x1B42, 'ID_Continue').	% Mn       BALINESE VOWEL SIGN PEPET
unicode_core_property(0x1B43, 0x1B44, 'ID_Continue').	% Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
unicode_core_property(0x1B45, 0x1B4B, 'ID_Continue').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B50, 0x1B59, 'ID_Continue').	% Nd  [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
unicode_core_property(0x1B6B, 0x1B73, 'ID_Continue').	% Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
unicode_core_property(0x1B80, 0x1B81, 'ID_Continue').	% Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
unicode_core_property(0x1B82, 0x1B82, 'ID_Continue').	% Mc       SUNDANESE SIGN PANGWISAD
unicode_core_property(0x1B83, 0x1BA0, 'ID_Continue').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BA1, 0x1BA1, 'ID_Continue').	% Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
unicode_core_property(0x1BA2, 0x1BA5, 'ID_Continue').	% Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
unicode_core_property(0x1BA6, 0x1BA7, 'ID_Continue').	% Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
unicode_core_property(0x1BA8, 0x1BA9, 'ID_Continue').	% Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
unicode_core_property(0x1BAA, 0x1BAA, 'ID_Continue').	% Mc       SUNDANESE SIGN PAMAAEH
unicode_core_property(0x1BAB, 0x1BAB, 'ID_Continue').	% Mn       SUNDANESE SIGN VIRAMA
unicode_core_property(0x1BAC, 0x1BAD, 'ID_Continue').	% Mc   [2] SUNDANESE CONSONANT SIGN PASANGAN MA..SUNDANESE CONSONANT SIGN PASANGAN WA
unicode_core_property(0x1BAE, 0x1BAF, 'ID_Continue').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BB0, 0x1BB9, 'ID_Continue').	% Nd  [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
unicode_core_property(0x1BBA, 0x1BE5, 'ID_Continue').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1BE6, 0x1BE6, 'ID_Continue').	% Mn       BATAK SIGN TOMPI
unicode_core_property(0x1BE7, 0x1BE7, 'ID_Continue').	% Mc       BATAK VOWEL SIGN E
unicode_core_property(0x1BE8, 0x1BE9, 'ID_Continue').	% Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
unicode_core_property(0x1BEA, 0x1BEC, 'ID_Continue').	% Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
unicode_core_property(0x1BED, 0x1BED, 'ID_Continue').	% Mn       BATAK VOWEL SIGN KARO O
unicode_core_property(0x1BEE, 0x1BEE, 'ID_Continue').	% Mc       BATAK VOWEL SIGN U
unicode_core_property(0x1BEF, 0x1BF1, 'ID_Continue').	% Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
unicode_core_property(0x1BF2, 0x1BF3, 'ID_Continue').	% Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
unicode_core_property(0x1C00, 0x1C23, 'ID_Continue').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C24, 0x1C2B, 'ID_Continue').	% Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
unicode_core_property(0x1C2C, 0x1C33, 'ID_Continue').	% Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
unicode_core_property(0x1C34, 0x1C35, 'ID_Continue').	% Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
unicode_core_property(0x1C36, 0x1C37, 'ID_Continue').	% Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
unicode_core_property(0x1C40, 0x1C49, 'ID_Continue').	% Nd  [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
unicode_core_property(0x1C4D, 0x1C4F, 'ID_Continue').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C50, 0x1C59, 'ID_Continue').	% Nd  [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
unicode_core_property(0x1C5A, 0x1C77, 'ID_Continue').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'ID_Continue').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CD0, 0x1CD2, 'ID_Continue').	% Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
unicode_core_property(0x1CD4, 0x1CE0, 'ID_Continue').	% Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
unicode_core_property(0x1CE1, 0x1CE1, 'ID_Continue').	% Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
unicode_core_property(0x1CE2, 0x1CE8, 'ID_Continue').	% Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
unicode_core_property(0x1CE9, 0x1CEC, 'ID_Continue').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_core_property(0x1CED, 0x1CED, 'ID_Continue').	% Mn       VEDIC SIGN TIRYAK
unicode_core_property(0x1CEE, 0x1CF1, 'ID_Continue').	% Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_core_property(0x1CF2, 0x1CF3, 'ID_Continue').	% Mc   [2] VEDIC SIGN ARDHAVISARGA..VEDIC SIGN ROTATED ARDHAVISARGA
unicode_core_property(0x1CF4, 0x1CF4, 'ID_Continue').	% Mn       VEDIC TONE CANDRA ABOVE
unicode_core_property(0x1CF5, 0x1CF6, 'ID_Continue').	% Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_core_property(0x1D00, 0x1D2B, 'ID_Continue').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'ID_Continue').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'ID_Continue').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'ID_Continue').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'ID_Continue').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'ID_Continue').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1DC0, 0x1DE6, 'ID_Continue').	% Mn  [39] COMBINING DOTTED GRAVE ACCENT..COMBINING LATIN SMALL LETTER Z
unicode_core_property(0x1DFC, 0x1DFF, 'ID_Continue').	% Mn   [4] COMBINING DOUBLE INVERTED BREVE BELOW..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
unicode_core_property(0x1E00, 0x1F15, 'ID_Continue').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'ID_Continue').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'ID_Continue').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'ID_Continue').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'ID_Continue').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'ID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'ID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'ID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'ID_Continue').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'ID_Continue').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'ID_Continue').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'ID_Continue').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'ID_Continue').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'ID_Continue').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'ID_Continue').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'ID_Continue').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'ID_Continue').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'ID_Continue').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'ID_Continue').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x203F, 0x2040, 'ID_Continue').	% Pc   [2] UNDERTIE..CHARACTER TIE
unicode_core_property(0x2054, 0x2054, 'ID_Continue').	% Pc       INVERTED UNDERTIE
unicode_core_property(0x2071, 0x2071, 'ID_Continue').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'ID_Continue').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'ID_Continue').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x20D0, 0x20DC, 'ID_Continue').	% Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_core_property(0x20E1, 0x20E1, 'ID_Continue').	% Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_core_property(0x20E5, 0x20F0, 'ID_Continue').	% Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
unicode_core_property(0x2102, 0x2102, 'ID_Continue').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'ID_Continue').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'ID_Continue').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'ID_Continue').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2118, 0x2118, 'ID_Continue').	% Sm       SCRIPT CAPITAL P
unicode_core_property(0x2119, 0x211D, 'ID_Continue').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'ID_Continue').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'ID_Continue').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'ID_Continue').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'ID_Continue').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212E, 0x212E, 'ID_Continue').	% So       ESTIMATED SYMBOL
unicode_core_property(0x212F, 0x2134, 'ID_Continue').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'ID_Continue').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x2139, 0x2139, 'ID_Continue').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'ID_Continue').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'ID_Continue').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'ID_Continue').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x2182, 'ID_Continue').	% Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_core_property(0x2183, 0x2184, 'ID_Continue').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x2185, 0x2188, 'ID_Continue').	% Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_core_property(0x2C00, 0x2C2E, 'ID_Continue').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'ID_Continue').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'ID_Continue').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'ID_Continue').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'ID_Continue').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'ID_Continue').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CEF, 0x2CF1, 'ID_Continue').	% Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
unicode_core_property(0x2CF2, 0x2CF3, 'ID_Continue').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'ID_Continue').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'ID_Continue').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'ID_Continue').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0x2D30, 0x2D67, 'ID_Continue').	% Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_core_property(0x2D6F, 0x2D6F, 'ID_Continue').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D7F, 0x2D7F, 'ID_Continue').	% Mn       TIFINAGH CONSONANT JOINER
unicode_core_property(0x2D80, 0x2D96, 'ID_Continue').	% Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_core_property(0x2DA0, 0x2DA6, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_core_property(0x2DA8, 0x2DAE, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_core_property(0x2DB0, 0x2DB6, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_core_property(0x2DB8, 0x2DBE, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_core_property(0x2DC0, 0x2DC6, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_core_property(0x2DC8, 0x2DCE, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_core_property(0x2DD0, 0x2DD6, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_core_property(0x2DD8, 0x2DDE, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_core_property(0x2DE0, 0x2DFF, 'ID_Continue').	% Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
unicode_core_property(0x3005, 0x3005, 'ID_Continue').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3006, 0x3006, 'ID_Continue').	% Lo       IDEOGRAPHIC CLOSING MARK
unicode_core_property(0x3007, 0x3007, 'ID_Continue').	% Nl       IDEOGRAPHIC NUMBER ZERO
unicode_core_property(0x3021, 0x3029, 'ID_Continue').	% Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_core_property(0x302A, 0x302D, 'ID_Continue').	% Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
unicode_core_property(0x302E, 0x302F, 'ID_Continue').	% Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
unicode_core_property(0x3031, 0x3035, 'ID_Continue').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x3038, 0x303A, 'ID_Continue').	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_core_property(0x303B, 0x303B, 'ID_Continue').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x303C, 0x303C, 'ID_Continue').	% Lo       MASU MARK
unicode_core_property(0x3041, 0x3096, 'ID_Continue').	% Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_core_property(0x3099, 0x309A, 'ID_Continue').	% Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309B, 0x309C, 'ID_Continue').	% Sk   [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309D, 0x309E, 'ID_Continue').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x309F, 0x309F, 'ID_Continue').	% Lo       HIRAGANA DIGRAPH YORI
unicode_core_property(0x30A1, 0x30FA, 'ID_Continue').	% Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_core_property(0x30FC, 0x30FE, 'ID_Continue').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0x30FF, 0x30FF, 'ID_Continue').	% Lo       KATAKANA DIGRAPH KOTO
unicode_core_property(0x3105, 0x312D, 'ID_Continue').	% Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_core_property(0x3131, 0x318E, 'ID_Continue').	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_core_property(0x31A0, 0x31BA, 'ID_Continue').	% Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_core_property(0x31F0, 0x31FF, 'ID_Continue').	% Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_core_property(0x3400, 0x4DB5, 'ID_Continue').	% Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_core_property(0x4E00, 0x9FCC, 'ID_Continue').	% Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_core_property(0xA000, 0xA014, 'ID_Continue').	% Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_core_property(0xA015, 0xA015, 'ID_Continue').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA016, 0xA48C, 'ID_Continue').	% Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_core_property(0xA4D0, 0xA4F7, 'ID_Continue').	% Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_core_property(0xA4F8, 0xA4FD, 'ID_Continue').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA500, 0xA60B, 'ID_Continue').	% Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_core_property(0xA60C, 0xA60C, 'ID_Continue').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA610, 0xA61F, 'ID_Continue').	% Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_core_property(0xA620, 0xA629, 'ID_Continue').	% Nd  [10] VAI DIGIT ZERO..VAI DIGIT NINE
unicode_core_property(0xA62A, 0xA62B, 'ID_Continue').	% Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_core_property(0xA640, 0xA66D, 'ID_Continue').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA66E, 0xA66E, 'ID_Continue').	% Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_core_property(0xA66F, 0xA66F, 'ID_Continue').	% Mn       COMBINING CYRILLIC VZMET
unicode_core_property(0xA674, 0xA67D, 'ID_Continue').	% Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
unicode_core_property(0xA67F, 0xA67F, 'ID_Continue').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA680, 0xA697, 'ID_Continue').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA69F, 0xA69F, 'ID_Continue').	% Mn       COMBINING CYRILLIC LETTER IOTIFIED E
unicode_core_property(0xA6A0, 0xA6E5, 'ID_Continue').	% Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_core_property(0xA6E6, 0xA6EF, 'ID_Continue').	% Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_core_property(0xA6F0, 0xA6F1, 'ID_Continue').	% Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
unicode_core_property(0xA717, 0xA71F, 'ID_Continue').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA722, 0xA76F, 'ID_Continue').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'ID_Continue').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'ID_Continue').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA788, 0xA788, 'ID_Continue').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA78B, 0xA78E, 'ID_Continue').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'ID_Continue').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'ID_Continue').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'ID_Continue').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'ID_Continue').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xA7FB, 0xA801, 'ID_Continue').	% Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_core_property(0xA802, 0xA802, 'ID_Continue').	% Mn       SYLOTI NAGRI SIGN DVISVARA
unicode_core_property(0xA803, 0xA805, 'ID_Continue').	% Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_core_property(0xA806, 0xA806, 'ID_Continue').	% Mn       SYLOTI NAGRI SIGN HASANTA
unicode_core_property(0xA807, 0xA80A, 'ID_Continue').	% Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_core_property(0xA80B, 0xA80B, 'ID_Continue').	% Mn       SYLOTI NAGRI SIGN ANUSVARA
unicode_core_property(0xA80C, 0xA822, 'ID_Continue').	% Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_core_property(0xA823, 0xA824, 'ID_Continue').	% Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
unicode_core_property(0xA825, 0xA826, 'ID_Continue').	% Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
unicode_core_property(0xA827, 0xA827, 'ID_Continue').	% Mc       SYLOTI NAGRI VOWEL SIGN OO
unicode_core_property(0xA840, 0xA873, 'ID_Continue').	% Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_core_property(0xA880, 0xA881, 'ID_Continue').	% Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
unicode_core_property(0xA882, 0xA8B3, 'ID_Continue').	% Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_core_property(0xA8B4, 0xA8C3, 'ID_Continue').	% Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
unicode_core_property(0xA8C4, 0xA8C4, 'ID_Continue').	% Mn       SAURASHTRA SIGN VIRAMA
unicode_core_property(0xA8D0, 0xA8D9, 'ID_Continue').	% Nd  [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
unicode_core_property(0xA8E0, 0xA8F1, 'ID_Continue').	% Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0xA8F2, 0xA8F7, 'ID_Continue').	% Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_core_property(0xA8FB, 0xA8FB, 'ID_Continue').	% Lo       DEVANAGARI HEADSTROKE
unicode_core_property(0xA900, 0xA909, 'ID_Continue').	% Nd  [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
unicode_core_property(0xA90A, 0xA925, 'ID_Continue').	% Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_core_property(0xA926, 0xA92D, 'ID_Continue').	% Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
unicode_core_property(0xA930, 0xA946, 'ID_Continue').	% Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_core_property(0xA947, 0xA951, 'ID_Continue').	% Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
unicode_core_property(0xA952, 0xA953, 'ID_Continue').	% Mc   [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
unicode_core_property(0xA960, 0xA97C, 'ID_Continue').	% Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_core_property(0xA980, 0xA982, 'ID_Continue').	% Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
unicode_core_property(0xA983, 0xA983, 'ID_Continue').	% Mc       JAVANESE SIGN WIGNYAN
unicode_core_property(0xA984, 0xA9B2, 'ID_Continue').	% Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_core_property(0xA9B3, 0xA9B3, 'ID_Continue').	% Mn       JAVANESE SIGN CECAK TELU
unicode_core_property(0xA9B4, 0xA9B5, 'ID_Continue').	% Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
unicode_core_property(0xA9B6, 0xA9B9, 'ID_Continue').	% Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
unicode_core_property(0xA9BA, 0xA9BB, 'ID_Continue').	% Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
unicode_core_property(0xA9BC, 0xA9BC, 'ID_Continue').	% Mn       JAVANESE VOWEL SIGN PEPET
unicode_core_property(0xA9BD, 0xA9C0, 'ID_Continue').	% Mc   [4] JAVANESE CONSONANT SIGN KERET..JAVANESE PANGKON
unicode_core_property(0xA9CF, 0xA9CF, 'ID_Continue').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xA9D0, 0xA9D9, 'ID_Continue').	% Nd  [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
unicode_core_property(0xAA00, 0xAA28, 'ID_Continue').	% Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_core_property(0xAA29, 0xAA2E, 'ID_Continue').	% Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
unicode_core_property(0xAA2F, 0xAA30, 'ID_Continue').	% Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
unicode_core_property(0xAA31, 0xAA32, 'ID_Continue').	% Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
unicode_core_property(0xAA33, 0xAA34, 'ID_Continue').	% Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
unicode_core_property(0xAA35, 0xAA36, 'ID_Continue').	% Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
unicode_core_property(0xAA40, 0xAA42, 'ID_Continue').	% Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_core_property(0xAA43, 0xAA43, 'ID_Continue').	% Mn       CHAM CONSONANT SIGN FINAL NG
unicode_core_property(0xAA44, 0xAA4B, 'ID_Continue').	% Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_core_property(0xAA4C, 0xAA4C, 'ID_Continue').	% Mn       CHAM CONSONANT SIGN FINAL M
unicode_core_property(0xAA4D, 0xAA4D, 'ID_Continue').	% Mc       CHAM CONSONANT SIGN FINAL H
unicode_core_property(0xAA50, 0xAA59, 'ID_Continue').	% Nd  [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
unicode_core_property(0xAA60, 0xAA6F, 'ID_Continue').	% Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_core_property(0xAA70, 0xAA70, 'ID_Continue').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAA71, 0xAA76, 'ID_Continue').	% Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_core_property(0xAA7A, 0xAA7A, 'ID_Continue').	% Lo       MYANMAR LETTER AITON RA
unicode_core_property(0xAA7B, 0xAA7B, 'ID_Continue').	% Mc       MYANMAR SIGN PAO KAREN TONE
unicode_core_property(0xAA80, 0xAAAF, 'ID_Continue').	% Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_core_property(0xAAB0, 0xAAB0, 'ID_Continue').	% Mn       TAI VIET MAI KANG
unicode_core_property(0xAAB1, 0xAAB1, 'ID_Continue').	% Lo       TAI VIET VOWEL AA
unicode_core_property(0xAAB2, 0xAAB4, 'ID_Continue').	% Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
unicode_core_property(0xAAB5, 0xAAB6, 'ID_Continue').	% Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_core_property(0xAAB7, 0xAAB8, 'ID_Continue').	% Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
unicode_core_property(0xAAB9, 0xAABD, 'ID_Continue').	% Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_core_property(0xAABE, 0xAABF, 'ID_Continue').	% Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
unicode_core_property(0xAAC0, 0xAAC0, 'ID_Continue').	% Lo       TAI VIET TONE MAI NUENG
unicode_core_property(0xAAC1, 0xAAC1, 'ID_Continue').	% Mn       TAI VIET TONE MAI THO
unicode_core_property(0xAAC2, 0xAAC2, 'ID_Continue').	% Lo       TAI VIET TONE MAI SONG
unicode_core_property(0xAADB, 0xAADC, 'ID_Continue').	% Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_core_property(0xAADD, 0xAADD, 'ID_Continue').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAE0, 0xAAEA, 'ID_Continue').	% Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_core_property(0xAAEB, 0xAAEB, 'ID_Continue').	% Mc       MEETEI MAYEK VOWEL SIGN II
unicode_core_property(0xAAEC, 0xAAED, 'ID_Continue').	% Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
unicode_core_property(0xAAEE, 0xAAEF, 'ID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
unicode_core_property(0xAAF2, 0xAAF2, 'ID_Continue').	% Lo       MEETEI MAYEK ANJI
unicode_core_property(0xAAF3, 0xAAF4, 'ID_Continue').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAAF5, 0xAAF5, 'ID_Continue').	% Mc       MEETEI MAYEK VOWEL SIGN VISARGA
unicode_core_property(0xAAF6, 0xAAF6, 'ID_Continue').	% Mn       MEETEI MAYEK VIRAMA
unicode_core_property(0xAB01, 0xAB06, 'ID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_core_property(0xAB09, 0xAB0E, 'ID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_core_property(0xAB11, 0xAB16, 'ID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_core_property(0xAB20, 0xAB26, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_core_property(0xAB28, 0xAB2E, 'ID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_core_property(0xABC0, 0xABE2, 'ID_Continue').	% Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_core_property(0xABE3, 0xABE4, 'ID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
unicode_core_property(0xABE5, 0xABE5, 'ID_Continue').	% Mn       MEETEI MAYEK VOWEL SIGN ANAP
unicode_core_property(0xABE6, 0xABE7, 'ID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
unicode_core_property(0xABE8, 0xABE8, 'ID_Continue').	% Mn       MEETEI MAYEK VOWEL SIGN UNAP
unicode_core_property(0xABE9, 0xABEA, 'ID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
unicode_core_property(0xABEC, 0xABEC, 'ID_Continue').	% Mc       MEETEI MAYEK LUM IYEK
unicode_core_property(0xABED, 0xABED, 'ID_Continue').	% Mn       MEETEI MAYEK APUN IYEK
unicode_core_property(0xABF0, 0xABF9, 'ID_Continue').	% Nd  [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
unicode_core_property(0xAC00, 0xD7A3, 'ID_Continue').	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_core_property(0xD7B0, 0xD7C6, 'ID_Continue').	% Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_core_property(0xD7CB, 0xD7FB, 'ID_Continue').	% Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_core_property(0xF900, 0xFA6D, 'ID_Continue').	% Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_core_property(0xFA70, 0xFAD9, 'ID_Continue').	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_core_property(0xFB00, 0xFB06, 'ID_Continue').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'ID_Continue').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFB1D, 0xFB1D, 'ID_Continue').	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_core_property(0xFB1E, 0xFB1E, 'ID_Continue').	% Mn       HEBREW POINT JUDEO-SPANISH VARIKA
unicode_core_property(0xFB1F, 0xFB28, 'ID_Continue').	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_core_property(0xFB2A, 0xFB36, 'ID_Continue').	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_core_property(0xFB38, 0xFB3C, 'ID_Continue').	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_core_property(0xFB3E, 0xFB3E, 'ID_Continue').	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_core_property(0xFB40, 0xFB41, 'ID_Continue').	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_core_property(0xFB43, 0xFB44, 'ID_Continue').	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_core_property(0xFB46, 0xFBB1, 'ID_Continue').	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_core_property(0xFBD3, 0xFD3D, 'ID_Continue').	% Lo [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_core_property(0xFD50, 0xFD8F, 'ID_Continue').	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_core_property(0xFD92, 0xFDC7, 'ID_Continue').	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_core_property(0xFDF0, 0xFDFB, 'ID_Continue').	% Lo  [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
unicode_core_property(0xFE00, 0xFE0F, 'ID_Continue').	% Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
unicode_core_property(0xFE20, 0xFE26, 'ID_Continue').	% Mn   [7] COMBINING LIGATURE LEFT HALF..COMBINING CONJOINING MACRON
unicode_core_property(0xFE33, 0xFE34, 'ID_Continue').	% Pc   [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
unicode_core_property(0xFE4D, 0xFE4F, 'ID_Continue').	% Pc   [3] DASHED LOW LINE..WAVY LOW LINE
unicode_core_property(0xFE70, 0xFE74, 'ID_Continue').	% Lo   [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
unicode_core_property(0xFE76, 0xFEFC, 'ID_Continue').	% Lo [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_core_property(0xFF10, 0xFF19, 'ID_Continue').	% Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
unicode_core_property(0xFF21, 0xFF3A, 'ID_Continue').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF3F, 0xFF3F, 'ID_Continue').	% Pc       FULLWIDTH LOW LINE
unicode_core_property(0xFF41, 0xFF5A, 'ID_Continue').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0xFF66, 0xFF6F, 'ID_Continue').	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_core_property(0xFF70, 0xFF70, 'ID_Continue').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF71, 0xFF9D, 'ID_Continue').	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_core_property(0xFF9E, 0xFF9F, 'ID_Continue').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0xFFA0, 0xFFBE, 'ID_Continue').	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_core_property(0xFFC2, 0xFFC7, 'ID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_core_property(0xFFCA, 0xFFCF, 'ID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_core_property(0xFFD2, 0xFFD7, 'ID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_core_property(0xFFDA, 0xFFDC, 'ID_Continue').	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_core_property(0x10000, 0x1000B, 'ID_Continue').	% Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_core_property(0x1000D, 0x10026, 'ID_Continue').	% Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_core_property(0x10028, 0x1003A, 'ID_Continue').	% Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_core_property(0x1003C, 0x1003D, 'ID_Continue').	% Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_core_property(0x1003F, 0x1004D, 'ID_Continue').	% Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_core_property(0x10050, 0x1005D, 'ID_Continue').	% Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_core_property(0x10080, 0x100FA, 'ID_Continue').	% Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_core_property(0x10140, 0x10174, 'ID_Continue').	% Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_core_property(0x101FD, 0x101FD, 'ID_Continue').	% Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
unicode_core_property(0x10280, 0x1029C, 'ID_Continue').	% Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_core_property(0x102A0, 0x102D0, 'ID_Continue').	% Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_core_property(0x10300, 0x1031E, 'ID_Continue').	% Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_core_property(0x10330, 0x10340, 'ID_Continue').	% Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_core_property(0x10341, 0x10341, 'ID_Continue').	% Nl       GOTHIC LETTER NINETY
unicode_core_property(0x10342, 0x10349, 'ID_Continue').	% Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_core_property(0x1034A, 0x1034A, 'ID_Continue').	% Nl       GOTHIC LETTER NINE HUNDRED
unicode_core_property(0x10380, 0x1039D, 'ID_Continue').	% Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_core_property(0x103A0, 0x103C3, 'ID_Continue').	% Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_core_property(0x103C8, 0x103CF, 'ID_Continue').	% Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_core_property(0x103D1, 0x103D5, 'ID_Continue').	% Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_core_property(0x10400, 0x1044F, 'ID_Continue').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x10450, 0x1049D, 'ID_Continue').	% Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_core_property(0x104A0, 0x104A9, 'ID_Continue').	% Nd  [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
unicode_core_property(0x10800, 0x10805, 'ID_Continue').	% Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_core_property(0x10808, 0x10808, 'ID_Continue').	% Lo       CYPRIOT SYLLABLE JO
unicode_core_property(0x1080A, 0x10835, 'ID_Continue').	% Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_core_property(0x10837, 0x10838, 'ID_Continue').	% Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_core_property(0x1083C, 0x1083C, 'ID_Continue').	% Lo       CYPRIOT SYLLABLE ZA
unicode_core_property(0x1083F, 0x10855, 'ID_Continue').	% Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_core_property(0x10900, 0x10915, 'ID_Continue').	% Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_core_property(0x10920, 0x10939, 'ID_Continue').	% Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_core_property(0x10980, 0x109B7, 'ID_Continue').	% Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_core_property(0x109BE, 0x109BF, 'ID_Continue').	% Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_core_property(0x10A00, 0x10A00, 'ID_Continue').	% Lo       KHAROSHTHI LETTER A
unicode_core_property(0x10A01, 0x10A03, 'ID_Continue').	% Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
unicode_core_property(0x10A05, 0x10A06, 'ID_Continue').	% Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
unicode_core_property(0x10A0C, 0x10A0F, 'ID_Continue').	% Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
unicode_core_property(0x10A10, 0x10A13, 'ID_Continue').	% Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_core_property(0x10A15, 0x10A17, 'ID_Continue').	% Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_core_property(0x10A19, 0x10A33, 'ID_Continue').	% Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_core_property(0x10A38, 0x10A3A, 'ID_Continue').	% Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
unicode_core_property(0x10A3F, 0x10A3F, 'ID_Continue').	% Mn       KHAROSHTHI VIRAMA
unicode_core_property(0x10A60, 0x10A7C, 'ID_Continue').	% Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_core_property(0x10B00, 0x10B35, 'ID_Continue').	% Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_core_property(0x10B40, 0x10B55, 'ID_Continue').	% Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_core_property(0x10B60, 0x10B72, 'ID_Continue').	% Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_core_property(0x10C00, 0x10C48, 'ID_Continue').	% Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_core_property(0x11000, 0x11000, 'ID_Continue').	% Mc       BRAHMI SIGN CANDRABINDU
unicode_core_property(0x11001, 0x11001, 'ID_Continue').	% Mn       BRAHMI SIGN ANUSVARA
unicode_core_property(0x11002, 0x11002, 'ID_Continue').	% Mc       BRAHMI SIGN VISARGA
unicode_core_property(0x11003, 0x11037, 'ID_Continue').	% Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_core_property(0x11038, 0x11046, 'ID_Continue').	% Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
unicode_core_property(0x11066, 0x1106F, 'ID_Continue').	% Nd  [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
unicode_core_property(0x11080, 0x11081, 'ID_Continue').	% Mn   [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
unicode_core_property(0x11082, 0x11082, 'ID_Continue').	% Mc       KAITHI SIGN VISARGA
unicode_core_property(0x11083, 0x110AF, 'ID_Continue').	% Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_core_property(0x110B0, 0x110B2, 'ID_Continue').	% Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
unicode_core_property(0x110B3, 0x110B6, 'ID_Continue').	% Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
unicode_core_property(0x110B7, 0x110B8, 'ID_Continue').	% Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
unicode_core_property(0x110B9, 0x110BA, 'ID_Continue').	% Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
unicode_core_property(0x110D0, 0x110E8, 'ID_Continue').	% Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_core_property(0x110F0, 0x110F9, 'ID_Continue').	% Nd  [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
unicode_core_property(0x11100, 0x11102, 'ID_Continue').	% Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
unicode_core_property(0x11103, 0x11126, 'ID_Continue').	% Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_core_property(0x11127, 0x1112B, 'ID_Continue').	% Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
unicode_core_property(0x1112C, 0x1112C, 'ID_Continue').	% Mc       CHAKMA VOWEL SIGN E
unicode_core_property(0x1112D, 0x11134, 'ID_Continue').	% Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
unicode_core_property(0x11136, 0x1113F, 'ID_Continue').	% Nd  [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
unicode_core_property(0x11180, 0x11181, 'ID_Continue').	% Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
unicode_core_property(0x11182, 0x11182, 'ID_Continue').	% Mc       SHARADA SIGN VISARGA
unicode_core_property(0x11183, 0x111B2, 'ID_Continue').	% Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_core_property(0x111B3, 0x111B5, 'ID_Continue').	% Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
unicode_core_property(0x111B6, 0x111BE, 'ID_Continue').	% Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
unicode_core_property(0x111BF, 0x111C0, 'ID_Continue').	% Mc   [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
unicode_core_property(0x111C1, 0x111C4, 'ID_Continue').	% Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_core_property(0x111D0, 0x111D9, 'ID_Continue').	% Nd  [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
unicode_core_property(0x11680, 0x116AA, 'ID_Continue').	% Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_core_property(0x116AB, 0x116AB, 'ID_Continue').	% Mn       TAKRI SIGN ANUSVARA
unicode_core_property(0x116AC, 0x116AC, 'ID_Continue').	% Mc       TAKRI SIGN VISARGA
unicode_core_property(0x116AD, 0x116AD, 'ID_Continue').	% Mn       TAKRI VOWEL SIGN AA
unicode_core_property(0x116AE, 0x116AF, 'ID_Continue').	% Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
unicode_core_property(0x116B0, 0x116B5, 'ID_Continue').	% Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
unicode_core_property(0x116B6, 0x116B6, 'ID_Continue').	% Mc       TAKRI SIGN VIRAMA
unicode_core_property(0x116B7, 0x116B7, 'ID_Continue').	% Mn       TAKRI SIGN NUKTA
unicode_core_property(0x116C0, 0x116C9, 'ID_Continue').	% Nd  [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
unicode_core_property(0x12000, 0x1236E, 'ID_Continue').	% Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_core_property(0x12400, 0x12462, 'ID_Continue').	% Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_core_property(0x13000, 0x1342E, 'ID_Continue').	% Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_core_property(0x16800, 0x16A38, 'ID_Continue').	% Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_core_property(0x16F00, 0x16F44, 'ID_Continue').	% Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_core_property(0x16F50, 0x16F50, 'ID_Continue').	% Lo       MIAO LETTER NASALIZATION
unicode_core_property(0x16F51, 0x16F7E, 'ID_Continue').	% Mc  [46] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN NG
unicode_core_property(0x16F8F, 0x16F92, 'ID_Continue').	% Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
unicode_core_property(0x16F93, 0x16F9F, 'ID_Continue').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1B000, 0x1B001, 'ID_Continue').	% Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_core_property(0x1D165, 0x1D166, 'ID_Continue').	% Mc   [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
unicode_core_property(0x1D167, 0x1D169, 'ID_Continue').	% Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
unicode_core_property(0x1D16D, 0x1D172, 'ID_Continue').	% Mc   [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
unicode_core_property(0x1D17B, 0x1D182, 'ID_Continue').	% Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
unicode_core_property(0x1D185, 0x1D18B, 'ID_Continue').	% Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
unicode_core_property(0x1D1AA, 0x1D1AD, 'ID_Continue').	% Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
unicode_core_property(0x1D242, 0x1D244, 'ID_Continue').	% Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
unicode_core_property(0x1D400, 0x1D454, 'ID_Continue').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'ID_Continue').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'ID_Continue').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'ID_Continue').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'ID_Continue').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'ID_Continue').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'ID_Continue').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'ID_Continue').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'ID_Continue').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'ID_Continue').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'ID_Continue').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'ID_Continue').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'ID_Continue').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'ID_Continue').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'ID_Continue').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'ID_Continue').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'ID_Continue').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'ID_Continue').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'ID_Continue').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'ID_Continue').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'ID_Continue').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'ID_Continue').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'ID_Continue').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'ID_Continue').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'ID_Continue').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'ID_Continue').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'ID_Continue').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'ID_Continue').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'ID_Continue').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'ID_Continue').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1D7CE, 0x1D7FF, 'ID_Continue').	% Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_core_property(0x1EE00, 0x1EE03, 'ID_Continue').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'ID_Continue').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'ID_Continue').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'ID_Continue').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'ID_Continue').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'ID_Continue').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'ID_Continue').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'ID_Continue').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'ID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'ID_Continue').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'ID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'ID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'ID_Continue').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'ID_Continue').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'ID_Continue').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'ID_Continue').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'ID_Continue').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'ID_Continue').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x20000, 0x2A6D6, 'ID_Continue').	% Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_core_property(0x2A700, 0x2B734, 'ID_Continue').	% Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_core_property(0x2B740, 0x2B81D, 'ID_Continue').	% Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_core_property(0x2F800, 0x2FA1D, 'ID_Continue').	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
unicode_core_property(0xE0100, 0xE01EF, 'ID_Continue').	% Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256

% Total code points: 103355

% ================================================

% Derived Property: XID_Start
%  ID_Start modified for closure under NFKx
%  Modified as described in UAX #15
%  NOTE: Does NOT remove the non-NFKx characters.
%        Merely ensures that if isIdentifer(string) then isIdentifier(NFKx(string))
%  NOTE: See UAX #31 for more information

unicode_core_property(0x0041, 0x005A, 'XID_Start').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x0061, 0x007A, 'XID_Start').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'XID_Start').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'XID_Start').	% L&       MICRO SIGN
unicode_core_property(0x00BA, 0x00BA, 'XID_Start').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'XID_Start').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'XID_Start').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'XID_Start').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'XID_Start').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'XID_Start').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'XID_Start').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'XID_Start').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'XID_Start').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'XID_Start').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'XID_Start').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C6, 0x02D1, 'XID_Start').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02E0, 0x02E4, 'XID_Start').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02EC, 0x02EC, 'XID_Start').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02EE, 0x02EE, 'XID_Start').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x0370, 0x0373, 'XID_Start').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'XID_Start').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'XID_Start').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037B, 0x037D, 'XID_Start').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'XID_Start').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0388, 0x038A, 'XID_Start').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'XID_Start').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'XID_Start').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'XID_Start').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'XID_Start').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x048A, 0x0527, 'XID_Start').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'XID_Start').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'XID_Start').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0561, 0x0587, 'XID_Start').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x05D0, 0x05EA, 'XID_Start').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'XID_Start').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x0620, 0x063F, 'XID_Start').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'XID_Start').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'XID_Start').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x066E, 0x066F, 'XID_Start').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0671, 0x06D3, 'XID_Start').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D5, 0x06D5, 'XID_Start').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06E5, 0x06E6, 'XID_Start').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06EE, 0x06EF, 'XID_Start').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06FA, 0x06FC, 'XID_Start').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FF, 0x06FF, 'XID_Start').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0710, 0x0710, 'XID_Start').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0712, 0x072F, 'XID_Start').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x074D, 0x07A5, 'XID_Start').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07B1, 0x07B1, 'XID_Start').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07CA, 0x07EA, 'XID_Start').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07F4, 0x07F5, 'XID_Start').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'XID_Start').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'XID_Start').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x081A, 0x081A, 'XID_Start').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x0824, 0x0824, 'XID_Start').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0828, 0x0828, 'XID_Start').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0840, 0x0858, 'XID_Start').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x08A0, 0x08A0, 'XID_Start').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'XID_Start').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x0904, 0x0939, 'XID_Start').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093D, 0x093D, 'XID_Start').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x0950, 0x0950, 'XID_Start').	% Lo       DEVANAGARI OM
unicode_core_property(0x0958, 0x0961, 'XID_Start').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0971, 0x0971, 'XID_Start').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'XID_Start').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'XID_Start').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0985, 0x098C, 'XID_Start').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'XID_Start').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'XID_Start').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'XID_Start').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'XID_Start').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'XID_Start').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BD, 0x09BD, 'XID_Start').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09CE, 0x09CE, 'XID_Start').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09DC, 0x09DD, 'XID_Start').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'XID_Start').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09F0, 0x09F1, 'XID_Start').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x0A05, 0x0A0A, 'XID_Start').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'XID_Start').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'XID_Start').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'XID_Start').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'XID_Start').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'XID_Start').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'XID_Start').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A59, 0x0A5C, 'XID_Start').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'XID_Start').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A72, 0x0A74, 'XID_Start').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A85, 0x0A8D, 'XID_Start').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'XID_Start').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'XID_Start').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'XID_Start').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'XID_Start').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'XID_Start').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABD, 0x0ABD, 'XID_Start').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0AD0, 0x0AD0, 'XID_Start').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'XID_Start').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0B05, 0x0B0C, 'XID_Start').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'XID_Start').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'XID_Start').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'XID_Start').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'XID_Start').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'XID_Start').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3D, 0x0B3D, 'XID_Start').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B5C, 0x0B5D, 'XID_Start').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'XID_Start').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B71, 0x0B71, 'XID_Start').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B83, 0x0B83, 'XID_Start').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'XID_Start').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'XID_Start').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'XID_Start').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'XID_Start').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'XID_Start').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'XID_Start').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'XID_Start').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'XID_Start').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'XID_Start').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BD0, 0x0BD0, 'XID_Start').	% Lo       TAMIL OM
unicode_core_property(0x0C05, 0x0C0C, 'XID_Start').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'XID_Start').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'XID_Start').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'XID_Start').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'XID_Start').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'XID_Start').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C58, 0x0C59, 'XID_Start').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'XID_Start').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C85, 0x0C8C, 'XID_Start').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'XID_Start').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'XID_Start').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'XID_Start').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'XID_Start').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBD, 0x0CBD, 'XID_Start').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CDE, 0x0CDE, 'XID_Start').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'XID_Start').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CF1, 0x0CF2, 'XID_Start').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D05, 0x0D0C, 'XID_Start').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'XID_Start').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'XID_Start').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'XID_Start').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D4E, 0x0D4E, 'XID_Start').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D60, 0x0D61, 'XID_Start').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D7A, 0x0D7F, 'XID_Start').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D85, 0x0D96, 'XID_Start').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'XID_Start').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'XID_Start').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'XID_Start').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'XID_Start').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0E01, 0x0E30, 'XID_Start').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E32, 0x0E32, 'XID_Start').	% Lo       THAI CHARACTER SARA AA
unicode_core_property(0x0E40, 0x0E45, 'XID_Start').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'XID_Start').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E81, 0x0E82, 'XID_Start').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'XID_Start').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'XID_Start').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'XID_Start').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'XID_Start').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'XID_Start').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'XID_Start').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'XID_Start').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'XID_Start').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'XID_Start').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'XID_Start').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'XID_Start').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB2, 0x0EB2, 'XID_Start').	% Lo       LAO VOWEL SIGN AA
unicode_core_property(0x0EBD, 0x0EBD, 'XID_Start').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'XID_Start').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'XID_Start').	% Lm       LAO KO LA
unicode_core_property(0x0EDC, 0x0EDF, 'XID_Start').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'XID_Start').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F40, 0x0F47, 'XID_Start').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'XID_Start').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F88, 0x0F8C, 'XID_Start').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x1000, 0x102A, 'XID_Start').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x103F, 0x103F, 'XID_Start').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1050, 0x1055, 'XID_Start').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x105A, 0x105D, 'XID_Start').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x1061, 0x1061, 'XID_Start').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1065, 0x1066, 'XID_Start').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x106E, 0x1070, 'XID_Start').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1075, 0x1081, 'XID_Start').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x108E, 0x108E, 'XID_Start').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x10A0, 0x10C5, 'XID_Start').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'XID_Start').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'XID_Start').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'XID_Start').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FC, 0x10FC, 'XID_Start').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'XID_Start').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'XID_Start').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'XID_Start').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'XID_Start').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'XID_Start').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'XID_Start').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'XID_Start').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'XID_Start').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'XID_Start').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x1380, 0x138F, 'XID_Start').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x13A0, 0x13F4, 'XID_Start').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1401, 0x166C, 'XID_Start').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166F, 0x167F, 'XID_Start').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1681, 0x169A, 'XID_Start').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x16A0, 0x16EA, 'XID_Start').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EE, 0x16F0, 'XID_Start').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'XID_Start').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'XID_Start').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1720, 0x1731, 'XID_Start').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1740, 0x1751, 'XID_Start').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1760, 0x176C, 'XID_Start').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'XID_Start').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1780, 0x17B3, 'XID_Start').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17D7, 0x17D7, 'XID_Start').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DC, 0x17DC, 'XID_Start').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x1820, 0x1842, 'XID_Start').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'XID_Start').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'XID_Start').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'XID_Start').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18AA, 0x18AA, 'XID_Start').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'XID_Start').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'XID_Start').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1950, 0x196D, 'XID_Start').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'XID_Start').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'XID_Start').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19C1, 0x19C7, 'XID_Start').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x1A00, 0x1A16, 'XID_Start').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A20, 0x1A54, 'XID_Start').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1AA7, 0x1AA7, 'XID_Start').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B05, 0x1B33, 'XID_Start').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B45, 0x1B4B, 'XID_Start').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B83, 0x1BA0, 'XID_Start').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BAE, 0x1BAF, 'XID_Start').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BBA, 0x1BE5, 'XID_Start').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1C00, 0x1C23, 'XID_Start').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C4D, 0x1C4F, 'XID_Start').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C5A, 0x1C77, 'XID_Start').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'XID_Start').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CE9, 0x1CEC, 'XID_Start').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_core_property(0x1CEE, 0x1CF1, 'XID_Start').	% Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_core_property(0x1CF5, 0x1CF6, 'XID_Start').	% Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_core_property(0x1D00, 0x1D2B, 'XID_Start').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'XID_Start').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'XID_Start').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'XID_Start').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'XID_Start').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'XID_Start').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1E00, 0x1F15, 'XID_Start').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'XID_Start').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'XID_Start').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'XID_Start').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'XID_Start').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'XID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'XID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'XID_Start').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'XID_Start').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'XID_Start').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'XID_Start').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'XID_Start').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'XID_Start').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'XID_Start').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'XID_Start').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'XID_Start').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'XID_Start').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'XID_Start').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'XID_Start').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x2071, 0x2071, 'XID_Start').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'XID_Start').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'XID_Start').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x2102, 0x2102, 'XID_Start').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'XID_Start').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'XID_Start').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'XID_Start').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2118, 0x2118, 'XID_Start').	% Sm       SCRIPT CAPITAL P
unicode_core_property(0x2119, 0x211D, 'XID_Start').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'XID_Start').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'XID_Start').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'XID_Start').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'XID_Start').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212E, 0x212E, 'XID_Start').	% So       ESTIMATED SYMBOL
unicode_core_property(0x212F, 0x2134, 'XID_Start').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'XID_Start').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x2139, 0x2139, 'XID_Start').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'XID_Start').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'XID_Start').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'XID_Start').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x2182, 'XID_Start').	% Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_core_property(0x2183, 0x2184, 'XID_Start').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x2185, 0x2188, 'XID_Start').	% Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_core_property(0x2C00, 0x2C2E, 'XID_Start').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'XID_Start').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'XID_Start').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'XID_Start').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'XID_Start').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'XID_Start').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CF2, 0x2CF3, 'XID_Start').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'XID_Start').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'XID_Start').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'XID_Start').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0x2D30, 0x2D67, 'XID_Start').	% Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_core_property(0x2D6F, 0x2D6F, 'XID_Start').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D80, 0x2D96, 'XID_Start').	% Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_core_property(0x2DA0, 0x2DA6, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_core_property(0x2DA8, 0x2DAE, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_core_property(0x2DB0, 0x2DB6, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_core_property(0x2DB8, 0x2DBE, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_core_property(0x2DC0, 0x2DC6, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_core_property(0x2DC8, 0x2DCE, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_core_property(0x2DD0, 0x2DD6, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_core_property(0x2DD8, 0x2DDE, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_core_property(0x3005, 0x3005, 'XID_Start').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3006, 0x3006, 'XID_Start').	% Lo       IDEOGRAPHIC CLOSING MARK
unicode_core_property(0x3007, 0x3007, 'XID_Start').	% Nl       IDEOGRAPHIC NUMBER ZERO
unicode_core_property(0x3021, 0x3029, 'XID_Start').	% Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_core_property(0x3031, 0x3035, 'XID_Start').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x3038, 0x303A, 'XID_Start').	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_core_property(0x303B, 0x303B, 'XID_Start').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x303C, 0x303C, 'XID_Start').	% Lo       MASU MARK
unicode_core_property(0x3041, 0x3096, 'XID_Start').	% Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_core_property(0x309D, 0x309E, 'XID_Start').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x309F, 0x309F, 'XID_Start').	% Lo       HIRAGANA DIGRAPH YORI
unicode_core_property(0x30A1, 0x30FA, 'XID_Start').	% Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_core_property(0x30FC, 0x30FE, 'XID_Start').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0x30FF, 0x30FF, 'XID_Start').	% Lo       KATAKANA DIGRAPH KOTO
unicode_core_property(0x3105, 0x312D, 'XID_Start').	% Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_core_property(0x3131, 0x318E, 'XID_Start').	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_core_property(0x31A0, 0x31BA, 'XID_Start').	% Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_core_property(0x31F0, 0x31FF, 'XID_Start').	% Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_core_property(0x3400, 0x4DB5, 'XID_Start').	% Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_core_property(0x4E00, 0x9FCC, 'XID_Start').	% Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_core_property(0xA000, 0xA014, 'XID_Start').	% Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_core_property(0xA015, 0xA015, 'XID_Start').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA016, 0xA48C, 'XID_Start').	% Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_core_property(0xA4D0, 0xA4F7, 'XID_Start').	% Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_core_property(0xA4F8, 0xA4FD, 'XID_Start').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA500, 0xA60B, 'XID_Start').	% Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_core_property(0xA60C, 0xA60C, 'XID_Start').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA610, 0xA61F, 'XID_Start').	% Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_core_property(0xA62A, 0xA62B, 'XID_Start').	% Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_core_property(0xA640, 0xA66D, 'XID_Start').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA66E, 0xA66E, 'XID_Start').	% Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_core_property(0xA67F, 0xA67F, 'XID_Start').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA680, 0xA697, 'XID_Start').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA6A0, 0xA6E5, 'XID_Start').	% Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_core_property(0xA6E6, 0xA6EF, 'XID_Start').	% Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_core_property(0xA717, 0xA71F, 'XID_Start').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA722, 0xA76F, 'XID_Start').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'XID_Start').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'XID_Start').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA788, 0xA788, 'XID_Start').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA78B, 0xA78E, 'XID_Start').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'XID_Start').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'XID_Start').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'XID_Start').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'XID_Start').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xA7FB, 0xA801, 'XID_Start').	% Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_core_property(0xA803, 0xA805, 'XID_Start').	% Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_core_property(0xA807, 0xA80A, 'XID_Start').	% Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_core_property(0xA80C, 0xA822, 'XID_Start').	% Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_core_property(0xA840, 0xA873, 'XID_Start').	% Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_core_property(0xA882, 0xA8B3, 'XID_Start').	% Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_core_property(0xA8F2, 0xA8F7, 'XID_Start').	% Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_core_property(0xA8FB, 0xA8FB, 'XID_Start').	% Lo       DEVANAGARI HEADSTROKE
unicode_core_property(0xA90A, 0xA925, 'XID_Start').	% Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_core_property(0xA930, 0xA946, 'XID_Start').	% Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_core_property(0xA960, 0xA97C, 'XID_Start').	% Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_core_property(0xA984, 0xA9B2, 'XID_Start').	% Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_core_property(0xA9CF, 0xA9CF, 'XID_Start').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xAA00, 0xAA28, 'XID_Start').	% Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_core_property(0xAA40, 0xAA42, 'XID_Start').	% Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_core_property(0xAA44, 0xAA4B, 'XID_Start').	% Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_core_property(0xAA60, 0xAA6F, 'XID_Start').	% Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_core_property(0xAA70, 0xAA70, 'XID_Start').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAA71, 0xAA76, 'XID_Start').	% Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_core_property(0xAA7A, 0xAA7A, 'XID_Start').	% Lo       MYANMAR LETTER AITON RA
unicode_core_property(0xAA80, 0xAAAF, 'XID_Start').	% Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_core_property(0xAAB1, 0xAAB1, 'XID_Start').	% Lo       TAI VIET VOWEL AA
unicode_core_property(0xAAB5, 0xAAB6, 'XID_Start').	% Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_core_property(0xAAB9, 0xAABD, 'XID_Start').	% Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_core_property(0xAAC0, 0xAAC0, 'XID_Start').	% Lo       TAI VIET TONE MAI NUENG
unicode_core_property(0xAAC2, 0xAAC2, 'XID_Start').	% Lo       TAI VIET TONE MAI SONG
unicode_core_property(0xAADB, 0xAADC, 'XID_Start').	% Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_core_property(0xAADD, 0xAADD, 'XID_Start').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAE0, 0xAAEA, 'XID_Start').	% Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_core_property(0xAAF2, 0xAAF2, 'XID_Start').	% Lo       MEETEI MAYEK ANJI
unicode_core_property(0xAAF3, 0xAAF4, 'XID_Start').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAB01, 0xAB06, 'XID_Start').	% Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_core_property(0xAB09, 0xAB0E, 'XID_Start').	% Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_core_property(0xAB11, 0xAB16, 'XID_Start').	% Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_core_property(0xAB20, 0xAB26, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_core_property(0xAB28, 0xAB2E, 'XID_Start').	% Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_core_property(0xABC0, 0xABE2, 'XID_Start').	% Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_core_property(0xAC00, 0xD7A3, 'XID_Start').	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_core_property(0xD7B0, 0xD7C6, 'XID_Start').	% Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_core_property(0xD7CB, 0xD7FB, 'XID_Start').	% Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_core_property(0xF900, 0xFA6D, 'XID_Start').	% Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_core_property(0xFA70, 0xFAD9, 'XID_Start').	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_core_property(0xFB00, 0xFB06, 'XID_Start').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'XID_Start').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFB1D, 0xFB1D, 'XID_Start').	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_core_property(0xFB1F, 0xFB28, 'XID_Start').	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_core_property(0xFB2A, 0xFB36, 'XID_Start').	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_core_property(0xFB38, 0xFB3C, 'XID_Start').	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_core_property(0xFB3E, 0xFB3E, 'XID_Start').	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_core_property(0xFB40, 0xFB41, 'XID_Start').	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_core_property(0xFB43, 0xFB44, 'XID_Start').	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_core_property(0xFB46, 0xFBB1, 'XID_Start').	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_core_property(0xFBD3, 0xFC5D, 'XID_Start').	% Lo [139] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
unicode_core_property(0xFC64, 0xFD3D, 'XID_Start').	% Lo [218] ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_core_property(0xFD50, 0xFD8F, 'XID_Start').	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_core_property(0xFD92, 0xFDC7, 'XID_Start').	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_core_property(0xFDF0, 0xFDF9, 'XID_Start').	% Lo  [10] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE SALLA ISOLATED FORM
unicode_core_property(0xFE71, 0xFE71, 'XID_Start').	% Lo       ARABIC TATWEEL WITH FATHATAN ABOVE
unicode_core_property(0xFE73, 0xFE73, 'XID_Start').	% Lo       ARABIC TAIL FRAGMENT
unicode_core_property(0xFE77, 0xFE77, 'XID_Start').	% Lo       ARABIC FATHA MEDIAL FORM
unicode_core_property(0xFE79, 0xFE79, 'XID_Start').	% Lo       ARABIC DAMMA MEDIAL FORM
unicode_core_property(0xFE7B, 0xFE7B, 'XID_Start').	% Lo       ARABIC KASRA MEDIAL FORM
unicode_core_property(0xFE7D, 0xFE7D, 'XID_Start').	% Lo       ARABIC SHADDA MEDIAL FORM
unicode_core_property(0xFE7F, 0xFEFC, 'XID_Start').	% Lo [126] ARABIC SUKUN MEDIAL FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_core_property(0xFF21, 0xFF3A, 'XID_Start').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF41, 0xFF5A, 'XID_Start').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0xFF66, 0xFF6F, 'XID_Start').	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_core_property(0xFF70, 0xFF70, 'XID_Start').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF71, 0xFF9D, 'XID_Start').	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_core_property(0xFFA0, 0xFFBE, 'XID_Start').	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_core_property(0xFFC2, 0xFFC7, 'XID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_core_property(0xFFCA, 0xFFCF, 'XID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_core_property(0xFFD2, 0xFFD7, 'XID_Start').	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_core_property(0xFFDA, 0xFFDC, 'XID_Start').	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_core_property(0x10000, 0x1000B, 'XID_Start').	% Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_core_property(0x1000D, 0x10026, 'XID_Start').	% Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_core_property(0x10028, 0x1003A, 'XID_Start').	% Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_core_property(0x1003C, 0x1003D, 'XID_Start').	% Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_core_property(0x1003F, 0x1004D, 'XID_Start').	% Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_core_property(0x10050, 0x1005D, 'XID_Start').	% Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_core_property(0x10080, 0x100FA, 'XID_Start').	% Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_core_property(0x10140, 0x10174, 'XID_Start').	% Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_core_property(0x10280, 0x1029C, 'XID_Start').	% Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_core_property(0x102A0, 0x102D0, 'XID_Start').	% Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_core_property(0x10300, 0x1031E, 'XID_Start').	% Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_core_property(0x10330, 0x10340, 'XID_Start').	% Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_core_property(0x10341, 0x10341, 'XID_Start').	% Nl       GOTHIC LETTER NINETY
unicode_core_property(0x10342, 0x10349, 'XID_Start').	% Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_core_property(0x1034A, 0x1034A, 'XID_Start').	% Nl       GOTHIC LETTER NINE HUNDRED
unicode_core_property(0x10380, 0x1039D, 'XID_Start').	% Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_core_property(0x103A0, 0x103C3, 'XID_Start').	% Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_core_property(0x103C8, 0x103CF, 'XID_Start').	% Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_core_property(0x103D1, 0x103D5, 'XID_Start').	% Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_core_property(0x10400, 0x1044F, 'XID_Start').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x10450, 0x1049D, 'XID_Start').	% Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_core_property(0x10800, 0x10805, 'XID_Start').	% Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_core_property(0x10808, 0x10808, 'XID_Start').	% Lo       CYPRIOT SYLLABLE JO
unicode_core_property(0x1080A, 0x10835, 'XID_Start').	% Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_core_property(0x10837, 0x10838, 'XID_Start').	% Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_core_property(0x1083C, 0x1083C, 'XID_Start').	% Lo       CYPRIOT SYLLABLE ZA
unicode_core_property(0x1083F, 0x10855, 'XID_Start').	% Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_core_property(0x10900, 0x10915, 'XID_Start').	% Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_core_property(0x10920, 0x10939, 'XID_Start').	% Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_core_property(0x10980, 0x109B7, 'XID_Start').	% Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_core_property(0x109BE, 0x109BF, 'XID_Start').	% Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_core_property(0x10A00, 0x10A00, 'XID_Start').	% Lo       KHAROSHTHI LETTER A
unicode_core_property(0x10A10, 0x10A13, 'XID_Start').	% Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_core_property(0x10A15, 0x10A17, 'XID_Start').	% Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_core_property(0x10A19, 0x10A33, 'XID_Start').	% Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_core_property(0x10A60, 0x10A7C, 'XID_Start').	% Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_core_property(0x10B00, 0x10B35, 'XID_Start').	% Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_core_property(0x10B40, 0x10B55, 'XID_Start').	% Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_core_property(0x10B60, 0x10B72, 'XID_Start').	% Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_core_property(0x10C00, 0x10C48, 'XID_Start').	% Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_core_property(0x11003, 0x11037, 'XID_Start').	% Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_core_property(0x11083, 0x110AF, 'XID_Start').	% Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_core_property(0x110D0, 0x110E8, 'XID_Start').	% Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_core_property(0x11103, 0x11126, 'XID_Start').	% Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_core_property(0x11183, 0x111B2, 'XID_Start').	% Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_core_property(0x111C1, 0x111C4, 'XID_Start').	% Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_core_property(0x11680, 0x116AA, 'XID_Start').	% Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_core_property(0x12000, 0x1236E, 'XID_Start').	% Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_core_property(0x12400, 0x12462, 'XID_Start').	% Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_core_property(0x13000, 0x1342E, 'XID_Start').	% Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_core_property(0x16800, 0x16A38, 'XID_Start').	% Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_core_property(0x16F00, 0x16F44, 'XID_Start').	% Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_core_property(0x16F50, 0x16F50, 'XID_Start').	% Lo       MIAO LETTER NASALIZATION
unicode_core_property(0x16F93, 0x16F9F, 'XID_Start').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1B000, 0x1B001, 'XID_Start').	% Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_core_property(0x1D400, 0x1D454, 'XID_Start').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'XID_Start').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'XID_Start').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'XID_Start').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'XID_Start').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'XID_Start').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'XID_Start').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'XID_Start').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'XID_Start').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'XID_Start').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'XID_Start').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'XID_Start').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'XID_Start').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'XID_Start').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'XID_Start').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'XID_Start').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'XID_Start').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'XID_Start').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'XID_Start').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'XID_Start').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'XID_Start').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'XID_Start').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'XID_Start').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'XID_Start').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'XID_Start').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'XID_Start').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'XID_Start').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'XID_Start').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'XID_Start').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'XID_Start').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1EE00, 0x1EE03, 'XID_Start').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'XID_Start').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'XID_Start').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'XID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'XID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'XID_Start').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'XID_Start').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'XID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'XID_Start').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'XID_Start').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'XID_Start').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'XID_Start').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'XID_Start').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'XID_Start').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'XID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'XID_Start').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'XID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'XID_Start').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'XID_Start').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'XID_Start').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'XID_Start').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'XID_Start').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'XID_Start').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'XID_Start').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x20000, 0x2A6D6, 'XID_Start').	% Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_core_property(0x2A700, 0x2B734, 'XID_Start').	% Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_core_property(0x2B740, 0x2B81D, 'XID_Start').	% Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_core_property(0x2F800, 0x2FA1D, 'XID_Start').	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D

% Total code points: 101217

% ================================================

% Derived Property: XID_Continue
%  Mod_ID_Continue modified for closure under NFKx
%  Modified as described in UAX #15
%  NOTE: Does NOT remove the non-NFKx characters.
%        Merely ensures that if isIdentifer(string) then isIdentifier(NFKx(string))
%  NOTE: See UAX #31 for more information

unicode_core_property(0x0030, 0x0039, 'XID_Continue').	% Nd  [10] DIGIT ZERO..DIGIT NINE
unicode_core_property(0x0041, 0x005A, 'XID_Continue').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x005F, 0x005F, 'XID_Continue').	% Pc       LOW LINE
unicode_core_property(0x0061, 0x007A, 'XID_Continue').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x00AA, 0x00AA, 'XID_Continue').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00B5, 0x00B5, 'XID_Continue').	% L&       MICRO SIGN
unicode_core_property(0x00B7, 0x00B7, 'XID_Continue').	% Po       MIDDLE DOT
unicode_core_property(0x00BA, 0x00BA, 'XID_Continue').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00C0, 0x00D6, 'XID_Continue').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D8, 0x00F6, 'XID_Continue').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F8, 0x01BA, 'XID_Continue').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'XID_Continue').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'XID_Continue').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'XID_Continue').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'XID_Continue').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'XID_Continue').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'XID_Continue').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'XID_Continue').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C6, 0x02D1, 'XID_Continue').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02E0, 0x02E4, 'XID_Continue').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02EC, 0x02EC, 'XID_Continue').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02EE, 0x02EE, 'XID_Continue').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x0300, 0x036F, 'XID_Continue').	% Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
unicode_core_property(0x0370, 0x0373, 'XID_Continue').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'XID_Continue').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'XID_Continue').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037B, 0x037D, 'XID_Continue').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x0386, 0x0386, 'XID_Continue').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0387, 0x0387, 'XID_Continue').	% Po       GREEK ANO TELEIA
unicode_core_property(0x0388, 0x038A, 'XID_Continue').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'XID_Continue').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'XID_Continue').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'XID_Continue').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'XID_Continue').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x0483, 0x0487, 'XID_Continue').	% Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
unicode_core_property(0x048A, 0x0527, 'XID_Continue').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'XID_Continue').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'XID_Continue').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x0561, 0x0587, 'XID_Continue').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x0591, 0x05BD, 'XID_Continue').	% Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
unicode_core_property(0x05BF, 0x05BF, 'XID_Continue').	% Mn       HEBREW POINT RAFE
unicode_core_property(0x05C1, 0x05C2, 'XID_Continue').	% Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
unicode_core_property(0x05C4, 0x05C5, 'XID_Continue').	% Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
unicode_core_property(0x05C7, 0x05C7, 'XID_Continue').	% Mn       HEBREW POINT QAMATS QATAN
unicode_core_property(0x05D0, 0x05EA, 'XID_Continue').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'XID_Continue').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x0610, 0x061A, 'XID_Continue').	% Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
unicode_core_property(0x0620, 0x063F, 'XID_Continue').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'XID_Continue').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'XID_Continue').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x064B, 0x065F, 'XID_Continue').	% Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
unicode_core_property(0x0660, 0x0669, 'XID_Continue').	% Nd  [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
unicode_core_property(0x066E, 0x066F, 'XID_Continue').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0670, 0x0670, 'XID_Continue').	% Mn       ARABIC LETTER SUPERSCRIPT ALEF
unicode_core_property(0x0671, 0x06D3, 'XID_Continue').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D5, 0x06D5, 'XID_Continue').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06D6, 0x06DC, 'XID_Continue').	% Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
unicode_core_property(0x06DF, 0x06E4, 'XID_Continue').	% Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
unicode_core_property(0x06E5, 0x06E6, 'XID_Continue').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06E7, 0x06E8, 'XID_Continue').	% Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
unicode_core_property(0x06EA, 0x06ED, 'XID_Continue').	% Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
unicode_core_property(0x06EE, 0x06EF, 'XID_Continue').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06F0, 0x06F9, 'XID_Continue').	% Nd  [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
unicode_core_property(0x06FA, 0x06FC, 'XID_Continue').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FF, 0x06FF, 'XID_Continue').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0710, 0x0710, 'XID_Continue').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0711, 0x0711, 'XID_Continue').	% Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
unicode_core_property(0x0712, 0x072F, 'XID_Continue').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x0730, 0x074A, 'XID_Continue').	% Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
unicode_core_property(0x074D, 0x07A5, 'XID_Continue').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07A6, 0x07B0, 'XID_Continue').	% Mn  [11] THAANA ABAFILI..THAANA SUKUN
unicode_core_property(0x07B1, 0x07B1, 'XID_Continue').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07C0, 0x07C9, 'XID_Continue').	% Nd  [10] NKO DIGIT ZERO..NKO DIGIT NINE
unicode_core_property(0x07CA, 0x07EA, 'XID_Continue').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07EB, 0x07F3, 'XID_Continue').	% Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
unicode_core_property(0x07F4, 0x07F5, 'XID_Continue').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07FA, 0x07FA, 'XID_Continue').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'XID_Continue').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x0816, 0x0819, 'XID_Continue').	% Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
unicode_core_property(0x081A, 0x081A, 'XID_Continue').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x081B, 0x0823, 'XID_Continue').	% Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
unicode_core_property(0x0824, 0x0824, 'XID_Continue').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0825, 0x0827, 'XID_Continue').	% Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
unicode_core_property(0x0828, 0x0828, 'XID_Continue').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0829, 0x082D, 'XID_Continue').	% Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
unicode_core_property(0x0840, 0x0858, 'XID_Continue').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x0859, 0x085B, 'XID_Continue').	% Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
unicode_core_property(0x08A0, 0x08A0, 'XID_Continue').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'XID_Continue').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x08E4, 0x08FE, 'XID_Continue').	% Mn  [27] ARABIC CURLY FATHA..ARABIC DAMMA WITH DOT
unicode_core_property(0x0900, 0x0902, 'XID_Continue').	% Mn   [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
unicode_core_property(0x0903, 0x0903, 'XID_Continue').	% Mc       DEVANAGARI SIGN VISARGA
unicode_core_property(0x0904, 0x0939, 'XID_Continue').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093A, 0x093A, 'XID_Continue').	% Mn       DEVANAGARI VOWEL SIGN OE
unicode_core_property(0x093B, 0x093B, 'XID_Continue').	% Mc       DEVANAGARI VOWEL SIGN OOE
unicode_core_property(0x093C, 0x093C, 'XID_Continue').	% Mn       DEVANAGARI SIGN NUKTA
unicode_core_property(0x093D, 0x093D, 'XID_Continue').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x093E, 0x0940, 'XID_Continue').	% Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
unicode_core_property(0x0941, 0x0948, 'XID_Continue').	% Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
unicode_core_property(0x0949, 0x094C, 'XID_Continue').	% Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
unicode_core_property(0x094D, 0x094D, 'XID_Continue').	% Mn       DEVANAGARI SIGN VIRAMA
unicode_core_property(0x094E, 0x094F, 'XID_Continue').	% Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
unicode_core_property(0x0950, 0x0950, 'XID_Continue').	% Lo       DEVANAGARI OM
unicode_core_property(0x0951, 0x0957, 'XID_Continue').	% Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
unicode_core_property(0x0958, 0x0961, 'XID_Continue').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0962, 0x0963, 'XID_Continue').	% Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0966, 0x096F, 'XID_Continue').	% Nd  [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
unicode_core_property(0x0971, 0x0971, 'XID_Continue').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'XID_Continue').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'XID_Continue').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0981, 0x0981, 'XID_Continue').	% Mn       BENGALI SIGN CANDRABINDU
unicode_core_property(0x0982, 0x0983, 'XID_Continue').	% Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
unicode_core_property(0x0985, 0x098C, 'XID_Continue').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'XID_Continue').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'XID_Continue').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'XID_Continue').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'XID_Continue').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'XID_Continue').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BC, 0x09BC, 'XID_Continue').	% Mn       BENGALI SIGN NUKTA
unicode_core_property(0x09BD, 0x09BD, 'XID_Continue').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09BE, 0x09C0, 'XID_Continue').	% Mc   [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
unicode_core_property(0x09C1, 0x09C4, 'XID_Continue').	% Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
unicode_core_property(0x09C7, 0x09C8, 'XID_Continue').	% Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
unicode_core_property(0x09CB, 0x09CC, 'XID_Continue').	% Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
unicode_core_property(0x09CD, 0x09CD, 'XID_Continue').	% Mn       BENGALI SIGN VIRAMA
unicode_core_property(0x09CE, 0x09CE, 'XID_Continue').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09D7, 0x09D7, 'XID_Continue').	% Mc       BENGALI AU LENGTH MARK
unicode_core_property(0x09DC, 0x09DD, 'XID_Continue').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'XID_Continue').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09E2, 0x09E3, 'XID_Continue').	% Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
unicode_core_property(0x09E6, 0x09EF, 'XID_Continue').	% Nd  [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
unicode_core_property(0x09F0, 0x09F1, 'XID_Continue').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x0A01, 0x0A02, 'XID_Continue').	% Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
unicode_core_property(0x0A03, 0x0A03, 'XID_Continue').	% Mc       GURMUKHI SIGN VISARGA
unicode_core_property(0x0A05, 0x0A0A, 'XID_Continue').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'XID_Continue').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'XID_Continue').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'XID_Continue').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'XID_Continue').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'XID_Continue').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'XID_Continue').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A3C, 0x0A3C, 'XID_Continue').	% Mn       GURMUKHI SIGN NUKTA
unicode_core_property(0x0A3E, 0x0A40, 'XID_Continue').	% Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
unicode_core_property(0x0A41, 0x0A42, 'XID_Continue').	% Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
unicode_core_property(0x0A47, 0x0A48, 'XID_Continue').	% Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
unicode_core_property(0x0A4B, 0x0A4D, 'XID_Continue').	% Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
unicode_core_property(0x0A51, 0x0A51, 'XID_Continue').	% Mn       GURMUKHI SIGN UDAAT
unicode_core_property(0x0A59, 0x0A5C, 'XID_Continue').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'XID_Continue').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A66, 0x0A6F, 'XID_Continue').	% Nd  [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
unicode_core_property(0x0A70, 0x0A71, 'XID_Continue').	% Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
unicode_core_property(0x0A72, 0x0A74, 'XID_Continue').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A75, 0x0A75, 'XID_Continue').	% Mn       GURMUKHI SIGN YAKASH
unicode_core_property(0x0A81, 0x0A82, 'XID_Continue').	% Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
unicode_core_property(0x0A83, 0x0A83, 'XID_Continue').	% Mc       GUJARATI SIGN VISARGA
unicode_core_property(0x0A85, 0x0A8D, 'XID_Continue').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'XID_Continue').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'XID_Continue').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'XID_Continue').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'XID_Continue').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'XID_Continue').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABC, 0x0ABC, 'XID_Continue').	% Mn       GUJARATI SIGN NUKTA
unicode_core_property(0x0ABD, 0x0ABD, 'XID_Continue').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0ABE, 0x0AC0, 'XID_Continue').	% Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
unicode_core_property(0x0AC1, 0x0AC5, 'XID_Continue').	% Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
unicode_core_property(0x0AC7, 0x0AC8, 'XID_Continue').	% Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
unicode_core_property(0x0AC9, 0x0AC9, 'XID_Continue').	% Mc       GUJARATI VOWEL SIGN CANDRA O
unicode_core_property(0x0ACB, 0x0ACC, 'XID_Continue').	% Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
unicode_core_property(0x0ACD, 0x0ACD, 'XID_Continue').	% Mn       GUJARATI SIGN VIRAMA
unicode_core_property(0x0AD0, 0x0AD0, 'XID_Continue').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'XID_Continue').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0AE2, 0x0AE3, 'XID_Continue').	% Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0AE6, 0x0AEF, 'XID_Continue').	% Nd  [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
unicode_core_property(0x0B01, 0x0B01, 'XID_Continue').	% Mn       ORIYA SIGN CANDRABINDU
unicode_core_property(0x0B02, 0x0B03, 'XID_Continue').	% Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
unicode_core_property(0x0B05, 0x0B0C, 'XID_Continue').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'XID_Continue').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'XID_Continue').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'XID_Continue').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'XID_Continue').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'XID_Continue').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3C, 0x0B3C, 'XID_Continue').	% Mn       ORIYA SIGN NUKTA
unicode_core_property(0x0B3D, 0x0B3D, 'XID_Continue').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B3E, 0x0B3E, 'XID_Continue').	% Mc       ORIYA VOWEL SIGN AA
unicode_core_property(0x0B3F, 0x0B3F, 'XID_Continue').	% Mn       ORIYA VOWEL SIGN I
unicode_core_property(0x0B40, 0x0B40, 'XID_Continue').	% Mc       ORIYA VOWEL SIGN II
unicode_core_property(0x0B41, 0x0B44, 'XID_Continue').	% Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0B47, 0x0B48, 'XID_Continue').	% Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
unicode_core_property(0x0B4B, 0x0B4C, 'XID_Continue').	% Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
unicode_core_property(0x0B4D, 0x0B4D, 'XID_Continue').	% Mn       ORIYA SIGN VIRAMA
unicode_core_property(0x0B56, 0x0B56, 'XID_Continue').	% Mn       ORIYA AI LENGTH MARK
unicode_core_property(0x0B57, 0x0B57, 'XID_Continue').	% Mc       ORIYA AU LENGTH MARK
unicode_core_property(0x0B5C, 0x0B5D, 'XID_Continue').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'XID_Continue').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B62, 0x0B63, 'XID_Continue').	% Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B66, 0x0B6F, 'XID_Continue').	% Nd  [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
unicode_core_property(0x0B71, 0x0B71, 'XID_Continue').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B82, 0x0B82, 'XID_Continue').	% Mn       TAMIL SIGN ANUSVARA
unicode_core_property(0x0B83, 0x0B83, 'XID_Continue').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'XID_Continue').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'XID_Continue').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'XID_Continue').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'XID_Continue').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'XID_Continue').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'XID_Continue').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'XID_Continue').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'XID_Continue').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'XID_Continue').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BBE, 0x0BBF, 'XID_Continue').	% Mc   [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
unicode_core_property(0x0BC0, 0x0BC0, 'XID_Continue').	% Mn       TAMIL VOWEL SIGN II
unicode_core_property(0x0BC1, 0x0BC2, 'XID_Continue').	% Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
unicode_core_property(0x0BC6, 0x0BC8, 'XID_Continue').	% Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
unicode_core_property(0x0BCA, 0x0BCC, 'XID_Continue').	% Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
unicode_core_property(0x0BCD, 0x0BCD, 'XID_Continue').	% Mn       TAMIL SIGN VIRAMA
unicode_core_property(0x0BD0, 0x0BD0, 'XID_Continue').	% Lo       TAMIL OM
unicode_core_property(0x0BD7, 0x0BD7, 'XID_Continue').	% Mc       TAMIL AU LENGTH MARK
unicode_core_property(0x0BE6, 0x0BEF, 'XID_Continue').	% Nd  [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
unicode_core_property(0x0C01, 0x0C03, 'XID_Continue').	% Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
unicode_core_property(0x0C05, 0x0C0C, 'XID_Continue').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'XID_Continue').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'XID_Continue').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'XID_Continue').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'XID_Continue').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'XID_Continue').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C3E, 0x0C40, 'XID_Continue').	% Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
unicode_core_property(0x0C41, 0x0C44, 'XID_Continue').	% Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
unicode_core_property(0x0C46, 0x0C48, 'XID_Continue').	% Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
unicode_core_property(0x0C4A, 0x0C4D, 'XID_Continue').	% Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
unicode_core_property(0x0C55, 0x0C56, 'XID_Continue').	% Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
unicode_core_property(0x0C58, 0x0C59, 'XID_Continue').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'XID_Continue').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C62, 0x0C63, 'XID_Continue').	% Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
unicode_core_property(0x0C66, 0x0C6F, 'XID_Continue').	% Nd  [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
unicode_core_property(0x0C82, 0x0C83, 'XID_Continue').	% Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
unicode_core_property(0x0C85, 0x0C8C, 'XID_Continue').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'XID_Continue').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'XID_Continue').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'XID_Continue').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'XID_Continue').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBC, 0x0CBC, 'XID_Continue').	% Mn       KANNADA SIGN NUKTA
unicode_core_property(0x0CBD, 0x0CBD, 'XID_Continue').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CBE, 0x0CBE, 'XID_Continue').	% Mc       KANNADA VOWEL SIGN AA
unicode_core_property(0x0CBF, 0x0CBF, 'XID_Continue').	% Mn       KANNADA VOWEL SIGN I
unicode_core_property(0x0CC0, 0x0CC4, 'XID_Continue').	% Mc   [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0CC6, 0x0CC6, 'XID_Continue').	% Mn       KANNADA VOWEL SIGN E
unicode_core_property(0x0CC7, 0x0CC8, 'XID_Continue').	% Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
unicode_core_property(0x0CCA, 0x0CCB, 'XID_Continue').	% Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
unicode_core_property(0x0CCC, 0x0CCD, 'XID_Continue').	% Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
unicode_core_property(0x0CD5, 0x0CD6, 'XID_Continue').	% Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
unicode_core_property(0x0CDE, 0x0CDE, 'XID_Continue').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'XID_Continue').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CE2, 0x0CE3, 'XID_Continue').	% Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0CE6, 0x0CEF, 'XID_Continue').	% Nd  [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
unicode_core_property(0x0CF1, 0x0CF2, 'XID_Continue').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D02, 0x0D03, 'XID_Continue').	% Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
unicode_core_property(0x0D05, 0x0D0C, 'XID_Continue').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'XID_Continue').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'XID_Continue').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'XID_Continue').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D3E, 0x0D40, 'XID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
unicode_core_property(0x0D41, 0x0D44, 'XID_Continue').	% Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
unicode_core_property(0x0D46, 0x0D48, 'XID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
unicode_core_property(0x0D4A, 0x0D4C, 'XID_Continue').	% Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
unicode_core_property(0x0D4D, 0x0D4D, 'XID_Continue').	% Mn       MALAYALAM SIGN VIRAMA
unicode_core_property(0x0D4E, 0x0D4E, 'XID_Continue').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D57, 0x0D57, 'XID_Continue').	% Mc       MALAYALAM AU LENGTH MARK
unicode_core_property(0x0D60, 0x0D61, 'XID_Continue').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D62, 0x0D63, 'XID_Continue').	% Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
unicode_core_property(0x0D66, 0x0D6F, 'XID_Continue').	% Nd  [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
unicode_core_property(0x0D7A, 0x0D7F, 'XID_Continue').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D82, 0x0D83, 'XID_Continue').	% Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
unicode_core_property(0x0D85, 0x0D96, 'XID_Continue').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'XID_Continue').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'XID_Continue').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'XID_Continue').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'XID_Continue').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0DCA, 0x0DCA, 'XID_Continue').	% Mn       SINHALA SIGN AL-LAKUNA
unicode_core_property(0x0DCF, 0x0DD1, 'XID_Continue').	% Mc   [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
unicode_core_property(0x0DD2, 0x0DD4, 'XID_Continue').	% Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
unicode_core_property(0x0DD6, 0x0DD6, 'XID_Continue').	% Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
unicode_core_property(0x0DD8, 0x0DDF, 'XID_Continue').	% Mc   [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
unicode_core_property(0x0DF2, 0x0DF3, 'XID_Continue').	% Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
unicode_core_property(0x0E01, 0x0E30, 'XID_Continue').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E31, 0x0E31, 'XID_Continue').	% Mn       THAI CHARACTER MAI HAN-AKAT
unicode_core_property(0x0E32, 0x0E33, 'XID_Continue').	% Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_core_property(0x0E34, 0x0E3A, 'XID_Continue').	% Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
unicode_core_property(0x0E40, 0x0E45, 'XID_Continue').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'XID_Continue').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E47, 0x0E4E, 'XID_Continue').	% Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
unicode_core_property(0x0E50, 0x0E59, 'XID_Continue').	% Nd  [10] THAI DIGIT ZERO..THAI DIGIT NINE
unicode_core_property(0x0E81, 0x0E82, 'XID_Continue').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'XID_Continue').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'XID_Continue').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'XID_Continue').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'XID_Continue').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'XID_Continue').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'XID_Continue').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'XID_Continue').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'XID_Continue').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'XID_Continue').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'XID_Continue').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'XID_Continue').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB1, 0x0EB1, 'XID_Continue').	% Mn       LAO VOWEL SIGN MAI KAN
unicode_core_property(0x0EB2, 0x0EB3, 'XID_Continue').	% Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_core_property(0x0EB4, 0x0EB9, 'XID_Continue').	% Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
unicode_core_property(0x0EBB, 0x0EBC, 'XID_Continue').	% Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
unicode_core_property(0x0EBD, 0x0EBD, 'XID_Continue').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'XID_Continue').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'XID_Continue').	% Lm       LAO KO LA
unicode_core_property(0x0EC8, 0x0ECD, 'XID_Continue').	% Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
unicode_core_property(0x0ED0, 0x0ED9, 'XID_Continue').	% Nd  [10] LAO DIGIT ZERO..LAO DIGIT NINE
unicode_core_property(0x0EDC, 0x0EDF, 'XID_Continue').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'XID_Continue').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F18, 0x0F19, 'XID_Continue').	% Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
unicode_core_property(0x0F20, 0x0F29, 'XID_Continue').	% Nd  [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
unicode_core_property(0x0F35, 0x0F35, 'XID_Continue').	% Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
unicode_core_property(0x0F37, 0x0F37, 'XID_Continue').	% Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
unicode_core_property(0x0F39, 0x0F39, 'XID_Continue').	% Mn       TIBETAN MARK TSA -PHRU
unicode_core_property(0x0F3E, 0x0F3F, 'XID_Continue').	% Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
unicode_core_property(0x0F40, 0x0F47, 'XID_Continue').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'XID_Continue').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F71, 0x0F7E, 'XID_Continue').	% Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
unicode_core_property(0x0F7F, 0x0F7F, 'XID_Continue').	% Mc       TIBETAN SIGN RNAM BCAD
unicode_core_property(0x0F80, 0x0F84, 'XID_Continue').	% Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
unicode_core_property(0x0F86, 0x0F87, 'XID_Continue').	% Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
unicode_core_property(0x0F88, 0x0F8C, 'XID_Continue').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x0F8D, 0x0F97, 'XID_Continue').	% Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
unicode_core_property(0x0F99, 0x0FBC, 'XID_Continue').	% Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
unicode_core_property(0x0FC6, 0x0FC6, 'XID_Continue').	% Mn       TIBETAN SYMBOL PADMA GDAN
unicode_core_property(0x1000, 0x102A, 'XID_Continue').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x102B, 0x102C, 'XID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
unicode_core_property(0x102D, 0x1030, 'XID_Continue').	% Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
unicode_core_property(0x1031, 0x1031, 'XID_Continue').	% Mc       MYANMAR VOWEL SIGN E
unicode_core_property(0x1032, 0x1037, 'XID_Continue').	% Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
unicode_core_property(0x1038, 0x1038, 'XID_Continue').	% Mc       MYANMAR SIGN VISARGA
unicode_core_property(0x1039, 0x103A, 'XID_Continue').	% Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
unicode_core_property(0x103B, 0x103C, 'XID_Continue').	% Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
unicode_core_property(0x103D, 0x103E, 'XID_Continue').	% Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
unicode_core_property(0x103F, 0x103F, 'XID_Continue').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1040, 0x1049, 'XID_Continue').	% Nd  [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
unicode_core_property(0x1050, 0x1055, 'XID_Continue').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x1056, 0x1057, 'XID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
unicode_core_property(0x1058, 0x1059, 'XID_Continue').	% Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
unicode_core_property(0x105A, 0x105D, 'XID_Continue').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x105E, 0x1060, 'XID_Continue').	% Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
unicode_core_property(0x1061, 0x1061, 'XID_Continue').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1062, 0x1064, 'XID_Continue').	% Mc   [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
unicode_core_property(0x1065, 0x1066, 'XID_Continue').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x1067, 0x106D, 'XID_Continue').	% Mc   [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
unicode_core_property(0x106E, 0x1070, 'XID_Continue').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1071, 0x1074, 'XID_Continue').	% Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
unicode_core_property(0x1075, 0x1081, 'XID_Continue').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x1082, 0x1082, 'XID_Continue').	% Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
unicode_core_property(0x1083, 0x1084, 'XID_Continue').	% Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
unicode_core_property(0x1085, 0x1086, 'XID_Continue').	% Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
unicode_core_property(0x1087, 0x108C, 'XID_Continue').	% Mc   [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
unicode_core_property(0x108D, 0x108D, 'XID_Continue').	% Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
unicode_core_property(0x108E, 0x108E, 'XID_Continue').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x108F, 0x108F, 'XID_Continue').	% Mc       MYANMAR SIGN RUMAI PALAUNG TONE-5
unicode_core_property(0x1090, 0x1099, 'XID_Continue').	% Nd  [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
unicode_core_property(0x109A, 0x109C, 'XID_Continue').	% Mc   [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
unicode_core_property(0x109D, 0x109D, 'XID_Continue').	% Mn       MYANMAR VOWEL SIGN AITON AI
unicode_core_property(0x10A0, 0x10C5, 'XID_Continue').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'XID_Continue').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'XID_Continue').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'XID_Continue').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FC, 0x10FC, 'XID_Continue').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'XID_Continue').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'XID_Continue').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'XID_Continue').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'XID_Continue').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'XID_Continue').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'XID_Continue').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'XID_Continue').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'XID_Continue').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'XID_Continue').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x135D, 0x135F, 'XID_Continue').	% Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
unicode_core_property(0x1369, 0x1371, 'XID_Continue').	% No   [9] ETHIOPIC DIGIT ONE..ETHIOPIC DIGIT NINE
unicode_core_property(0x1380, 0x138F, 'XID_Continue').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x13A0, 0x13F4, 'XID_Continue').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1401, 0x166C, 'XID_Continue').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166F, 0x167F, 'XID_Continue').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1681, 0x169A, 'XID_Continue').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x16A0, 0x16EA, 'XID_Continue').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EE, 0x16F0, 'XID_Continue').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'XID_Continue').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'XID_Continue').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1712, 0x1714, 'XID_Continue').	% Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
unicode_core_property(0x1720, 0x1731, 'XID_Continue').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1732, 0x1734, 'XID_Continue').	% Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN PAMUDPOD
unicode_core_property(0x1740, 0x1751, 'XID_Continue').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1752, 0x1753, 'XID_Continue').	% Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
unicode_core_property(0x1760, 0x176C, 'XID_Continue').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'XID_Continue').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1772, 0x1773, 'XID_Continue').	% Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
unicode_core_property(0x1780, 0x17B3, 'XID_Continue').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17B4, 0x17B5, 'XID_Continue').	% Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
unicode_core_property(0x17B6, 0x17B6, 'XID_Continue').	% Mc       KHMER VOWEL SIGN AA
unicode_core_property(0x17B7, 0x17BD, 'XID_Continue').	% Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
unicode_core_property(0x17BE, 0x17C5, 'XID_Continue').	% Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
unicode_core_property(0x17C6, 0x17C6, 'XID_Continue').	% Mn       KHMER SIGN NIKAHIT
unicode_core_property(0x17C7, 0x17C8, 'XID_Continue').	% Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
unicode_core_property(0x17C9, 0x17D3, 'XID_Continue').	% Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
unicode_core_property(0x17D7, 0x17D7, 'XID_Continue').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17DC, 0x17DC, 'XID_Continue').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x17DD, 0x17DD, 'XID_Continue').	% Mn       KHMER SIGN ATTHACAN
unicode_core_property(0x17E0, 0x17E9, 'XID_Continue').	% Nd  [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
unicode_core_property(0x180B, 0x180D, 'XID_Continue').	% Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
unicode_core_property(0x1810, 0x1819, 'XID_Continue').	% Nd  [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
unicode_core_property(0x1820, 0x1842, 'XID_Continue').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'XID_Continue').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'XID_Continue').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'XID_Continue').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18A9, 0x18A9, 'XID_Continue').	% Mn       MONGOLIAN LETTER ALI GALI DAGALGA
unicode_core_property(0x18AA, 0x18AA, 'XID_Continue').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'XID_Continue').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'XID_Continue').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1920, 0x1922, 'XID_Continue').	% Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
unicode_core_property(0x1923, 0x1926, 'XID_Continue').	% Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
unicode_core_property(0x1927, 0x1928, 'XID_Continue').	% Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
unicode_core_property(0x1929, 0x192B, 'XID_Continue').	% Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
unicode_core_property(0x1930, 0x1931, 'XID_Continue').	% Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
unicode_core_property(0x1932, 0x1932, 'XID_Continue').	% Mn       LIMBU SMALL LETTER ANUSVARA
unicode_core_property(0x1933, 0x1938, 'XID_Continue').	% Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
unicode_core_property(0x1939, 0x193B, 'XID_Continue').	% Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
unicode_core_property(0x1946, 0x194F, 'XID_Continue').	% Nd  [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
unicode_core_property(0x1950, 0x196D, 'XID_Continue').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'XID_Continue').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'XID_Continue').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19B0, 0x19C0, 'XID_Continue').	% Mc  [17] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE VOWEL SIGN IY
unicode_core_property(0x19C1, 0x19C7, 'XID_Continue').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x19C8, 0x19C9, 'XID_Continue').	% Mc   [2] NEW TAI LUE TONE MARK-1..NEW TAI LUE TONE MARK-2
unicode_core_property(0x19D0, 0x19D9, 'XID_Continue').	% Nd  [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
unicode_core_property(0x19DA, 0x19DA, 'XID_Continue').	% No       NEW TAI LUE THAM DIGIT ONE
unicode_core_property(0x1A00, 0x1A16, 'XID_Continue').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A17, 0x1A18, 'XID_Continue').	% Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
unicode_core_property(0x1A19, 0x1A1B, 'XID_Continue').	% Mc   [3] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN AE
unicode_core_property(0x1A20, 0x1A54, 'XID_Continue').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1A55, 0x1A55, 'XID_Continue').	% Mc       TAI THAM CONSONANT SIGN MEDIAL RA
unicode_core_property(0x1A56, 0x1A56, 'XID_Continue').	% Mn       TAI THAM CONSONANT SIGN MEDIAL LA
unicode_core_property(0x1A57, 0x1A57, 'XID_Continue').	% Mc       TAI THAM CONSONANT SIGN LA TANG LAI
unicode_core_property(0x1A58, 0x1A5E, 'XID_Continue').	% Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
unicode_core_property(0x1A60, 0x1A60, 'XID_Continue').	% Mn       TAI THAM SIGN SAKOT
unicode_core_property(0x1A61, 0x1A61, 'XID_Continue').	% Mc       TAI THAM VOWEL SIGN A
unicode_core_property(0x1A62, 0x1A62, 'XID_Continue').	% Mn       TAI THAM VOWEL SIGN MAI SAT
unicode_core_property(0x1A63, 0x1A64, 'XID_Continue').	% Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
unicode_core_property(0x1A65, 0x1A6C, 'XID_Continue').	% Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
unicode_core_property(0x1A6D, 0x1A72, 'XID_Continue').	% Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
unicode_core_property(0x1A73, 0x1A7C, 'XID_Continue').	% Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
unicode_core_property(0x1A7F, 0x1A7F, 'XID_Continue').	% Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
unicode_core_property(0x1A80, 0x1A89, 'XID_Continue').	% Nd  [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
unicode_core_property(0x1A90, 0x1A99, 'XID_Continue').	% Nd  [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
unicode_core_property(0x1AA7, 0x1AA7, 'XID_Continue').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1B00, 0x1B03, 'XID_Continue').	% Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
unicode_core_property(0x1B04, 0x1B04, 'XID_Continue').	% Mc       BALINESE SIGN BISAH
unicode_core_property(0x1B05, 0x1B33, 'XID_Continue').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B34, 0x1B34, 'XID_Continue').	% Mn       BALINESE SIGN REREKAN
unicode_core_property(0x1B35, 0x1B35, 'XID_Continue').	% Mc       BALINESE VOWEL SIGN TEDUNG
unicode_core_property(0x1B36, 0x1B3A, 'XID_Continue').	% Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
unicode_core_property(0x1B3B, 0x1B3B, 'XID_Continue').	% Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
unicode_core_property(0x1B3C, 0x1B3C, 'XID_Continue').	% Mn       BALINESE VOWEL SIGN LA LENGA
unicode_core_property(0x1B3D, 0x1B41, 'XID_Continue').	% Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
unicode_core_property(0x1B42, 0x1B42, 'XID_Continue').	% Mn       BALINESE VOWEL SIGN PEPET
unicode_core_property(0x1B43, 0x1B44, 'XID_Continue').	% Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
unicode_core_property(0x1B45, 0x1B4B, 'XID_Continue').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B50, 0x1B59, 'XID_Continue').	% Nd  [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
unicode_core_property(0x1B6B, 0x1B73, 'XID_Continue').	% Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
unicode_core_property(0x1B80, 0x1B81, 'XID_Continue').	% Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
unicode_core_property(0x1B82, 0x1B82, 'XID_Continue').	% Mc       SUNDANESE SIGN PANGWISAD
unicode_core_property(0x1B83, 0x1BA0, 'XID_Continue').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BA1, 0x1BA1, 'XID_Continue').	% Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
unicode_core_property(0x1BA2, 0x1BA5, 'XID_Continue').	% Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
unicode_core_property(0x1BA6, 0x1BA7, 'XID_Continue').	% Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
unicode_core_property(0x1BA8, 0x1BA9, 'XID_Continue').	% Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
unicode_core_property(0x1BAA, 0x1BAA, 'XID_Continue').	% Mc       SUNDANESE SIGN PAMAAEH
unicode_core_property(0x1BAB, 0x1BAB, 'XID_Continue').	% Mn       SUNDANESE SIGN VIRAMA
unicode_core_property(0x1BAC, 0x1BAD, 'XID_Continue').	% Mc   [2] SUNDANESE CONSONANT SIGN PASANGAN MA..SUNDANESE CONSONANT SIGN PASANGAN WA
unicode_core_property(0x1BAE, 0x1BAF, 'XID_Continue').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BB0, 0x1BB9, 'XID_Continue').	% Nd  [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
unicode_core_property(0x1BBA, 0x1BE5, 'XID_Continue').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1BE6, 0x1BE6, 'XID_Continue').	% Mn       BATAK SIGN TOMPI
unicode_core_property(0x1BE7, 0x1BE7, 'XID_Continue').	% Mc       BATAK VOWEL SIGN E
unicode_core_property(0x1BE8, 0x1BE9, 'XID_Continue').	% Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
unicode_core_property(0x1BEA, 0x1BEC, 'XID_Continue').	% Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
unicode_core_property(0x1BED, 0x1BED, 'XID_Continue').	% Mn       BATAK VOWEL SIGN KARO O
unicode_core_property(0x1BEE, 0x1BEE, 'XID_Continue').	% Mc       BATAK VOWEL SIGN U
unicode_core_property(0x1BEF, 0x1BF1, 'XID_Continue').	% Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
unicode_core_property(0x1BF2, 0x1BF3, 'XID_Continue').	% Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
unicode_core_property(0x1C00, 0x1C23, 'XID_Continue').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C24, 0x1C2B, 'XID_Continue').	% Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
unicode_core_property(0x1C2C, 0x1C33, 'XID_Continue').	% Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
unicode_core_property(0x1C34, 0x1C35, 'XID_Continue').	% Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
unicode_core_property(0x1C36, 0x1C37, 'XID_Continue').	% Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
unicode_core_property(0x1C40, 0x1C49, 'XID_Continue').	% Nd  [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
unicode_core_property(0x1C4D, 0x1C4F, 'XID_Continue').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C50, 0x1C59, 'XID_Continue').	% Nd  [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
unicode_core_property(0x1C5A, 0x1C77, 'XID_Continue').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'XID_Continue').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1CD0, 0x1CD2, 'XID_Continue').	% Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
unicode_core_property(0x1CD4, 0x1CE0, 'XID_Continue').	% Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
unicode_core_property(0x1CE1, 0x1CE1, 'XID_Continue').	% Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
unicode_core_property(0x1CE2, 0x1CE8, 'XID_Continue').	% Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
unicode_core_property(0x1CE9, 0x1CEC, 'XID_Continue').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
unicode_core_property(0x1CED, 0x1CED, 'XID_Continue').	% Mn       VEDIC SIGN TIRYAK
unicode_core_property(0x1CEE, 0x1CF1, 'XID_Continue').	% Lo   [4] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ANUSVARA UBHAYATO MUKHA
unicode_core_property(0x1CF2, 0x1CF3, 'XID_Continue').	% Mc   [2] VEDIC SIGN ARDHAVISARGA..VEDIC SIGN ROTATED ARDHAVISARGA
unicode_core_property(0x1CF4, 0x1CF4, 'XID_Continue').	% Mn       VEDIC TONE CANDRA ABOVE
unicode_core_property(0x1CF5, 0x1CF6, 'XID_Continue').	% Lo   [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
unicode_core_property(0x1D00, 0x1D2B, 'XID_Continue').	% L&  [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
unicode_core_property(0x1D2C, 0x1D6A, 'XID_Continue').	% Lm  [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
unicode_core_property(0x1D6B, 0x1D77, 'XID_Continue').	% L&  [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
unicode_core_property(0x1D78, 0x1D78, 'XID_Continue').	% Lm       MODIFIER LETTER CYRILLIC EN
unicode_core_property(0x1D79, 0x1D9A, 'XID_Continue').	% L&  [34] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
unicode_core_property(0x1D9B, 0x1DBF, 'XID_Continue').	% Lm  [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
unicode_core_property(0x1DC0, 0x1DE6, 'XID_Continue').	% Mn  [39] COMBINING DOTTED GRAVE ACCENT..COMBINING LATIN SMALL LETTER Z
unicode_core_property(0x1DFC, 0x1DFF, 'XID_Continue').	% Mn   [4] COMBINING DOUBLE INVERTED BREVE BELOW..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
unicode_core_property(0x1E00, 0x1F15, 'XID_Continue').	% L& [278] LATIN CAPITAL LETTER A WITH RING BELOW..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F18, 0x1F1D, 'XID_Continue').	% L&   [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F20, 0x1F45, 'XID_Continue').	% L&  [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F48, 0x1F4D, 'XID_Continue').	% L&   [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
unicode_core_property(0x1F50, 0x1F57, 'XID_Continue').	% L&   [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
unicode_core_property(0x1F59, 0x1F59, 'XID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA
unicode_core_property(0x1F5B, 0x1F5B, 'XID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
unicode_core_property(0x1F5D, 0x1F5D, 'XID_Continue').	% L&       GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
unicode_core_property(0x1F5F, 0x1F7D, 'XID_Continue').	% L&  [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
unicode_core_property(0x1F80, 0x1FB4, 'XID_Continue').	% L&  [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FB6, 0x1FBC, 'XID_Continue').	% L&   [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
unicode_core_property(0x1FBE, 0x1FBE, 'XID_Continue').	% L&       GREEK PROSGEGRAMMENI
unicode_core_property(0x1FC2, 0x1FC4, 'XID_Continue').	% L&   [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FC6, 0x1FCC, 'XID_Continue').	% L&   [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
unicode_core_property(0x1FD0, 0x1FD3, 'XID_Continue').	% L&   [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
unicode_core_property(0x1FD6, 0x1FDB, 'XID_Continue').	% L&   [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
unicode_core_property(0x1FE0, 0x1FEC, 'XID_Continue').	% L&  [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
unicode_core_property(0x1FF2, 0x1FF4, 'XID_Continue').	% L&   [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
unicode_core_property(0x1FF6, 0x1FFC, 'XID_Continue').	% L&   [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
unicode_core_property(0x203F, 0x2040, 'XID_Continue').	% Pc   [2] UNDERTIE..CHARACTER TIE
unicode_core_property(0x2054, 0x2054, 'XID_Continue').	% Pc       INVERTED UNDERTIE
unicode_core_property(0x2071, 0x2071, 'XID_Continue').	% Lm       SUPERSCRIPT LATIN SMALL LETTER I
unicode_core_property(0x207F, 0x207F, 'XID_Continue').	% Lm       SUPERSCRIPT LATIN SMALL LETTER N
unicode_core_property(0x2090, 0x209C, 'XID_Continue').	% Lm  [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
unicode_core_property(0x20D0, 0x20DC, 'XID_Continue').	% Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_core_property(0x20E1, 0x20E1, 'XID_Continue').	% Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_core_property(0x20E5, 0x20F0, 'XID_Continue').	% Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
unicode_core_property(0x2102, 0x2102, 'XID_Continue').	% L&       DOUBLE-STRUCK CAPITAL C
unicode_core_property(0x2107, 0x2107, 'XID_Continue').	% L&       EULER CONSTANT
unicode_core_property(0x210A, 0x2113, 'XID_Continue').	% L&  [10] SCRIPT SMALL G..SCRIPT SMALL L
unicode_core_property(0x2115, 0x2115, 'XID_Continue').	% L&       DOUBLE-STRUCK CAPITAL N
unicode_core_property(0x2118, 0x2118, 'XID_Continue').	% Sm       SCRIPT CAPITAL P
unicode_core_property(0x2119, 0x211D, 'XID_Continue').	% L&   [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
unicode_core_property(0x2124, 0x2124, 'XID_Continue').	% L&       DOUBLE-STRUCK CAPITAL Z
unicode_core_property(0x2126, 0x2126, 'XID_Continue').	% L&       OHM SIGN
unicode_core_property(0x2128, 0x2128, 'XID_Continue').	% L&       BLACK-LETTER CAPITAL Z
unicode_core_property(0x212A, 0x212D, 'XID_Continue').	% L&   [4] KELVIN SIGN..BLACK-LETTER CAPITAL C
unicode_core_property(0x212E, 0x212E, 'XID_Continue').	% So       ESTIMATED SYMBOL
unicode_core_property(0x212F, 0x2134, 'XID_Continue').	% L&   [6] SCRIPT SMALL E..SCRIPT SMALL O
unicode_core_property(0x2135, 0x2138, 'XID_Continue').	% Lo   [4] ALEF SYMBOL..DALET SYMBOL
unicode_core_property(0x2139, 0x2139, 'XID_Continue').	% L&       INFORMATION SOURCE
unicode_core_property(0x213C, 0x213F, 'XID_Continue').	% L&   [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
unicode_core_property(0x2145, 0x2149, 'XID_Continue').	% L&   [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
unicode_core_property(0x214E, 0x214E, 'XID_Continue').	% L&       TURNED SMALL F
unicode_core_property(0x2160, 0x2182, 'XID_Continue').	% Nl  [35] ROMAN NUMERAL ONE..ROMAN NUMERAL TEN THOUSAND
unicode_core_property(0x2183, 0x2184, 'XID_Continue').	% L&   [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
unicode_core_property(0x2185, 0x2188, 'XID_Continue').	% Nl   [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
unicode_core_property(0x2C00, 0x2C2E, 'XID_Continue').	% L&  [47] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE
unicode_core_property(0x2C30, 0x2C5E, 'XID_Continue').	% L&  [47] GLAGOLITIC SMALL LETTER AZU..GLAGOLITIC SMALL LETTER LATINATE MYSLITE
unicode_core_property(0x2C60, 0x2C7B, 'XID_Continue').	% L&  [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
unicode_core_property(0x2C7C, 0x2C7D, 'XID_Continue').	% Lm   [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
unicode_core_property(0x2C7E, 0x2CE4, 'XID_Continue').	% L& [103] LATIN CAPITAL LETTER S WITH SWASH TAIL..COPTIC SYMBOL KAI
unicode_core_property(0x2CEB, 0x2CEE, 'XID_Continue').	% L&   [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
unicode_core_property(0x2CEF, 0x2CF1, 'XID_Continue').	% Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
unicode_core_property(0x2CF2, 0x2CF3, 'XID_Continue').	% L&   [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
unicode_core_property(0x2D00, 0x2D25, 'XID_Continue').	% L&  [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
unicode_core_property(0x2D27, 0x2D27, 'XID_Continue').	% L&       GEORGIAN SMALL LETTER YN
unicode_core_property(0x2D2D, 0x2D2D, 'XID_Continue').	% L&       GEORGIAN SMALL LETTER AEN
unicode_core_property(0x2D30, 0x2D67, 'XID_Continue').	% Lo  [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
unicode_core_property(0x2D6F, 0x2D6F, 'XID_Continue').	% Lm       TIFINAGH MODIFIER LETTER LABIALIZATION MARK
unicode_core_property(0x2D7F, 0x2D7F, 'XID_Continue').	% Mn       TIFINAGH CONSONANT JOINER
unicode_core_property(0x2D80, 0x2D96, 'XID_Continue').	% Lo  [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
unicode_core_property(0x2DA0, 0x2DA6, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
unicode_core_property(0x2DA8, 0x2DAE, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
unicode_core_property(0x2DB0, 0x2DB6, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
unicode_core_property(0x2DB8, 0x2DBE, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
unicode_core_property(0x2DC0, 0x2DC6, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
unicode_core_property(0x2DC8, 0x2DCE, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
unicode_core_property(0x2DD0, 0x2DD6, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
unicode_core_property(0x2DD8, 0x2DDE, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
unicode_core_property(0x2DE0, 0x2DFF, 'XID_Continue').	% Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
unicode_core_property(0x3005, 0x3005, 'XID_Continue').	% Lm       IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x3006, 0x3006, 'XID_Continue').	% Lo       IDEOGRAPHIC CLOSING MARK
unicode_core_property(0x3007, 0x3007, 'XID_Continue').	% Nl       IDEOGRAPHIC NUMBER ZERO
unicode_core_property(0x3021, 0x3029, 'XID_Continue').	% Nl   [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
unicode_core_property(0x302A, 0x302D, 'XID_Continue').	% Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
unicode_core_property(0x302E, 0x302F, 'XID_Continue').	% Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
unicode_core_property(0x3031, 0x3035, 'XID_Continue').	% Lm   [5] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT MARK LOWER HALF
unicode_core_property(0x3038, 0x303A, 'XID_Continue').	% Nl   [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
unicode_core_property(0x303B, 0x303B, 'XID_Continue').	% Lm       VERTICAL IDEOGRAPHIC ITERATION MARK
unicode_core_property(0x303C, 0x303C, 'XID_Continue').	% Lo       MASU MARK
unicode_core_property(0x3041, 0x3096, 'XID_Continue').	% Lo  [86] HIRAGANA LETTER SMALL A..HIRAGANA LETTER SMALL KE
unicode_core_property(0x3099, 0x309A, 'XID_Continue').	% Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0x309D, 0x309E, 'XID_Continue').	% Lm   [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
unicode_core_property(0x309F, 0x309F, 'XID_Continue').	% Lo       HIRAGANA DIGRAPH YORI
unicode_core_property(0x30A1, 0x30FA, 'XID_Continue').	% Lo  [90] KATAKANA LETTER SMALL A..KATAKANA LETTER VO
unicode_core_property(0x30FC, 0x30FE, 'XID_Continue').	% Lm   [3] KATAKANA-HIRAGANA PROLONGED SOUND MARK..KATAKANA VOICED ITERATION MARK
unicode_core_property(0x30FF, 0x30FF, 'XID_Continue').	% Lo       KATAKANA DIGRAPH KOTO
unicode_core_property(0x3105, 0x312D, 'XID_Continue').	% Lo  [41] BOPOMOFO LETTER B..BOPOMOFO LETTER IH
unicode_core_property(0x3131, 0x318E, 'XID_Continue').	% Lo  [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
unicode_core_property(0x31A0, 0x31BA, 'XID_Continue').	% Lo  [27] BOPOMOFO LETTER BU..BOPOMOFO LETTER ZY
unicode_core_property(0x31F0, 0x31FF, 'XID_Continue').	% Lo  [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
unicode_core_property(0x3400, 0x4DB5, 'XID_Continue').	% Lo [6582] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DB5
unicode_core_property(0x4E00, 0x9FCC, 'XID_Continue').	% Lo [20941] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FCC
unicode_core_property(0xA000, 0xA014, 'XID_Continue').	% Lo  [21] YI SYLLABLE IT..YI SYLLABLE E
unicode_core_property(0xA015, 0xA015, 'XID_Continue').	% Lm       YI SYLLABLE WU
unicode_core_property(0xA016, 0xA48C, 'XID_Continue').	% Lo [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
unicode_core_property(0xA4D0, 0xA4F7, 'XID_Continue').	% Lo  [40] LISU LETTER BA..LISU LETTER OE
unicode_core_property(0xA4F8, 0xA4FD, 'XID_Continue').	% Lm   [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
unicode_core_property(0xA500, 0xA60B, 'XID_Continue').	% Lo [268] VAI SYLLABLE EE..VAI SYLLABLE NG
unicode_core_property(0xA60C, 0xA60C, 'XID_Continue').	% Lm       VAI SYLLABLE LENGTHENER
unicode_core_property(0xA610, 0xA61F, 'XID_Continue').	% Lo  [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
unicode_core_property(0xA620, 0xA629, 'XID_Continue').	% Nd  [10] VAI DIGIT ZERO..VAI DIGIT NINE
unicode_core_property(0xA62A, 0xA62B, 'XID_Continue').	% Lo   [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
unicode_core_property(0xA640, 0xA66D, 'XID_Continue').	% L&  [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
unicode_core_property(0xA66E, 0xA66E, 'XID_Continue').	% Lo       CYRILLIC LETTER MULTIOCULAR O
unicode_core_property(0xA66F, 0xA66F, 'XID_Continue').	% Mn       COMBINING CYRILLIC VZMET
unicode_core_property(0xA674, 0xA67D, 'XID_Continue').	% Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
unicode_core_property(0xA67F, 0xA67F, 'XID_Continue').	% Lm       CYRILLIC PAYEROK
unicode_core_property(0xA680, 0xA697, 'XID_Continue').	% L&  [24] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER SHWE
unicode_core_property(0xA69F, 0xA69F, 'XID_Continue').	% Mn       COMBINING CYRILLIC LETTER IOTIFIED E
unicode_core_property(0xA6A0, 0xA6E5, 'XID_Continue').	% Lo  [70] BAMUM LETTER A..BAMUM LETTER KI
unicode_core_property(0xA6E6, 0xA6EF, 'XID_Continue').	% Nl  [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
unicode_core_property(0xA6F0, 0xA6F1, 'XID_Continue').	% Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
unicode_core_property(0xA717, 0xA71F, 'XID_Continue').	% Lm   [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
unicode_core_property(0xA722, 0xA76F, 'XID_Continue').	% L&  [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
unicode_core_property(0xA770, 0xA770, 'XID_Continue').	% Lm       MODIFIER LETTER US
unicode_core_property(0xA771, 0xA787, 'XID_Continue').	% L&  [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
unicode_core_property(0xA788, 0xA788, 'XID_Continue').	% Lm       MODIFIER LETTER LOW CIRCUMFLEX ACCENT
unicode_core_property(0xA78B, 0xA78E, 'XID_Continue').	% L&   [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
unicode_core_property(0xA790, 0xA793, 'XID_Continue').	% L&   [4] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER C WITH BAR
unicode_core_property(0xA7A0, 0xA7AA, 'XID_Continue').	% L&  [11] LATIN CAPITAL LETTER G WITH OBLIQUE STROKE..LATIN CAPITAL LETTER H WITH HOOK
unicode_core_property(0xA7F8, 0xA7F9, 'XID_Continue').	% Lm   [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
unicode_core_property(0xA7FA, 0xA7FA, 'XID_Continue').	% L&       LATIN LETTER SMALL CAPITAL TURNED M
unicode_core_property(0xA7FB, 0xA801, 'XID_Continue').	% Lo   [7] LATIN EPIGRAPHIC LETTER REVERSED F..SYLOTI NAGRI LETTER I
unicode_core_property(0xA802, 0xA802, 'XID_Continue').	% Mn       SYLOTI NAGRI SIGN DVISVARA
unicode_core_property(0xA803, 0xA805, 'XID_Continue').	% Lo   [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
unicode_core_property(0xA806, 0xA806, 'XID_Continue').	% Mn       SYLOTI NAGRI SIGN HASANTA
unicode_core_property(0xA807, 0xA80A, 'XID_Continue').	% Lo   [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
unicode_core_property(0xA80B, 0xA80B, 'XID_Continue').	% Mn       SYLOTI NAGRI SIGN ANUSVARA
unicode_core_property(0xA80C, 0xA822, 'XID_Continue').	% Lo  [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
unicode_core_property(0xA823, 0xA824, 'XID_Continue').	% Mc   [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
unicode_core_property(0xA825, 0xA826, 'XID_Continue').	% Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
unicode_core_property(0xA827, 0xA827, 'XID_Continue').	% Mc       SYLOTI NAGRI VOWEL SIGN OO
unicode_core_property(0xA840, 0xA873, 'XID_Continue').	% Lo  [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
unicode_core_property(0xA880, 0xA881, 'XID_Continue').	% Mc   [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
unicode_core_property(0xA882, 0xA8B3, 'XID_Continue').	% Lo  [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
unicode_core_property(0xA8B4, 0xA8C3, 'XID_Continue').	% Mc  [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
unicode_core_property(0xA8C4, 0xA8C4, 'XID_Continue').	% Mn       SAURASHTRA SIGN VIRAMA
unicode_core_property(0xA8D0, 0xA8D9, 'XID_Continue').	% Nd  [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
unicode_core_property(0xA8E0, 0xA8F1, 'XID_Continue').	% Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0xA8F2, 0xA8F7, 'XID_Continue').	% Lo   [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
unicode_core_property(0xA8FB, 0xA8FB, 'XID_Continue').	% Lo       DEVANAGARI HEADSTROKE
unicode_core_property(0xA900, 0xA909, 'XID_Continue').	% Nd  [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
unicode_core_property(0xA90A, 0xA925, 'XID_Continue').	% Lo  [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
unicode_core_property(0xA926, 0xA92D, 'XID_Continue').	% Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
unicode_core_property(0xA930, 0xA946, 'XID_Continue').	% Lo  [23] REJANG LETTER KA..REJANG LETTER A
unicode_core_property(0xA947, 0xA951, 'XID_Continue').	% Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
unicode_core_property(0xA952, 0xA953, 'XID_Continue').	% Mc   [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
unicode_core_property(0xA960, 0xA97C, 'XID_Continue').	% Lo  [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
unicode_core_property(0xA980, 0xA982, 'XID_Continue').	% Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
unicode_core_property(0xA983, 0xA983, 'XID_Continue').	% Mc       JAVANESE SIGN WIGNYAN
unicode_core_property(0xA984, 0xA9B2, 'XID_Continue').	% Lo  [47] JAVANESE LETTER A..JAVANESE LETTER HA
unicode_core_property(0xA9B3, 0xA9B3, 'XID_Continue').	% Mn       JAVANESE SIGN CECAK TELU
unicode_core_property(0xA9B4, 0xA9B5, 'XID_Continue').	% Mc   [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
unicode_core_property(0xA9B6, 0xA9B9, 'XID_Continue').	% Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
unicode_core_property(0xA9BA, 0xA9BB, 'XID_Continue').	% Mc   [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
unicode_core_property(0xA9BC, 0xA9BC, 'XID_Continue').	% Mn       JAVANESE VOWEL SIGN PEPET
unicode_core_property(0xA9BD, 0xA9C0, 'XID_Continue').	% Mc   [4] JAVANESE CONSONANT SIGN KERET..JAVANESE PANGKON
unicode_core_property(0xA9CF, 0xA9CF, 'XID_Continue').	% Lm       JAVANESE PANGRANGKEP
unicode_core_property(0xA9D0, 0xA9D9, 'XID_Continue').	% Nd  [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
unicode_core_property(0xAA00, 0xAA28, 'XID_Continue').	% Lo  [41] CHAM LETTER A..CHAM LETTER HA
unicode_core_property(0xAA29, 0xAA2E, 'XID_Continue').	% Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
unicode_core_property(0xAA2F, 0xAA30, 'XID_Continue').	% Mc   [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
unicode_core_property(0xAA31, 0xAA32, 'XID_Continue').	% Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
unicode_core_property(0xAA33, 0xAA34, 'XID_Continue').	% Mc   [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
unicode_core_property(0xAA35, 0xAA36, 'XID_Continue').	% Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
unicode_core_property(0xAA40, 0xAA42, 'XID_Continue').	% Lo   [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
unicode_core_property(0xAA43, 0xAA43, 'XID_Continue').	% Mn       CHAM CONSONANT SIGN FINAL NG
unicode_core_property(0xAA44, 0xAA4B, 'XID_Continue').	% Lo   [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
unicode_core_property(0xAA4C, 0xAA4C, 'XID_Continue').	% Mn       CHAM CONSONANT SIGN FINAL M
unicode_core_property(0xAA4D, 0xAA4D, 'XID_Continue').	% Mc       CHAM CONSONANT SIGN FINAL H
unicode_core_property(0xAA50, 0xAA59, 'XID_Continue').	% Nd  [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
unicode_core_property(0xAA60, 0xAA6F, 'XID_Continue').	% Lo  [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
unicode_core_property(0xAA70, 0xAA70, 'XID_Continue').	% Lm       MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
unicode_core_property(0xAA71, 0xAA76, 'XID_Continue').	% Lo   [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
unicode_core_property(0xAA7A, 0xAA7A, 'XID_Continue').	% Lo       MYANMAR LETTER AITON RA
unicode_core_property(0xAA7B, 0xAA7B, 'XID_Continue').	% Mc       MYANMAR SIGN PAO KAREN TONE
unicode_core_property(0xAA80, 0xAAAF, 'XID_Continue').	% Lo  [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
unicode_core_property(0xAAB0, 0xAAB0, 'XID_Continue').	% Mn       TAI VIET MAI KANG
unicode_core_property(0xAAB1, 0xAAB1, 'XID_Continue').	% Lo       TAI VIET VOWEL AA
unicode_core_property(0xAAB2, 0xAAB4, 'XID_Continue').	% Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
unicode_core_property(0xAAB5, 0xAAB6, 'XID_Continue').	% Lo   [2] TAI VIET VOWEL E..TAI VIET VOWEL O
unicode_core_property(0xAAB7, 0xAAB8, 'XID_Continue').	% Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
unicode_core_property(0xAAB9, 0xAABD, 'XID_Continue').	% Lo   [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
unicode_core_property(0xAABE, 0xAABF, 'XID_Continue').	% Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
unicode_core_property(0xAAC0, 0xAAC0, 'XID_Continue').	% Lo       TAI VIET TONE MAI NUENG
unicode_core_property(0xAAC1, 0xAAC1, 'XID_Continue').	% Mn       TAI VIET TONE MAI THO
unicode_core_property(0xAAC2, 0xAAC2, 'XID_Continue').	% Lo       TAI VIET TONE MAI SONG
unicode_core_property(0xAADB, 0xAADC, 'XID_Continue').	% Lo   [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
unicode_core_property(0xAADD, 0xAADD, 'XID_Continue').	% Lm       TAI VIET SYMBOL SAM
unicode_core_property(0xAAE0, 0xAAEA, 'XID_Continue').	% Lo  [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
unicode_core_property(0xAAEB, 0xAAEB, 'XID_Continue').	% Mc       MEETEI MAYEK VOWEL SIGN II
unicode_core_property(0xAAEC, 0xAAED, 'XID_Continue').	% Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
unicode_core_property(0xAAEE, 0xAAEF, 'XID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
unicode_core_property(0xAAF2, 0xAAF2, 'XID_Continue').	% Lo       MEETEI MAYEK ANJI
unicode_core_property(0xAAF3, 0xAAF4, 'XID_Continue').	% Lm   [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
unicode_core_property(0xAAF5, 0xAAF5, 'XID_Continue').	% Mc       MEETEI MAYEK VOWEL SIGN VISARGA
unicode_core_property(0xAAF6, 0xAAF6, 'XID_Continue').	% Mn       MEETEI MAYEK VIRAMA
unicode_core_property(0xAB01, 0xAB06, 'XID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
unicode_core_property(0xAB09, 0xAB0E, 'XID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
unicode_core_property(0xAB11, 0xAB16, 'XID_Continue').	% Lo   [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
unicode_core_property(0xAB20, 0xAB26, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
unicode_core_property(0xAB28, 0xAB2E, 'XID_Continue').	% Lo   [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
unicode_core_property(0xABC0, 0xABE2, 'XID_Continue').	% Lo  [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
unicode_core_property(0xABE3, 0xABE4, 'XID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
unicode_core_property(0xABE5, 0xABE5, 'XID_Continue').	% Mn       MEETEI MAYEK VOWEL SIGN ANAP
unicode_core_property(0xABE6, 0xABE7, 'XID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
unicode_core_property(0xABE8, 0xABE8, 'XID_Continue').	% Mn       MEETEI MAYEK VOWEL SIGN UNAP
unicode_core_property(0xABE9, 0xABEA, 'XID_Continue').	% Mc   [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
unicode_core_property(0xABEC, 0xABEC, 'XID_Continue').	% Mc       MEETEI MAYEK LUM IYEK
unicode_core_property(0xABED, 0xABED, 'XID_Continue').	% Mn       MEETEI MAYEK APUN IYEK
unicode_core_property(0xABF0, 0xABF9, 'XID_Continue').	% Nd  [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
unicode_core_property(0xAC00, 0xD7A3, 'XID_Continue').	% Lo [11172] HANGUL SYLLABLE GA..HANGUL SYLLABLE HIH
unicode_core_property(0xD7B0, 0xD7C6, 'XID_Continue').	% Lo  [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
unicode_core_property(0xD7CB, 0xD7FB, 'XID_Continue').	% Lo  [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
unicode_core_property(0xF900, 0xFA6D, 'XID_Continue').	% Lo [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
unicode_core_property(0xFA70, 0xFAD9, 'XID_Continue').	% Lo [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
unicode_core_property(0xFB00, 0xFB06, 'XID_Continue').	% L&   [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
unicode_core_property(0xFB13, 0xFB17, 'XID_Continue').	% L&   [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
unicode_core_property(0xFB1D, 0xFB1D, 'XID_Continue').	% Lo       HEBREW LETTER YOD WITH HIRIQ
unicode_core_property(0xFB1E, 0xFB1E, 'XID_Continue').	% Mn       HEBREW POINT JUDEO-SPANISH VARIKA
unicode_core_property(0xFB1F, 0xFB28, 'XID_Continue').	% Lo  [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
unicode_core_property(0xFB2A, 0xFB36, 'XID_Continue').	% Lo  [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
unicode_core_property(0xFB38, 0xFB3C, 'XID_Continue').	% Lo   [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
unicode_core_property(0xFB3E, 0xFB3E, 'XID_Continue').	% Lo       HEBREW LETTER MEM WITH DAGESH
unicode_core_property(0xFB40, 0xFB41, 'XID_Continue').	% Lo   [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
unicode_core_property(0xFB43, 0xFB44, 'XID_Continue').	% Lo   [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
unicode_core_property(0xFB46, 0xFBB1, 'XID_Continue').	% Lo [108] HEBREW LETTER TSADI WITH DAGESH..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
unicode_core_property(0xFBD3, 0xFC5D, 'XID_Continue').	% Lo [139] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
unicode_core_property(0xFC64, 0xFD3D, 'XID_Continue').	% Lo [218] ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
unicode_core_property(0xFD50, 0xFD8F, 'XID_Continue').	% Lo  [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
unicode_core_property(0xFD92, 0xFDC7, 'XID_Continue').	% Lo  [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
unicode_core_property(0xFDF0, 0xFDF9, 'XID_Continue').	% Lo  [10] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE SALLA ISOLATED FORM
unicode_core_property(0xFE00, 0xFE0F, 'XID_Continue').	% Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
unicode_core_property(0xFE20, 0xFE26, 'XID_Continue').	% Mn   [7] COMBINING LIGATURE LEFT HALF..COMBINING CONJOINING MACRON
unicode_core_property(0xFE33, 0xFE34, 'XID_Continue').	% Pc   [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
unicode_core_property(0xFE4D, 0xFE4F, 'XID_Continue').	% Pc   [3] DASHED LOW LINE..WAVY LOW LINE
unicode_core_property(0xFE71, 0xFE71, 'XID_Continue').	% Lo       ARABIC TATWEEL WITH FATHATAN ABOVE
unicode_core_property(0xFE73, 0xFE73, 'XID_Continue').	% Lo       ARABIC TAIL FRAGMENT
unicode_core_property(0xFE77, 0xFE77, 'XID_Continue').	% Lo       ARABIC FATHA MEDIAL FORM
unicode_core_property(0xFE79, 0xFE79, 'XID_Continue').	% Lo       ARABIC DAMMA MEDIAL FORM
unicode_core_property(0xFE7B, 0xFE7B, 'XID_Continue').	% Lo       ARABIC KASRA MEDIAL FORM
unicode_core_property(0xFE7D, 0xFE7D, 'XID_Continue').	% Lo       ARABIC SHADDA MEDIAL FORM
unicode_core_property(0xFE7F, 0xFEFC, 'XID_Continue').	% Lo [126] ARABIC SUKUN MEDIAL FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
unicode_core_property(0xFF10, 0xFF19, 'XID_Continue').	% Nd  [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
unicode_core_property(0xFF21, 0xFF3A, 'XID_Continue').	% L&  [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
unicode_core_property(0xFF3F, 0xFF3F, 'XID_Continue').	% Pc       FULLWIDTH LOW LINE
unicode_core_property(0xFF41, 0xFF5A, 'XID_Continue').	% L&  [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
unicode_core_property(0xFF66, 0xFF6F, 'XID_Continue').	% Lo  [10] HALFWIDTH KATAKANA LETTER WO..HALFWIDTH KATAKANA LETTER SMALL TU
unicode_core_property(0xFF70, 0xFF70, 'XID_Continue').	% Lm       HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
unicode_core_property(0xFF71, 0xFF9D, 'XID_Continue').	% Lo  [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
unicode_core_property(0xFF9E, 0xFF9F, 'XID_Continue').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0xFFA0, 0xFFBE, 'XID_Continue').	% Lo  [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
unicode_core_property(0xFFC2, 0xFFC7, 'XID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
unicode_core_property(0xFFCA, 0xFFCF, 'XID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
unicode_core_property(0xFFD2, 0xFFD7, 'XID_Continue').	% Lo   [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
unicode_core_property(0xFFDA, 0xFFDC, 'XID_Continue').	% Lo   [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
unicode_core_property(0x10000, 0x1000B, 'XID_Continue').	% Lo  [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
unicode_core_property(0x1000D, 0x10026, 'XID_Continue').	% Lo  [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
unicode_core_property(0x10028, 0x1003A, 'XID_Continue').	% Lo  [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
unicode_core_property(0x1003C, 0x1003D, 'XID_Continue').	% Lo   [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
unicode_core_property(0x1003F, 0x1004D, 'XID_Continue').	% Lo  [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
unicode_core_property(0x10050, 0x1005D, 'XID_Continue').	% Lo  [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
unicode_core_property(0x10080, 0x100FA, 'XID_Continue').	% Lo [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
unicode_core_property(0x10140, 0x10174, 'XID_Continue').	% Nl  [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
unicode_core_property(0x101FD, 0x101FD, 'XID_Continue').	% Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
unicode_core_property(0x10280, 0x1029C, 'XID_Continue').	% Lo  [29] LYCIAN LETTER A..LYCIAN LETTER X
unicode_core_property(0x102A0, 0x102D0, 'XID_Continue').	% Lo  [49] CARIAN LETTER A..CARIAN LETTER UUU3
unicode_core_property(0x10300, 0x1031E, 'XID_Continue').	% Lo  [31] OLD ITALIC LETTER A..OLD ITALIC LETTER UU
unicode_core_property(0x10330, 0x10340, 'XID_Continue').	% Lo  [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
unicode_core_property(0x10341, 0x10341, 'XID_Continue').	% Nl       GOTHIC LETTER NINETY
unicode_core_property(0x10342, 0x10349, 'XID_Continue').	% Lo   [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
unicode_core_property(0x1034A, 0x1034A, 'XID_Continue').	% Nl       GOTHIC LETTER NINE HUNDRED
unicode_core_property(0x10380, 0x1039D, 'XID_Continue').	% Lo  [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
unicode_core_property(0x103A0, 0x103C3, 'XID_Continue').	% Lo  [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
unicode_core_property(0x103C8, 0x103CF, 'XID_Continue').	% Lo   [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
unicode_core_property(0x103D1, 0x103D5, 'XID_Continue').	% Nl   [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
unicode_core_property(0x10400, 0x1044F, 'XID_Continue').	% L&  [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
unicode_core_property(0x10450, 0x1049D, 'XID_Continue').	% Lo  [78] SHAVIAN LETTER PEEP..OSMANYA LETTER OO
unicode_core_property(0x104A0, 0x104A9, 'XID_Continue').	% Nd  [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
unicode_core_property(0x10800, 0x10805, 'XID_Continue').	% Lo   [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
unicode_core_property(0x10808, 0x10808, 'XID_Continue').	% Lo       CYPRIOT SYLLABLE JO
unicode_core_property(0x1080A, 0x10835, 'XID_Continue').	% Lo  [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
unicode_core_property(0x10837, 0x10838, 'XID_Continue').	% Lo   [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
unicode_core_property(0x1083C, 0x1083C, 'XID_Continue').	% Lo       CYPRIOT SYLLABLE ZA
unicode_core_property(0x1083F, 0x10855, 'XID_Continue').	% Lo  [23] CYPRIOT SYLLABLE ZO..IMPERIAL ARAMAIC LETTER TAW
unicode_core_property(0x10900, 0x10915, 'XID_Continue').	% Lo  [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
unicode_core_property(0x10920, 0x10939, 'XID_Continue').	% Lo  [26] LYDIAN LETTER A..LYDIAN LETTER C
unicode_core_property(0x10980, 0x109B7, 'XID_Continue').	% Lo  [56] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC CURSIVE LETTER DA
unicode_core_property(0x109BE, 0x109BF, 'XID_Continue').	% Lo   [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
unicode_core_property(0x10A00, 0x10A00, 'XID_Continue').	% Lo       KHAROSHTHI LETTER A
unicode_core_property(0x10A01, 0x10A03, 'XID_Continue').	% Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
unicode_core_property(0x10A05, 0x10A06, 'XID_Continue').	% Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
unicode_core_property(0x10A0C, 0x10A0F, 'XID_Continue').	% Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
unicode_core_property(0x10A10, 0x10A13, 'XID_Continue').	% Lo   [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
unicode_core_property(0x10A15, 0x10A17, 'XID_Continue').	% Lo   [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
unicode_core_property(0x10A19, 0x10A33, 'XID_Continue').	% Lo  [27] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER TTTHA
unicode_core_property(0x10A38, 0x10A3A, 'XID_Continue').	% Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
unicode_core_property(0x10A3F, 0x10A3F, 'XID_Continue').	% Mn       KHAROSHTHI VIRAMA
unicode_core_property(0x10A60, 0x10A7C, 'XID_Continue').	% Lo  [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
unicode_core_property(0x10B00, 0x10B35, 'XID_Continue').	% Lo  [54] AVESTAN LETTER A..AVESTAN LETTER HE
unicode_core_property(0x10B40, 0x10B55, 'XID_Continue').	% Lo  [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
unicode_core_property(0x10B60, 0x10B72, 'XID_Continue').	% Lo  [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
unicode_core_property(0x10C00, 0x10C48, 'XID_Continue').	% Lo  [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
unicode_core_property(0x11000, 0x11000, 'XID_Continue').	% Mc       BRAHMI SIGN CANDRABINDU
unicode_core_property(0x11001, 0x11001, 'XID_Continue').	% Mn       BRAHMI SIGN ANUSVARA
unicode_core_property(0x11002, 0x11002, 'XID_Continue').	% Mc       BRAHMI SIGN VISARGA
unicode_core_property(0x11003, 0x11037, 'XID_Continue').	% Lo  [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
unicode_core_property(0x11038, 0x11046, 'XID_Continue').	% Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
unicode_core_property(0x11066, 0x1106F, 'XID_Continue').	% Nd  [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
unicode_core_property(0x11080, 0x11081, 'XID_Continue').	% Mn   [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
unicode_core_property(0x11082, 0x11082, 'XID_Continue').	% Mc       KAITHI SIGN VISARGA
unicode_core_property(0x11083, 0x110AF, 'XID_Continue').	% Lo  [45] KAITHI LETTER A..KAITHI LETTER HA
unicode_core_property(0x110B0, 0x110B2, 'XID_Continue').	% Mc   [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
unicode_core_property(0x110B3, 0x110B6, 'XID_Continue').	% Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
unicode_core_property(0x110B7, 0x110B8, 'XID_Continue').	% Mc   [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
unicode_core_property(0x110B9, 0x110BA, 'XID_Continue').	% Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
unicode_core_property(0x110D0, 0x110E8, 'XID_Continue').	% Lo  [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
unicode_core_property(0x110F0, 0x110F9, 'XID_Continue').	% Nd  [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
unicode_core_property(0x11100, 0x11102, 'XID_Continue').	% Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
unicode_core_property(0x11103, 0x11126, 'XID_Continue').	% Lo  [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
unicode_core_property(0x11127, 0x1112B, 'XID_Continue').	% Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
unicode_core_property(0x1112C, 0x1112C, 'XID_Continue').	% Mc       CHAKMA VOWEL SIGN E
unicode_core_property(0x1112D, 0x11134, 'XID_Continue').	% Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
unicode_core_property(0x11136, 0x1113F, 'XID_Continue').	% Nd  [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
unicode_core_property(0x11180, 0x11181, 'XID_Continue').	% Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
unicode_core_property(0x11182, 0x11182, 'XID_Continue').	% Mc       SHARADA SIGN VISARGA
unicode_core_property(0x11183, 0x111B2, 'XID_Continue').	% Lo  [48] SHARADA LETTER A..SHARADA LETTER HA
unicode_core_property(0x111B3, 0x111B5, 'XID_Continue').	% Mc   [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
unicode_core_property(0x111B6, 0x111BE, 'XID_Continue').	% Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
unicode_core_property(0x111BF, 0x111C0, 'XID_Continue').	% Mc   [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
unicode_core_property(0x111C1, 0x111C4, 'XID_Continue').	% Lo   [4] SHARADA SIGN AVAGRAHA..SHARADA OM
unicode_core_property(0x111D0, 0x111D9, 'XID_Continue').	% Nd  [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
unicode_core_property(0x11680, 0x116AA, 'XID_Continue').	% Lo  [43] TAKRI LETTER A..TAKRI LETTER RRA
unicode_core_property(0x116AB, 0x116AB, 'XID_Continue').	% Mn       TAKRI SIGN ANUSVARA
unicode_core_property(0x116AC, 0x116AC, 'XID_Continue').	% Mc       TAKRI SIGN VISARGA
unicode_core_property(0x116AD, 0x116AD, 'XID_Continue').	% Mn       TAKRI VOWEL SIGN AA
unicode_core_property(0x116AE, 0x116AF, 'XID_Continue').	% Mc   [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
unicode_core_property(0x116B0, 0x116B5, 'XID_Continue').	% Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
unicode_core_property(0x116B6, 0x116B6, 'XID_Continue').	% Mc       TAKRI SIGN VIRAMA
unicode_core_property(0x116B7, 0x116B7, 'XID_Continue').	% Mn       TAKRI SIGN NUKTA
unicode_core_property(0x116C0, 0x116C9, 'XID_Continue').	% Nd  [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
unicode_core_property(0x12000, 0x1236E, 'XID_Continue').	% Lo [879] CUNEIFORM SIGN A..CUNEIFORM SIGN ZUM
unicode_core_property(0x12400, 0x12462, 'XID_Continue').	% Nl  [99] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER
unicode_core_property(0x13000, 0x1342E, 'XID_Continue').	% Lo [1071] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH AA032
unicode_core_property(0x16800, 0x16A38, 'XID_Continue').	% Lo [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
unicode_core_property(0x16F00, 0x16F44, 'XID_Continue').	% Lo  [69] MIAO LETTER PA..MIAO LETTER HHA
unicode_core_property(0x16F50, 0x16F50, 'XID_Continue').	% Lo       MIAO LETTER NASALIZATION
unicode_core_property(0x16F51, 0x16F7E, 'XID_Continue').	% Mc  [46] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN NG
unicode_core_property(0x16F8F, 0x16F92, 'XID_Continue').	% Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
unicode_core_property(0x16F93, 0x16F9F, 'XID_Continue').	% Lm  [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
unicode_core_property(0x1B000, 0x1B001, 'XID_Continue').	% Lo   [2] KATAKANA LETTER ARCHAIC E..HIRAGANA LETTER ARCHAIC YE
unicode_core_property(0x1D165, 0x1D166, 'XID_Continue').	% Mc   [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
unicode_core_property(0x1D167, 0x1D169, 'XID_Continue').	% Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
unicode_core_property(0x1D16D, 0x1D172, 'XID_Continue').	% Mc   [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
unicode_core_property(0x1D17B, 0x1D182, 'XID_Continue').	% Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
unicode_core_property(0x1D185, 0x1D18B, 'XID_Continue').	% Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
unicode_core_property(0x1D1AA, 0x1D1AD, 'XID_Continue').	% Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
unicode_core_property(0x1D242, 0x1D244, 'XID_Continue').	% Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
unicode_core_property(0x1D400, 0x1D454, 'XID_Continue').	% L&  [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
unicode_core_property(0x1D456, 0x1D49C, 'XID_Continue').	% L&  [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
unicode_core_property(0x1D49E, 0x1D49F, 'XID_Continue').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
unicode_core_property(0x1D4A2, 0x1D4A2, 'XID_Continue').	% L&       MATHEMATICAL SCRIPT CAPITAL G
unicode_core_property(0x1D4A5, 0x1D4A6, 'XID_Continue').	% L&   [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
unicode_core_property(0x1D4A9, 0x1D4AC, 'XID_Continue').	% L&   [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
unicode_core_property(0x1D4AE, 0x1D4B9, 'XID_Continue').	% L&  [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
unicode_core_property(0x1D4BB, 0x1D4BB, 'XID_Continue').	% L&       MATHEMATICAL SCRIPT SMALL F
unicode_core_property(0x1D4BD, 0x1D4C3, 'XID_Continue').	% L&   [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
unicode_core_property(0x1D4C5, 0x1D505, 'XID_Continue').	% L&  [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
unicode_core_property(0x1D507, 0x1D50A, 'XID_Continue').	% L&   [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
unicode_core_property(0x1D50D, 0x1D514, 'XID_Continue').	% L&   [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
unicode_core_property(0x1D516, 0x1D51C, 'XID_Continue').	% L&   [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
unicode_core_property(0x1D51E, 0x1D539, 'XID_Continue').	% L&  [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
unicode_core_property(0x1D53B, 0x1D53E, 'XID_Continue').	% L&   [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
unicode_core_property(0x1D540, 0x1D544, 'XID_Continue').	% L&   [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
unicode_core_property(0x1D546, 0x1D546, 'XID_Continue').	% L&       MATHEMATICAL DOUBLE-STRUCK CAPITAL O
unicode_core_property(0x1D54A, 0x1D550, 'XID_Continue').	% L&   [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
unicode_core_property(0x1D552, 0x1D6A5, 'XID_Continue').	% L& [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
unicode_core_property(0x1D6A8, 0x1D6C0, 'XID_Continue').	% L&  [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
unicode_core_property(0x1D6C2, 0x1D6DA, 'XID_Continue').	% L&  [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
unicode_core_property(0x1D6DC, 0x1D6FA, 'XID_Continue').	% L&  [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
unicode_core_property(0x1D6FC, 0x1D714, 'XID_Continue').	% L&  [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
unicode_core_property(0x1D716, 0x1D734, 'XID_Continue').	% L&  [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D736, 0x1D74E, 'XID_Continue').	% L&  [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D750, 0x1D76E, 'XID_Continue').	% L&  [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
unicode_core_property(0x1D770, 0x1D788, 'XID_Continue').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
unicode_core_property(0x1D78A, 0x1D7A8, 'XID_Continue').	% L&  [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
unicode_core_property(0x1D7AA, 0x1D7C2, 'XID_Continue').	% L&  [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
unicode_core_property(0x1D7C4, 0x1D7CB, 'XID_Continue').	% L&   [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
unicode_core_property(0x1D7CE, 0x1D7FF, 'XID_Continue').	% Nd  [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
unicode_core_property(0x1EE00, 0x1EE03, 'XID_Continue').	% Lo   [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
unicode_core_property(0x1EE05, 0x1EE1F, 'XID_Continue').	% Lo  [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
unicode_core_property(0x1EE21, 0x1EE22, 'XID_Continue').	% Lo   [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
unicode_core_property(0x1EE24, 0x1EE24, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL HEH
unicode_core_property(0x1EE27, 0x1EE27, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL HAH
unicode_core_property(0x1EE29, 0x1EE32, 'XID_Continue').	% Lo  [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
unicode_core_property(0x1EE34, 0x1EE37, 'XID_Continue').	% Lo   [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
unicode_core_property(0x1EE39, 0x1EE39, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL DAD
unicode_core_property(0x1EE3B, 0x1EE3B, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL INITIAL GHAIN
unicode_core_property(0x1EE42, 0x1EE42, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED JEEM
unicode_core_property(0x1EE47, 0x1EE47, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED HAH
unicode_core_property(0x1EE49, 0x1EE49, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED YEH
unicode_core_property(0x1EE4B, 0x1EE4B, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED LAM
unicode_core_property(0x1EE4D, 0x1EE4F, 'XID_Continue').	% Lo   [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
unicode_core_property(0x1EE51, 0x1EE52, 'XID_Continue').	% Lo   [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
unicode_core_property(0x1EE54, 0x1EE54, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED SHEEN
unicode_core_property(0x1EE57, 0x1EE57, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED KHAH
unicode_core_property(0x1EE59, 0x1EE59, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DAD
unicode_core_property(0x1EE5B, 0x1EE5B, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED GHAIN
unicode_core_property(0x1EE5D, 0x1EE5D, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS NOON
unicode_core_property(0x1EE5F, 0x1EE5F, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL TAILED DOTLESS QAF
unicode_core_property(0x1EE61, 0x1EE62, 'XID_Continue').	% Lo   [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
unicode_core_property(0x1EE64, 0x1EE64, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL STRETCHED HEH
unicode_core_property(0x1EE67, 0x1EE6A, 'XID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
unicode_core_property(0x1EE6C, 0x1EE72, 'XID_Continue').	% Lo   [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
unicode_core_property(0x1EE74, 0x1EE77, 'XID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
unicode_core_property(0x1EE79, 0x1EE7C, 'XID_Continue').	% Lo   [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
unicode_core_property(0x1EE7E, 0x1EE7E, 'XID_Continue').	% Lo       ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
unicode_core_property(0x1EE80, 0x1EE89, 'XID_Continue').	% Lo  [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
unicode_core_property(0x1EE8B, 0x1EE9B, 'XID_Continue').	% Lo  [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
unicode_core_property(0x1EEA1, 0x1EEA3, 'XID_Continue').	% Lo   [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
unicode_core_property(0x1EEA5, 0x1EEA9, 'XID_Continue').	% Lo   [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
unicode_core_property(0x1EEAB, 0x1EEBB, 'XID_Continue').	% Lo  [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
unicode_core_property(0x20000, 0x2A6D6, 'XID_Continue').	% Lo [42711] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6D6
unicode_core_property(0x2A700, 0x2B734, 'XID_Continue').	% Lo [4149] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B734
unicode_core_property(0x2B740, 0x2B81D, 'XID_Continue').	% Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
unicode_core_property(0x2F800, 0x2FA1D, 'XID_Continue').	% Lo [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
unicode_core_property(0xE0100, 0xE01EF, 'XID_Continue').	% Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256

% Total code points: 103336

% ================================================

% Derived Property: Default_Ignorable_Code_Point
%  Generated from
%    Other_Default_Ignorable_Code_Point
%  + Cf (Format characters)
%  + Variation_Selector
%  - White_Space
%  - FFF9..FFFB (Annotation Characters)
%  - 0600..0604, 06DD, 070F, 110BD (exceptional Cf characters that should be visible)

unicode_core_property(0x00AD, 0x00AD, 'Default_Ignorable_Code_Point').	% Cf       SOFT HYPHEN
unicode_core_property(0x034F, 0x034F, 'Default_Ignorable_Code_Point').	% Mn       COMBINING GRAPHEME JOINER
unicode_core_property(0x115F, 0x1160, 'Default_Ignorable_Code_Point').	% Lo   [2] HANGUL CHOSEONG FILLER..HANGUL JUNGSEONG FILLER
unicode_core_property(0x17B4, 0x17B5, 'Default_Ignorable_Code_Point').	% Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
unicode_core_property(0x180B, 0x180D, 'Default_Ignorable_Code_Point').	% Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
unicode_core_property(0x200B, 0x200F, 'Default_Ignorable_Code_Point').	% Cf   [5] ZERO WIDTH SPACE..RIGHT-TO-LEFT MARK
unicode_core_property(0x202A, 0x202E, 'Default_Ignorable_Code_Point').	% Cf   [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
unicode_core_property(0x2060, 0x2064, 'Default_Ignorable_Code_Point').	% Cf   [5] WORD JOINER..INVISIBLE PLUS
unicode_core_property(0x2065, 0x2069, 'Default_Ignorable_Code_Point').	% Cn   [5] <reserved-2065>..<reserved-2069>
unicode_core_property(0x206A, 0x206F, 'Default_Ignorable_Code_Point').	% Cf   [6] INHIBIT SYMMETRIC SWAPPING..NOMINAL DIGIT SHAPES
unicode_core_property(0x3164, 0x3164, 'Default_Ignorable_Code_Point').	% Lo       HANGUL FILLER
unicode_core_property(0xFE00, 0xFE0F, 'Default_Ignorable_Code_Point').	% Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
unicode_core_property(0xFEFF, 0xFEFF, 'Default_Ignorable_Code_Point').	% Cf       ZERO WIDTH NO-BREAK SPACE
unicode_core_property(0xFFA0, 0xFFA0, 'Default_Ignorable_Code_Point').	% Lo       HALFWIDTH HANGUL FILLER
unicode_core_property(0xFFF0, 0xFFF8, 'Default_Ignorable_Code_Point').	% Cn   [9] <reserved-FFF0>..<reserved-FFF8>
unicode_core_property(0x1D173, 0x1D17A, 'Default_Ignorable_Code_Point').	% Cf   [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
unicode_core_property(0xE0000, 0xE0000, 'Default_Ignorable_Code_Point').	% Cn       <reserved-E0000>
unicode_core_property(0xE0001, 0xE0001, 'Default_Ignorable_Code_Point').	% Cf       LANGUAGE TAG
unicode_core_property(0xE0002, 0xE001F, 'Default_Ignorable_Code_Point').	% Cn  [30] <reserved-E0002>..<reserved-E001F>
unicode_core_property(0xE0020, 0xE007F, 'Default_Ignorable_Code_Point').	% Cf  [96] TAG SPACE..CANCEL TAG
unicode_core_property(0xE0080, 0xE00FF, 'Default_Ignorable_Code_Point').	% Cn [128] <reserved-E0080>..<reserved-E00FF>
unicode_core_property(0xE0100, 0xE01EF, 'Default_Ignorable_Code_Point').	% Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
unicode_core_property(0xE01F0, 0xE0FFF, 'Default_Ignorable_Code_Point').	% Cn [3600] <reserved-E01F0>..<reserved-E0FFF>

% Total code points: 4167

% ================================================

% Derived Property: Grapheme_Extend
%  Generated from: Me + Mn + Other_Grapheme_Extend
%  Note: depending on an application's interpretation of Co (private use),
%  they may be either in Grapheme_Base, or in Grapheme_Extend, or in neither.

unicode_core_property(0x0300, 0x036F, 'Grapheme_Extend').	% Mn [112] COMBINING GRAVE ACCENT..COMBINING LATIN SMALL LETTER X
unicode_core_property(0x0483, 0x0487, 'Grapheme_Extend').	% Mn   [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
unicode_core_property(0x0488, 0x0489, 'Grapheme_Extend').	% Me   [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
unicode_core_property(0x0591, 0x05BD, 'Grapheme_Extend').	% Mn  [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
unicode_core_property(0x05BF, 0x05BF, 'Grapheme_Extend').	% Mn       HEBREW POINT RAFE
unicode_core_property(0x05C1, 0x05C2, 'Grapheme_Extend').	% Mn   [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
unicode_core_property(0x05C4, 0x05C5, 'Grapheme_Extend').	% Mn   [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
unicode_core_property(0x05C7, 0x05C7, 'Grapheme_Extend').	% Mn       HEBREW POINT QAMATS QATAN
unicode_core_property(0x0610, 0x061A, 'Grapheme_Extend').	% Mn  [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
unicode_core_property(0x064B, 0x065F, 'Grapheme_Extend').	% Mn  [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
unicode_core_property(0x0670, 0x0670, 'Grapheme_Extend').	% Mn       ARABIC LETTER SUPERSCRIPT ALEF
unicode_core_property(0x06D6, 0x06DC, 'Grapheme_Extend').	% Mn   [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
unicode_core_property(0x06DF, 0x06E4, 'Grapheme_Extend').	% Mn   [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
unicode_core_property(0x06E7, 0x06E8, 'Grapheme_Extend').	% Mn   [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
unicode_core_property(0x06EA, 0x06ED, 'Grapheme_Extend').	% Mn   [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
unicode_core_property(0x0711, 0x0711, 'Grapheme_Extend').	% Mn       SYRIAC LETTER SUPERSCRIPT ALAPH
unicode_core_property(0x0730, 0x074A, 'Grapheme_Extend').	% Mn  [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
unicode_core_property(0x07A6, 0x07B0, 'Grapheme_Extend').	% Mn  [11] THAANA ABAFILI..THAANA SUKUN
unicode_core_property(0x07EB, 0x07F3, 'Grapheme_Extend').	% Mn   [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
unicode_core_property(0x0816, 0x0819, 'Grapheme_Extend').	% Mn   [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
unicode_core_property(0x081B, 0x0823, 'Grapheme_Extend').	% Mn   [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
unicode_core_property(0x0825, 0x0827, 'Grapheme_Extend').	% Mn   [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
unicode_core_property(0x0829, 0x082D, 'Grapheme_Extend').	% Mn   [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
unicode_core_property(0x0859, 0x085B, 'Grapheme_Extend').	% Mn   [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
unicode_core_property(0x08E4, 0x08FE, 'Grapheme_Extend').	% Mn  [27] ARABIC CURLY FATHA..ARABIC DAMMA WITH DOT
unicode_core_property(0x0900, 0x0902, 'Grapheme_Extend').	% Mn   [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
unicode_core_property(0x093A, 0x093A, 'Grapheme_Extend').	% Mn       DEVANAGARI VOWEL SIGN OE
unicode_core_property(0x093C, 0x093C, 'Grapheme_Extend').	% Mn       DEVANAGARI SIGN NUKTA
unicode_core_property(0x0941, 0x0948, 'Grapheme_Extend').	% Mn   [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
unicode_core_property(0x094D, 0x094D, 'Grapheme_Extend').	% Mn       DEVANAGARI SIGN VIRAMA
unicode_core_property(0x0951, 0x0957, 'Grapheme_Extend').	% Mn   [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
unicode_core_property(0x0962, 0x0963, 'Grapheme_Extend').	% Mn   [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0981, 0x0981, 'Grapheme_Extend').	% Mn       BENGALI SIGN CANDRABINDU
unicode_core_property(0x09BC, 0x09BC, 'Grapheme_Extend').	% Mn       BENGALI SIGN NUKTA
unicode_core_property(0x09BE, 0x09BE, 'Grapheme_Extend').	% Mc       BENGALI VOWEL SIGN AA
unicode_core_property(0x09C1, 0x09C4, 'Grapheme_Extend').	% Mn   [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
unicode_core_property(0x09CD, 0x09CD, 'Grapheme_Extend').	% Mn       BENGALI SIGN VIRAMA
unicode_core_property(0x09D7, 0x09D7, 'Grapheme_Extend').	% Mc       BENGALI AU LENGTH MARK
unicode_core_property(0x09E2, 0x09E3, 'Grapheme_Extend').	% Mn   [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0A01, 0x0A02, 'Grapheme_Extend').	% Mn   [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
unicode_core_property(0x0A3C, 0x0A3C, 'Grapheme_Extend').	% Mn       GURMUKHI SIGN NUKTA
unicode_core_property(0x0A41, 0x0A42, 'Grapheme_Extend').	% Mn   [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
unicode_core_property(0x0A47, 0x0A48, 'Grapheme_Extend').	% Mn   [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
unicode_core_property(0x0A4B, 0x0A4D, 'Grapheme_Extend').	% Mn   [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
unicode_core_property(0x0A51, 0x0A51, 'Grapheme_Extend').	% Mn       GURMUKHI SIGN UDAAT
unicode_core_property(0x0A70, 0x0A71, 'Grapheme_Extend').	% Mn   [2] GURMUKHI TIPPI..GURMUKHI ADDAK
unicode_core_property(0x0A75, 0x0A75, 'Grapheme_Extend').	% Mn       GURMUKHI SIGN YAKASH
unicode_core_property(0x0A81, 0x0A82, 'Grapheme_Extend').	% Mn   [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
unicode_core_property(0x0ABC, 0x0ABC, 'Grapheme_Extend').	% Mn       GUJARATI SIGN NUKTA
unicode_core_property(0x0AC1, 0x0AC5, 'Grapheme_Extend').	% Mn   [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
unicode_core_property(0x0AC7, 0x0AC8, 'Grapheme_Extend').	% Mn   [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
unicode_core_property(0x0ACD, 0x0ACD, 'Grapheme_Extend').	% Mn       GUJARATI SIGN VIRAMA
unicode_core_property(0x0AE2, 0x0AE3, 'Grapheme_Extend').	% Mn   [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B01, 0x0B01, 'Grapheme_Extend').	% Mn       ORIYA SIGN CANDRABINDU
unicode_core_property(0x0B3C, 0x0B3C, 'Grapheme_Extend').	% Mn       ORIYA SIGN NUKTA
unicode_core_property(0x0B3E, 0x0B3E, 'Grapheme_Extend').	% Mc       ORIYA VOWEL SIGN AA
unicode_core_property(0x0B3F, 0x0B3F, 'Grapheme_Extend').	% Mn       ORIYA VOWEL SIGN I
unicode_core_property(0x0B41, 0x0B44, 'Grapheme_Extend').	% Mn   [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0B4D, 0x0B4D, 'Grapheme_Extend').	% Mn       ORIYA SIGN VIRAMA
unicode_core_property(0x0B56, 0x0B56, 'Grapheme_Extend').	% Mn       ORIYA AI LENGTH MARK
unicode_core_property(0x0B57, 0x0B57, 'Grapheme_Extend').	% Mc       ORIYA AU LENGTH MARK
unicode_core_property(0x0B62, 0x0B63, 'Grapheme_Extend').	% Mn   [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0B82, 0x0B82, 'Grapheme_Extend').	% Mn       TAMIL SIGN ANUSVARA
unicode_core_property(0x0BBE, 0x0BBE, 'Grapheme_Extend').	% Mc       TAMIL VOWEL SIGN AA
unicode_core_property(0x0BC0, 0x0BC0, 'Grapheme_Extend').	% Mn       TAMIL VOWEL SIGN II
unicode_core_property(0x0BCD, 0x0BCD, 'Grapheme_Extend').	% Mn       TAMIL SIGN VIRAMA
unicode_core_property(0x0BD7, 0x0BD7, 'Grapheme_Extend').	% Mc       TAMIL AU LENGTH MARK
unicode_core_property(0x0C3E, 0x0C40, 'Grapheme_Extend').	% Mn   [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
unicode_core_property(0x0C46, 0x0C48, 'Grapheme_Extend').	% Mn   [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
unicode_core_property(0x0C4A, 0x0C4D, 'Grapheme_Extend').	% Mn   [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
unicode_core_property(0x0C55, 0x0C56, 'Grapheme_Extend').	% Mn   [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
unicode_core_property(0x0C62, 0x0C63, 'Grapheme_Extend').	% Mn   [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
unicode_core_property(0x0CBC, 0x0CBC, 'Grapheme_Extend').	% Mn       KANNADA SIGN NUKTA
unicode_core_property(0x0CBF, 0x0CBF, 'Grapheme_Extend').	% Mn       KANNADA VOWEL SIGN I
unicode_core_property(0x0CC2, 0x0CC2, 'Grapheme_Extend').	% Mc       KANNADA VOWEL SIGN UU
unicode_core_property(0x0CC6, 0x0CC6, 'Grapheme_Extend').	% Mn       KANNADA VOWEL SIGN E
unicode_core_property(0x0CCC, 0x0CCD, 'Grapheme_Extend').	% Mn   [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
unicode_core_property(0x0CD5, 0x0CD6, 'Grapheme_Extend').	% Mc   [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
unicode_core_property(0x0CE2, 0x0CE3, 'Grapheme_Extend').	% Mn   [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
unicode_core_property(0x0D3E, 0x0D3E, 'Grapheme_Extend').	% Mc       MALAYALAM VOWEL SIGN AA
unicode_core_property(0x0D41, 0x0D44, 'Grapheme_Extend').	% Mn   [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
unicode_core_property(0x0D4D, 0x0D4D, 'Grapheme_Extend').	% Mn       MALAYALAM SIGN VIRAMA
unicode_core_property(0x0D57, 0x0D57, 'Grapheme_Extend').	% Mc       MALAYALAM AU LENGTH MARK
unicode_core_property(0x0D62, 0x0D63, 'Grapheme_Extend').	% Mn   [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
unicode_core_property(0x0DCA, 0x0DCA, 'Grapheme_Extend').	% Mn       SINHALA SIGN AL-LAKUNA
unicode_core_property(0x0DCF, 0x0DCF, 'Grapheme_Extend').	% Mc       SINHALA VOWEL SIGN AELA-PILLA
unicode_core_property(0x0DD2, 0x0DD4, 'Grapheme_Extend').	% Mn   [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
unicode_core_property(0x0DD6, 0x0DD6, 'Grapheme_Extend').	% Mn       SINHALA VOWEL SIGN DIGA PAA-PILLA
unicode_core_property(0x0DDF, 0x0DDF, 'Grapheme_Extend').	% Mc       SINHALA VOWEL SIGN GAYANUKITTA
unicode_core_property(0x0E31, 0x0E31, 'Grapheme_Extend').	% Mn       THAI CHARACTER MAI HAN-AKAT
unicode_core_property(0x0E34, 0x0E3A, 'Grapheme_Extend').	% Mn   [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
unicode_core_property(0x0E47, 0x0E4E, 'Grapheme_Extend').	% Mn   [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
unicode_core_property(0x0EB1, 0x0EB1, 'Grapheme_Extend').	% Mn       LAO VOWEL SIGN MAI KAN
unicode_core_property(0x0EB4, 0x0EB9, 'Grapheme_Extend').	% Mn   [6] LAO VOWEL SIGN I..LAO VOWEL SIGN UU
unicode_core_property(0x0EBB, 0x0EBC, 'Grapheme_Extend').	% Mn   [2] LAO VOWEL SIGN MAI KON..LAO SEMIVOWEL SIGN LO
unicode_core_property(0x0EC8, 0x0ECD, 'Grapheme_Extend').	% Mn   [6] LAO TONE MAI EK..LAO NIGGAHITA
unicode_core_property(0x0F18, 0x0F19, 'Grapheme_Extend').	% Mn   [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
unicode_core_property(0x0F35, 0x0F35, 'Grapheme_Extend').	% Mn       TIBETAN MARK NGAS BZUNG NYI ZLA
unicode_core_property(0x0F37, 0x0F37, 'Grapheme_Extend').	% Mn       TIBETAN MARK NGAS BZUNG SGOR RTAGS
unicode_core_property(0x0F39, 0x0F39, 'Grapheme_Extend').	% Mn       TIBETAN MARK TSA -PHRU
unicode_core_property(0x0F71, 0x0F7E, 'Grapheme_Extend').	% Mn  [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
unicode_core_property(0x0F80, 0x0F84, 'Grapheme_Extend').	% Mn   [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
unicode_core_property(0x0F86, 0x0F87, 'Grapheme_Extend').	% Mn   [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
unicode_core_property(0x0F8D, 0x0F97, 'Grapheme_Extend').	% Mn  [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
unicode_core_property(0x0F99, 0x0FBC, 'Grapheme_Extend').	% Mn  [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
unicode_core_property(0x0FC6, 0x0FC6, 'Grapheme_Extend').	% Mn       TIBETAN SYMBOL PADMA GDAN
unicode_core_property(0x102D, 0x1030, 'Grapheme_Extend').	% Mn   [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
unicode_core_property(0x1032, 0x1037, 'Grapheme_Extend').	% Mn   [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
unicode_core_property(0x1039, 0x103A, 'Grapheme_Extend').	% Mn   [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
unicode_core_property(0x103D, 0x103E, 'Grapheme_Extend').	% Mn   [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
unicode_core_property(0x1058, 0x1059, 'Grapheme_Extend').	% Mn   [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
unicode_core_property(0x105E, 0x1060, 'Grapheme_Extend').	% Mn   [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
unicode_core_property(0x1071, 0x1074, 'Grapheme_Extend').	% Mn   [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
unicode_core_property(0x1082, 0x1082, 'Grapheme_Extend').	% Mn       MYANMAR CONSONANT SIGN SHAN MEDIAL WA
unicode_core_property(0x1085, 0x1086, 'Grapheme_Extend').	% Mn   [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
unicode_core_property(0x108D, 0x108D, 'Grapheme_Extend').	% Mn       MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
unicode_core_property(0x109D, 0x109D, 'Grapheme_Extend').	% Mn       MYANMAR VOWEL SIGN AITON AI
unicode_core_property(0x135D, 0x135F, 'Grapheme_Extend').	% Mn   [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
unicode_core_property(0x1712, 0x1714, 'Grapheme_Extend').	% Mn   [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
unicode_core_property(0x1732, 0x1734, 'Grapheme_Extend').	% Mn   [3] HANUNOO VOWEL SIGN I..HANUNOO SIGN PAMUDPOD
unicode_core_property(0x1752, 0x1753, 'Grapheme_Extend').	% Mn   [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
unicode_core_property(0x1772, 0x1773, 'Grapheme_Extend').	% Mn   [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
unicode_core_property(0x17B4, 0x17B5, 'Grapheme_Extend').	% Mn   [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
unicode_core_property(0x17B7, 0x17BD, 'Grapheme_Extend').	% Mn   [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
unicode_core_property(0x17C6, 0x17C6, 'Grapheme_Extend').	% Mn       KHMER SIGN NIKAHIT
unicode_core_property(0x17C9, 0x17D3, 'Grapheme_Extend').	% Mn  [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
unicode_core_property(0x17DD, 0x17DD, 'Grapheme_Extend').	% Mn       KHMER SIGN ATTHACAN
unicode_core_property(0x180B, 0x180D, 'Grapheme_Extend').	% Mn   [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
unicode_core_property(0x18A9, 0x18A9, 'Grapheme_Extend').	% Mn       MONGOLIAN LETTER ALI GALI DAGALGA
unicode_core_property(0x1920, 0x1922, 'Grapheme_Extend').	% Mn   [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
unicode_core_property(0x1927, 0x1928, 'Grapheme_Extend').	% Mn   [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
unicode_core_property(0x1932, 0x1932, 'Grapheme_Extend').	% Mn       LIMBU SMALL LETTER ANUSVARA
unicode_core_property(0x1939, 0x193B, 'Grapheme_Extend').	% Mn   [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
unicode_core_property(0x1A17, 0x1A18, 'Grapheme_Extend').	% Mn   [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
unicode_core_property(0x1A56, 0x1A56, 'Grapheme_Extend').	% Mn       TAI THAM CONSONANT SIGN MEDIAL LA
unicode_core_property(0x1A58, 0x1A5E, 'Grapheme_Extend').	% Mn   [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
unicode_core_property(0x1A60, 0x1A60, 'Grapheme_Extend').	% Mn       TAI THAM SIGN SAKOT
unicode_core_property(0x1A62, 0x1A62, 'Grapheme_Extend').	% Mn       TAI THAM VOWEL SIGN MAI SAT
unicode_core_property(0x1A65, 0x1A6C, 'Grapheme_Extend').	% Mn   [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
unicode_core_property(0x1A73, 0x1A7C, 'Grapheme_Extend').	% Mn  [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
unicode_core_property(0x1A7F, 0x1A7F, 'Grapheme_Extend').	% Mn       TAI THAM COMBINING CRYPTOGRAMMIC DOT
unicode_core_property(0x1B00, 0x1B03, 'Grapheme_Extend').	% Mn   [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
unicode_core_property(0x1B34, 0x1B34, 'Grapheme_Extend').	% Mn       BALINESE SIGN REREKAN
unicode_core_property(0x1B36, 0x1B3A, 'Grapheme_Extend').	% Mn   [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
unicode_core_property(0x1B3C, 0x1B3C, 'Grapheme_Extend').	% Mn       BALINESE VOWEL SIGN LA LENGA
unicode_core_property(0x1B42, 0x1B42, 'Grapheme_Extend').	% Mn       BALINESE VOWEL SIGN PEPET
unicode_core_property(0x1B6B, 0x1B73, 'Grapheme_Extend').	% Mn   [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
unicode_core_property(0x1B80, 0x1B81, 'Grapheme_Extend').	% Mn   [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
unicode_core_property(0x1BA2, 0x1BA5, 'Grapheme_Extend').	% Mn   [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
unicode_core_property(0x1BA8, 0x1BA9, 'Grapheme_Extend').	% Mn   [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
unicode_core_property(0x1BAB, 0x1BAB, 'Grapheme_Extend').	% Mn       SUNDANESE SIGN VIRAMA
unicode_core_property(0x1BE6, 0x1BE6, 'Grapheme_Extend').	% Mn       BATAK SIGN TOMPI
unicode_core_property(0x1BE8, 0x1BE9, 'Grapheme_Extend').	% Mn   [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
unicode_core_property(0x1BED, 0x1BED, 'Grapheme_Extend').	% Mn       BATAK VOWEL SIGN KARO O
unicode_core_property(0x1BEF, 0x1BF1, 'Grapheme_Extend').	% Mn   [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
unicode_core_property(0x1C2C, 0x1C33, 'Grapheme_Extend').	% Mn   [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
unicode_core_property(0x1C36, 0x1C37, 'Grapheme_Extend').	% Mn   [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
unicode_core_property(0x1CD0, 0x1CD2, 'Grapheme_Extend').	% Mn   [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
unicode_core_property(0x1CD4, 0x1CE0, 'Grapheme_Extend').	% Mn  [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
unicode_core_property(0x1CE2, 0x1CE8, 'Grapheme_Extend').	% Mn   [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
unicode_core_property(0x1CED, 0x1CED, 'Grapheme_Extend').	% Mn       VEDIC SIGN TIRYAK
unicode_core_property(0x1CF4, 0x1CF4, 'Grapheme_Extend').	% Mn       VEDIC TONE CANDRA ABOVE
unicode_core_property(0x1DC0, 0x1DE6, 'Grapheme_Extend').	% Mn  [39] COMBINING DOTTED GRAVE ACCENT..COMBINING LATIN SMALL LETTER Z
unicode_core_property(0x1DFC, 0x1DFF, 'Grapheme_Extend').	% Mn   [4] COMBINING DOUBLE INVERTED BREVE BELOW..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
unicode_core_property(0x200C, 0x200D, 'Grapheme_Extend').	% Cf   [2] ZERO WIDTH NON-JOINER..ZERO WIDTH JOINER
unicode_core_property(0x20D0, 0x20DC, 'Grapheme_Extend').	% Mn  [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
unicode_core_property(0x20DD, 0x20E0, 'Grapheme_Extend').	% Me   [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
unicode_core_property(0x20E1, 0x20E1, 'Grapheme_Extend').	% Mn       COMBINING LEFT RIGHT ARROW ABOVE
unicode_core_property(0x20E2, 0x20E4, 'Grapheme_Extend').	% Me   [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
unicode_core_property(0x20E5, 0x20F0, 'Grapheme_Extend').	% Mn  [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
unicode_core_property(0x2CEF, 0x2CF1, 'Grapheme_Extend').	% Mn   [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
unicode_core_property(0x2D7F, 0x2D7F, 'Grapheme_Extend').	% Mn       TIFINAGH CONSONANT JOINER
unicode_core_property(0x2DE0, 0x2DFF, 'Grapheme_Extend').	% Mn  [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
unicode_core_property(0x302A, 0x302D, 'Grapheme_Extend').	% Mn   [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
unicode_core_property(0x302E, 0x302F, 'Grapheme_Extend').	% Mc   [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
unicode_core_property(0x3099, 0x309A, 'Grapheme_Extend').	% Mn   [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
unicode_core_property(0xA66F, 0xA66F, 'Grapheme_Extend').	% Mn       COMBINING CYRILLIC VZMET
unicode_core_property(0xA670, 0xA672, 'Grapheme_Extend').	% Me   [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
unicode_core_property(0xA674, 0xA67D, 'Grapheme_Extend').	% Mn  [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
unicode_core_property(0xA69F, 0xA69F, 'Grapheme_Extend').	% Mn       COMBINING CYRILLIC LETTER IOTIFIED E
unicode_core_property(0xA6F0, 0xA6F1, 'Grapheme_Extend').	% Mn   [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
unicode_core_property(0xA802, 0xA802, 'Grapheme_Extend').	% Mn       SYLOTI NAGRI SIGN DVISVARA
unicode_core_property(0xA806, 0xA806, 'Grapheme_Extend').	% Mn       SYLOTI NAGRI SIGN HASANTA
unicode_core_property(0xA80B, 0xA80B, 'Grapheme_Extend').	% Mn       SYLOTI NAGRI SIGN ANUSVARA
unicode_core_property(0xA825, 0xA826, 'Grapheme_Extend').	% Mn   [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
unicode_core_property(0xA8C4, 0xA8C4, 'Grapheme_Extend').	% Mn       SAURASHTRA SIGN VIRAMA
unicode_core_property(0xA8E0, 0xA8F1, 'Grapheme_Extend').	% Mn  [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0xA926, 0xA92D, 'Grapheme_Extend').	% Mn   [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
unicode_core_property(0xA947, 0xA951, 'Grapheme_Extend').	% Mn  [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
unicode_core_property(0xA980, 0xA982, 'Grapheme_Extend').	% Mn   [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
unicode_core_property(0xA9B3, 0xA9B3, 'Grapheme_Extend').	% Mn       JAVANESE SIGN CECAK TELU
unicode_core_property(0xA9B6, 0xA9B9, 'Grapheme_Extend').	% Mn   [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
unicode_core_property(0xA9BC, 0xA9BC, 'Grapheme_Extend').	% Mn       JAVANESE VOWEL SIGN PEPET
unicode_core_property(0xAA29, 0xAA2E, 'Grapheme_Extend').	% Mn   [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
unicode_core_property(0xAA31, 0xAA32, 'Grapheme_Extend').	% Mn   [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
unicode_core_property(0xAA35, 0xAA36, 'Grapheme_Extend').	% Mn   [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
unicode_core_property(0xAA43, 0xAA43, 'Grapheme_Extend').	% Mn       CHAM CONSONANT SIGN FINAL NG
unicode_core_property(0xAA4C, 0xAA4C, 'Grapheme_Extend').	% Mn       CHAM CONSONANT SIGN FINAL M
unicode_core_property(0xAAB0, 0xAAB0, 'Grapheme_Extend').	% Mn       TAI VIET MAI KANG
unicode_core_property(0xAAB2, 0xAAB4, 'Grapheme_Extend').	% Mn   [3] TAI VIET VOWEL I..TAI VIET VOWEL U
unicode_core_property(0xAAB7, 0xAAB8, 'Grapheme_Extend').	% Mn   [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
unicode_core_property(0xAABE, 0xAABF, 'Grapheme_Extend').	% Mn   [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
unicode_core_property(0xAAC1, 0xAAC1, 'Grapheme_Extend').	% Mn       TAI VIET TONE MAI THO
unicode_core_property(0xAAEC, 0xAAED, 'Grapheme_Extend').	% Mn   [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
unicode_core_property(0xAAF6, 0xAAF6, 'Grapheme_Extend').	% Mn       MEETEI MAYEK VIRAMA
unicode_core_property(0xABE5, 0xABE5, 'Grapheme_Extend').	% Mn       MEETEI MAYEK VOWEL SIGN ANAP
unicode_core_property(0xABE8, 0xABE8, 'Grapheme_Extend').	% Mn       MEETEI MAYEK VOWEL SIGN UNAP
unicode_core_property(0xABED, 0xABED, 'Grapheme_Extend').	% Mn       MEETEI MAYEK APUN IYEK
unicode_core_property(0xFB1E, 0xFB1E, 'Grapheme_Extend').	% Mn       HEBREW POINT JUDEO-SPANISH VARIKA
unicode_core_property(0xFE00, 0xFE0F, 'Grapheme_Extend').	% Mn  [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
unicode_core_property(0xFE20, 0xFE26, 'Grapheme_Extend').	% Mn   [7] COMBINING LIGATURE LEFT HALF..COMBINING CONJOINING MACRON
unicode_core_property(0xFF9E, 0xFF9F, 'Grapheme_Extend').	% Lm   [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
unicode_core_property(0x101FD, 0x101FD, 'Grapheme_Extend').	% Mn       PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
unicode_core_property(0x10A01, 0x10A03, 'Grapheme_Extend').	% Mn   [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
unicode_core_property(0x10A05, 0x10A06, 'Grapheme_Extend').	% Mn   [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
unicode_core_property(0x10A0C, 0x10A0F, 'Grapheme_Extend').	% Mn   [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
unicode_core_property(0x10A38, 0x10A3A, 'Grapheme_Extend').	% Mn   [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
unicode_core_property(0x10A3F, 0x10A3F, 'Grapheme_Extend').	% Mn       KHAROSHTHI VIRAMA
unicode_core_property(0x11001, 0x11001, 'Grapheme_Extend').	% Mn       BRAHMI SIGN ANUSVARA
unicode_core_property(0x11038, 0x11046, 'Grapheme_Extend').	% Mn  [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
unicode_core_property(0x11080, 0x11081, 'Grapheme_Extend').	% Mn   [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
unicode_core_property(0x110B3, 0x110B6, 'Grapheme_Extend').	% Mn   [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
unicode_core_property(0x110B9, 0x110BA, 'Grapheme_Extend').	% Mn   [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
unicode_core_property(0x11100, 0x11102, 'Grapheme_Extend').	% Mn   [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
unicode_core_property(0x11127, 0x1112B, 'Grapheme_Extend').	% Mn   [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
unicode_core_property(0x1112D, 0x11134, 'Grapheme_Extend').	% Mn   [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
unicode_core_property(0x11180, 0x11181, 'Grapheme_Extend').	% Mn   [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
unicode_core_property(0x111B6, 0x111BE, 'Grapheme_Extend').	% Mn   [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
unicode_core_property(0x116AB, 0x116AB, 'Grapheme_Extend').	% Mn       TAKRI SIGN ANUSVARA
unicode_core_property(0x116AD, 0x116AD, 'Grapheme_Extend').	% Mn       TAKRI VOWEL SIGN AA
unicode_core_property(0x116B0, 0x116B5, 'Grapheme_Extend').	% Mn   [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
unicode_core_property(0x116B7, 0x116B7, 'Grapheme_Extend').	% Mn       TAKRI SIGN NUKTA
unicode_core_property(0x16F8F, 0x16F92, 'Grapheme_Extend').	% Mn   [4] MIAO TONE RIGHT..MIAO TONE BELOW
unicode_core_property(0x1D165, 0x1D165, 'Grapheme_Extend').	% Mc       MUSICAL SYMBOL COMBINING STEM
unicode_core_property(0x1D167, 0x1D169, 'Grapheme_Extend').	% Mn   [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
unicode_core_property(0x1D16E, 0x1D172, 'Grapheme_Extend').	% Mc   [5] MUSICAL SYMBOL COMBINING FLAG-1..MUSICAL SYMBOL COMBINING FLAG-5
unicode_core_property(0x1D17B, 0x1D182, 'Grapheme_Extend').	% Mn   [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
unicode_core_property(0x1D185, 0x1D18B, 'Grapheme_Extend').	% Mn   [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
unicode_core_property(0x1D1AA, 0x1D1AD, 'Grapheme_Extend').	% Mn   [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
unicode_core_property(0x1D242, 0x1D244, 'Grapheme_Extend').	% Mn   [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
unicode_core_property(0xE0100, 0xE01EF, 'Grapheme_Extend').	% Mn [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256

% Total code points: 1317

% ================================================

% Derived Property: Grapheme_Base
%  Generated from: [0..10FFFF] - Cc - Cf - Cs - Co - Cn - Zl - Zp - Grapheme_Extend
%  Note: depending on an application's interpretation of Co (private use),
%  they may be either in Grapheme_Base, or in Grapheme_Extend, or in neither.

unicode_core_property(0x0020, 0x0020, 'Grapheme_Base').	% Zs       SPACE
unicode_core_property(0x0021, 0x0023, 'Grapheme_Base').	% Po   [3] EXCLAMATION MARK..NUMBER SIGN
unicode_core_property(0x0024, 0x0024, 'Grapheme_Base').	% Sc       DOLLAR SIGN
unicode_core_property(0x0025, 0x0027, 'Grapheme_Base').	% Po   [3] PERCENT SIGN..APOSTROPHE
unicode_core_property(0x0028, 0x0028, 'Grapheme_Base').	% Ps       LEFT PARENTHESIS
unicode_core_property(0x0029, 0x0029, 'Grapheme_Base').	% Pe       RIGHT PARENTHESIS
unicode_core_property(0x002A, 0x002A, 'Grapheme_Base').	% Po       ASTERISK
unicode_core_property(0x002B, 0x002B, 'Grapheme_Base').	% Sm       PLUS SIGN
unicode_core_property(0x002C, 0x002C, 'Grapheme_Base').	% Po       COMMA
unicode_core_property(0x002D, 0x002D, 'Grapheme_Base').	% Pd       HYPHEN-MINUS
unicode_core_property(0x002E, 0x002F, 'Grapheme_Base').	% Po   [2] FULL STOP..SOLIDUS
unicode_core_property(0x0030, 0x0039, 'Grapheme_Base').	% Nd  [10] DIGIT ZERO..DIGIT NINE
unicode_core_property(0x003A, 0x003B, 'Grapheme_Base').	% Po   [2] COLON..SEMICOLON
unicode_core_property(0x003C, 0x003E, 'Grapheme_Base').	% Sm   [3] LESS-THAN SIGN..GREATER-THAN SIGN
unicode_core_property(0x003F, 0x0040, 'Grapheme_Base').	% Po   [2] QUESTION MARK..COMMERCIAL AT
unicode_core_property(0x0041, 0x005A, 'Grapheme_Base').	% L&  [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
unicode_core_property(0x005B, 0x005B, 'Grapheme_Base').	% Ps       LEFT SQUARE BRACKET
unicode_core_property(0x005C, 0x005C, 'Grapheme_Base').	% Po       REVERSE SOLIDUS
unicode_core_property(0x005D, 0x005D, 'Grapheme_Base').	% Pe       RIGHT SQUARE BRACKET
unicode_core_property(0x005E, 0x005E, 'Grapheme_Base').	% Sk       CIRCUMFLEX ACCENT
unicode_core_property(0x005F, 0x005F, 'Grapheme_Base').	% Pc       LOW LINE
unicode_core_property(0x0060, 0x0060, 'Grapheme_Base').	% Sk       GRAVE ACCENT
unicode_core_property(0x0061, 0x007A, 'Grapheme_Base').	% L&  [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
unicode_core_property(0x007B, 0x007B, 'Grapheme_Base').	% Ps       LEFT CURLY BRACKET
unicode_core_property(0x007C, 0x007C, 'Grapheme_Base').	% Sm       VERTICAL LINE
unicode_core_property(0x007D, 0x007D, 'Grapheme_Base').	% Pe       RIGHT CURLY BRACKET
unicode_core_property(0x007E, 0x007E, 'Grapheme_Base').	% Sm       TILDE
unicode_core_property(0x00A0, 0x00A0, 'Grapheme_Base').	% Zs       NO-BREAK SPACE
unicode_core_property(0x00A1, 0x00A1, 'Grapheme_Base').	% Po       INVERTED EXCLAMATION MARK
unicode_core_property(0x00A2, 0x00A5, 'Grapheme_Base').	% Sc   [4] CENT SIGN..YEN SIGN
unicode_core_property(0x00A6, 0x00A6, 'Grapheme_Base').	% So       BROKEN BAR
unicode_core_property(0x00A7, 0x00A7, 'Grapheme_Base').	% Po       SECTION SIGN
unicode_core_property(0x00A8, 0x00A8, 'Grapheme_Base').	% Sk       DIAERESIS
unicode_core_property(0x00A9, 0x00A9, 'Grapheme_Base').	% So       COPYRIGHT SIGN
unicode_core_property(0x00AA, 0x00AA, 'Grapheme_Base').	% Lo       FEMININE ORDINAL INDICATOR
unicode_core_property(0x00AB, 0x00AB, 'Grapheme_Base').	% Pi       LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
unicode_core_property(0x00AC, 0x00AC, 'Grapheme_Base').	% Sm       NOT SIGN
unicode_core_property(0x00AE, 0x00AE, 'Grapheme_Base').	% So       REGISTERED SIGN
unicode_core_property(0x00AF, 0x00AF, 'Grapheme_Base').	% Sk       MACRON
unicode_core_property(0x00B0, 0x00B0, 'Grapheme_Base').	% So       DEGREE SIGN
unicode_core_property(0x00B1, 0x00B1, 'Grapheme_Base').	% Sm       PLUS-MINUS SIGN
unicode_core_property(0x00B2, 0x00B3, 'Grapheme_Base').	% No   [2] SUPERSCRIPT TWO..SUPERSCRIPT THREE
unicode_core_property(0x00B4, 0x00B4, 'Grapheme_Base').	% Sk       ACUTE ACCENT
unicode_core_property(0x00B5, 0x00B5, 'Grapheme_Base').	% L&       MICRO SIGN
unicode_core_property(0x00B6, 0x00B7, 'Grapheme_Base').	% Po   [2] PILCROW SIGN..MIDDLE DOT
unicode_core_property(0x00B8, 0x00B8, 'Grapheme_Base').	% Sk       CEDILLA
unicode_core_property(0x00B9, 0x00B9, 'Grapheme_Base').	% No       SUPERSCRIPT ONE
unicode_core_property(0x00BA, 0x00BA, 'Grapheme_Base').	% Lo       MASCULINE ORDINAL INDICATOR
unicode_core_property(0x00BB, 0x00BB, 'Grapheme_Base').	% Pf       RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
unicode_core_property(0x00BC, 0x00BE, 'Grapheme_Base').	% No   [3] VULGAR FRACTION ONE QUARTER..VULGAR FRACTION THREE QUARTERS
unicode_core_property(0x00BF, 0x00BF, 'Grapheme_Base').	% Po       INVERTED QUESTION MARK
unicode_core_property(0x00C0, 0x00D6, 'Grapheme_Base').	% L&  [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
unicode_core_property(0x00D7, 0x00D7, 'Grapheme_Base').	% Sm       MULTIPLICATION SIGN
unicode_core_property(0x00D8, 0x00F6, 'Grapheme_Base').	% L&  [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
unicode_core_property(0x00F7, 0x00F7, 'Grapheme_Base').	% Sm       DIVISION SIGN
unicode_core_property(0x00F8, 0x01BA, 'Grapheme_Base').	% L& [195] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
unicode_core_property(0x01BB, 0x01BB, 'Grapheme_Base').	% Lo       LATIN LETTER TWO WITH STROKE
unicode_core_property(0x01BC, 0x01BF, 'Grapheme_Base').	% L&   [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
unicode_core_property(0x01C0, 0x01C3, 'Grapheme_Base').	% Lo   [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
unicode_core_property(0x01C4, 0x0293, 'Grapheme_Base').	% L& [208] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER EZH WITH CURL
unicode_core_property(0x0294, 0x0294, 'Grapheme_Base').	% Lo       LATIN LETTER GLOTTAL STOP
unicode_core_property(0x0295, 0x02AF, 'Grapheme_Base').	% L&  [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
unicode_core_property(0x02B0, 0x02C1, 'Grapheme_Base').	% Lm  [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
unicode_core_property(0x02C2, 0x02C5, 'Grapheme_Base').	% Sk   [4] MODIFIER LETTER LEFT ARROWHEAD..MODIFIER LETTER DOWN ARROWHEAD
unicode_core_property(0x02C6, 0x02D1, 'Grapheme_Base').	% Lm  [12] MODIFIER LETTER CIRCUMFLEX ACCENT..MODIFIER LETTER HALF TRIANGULAR COLON
unicode_core_property(0x02D2, 0x02DF, 'Grapheme_Base').	% Sk  [14] MODIFIER LETTER CENTRED RIGHT HALF RING..MODIFIER LETTER CROSS ACCENT
unicode_core_property(0x02E0, 0x02E4, 'Grapheme_Base').	% Lm   [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
unicode_core_property(0x02E5, 0x02EB, 'Grapheme_Base').	% Sk   [7] MODIFIER LETTER EXTRA-HIGH TONE BAR..MODIFIER LETTER YANG DEPARTING TONE MARK
unicode_core_property(0x02EC, 0x02EC, 'Grapheme_Base').	% Lm       MODIFIER LETTER VOICING
unicode_core_property(0x02ED, 0x02ED, 'Grapheme_Base').	% Sk       MODIFIER LETTER UNASPIRATED
unicode_core_property(0x02EE, 0x02EE, 'Grapheme_Base').	% Lm       MODIFIER LETTER DOUBLE APOSTROPHE
unicode_core_property(0x02EF, 0x02FF, 'Grapheme_Base').	% Sk  [17] MODIFIER LETTER LOW DOWN ARROWHEAD..MODIFIER LETTER LOW LEFT ARROW
unicode_core_property(0x0370, 0x0373, 'Grapheme_Base').	% L&   [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
unicode_core_property(0x0374, 0x0374, 'Grapheme_Base').	% Lm       GREEK NUMERAL SIGN
unicode_core_property(0x0375, 0x0375, 'Grapheme_Base').	% Sk       GREEK LOWER NUMERAL SIGN
unicode_core_property(0x0376, 0x0377, 'Grapheme_Base').	% L&   [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
unicode_core_property(0x037A, 0x037A, 'Grapheme_Base').	% Lm       GREEK YPOGEGRAMMENI
unicode_core_property(0x037B, 0x037D, 'Grapheme_Base').	% L&   [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
unicode_core_property(0x037E, 0x037E, 'Grapheme_Base').	% Po       GREEK QUESTION MARK
unicode_core_property(0x0384, 0x0385, 'Grapheme_Base').	% Sk   [2] GREEK TONOS..GREEK DIALYTIKA TONOS
unicode_core_property(0x0386, 0x0386, 'Grapheme_Base').	% L&       GREEK CAPITAL LETTER ALPHA WITH TONOS
unicode_core_property(0x0387, 0x0387, 'Grapheme_Base').	% Po       GREEK ANO TELEIA
unicode_core_property(0x0388, 0x038A, 'Grapheme_Base').	% L&   [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
unicode_core_property(0x038C, 0x038C, 'Grapheme_Base').	% L&       GREEK CAPITAL LETTER OMICRON WITH TONOS
unicode_core_property(0x038E, 0x03A1, 'Grapheme_Base').	% L&  [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
unicode_core_property(0x03A3, 0x03F5, 'Grapheme_Base').	% L&  [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
unicode_core_property(0x03F6, 0x03F6, 'Grapheme_Base').	% Sm       GREEK REVERSED LUNATE EPSILON SYMBOL
unicode_core_property(0x03F7, 0x0481, 'Grapheme_Base').	% L& [139] GREEK CAPITAL LETTER SHO..CYRILLIC SMALL LETTER KOPPA
unicode_core_property(0x0482, 0x0482, 'Grapheme_Base').	% So       CYRILLIC THOUSANDS SIGN
unicode_core_property(0x048A, 0x0527, 'Grapheme_Base').	% L& [158] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER SHHA WITH DESCENDER
unicode_core_property(0x0531, 0x0556, 'Grapheme_Base').	% L&  [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
unicode_core_property(0x0559, 0x0559, 'Grapheme_Base').	% Lm       ARMENIAN MODIFIER LETTER LEFT HALF RING
unicode_core_property(0x055A, 0x055F, 'Grapheme_Base').	% Po   [6] ARMENIAN APOSTROPHE..ARMENIAN ABBREVIATION MARK
unicode_core_property(0x0561, 0x0587, 'Grapheme_Base').	% L&  [39] ARMENIAN SMALL LETTER AYB..ARMENIAN SMALL LIGATURE ECH YIWN
unicode_core_property(0x0589, 0x0589, 'Grapheme_Base').	% Po       ARMENIAN FULL STOP
unicode_core_property(0x058A, 0x058A, 'Grapheme_Base').	% Pd       ARMENIAN HYPHEN
unicode_core_property(0x058F, 0x058F, 'Grapheme_Base').	% Sc       ARMENIAN DRAM SIGN
unicode_core_property(0x05BE, 0x05BE, 'Grapheme_Base').	% Pd       HEBREW PUNCTUATION MAQAF
unicode_core_property(0x05C0, 0x05C0, 'Grapheme_Base').	% Po       HEBREW PUNCTUATION PASEQ
unicode_core_property(0x05C3, 0x05C3, 'Grapheme_Base').	% Po       HEBREW PUNCTUATION SOF PASUQ
unicode_core_property(0x05C6, 0x05C6, 'Grapheme_Base').	% Po       HEBREW PUNCTUATION NUN HAFUKHA
unicode_core_property(0x05D0, 0x05EA, 'Grapheme_Base').	% Lo  [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
unicode_core_property(0x05F0, 0x05F2, 'Grapheme_Base').	% Lo   [3] HEBREW LIGATURE YIDDISH DOUBLE VAV..HEBREW LIGATURE YIDDISH DOUBLE YOD
unicode_core_property(0x05F3, 0x05F4, 'Grapheme_Base').	% Po   [2] HEBREW PUNCTUATION GERESH..HEBREW PUNCTUATION GERSHAYIM
unicode_core_property(0x0606, 0x0608, 'Grapheme_Base').	% Sm   [3] ARABIC-INDIC CUBE ROOT..ARABIC RAY
unicode_core_property(0x0609, 0x060A, 'Grapheme_Base').	% Po   [2] ARABIC-INDIC PER MILLE SIGN..ARABIC-INDIC PER TEN THOUSAND SIGN
unicode_core_property(0x060B, 0x060B, 'Grapheme_Base').	% Sc       AFGHANI SIGN
unicode_core_property(0x060C, 0x060D, 'Grapheme_Base').	% Po   [2] ARABIC COMMA..ARABIC DATE SEPARATOR
unicode_core_property(0x060E, 0x060F, 'Grapheme_Base').	% So   [2] ARABIC POETIC VERSE SIGN..ARABIC SIGN MISRA
unicode_core_property(0x061B, 0x061B, 'Grapheme_Base').	% Po       ARABIC SEMICOLON
unicode_core_property(0x061E, 0x061F, 'Grapheme_Base').	% Po   [2] ARABIC TRIPLE DOT PUNCTUATION MARK..ARABIC QUESTION MARK
unicode_core_property(0x0620, 0x063F, 'Grapheme_Base').	% Lo  [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
unicode_core_property(0x0640, 0x0640, 'Grapheme_Base').	% Lm       ARABIC TATWEEL
unicode_core_property(0x0641, 0x064A, 'Grapheme_Base').	% Lo  [10] ARABIC LETTER FEH..ARABIC LETTER YEH
unicode_core_property(0x0660, 0x0669, 'Grapheme_Base').	% Nd  [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
unicode_core_property(0x066A, 0x066D, 'Grapheme_Base').	% Po   [4] ARABIC PERCENT SIGN..ARABIC FIVE POINTED STAR
unicode_core_property(0x066E, 0x066F, 'Grapheme_Base').	% Lo   [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
unicode_core_property(0x0671, 0x06D3, 'Grapheme_Base').	% Lo  [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
unicode_core_property(0x06D4, 0x06D4, 'Grapheme_Base').	% Po       ARABIC FULL STOP
unicode_core_property(0x06D5, 0x06D5, 'Grapheme_Base').	% Lo       ARABIC LETTER AE
unicode_core_property(0x06DE, 0x06DE, 'Grapheme_Base').	% So       ARABIC START OF RUB EL HIZB
unicode_core_property(0x06E5, 0x06E6, 'Grapheme_Base').	% Lm   [2] ARABIC SMALL WAW..ARABIC SMALL YEH
unicode_core_property(0x06E9, 0x06E9, 'Grapheme_Base').	% So       ARABIC PLACE OF SAJDAH
unicode_core_property(0x06EE, 0x06EF, 'Grapheme_Base').	% Lo   [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
unicode_core_property(0x06F0, 0x06F9, 'Grapheme_Base').	% Nd  [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
unicode_core_property(0x06FA, 0x06FC, 'Grapheme_Base').	% Lo   [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
unicode_core_property(0x06FD, 0x06FE, 'Grapheme_Base').	% So   [2] ARABIC SIGN SINDHI AMPERSAND..ARABIC SIGN SINDHI POSTPOSITION MEN
unicode_core_property(0x06FF, 0x06FF, 'Grapheme_Base').	% Lo       ARABIC LETTER HEH WITH INVERTED V
unicode_core_property(0x0700, 0x070D, 'Grapheme_Base').	% Po  [14] SYRIAC END OF PARAGRAPH..SYRIAC HARKLEAN ASTERISCUS
unicode_core_property(0x0710, 0x0710, 'Grapheme_Base').	% Lo       SYRIAC LETTER ALAPH
unicode_core_property(0x0712, 0x072F, 'Grapheme_Base').	% Lo  [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
unicode_core_property(0x074D, 0x07A5, 'Grapheme_Base').	% Lo  [89] SYRIAC LETTER SOGDIAN ZHAIN..THAANA LETTER WAAVU
unicode_core_property(0x07B1, 0x07B1, 'Grapheme_Base').	% Lo       THAANA LETTER NAA
unicode_core_property(0x07C0, 0x07C9, 'Grapheme_Base').	% Nd  [10] NKO DIGIT ZERO..NKO DIGIT NINE
unicode_core_property(0x07CA, 0x07EA, 'Grapheme_Base').	% Lo  [33] NKO LETTER A..NKO LETTER JONA RA
unicode_core_property(0x07F4, 0x07F5, 'Grapheme_Base').	% Lm   [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
unicode_core_property(0x07F6, 0x07F6, 'Grapheme_Base').	% So       NKO SYMBOL OO DENNEN
unicode_core_property(0x07F7, 0x07F9, 'Grapheme_Base').	% Po   [3] NKO SYMBOL GBAKURUNEN..NKO EXCLAMATION MARK
unicode_core_property(0x07FA, 0x07FA, 'Grapheme_Base').	% Lm       NKO LAJANYALAN
unicode_core_property(0x0800, 0x0815, 'Grapheme_Base').	% Lo  [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
unicode_core_property(0x081A, 0x081A, 'Grapheme_Base').	% Lm       SAMARITAN MODIFIER LETTER EPENTHETIC YUT
unicode_core_property(0x0824, 0x0824, 'Grapheme_Base').	% Lm       SAMARITAN MODIFIER LETTER SHORT A
unicode_core_property(0x0828, 0x0828, 'Grapheme_Base').	% Lm       SAMARITAN MODIFIER LETTER I
unicode_core_property(0x0830, 0x083E, 'Grapheme_Base').	% Po  [15] SAMARITAN PUNCTUATION NEQUDAA..SAMARITAN PUNCTUATION ANNAAU
unicode_core_property(0x0840, 0x0858, 'Grapheme_Base').	% Lo  [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
unicode_core_property(0x085E, 0x085E, 'Grapheme_Base').	% Po       MANDAIC PUNCTUATION
unicode_core_property(0x08A0, 0x08A0, 'Grapheme_Base').	% Lo       ARABIC LETTER BEH WITH SMALL V BELOW
unicode_core_property(0x08A2, 0x08AC, 'Grapheme_Base').	% Lo  [11] ARABIC LETTER JEEM WITH TWO DOTS ABOVE..ARABIC LETTER ROHINGYA YEH
unicode_core_property(0x0903, 0x0903, 'Grapheme_Base').	% Mc       DEVANAGARI SIGN VISARGA
unicode_core_property(0x0904, 0x0939, 'Grapheme_Base').	% Lo  [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
unicode_core_property(0x093B, 0x093B, 'Grapheme_Base').	% Mc       DEVANAGARI VOWEL SIGN OOE
unicode_core_property(0x093D, 0x093D, 'Grapheme_Base').	% Lo       DEVANAGARI SIGN AVAGRAHA
unicode_core_property(0x093E, 0x0940, 'Grapheme_Base').	% Mc   [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
unicode_core_property(0x0949, 0x094C, 'Grapheme_Base').	% Mc   [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
unicode_core_property(0x094E, 0x094F, 'Grapheme_Base').	% Mc   [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
unicode_core_property(0x0950, 0x0950, 'Grapheme_Base').	% Lo       DEVANAGARI OM
unicode_core_property(0x0958, 0x0961, 'Grapheme_Base').	% Lo  [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
unicode_core_property(0x0964, 0x0965, 'Grapheme_Base').	% Po   [2] DEVANAGARI DANDA..DEVANAGARI DOUBLE DANDA
unicode_core_property(0x0966, 0x096F, 'Grapheme_Base').	% Nd  [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
unicode_core_property(0x0970, 0x0970, 'Grapheme_Base').	% Po       DEVANAGARI ABBREVIATION SIGN
unicode_core_property(0x0971, 0x0971, 'Grapheme_Base').	% Lm       DEVANAGARI SIGN HIGH SPACING DOT
unicode_core_property(0x0972, 0x0977, 'Grapheme_Base').	% Lo   [6] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER UUE
unicode_core_property(0x0979, 0x097F, 'Grapheme_Base').	% Lo   [7] DEVANAGARI LETTER ZHA..DEVANAGARI LETTER BBA
unicode_core_property(0x0982, 0x0983, 'Grapheme_Base').	% Mc   [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
unicode_core_property(0x0985, 0x098C, 'Grapheme_Base').	% Lo   [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
unicode_core_property(0x098F, 0x0990, 'Grapheme_Base').	% Lo   [2] BENGALI LETTER E..BENGALI LETTER AI
unicode_core_property(0x0993, 0x09A8, 'Grapheme_Base').	% Lo  [22] BENGALI LETTER O..BENGALI LETTER NA
unicode_core_property(0x09AA, 0x09B0, 'Grapheme_Base').	% Lo   [7] BENGALI LETTER PA..BENGALI LETTER RA
unicode_core_property(0x09B2, 0x09B2, 'Grapheme_Base').	% Lo       BENGALI LETTER LA
unicode_core_property(0x09B6, 0x09B9, 'Grapheme_Base').	% Lo   [4] BENGALI LETTER SHA..BENGALI LETTER HA
unicode_core_property(0x09BD, 0x09BD, 'Grapheme_Base').	% Lo       BENGALI SIGN AVAGRAHA
unicode_core_property(0x09BF, 0x09C0, 'Grapheme_Base').	% Mc   [2] BENGALI VOWEL SIGN I..BENGALI VOWEL SIGN II
unicode_core_property(0x09C7, 0x09C8, 'Grapheme_Base').	% Mc   [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
unicode_core_property(0x09CB, 0x09CC, 'Grapheme_Base').	% Mc   [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
unicode_core_property(0x09CE, 0x09CE, 'Grapheme_Base').	% Lo       BENGALI LETTER KHANDA TA
unicode_core_property(0x09DC, 0x09DD, 'Grapheme_Base').	% Lo   [2] BENGALI LETTER RRA..BENGALI LETTER RHA
unicode_core_property(0x09DF, 0x09E1, 'Grapheme_Base').	% Lo   [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
unicode_core_property(0x09E6, 0x09EF, 'Grapheme_Base').	% Nd  [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
unicode_core_property(0x09F0, 0x09F1, 'Grapheme_Base').	% Lo   [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
unicode_core_property(0x09F2, 0x09F3, 'Grapheme_Base').	% Sc   [2] BENGALI RUPEE MARK..BENGALI RUPEE SIGN
unicode_core_property(0x09F4, 0x09F9, 'Grapheme_Base').	% No   [6] BENGALI CURRENCY NUMERATOR ONE..BENGALI CURRENCY DENOMINATOR SIXTEEN
unicode_core_property(0x09FA, 0x09FA, 'Grapheme_Base').	% So       BENGALI ISSHAR
unicode_core_property(0x09FB, 0x09FB, 'Grapheme_Base').	% Sc       BENGALI GANDA MARK
unicode_core_property(0x0A03, 0x0A03, 'Grapheme_Base').	% Mc       GURMUKHI SIGN VISARGA
unicode_core_property(0x0A05, 0x0A0A, 'Grapheme_Base').	% Lo   [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
unicode_core_property(0x0A0F, 0x0A10, 'Grapheme_Base').	% Lo   [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
unicode_core_property(0x0A13, 0x0A28, 'Grapheme_Base').	% Lo  [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
unicode_core_property(0x0A2A, 0x0A30, 'Grapheme_Base').	% Lo   [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
unicode_core_property(0x0A32, 0x0A33, 'Grapheme_Base').	% Lo   [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
unicode_core_property(0x0A35, 0x0A36, 'Grapheme_Base').	% Lo   [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
unicode_core_property(0x0A38, 0x0A39, 'Grapheme_Base').	% Lo   [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
unicode_core_property(0x0A3E, 0x0A40, 'Grapheme_Base').	% Mc   [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
unicode_core_property(0x0A59, 0x0A5C, 'Grapheme_Base').	% Lo   [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
unicode_core_property(0x0A5E, 0x0A5E, 'Grapheme_Base').	% Lo       GURMUKHI LETTER FA
unicode_core_property(0x0A66, 0x0A6F, 'Grapheme_Base').	% Nd  [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
unicode_core_property(0x0A72, 0x0A74, 'Grapheme_Base').	% Lo   [3] GURMUKHI IRI..GURMUKHI EK ONKAR
unicode_core_property(0x0A83, 0x0A83, 'Grapheme_Base').	% Mc       GUJARATI SIGN VISARGA
unicode_core_property(0x0A85, 0x0A8D, 'Grapheme_Base').	% Lo   [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
unicode_core_property(0x0A8F, 0x0A91, 'Grapheme_Base').	% Lo   [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
unicode_core_property(0x0A93, 0x0AA8, 'Grapheme_Base').	% Lo  [22] GUJARATI LETTER O..GUJARATI LETTER NA
unicode_core_property(0x0AAA, 0x0AB0, 'Grapheme_Base').	% Lo   [7] GUJARATI LETTER PA..GUJARATI LETTER RA
unicode_core_property(0x0AB2, 0x0AB3, 'Grapheme_Base').	% Lo   [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
unicode_core_property(0x0AB5, 0x0AB9, 'Grapheme_Base').	% Lo   [5] GUJARATI LETTER VA..GUJARATI LETTER HA
unicode_core_property(0x0ABD, 0x0ABD, 'Grapheme_Base').	% Lo       GUJARATI SIGN AVAGRAHA
unicode_core_property(0x0ABE, 0x0AC0, 'Grapheme_Base').	% Mc   [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
unicode_core_property(0x0AC9, 0x0AC9, 'Grapheme_Base').	% Mc       GUJARATI VOWEL SIGN CANDRA O
unicode_core_property(0x0ACB, 0x0ACC, 'Grapheme_Base').	% Mc   [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
unicode_core_property(0x0AD0, 0x0AD0, 'Grapheme_Base').	% Lo       GUJARATI OM
unicode_core_property(0x0AE0, 0x0AE1, 'Grapheme_Base').	% Lo   [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
unicode_core_property(0x0AE6, 0x0AEF, 'Grapheme_Base').	% Nd  [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
unicode_core_property(0x0AF0, 0x0AF0, 'Grapheme_Base').	% Po       GUJARATI ABBREVIATION SIGN
unicode_core_property(0x0AF1, 0x0AF1, 'Grapheme_Base').	% Sc       GUJARATI RUPEE SIGN
unicode_core_property(0x0B02, 0x0B03, 'Grapheme_Base').	% Mc   [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
unicode_core_property(0x0B05, 0x0B0C, 'Grapheme_Base').	% Lo   [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
unicode_core_property(0x0B0F, 0x0B10, 'Grapheme_Base').	% Lo   [2] ORIYA LETTER E..ORIYA LETTER AI
unicode_core_property(0x0B13, 0x0B28, 'Grapheme_Base').	% Lo  [22] ORIYA LETTER O..ORIYA LETTER NA
unicode_core_property(0x0B2A, 0x0B30, 'Grapheme_Base').	% Lo   [7] ORIYA LETTER PA..ORIYA LETTER RA
unicode_core_property(0x0B32, 0x0B33, 'Grapheme_Base').	% Lo   [2] ORIYA LETTER LA..ORIYA LETTER LLA
unicode_core_property(0x0B35, 0x0B39, 'Grapheme_Base').	% Lo   [5] ORIYA LETTER VA..ORIYA LETTER HA
unicode_core_property(0x0B3D, 0x0B3D, 'Grapheme_Base').	% Lo       ORIYA SIGN AVAGRAHA
unicode_core_property(0x0B40, 0x0B40, 'Grapheme_Base').	% Mc       ORIYA VOWEL SIGN II
unicode_core_property(0x0B47, 0x0B48, 'Grapheme_Base').	% Mc   [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
unicode_core_property(0x0B4B, 0x0B4C, 'Grapheme_Base').	% Mc   [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
unicode_core_property(0x0B5C, 0x0B5D, 'Grapheme_Base').	% Lo   [2] ORIYA LETTER RRA..ORIYA LETTER RHA
unicode_core_property(0x0B5F, 0x0B61, 'Grapheme_Base').	% Lo   [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
unicode_core_property(0x0B66, 0x0B6F, 'Grapheme_Base').	% Nd  [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
unicode_core_property(0x0B70, 0x0B70, 'Grapheme_Base').	% So       ORIYA ISSHAR
unicode_core_property(0x0B71, 0x0B71, 'Grapheme_Base').	% Lo       ORIYA LETTER WA
unicode_core_property(0x0B72, 0x0B77, 'Grapheme_Base').	% No   [6] ORIYA FRACTION ONE QUARTER..ORIYA FRACTION THREE SIXTEENTHS
unicode_core_property(0x0B83, 0x0B83, 'Grapheme_Base').	% Lo       TAMIL SIGN VISARGA
unicode_core_property(0x0B85, 0x0B8A, 'Grapheme_Base').	% Lo   [6] TAMIL LETTER A..TAMIL LETTER UU
unicode_core_property(0x0B8E, 0x0B90, 'Grapheme_Base').	% Lo   [3] TAMIL LETTER E..TAMIL LETTER AI
unicode_core_property(0x0B92, 0x0B95, 'Grapheme_Base').	% Lo   [4] TAMIL LETTER O..TAMIL LETTER KA
unicode_core_property(0x0B99, 0x0B9A, 'Grapheme_Base').	% Lo   [2] TAMIL LETTER NGA..TAMIL LETTER CA
unicode_core_property(0x0B9C, 0x0B9C, 'Grapheme_Base').	% Lo       TAMIL LETTER JA
unicode_core_property(0x0B9E, 0x0B9F, 'Grapheme_Base').	% Lo   [2] TAMIL LETTER NYA..TAMIL LETTER TTA
unicode_core_property(0x0BA3, 0x0BA4, 'Grapheme_Base').	% Lo   [2] TAMIL LETTER NNA..TAMIL LETTER TA
unicode_core_property(0x0BA8, 0x0BAA, 'Grapheme_Base').	% Lo   [3] TAMIL LETTER NA..TAMIL LETTER PA
unicode_core_property(0x0BAE, 0x0BB9, 'Grapheme_Base').	% Lo  [12] TAMIL LETTER MA..TAMIL LETTER HA
unicode_core_property(0x0BBF, 0x0BBF, 'Grapheme_Base').	% Mc       TAMIL VOWEL SIGN I
unicode_core_property(0x0BC1, 0x0BC2, 'Grapheme_Base').	% Mc   [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
unicode_core_property(0x0BC6, 0x0BC8, 'Grapheme_Base').	% Mc   [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
unicode_core_property(0x0BCA, 0x0BCC, 'Grapheme_Base').	% Mc   [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
unicode_core_property(0x0BD0, 0x0BD0, 'Grapheme_Base').	% Lo       TAMIL OM
unicode_core_property(0x0BE6, 0x0BEF, 'Grapheme_Base').	% Nd  [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
unicode_core_property(0x0BF0, 0x0BF2, 'Grapheme_Base').	% No   [3] TAMIL NUMBER TEN..TAMIL NUMBER ONE THOUSAND
unicode_core_property(0x0BF3, 0x0BF8, 'Grapheme_Base').	% So   [6] TAMIL DAY SIGN..TAMIL AS ABOVE SIGN
unicode_core_property(0x0BF9, 0x0BF9, 'Grapheme_Base').	% Sc       TAMIL RUPEE SIGN
unicode_core_property(0x0BFA, 0x0BFA, 'Grapheme_Base').	% So       TAMIL NUMBER SIGN
unicode_core_property(0x0C01, 0x0C03, 'Grapheme_Base').	% Mc   [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
unicode_core_property(0x0C05, 0x0C0C, 'Grapheme_Base').	% Lo   [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
unicode_core_property(0x0C0E, 0x0C10, 'Grapheme_Base').	% Lo   [3] TELUGU LETTER E..TELUGU LETTER AI
unicode_core_property(0x0C12, 0x0C28, 'Grapheme_Base').	% Lo  [23] TELUGU LETTER O..TELUGU LETTER NA
unicode_core_property(0x0C2A, 0x0C33, 'Grapheme_Base').	% Lo  [10] TELUGU LETTER PA..TELUGU LETTER LLA
unicode_core_property(0x0C35, 0x0C39, 'Grapheme_Base').	% Lo   [5] TELUGU LETTER VA..TELUGU LETTER HA
unicode_core_property(0x0C3D, 0x0C3D, 'Grapheme_Base').	% Lo       TELUGU SIGN AVAGRAHA
unicode_core_property(0x0C41, 0x0C44, 'Grapheme_Base').	% Mc   [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
unicode_core_property(0x0C58, 0x0C59, 'Grapheme_Base').	% Lo   [2] TELUGU LETTER TSA..TELUGU LETTER DZA
unicode_core_property(0x0C60, 0x0C61, 'Grapheme_Base').	% Lo   [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
unicode_core_property(0x0C66, 0x0C6F, 'Grapheme_Base').	% Nd  [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
unicode_core_property(0x0C78, 0x0C7E, 'Grapheme_Base').	% No   [7] TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR..TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR
unicode_core_property(0x0C7F, 0x0C7F, 'Grapheme_Base').	% So       TELUGU SIGN TUUMU
unicode_core_property(0x0C82, 0x0C83, 'Grapheme_Base').	% Mc   [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
unicode_core_property(0x0C85, 0x0C8C, 'Grapheme_Base').	% Lo   [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
unicode_core_property(0x0C8E, 0x0C90, 'Grapheme_Base').	% Lo   [3] KANNADA LETTER E..KANNADA LETTER AI
unicode_core_property(0x0C92, 0x0CA8, 'Grapheme_Base').	% Lo  [23] KANNADA LETTER O..KANNADA LETTER NA
unicode_core_property(0x0CAA, 0x0CB3, 'Grapheme_Base').	% Lo  [10] KANNADA LETTER PA..KANNADA LETTER LLA
unicode_core_property(0x0CB5, 0x0CB9, 'Grapheme_Base').	% Lo   [5] KANNADA LETTER VA..KANNADA LETTER HA
unicode_core_property(0x0CBD, 0x0CBD, 'Grapheme_Base').	% Lo       KANNADA SIGN AVAGRAHA
unicode_core_property(0x0CBE, 0x0CBE, 'Grapheme_Base').	% Mc       KANNADA VOWEL SIGN AA
unicode_core_property(0x0CC0, 0x0CC1, 'Grapheme_Base').	% Mc   [2] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN U
unicode_core_property(0x0CC3, 0x0CC4, 'Grapheme_Base').	% Mc   [2] KANNADA VOWEL SIGN VOCALIC R..KANNADA VOWEL SIGN VOCALIC RR
unicode_core_property(0x0CC7, 0x0CC8, 'Grapheme_Base').	% Mc   [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
unicode_core_property(0x0CCA, 0x0CCB, 'Grapheme_Base').	% Mc   [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
unicode_core_property(0x0CDE, 0x0CDE, 'Grapheme_Base').	% Lo       KANNADA LETTER FA
unicode_core_property(0x0CE0, 0x0CE1, 'Grapheme_Base').	% Lo   [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
unicode_core_property(0x0CE6, 0x0CEF, 'Grapheme_Base').	% Nd  [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
unicode_core_property(0x0CF1, 0x0CF2, 'Grapheme_Base').	% Lo   [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
unicode_core_property(0x0D02, 0x0D03, 'Grapheme_Base').	% Mc   [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
unicode_core_property(0x0D05, 0x0D0C, 'Grapheme_Base').	% Lo   [8] MALAYALAM LETTER A..MALAYALAM LETTER VOCALIC L
unicode_core_property(0x0D0E, 0x0D10, 'Grapheme_Base').	% Lo   [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
unicode_core_property(0x0D12, 0x0D3A, 'Grapheme_Base').	% Lo  [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
unicode_core_property(0x0D3D, 0x0D3D, 'Grapheme_Base').	% Lo       MALAYALAM SIGN AVAGRAHA
unicode_core_property(0x0D3F, 0x0D40, 'Grapheme_Base').	% Mc   [2] MALAYALAM VOWEL SIGN I..MALAYALAM VOWEL SIGN II
unicode_core_property(0x0D46, 0x0D48, 'Grapheme_Base').	% Mc   [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
unicode_core_property(0x0D4A, 0x0D4C, 'Grapheme_Base').	% Mc   [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
unicode_core_property(0x0D4E, 0x0D4E, 'Grapheme_Base').	% Lo       MALAYALAM LETTER DOT REPH
unicode_core_property(0x0D60, 0x0D61, 'Grapheme_Base').	% Lo   [2] MALAYALAM LETTER VOCALIC RR..MALAYALAM LETTER VOCALIC LL
unicode_core_property(0x0D66, 0x0D6F, 'Grapheme_Base').	% Nd  [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
unicode_core_property(0x0D70, 0x0D75, 'Grapheme_Base').	% No   [6] MALAYALAM NUMBER TEN..MALAYALAM FRACTION THREE QUARTERS
unicode_core_property(0x0D79, 0x0D79, 'Grapheme_Base').	% So       MALAYALAM DATE MARK
unicode_core_property(0x0D7A, 0x0D7F, 'Grapheme_Base').	% Lo   [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
unicode_core_property(0x0D82, 0x0D83, 'Grapheme_Base').	% Mc   [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
unicode_core_property(0x0D85, 0x0D96, 'Grapheme_Base').	% Lo  [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
unicode_core_property(0x0D9A, 0x0DB1, 'Grapheme_Base').	% Lo  [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
unicode_core_property(0x0DB3, 0x0DBB, 'Grapheme_Base').	% Lo   [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
unicode_core_property(0x0DBD, 0x0DBD, 'Grapheme_Base').	% Lo       SINHALA LETTER DANTAJA LAYANNA
unicode_core_property(0x0DC0, 0x0DC6, 'Grapheme_Base').	% Lo   [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
unicode_core_property(0x0DD0, 0x0DD1, 'Grapheme_Base').	% Mc   [2] SINHALA VOWEL SIGN KETTI AEDA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
unicode_core_property(0x0DD8, 0x0DDE, 'Grapheme_Base').	% Mc   [7] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
unicode_core_property(0x0DF2, 0x0DF3, 'Grapheme_Base').	% Mc   [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
unicode_core_property(0x0DF4, 0x0DF4, 'Grapheme_Base').	% Po       SINHALA PUNCTUATION KUNDDALIYA
unicode_core_property(0x0E01, 0x0E30, 'Grapheme_Base').	% Lo  [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
unicode_core_property(0x0E32, 0x0E33, 'Grapheme_Base').	% Lo   [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
unicode_core_property(0x0E3F, 0x0E3F, 'Grapheme_Base').	% Sc       THAI CURRENCY SYMBOL BAHT
unicode_core_property(0x0E40, 0x0E45, 'Grapheme_Base').	% Lo   [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
unicode_core_property(0x0E46, 0x0E46, 'Grapheme_Base').	% Lm       THAI CHARACTER MAIYAMOK
unicode_core_property(0x0E4F, 0x0E4F, 'Grapheme_Base').	% Po       THAI CHARACTER FONGMAN
unicode_core_property(0x0E50, 0x0E59, 'Grapheme_Base').	% Nd  [10] THAI DIGIT ZERO..THAI DIGIT NINE
unicode_core_property(0x0E5A, 0x0E5B, 'Grapheme_Base').	% Po   [2] THAI CHARACTER ANGKHANKHU..THAI CHARACTER KHOMUT
unicode_core_property(0x0E81, 0x0E82, 'Grapheme_Base').	% Lo   [2] LAO LETTER KO..LAO LETTER KHO SUNG
unicode_core_property(0x0E84, 0x0E84, 'Grapheme_Base').	% Lo       LAO LETTER KHO TAM
unicode_core_property(0x0E87, 0x0E88, 'Grapheme_Base').	% Lo   [2] LAO LETTER NGO..LAO LETTER CO
unicode_core_property(0x0E8A, 0x0E8A, 'Grapheme_Base').	% Lo       LAO LETTER SO TAM
unicode_core_property(0x0E8D, 0x0E8D, 'Grapheme_Base').	% Lo       LAO LETTER NYO
unicode_core_property(0x0E94, 0x0E97, 'Grapheme_Base').	% Lo   [4] LAO LETTER DO..LAO LETTER THO TAM
unicode_core_property(0x0E99, 0x0E9F, 'Grapheme_Base').	% Lo   [7] LAO LETTER NO..LAO LETTER FO SUNG
unicode_core_property(0x0EA1, 0x0EA3, 'Grapheme_Base').	% Lo   [3] LAO LETTER MO..LAO LETTER LO LING
unicode_core_property(0x0EA5, 0x0EA5, 'Grapheme_Base').	% Lo       LAO LETTER LO LOOT
unicode_core_property(0x0EA7, 0x0EA7, 'Grapheme_Base').	% Lo       LAO LETTER WO
unicode_core_property(0x0EAA, 0x0EAB, 'Grapheme_Base').	% Lo   [2] LAO LETTER SO SUNG..LAO LETTER HO SUNG
unicode_core_property(0x0EAD, 0x0EB0, 'Grapheme_Base').	% Lo   [4] LAO LETTER O..LAO VOWEL SIGN A
unicode_core_property(0x0EB2, 0x0EB3, 'Grapheme_Base').	% Lo   [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
unicode_core_property(0x0EBD, 0x0EBD, 'Grapheme_Base').	% Lo       LAO SEMIVOWEL SIGN NYO
unicode_core_property(0x0EC0, 0x0EC4, 'Grapheme_Base').	% Lo   [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
unicode_core_property(0x0EC6, 0x0EC6, 'Grapheme_Base').	% Lm       LAO KO LA
unicode_core_property(0x0ED0, 0x0ED9, 'Grapheme_Base').	% Nd  [10] LAO DIGIT ZERO..LAO DIGIT NINE
unicode_core_property(0x0EDC, 0x0EDF, 'Grapheme_Base').	% Lo   [4] LAO HO NO..LAO LETTER KHMU NYO
unicode_core_property(0x0F00, 0x0F00, 'Grapheme_Base').	% Lo       TIBETAN SYLLABLE OM
unicode_core_property(0x0F01, 0x0F03, 'Grapheme_Base').	% So   [3] TIBETAN MARK GTER YIG MGO TRUNCATED A..TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
unicode_core_property(0x0F04, 0x0F12, 'Grapheme_Base').	% Po  [15] TIBETAN MARK INITIAL YIG MGO MDUN MA..TIBETAN MARK RGYA GRAM SHAD
unicode_core_property(0x0F13, 0x0F13, 'Grapheme_Base').	% So       TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
unicode_core_property(0x0F14, 0x0F14, 'Grapheme_Base').	% Po       TIBETAN MARK GTER TSHEG
unicode_core_property(0x0F15, 0x0F17, 'Grapheme_Base').	% So   [3] TIBETAN LOGOTYPE SIGN CHAD RTAGS..TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
unicode_core_property(0x0F1A, 0x0F1F, 'Grapheme_Base').	% So   [6] TIBETAN SIGN RDEL DKAR GCIG..TIBETAN SIGN RDEL DKAR RDEL NAG
unicode_core_property(0x0F20, 0x0F29, 'Grapheme_Base').	% Nd  [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
unicode_core_property(0x0F2A, 0x0F33, 'Grapheme_Base').	% No  [10] TIBETAN DIGIT HALF ONE..TIBETAN DIGIT HALF ZERO
unicode_core_property(0x0F34, 0x0F34, 'Grapheme_Base').	% So       TIBETAN MARK BSDUS RTAGS
unicode_core_property(0x0F36, 0x0F36, 'Grapheme_Base').	% So       TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
unicode_core_property(0x0F38, 0x0F38, 'Grapheme_Base').	% So       TIBETAN MARK CHE MGO
unicode_core_property(0x0F3A, 0x0F3A, 'Grapheme_Base').	% Ps       TIBETAN MARK GUG RTAGS GYON
unicode_core_property(0x0F3B, 0x0F3B, 'Grapheme_Base').	% Pe       TIBETAN MARK GUG RTAGS GYAS
unicode_core_property(0x0F3C, 0x0F3C, 'Grapheme_Base').	% Ps       TIBETAN MARK ANG KHANG GYON
unicode_core_property(0x0F3D, 0x0F3D, 'Grapheme_Base').	% Pe       TIBETAN MARK ANG KHANG GYAS
unicode_core_property(0x0F3E, 0x0F3F, 'Grapheme_Base').	% Mc   [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
unicode_core_property(0x0F40, 0x0F47, 'Grapheme_Base').	% Lo   [8] TIBETAN LETTER KA..TIBETAN LETTER JA
unicode_core_property(0x0F49, 0x0F6C, 'Grapheme_Base').	% Lo  [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
unicode_core_property(0x0F7F, 0x0F7F, 'Grapheme_Base').	% Mc       TIBETAN SIGN RNAM BCAD
unicode_core_property(0x0F85, 0x0F85, 'Grapheme_Base').	% Po       TIBETAN MARK PALUTA
unicode_core_property(0x0F88, 0x0F8C, 'Grapheme_Base').	% Lo   [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
unicode_core_property(0x0FBE, 0x0FC5, 'Grapheme_Base').	% So   [8] TIBETAN KU RU KHA..TIBETAN SYMBOL RDO RJE
unicode_core_property(0x0FC7, 0x0FCC, 'Grapheme_Base').	% So   [6] TIBETAN SYMBOL RDO RJE RGYA GRAM..TIBETAN SYMBOL NOR BU BZHI -KHYIL
unicode_core_property(0x0FCE, 0x0FCF, 'Grapheme_Base').	% So   [2] TIBETAN SIGN RDEL NAG RDEL DKAR..TIBETAN SIGN RDEL NAG GSUM
unicode_core_property(0x0FD0, 0x0FD4, 'Grapheme_Base').	% Po   [5] TIBETAN MARK BSKA- SHOG GI MGO RGYAN..TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA
unicode_core_property(0x0FD5, 0x0FD8, 'Grapheme_Base').	% So   [4] RIGHT-FACING SVASTI SIGN..LEFT-FACING SVASTI SIGN WITH DOTS
unicode_core_property(0x0FD9, 0x0FDA, 'Grapheme_Base').	% Po   [2] TIBETAN MARK LEADING MCHAN RTAGS..TIBETAN MARK TRAILING MCHAN RTAGS
unicode_core_property(0x1000, 0x102A, 'Grapheme_Base').	% Lo  [43] MYANMAR LETTER KA..MYANMAR LETTER AU
unicode_core_property(0x102B, 0x102C, 'Grapheme_Base').	% Mc   [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
unicode_core_property(0x1031, 0x1031, 'Grapheme_Base').	% Mc       MYANMAR VOWEL SIGN E
unicode_core_property(0x1038, 0x1038, 'Grapheme_Base').	% Mc       MYANMAR SIGN VISARGA
unicode_core_property(0x103B, 0x103C, 'Grapheme_Base').	% Mc   [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
unicode_core_property(0x103F, 0x103F, 'Grapheme_Base').	% Lo       MYANMAR LETTER GREAT SA
unicode_core_property(0x1040, 0x1049, 'Grapheme_Base').	% Nd  [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
unicode_core_property(0x104A, 0x104F, 'Grapheme_Base').	% Po   [6] MYANMAR SIGN LITTLE SECTION..MYANMAR SYMBOL GENITIVE
unicode_core_property(0x1050, 0x1055, 'Grapheme_Base').	% Lo   [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
unicode_core_property(0x1056, 0x1057, 'Grapheme_Base').	% Mc   [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
unicode_core_property(0x105A, 0x105D, 'Grapheme_Base').	% Lo   [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
unicode_core_property(0x1061, 0x1061, 'Grapheme_Base').	% Lo       MYANMAR LETTER SGAW KAREN SHA
unicode_core_property(0x1062, 0x1064, 'Grapheme_Base').	% Mc   [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
unicode_core_property(0x1065, 0x1066, 'Grapheme_Base').	% Lo   [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
unicode_core_property(0x1067, 0x106D, 'Grapheme_Base').	% Mc   [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
unicode_core_property(0x106E, 0x1070, 'Grapheme_Base').	% Lo   [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
unicode_core_property(0x1075, 0x1081, 'Grapheme_Base').	% Lo  [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
unicode_core_property(0x1083, 0x1084, 'Grapheme_Base').	% Mc   [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
unicode_core_property(0x1087, 0x108C, 'Grapheme_Base').	% Mc   [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
unicode_core_property(0x108E, 0x108E, 'Grapheme_Base').	% Lo       MYANMAR LETTER RUMAI PALAUNG FA
unicode_core_property(0x108F, 0x108F, 'Grapheme_Base').	% Mc       MYANMAR SIGN RUMAI PALAUNG TONE-5
unicode_core_property(0x1090, 0x1099, 'Grapheme_Base').	% Nd  [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
unicode_core_property(0x109A, 0x109C, 'Grapheme_Base').	% Mc   [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
unicode_core_property(0x109E, 0x109F, 'Grapheme_Base').	% So   [2] MYANMAR SYMBOL SHAN ONE..MYANMAR SYMBOL SHAN EXCLAMATION
unicode_core_property(0x10A0, 0x10C5, 'Grapheme_Base').	% L&  [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
unicode_core_property(0x10C7, 0x10C7, 'Grapheme_Base').	% L&       GEORGIAN CAPITAL LETTER YN
unicode_core_property(0x10CD, 0x10CD, 'Grapheme_Base').	% L&       GEORGIAN CAPITAL LETTER AEN
unicode_core_property(0x10D0, 0x10FA, 'Grapheme_Base').	% Lo  [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
unicode_core_property(0x10FB, 0x10FB, 'Grapheme_Base').	% Po       GEORGIAN PARAGRAPH SEPARATOR
unicode_core_property(0x10FC, 0x10FC, 'Grapheme_Base').	% Lm       MODIFIER LETTER GEORGIAN NAR
unicode_core_property(0x10FD, 0x1248, 'Grapheme_Base').	% Lo [332] GEORGIAN LETTER AEN..ETHIOPIC SYLLABLE QWA
unicode_core_property(0x124A, 0x124D, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
unicode_core_property(0x1250, 0x1256, 'Grapheme_Base').	% Lo   [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
unicode_core_property(0x1258, 0x1258, 'Grapheme_Base').	% Lo       ETHIOPIC SYLLABLE QHWA
unicode_core_property(0x125A, 0x125D, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
unicode_core_property(0x1260, 0x1288, 'Grapheme_Base').	% Lo  [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
unicode_core_property(0x128A, 0x128D, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
unicode_core_property(0x1290, 0x12B0, 'Grapheme_Base').	% Lo  [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
unicode_core_property(0x12B2, 0x12B5, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
unicode_core_property(0x12B8, 0x12BE, 'Grapheme_Base').	% Lo   [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
unicode_core_property(0x12C0, 0x12C0, 'Grapheme_Base').	% Lo       ETHIOPIC SYLLABLE KXWA
unicode_core_property(0x12C2, 0x12C5, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
unicode_core_property(0x12C8, 0x12D6, 'Grapheme_Base').	% Lo  [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
unicode_core_property(0x12D8, 0x1310, 'Grapheme_Base').	% Lo  [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
unicode_core_property(0x1312, 0x1315, 'Grapheme_Base').	% Lo   [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
unicode_core_property(0x1318, 0x135A, 'Grapheme_Base').	% Lo  [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
unicode_core_property(0x1360, 0x1368, 'Grapheme_Base').	% Po   [9] ETHIOPIC SECTION MARK..ETHIOPIC PARAGRAPH SEPARATOR
unicode_core_property(0x1369, 0x137C, 'Grapheme_Base').	% No  [20] ETHIOPIC DIGIT ONE..ETHIOPIC NUMBER TEN THOUSAND
unicode_core_property(0x1380, 0x138F, 'Grapheme_Base').	% Lo  [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
unicode_core_property(0x1390, 0x1399, 'Grapheme_Base').	% So  [10] ETHIOPIC TONAL MARK YIZET..ETHIOPIC TONAL MARK KURT
unicode_core_property(0x13A0, 0x13F4, 'Grapheme_Base').	% Lo  [85] CHEROKEE LETTER A..CHEROKEE LETTER YV
unicode_core_property(0x1400, 0x1400, 'Grapheme_Base').	% Pd       CANADIAN SYLLABICS HYPHEN
unicode_core_property(0x1401, 0x166C, 'Grapheme_Base').	% Lo [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
unicode_core_property(0x166D, 0x166E, 'Grapheme_Base').	% Po   [2] CANADIAN SYLLABICS CHI SIGN..CANADIAN SYLLABICS FULL STOP
unicode_core_property(0x166F, 0x167F, 'Grapheme_Base').	% Lo  [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
unicode_core_property(0x1680, 0x1680, 'Grapheme_Base').	% Zs       OGHAM SPACE MARK
unicode_core_property(0x1681, 0x169A, 'Grapheme_Base').	% Lo  [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
unicode_core_property(0x169B, 0x169B, 'Grapheme_Base').	% Ps       OGHAM FEATHER MARK
unicode_core_property(0x169C, 0x169C, 'Grapheme_Base').	% Pe       OGHAM REVERSED FEATHER MARK
unicode_core_property(0x16A0, 0x16EA, 'Grapheme_Base').	% Lo  [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
unicode_core_property(0x16EB, 0x16ED, 'Grapheme_Base').	% Po   [3] RUNIC SINGLE PUNCTUATION..RUNIC CROSS PUNCTUATION
unicode_core_property(0x16EE, 0x16F0, 'Grapheme_Base').	% Nl   [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
unicode_core_property(0x1700, 0x170C, 'Grapheme_Base').	% Lo  [13] TAGALOG LETTER A..TAGALOG LETTER YA
unicode_core_property(0x170E, 0x1711, 'Grapheme_Base').	% Lo   [4] TAGALOG LETTER LA..TAGALOG LETTER HA
unicode_core_property(0x1720, 0x1731, 'Grapheme_Base').	% Lo  [18] HANUNOO LETTER A..HANUNOO LETTER HA
unicode_core_property(0x1735, 0x1736, 'Grapheme_Base').	% Po   [2] PHILIPPINE SINGLE PUNCTUATION..PHILIPPINE DOUBLE PUNCTUATION
unicode_core_property(0x1740, 0x1751, 'Grapheme_Base').	% Lo  [18] BUHID LETTER A..BUHID LETTER HA
unicode_core_property(0x1760, 0x176C, 'Grapheme_Base').	% Lo  [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
unicode_core_property(0x176E, 0x1770, 'Grapheme_Base').	% Lo   [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
unicode_core_property(0x1780, 0x17B3, 'Grapheme_Base').	% Lo  [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
unicode_core_property(0x17B6, 0x17B6, 'Grapheme_Base').	% Mc       KHMER VOWEL SIGN AA
unicode_core_property(0x17BE, 0x17C5, 'Grapheme_Base').	% Mc   [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
unicode_core_property(0x17C7, 0x17C8, 'Grapheme_Base').	% Mc   [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
unicode_core_property(0x17D4, 0x17D6, 'Grapheme_Base').	% Po   [3] KHMER SIGN KHAN..KHMER SIGN CAMNUC PII KUUH
unicode_core_property(0x17D7, 0x17D7, 'Grapheme_Base').	% Lm       KHMER SIGN LEK TOO
unicode_core_property(0x17D8, 0x17DA, 'Grapheme_Base').	% Po   [3] KHMER SIGN BEYYAL..KHMER SIGN KOOMUUT
unicode_core_property(0x17DB, 0x17DB, 'Grapheme_Base').	% Sc       KHMER CURRENCY SYMBOL RIEL
unicode_core_property(0x17DC, 0x17DC, 'Grapheme_Base').	% Lo       KHMER SIGN AVAKRAHASANYA
unicode_core_property(0x17E0, 0x17E9, 'Grapheme_Base').	% Nd  [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
unicode_core_property(0x17F0, 0x17F9, 'Grapheme_Base').	% No  [10] KHMER SYMBOL LEK ATTAK SON..KHMER SYMBOL LEK ATTAK PRAM-BUON
unicode_core_property(0x1800, 0x1805, 'Grapheme_Base').	% Po   [6] MONGOLIAN BIRGA..MONGOLIAN FOUR DOTS
unicode_core_property(0x1806, 0x1806, 'Grapheme_Base').	% Pd       MONGOLIAN TODO SOFT HYPHEN
unicode_core_property(0x1807, 0x180A, 'Grapheme_Base').	% Po   [4] MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER..MONGOLIAN NIRUGU
unicode_core_property(0x180E, 0x180E, 'Grapheme_Base').	% Zs       MONGOLIAN VOWEL SEPARATOR
unicode_core_property(0x1810, 0x1819, 'Grapheme_Base').	% Nd  [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
unicode_core_property(0x1820, 0x1842, 'Grapheme_Base').	% Lo  [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
unicode_core_property(0x1843, 0x1843, 'Grapheme_Base').	% Lm       MONGOLIAN LETTER TODO LONG VOWEL SIGN
unicode_core_property(0x1844, 0x1877, 'Grapheme_Base').	% Lo  [52] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER MANCHU ZHA
unicode_core_property(0x1880, 0x18A8, 'Grapheme_Base').	% Lo  [41] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER MANCHU ALI GALI BHA
unicode_core_property(0x18AA, 0x18AA, 'Grapheme_Base').	% Lo       MONGOLIAN LETTER MANCHU ALI GALI LHA
unicode_core_property(0x18B0, 0x18F5, 'Grapheme_Base').	% Lo  [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
unicode_core_property(0x1900, 0x191C, 'Grapheme_Base').	% Lo  [29] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER HA
unicode_core_property(0x1923, 0x1926, 'Grapheme_Base').	% Mc   [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
unicode_core_property(0x1929, 0x192B, 'Grapheme_Base').	% Mc   [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
unicode_core_property(0x1930, 0x1931, 'Grapheme_Base').	% Mc   [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
unicode_core_property(0x1933, 0x1938, 'Grapheme_Base').	% Mc   [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
unicode_core_property(0x1940, 0x1940, 'Grapheme_Base').	% So       LIMBU SIGN LOO
unicode_core_property(0x1944, 0x1945, 'Grapheme_Base').	% Po   [2] LIMBU EXCLAMATION MARK..LIMBU QUESTION MARK
unicode_core_property(0x1946, 0x194F, 'Grapheme_Base').	% Nd  [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
unicode_core_property(0x1950, 0x196D, 'Grapheme_Base').	% Lo  [30] TAI LE LETTER KA..TAI LE LETTER AI
unicode_core_property(0x1970, 0x1974, 'Grapheme_Base').	% Lo   [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
unicode_core_property(0x1980, 0x19AB, 'Grapheme_Base').	% Lo  [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
unicode_core_property(0x19B0, 0x19C0, 'Grapheme_Base').	% Mc  [17] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE VOWEL SIGN IY
unicode_core_property(0x19C1, 0x19C7, 'Grapheme_Base').	% Lo   [7] NEW TAI LUE LETTER FINAL V..NEW TAI LUE LETTER FINAL B
unicode_core_property(0x19C8, 0x19C9, 'Grapheme_Base').	% Mc   [2] NEW TAI LUE TONE MARK-1..NEW TAI LUE TONE MARK-2
unicode_core_property(0x19D0, 0x19D9, 'Grapheme_Base').	% Nd  [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
unicode_core_property(0x19DA, 0x19DA, 'Grapheme_Base').	% No       NEW TAI LUE THAM DIGIT ONE
unicode_core_property(0x19DE, 0x19FF, 'Grapheme_Base').	% So  [34] NEW TAI LUE SIGN LAE..KHMER SYMBOL DAP-PRAM ROC
unicode_core_property(0x1A00, 0x1A16, 'Grapheme_Base').	% Lo  [23] BUGINESE LETTER KA..BUGINESE LETTER HA
unicode_core_property(0x1A19, 0x1A1B, 'Grapheme_Base').	% Mc   [3] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN AE
unicode_core_property(0x1A1E, 0x1A1F, 'Grapheme_Base').	% Po   [2] BUGINESE PALLAWA..BUGINESE END OF SECTION
unicode_core_property(0x1A20, 0x1A54, 'Grapheme_Base').	% Lo  [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
unicode_core_property(0x1A55, 0x1A55, 'Grapheme_Base').	% Mc       TAI THAM CONSONANT SIGN MEDIAL RA
unicode_core_property(0x1A57, 0x1A57, 'Grapheme_Base').	% Mc       TAI THAM CONSONANT SIGN LA TANG LAI
unicode_core_property(0x1A61, 0x1A61, 'Grapheme_Base').	% Mc       TAI THAM VOWEL SIGN A
unicode_core_property(0x1A63, 0x1A64, 'Grapheme_Base').	% Mc   [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
unicode_core_property(0x1A6D, 0x1A72, 'Grapheme_Base').	% Mc   [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
unicode_core_property(0x1A80, 0x1A89, 'Grapheme_Base').	% Nd  [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
unicode_core_property(0x1A90, 0x1A99, 'Grapheme_Base').	% Nd  [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
unicode_core_property(0x1AA0, 0x1AA6, 'Grapheme_Base').	% Po   [7] TAI THAM SIGN WIANG..TAI THAM SIGN REVERSED ROTATED RANA
unicode_core_property(0x1AA7, 0x1AA7, 'Grapheme_Base').	% Lm       TAI THAM SIGN MAI YAMOK
unicode_core_property(0x1AA8, 0x1AAD, 'Grapheme_Base').	% Po   [6] TAI THAM SIGN KAAN..TAI THAM SIGN CAANG
unicode_core_property(0x1B04, 0x1B04, 'Grapheme_Base').	% Mc       BALINESE SIGN BISAH
unicode_core_property(0x1B05, 0x1B33, 'Grapheme_Base').	% Lo  [47] BALINESE LETTER AKARA..BALINESE LETTER HA
unicode_core_property(0x1B35, 0x1B35, 'Grapheme_Base').	% Mc       BALINESE VOWEL SIGN TEDUNG
unicode_core_property(0x1B3B, 0x1B3B, 'Grapheme_Base').	% Mc       BALINESE VOWEL SIGN RA REPA TEDUNG
unicode_core_property(0x1B3D, 0x1B41, 'Grapheme_Base').	% Mc   [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
unicode_core_property(0x1B43, 0x1B44, 'Grapheme_Base').	% Mc   [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
unicode_core_property(0x1B45, 0x1B4B, 'Grapheme_Base').	% Lo   [7] BALINESE LETTER KAF SASAK..BALINESE LETTER ASYURA SASAK
unicode_core_property(0x1B50, 0x1B59, 'Grapheme_Base').	% Nd  [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
unicode_core_property(0x1B5A, 0x1B60, 'Grapheme_Base').	% Po   [7] BALINESE PANTI..BALINESE PAMENENG
unicode_core_property(0x1B61, 0x1B6A, 'Grapheme_Base').	% So  [10] BALINESE MUSICAL SYMBOL DONG..BALINESE MUSICAL SYMBOL DANG GEDE
unicode_core_property(0x1B74, 0x1B7C, 'Grapheme_Base').	% So   [9] BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG..BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING
unicode_core_property(0x1B82, 0x1B82, 'Grapheme_Base').	% Mc       SUNDANESE SIGN PANGWISAD
unicode_core_property(0x1B83, 0x1BA0, 'Grapheme_Base').	% Lo  [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
unicode_core_property(0x1BA1, 0x1BA1, 'Grapheme_Base').	% Mc       SUNDANESE CONSONANT SIGN PAMINGKAL
unicode_core_property(0x1BA6, 0x1BA7, 'Grapheme_Base').	% Mc   [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
unicode_core_property(0x1BAA, 0x1BAA, 'Grapheme_Base').	% Mc       SUNDANESE SIGN PAMAAEH
unicode_core_property(0x1BAC, 0x1BAD, 'Grapheme_Base').	% Mc   [2] SUNDANESE CONSONANT SIGN PASANGAN MA..SUNDANESE CONSONANT SIGN PASANGAN WA
unicode_core_property(0x1BAE, 0x1BAF, 'Grapheme_Base').	% Lo   [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
unicode_core_property(0x1BB0, 0x1BB9, 'Grapheme_Base').	% Nd  [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
unicode_core_property(0x1BBA, 0x1BE5, 'Grapheme_Base').	% Lo  [44] SUNDANESE AVAGRAHA..BATAK LETTER U
unicode_core_property(0x1BE7, 0x1BE7, 'Grapheme_Base').	% Mc       BATAK VOWEL SIGN E
unicode_core_property(0x1BEA, 0x1BEC, 'Grapheme_Base').	% Mc   [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
unicode_core_property(0x1BEE, 0x1BEE, 'Grapheme_Base').	% Mc       BATAK VOWEL SIGN U
unicode_core_property(0x1BF2, 0x1BF3, 'Grapheme_Base').	% Mc   [2] BATAK PANGOLAT..BATAK PANONGONAN
unicode_core_property(0x1BFC, 0x1BFF, 'Grapheme_Base').	% Po   [4] BATAK SYMBOL BINDU NA METEK..BATAK SYMBOL BINDU PANGOLAT
unicode_core_property(0x1C00, 0x1C23, 'Grapheme_Base').	% Lo  [36] LEPCHA LETTER KA..LEPCHA LETTER A
unicode_core_property(0x1C24, 0x1C2B, 'Grapheme_Base').	% Mc   [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
unicode_core_property(0x1C34, 0x1C35, 'Grapheme_Base').	% Mc   [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
unicode_core_property(0x1C3B, 0x1C3F, 'Grapheme_Base').	% Po   [5] LEPCHA PUNCTUATION TA-ROL..LEPCHA PUNCTUATION TSHOOK
unicode_core_property(0x1C40, 0x1C49, 'Grapheme_Base').	% Nd  [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
unicode_core_property(0x1C4D, 0x1C4F, 'Grapheme_Base').	% Lo   [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
unicode_core_property(0x1C50, 0x1C59, 'Grapheme_Base').	% Nd  [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
unicode_core_property(0x1C5A, 0x1C77, 'Grapheme_Base').	% Lo  [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
unicode_core_property(0x1C78, 0x1C7D, 'Grapheme_Base').	% Lm   [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
unicode_core_property(0x1C7E, 0x1C7F, 'Grapheme_Base').	% Po   [2] OL CHIKI PUNCTUATION MUCAAD..OL CHIKI PUNCTUATION DOUBLE MUCAAD
unicode_core_property(0x1CC0, 0x1CC7, 'Grapheme_Base').	% Po   [8] SUNDANESE PUNCTUATION BINDU SURYA..SUNDANESE PUNCTUATION BINDU BA SATANGA
unicode_core_property(0x1CD3, 0x1CD3, 'Grapheme_Base').	% Po       VEDIC SIGN NIHSHVASA
unicode_core_property(0x1CE1, 0x1CE1, 'Grapheme_Base').	% Mc       VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
unicode_core_property(0x1CE9, 0x1CEC, 'Grapheme_Base').	% Lo   [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH 