/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.WebhookAnnouncer;
import org.jreleaser.model.internal.announce.WebhooksAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class WebhooksAnnouncerValidator {
    private static final String DEFAULT_TPL = "src/jreleaser/templates/";

    private WebhooksAnnouncerValidator() {
    }

    public static void validateWebhooks(JReleaserContext context, JReleaserContext.Mode mode, WebhooksAnnouncer webhooks, Errors errors) {
        context.getLogger().debug("announce.webhooks");
        Map<String, WebhookAnnouncer> webhook = webhooks.getWebhooks();
        boolean enabled = false;
        for (Map.Entry<String, WebhookAnnouncer> e : webhook.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig() && !mode.validateAnnounce() || !WebhooksAnnouncerValidator.validateWebhook(context, e.getValue(), errors)) continue;
            enabled = true;
        }
        if (enabled) {
            webhooks.setActive(Active.ALWAYS);
        } else {
            webhooks.setActive(Active.NEVER);
        }
        if (!webhooks.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
        }
    }

    public static boolean validateWebhook(JReleaserContext context, WebhookAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.webhooks." + announcer.getName());
        Validator.resolveActivatable(context, (Activatable)announcer, CollectionUtils.listOf((Object[])new String[]{"announce.webhooks." + announcer.getName(), "announce.webhooks"}), "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((String)announcer.getName())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            announcer.disable();
            return false;
        }
        announcer.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.webhooks." + announcer.getName() + ".webhook", announcer.getName() + ".webhook"}), "announce.webhooks." + announcer.getName() + ".webhook", announcer.getWebhook(), errors, context.isDryrun()));
        String defaultMessageTemplate = DEFAULT_TPL + announcer.getName() + ".tpl";
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(defaultMessageTemplate), new LinkOption[0])) {
                announcer.setMessageTemplate(defaultMessageTemplate);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageProperty())) {
            announcer.setMessageProperty("text");
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !defaultMessageTemplate.equals(announcer.getMessageTemplate().trim()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"webhook." + announcer.getName() + ".messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
        return true;
    }
}

