/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.release;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.CommitAuthor;
import org.jreleaser.model.api.release.Changelog;
import org.jreleaser.model.api.release.Releaser;
import org.jreleaser.model.internal.release.BaseReleaser;

public class GiteaReleaser
extends BaseReleaser<org.jreleaser.model.api.release.GiteaReleaser, GiteaReleaser> {
    private static final long serialVersionUID = -1447563457831439973L;
    private Boolean draft;
    @JsonIgnore
    private final org.jreleaser.model.api.release.GiteaReleaser immutable = new org.jreleaser.model.api.release.GiteaReleaser(){
        private static final long serialVersionUID = -2135534604107948779L;

        public boolean isPrerelease() {
            return GiteaReleaser.this.isPrerelease();
        }

        public boolean isDraft() {
            return GiteaReleaser.this.isDraft();
        }

        public String getServiceName() {
            return GiteaReleaser.this.getServiceName();
        }

        public boolean isReleaseSupported() {
            return GiteaReleaser.this.isReleaseSupported();
        }

        public String getCanonicalRepoName() {
            return GiteaReleaser.this.getCanonicalRepoName();
        }

        public String getReverseRepoHost() {
            return GiteaReleaser.this.getReverseRepoHost();
        }

        public boolean isMatch() {
            return GiteaReleaser.this.isMatch();
        }

        public String getHost() {
            return GiteaReleaser.this.getHost();
        }

        public String getName() {
            return GiteaReleaser.this.getName();
        }

        public String getRepoUrl() {
            return GiteaReleaser.this.getRepoUrl();
        }

        public String getRepoCloneUrl() {
            return GiteaReleaser.this.getRepoCloneUrl();
        }

        public String getCommitUrl() {
            return GiteaReleaser.this.getCommitUrl();
        }

        public String getSrcUrl() {
            return GiteaReleaser.this.getSrcUrl();
        }

        public String getDownloadUrl() {
            return GiteaReleaser.this.getDownloadUrl();
        }

        public String getReleaseNotesUrl() {
            return GiteaReleaser.this.getReleaseNotesUrl();
        }

        public String getLatestReleaseUrl() {
            return GiteaReleaser.this.getLatestReleaseUrl();
        }

        public String getIssueTrackerUrl() {
            return GiteaReleaser.this.getIssueTrackerUrl();
        }

        public String getUsername() {
            return GiteaReleaser.this.getUsername();
        }

        public String getToken() {
            return GiteaReleaser.this.getToken();
        }

        public String getTagName() {
            return GiteaReleaser.this.getTagName();
        }

        public String getPreviousTagName() {
            return GiteaReleaser.this.getPreviousTagName();
        }

        public String getReleaseName() {
            return GiteaReleaser.this.getReleaseName();
        }

        public String getBranch() {
            return GiteaReleaser.this.getBranch();
        }

        public String getBranchPush() {
            return GiteaReleaser.this.getBranchPush();
        }

        public Releaser.Prerelease getPrerelease() {
            return GiteaReleaser.this.getPrerelease().asImmutable();
        }

        public boolean isSign() {
            return GiteaReleaser.this.isSign();
        }

        public Changelog getChangelog() {
            return GiteaReleaser.this.getChangelog().asImmutable();
        }

        public Releaser.Milestone getMilestone() {
            return GiteaReleaser.this.getMilestone().asImmutable();
        }

        public Releaser.Issues getIssues() {
            return GiteaReleaser.this.getIssues().asImmutable();
        }

        public boolean isSkipTag() {
            return GiteaReleaser.this.isSkipTag();
        }

        public boolean isSkipRelease() {
            return GiteaReleaser.this.isSkipRelease();
        }

        public boolean isOverwrite() {
            return GiteaReleaser.this.isOverwrite();
        }

        public Releaser.Update getUpdate() {
            return GiteaReleaser.this.getUpdate().asImmutable();
        }

        public String getApiEndpoint() {
            return GiteaReleaser.this.getApiEndpoint();
        }

        public boolean isArtifacts() {
            return GiteaReleaser.this.isArtifacts();
        }

        public boolean isFiles() {
            return GiteaReleaser.this.isFiles();
        }

        public boolean isChecksums() {
            return GiteaReleaser.this.isChecksums();
        }

        public boolean isCatalogs() {
            return GiteaReleaser.this.isCatalogs();
        }

        public boolean isSignatures() {
            return GiteaReleaser.this.isSignatures();
        }

        public Active getUploadAssets() {
            return GiteaReleaser.this.getUploadAssets();
        }

        public CommitAuthor getCommitAuthor() {
            return GiteaReleaser.this.getCommitAuthor().asImmutable();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(GiteaReleaser.this.asMap(full));
        }

        public boolean isEnabled() {
            return GiteaReleaser.this.isEnabled();
        }

        public String getOwner() {
            return GiteaReleaser.this.getOwner();
        }

        public Integer getConnectTimeout() {
            return GiteaReleaser.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return GiteaReleaser.this.getReadTimeout();
        }
    };

    public GiteaReleaser() {
        this("gitea");
    }

    GiteaReleaser(String name) {
        super(name, true);
        this.setRepoUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}");
        this.setRepoCloneUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}.git");
        this.setCommitUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/commits");
        this.setSrcUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/src/{{repoBranch}}");
        this.setDownloadUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/download/{{tagName}}/{{artifactFile}}");
        this.setReleaseNotesUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/tag/{{tagName}}");
        this.setLatestReleaseUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/releases/latest");
        this.setIssueTrackerUrl("https://{{repoHost}}/{{repoOwner}}/{{repoName}}/issues");
    }

    @Override
    public org.jreleaser.model.api.release.GiteaReleaser asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(GiteaReleaser source) {
        super.merge(source);
        this.draft = this.merge(this.draft, source.draft);
    }

    public boolean isDraft() {
        return null != this.draft && this.draft != false;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public boolean isDraftSet() {
        return null != this.draft;
    }

    @Override
    public String getReverseRepoHost() {
        return null;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> map = super.asMap(full);
        map.put("draft", this.isDraft());
        return map;
    }
}

