/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.hooks;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.NamedScriptHooks;
import org.jreleaser.model.internal.hooks.ScriptHook;
import org.jreleaser.model.internal.hooks.ScriptHooks;
import org.jreleaser.model.internal.validation.common.MatrixValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class ScriptHooksValidator {
    private ScriptHooksValidator() {
    }

    public static void validateScriptHooks(JReleaserContext context, Errors errors) {
        int i;
        context.getLogger().debug("hooks.script");
        ScriptHooks hooks = context.getModel().getHooks().getScript();
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks.script", "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.getMatrix().isEmpty()) {
            hooks.setMatrix(context.getModel().getHooks().getMatrix());
        }
        if (hooks.isApplyDefaultMatrix()) {
            hooks.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hooks.getMatrix(), "hooks.script.matrix", errors);
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getBefore().get(i), "before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getSuccess().get(i), "success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getFailure().get(i), "failure", i, errors);
        }
        for (Map.Entry<String, NamedScriptHooks> e : hooks.getGroups().entrySet()) {
            e.getValue().setName(e.getKey());
            ScriptHooksValidator.validateNamedScriptHooks(context, hooks, e.getValue(), errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getSuccess().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getFailure().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getGroups().values().stream().anyMatch(AbstractActivatable::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    public static void validateNamedScriptHooks(JReleaserContext context, ScriptHooks parentHooks, NamedScriptHooks hooks, Errors errors) {
        int i;
        context.getLogger().debug("hooks.script." + hooks.getName());
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks.script." + hooks.getName(), "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.getMatrix().isEmpty()) {
            hooks.setMatrix(parentHooks.getMatrix());
        }
        if (hooks.isApplyDefaultMatrix()) {
            hooks.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hooks.getMatrix(), "hooks.script.matrix", errors);
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            hooks.getBefore().get(i).setName(hooks.getName());
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getBefore().get(i), hooks.getName() + ".before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            hooks.getSuccess().get(i).setName(hooks.getName());
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getSuccess().get(i), hooks.getName() + ".success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            hooks.getFailure().get(i).setName(hooks.getName());
            ScriptHooksValidator.validateScriptHook(context, hooks, hooks.getFailure().get(i), hooks.getName() + ".failure", i, errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getSuccess().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getFailure().stream().anyMatch(AbstractActivatable::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    private static void validateScriptHook(JReleaserContext context, MatrixAware matrixProvider, ScriptHook hook, String type, int index, Errors errors) {
        context.getLogger().debug("hooks.script.{}[{}]", new Object[]{type, index});
        Validator.resolveActivatable(context, (Activatable)hook, "hooks.script." + type + "." + index, "ALWAYS");
        if (!hook.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (hook.getMatrix().isEmpty()) {
            hook.setMatrix(matrixProvider.getMatrix());
        }
        if (hook.isApplyDefaultMatrix()) {
            hook.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hook.getMatrix(), "hooks.script." + type + "[" + index + "].matrix", errors);
        if (StringUtils.isBlank((String)hook.getRun())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"hook.script"}));
        }
    }
}

