/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.version;

import java.util.Objects;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.Version;

public class CustomVersion
implements Version<CustomVersion> {
    private final String version;

    private CustomVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equalsSpec(CustomVersion version) {
        return true;
    }

    @Override
    public String toRpmVersion() {
        return this.toString().replace("-", "_");
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        CustomVersion v = (CustomVersion)o;
        return this.version.equals(v.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    @Override
    public int compareTo(CustomVersion other) {
        return this.version.compareTo(other.version);
    }

    public static CustomVersion defaultOf() {
        return CustomVersion.of("0.0.0");
    }

    public static CustomVersion of(String version) {
        StringUtils.requireNonBlank((String)version, (String)"Argument 'version' must not be blank");
        return new CustomVersion(version);
    }
}

