/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.util.Set;
import org.jreleaser.cli.AbstractCommand;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.Main;
import org.jreleaser.cli.internal.CliJReleaserModelPrinter;
import org.jreleaser.engine.context.ModelValidator;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import picocli.CommandLine;

@CommandLine.Command(name="config")
public class Config
extends AbstractPlatformAwareModelCommand<Main> {
    @CommandLine.Option(names={"-f", "--full"})
    boolean full;
    @CommandLine.ArgGroup
    Exclusive exclusive;

    @Override
    protected void collectCandidateDeprecatedArgs(Set<AbstractCommand.DeprecatedArg> args) {
        super.collectCandidateDeprecatedArgs(args);
        args.add(new AbstractCommand.DeprecatedArg("-a", "--assembly", "1.5.0"));
        args.add(new AbstractCommand.DeprecatedArg("-d", "--download", "1.5.0"));
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        ModelValidator.validate((JReleaserContext)context);
        new CliJReleaserModelPrinter(((Main)this.parent()).getOut()).print(context.getModel().asMap(this.full));
        context.report();
    }

    @Override
    protected JReleaserContext.Mode getMode() {
        if (this.download()) {
            return JReleaserContext.Mode.DOWNLOAD;
        }
        if (this.assembly()) {
            return JReleaserContext.Mode.ASSEMBLE;
        }
        if (this.changelog()) {
            return JReleaserContext.Mode.CHANGELOG;
        }
        if (this.announce()) {
            return JReleaserContext.Mode.ANNOUNCE;
        }
        return JReleaserContext.Mode.CONFIG;
    }

    private boolean download() {
        return null != this.exclusive && this.exclusive.download;
    }

    private boolean assembly() {
        return null != this.exclusive && this.exclusive.assembly;
    }

    private boolean changelog() {
        return null != this.exclusive && this.exclusive.changelog;
    }

    private boolean announce() {
        return null != this.exclusive && this.exclusive.announce;
    }

    @Override
    protected JReleaserCommand getCommand() {
        return JReleaserCommand.CONFIG;
    }

    static class Exclusive {
        @CommandLine.Option(names={"--announce"}, required=true)
        boolean announce;
        @CommandLine.Option(names={"-a", "--assembly"}, required=true)
        boolean assembly;
        @CommandLine.Option(names={"--changelog"}, required=true)
        boolean changelog;
        @CommandLine.Option(names={"-d", "--download"}, required=true)
        boolean download;

        Exclusive() {
        }
    }
}

