/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.packagers.DockerConfiguration;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.packagers.AbstractDockerConfiguration;
import org.jreleaser.model.internal.packagers.DockerConfiguration;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class DockerSpec
extends AbstractDockerConfiguration<DockerSpec>
implements Domain {
    private static final long serialVersionUID = 5373884037924711407L;
    private final Map<String, Object> matchers = new LinkedHashMap<String, Object>();
    private Artifact artifact;
    private String name;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.DockerSpec immutable = new org.jreleaser.model.api.packagers.DockerSpec(){
        private static final long serialVersionUID = 4314004887192195726L;
        private Set<? extends DockerConfiguration.Registry> registries;

        public org.jreleaser.model.api.common.Artifact getArtifact() {
            return DockerSpec.this.artifact.asImmutable();
        }

        public String getName() {
            return DockerSpec.this.name;
        }

        public Map<String, Object> getMatchers() {
            return Collections.unmodifiableMap(DockerSpec.this.matchers);
        }

        public String getTemplateDirectory() {
            return DockerSpec.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(DockerSpec.this.getSkipTemplates());
        }

        public String getBaseImage() {
            return DockerSpec.this.getBaseImage();
        }

        public Map<String, String> getLabels() {
            return Collections.unmodifiableMap(DockerSpec.this.getLabels());
        }

        public Set<String> getImageNames() {
            return Collections.unmodifiableSet(DockerSpec.this.getImageNames());
        }

        public List<String> getBuildArgs() {
            return Collections.unmodifiableList(DockerSpec.this.getBuildArgs());
        }

        public List<String> getPreCommands() {
            return Collections.unmodifiableList(DockerSpec.this.getPreCommands());
        }

        public List<String> getPostCommands() {
            return Collections.unmodifiableList(DockerSpec.this.getPostCommands());
        }

        public Set<? extends DockerConfiguration.Registry> getRegistries() {
            if (null == this.registries) {
                this.registries = DockerSpec.this.getRegistries().stream().map(DockerConfiguration.Registry::asImmutable).collect(Collectors.toSet());
            }
            return this.registries;
        }

        public boolean isUseLocalArtifact() {
            return DockerSpec.this.isUseLocalArtifact();
        }

        public Active getActive() {
            return DockerSpec.this.getActive();
        }

        public boolean isEnabled() {
            return DockerSpec.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(DockerSpec.this.asMap(full));
        }

        public String getPrefix() {
            return DockerSpec.this.prefix();
        }

        public DockerConfiguration.DockerCommand getCommand() {
            return DockerSpec.this.getCommand();
        }

        public DockerConfiguration.Buildx getBuildx() {
            return DockerSpec.this.getBuildx().asImmutable();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(DockerSpec.this.getExtraProperties());
        }
    };

    public org.jreleaser.model.api.packagers.DockerSpec asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(DockerSpec source) {
        super.merge(source);
        this.name = this.merge(this.name, source.name);
        this.artifact = source.artifact;
        this.setMatchers(this.merge(this.matchers, source.matchers));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
        this.artifact.select();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Map<String, Object> matchers) {
        this.matchers.putAll(matchers);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> props = super.asMap(full);
        if (!props.isEmpty()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, props);
            return map;
        }
        return props;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("matchers", this.matchers);
        if (null != this.artifact) {
            props.put("artifact", this.artifact.asMap(full));
        }
    }

    public boolean matches(Artifact artifact) {
        boolean matched = true;
        for (Map.Entry<String, Object> e : this.matchers.entrySet()) {
            String key = e.getKey();
            if ("platform".equals(key)) {
                matched &= StringUtils.isNotBlank((String)artifact.getPlatform()) && PlatformUtils.isCompatible((String)String.valueOf(e.getValue()), (String)artifact.getPlatform());
                continue;
            }
            if (!artifact.getExtraProperties().containsKey(key)) continue;
            matched &= e.getValue().equals(artifact.getExtraProperties().get(key));
        }
        return matched;
    }
}

