program nrtex
!
! This program translates a .nroff file into a .tex LaTeX file suitable
! for the internal HELP of Gildas programs
!
! The output maximum width is set by default to 50em in the .css file
! I have no idea on how to change that, but after manual editing, it 
! seems the specified value persists.
!
! Perhaps a "page width" in Latex file ?
!
  character(len=128) :: infile, outfile, curfile
  character(len=256) :: line
  character(len=64) :: prefix
  integer, parameter :: iout=3
  integer :: idep, iunit(6), nl,lp, ier
  logical :: verb
  data iunit/10,11,12,13,14,15/
  !
  call get_command_argument(1,infile)
  outfile = trim(infile)//".tex"
  infile = trim(infile)//".nroff"
  Print *,trim(infile)
  Print *,trim(outfile)
  !
  open(unit=iunit(1),file=infile,status='OLD')
  open(unit=iout,file=outfile,status='UNKNOWN')
  open(unit=2, file='error.txt', status='unknown')
  rewind(2)
  rewind(iout)
  !
  idep = 1
  ier = 0
  verb = .false.
  lp = 0
  do 
    read(iunit(idep),'(A)',iostat=ier) line
    if (ier.ne.0) then
      ! Decrease depth or exit
      Print *,'Closing '//trim(curfile)
      close(unit=iunit(idep))
      if (idep.eq.1) exit
      idep = idep-1
    endif
    !
    if (line(1:1).eq.'.') then
      if (line(1:4).eq.'.nf') then
        write(iout,'(A,A)') "\begin{verbatim}"
        verb = .true.
      else if (line(1:4).eq.'.fi') then
        write(iout,'(A,A)') "\end{verbatim}"
        verb = .false.
      else if (line(1:4).eq.'.br') then
        write(iout,'(A)') "\htbreak"
      else if (line(1:3).eq.'.so ') then
        ! Branch to another source file and increase depth
        idep = idep+1
        curfile = adjustl(line(4:))
        Print *,'Branching to ['//trim(curfile)//']'
        open(iunit(idep),file=curfile,status='OLD')
      endif
    else if (line(1:2).eq.'1 ') then
      flush(unit=iout)
      flush(unit=2)
      ! Command level help
      if (line(iout:).eq."ENDOFHELP") exit
      call escape(line)
!      call special(line,'%')
!      call special(line,'#')
      write(iout,*) "\subsection{"//trim(line(3:))//"}"
      lp = 0
    else if (line(1:2).eq.'2 ') then
      flush(unit=iout)
      flush(unit=2)
      ! Option, Argument, Variable or Result level help
      call escape(line)
      call special(line,'%')
      nl = len_trim(line)
      if (line(nl:nl).eq.':') then
        write(iout,*) "\subsubsection{"//trim(line(3:nl))//"}"
        prefix = "\htpad "  !rawhtml &nbsp;&nbsp;&nbsp;&nbsp; \endrawhtml"
        lp = len_trim(prefix)+1
      else if (lp.eq.0) then
        write(iout,*) "\subsubsection{"//trim(line(3:nl))//"}"
      else
        write(iout,*) "\subsubsection{"//prefix(1:lp)//trim(line(3:nl))//"}"
      endif
    else if (verb) then
      call verbatim(line)
      write(iout,*) trim(line)
    else
      call escape(line)
      call special(line,'%')
      call special(line,'#')
      call special(line,'^')
      call special(line,'$')
      write(iout,*) trim(line)
    endif      
  enddo
  close(unit=iout)
end program
!
subroutine special(line,token)
  character(len=*), intent(inout) :: line
  character(len=1), intent(in) :: token
  !
  ! Prefix the specific token by an escape character
  character(len=256) :: myline
  integer :: iesc,iinp, iout
  iesc = index(line,token) 
  !
  if (iesc.eq.0) return
  !
  iinp = 1
  iout = 1
  myline = ' '
  do while (iesc.ne.0) 
    myline(iout:) = line(iinp:iesc-1)
    iout = iout+iesc-iinp
    iinp = iesc+1
    myline(iout:) = "\"//token
    iout = iout+2
    iesc = index(line(iinp:),token) 
    if (iesc.eq.0) then
      myline(iout:) = line(iinp:)
      exit
    else
      write(2,*) 'IESC ',iesc,iinp,line(iinp:),iesc+iinp
      iesc = iinp+iesc-1
    endif
  enddo
  Write(2,*) 'Token '//token//' LINE ',trim(line)
  Write(2,*) 'Out  ',trim(myline)
  line = myline
end subroutine special
!
subroutine verbatim(line)
  character(len=*), intent(inout) :: line
  !
  character(len=256) :: myline
  integer :: iesc,iinp, iout
  iesc = index(line,'_') 
  !
  if (iesc.eq.0) return
  !
  iinp = 1
  iout = 1
  myline = ' '
  do while (iesc.ne.0) 
    if (line(iesc:iesc+1).eq.'_\') then
      myline(iout:) = line(iinp:iesc-1)
      iout = iout+iesc-iinp
      iinp = iesc+2
      myline(iout:) = "\"
      iout = iout+1
      iesc = index(line(iinp:),'_') 
    else if (line(iesc:iesc+1).eq.'__') then
      myline(iout:) = line(iinp:iesc-1)
      iout = iout+iesc-iinp
      iinp = iesc+2
      myline(iout:) = "_"
      iout = iout+1 
      iesc = index(line(iinp:),'_') 
    endif
    if (iesc.eq.0) then
      myline(iout:) = line(iinp:)
      exit
    else
      iesc = iinp+iesc-1
    endif
  enddo
  Write(2,*) 'LINE ',trim(line)
  Write(2,*) 'Out  ',trim(myline)
  line = myline
end subroutine verbatim

subroutine escape(line)
  character(len=*), intent(inout) :: line
  !
  character(len=256) :: myline
  integer :: iesc,iinp, iout
  !
  iesc = index(line,'_') 
  if (iesc.eq.0) return
  !
  iinp = 1
  iout = 1
  myline = ' '
  do while (iesc.ne.0) 
    if (line(iesc:iesc+1).eq.'_\') then
      myline(iout:) = line(iinp:iesc-1)
      iout = iout+iesc-iinp
      iinp = iesc+2
      myline(iout:) = "\textbackslash{}"
      iout = len_trim(myline)+1
      iesc = index(line(iinp:),'_') 
    else if (line(iesc:iesc+1).eq.'__') then
      myline(iout:) = line(iinp:iesc-1)
      iout = iout+iesc-iinp
      iinp = iesc+2
      myline(iout:) = "\_"
      iout = iout+2 
      iesc = index(line(iinp:),'_') 
    endif
    if (iesc.eq.0) then
      myline(iout:) = line(iinp:)
      exit
    else
      iesc = iinp+iesc-1
    endif
  enddo
  line = myline
end subroutine escape
