# -*- coding: utf-8 -*- #
# Copyright 2025 Google LLC. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Commands for ."""

from googlecloudsdk.calliope import base


@base.UniverseCompatible
@base.ReleaseTracks(base.ReleaseTrack.ALPHA)
class PreviewFeatures(base.Group):
  """Read and manipulate Compute Engine Preview Features."""


PreviewFeatures.category = base.TOOLS_CATEGORY

PreviewFeatures.detailed_help = {
    'DESCRIPTION': """
        Read and manipulate Compute Engine Preview Features.
    """,
}
