"""Generated client library for cloudaicompanion version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudaicompanion.v1 import cloudaicompanion_v1_messages as messages


class CloudaicompanionV1(base_api.BaseApiClient):
  """Generated client library for service cloudaicompanion version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudaicompanion.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudaicompanion.mtls.googleapis.com/'

  _PACKAGE = 'cloudaicompanion'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudaicompanionV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudaicompanion handle."""
    url = url or self.BASE_URL
    super(CloudaicompanionV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_codeRepositoryIndexes_repositoryGroups = self.ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService(self)
    self.projects_locations_codeRepositoryIndexes = self.ProjectsLocationsCodeRepositoryIndexesService(self)
    self.projects_locations_dataSharingWithGoogleSettings_settingBindings = self.ProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsService(self)
    self.projects_locations_dataSharingWithGoogleSettings = self.ProjectsLocationsDataSharingWithGoogleSettingsService(self)
    self.projects_locations_geminiGcpEnablementSettings_settingBindings = self.ProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsService(self)
    self.projects_locations_geminiGcpEnablementSettings = self.ProjectsLocationsGeminiGcpEnablementSettingsService(self)
    self.projects_locations_loggingSettings_settingBindings = self.ProjectsLocationsLoggingSettingsSettingBindingsService(self)
    self.projects_locations_loggingSettings = self.ProjectsLocationsLoggingSettingsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_releaseChannelSettings_settingBindings = self.ProjectsLocationsReleaseChannelSettingsSettingBindingsService(self)
    self.projects_locations_releaseChannelSettings = self.ProjectsLocationsReleaseChannelSettingsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_codeRepositoryIndexes_repositoryGroups resource."""

    _NAME = 'projects_locations_codeRepositoryIndexes_repositoryGroups'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new RepositoryGroup in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['repositoryGroupId', 'requestId'],
        relative_path='v1/{+parent}/repositoryGroups',
        request_field='repositoryGroup',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RepositoryGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest',
        response_type_name='RepositoryGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:getIamPolicy',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists RepositoryGroups in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRepositoryGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/repositoryGroups',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest',
        response_type_name='ListRepositoryGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='repositoryGroup',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:setIamPolicy',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:testIamPermissions',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCodeRepositoryIndexesService(base_api.BaseApiService):
    """Service class for the projects_locations_codeRepositoryIndexes resource."""

    _NAME = 'projects_locations_codeRepositoryIndexes'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsCodeRepositoryIndexesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new CodeRepositoryIndex in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['codeRepositoryIndexId', 'requestId'],
        relative_path='v1/{+parent}/codeRepositoryIndexes',
        request_field='codeRepositoryIndex',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CodeRepositoryIndex) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest',
        response_type_name='CodeRepositoryIndex',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CodeRepositoryIndexes in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCodeRepositoryIndexesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/codeRepositoryIndexes',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest',
        response_type_name='ListCodeRepositoryIndexesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='codeRepositoryIndex',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_dataSharingWithGoogleSettings_settingBindings resource."""

    _NAME = 'projects_locations_dataSharingWithGoogleSettings_settingBindings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new SettingBinding in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}/settingBindings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.settingBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'settingBindingId'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}/settingBindings/{settingBindingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.settingBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SettingBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}/settingBindings/{settingBindingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.settingBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsGetRequest',
        response_type_name='SettingBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists SettingBindings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSettingBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}/settingBindings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.settingBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsListRequest',
        response_type_name='ListSettingBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}/settingBindings/{settingBindingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.settingBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsDataSharingWithGoogleSettingsService(base_api.BaseApiService):
    """Service class for the projects_locations_dataSharingWithGoogleSettings resource."""

    _NAME = 'projects_locations_dataSharingWithGoogleSettings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsDataSharingWithGoogleSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DataSharingWithGoogleSetting in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSharingWithGoogleSetting) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['dataSharingWithGoogleSettingId', 'requestId'],
        relative_path='v1/{+parent}/dataSharingWithGoogleSettings',
        request_field='dataSharingWithGoogleSetting',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsCreateRequest',
        response_type_name='DataSharingWithGoogleSetting',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single DataSharingWithGoogleSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DataSharingWithGoogleSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSharingWithGoogleSetting) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsGetRequest',
        response_type_name='DataSharingWithGoogleSetting',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DataSharingWithGoogleSettings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDataSharingWithGoogleSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/dataSharingWithGoogleSettings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsListRequest',
        response_type_name='ListDataSharingWithGoogleSettingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single DataSharingWithGoogleSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DataSharingWithGoogleSetting) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSettingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.dataSharingWithGoogleSettings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='dataSharingWithGoogleSetting',
        request_type_name='CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsPatchRequest',
        response_type_name='DataSharingWithGoogleSetting',
        supports_download=False,
    )

  class ProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_geminiGcpEnablementSettings_settingBindings resource."""

    _NAME = 'projects_locations_geminiGcpEnablementSettings_settingBindings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new SettingBinding in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}/settingBindings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.settingBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'settingBindingId'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}/settingBindings/{settingBindingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.settingBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SettingBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}/settingBindings/{settingBindingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.settingBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsGetRequest',
        response_type_name='SettingBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists SettingBindings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSettingBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}/settingBindings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.settingBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsListRequest',
        response_type_name='ListSettingBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}/settingBindings/{settingBindingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.settingBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsGeminiGcpEnablementSettingsService(base_api.BaseApiService):
    """Service class for the projects_locations_geminiGcpEnablementSettings resource."""

    _NAME = 'projects_locations_geminiGcpEnablementSettings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsGeminiGcpEnablementSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new GeminiGcpEnablementSetting in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GeminiGcpEnablementSetting) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['geminiGcpEnablementSettingId', 'requestId'],
        relative_path='v1/{+parent}/geminiGcpEnablementSettings',
        request_field='geminiGcpEnablementSetting',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsCreateRequest',
        response_type_name='GeminiGcpEnablementSetting',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single GeminiGcpEnablementSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single GeminiGcpEnablementSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GeminiGcpEnablementSetting) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsGetRequest',
        response_type_name='GeminiGcpEnablementSetting',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists GeminiGcpEnablementSettings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListGeminiGcpEnablementSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/geminiGcpEnablementSettings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsListRequest',
        response_type_name='ListGeminiGcpEnablementSettingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single GeminiGcpEnablementSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GeminiGcpEnablementSetting) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/geminiGcpEnablementSettings/{geminiGcpEnablementSettingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.geminiGcpEnablementSettings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='geminiGcpEnablementSetting',
        request_type_name='CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsPatchRequest',
        response_type_name='GeminiGcpEnablementSetting',
        supports_download=False,
    )

  class ProjectsLocationsLoggingSettingsSettingBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_loggingSettings_settingBindings resource."""

    _NAME = 'projects_locations_loggingSettings_settingBindings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsLoggingSettingsSettingBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new SettingBinding in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}/settingBindings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.loggingSettings.settingBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'settingBindingId'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}/settingBindings/{settingBindingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.loggingSettings.settingBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SettingBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}/settingBindings/{settingBindingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.loggingSettings.settingBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsGetRequest',
        response_type_name='SettingBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists SettingBindings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSettingBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}/settingBindings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.loggingSettings.settingBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsListRequest',
        response_type_name='ListSettingBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}/settingBindings/{settingBindingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.loggingSettings.settingBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsLoggingSettingsService(base_api.BaseApiService):
    """Service class for the projects_locations_loggingSettings resource."""

    _NAME = 'projects_locations_loggingSettings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsLoggingSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new LoggingSetting in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LoggingSetting) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.loggingSettings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['loggingSettingId', 'requestId'],
        relative_path='v1/{+parent}/loggingSettings',
        request_field='loggingSetting',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsCreateRequest',
        response_type_name='LoggingSetting',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single LoggingSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.loggingSettings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single LoggingSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LoggingSetting) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.loggingSettings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsGetRequest',
        response_type_name='LoggingSetting',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists LoggingSettings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLoggingSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.loggingSettings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/loggingSettings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsListRequest',
        response_type_name='ListLoggingSettingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single LoggingSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsLoggingSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (LoggingSetting) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/loggingSettings/{loggingSettingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.loggingSettings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='loggingSetting',
        request_type_name='CloudaicompanionProjectsLocationsLoggingSettingsPatchRequest',
        response_type_name='LoggingSetting',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='CloudaicompanionProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsReleaseChannelSettingsSettingBindingsService(base_api.BaseApiService):
    """Service class for the projects_locations_releaseChannelSettings_settingBindings resource."""

    _NAME = 'projects_locations_releaseChannelSettings_settingBindings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsReleaseChannelSettingsSettingBindingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new SettingBinding in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}/settingBindings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.settingBindings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['requestId', 'settingBindingId'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}/settingBindings/{settingBindingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.settingBindings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SettingBinding) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}/settingBindings/{settingBindingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.settingBindings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsGetRequest',
        response_type_name='SettingBinding',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists SettingBindings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListSettingBindingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}/settingBindings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.settingBindings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/settingBindings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsListRequest',
        response_type_name='ListSettingBindingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single SettingBinding.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}/settingBindings/{settingBindingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.settingBindings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='settingBinding',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsReleaseChannelSettingsService(base_api.BaseApiService):
    """Service class for the projects_locations_releaseChannelSettings resource."""

    _NAME = 'projects_locations_releaseChannelSettings'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsReleaseChannelSettingsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ReleaseChannelSetting in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseChannelSetting) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['releaseChannelSettingId', 'requestId'],
        relative_path='v1/{+parent}/releaseChannelSettings',
        request_field='releaseChannelSetting',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsCreateRequest',
        response_type_name='ReleaseChannelSetting',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ReleaseChannelSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ReleaseChannelSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseChannelSetting) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsGetRequest',
        response_type_name='ReleaseChannelSetting',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ReleaseChannelSettings in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListReleaseChannelSettingsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/releaseChannelSettings',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsListRequest',
        response_type_name='ListReleaseChannelSettingsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single ReleaseChannelSetting.

      Args:
        request: (CloudaicompanionProjectsLocationsReleaseChannelSettingsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReleaseChannelSetting) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/releaseChannelSettings/{releaseChannelSettingsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.releaseChannelSettings.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1/{+name}',
        request_field='releaseChannelSetting',
        request_type_name='CloudaicompanionProjectsLocationsReleaseChannelSettingsPatchRequest',
        response_type_name='ReleaseChannelSetting',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (CloudaicompanionProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudaicompanionV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
