// Code generated by go generate; DO NOT EDIT.
package gitlab

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Api Permission = iota
    ReadUser Permission = iota
    ReadApi Permission = iota
    ReadRepository Permission = iota
    WriteRepository Permission = iota
    ReadRegistry Permission = iota
    WriteRegistry Permission = iota
    Sudo Permission = iota
    AdminMode Permission = iota
    CreateRunner Permission = iota
    ManageRunner Permission = iota
    AiFeatures Permission = iota
    K8sProxy Permission = iota
    ReadServicePing Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Api: "api",
        ReadUser: "read_user",
        ReadApi: "read_api",
        ReadRepository: "read_repository",
        WriteRepository: "write_repository",
        ReadRegistry: "read_registry",
        WriteRegistry: "write_registry",
        Sudo: "sudo",
        AdminMode: "admin_mode",
        CreateRunner: "create_runner",
        ManageRunner: "manage_runner",
        AiFeatures: "ai_features",
        K8sProxy: "k8s_proxy",
        ReadServicePing: "read_service_ping",
    }

    StringToPermission = map[string]Permission{
        "api": Api,
        "read_user": ReadUser,
        "read_api": ReadApi,
        "read_repository": ReadRepository,
        "write_repository": WriteRepository,
        "read_registry": ReadRegistry,
        "write_registry": WriteRegistry,
        "sudo": Sudo,
        "admin_mode": AdminMode,
        "create_runner": CreateRunner,
        "manage_runner": ManageRunner,
        "ai_features": AiFeatures,
        "k8s_proxy": K8sProxy,
        "read_service_ping": ReadServicePing,
    }

    PermissionIDs = map[Permission]int{
        Api: 1,
        ReadUser: 2,
        ReadApi: 3,
        ReadRepository: 4,
        WriteRepository: 5,
        ReadRegistry: 6,
        WriteRegistry: 7,
        Sudo: 8,
        AdminMode: 9,
        CreateRunner: 10,
        ManageRunner: 11,
        AiFeatures: 12,
        K8sProxy: 13,
        ReadServicePing: 14,
    }

    IdToPermission = map[int]Permission{
        1: Api,
        2: ReadUser,
        3: ReadApi,
        4: ReadRepository,
        5: WriteRepository,
        6: ReadRegistry,
        7: WriteRegistry,
        8: Sudo,
        9: AdminMode,
        10: CreateRunner,
        11: ManageRunner,
        12: AiFeatures,
        13: K8sProxy,
        14: ReadServicePing,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
