---
title: Community
weight: 400
---

The GitHub repo of Lima can be found at <https://github.com/lima-vm/lima>.

## Communication channels

- [GitHub Discussions](https://github.com/lima-vm/lima/discussions)

- `#lima` channel in the CNCF Slack
  - New account: <https://slack.cncf.io/>
  - Login: <https://cloud-native.slack.com/>

- Zoom meetings (tentatively monthly)
  - Meeting notes & agenda proposals: https://github.com/lima-vm/lima/discussions/categories/meetings
  - Calendar: https://zoom-lfx.platform.linuxfoundation.org/meetings/lima

- See <https://github.com/lima-vm/.github/blob/main/SECURITY.md> for how to report security issues.

## Social media accounts

Follow us for project updates, release announcements, and community news:

- https://x.com/@TheLimaProject
- https://mastodon.social/@TheLimaProject

## Projects using Lima

### Container environments
- [Rancher Desktop](https://rancherdesktop.io/): Kubernetes and container management to the desktop
- [Colima](https://github.com/abiosoft/colima): Docker (and Kubernetes) on macOS with minimal setup
- [Finch](https://github.com/runfinch/finch): Finch is a command line client for local container development
- [Podman Desktop](https://podman-desktop.io/): Podman Desktop GUI has a plug-in for Lima virtual machines

### GUI
- [Lima xbar plugin](https://github.com/unixorn/lima-xbar-plugin): [xbar](https://xbarapp.com/) plugin to start/stop VMs from the menu bar and see their running status.
- [lima-gui](https://github.com/afbjorklund/lima-gui): Qt GUI for Lima
