---
title: Talks
weight: 450
---

## 2022
### KubeCon + CloudNativeCon Europe 2022

[Akihiro Suda](https://github.com/AkihiroSuda) and [Jan Dubois](https://github.com/jandubois) presented "Running containerd and k3s on macOS" about Lima.

> It has been very hard to use Mac for developing containerized apps. A typical way is to use Docker for Mac, but it is not FLOSS. Another option is to install Docker and/or Kubernetes into VirtualBox, often via minikube, but it doesn't propagate localhost ports, and VirtualBox also doesn't support the ARM architecture. This session will show how to run containerd and k3s on macOS, using Lima and Rancher Desktop. Lima wraps QEMU in a simple CLI, with neat features for container users, such as filesystem sharing and automatic localhost port forwarding, as well as DNS and proxy propagation for enterprise networks. Rancher Desktop wraps Lima with k3s integration and GUI.

Read the [slides](https://static.sched.com/hosted_files/kccnceu2022/5f/lima.pdf) or watch the [video](https://www.youtube.com/watch?v=g5GCsbjkzRM).

### CNCF TAG-Runtime Meeting 2022-10-06

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in [the CNCF TAG-Runtime Meeting](https://github.com/cncf/tag-runtime).

Read the [slides](https://www.slideshare.net/AkihiroSuda/cncf-tagruntime-20221006-limapdf).

## 2023
### DevOps Toolkit 2023-02-09

[Anders Björklund](https://github.com/afbjorklund) presented Lima in The DevOps Toolkit Series.

Watch the [video](https://www.youtube.com/watch?v=GDInFocQJTU).

### KubeCon + CloudNativeCon Europe 2023

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://www.slideshare.net/AkihiroSuda/kubeconeu2023-lima-pavilion).

### KubeCon + CloudNativeCon North America 2023

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://github.com/AkihiroSuda/AkihiroSuda/blob/master/slides/2023/20231107%20%5BKubeCon%20NA%20Pavilion%5D%20Lima.pdf).

## 2024
### KubeCon + CloudNativeCon Europe 2024

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://github.com/AkihiroSuda/AkihiroSuda/blob/master/slides/2024/20240321%20%5BKubeCon%20EU%20Pavilion%5D%20Lima.pdf).

### Open Source Summit Europe 2024

[Harsh Thakur](https://github.com/RealHarshThakur) and [Kunal Verma](https://github.com/verma-kunal) presented
a talk ["Container Development Client for Reproducible Artifacts"](https://osseu2024.sched.com/event/1ej5z/container-development-client-for-reproducible-artifacts-harsh-thakur-civo-kunal-verma-kubesimplify).

> The container landscape is undergoing a transformation with innovative snapshotters and image formats. But how do we leverage these advancements to empower developers with more cost-effective solutions? Open source projects like Colima and Finch are paving the way for this new wave of container tooling. While they didn't fully meet our specific needs, they provided valuable building blocks for our solution. In our pursuit of achieving truly reproducible builds, we explored Nix and Nix-snapshotter. Combining the power of Nix, a robust package manager, with Nix-snapshotter's efficient caching capabilities within containerd, and the cross-platform functionality of Lima for managing Linux VMs, we've unlocked a new level of consistency and reproducibility for developers' software builds. This project empowers developers with unprecedented flexibility and control over their containerized environments. By embracing these innovations, we can expect reduced CI resource consumption, faster build times, and simplified security and compliance.

Watch the [video (13:40-)](https://www.youtube.com/watch?v=O4qIoMSv674&t=820s).

### KubeCon + CloudNativeCon North America 2024

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://github.com/AkihiroSuda/AkihiroSuda/blob/master/slides/2024/20241115%20%5BKubeCon%20NA%20Pavilion%5D%20Lima.pdf).

He also mentioned Lima in the presentation "What’s Going on in the Containerd Neighborhood?" in the context of case study of nerdctl.

Read the [slides](https://static.sched.com/hosted_files/kccncna2024/74/KCCNC-SLC-24-Containerd-session.pdf) or watch the [video](https://www.youtube.com/watch?v=kCNhgNXVdxw).

## 2025
### KubeCon + CloudNativeCon Europe 2025

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://github.com/AkihiroSuda/AkihiroSuda/blob/master/slides/2025/20250402%20%5BKubeCon%20EU%20Pavilion%5D%20Lima.pdf).

### EuroBSDCon 2025

[Leonardo Taccari](https://github.com/iamleot) presented Lima in the NetBSD devsummit at EuroBSDCon 2025.

Read the [slides](https://www.NetBSD.org/gallery/presentations/leot/eurobsdcon2025-devsummit-lima/lima.pdf).

### KubeCon + CloudNativeCon North America 2025

[Akihiro Suda](https://github.com/AkihiroSuda) presented Lima in the CNCF project pavilion.

Read the [slides](https://github.com/AkihiroSuda/AkihiroSuda/blob/master/slides/2025/20251113%20%5BKubeCon%20NA%20Pavilion%5D%20Lima.pdf).
