// Copyright 2025 Ksctl Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cmd

import (
	"fmt"

	"github.com/fatih/color"
	"github.com/ksctl/kli/v2/pkg/config"
	"github.com/spf13/cobra"
)

func (k *KsctlCommand) Version() *cobra.Command {

	logoKsctl := `
    ██╗  ██╗██╗     ██╗
    ██║ ██╔╝██║     ██║
    █████╔╝ ██║     ██║
    ██╔═██╗ ██║     ██║
    ██║  ██╗███████╗██║
    ╚═╝  ╚═╝╚══════╝╚═╝
`

	cmd := &cobra.Command{
		Use: "version",
		Example: `
kli version --help
`,
		Short: "kli version",
		Long:  "To get version for ksctl components",
		Run: func(cmd *cobra.Command, args []string) {

			fmt.Println(logoKsctl)

			k.l.Note(k.Ctx, "Components", color.HiGreenString("ksctl:kli"), color.HiBlueString(config.Version), color.HiGreenString("ksctl:core"), color.HiBlueString(config.KsctlCoreVer))
			k.l.Note(k.Ctx, "Build Information", "date", config.BuildDate)
		},
	}

	return cmd
}
