//
// This file is generated by grafana-app-sdk
// DO NOT EDIT
//

package apis

import (
	"fmt"
	"strings"

	"github.com/grafana/grafana-app-sdk/app"
	"github.com/grafana/grafana-app-sdk/resource"

	v0alpha1 "github.com/grafana/grafana/apps/alerting/notifications/pkg/apis/alerting/v0alpha1"
)

var appManifestData = app.ManifestData{
	AppName: "alerting",
	Group:   "notifications.alerting.grafana.app",
	Versions: []app.ManifestVersion{
		{
			Name:   "v0alpha1",
			Served: true,
			Kinds: []app.ManifestVersionKind{
				{
					Kind:       "Receiver",
					Plural:     "Receivers",
					Scope:      "Namespaced",
					Conversion: false,
					SelectableFields: []string{
						"spec.title",
					},
				},

				{
					Kind:       "RoutingTree",
					Plural:     "RoutingTrees",
					Scope:      "Namespaced",
					Conversion: false,
				},

				{
					Kind:       "TemplateGroup",
					Plural:     "TemplateGroups",
					Scope:      "Namespaced",
					Conversion: false,
					SelectableFields: []string{
						"spec.title",
					},
				},

				{
					Kind:       "TimeInterval",
					Plural:     "TimeIntervals",
					Scope:      "Namespaced",
					Conversion: false,
					SelectableFields: []string{
						"spec.name",
					},
				},
			},
		},
	},
}

func LocalManifest() app.Manifest {
	return app.NewEmbeddedManifest(appManifestData)
}

func RemoteManifest() app.Manifest {
	return app.NewAPIServerManifest("alerting")
}

var kindVersionToGoType = map[string]resource.Kind{
	"Receiver/v0alpha1":      v0alpha1.ReceiverKind(),
	"RoutingTree/v0alpha1":   v0alpha1.RoutingTreeKind(),
	"TemplateGroup/v0alpha1": v0alpha1.TemplateGroupKind(),
	"TimeInterval/v0alpha1":  v0alpha1.TimeIntervalKind(),
}

// ManifestGoTypeAssociator returns the associated resource.Kind instance for a given Kind and Version, if one exists.
// If there is no association for the provided Kind and Version, exists will return false.
func ManifestGoTypeAssociator(kind, version string) (goType resource.Kind, exists bool) {
	goType, exists = kindVersionToGoType[fmt.Sprintf("%s/%s", kind, version)]
	return goType, exists
}

var customRouteToGoResponseType = map[string]any{}

// ManifestCustomRouteResponsesAssociator returns the associated response go type for a given kind, version, custom route path, and method, if one exists.
// kind may be empty for custom routes which are not kind subroutes. Leading slashes are removed from subroute paths.
// If there is no association for the provided kind, version, custom route path, and method, exists will return false.
func ManifestCustomRouteResponsesAssociator(kind, version, path, verb string) (goType any, exists bool) {
	if len(path) > 0 && path[0] == '/' {
		path = path[1:]
	}
	goType, exists = customRouteToGoResponseType[fmt.Sprintf("%s|%s|%s|%s", version, kind, path, strings.ToUpper(verb))]
	return goType, exists
}
