Feature: display all executed Git commands

  Background:
    Given a Git repo with origin
    And the branches
      | NAME | TYPE    | PARENT | LOCATIONS     |
      | old  | feature | main   | local, origin |
    And the commits
      | BRANCH | LOCATION      | MESSAGE     |
      | main   | local, origin | main commit |
      | old    | local, origin | old commit  |
    And the current branch is "old"
    When I run "git-town rename new --verbose"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git branch --show-current                                                                                                                                                                                                                                                                                                                        |
      | old    | frontend | git fetch --prune --tags                                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | frontend | git branch --move old new                                                                                                                                                                                                                                                                                                                        |
      |        | frontend | git checkout new                                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git config git-town-branch.new.branchtype feature                                                                                                                                                                                                                                                                                                |
      |        | backend  | git config --unset git-town-branch.old.branchtype                                                                                                                                                                                                                                                                                                |
      |        | backend  | git config git-town-branch.new.parent main                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git config --unset git-town-branch.old.parent                                                                                                                                                                                                                                                                                                    |
      | new    | frontend | git push -u origin new                                                                                                                                                                                                                                                                                                                           |
      |        | frontend | git push origin :old                                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --verify -q refs/heads/old                                                                                                                                                                                                                                                                                                         |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
    And Git Town prints:
      """
      Ran 28 shell commands.
      """

  Scenario: undo
    When I run "git-town undo --verbose"
    Then Git Town runs the commands
      | BRANCH | TYPE     | COMMAND                                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git version                                                                                                                                                                                                                                                                                                                                      |
      |        | backend  | git rev-parse --show-toplevel                                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config -lz --global                                                                                                                                                                                                                                                                                                                          |
      |        | backend  | git config -lz --local                                                                                                                                                                                                                                                                                                                           |
      |        | backend  | git config -lz                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git status -z --ignore-submodules                                                                                                                                                                                                                                                                                                                |
      |        | backend  | git rev-parse --verify -q MERGE_HEAD                                                                                                                                                                                                                                                                                                             |
      |        | backend  | git rev-parse --absolute-git-dir                                                                                                                                                                                                                                                                                                                 |
      |        | backend  | git remote get-url origin                                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git stash list                                                                                                                                                                                                                                                                                                                                   |
      |        | backend  | git for-each-ref "--format=refname:%(refname) branchname:%(refname:lstrip=2) sha:%(objectname) head:%(if)%(HEAD)%(then)Y%(else)N%(end) worktree:%(if)%(worktreepath)%(then)Y%(else)N%(end) symref:%(if)%(symref)%(then)Y%(else)N%(end) upstream:%(upstream:lstrip=2) track:%(upstream:track,nobracket)" --sort=refname refs/heads/ refs/remotes/ |
      |        | backend  | git remote                                                                                                                                                                                                                                                                                                                                       |
      |        | backend  | git rev-parse --verify --abbrev-ref @{-1}                                                                                                                                                                                                                                                                                                        |
      |        | backend  | git config --unset git-town-branch.new.branchtype                                                                                                                                                                                                                                                                                                |
      |        | backend  | git config --unset git-town-branch.new.parent                                                                                                                                                                                                                                                                                                    |
      |        | backend  | git config git-town-branch.old.branchtype feature                                                                                                                                                                                                                                                                                                |
      |        | backend  | git config git-town-branch.old.parent main                                                                                                                                                                                                                                                                                                       |
      | new    | frontend | git branch old {{ sha 'old commit' }}                                                                                                                                                                                                                                                                                                            |
      |        | frontend | git push -u origin old                                                                                                                                                                                                                                                                                                                           |
      |        | frontend | git checkout old                                                                                                                                                                                                                                                                                                                                 |
      | old    | frontend | git branch -D new                                                                                                                                                                                                                                                                                                                                |
      |        | frontend | git push origin :new                                                                                                                                                                                                                                                                                                                             |
    And Git Town prints:
      """
      Ran 22 shell commands.
      """
