# Q & A

### Does Git Town enforce any specific conventions for branches or commits?

No, Git Town doesn't impose any rules for branch or commit naming. It works with
a wide range of Git branching strategies and workflows. If you find it doesn't
mesh with your specific setup,
[reach out to us](https://github.com/git-town/git-town/issues/new).

### Which Git branching models does Git Town support?

Git Town is flexible enough to support the most popular branching models like
[GitHub Flow](https://docs.github.com/en/get-started/quickstart/github-flow),
[Git Flow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow),
[GitLab Flow](https://docs.gitlab.com/ee/topics/gitlab_flow.html),
[trunk-based development](https://trunkbaseddevelopment.com). It even works if
you commit directly to the main branch!

### How is Git Town different from the [git-flow](https://github.com/nvie/gitflow) tool?

`git-flow` is a specialized Git extension designed around providing opinionated
support for the Git Flow branching model. It doesn't help with keeping your
branches or team in sync. Git Town, on the other hand, doesn't mind which
branching model you use&mdash;it focuses on syncing your team's work and keeping
your repo tidy by cleaning up old branches. You can use Git Town alongside
`git-flow` if that fits your workflow.

### Is Git Town compatible with other Git tools?

Yes, we try to be good citizens in the Git ecosystem. If you run into
compatibility issues, please
[let us know](https://github.com/git-town/git-town/issues/new)!

### Does my whole team have to use Git Town?

No, you can get value from Git Town even if you're the only one using it. It
simply automates the Git commands that you would (should) normally run.
