package harfbuzz

// Code generated with ragel -Z -o ot_use_machine.go ot_use_machine.rl ; sed -i '/^\/\/line/ d' ot_use_machine.go ; goimports -w ot_use_machine.go  DO NOT EDIT.

// ported from harfbuzz/src/hb-ot-shape-complex-use-machine.rl Copyright © 2015 Mozilla Foundation. Google, Inc. Jonathan Kew Behdad Esfahbod

const (
	useViramaTerminatedCluster = iota
	useSakotTerminatedCluster
	useStandardCluster
	useNumberJoinerTerminatedCluster
	useNumeralCluster
	useSymbolCluster
	useHieroglyphCluster
	useBrokenCluster
	useNonCluster
)

const useSM_ex_B = 1
const useSM_ex_CGJ = 6
const useSM_ex_CMAbv = 31
const useSM_ex_CMBlw = 32
const useSM_ex_CS = 43
const useSM_ex_FAbv = 24
const useSM_ex_FBlw = 25
const useSM_ex_FMAbv = 45
const useSM_ex_FMBlw = 46
const useSM_ex_FMPst = 47
const useSM_ex_FPst = 26
const useSM_ex_G = 49
const useSM_ex_GB = 5
const useSM_ex_H = 12
const useSM_ex_HN = 13
const useSM_ex_HVM = 53
const useSM_ex_IS = 44
const useSM_ex_J = 50
const useSM_ex_MAbv = 27
const useSM_ex_MBlw = 28
const useSM_ex_MPre = 30
const useSM_ex_MPst = 29
const useSM_ex_N = 4
const useSM_ex_O = 0
const useSM_ex_R = 18
const useSM_ex_SB = 51
const useSM_ex_SE = 52
const useSM_ex_SMAbv = 41
const useSM_ex_SMBlw = 42
const useSM_ex_SUB = 11
const useSM_ex_Sk = 48
const useSM_ex_VAbv = 33
const useSM_ex_VBlw = 34
const useSM_ex_VMAbv = 37
const useSM_ex_VMBlw = 38
const useSM_ex_VMPre = 23
const useSM_ex_VMPst = 39
const useSM_ex_VPre = 22
const useSM_ex_VPst = 35
const useSM_ex_WJ = 16
const useSM_ex_ZWNJ = 14

var _useSM_actions []byte = []byte{
	0, 1, 0, 1, 1, 1, 2, 1, 3,
	1, 4, 1, 5, 1, 6, 1, 7,
	1, 8, 1, 9, 1, 10, 1, 11,
	1, 12, 1, 13, 1, 14, 1, 15,
	1, 16, 1, 17, 1, 18, 1, 19,
}

var _useSM_key_offsets []int16 = []int16{
	0, 37, 65, 91, 105, 117, 124, 130,
	135, 138, 140, 141, 152, 162, 171, 173,
	181, 198, 214, 229, 243, 263, 276, 295,
	313, 334, 359, 361, 374, 400, 403, 405,
	431, 457, 471, 483, 490, 496, 501, 504,
	506, 507, 518, 528, 537, 539, 547, 564,
	580, 595, 609, 629, 642, 661, 679, 700,
	725, 727, 729, 742, 744, 746, 774, 800,
	814, 826, 833, 839, 844, 847, 849, 850,
	861, 871, 880, 882, 890, 907, 923, 938,
	952, 972, 985, 1004, 1022, 1043, 1068, 1070,
	1072, 1085, 1111, 1137, 1151, 1163, 1170, 1176,
	1181, 1184, 1186, 1187, 1198, 1208, 1217, 1219,
	1227, 1244, 1260, 1275, 1289, 1309, 1322, 1341,
	1359, 1380, 1405, 1407, 1420, 1422, 1424, 1455,
	1481, 1484, 1486, 1488, 1491, 1495,
}

var _useSM_trans_keys []byte = []byte{
	0, 1, 4, 5, 11, 12, 13, 14,
	18, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 35, 37,
	38, 39, 41, 42, 43, 45, 46, 47,
	49, 51, 53, 44, 48, 11, 12, 14,
	22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 37, 38,
	39, 41, 42, 45, 46, 47, 53, 44,
	48, 11, 12, 14, 22, 23, 24, 25,
	26, 27, 28, 29, 30, 33, 34, 35,
	37, 38, 39, 45, 46, 47, 53, 31,
	32, 44, 48, 1, 14, 23, 24, 25,
	26, 37, 38, 39, 45, 46, 47, 48,
	53, 14, 23, 24, 25, 26, 37, 38,
	39, 45, 46, 47, 48, 14, 24, 25,
	26, 45, 46, 47, 14, 25, 26, 45,
	46, 47, 14, 26, 45, 46, 47, 14,
	45, 46, 14, 46, 14, 14, 24, 25,
	26, 37, 38, 39, 45, 46, 47, 48,
	14, 24, 25, 26, 38, 39, 45, 46,
	47, 48, 14, 24, 25, 26, 39, 45,
	46, 47, 48, 1, 14, 14, 24, 25,
	26, 45, 46, 47, 48, 14, 22, 23,
	24, 25, 26, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 48, 53, 14, 23,
	24, 25, 26, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 48, 53, 14, 23,
	24, 25, 26, 34, 35, 37, 38, 39,
	45, 46, 47, 48, 53, 14, 23, 24,
	25, 26, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 12, 14, 22, 23, 24,
	25, 26, 28, 29, 33, 34, 35, 37,
	38, 39, 45, 46, 47, 48, 53, 14,
	23, 24, 25, 26, 37, 38, 39, 45,
	46, 47, 48, 53, 12, 14, 22, 23,
	24, 25, 26, 29, 33, 34, 35, 37,
	38, 39, 45, 46, 47, 48, 53, 12,
	14, 22, 23, 24, 25, 26, 33, 34,
	35, 37, 38, 39, 45, 46, 47, 48,
	53, 12, 14, 22, 23, 24, 25, 26,
	27, 28, 29, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 48, 53, 11, 12,
	14, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 32, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 53, 44, 48, 1,
	14, 1, 14, 23, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 11, 12,
	14, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 31, 32, 33, 34, 35, 37,
	38, 39, 45, 46, 47, 53, 44, 48,
	14, 41, 42, 14, 42, 11, 12, 14,
	22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 37, 38,
	39, 44, 45, 46, 47, 48, 53, 11,
	12, 14, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 33, 34, 35, 37, 38,
	39, 44, 45, 46, 47, 48, 53, 31,
	32, 1, 14, 23, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 53, 14,
	23, 24, 25, 26, 37, 38, 39, 45,
	46, 47, 48, 14, 24, 25, 26, 45,
	46, 47, 14, 25, 26, 45, 46, 47,
	14, 26, 45, 46, 47, 14, 45, 46,
	14, 46, 14, 14, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 14, 24,
	25, 26, 38, 39, 45, 46, 47, 48,
	14, 24, 25, 26, 39, 45, 46, 47,
	48, 1, 14, 14, 24, 25, 26, 45,
	46, 47, 48, 14, 22, 23, 24, 25,
	26, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 14, 23, 24, 25,
	26, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 14, 23, 24, 25,
	26, 34, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 14, 23, 24, 25, 26,
	35, 37, 38, 39, 45, 46, 47, 48,
	53, 12, 14, 22, 23, 24, 25, 26,
	28, 29, 33, 34, 35, 37, 38, 39,
	45, 46, 47, 48, 53, 14, 23, 24,
	25, 26, 37, 38, 39, 45, 46, 47,
	48, 53, 12, 14, 22, 23, 24, 25,
	26, 29, 33, 34, 35, 37, 38, 39,
	45, 46, 47, 48, 53, 12, 14, 22,
	23, 24, 25, 26, 33, 34, 35, 37,
	38, 39, 45, 46, 47, 48, 53, 12,
	14, 22, 23, 24, 25, 26, 27, 28,
	29, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 11, 12, 14, 22,
	23, 24, 25, 26, 27, 28, 29, 30,
	32, 33, 34, 35, 37, 38, 39, 44,
	45, 46, 47, 48, 53, 1, 14, 1,
	14, 1, 14, 23, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 13, 14,
	4, 14, 11, 12, 14, 22, 23, 24,
	25, 26, 27, 28, 29, 30, 31, 32,
	33, 34, 35, 37, 38, 39, 41, 42,
	44, 45, 46, 47, 48, 53, 11, 12,
	14, 22, 23, 24, 25, 26, 27, 28,
	29, 30, 33, 34, 35, 37, 38, 39,
	44, 45, 46, 47, 48, 53, 31, 32,
	1, 14, 23, 24, 25, 26, 37, 38,
	39, 45, 46, 47, 48, 53, 14, 23,
	24, 25, 26, 37, 38, 39, 45, 46,
	47, 48, 14, 24, 25, 26, 45, 46,
	47, 14, 25, 26, 45, 46, 47, 14,
	26, 45, 46, 47, 14, 45, 46, 14,
	46, 14, 14, 24, 25, 26, 37, 38,
	39, 45, 46, 47, 48, 14, 24, 25,
	26, 38, 39, 45, 46, 47, 48, 14,
	24, 25, 26, 39, 45, 46, 47, 48,
	1, 14, 14, 24, 25, 26, 45, 46,
	47, 48, 14, 22, 23, 24, 25, 26,
	33, 34, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 14, 23, 24, 25, 26,
	33, 34, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 14, 23, 24, 25, 26,
	34, 35, 37, 38, 39, 45, 46, 47,
	48, 53, 14, 23, 24, 25, 26, 35,
	37, 38, 39, 45, 46, 47, 48, 53,
	12, 14, 22, 23, 24, 25, 26, 28,
	29, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 14, 23, 24, 25,
	26, 37, 38, 39, 45, 46, 47, 48,
	53, 12, 14, 22, 23, 24, 25, 26,
	29, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 12, 14, 22, 23,
	24, 25, 26, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 48, 53, 12, 14,
	22, 23, 24, 25, 26, 27, 28, 29,
	33, 34, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 11, 12, 14, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 32,
	33, 34, 35, 37, 38, 39, 44, 45,
	46, 47, 48, 53, 1, 14, 1, 14,
	1, 14, 23, 24, 25, 26, 37, 38,
	39, 45, 46, 47, 48, 11, 12, 14,
	22, 23, 24, 25, 26, 27, 28, 29,
	30, 31, 32, 33, 34, 35, 37, 38,
	39, 44, 45, 46, 47, 48, 53, 11,
	12, 14, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 33, 34, 35, 37, 38,
	39, 45, 46, 47, 53, 31, 32, 44,
	48, 1, 14, 23, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 53, 14,
	23, 24, 25, 26, 37, 38, 39, 45,
	46, 47, 48, 14, 24, 25, 26, 45,
	46, 47, 14, 25, 26, 45, 46, 47,
	14, 26, 45, 46, 47, 14, 45, 46,
	14, 46, 14, 14, 24, 25, 26, 37,
	38, 39, 45, 46, 47, 48, 14, 24,
	25, 26, 38, 39, 45, 46, 47, 48,
	14, 24, 25, 26, 39, 45, 46, 47,
	48, 1, 14, 14, 24, 25, 26, 45,
	46, 47, 48, 14, 22, 23, 24, 25,
	26, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 14, 23, 24, 25,
	26, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 14, 23, 24, 25,
	26, 34, 35, 37, 38, 39, 45, 46,
	47, 48, 53, 14, 23, 24, 25, 26,
	35, 37, 38, 39, 45, 46, 47, 48,
	53, 12, 14, 22, 23, 24, 25, 26,
	28, 29, 33, 34, 35, 37, 38, 39,
	45, 46, 47, 48, 53, 14, 23, 24,
	25, 26, 37, 38, 39, 45, 46, 47,
	48, 53, 12, 14, 22, 23, 24, 25,
	26, 29, 33, 34, 35, 37, 38, 39,
	45, 46, 47, 48, 53, 12, 14, 22,
	23, 24, 25, 26, 33, 34, 35, 37,
	38, 39, 45, 46, 47, 48, 53, 12,
	14, 22, 23, 24, 25, 26, 27, 28,
	29, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 48, 53, 11, 12, 14, 22,
	23, 24, 25, 26, 27, 28, 29, 30,
	32, 33, 34, 35, 37, 38, 39, 45,
	46, 47, 53, 44, 48, 1, 14, 1,
	14, 23, 24, 25, 26, 37, 38, 39,
	45, 46, 47, 48, 4, 14, 13, 14,
	1, 5, 11, 12, 13, 14, 22, 23,
	24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 37, 38, 39, 41,
	42, 45, 46, 47, 53, 44, 48, 11,
	12, 14, 22, 23, 24, 25, 26, 27,
	28, 29, 30, 31, 32, 33, 34, 35,
	37, 38, 39, 45, 46, 47, 53, 44,
	48, 14, 41, 42, 14, 42, 1, 5,
	14, 50, 52, 14, 49, 50, 52, 14,
	49, 51,
}

var _useSM_single_lengths []byte = []byte{
	35, 26, 22, 14, 12, 7, 6, 5,
	3, 2, 1, 11, 10, 9, 2, 8,
	17, 16, 15, 14, 20, 13, 19, 18,
	21, 23, 2, 13, 24, 3, 2, 26,
	24, 14, 12, 7, 6, 5, 3, 2,
	1, 11, 10, 9, 2, 8, 17, 16,
	15, 14, 20, 13, 19, 18, 21, 25,
	2, 2, 13, 2, 2, 28, 24, 14,
	12, 7, 6, 5, 3, 2, 1, 11,
	10, 9, 2, 8, 17, 16, 15, 14,
	20, 13, 19, 18, 21, 25, 2, 2,
	13, 26, 22, 14, 12, 7, 6, 5,
	3, 2, 1, 11, 10, 9, 2, 8,
	17, 16, 15, 14, 20, 13, 19, 18,
	21, 23, 2, 13, 2, 2, 29, 24,
	3, 2, 2, 3, 4, 3,
}

var _useSM_range_lengths []byte = []byte{
	1, 1, 2, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 0, 0, 1, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 1, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 2, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 1, 0, 0, 0, 0, 1, 1,
	0, 0, 0, 0, 0, 0,
}

var _useSM_index_offsets []int16 = []int16{
	0, 37, 65, 90, 105, 118, 126, 133,
	139, 143, 146, 148, 160, 171, 181, 184,
	193, 211, 228, 244, 259, 280, 294, 314,
	333, 355, 380, 383, 397, 423, 427, 430,
	457, 483, 498, 511, 519, 526, 532, 536,
	539, 541, 553, 564, 574, 577, 586, 604,
	621, 637, 652, 673, 687, 707, 726, 748,
	774, 777, 780, 794, 797, 800, 829, 855,
	870, 883, 891, 898, 904, 908, 911, 913,
	925, 936, 946, 949, 958, 976, 993, 1009,
	1024, 1045, 1059, 1079, 1098, 1120, 1146, 1149,
	1152, 1166, 1193, 1218, 1233, 1246, 1254, 1261,
	1267, 1271, 1274, 1276, 1288, 1299, 1309, 1312,
	1321, 1339, 1356, 1372, 1387, 1408, 1422, 1442,
	1461, 1483, 1508, 1511, 1525, 1528, 1531, 1562,
	1588, 1592, 1595, 1598, 1602, 1607,
}

var _useSM_indicies []byte = []byte{
	0, 1, 3, 4, 5, 6, 7, 8,
	9, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24,
	25, 26, 27, 28, 29, 31, 32, 33,
	34, 35, 36, 30, 2, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 58, 59, 61, 62, 63, 64, 60,
	37, 38, 39, 40, 41, 42, 43, 44,
	45, 46, 47, 48, 49, 52, 53, 54,
	55, 56, 57, 61, 62, 63, 64, 51,
	60, 37, 38, 40, 42, 43, 44, 45,
	55, 56, 57, 61, 62, 63, 65, 42,
	37, 40, 42, 43, 44, 45, 55, 56,
	57, 61, 62, 63, 65, 37, 40, 43,
	44, 45, 61, 62, 63, 37, 40, 44,
	45, 61, 62, 63, 37, 40, 45, 61,
	62, 63, 37, 40, 61, 62, 37, 40,
	62, 37, 40, 37, 40, 43, 44, 45,
	55, 56, 57, 61, 62, 63, 65, 37,
	40, 43, 44, 45, 56, 57, 61, 62,
	63, 65, 37, 40, 43, 44, 45, 57,
	61, 62, 63, 65, 37, 66, 40, 37,
	40, 43, 44, 45, 61, 62, 63, 65,
	37, 40, 41, 42, 43, 44, 45, 52,
	53, 54, 55, 56, 57, 61, 62, 63,
	65, 42, 37, 40, 42, 43, 44, 45,
	52, 53, 54, 55, 56, 57, 61, 62,
	63, 65, 42, 37, 40, 42, 43, 44,
	45, 53, 54, 55, 56, 57, 61, 62,
	63, 65, 42, 37, 40, 42, 43, 44,
	45, 54, 55, 56, 57, 61, 62, 63,
	65, 42, 37, 67, 40, 41, 42, 43,
	44, 45, 47, 48, 52, 53, 54, 55,
	56, 57, 61, 62, 63, 65, 42, 37,
	40, 42, 43, 44, 45, 55, 56, 57,
	61, 62, 63, 65, 42, 37, 67, 40,
	41, 42, 43, 44, 45, 48, 52, 53,
	54, 55, 56, 57, 61, 62, 63, 65,
	42, 37, 67, 40, 41, 42, 43, 44,
	45, 52, 53, 54, 55, 56, 57, 61,
	62, 63, 65, 42, 37, 67, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 52,
	53, 54, 55, 56, 57, 61, 62, 63,
	65, 42, 37, 38, 39, 40, 41, 42,
	43, 44, 45, 46, 47, 48, 49, 51,
	52, 53, 54, 55, 56, 57, 61, 62,
	63, 64, 60, 37, 38, 40, 37, 38,
	40, 42, 43, 44, 45, 55, 56, 57,
	61, 62, 63, 65, 37, 38, 39, 40,
	41, 42, 43, 44, 45, 46, 47, 48,
	49, 50, 51, 52, 53, 54, 55, 56,
	57, 61, 62, 63, 64, 60, 37, 40,
	58, 59, 37, 40, 59, 37, 69, 70,
	71, 72, 73, 74, 75, 76, 77, 78,
	79, 80, 1, 81, 82, 83, 84, 85,
	86, 87, 88, 89, 90, 91, 92, 93,
	68, 69, 70, 71, 72, 73, 74, 75,
	76, 77, 78, 79, 80, 82, 83, 84,
	85, 86, 87, 88, 89, 90, 91, 92,
	93, 81, 68, 69, 71, 73, 74, 75,
	76, 85, 86, 87, 89, 90, 91, 94,
	73, 68, 71, 73, 74, 75, 76, 85,
	86, 87, 89, 90, 91, 94, 68, 71,
	74, 75, 76, 89, 90, 91, 68, 71,
	75, 76, 89, 90, 91, 68, 71, 76,
	89, 90, 91, 68, 71, 89, 90, 68,
	71, 90, 68, 71, 68, 71, 74, 75,
	76, 85, 86, 87, 89, 90, 91, 94,
	68, 71, 74, 75, 76, 86, 87, 89,
	90, 91, 94, 68, 71, 74, 75, 76,
	87, 89, 90, 91, 94, 68, 96, 97,
	95, 71, 74, 75, 76, 89, 90, 91,
	94, 68, 71, 72, 73, 74, 75, 76,
	82, 83, 84, 85, 86, 87, 89, 90,
	91, 94, 73, 68, 71, 73, 74, 75,
	76, 82, 83, 84, 85, 86, 87, 89,
	90, 91, 94, 73, 68, 71, 73, 74,
	75, 76, 83, 84, 85, 86, 87, 89,
	90, 91, 94, 73, 68, 71, 73, 74,
	75, 76, 84, 85, 86, 87, 89, 90,
	91, 94, 73, 68, 98, 71, 72, 73,
	74, 75, 76, 78, 79, 82, 83, 84,
	85, 86, 87, 89, 90, 91, 94, 73,
	68, 71, 73, 74, 75, 76, 85, 86,
	87, 89, 90, 91, 94, 73, 68, 98,
	71, 72, 73, 74, 75, 76, 79, 82,
	83, 84, 85, 86, 87, 89, 90, 91,
	94, 73, 68, 98, 71, 72, 73, 74,
	75, 76, 82, 83, 84, 85, 86, 87,
	89, 90, 91, 94, 73, 68, 98, 71,
	72, 73, 74, 75, 76, 77, 78, 79,
	82, 83, 84, 85, 86, 87, 89, 90,
	91, 94, 73, 68, 69, 70, 71, 72,
	73, 74, 75, 76, 77, 78, 79, 80,
	81, 82, 83, 84, 85, 86, 87, 88,
	89, 90, 91, 92, 93, 68, 69, 100,
	99, 69, 97, 95, 69, 71, 73, 74,
	75, 76, 85, 86, 87, 89, 90, 91,
	94, 68, 102, 103, 101, 3, 105, 104,
	106, 107, 71, 108, 109, 110, 111, 112,
	113, 114, 115, 116, 117, 118, 119, 120,
	121, 122, 123, 124, 58, 59, 125, 126,
	127, 128, 129, 130, 68, 106, 107, 71,
	108, 109, 110, 111, 112, 113, 114, 115,
	116, 119, 120, 121, 122, 123, 124, 125,
	126, 127, 128, 129, 130, 118, 68, 106,
	71, 109, 110, 111, 112, 122, 123, 124,
	126, 127, 128, 131, 109, 68, 71, 109,
	110, 111, 112, 122, 123, 124, 126, 127,
	128, 131, 68, 71, 110, 111, 112, 126,
	127, 128, 68, 71, 111, 112, 126, 127,
	128, 68, 71, 112, 126, 127, 128, 68,
	71, 126, 127, 68, 71, 127, 68, 71,
	68, 71, 110, 111, 112, 122, 123, 124,
	126, 127, 128, 131, 68, 71, 110, 111,
	112, 123, 124, 126, 127, 128, 131, 68,
	71, 110, 111, 112, 124, 126, 127, 128,
	131, 68, 132, 97, 95, 71, 110, 111,
	112, 126, 127, 128, 131, 68, 71, 108,
	109, 110, 111, 112, 119, 120, 121, 122,
	123, 124, 126, 127, 128, 131, 109, 68,
	71, 109, 110, 111, 112, 119, 120, 121,
	122, 123, 124, 126, 127, 128, 131, 109,
	68, 71, 109, 110, 111, 112, 120, 121,
	122, 123, 124, 126, 127, 128, 131, 109,
	68, 71, 109, 110, 111, 112, 121, 122,
	123, 124, 126, 127, 128, 131, 109, 68,
	133, 71, 108, 109, 110, 111, 112, 114,
	115, 119, 120, 121, 122, 123, 124, 126,
	127, 128, 131, 109, 68, 71, 109, 110,
	111, 112, 122, 123, 124, 126, 127, 128,
	131, 109, 68, 133, 71, 108, 109, 110,
	111, 112, 115, 119, 120, 121, 122, 123,
	124, 126, 127, 128, 131, 109, 68, 133,
	71, 108, 109, 110, 111, 112, 119, 120,
	121, 122, 123, 124, 126, 127, 128, 131,
	109, 68, 133, 71, 108, 109, 110, 111,
	112, 113, 114, 115, 119, 120, 121, 122,
	123, 124, 126, 127, 128, 131, 109, 68,
	106, 107, 71, 108, 109, 110, 111, 112,
	113, 114, 115, 116, 118, 119, 120, 121,
	122, 123, 124, 125, 126, 127, 128, 129,
	130, 68, 106, 100, 99, 106, 97, 95,
	106, 71, 109, 110, 111, 112, 122, 123,
	124, 126, 127, 128, 131, 68, 106, 107,
	71, 108, 109, 110, 111, 112, 113, 114,
	115, 116, 117, 118, 119, 120, 121, 122,
	123, 124, 125, 126, 127, 128, 129, 130,
	68, 5, 6, 8, 10, 11, 12, 13,
	14, 15, 16, 17, 18, 21, 22, 23,
	24, 25, 26, 31, 32, 33, 36, 20,
	30, 134, 5, 8, 11, 12, 13, 14,
	24, 25, 26, 31, 32, 33, 135, 11,
	134, 8, 11, 12, 13, 14, 24, 25,
	26, 31, 32, 33, 135, 134, 8, 12,
	13, 14, 31, 32, 33, 134, 8, 13,
	14, 31, 32, 33, 134, 8, 14, 31,
	32, 33, 134, 8, 31, 32, 134, 8,
	32, 134, 8, 134, 8, 12, 13, 14,
	24, 25, 26, 31, 32, 33, 135, 134,
	8, 12, 13, 14, 25, 26, 31, 32,
	33, 135, 134, 8, 12, 13, 14, 26,
	31, 32, 33, 135, 134, 136, 8, 134,
	8, 12, 13, 14, 31, 32, 33, 135,
	134, 8, 10, 11, 12, 13, 14, 21,
	22, 23, 24, 25, 26, 31, 32, 33,
	135, 11, 134, 8, 11, 12, 13, 14,
	21, 22, 23, 24, 25, 26, 31, 32,
	33, 135, 11, 134, 8, 11, 12, 13,
	14, 22, 23, 24, 25, 26, 31, 32,
	33, 135, 11, 134, 8, 11, 12, 13,
	14, 23, 24, 25, 26, 31, 32, 33,
	135, 11, 134, 137, 8, 10, 11, 12,
	13, 14, 16, 17, 21, 22, 23, 24,
	25, 26, 31, 32, 33, 135, 11, 134,
	8, 11, 12, 13, 14, 24, 25, 26,
	31, 32, 33, 135, 11, 134, 137, 8,
	10, 11, 12, 13, 14, 17, 21, 22,
	23, 24, 25, 26, 31, 32, 33, 135,
	11, 134, 137, 8, 10, 11, 12, 13,
	14, 21, 22, 23, 24, 25, 26, 31,
	32, 33, 135, 11, 134, 137, 8, 10,
	11, 12, 13, 14, 15, 16, 17, 21,
	22, 23, 24, 25, 26, 31, 32, 33,
	135, 11, 134, 5, 6, 8, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 20,
	21, 22, 23, 24, 25, 26, 31, 32,
	33, 36, 30, 134, 5, 8, 134, 5,
	8, 11, 12, 13, 14, 24, 25, 26,
	31, 32, 33, 135, 134, 138, 8, 134,
	7, 8, 134, 1, 1, 5, 6, 7,
	8, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24,
	25, 26, 27, 28, 31, 32, 33, 36,
	30, 134, 5, 6, 8, 10, 11, 12,
	13, 14, 15, 16, 17, 18, 19, 20,
	21, 22, 23, 24, 25, 26, 31, 32,
	33, 36, 30, 134, 8, 27, 28, 134,
	8, 28, 134, 1, 1, 139, 141, 142,
	34, 140, 141, 34, 142, 142, 140, 141,
	34, 35, 140,
}

var _useSM_trans_targs []byte = []byte{
	1, 31, 0, 59, 61, 90, 91, 116,
	0, 118, 104, 92, 93, 94, 95, 108,
	110, 111, 112, 119, 113, 105, 106, 107,
	99, 100, 101, 120, 121, 122, 114, 96,
	97, 98, 123, 125, 115, 0, 2, 3,
	0, 16, 4, 5, 6, 7, 20, 22,
	23, 24, 28, 25, 17, 18, 19, 11,
	12, 13, 29, 30, 26, 8, 9, 10,
	27, 14, 15, 21, 0, 32, 33, 0,
	46, 34, 35, 36, 37, 50, 52, 53,
	54, 55, 47, 48, 49, 41, 42, 43,
	56, 38, 39, 40, 57, 58, 44, 0,
	45, 0, 51, 0, 0, 0, 60, 0,
	0, 0, 62, 63, 76, 64, 65, 66,
	67, 80, 82, 83, 84, 89, 85, 77,
	78, 79, 71, 72, 73, 86, 68, 69,
	70, 87, 88, 74, 75, 81, 0, 102,
	103, 109, 117, 0, 0, 0, 124,
}

var _useSM_trans_actions []byte = []byte{
	0, 0, 21, 0, 0, 0, 0, 0,
	19, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 33, 0, 0,
	15, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 27, 0, 0, 9,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 25,
	0, 7, 0, 23, 5, 31, 0, 13,
	29, 11, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 37, 0,
	0, 0, 0, 39, 35, 17, 0,
}

var _useSM_to_state_actions []byte = []byte{
	1, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
}

var _useSM_from_state_actions []byte = []byte{
	3, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0,
}

var _useSM_eof_trans []int16 = []int16{
	0, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 38,
	38, 38, 38, 38, 38, 38, 38, 69,
	69, 69, 69, 69, 69, 69, 69, 69,
	69, 69, 69, 69, 96, 69, 69, 69,
	69, 69, 69, 69, 69, 69, 69, 69,
	100, 96, 69, 102, 105, 69, 69, 69,
	69, 69, 69, 69, 69, 69, 69, 69,
	69, 69, 96, 69, 69, 69, 69, 69,
	69, 69, 69, 69, 69, 69, 100, 96,
	69, 69, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 135, 135, 135, 135, 135, 135,
	135, 135, 140, 141, 141, 141,
}

const useSM_start int = 0
const useSM_first_final int = 0
const useSM_error int = -1

const useSM_en_main int = 0

func findSyllablesUse(buffer *Buffer) {
	info := buffer.Info
	data := preprocessInfoUSE(info)
	p, pe := 0, len(data)
	eof := pe
	var cs, act, ts, te int

	{
		cs = useSM_start
		ts = 0
		te = 0
		act = 0
	}

	var syllableSerial uint8 = 1

	{
		var _klen int
		var _trans int
		var _acts int
		var _nacts uint
		var _keys int
		if p == pe {
			goto _test_eof
		}
	_resume:
		_acts = int(_useSM_from_state_actions[cs])
		_nacts = uint(_useSM_actions[_acts])
		_acts++
		for ; _nacts > 0; _nacts-- {
			_acts++
			switch _useSM_actions[_acts-1] {
			case 1:
				ts = p

			}
		}

		_keys = int(_useSM_key_offsets[cs])
		_trans = int(_useSM_index_offsets[cs])

		_klen = int(_useSM_single_lengths[cs])
		if _klen > 0 {
			_lower := int(_keys)
			var _mid int
			_upper := int(_keys + _klen - 1)
			for {
				if _upper < _lower {
					break
				}

				_mid = _lower + ((_upper - _lower) >> 1)
				switch {
				case ((data[p]).p.v.complexCategory) < _useSM_trans_keys[_mid]:
					_upper = _mid - 1
				case ((data[p]).p.v.complexCategory) > _useSM_trans_keys[_mid]:
					_lower = _mid + 1
				default:
					_trans += int(_mid - int(_keys))
					goto _match
				}
			}
			_keys += _klen
			_trans += _klen
		}

		_klen = int(_useSM_range_lengths[cs])
		if _klen > 0 {
			_lower := int(_keys)
			var _mid int
			_upper := int(_keys + (_klen << 1) - 2)
			for {
				if _upper < _lower {
					break
				}

				_mid = _lower + (((_upper - _lower) >> 1) & ^1)
				switch {
				case ((data[p]).p.v.complexCategory) < _useSM_trans_keys[_mid]:
					_upper = _mid - 2
				case ((data[p]).p.v.complexCategory) > _useSM_trans_keys[_mid+1]:
					_lower = _mid + 2
				default:
					_trans += int((_mid - int(_keys)) >> 1)
					goto _match
				}
			}
			_trans += _klen
		}

	_match:
		_trans = int(_useSM_indicies[_trans])
	_eof_trans:
		cs = int(_useSM_trans_targs[_trans])

		if _useSM_trans_actions[_trans] == 0 {
			goto _again
		}

		_acts = int(_useSM_trans_actions[_trans])
		_nacts = uint(_useSM_actions[_acts])
		_acts++
		for ; _nacts > 0; _nacts-- {
			_acts++
			switch _useSM_actions[_acts-1] {
			case 2:
				te = p + 1
				{
					foundSyllableUSE(useViramaTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 3:
				te = p + 1
				{
					foundSyllableUSE(useSakotTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 4:
				te = p + 1
				{
					foundSyllableUSE(useStandardCluster, data, ts, te, info, &syllableSerial)
				}
			case 5:
				te = p + 1
				{
					foundSyllableUSE(useNumberJoinerTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 6:
				te = p + 1
				{
					foundSyllableUSE(useNumeralCluster, data, ts, te, info, &syllableSerial)
				}
			case 7:
				te = p + 1
				{
					foundSyllableUSE(useSymbolCluster, data, ts, te, info, &syllableSerial)
				}
			case 8:
				te = p + 1
				{
					foundSyllableUSE(useHieroglyphCluster, data, ts, te, info, &syllableSerial)
				}
			case 9:
				te = p + 1
				{
					foundSyllableUSE(useBrokenCluster, data, ts, te, info, &syllableSerial)
					buffer.scratchFlags |= bsfHasBrokenSyllable
				}
			case 10:
				te = p + 1
				{
					foundSyllableUSE(useNonCluster, data, ts, te, info, &syllableSerial)
				}
			case 11:
				te = p
				p--
				{
					foundSyllableUSE(useViramaTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 12:
				te = p
				p--
				{
					foundSyllableUSE(useSakotTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 13:
				te = p
				p--
				{
					foundSyllableUSE(useStandardCluster, data, ts, te, info, &syllableSerial)
				}
			case 14:
				te = p
				p--
				{
					foundSyllableUSE(useNumberJoinerTerminatedCluster, data, ts, te, info, &syllableSerial)
				}
			case 15:
				te = p
				p--
				{
					foundSyllableUSE(useNumeralCluster, data, ts, te, info, &syllableSerial)
				}
			case 16:
				te = p
				p--
				{
					foundSyllableUSE(useSymbolCluster, data, ts, te, info, &syllableSerial)
				}
			case 17:
				te = p
				p--
				{
					foundSyllableUSE(useHieroglyphCluster, data, ts, te, info, &syllableSerial)
				}
			case 18:
				te = p
				p--
				{
					foundSyllableUSE(useBrokenCluster, data, ts, te, info, &syllableSerial)
					buffer.scratchFlags |= bsfHasBrokenSyllable
				}
			case 19:
				te = p
				p--
				{
					foundSyllableUSE(useNonCluster, data, ts, te, info, &syllableSerial)
				}
			}
		}

	_again:
		_acts = int(_useSM_to_state_actions[cs])
		_nacts = uint(_useSM_actions[_acts])
		_acts++
		for ; _nacts > 0; _nacts-- {
			_acts++
			switch _useSM_actions[_acts-1] {
			case 0:
				ts = 0

			}
		}

		p++
		if p != pe {
			goto _resume
		}
	_test_eof:
		{
		}
		if p == eof {
			if _useSM_eof_trans[cs] > 0 {
				_trans = int(_useSM_eof_trans[cs] - 1)
				goto _eof_trans
			}
		}

	}

	_ = act // needed by Ragel, but unused
}
