# Contributing to Colima

Thank you for your interest in contributing to Colima!

## Getting Started

Colima is a Go project. To contribute, you will need Go installed (see the [Go installation guide](https://golang.org/doc/install)).

### 1. Fork the Repository

First, fork the Colima repository on GitHub. Then, clone your fork locally:

```sh
git clone https://github.com/<your-username>/colima.git
cd colima
```

### 2. Create a New Branch

Create a new branch for your changes:

```sh
git checkout -b my-feature-branch
```

### 3. Commit Your Changes

Commit your changes with a DCO signoff and the required commit message format. Each commit must include a signoff line:

```
Signed-off-by: Your Name <your.email@example.com>
```

You can add this automatically with:

```sh
git commit -s -m "component: <message>"
# Example:
git commit -s -m "cli: add my-command to colima start"
```

### 4. Push Your Branch

Push your branch to your fork:

```sh
git push origin my-feature-branch
```

### 5. Open a Pull Request

Open a Pull Request against the main Colima repository.

## 6. DCO Signoff

Colima requires all commits to be signed off using the [Developer Certificate of Origin (DCO)](https://developercertificate.org/). This is a simple statement that you, as a contributor, have the right to submit your changes.

## Contribution Guidelines

### Major Contributions
Major contributions (new features, significant changes) should be preceded by a GitHub issue discussing the proposed change.

### Minor Contributions
Minor contributions (small fixes, documentation e.t.c.) do not require a prior issue.

### LLM Usage Disclosure
If you use a Large Language Model (LLM) to generate code, you must fully disclose its usage in your pull request, including which parts were generated and to what extent.

### LLM Reviewability
Large code contributions generated by LLMs that are not easily reviewable or understandable will be rejected.

## Reviewing and Merging

All PRs are subject to review.

Kindly ensure that your PR passes all CI checks. You are also obliged to respond to review comments and update your PR as needed.

## Need Help?

If you have questions, open an [issue](https://github.com/abiosoft/colima/issues) or start a [discussion](https://github.com/abiosoft/colima/discussions) in the repository.

---

Thank you for helping to improve Colima!
