//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/testbase/armtestbase"
	"net/http"
	"net/url"
	"regexp"
)

// PackagesServer is a fake server for instances of the armtestbase.PackagesClient type.
type PackagesServer struct {
	// BeginCreate is the fake for method PackagesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, parameters armtestbase.PackageResource, options *armtestbase.PackagesClientBeginCreateOptions) (resp azfake.PollerResponder[armtestbase.PackagesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PackagesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *armtestbase.PackagesClientBeginDeleteOptions) (resp azfake.PollerResponder[armtestbase.PackagesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PackagesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *armtestbase.PackagesClientGetOptions) (resp azfake.Responder[armtestbase.PackagesClientGetResponse], errResp azfake.ErrorResponder)

	// GetDownloadURL is the fake for method PackagesClient.GetDownloadURL
	// HTTP status codes to indicate success: http.StatusOK
	GetDownloadURL func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *armtestbase.PackagesClientGetDownloadURLOptions) (resp azfake.Responder[armtestbase.PackagesClientGetDownloadURLResponse], errResp azfake.ErrorResponder)

	// BeginHardDelete is the fake for method PackagesClient.BeginHardDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginHardDelete func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, options *armtestbase.PackagesClientBeginHardDeleteOptions) (resp azfake.PollerResponder[armtestbase.PackagesClientHardDeleteResponse], errResp azfake.ErrorResponder)

	// NewListByTestBaseAccountPager is the fake for method PackagesClient.NewListByTestBaseAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTestBaseAccountPager func(resourceGroupName string, testBaseAccountName string, options *armtestbase.PackagesClientListByTestBaseAccountOptions) (resp azfake.PagerResponder[armtestbase.PackagesClientListByTestBaseAccountResponse])

	// BeginUpdate is the fake for method PackagesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, testBaseAccountName string, packageName string, parameters armtestbase.PackageUpdateParameters, options *armtestbase.PackagesClientBeginUpdateOptions) (resp azfake.PollerResponder[armtestbase.PackagesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewPackagesServerTransport creates a new instance of PackagesServerTransport with the provided implementation.
// The returned PackagesServerTransport instance is connected to an instance of armtestbase.PackagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPackagesServerTransport(srv *PackagesServer) *PackagesServerTransport {
	return &PackagesServerTransport{
		srv:                           srv,
		beginCreate:                   newTracker[azfake.PollerResponder[armtestbase.PackagesClientCreateResponse]](),
		beginDelete:                   newTracker[azfake.PollerResponder[armtestbase.PackagesClientDeleteResponse]](),
		beginHardDelete:               newTracker[azfake.PollerResponder[armtestbase.PackagesClientHardDeleteResponse]](),
		newListByTestBaseAccountPager: newTracker[azfake.PagerResponder[armtestbase.PackagesClientListByTestBaseAccountResponse]](),
		beginUpdate:                   newTracker[azfake.PollerResponder[armtestbase.PackagesClientUpdateResponse]](),
	}
}

// PackagesServerTransport connects instances of armtestbase.PackagesClient to instances of PackagesServer.
// Don't use this type directly, use NewPackagesServerTransport instead.
type PackagesServerTransport struct {
	srv                           *PackagesServer
	beginCreate                   *tracker[azfake.PollerResponder[armtestbase.PackagesClientCreateResponse]]
	beginDelete                   *tracker[azfake.PollerResponder[armtestbase.PackagesClientDeleteResponse]]
	beginHardDelete               *tracker[azfake.PollerResponder[armtestbase.PackagesClientHardDeleteResponse]]
	newListByTestBaseAccountPager *tracker[azfake.PagerResponder[armtestbase.PackagesClientListByTestBaseAccountResponse]]
	beginUpdate                   *tracker[azfake.PollerResponder[armtestbase.PackagesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for PackagesServerTransport.
func (p *PackagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PackagesClient.BeginCreate":
		resp, err = p.dispatchBeginCreate(req)
	case "PackagesClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PackagesClient.Get":
		resp, err = p.dispatchGet(req)
	case "PackagesClient.GetDownloadURL":
		resp, err = p.dispatchGetDownloadURL(req)
	case "PackagesClient.BeginHardDelete":
		resp, err = p.dispatchBeginHardDelete(req)
	case "PackagesClient.NewListByTestBaseAccountPager":
		resp, err = p.dispatchNewListByTestBaseAccountPager(req)
	case "PackagesClient.BeginUpdate":
		resp, err = p.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PackagesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := p.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armtestbase.PackageResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreate(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		p.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		p.beginCreate.remove(req)
	}

	return resp, nil
}

func (p *PackagesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PackagesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PackageResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PackagesServerTransport) dispatchGetDownloadURL(req *http.Request) (*http.Response, error) {
	if p.srv.GetDownloadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDownloadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDownloadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
	if err != nil {
		return nil, err
	}
	packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetDownloadURL(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DownloadURLResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PackagesServerTransport) dispatchBeginHardDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginHardDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginHardDelete not implemented")}
	}
	beginHardDelete := p.beginHardDelete.get(req)
	if beginHardDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hardDelete`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginHardDelete(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginHardDelete = &respr
		p.beginHardDelete.add(req, beginHardDelete)
	}

	resp, err := server.PollerResponderNext(beginHardDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginHardDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginHardDelete) {
		p.beginHardDelete.remove(req)
	}

	return resp, nil
}

func (p *PackagesServerTransport) dispatchNewListByTestBaseAccountPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByTestBaseAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTestBaseAccountPager not implemented")}
	}
	newListByTestBaseAccountPager := p.newListByTestBaseAccountPager.get(req)
	if newListByTestBaseAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByTestBaseAccountPager(resourceGroupNameParam, testBaseAccountNameParam, nil)
		newListByTestBaseAccountPager = &resp
		p.newListByTestBaseAccountPager.add(req, newListByTestBaseAccountPager)
		server.PagerResponderInjectNextLinks(newListByTestBaseAccountPager, req, func(page *armtestbase.PackagesClientListByTestBaseAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTestBaseAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByTestBaseAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTestBaseAccountPager) {
		p.newListByTestBaseAccountPager.remove(req)
	}
	return resp, nil
}

func (p *PackagesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := p.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TestBase/testBaseAccounts/(?P<testBaseAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/packages/(?P<packageName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armtestbase.PackageUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		testBaseAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("testBaseAccountName")])
		if err != nil {
			return nil, err
		}
		packageNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("packageName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginUpdate(req.Context(), resourceGroupNameParam, testBaseAccountNameParam, packageNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		p.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		p.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		p.beginUpdate.remove(req)
	}

	return resp, nil
}
