//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient contains the methods for the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettings group.
// Don't use this type directly, use NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient() instead.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient creates a new instance of WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get workspace managed sql server's minimal tls settings.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - dedicatedSQLminimalTLSSettingsName - The name of the dedicated sql minimal tls settings.
//   - options - WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetOptions contains the optional parameters for
//     the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.Get method.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, dedicatedSQLminimalTLSSettingsName string, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetOptions) (WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse, error) {
	var err error
	const operationName = "WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, workspaceName, dedicatedSQLminimalTLSSettingsName, options)
	if err != nil {
		return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) getCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, dedicatedSQLminimalTLSSettingsName string, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if dedicatedSQLminimalTLSSettingsName == "" {
		return nil, errors.New("parameter dedicatedSQLminimalTLSSettingsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dedicatedSQLminimalTlsSettingsName}", url.PathEscape(dedicatedSQLminimalTLSSettingsName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) getHandleResponse(resp *http.Response) (WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse, error) {
	result := WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DedicatedSQLminimalTLSSettings); err != nil {
		return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List workspace managed sql server's minimal tls settings.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - options - WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListOptions contains the optional parameters for
//     the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.NewListPager method.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) NewListPager(resourceGroupName string, workspaceName string, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListOptions) *runtime.Pager[WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse]{
		More: func(page WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse) (WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, workspaceName, options)
			}, nil)
			if err != nil {
				return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) listCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) listHandleResponse(resp *http.Response) (WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse, error) {
	result := WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DedicatedSQLminimalTLSSettingsListResult); err != nil {
		return WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Update workspace managed sql server's minimal tls settings.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - workspaceName - The name of the workspace.
//   - dedicatedSQLminimalTLSSettingsName - The name of the dedicated sql minimal tls settings.
//   - parameters - minimal tls settings
//   - options - WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions contains the optional parameters
//     for the WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.BeginUpdate method.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) BeginUpdate(ctx context.Context, resourceGroupName string, workspaceName string, dedicatedSQLminimalTLSSettingsName DedicatedSQLMinimalTLSSettingsName, parameters DedicatedSQLminimalTLSSettings, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions) (*runtime.Poller[WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, workspaceName, dedicatedSQLminimalTLSSettingsName, parameters, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update workspace managed sql server's minimal tls settings.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-06-01
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) update(ctx context.Context, resourceGroupName string, workspaceName string, dedicatedSQLminimalTLSSettingsName DedicatedSQLMinimalTLSSettingsName, parameters DedicatedSQLminimalTLSSettings, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, workspaceName, dedicatedSQLminimalTLSSettingsName, parameters, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, dedicatedSQLminimalTLSSettingsName DedicatedSQLMinimalTLSSettingsName, parameters DedicatedSQLminimalTLSSettings, options *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/dedicatedSQLminimalTlsSettings/{dedicatedSQLminimalTlsSettingsName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if dedicatedSQLminimalTLSSettingsName == "" {
		return nil, errors.New("parameter dedicatedSQLminimalTLSSettingsName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dedicatedSQLminimalTlsSettingsName}", url.PathEscape(string(dedicatedSQLminimalTLSSettingsName)))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-06-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}
