//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CheckNameAvailabilityWorkspaceAlreadyExists.json
func ExampleOperationsClient_CheckNameAvailability_checkForAWorkspaceNameThatAlreadyExists() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().CheckNameAvailability(ctx, armsynapse.CheckNameAvailabilityRequest{
		Name: to.Ptr("workspace1"),
		Type: to.Ptr("Microsoft.Synapse/workspaces"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armsynapse.CheckNameAvailabilityResponse{
	// 	Name: to.Ptr("workspace1"),
	// 	Available: to.Ptr(false),
	// 	Message: to.Ptr("Specified workspace name is already used"),
	// 	Reason: to.Ptr("AlreadyExists"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/CheckNameAvailabilityWorkspaceAvailable.json
func ExampleOperationsClient_CheckNameAvailability_checkForAWorkspaceNameThatIsAvailable() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().CheckNameAvailability(ctx, armsynapse.CheckNameAvailabilityRequest{
		Name: to.Ptr("workspace1"),
		Type: to.Ptr("Microsoft.ProjectArcadia/workspaces"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armsynapse.CheckNameAvailabilityResponse{
	// 	Name: to.Ptr("workspace1"),
	// 	Available: to.Ptr(true),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetAvailableOperations.json
func ExampleOperationsClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().List(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AvailableRpOperationArray = []*armsynapse.AvailableRpOperation{
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get any Integration Runtime."),
	// 			Operation: to.Ptr("Get Integration Runtime Operation result."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/managedIdentitySqlControlSettings/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Update Managed Identity SQL Control Settings on the workspace"),
	// 			Operation: to.Ptr("Update Managed Identity SQL Control Settings"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Managed Identity SQL Control Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/managedIdentitySqlControlSettings/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get Managed Identity SQL Control Settings"),
	// 			Operation: to.Ptr("Get Managed Identity SQL Control Settings"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Managed Identity SQL Control Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/operations/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read Available Operations from the Analytics 365 Resource Provider."),
	// 			Operation: to.Ptr("Read Available Operations."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Available Operations"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/nodes/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get any Integration Runtime Node."),
	// 			Operation: to.Ptr("Get Integration Runtime Node."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/nodes/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any Integration Runtime Node."),
	// 			Operation: to.Ptr("Delete Integration Runtime Node."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/nodes/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Patch any Integration Runtime Node."),
	// 			Operation: to.Ptr("Patch Integration Runtime Node."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/nodes/ipAddress/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get Integration Runtime Ip Address"),
	// 			Operation: to.Ptr("Get Integration Runtime Ip Address"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationruntimes/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any Integration Runtimes."),
	// 			Operation: to.Ptr("Create or Update Integration Runtimes."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any Integration Runtime"),
	// 			Operation: to.Ptr("Delete Integration Runtimes"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/getStatus/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get any Integration Runtime's Status"),
	// 			Operation: to.Ptr("Get an Integration Runtime Status"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/start/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Start any Integration Runtime"),
	// 			Operation: to.Ptr("Start an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/stop/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Stop any Integration Runtime"),
	// 			Operation: to.Ptr("Stop an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/getConnectionInfo/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get Connection Info of any Integration Runtime"),
	// 			Operation: to.Ptr("Get Connection Info of an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/regenerateAuthKey/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Regenerate auth key of any Integration Runtime"),
	// 			Operation: to.Ptr("Regenerate auth key of an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/listAuthKeys/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("List Auth Keys of any Integration Runtime"),
	// 			Operation: to.Ptr("List Auth Keys of an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/removeNode/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Remove any Integration Runtime node"),
	// 			Operation: to.Ptr("Remove an Integration Runtime node"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/monitoringData/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get any Integration Runtime's monitoring data"),
	// 			Operation: to.Ptr("Get an Integration Runtime's monitoring data"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/syncCredentials/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Sync credential on any Integration Runtime"),
	// 			Operation: to.Ptr("Sync credential on an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/upgrade/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Upgrade any Integration Runtime"),
	// 			Operation: to.Ptr("Upgrade an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/removeLinks/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Remove any Integration Runtime link"),
	// 			Operation: to.Ptr("Remove an Integration Runtime link"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/enableInteractiveQuery/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Enable Interactive query on any Integration Runtime"),
	// 			Operation: to.Ptr("Enable Interactive query on an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/disableInteractiveQuery/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Disable Interactive query on any Integration Runtime"),
	// 			Operation: to.Ptr("Disable Interactive query on an Integration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/refreshObjectMetadata/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Refresh Object metadata on any Intergration Runtime"),
	// 			Operation: to.Ptr("Refresh Object metadata on an Intergration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/integrationRuntimes/getObjectMetadata/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get Object metadata on any Intergration Runtime"),
	// 			Operation: to.Ptr("Get Object metadata on an Intergration Runtime"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Integration Runtimes."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/firewallRules/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or update any IP Firewall Rule."),
	// 			Operation: to.Ptr("Create or update IP Firewall Rule."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("IP Firewall Rule."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/firewallRules/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read IP Firewall Rule"),
	// 			Operation: to.Ptr("Read IP Firewall Rule"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("IP Firewall Rule."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/firewallRules/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any IP Firewall Rule."),
	// 			Operation: to.Ptr("Delete IP Firewall Rule"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("IP Firewall Rule."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/replaceAllIpFirewallRules/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Replaces all Ip Firewall Rules for the Workspace."),
	// 			Operation: to.Ptr("Replace all Ip Firewall Rules for the Workspace."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Workspaces"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pools."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pools."),
	// 			Operation: to.Ptr("Read SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataWarehouseQueries/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Queries."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Queries."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Queries"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/geoBackupPolicies/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Geo Backup Policies."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Geo Backup Policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Geo Backup Policies"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataWarehouseUserActivities/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool User Activities."),
	// 			Operation: to.Ptr("Read SQL Analytics pool User Activities."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool User Activities"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/restorePoints/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Restore Points."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Restore Points."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Restore Points"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/dataWarehouseQueries/dataWarehouseQuerySteps/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Query Steps."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Query Steps."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Query Steps"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/maintenanceWindows/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Maintenance Windows."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Maintenance Windows."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Maintenance Windows"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/maintenanceWindowOptions/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Maintenance Window Options."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Maintenance Window Options."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Maintenance Window Options"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/replicationLinks/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Replication Links."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Replication Links."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Replication Links"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/transparentDataEncryption/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Transparent Data Encryption Configuration."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Transparent Data Encryption Configuration."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Transparent Data Encryption Configuration"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/transparentDataEncryption/operationResults/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Transparent Data Encryption Configuration Operation Results."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Transparent Data Encryption Configuration Operation Results."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Transparent Data Encryption Configuration Operation Results"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/auditingSettings/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Auditing Settings."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Auditing Settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/operations/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Operations."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Operations."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Operations"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/usages/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Usages."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Usages."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Usages"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/currentSensitivityLabels/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Current Sensitivity Labels."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Current Sensitivity Labels."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Current Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/recommendedSensitivityLabels/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Recommended Sensitivity Labels."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Recommended Sensitivity Labels."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Recommended Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Schemas."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Schemas."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Schemas"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Schema Tables."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Schema Tables."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Schema Tables"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/columns/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Schema Table Columns."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Schema Table Columns."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Schema Table Columns"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/connectionPolicies/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Connection Policies."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Connection Policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Connection Policies"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Vulnerability Assessment."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Vulnerability Assessment."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Operation: to.Ptr("Read SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment Scan Records"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/securityAlertPolicies/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Sql Analytics pool Threat Detection Policies."),
	// 			Operation: to.Ptr("Read Sql Analytics pool Threat Detection Policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Security Alert Policies"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any SQL Analytics pools."),
	// 			Operation: to.Ptr("Delete SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/pause/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Pause any SQL Analytics pools."),
	// 			Operation: to.Ptr("Pause SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/resume/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Resume any SQL Analytics pools."),
	// 			Operation: to.Ptr("Resume SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/restorePoints/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create a SQL Analytics pool Restore Point."),
	// 			Operation: to.Ptr("Create SQL Analytics pool Restore Point."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Restore Points"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/move/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Rename any SQL Analytics pools."),
	// 			Operation: to.Ptr("Rename SQL Analytics pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/columns/sensitivityLabels/enable/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Enable any SQL Analytics pool Sensitivity Labels."),
	// 			Operation: to.Ptr("Enable SQL Analytics pool Sensitivity Labels."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/columns/sensitivityLabels/disable/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Disable any SQL Analytics pool Sensitivity Labels."),
	// 			Operation: to.Ptr("Disable SQL Analytics pool Sensitivity Labels."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans/initiateScan/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Initiate any SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Operation: to.Ptr("Initiate SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment Scan Records"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans/export/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Export any SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Operation: to.Ptr("Export SQL Analytics pool Vulnerability Assessment Scan Records."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment Scan Records"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/maintenanceWindows/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any SQL Analytics pool Maintenance Windows."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Maintenance Windows."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Maintenance Windows"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/auditingSettings/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pool Auditing Settings."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Auditing Settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/columns/sensitivityLabels/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pool Sensitivity Labels."),
	// 			Operation: to.Ptr("Create or update SQL Analytics pool Sensitivity Labels."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/transparentDataEncryption/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pool Transparent Data Encryption Configuration."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Transparent Data Encryption Configuration."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Transparent Data Encryption Configuration"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/securityAlertPolicies/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pool Threat Detection Policies."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Threat Detection Policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Security Alert Policies"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/rules/baselines/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any SQL Analytics pool Vulnerability Assessment Rule Baseline."),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Vulnerability Assessment Rule Baseline."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment Rule Baseline"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/schemas/tables/columns/sensitivityLabels/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any SQL Analytics pool Sensitivity Labels."),
	// 			Operation: to.Ptr("Delete SQL Analytics pool Sensitivity Labels.2"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Sensitivity Labels"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any SQL Analytics pool Vulnerability Assessment."),
	// 			Operation: to.Ptr("Delete SQL Analytics pool Vulnerability Assessment."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/rules/baselines/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any SQL Analytics pool Vulnerability Assessment Rule Baseline."),
	// 			Operation: to.Ptr("Delete SQL Analytics pool Vulnerability Assessment Rule Baseline."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Vulnerability Assessment Rule Baseline"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/operationStatus/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Async Operation Status."),
	// 			Operation: to.Ptr("Read Async Operation Status."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Async Operation Status."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/operationResults/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Async Operation Result."),
	// 			Operation: to.Ptr("Read Async Operation Result."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Async Operation Result"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/operationResults/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Async Operation Result."),
	// 			Operation: to.Ptr("Read Async Operation Result."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Async Operation Result"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/checkNameAvailability/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Checks Workspace name availability."),
	// 			Operation: to.Ptr("Checks Workspace name availability."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Check Name Availability"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/bigDataPools/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any Spark pools."),
	// 			Operation: to.Ptr("Create or Update Spark pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Spark pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/bigDataPools/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Spark pools."),
	// 			Operation: to.Ptr("Read Spark pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Spark pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/bigDataPools/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any Spark pools."),
	// 			Operation: to.Ptr("Delete Spark pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Spark pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/metadataSync/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read SQL Analytics pool Metadata Sync Config"),
	// 			Operation: to.Ptr("Read SQL Analytics pool Metadata Sync Config"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Metadata Sync Config"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/metadataSync/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update SQL Analytics pool Metadata Sync Config"),
	// 			Operation: to.Ptr("Create or Update SQL Analytics pool Metadata Sync Config"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Metadata Sync Config"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/register/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Registers the Analytics 365 Resource Provider and enables the creation of Workspaces."),
	// 			Operation: to.Ptr("Registers the Analytics 365 Resource Provider."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Analytics 365 Resource Provider."),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/administrators/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Set Active Directory Administrator on the Workspace"),
	// 			Operation: to.Ptr("Set Active Directory Administrator"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Administrators"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/administrators/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get Workspace Active Directory Administrator"),
	// 			Operation: to.Ptr("Get Workspace Active Directory Administrator"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Administrators"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/administrators/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete Workspace Active Directory Administrator"),
	// 			Operation: to.Ptr("Delete Workspace Active Directory Administrator"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Administrators"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update any Workspaces."),
	// 			Operation: to.Ptr("Create or Update Workspaces."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Workspaces"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Workspaces."),
	// 			Operation: to.Ptr("Read Workspaces."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Workspaces"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete any Workspaces."),
	// 			Operation: to.Ptr("Delete Workspaces."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Workspaces"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/privateEndpointConnectionProxies/validate/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Validates Private Endpoint Connection Proxy"),
	// 			Operation: to.Ptr("Validates Private Endpoint Connection Proxy"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Validate Private Endpoint Connection Proxy"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/privateEndpointConnectionProxies/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update Private Endpoint Connection Proxy"),
	// 			Operation: to.Ptr("Create or Update Private Endpoint Connection Proxy"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Private Endpoint Connection Proxy"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/privateEndpointConnectionProxies/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read any Private Endpoint Connection Proxy"),
	// 			Operation: to.Ptr("Read Private Endpoint Connection Proxies"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Private Endpoint Connection Proxy"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/privateLinkResources/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Get a list of Private Link Resources"),
	// 			Operation: to.Ptr("Get Private Link Resources"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Private Link Resources"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/serverKeys/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Creates or updates a server key"),
	// 			Operation: to.Ptr("Creates or updates a server key"),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Key"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/serverKeys/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Deletes the server key with the given name."),
	// 			Operation: to.Ptr("Deletes the server key with the given name."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Key"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/extendedAuditingSettings/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update SQL server extended auditing settings."),
	// 			Operation: to.Ptr("Create or Update SQL server extended auditing settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Extended Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/extendedAuditingSettings/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read SQL server extended auditing settings."),
	// 			Operation: to.Ptr("Read SQL server extended auditing settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Extended Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/auditingSettings/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update SQL server auditing settings."),
	// 			Operation: to.Ptr("Create or Update SQL server auditing settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/auditingSettings/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read SQL server auditing settings."),
	// 			Operation: to.Ptr("Read SQL server auditing settings."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Auditing Settings"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/securityAlertPolicies/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update SQL server security alert policies."),
	// 			Operation: to.Ptr("Create or Update SQL server security alert policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Security Alert Policy"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/securityAlertPolicies/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read SQL server security alert policies."),
	// 			Operation: to.Ptr("Read SQL server security alert policies."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Security Alert Policy"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Create or Update SQL server vulnerability assement report."),
	// 			Operation: to.Ptr("Create or Update SQL server vulnerability assement report."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Vulnerability Assesment"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Read SQL server vulnerability assement report."),
	// 			Operation: to.Ptr("Read SQL server vulnerability assement report."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Vulnerability Assesment"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/vulnerabilityAssessments/delete"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Delete SQL server vulnerability assement report."),
	// 			Operation: to.Ptr("Delete SQL server vulnerability assement report."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Vulnerability Assesment"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/encryptionProtector/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Update the properties for the specified Server Encryption Protector."),
	// 			Operation: to.Ptr("Update the properties for the specified Server Encryption Protector."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Encryption Protector"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/encryptionProtector/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Returns a list of server encryption protectors or gets the properties for the specified server encryption protector."),
	// 			Operation: to.Ptr("Returns a list of server encryption protectors or gets the properties for the specified server encryption protector."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Encryption Protector"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/encryptionProtector/revalidate/action"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Revalidates an existing encryption protector."),
	// 			Operation: to.Ptr("Revalidates an existing encryption protector."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Server Encryption Protector"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/providers/Microsoft.Insights/metricDefinitions/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Gets the available metrics for workspace"),
	// 			Operation: to.Ptr("Read workspace metric definitions"),
	// 			Provider: to.Ptr("Microsoft Azure Synapse Analytics"),
	// 			Resource: to.Ptr("Workspace"),
	// 		},
	// 		Origin: to.Ptr("system"),
	// 		Properties: &armsynapse.OperationMetaPropertyInfo{
	// 			ServiceSpecification: &armsynapse.OperationMetaServiceSpecification{
	// 				MetricSpecifications: []*armsynapse.OperationMetaMetricSpecification{
	// 					{
	// 						Name: to.Ptr("PipelineFailedRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Failed pipeline runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("PipelineSucceededRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Succeeded pipeline runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("PipelineCancelledRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Cancelled pipeline runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("ActivityFailedRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("ActivityType"),
	// 								DisplayName: to.Ptr("Activity Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("PipelineName"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Activity"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Failed activity runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("ActivitySucceededRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("ActivityType"),
	// 								DisplayName: to.Ptr("Activity Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("PipelineName"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Activity"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Succeeded activity runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("ActivityCancelledRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("ActivityType"),
	// 								DisplayName: to.Ptr("Activity Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("PipelineName"),
	// 								DisplayName: to.Ptr("Pipeline"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Activity"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Cancelled activity runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("TriggerFailedRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Trigger"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Failed trigger runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("TriggerSucceededRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Trigger"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Succeeded trigger runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 					},
	// 					{
	// 						Name: to.Ptr("TriggerCancelledRuns"),
	// 						AggregationType: to.Ptr("Total"),
	// 						Dimensions: []*armsynapse.OperationMetaMetricDimensionSpecification{
	// 							{
	// 								Name: to.Ptr("Name"),
	// 								DisplayName: to.Ptr("Trigger"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 							},
	// 							{
	// 								Name: to.Ptr("FailureType"),
	// 								DisplayName: to.Ptr("Failure Type"),
	// 								ToBeExportedForShoebox: to.Ptr(true),
	// 						}},
	// 						DisplayName: to.Ptr("Cancelled trigger runs"),
	// 						SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
	// 						SourceMdmNamespace: to.Ptr("ADFMetrics"),
	// 						Unit: to.Ptr("Count"),
	// 				}},
	// 			},
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/providers/Microsoft.Insights/diagnosticSettings/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Gets the diagnostic setting for the resource"),
	// 			Operation: to.Ptr("Read diagnostic setting"),
	// 			Provider: to.Ptr("Microsoft Azure Synapse Analytics"),
	// 			Resource: to.Ptr("Workspace"),
	// 		},
	// 		Origin: to.Ptr("system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/providers/Microsoft.Insights/diagnosticSettings/write"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
	// 			Operation: to.Ptr("Write diagnostic setting"),
	// 			Provider: to.Ptr("Microsoft Azure Synapse Analytics"),
	// 			Resource: to.Ptr("Workspace"),
	// 		},
	// 		Origin: to.Ptr("system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/providers/Microsoft.Insights/logDefinitions/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Gets the available logs for workspace"),
	// 			Operation: to.Ptr("Read workspace log definitions"),
	// 			Provider: to.Ptr("Microsoft Azure Synapse Analytics"),
	// 			Resource: to.Ptr("The log definition of workspace"),
	// 		},
	// 		Origin: to.Ptr("system"),
	// 		Properties: &armsynapse.OperationMetaPropertyInfo{
	// 			ServiceSpecification: &armsynapse.OperationMetaServiceSpecification{
	// 				LogSpecifications: []*armsynapse.OperationMetaLogSpecification{
	// 					{
	// 						Name: to.Ptr("ActivityRuns"),
	// 						BlobDuration: to.Ptr("PT1H"),
	// 						DisplayName: to.Ptr("Activity runs"),
	// 					},
	// 					{
	// 						Name: to.Ptr("PipelineRuns"),
	// 						BlobDuration: to.Ptr("PT1H"),
	// 						DisplayName: to.Ptr("Pipeline runs"),
	// 					},
	// 					{
	// 						Name: to.Ptr("TriggerRuns"),
	// 						BlobDuration: to.Ptr("PT1H"),
	// 						DisplayName: to.Ptr("Trigger runs"),
	// 				}},
	// 			},
	// 		},
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/recoverableSqlPools/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Gets recoverable SQL Analytics Pools, which are the resources representing geo backups of SQL Analytics Pools."),
	// 			Operation: to.Ptr("Gets recoverable SQL Analytics Pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("Recoverable Sql Analytics Pools"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Synapse/workspaces/sqlUsages/read"),
	// 		Display: &armsynapse.AvailableRpOperationDisplayInfo{
	// 			Description: to.Ptr("Gets usage limits available for SQL Analytics Pools."),
	// 			Operation: to.Ptr("Gets usage limits available for SQL Analytics Pools."),
	// 			Provider: to.Ptr("Analytics 365 Resource Provider."),
	// 			Resource: to.Ptr("SQL Analytics pool Usages"),
	// 		},
	// 		IsDataAction: to.Ptr("false"),
	// 		Origin: to.Ptr("user, system"),
	// }}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetLocationHeader.json
func ExampleOperationsClient_GetLocationHeaderResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewOperationsClient().GetLocationHeaderResult(ctx, "resourceGroup1", "workspace1", "01234567-89ab-4def-0123-456789abcdef", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetAzureAsyncOperationHeader.json
func ExampleOperationsClient_GetAzureAsyncHeaderResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().GetAzureAsyncHeaderResult(ctx, "resourceGroup1", "workspace1", "01234567-89ab-4def-0123-456789abcdef", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResource = armsynapse.OperationResource{
	// 	Status: to.Ptr(armsynapse.OperationStatusInProgress),
	// }
}
