//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// KustoPoolsServer is a fake server for instances of the armsynapse.KustoPoolsClient type.
type KustoPoolsServer struct {
	// BeginAddLanguageExtensions is the fake for method KustoPoolsClient.BeginAddLanguageExtensions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAddLanguageExtensions func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToAdd armsynapse.LanguageExtensionsList, options *armsynapse.KustoPoolsClientBeginAddLanguageExtensionsOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientAddLanguageExtensionsResponse], errResp azfake.ErrorResponder)

	// CheckNameAvailability is the fake for method KustoPoolsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, kustoPoolName armsynapse.KustoPoolCheckNameRequest, options *armsynapse.KustoPoolsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armsynapse.KustoPoolsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method KustoPoolsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters armsynapse.KustoPool, options *armsynapse.KustoPoolsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method KustoPoolsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, options *armsynapse.KustoPoolsClientBeginDeleteOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDetachFollowerDatabases is the fake for method KustoPoolsClient.BeginDetachFollowerDatabases
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDetachFollowerDatabases func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, followerDatabaseToRemove armsynapse.FollowerDatabaseDefinition, options *armsynapse.KustoPoolsClientBeginDetachFollowerDatabasesOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientDetachFollowerDatabasesResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method KustoPoolsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientGetOptions) (resp azfake.Responder[armsynapse.KustoPoolsClientGetResponse], errResp azfake.ErrorResponder)

	// ListByWorkspace is the fake for method KustoPoolsClient.ListByWorkspace
	// HTTP status codes to indicate success: http.StatusOK
	ListByWorkspace func(ctx context.Context, resourceGroupName string, workspaceName string, options *armsynapse.KustoPoolsClientListByWorkspaceOptions) (resp azfake.Responder[armsynapse.KustoPoolsClientListByWorkspaceResponse], errResp azfake.ErrorResponder)

	// NewListFollowerDatabasesPager is the fake for method KustoPoolsClient.NewListFollowerDatabasesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFollowerDatabasesPager func(workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientListFollowerDatabasesOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolsClientListFollowerDatabasesResponse])

	// NewListLanguageExtensionsPager is the fake for method KustoPoolsClient.NewListLanguageExtensionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListLanguageExtensionsPager func(workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientListLanguageExtensionsOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolsClientListLanguageExtensionsResponse])

	// NewListSKUsPager is the fake for method KustoPoolsClient.NewListSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSKUsPager func(options *armsynapse.KustoPoolsClientListSKUsOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsResponse])

	// NewListSKUsByResourcePager is the fake for method KustoPoolsClient.NewListSKUsByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSKUsByResourcePager func(workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientListSKUsByResourceOptions) (resp azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsByResourceResponse])

	// BeginRemoveLanguageExtensions is the fake for method KustoPoolsClient.BeginRemoveLanguageExtensions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRemoveLanguageExtensions func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, languageExtensionsToRemove armsynapse.LanguageExtensionsList, options *armsynapse.KustoPoolsClientBeginRemoveLanguageExtensionsOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientRemoveLanguageExtensionsResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method KustoPoolsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientBeginStartOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method KustoPoolsClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, options *armsynapse.KustoPoolsClientBeginStopOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method KustoPoolsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, workspaceName string, resourceGroupName string, kustoPoolName string, parameters armsynapse.KustoPoolUpdate, options *armsynapse.KustoPoolsClientBeginUpdateOptions) (resp azfake.PollerResponder[armsynapse.KustoPoolsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewKustoPoolsServerTransport creates a new instance of KustoPoolsServerTransport with the provided implementation.
// The returned KustoPoolsServerTransport instance is connected to an instance of armsynapse.KustoPoolsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewKustoPoolsServerTransport(srv *KustoPoolsServer) *KustoPoolsServerTransport {
	return &KustoPoolsServerTransport{
		srv:                            srv,
		beginAddLanguageExtensions:     newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientAddLanguageExtensionsResponse]](),
		beginCreateOrUpdate:            newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientCreateOrUpdateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientDeleteResponse]](),
		beginDetachFollowerDatabases:   newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientDetachFollowerDatabasesResponse]](),
		newListFollowerDatabasesPager:  newTracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListFollowerDatabasesResponse]](),
		newListLanguageExtensionsPager: newTracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListLanguageExtensionsResponse]](),
		newListSKUsPager:               newTracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsResponse]](),
		newListSKUsByResourcePager:     newTracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsByResourceResponse]](),
		beginRemoveLanguageExtensions:  newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientRemoveLanguageExtensionsResponse]](),
		beginStart:                     newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientStartResponse]](),
		beginStop:                      newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientStopResponse]](),
		beginUpdate:                    newTracker[azfake.PollerResponder[armsynapse.KustoPoolsClientUpdateResponse]](),
	}
}

// KustoPoolsServerTransport connects instances of armsynapse.KustoPoolsClient to instances of KustoPoolsServer.
// Don't use this type directly, use NewKustoPoolsServerTransport instead.
type KustoPoolsServerTransport struct {
	srv                            *KustoPoolsServer
	beginAddLanguageExtensions     *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientAddLanguageExtensionsResponse]]
	beginCreateOrUpdate            *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientCreateOrUpdateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientDeleteResponse]]
	beginDetachFollowerDatabases   *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientDetachFollowerDatabasesResponse]]
	newListFollowerDatabasesPager  *tracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListFollowerDatabasesResponse]]
	newListLanguageExtensionsPager *tracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListLanguageExtensionsResponse]]
	newListSKUsPager               *tracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsResponse]]
	newListSKUsByResourcePager     *tracker[azfake.PagerResponder[armsynapse.KustoPoolsClientListSKUsByResourceResponse]]
	beginRemoveLanguageExtensions  *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientRemoveLanguageExtensionsResponse]]
	beginStart                     *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientStartResponse]]
	beginStop                      *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientStopResponse]]
	beginUpdate                    *tracker[azfake.PollerResponder[armsynapse.KustoPoolsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for KustoPoolsServerTransport.
func (k *KustoPoolsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "KustoPoolsClient.BeginAddLanguageExtensions":
		resp, err = k.dispatchBeginAddLanguageExtensions(req)
	case "KustoPoolsClient.CheckNameAvailability":
		resp, err = k.dispatchCheckNameAvailability(req)
	case "KustoPoolsClient.BeginCreateOrUpdate":
		resp, err = k.dispatchBeginCreateOrUpdate(req)
	case "KustoPoolsClient.BeginDelete":
		resp, err = k.dispatchBeginDelete(req)
	case "KustoPoolsClient.BeginDetachFollowerDatabases":
		resp, err = k.dispatchBeginDetachFollowerDatabases(req)
	case "KustoPoolsClient.Get":
		resp, err = k.dispatchGet(req)
	case "KustoPoolsClient.ListByWorkspace":
		resp, err = k.dispatchListByWorkspace(req)
	case "KustoPoolsClient.NewListFollowerDatabasesPager":
		resp, err = k.dispatchNewListFollowerDatabasesPager(req)
	case "KustoPoolsClient.NewListLanguageExtensionsPager":
		resp, err = k.dispatchNewListLanguageExtensionsPager(req)
	case "KustoPoolsClient.NewListSKUsPager":
		resp, err = k.dispatchNewListSKUsPager(req)
	case "KustoPoolsClient.NewListSKUsByResourcePager":
		resp, err = k.dispatchNewListSKUsByResourcePager(req)
	case "KustoPoolsClient.BeginRemoveLanguageExtensions":
		resp, err = k.dispatchBeginRemoveLanguageExtensions(req)
	case "KustoPoolsClient.BeginStart":
		resp, err = k.dispatchBeginStart(req)
	case "KustoPoolsClient.BeginStop":
		resp, err = k.dispatchBeginStop(req)
	case "KustoPoolsClient.BeginUpdate":
		resp, err = k.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginAddLanguageExtensions(req *http.Request) (*http.Response, error) {
	if k.srv.BeginAddLanguageExtensions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAddLanguageExtensions not implemented")}
	}
	beginAddLanguageExtensions := k.beginAddLanguageExtensions.get(req)
	if beginAddLanguageExtensions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/addLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.LanguageExtensionsList](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginAddLanguageExtensions(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAddLanguageExtensions = &respr
		k.beginAddLanguageExtensions.add(req, beginAddLanguageExtensions)
	}

	resp, err := server.PollerResponderNext(beginAddLanguageExtensions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginAddLanguageExtensions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAddLanguageExtensions) {
		k.beginAddLanguageExtensions.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if k.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPoolCheckNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.KustoPoolCheckNameRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := k.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.KustoPool](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		var options *armsynapse.KustoPoolsClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armsynapse.KustoPoolsClientBeginCreateOrUpdateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := k.srv.BeginCreateOrUpdate(req.Context(), workspaceNameParam, resourceGroupNameParam, kustoPoolNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		k.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		k.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		k.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if k.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := k.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginDelete(req.Context(), workspaceNameParam, resourceGroupNameParam, kustoPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		k.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		k.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		k.beginDelete.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginDetachFollowerDatabases(req *http.Request) (*http.Response, error) {
	if k.srv.BeginDetachFollowerDatabases == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDetachFollowerDatabases not implemented")}
	}
	beginDetachFollowerDatabases := k.beginDetachFollowerDatabases.get(req)
	if beginDetachFollowerDatabases == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detachFollowerDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.FollowerDatabaseDefinition](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginDetachFollowerDatabases(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDetachFollowerDatabases = &respr
		k.beginDetachFollowerDatabases.add(req, beginDetachFollowerDatabases)
	}

	resp, err := server.PollerResponderNext(beginDetachFollowerDatabases, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginDetachFollowerDatabases.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDetachFollowerDatabases) {
		k.beginDetachFollowerDatabases.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if k.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.Get(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KustoPool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchListByWorkspace(req *http.Request) (*http.Response, error) {
	if k.srv.ListByWorkspace == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByWorkspace not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.ListByWorkspace(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).KustoPoolListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchNewListFollowerDatabasesPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListFollowerDatabasesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFollowerDatabasesPager not implemented")}
	}
	newListFollowerDatabasesPager := k.newListFollowerDatabasesPager.get(req)
	if newListFollowerDatabasesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFollowerDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListFollowerDatabasesPager(workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		newListFollowerDatabasesPager = &resp
		k.newListFollowerDatabasesPager.add(req, newListFollowerDatabasesPager)
	}
	resp, err := server.PagerResponderNext(newListFollowerDatabasesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListFollowerDatabasesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFollowerDatabasesPager) {
		k.newListFollowerDatabasesPager.remove(req)
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchNewListLanguageExtensionsPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListLanguageExtensionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListLanguageExtensionsPager not implemented")}
	}
	newListLanguageExtensionsPager := k.newListLanguageExtensionsPager.get(req)
	if newListLanguageExtensionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListLanguageExtensionsPager(workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		newListLanguageExtensionsPager = &resp
		k.newListLanguageExtensionsPager.add(req, newListLanguageExtensionsPager)
	}
	resp, err := server.PagerResponderNext(newListLanguageExtensionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListLanguageExtensionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListLanguageExtensionsPager) {
		k.newListLanguageExtensionsPager.remove(req)
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchNewListSKUsPager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSKUsPager not implemented")}
	}
	newListSKUsPager := k.newListSKUsPager.get(req)
	if newListSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := k.srv.NewListSKUsPager(nil)
		newListSKUsPager = &resp
		k.newListSKUsPager.add(req, newListSKUsPager)
	}
	resp, err := server.PagerResponderNext(newListSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSKUsPager) {
		k.newListSKUsPager.remove(req)
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchNewListSKUsByResourcePager(req *http.Request) (*http.Response, error) {
	if k.srv.NewListSKUsByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSKUsByResourcePager not implemented")}
	}
	newListSKUsByResourcePager := k.newListSKUsByResourcePager.get(req)
	if newListSKUsByResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := k.srv.NewListSKUsByResourcePager(workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		newListSKUsByResourcePager = &resp
		k.newListSKUsByResourcePager.add(req, newListSKUsByResourcePager)
	}
	resp, err := server.PagerResponderNext(newListSKUsByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		k.newListSKUsByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSKUsByResourcePager) {
		k.newListSKUsByResourcePager.remove(req)
	}
	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginRemoveLanguageExtensions(req *http.Request) (*http.Response, error) {
	if k.srv.BeginRemoveLanguageExtensions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRemoveLanguageExtensions not implemented")}
	}
	beginRemoveLanguageExtensions := k.beginRemoveLanguageExtensions.get(req)
	if beginRemoveLanguageExtensions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/removeLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.LanguageExtensionsList](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginRemoveLanguageExtensions(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRemoveLanguageExtensions = &respr
		k.beginRemoveLanguageExtensions.add(req, beginRemoveLanguageExtensions)
	}

	resp, err := server.PollerResponderNext(beginRemoveLanguageExtensions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginRemoveLanguageExtensions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRemoveLanguageExtensions) {
		k.beginRemoveLanguageExtensions.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if k.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := k.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginStart(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		k.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		k.beginStart.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if k.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := k.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := k.srv.BeginStop(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		k.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		k.beginStop.remove(req)
	}

	return resp, nil
}

func (k *KustoPoolsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if k.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := k.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsynapse.KustoPoolUpdate](req)
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armsynapse.KustoPoolsClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armsynapse.KustoPoolsClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := k.srv.BeginUpdate(req.Context(), workspaceNameParam, resourceGroupNameParam, kustoPoolNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		k.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		k.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		k.beginUpdate.remove(req)
	}

	return resp, nil
}
