//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagepool/armstoragepool"
	"net/http"
	"net/url"
	"regexp"
)

// DiskPoolsServer is a fake server for instances of the armstoragepool.DiskPoolsClient type.
type DiskPoolsServer struct {
	// BeginCreateOrUpdate is the fake for method DiskPoolsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolCreatePayload armstoragepool.DiskPoolCreate, options *armstoragepool.DiskPoolsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDeallocate is the fake for method DiskPoolsClient.BeginDeallocate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDeallocate func(ctx context.Context, resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientBeginDeallocateOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientDeallocateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DiskPoolsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientBeginDeleteOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DiskPoolsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientGetOptions) (resp azfake.Responder[armstoragepool.DiskPoolsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method DiskPoolsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armstoragepool.DiskPoolsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armstoragepool.DiskPoolsClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method DiskPoolsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armstoragepool.DiskPoolsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armstoragepool.DiskPoolsClientListBySubscriptionResponse])

	// NewListOutboundNetworkDependenciesEndpointsPager is the fake for method DiskPoolsClient.NewListOutboundNetworkDependenciesEndpointsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOutboundNetworkDependenciesEndpointsPager func(resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientListOutboundNetworkDependenciesEndpointsOptions) (resp azfake.PagerResponder[armstoragepool.DiskPoolsClientListOutboundNetworkDependenciesEndpointsResponse])

	// BeginStart is the fake for method DiskPoolsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientBeginStartOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method DiskPoolsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolUpdatePayload armstoragepool.DiskPoolUpdate, options *armstoragepool.DiskPoolsClientBeginUpdateOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpgrade is the fake for method DiskPoolsClient.BeginUpgrade
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpgrade func(ctx context.Context, resourceGroupName string, diskPoolName string, options *armstoragepool.DiskPoolsClientBeginUpgradeOptions) (resp azfake.PollerResponder[armstoragepool.DiskPoolsClientUpgradeResponse], errResp azfake.ErrorResponder)
}

// NewDiskPoolsServerTransport creates a new instance of DiskPoolsServerTransport with the provided implementation.
// The returned DiskPoolsServerTransport instance is connected to an instance of armstoragepool.DiskPoolsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiskPoolsServerTransport(srv *DiskPoolsServer) *DiskPoolsServerTransport {
	return &DiskPoolsServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientCreateOrUpdateResponse]](),
		beginDeallocate:             newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientDeallocateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListBySubscriptionResponse]](),
		newListOutboundNetworkDependenciesEndpointsPager: newTracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListOutboundNetworkDependenciesEndpointsResponse]](),
		beginStart:   newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientStartResponse]](),
		beginUpdate:  newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientUpdateResponse]](),
		beginUpgrade: newTracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientUpgradeResponse]](),
	}
}

// DiskPoolsServerTransport connects instances of armstoragepool.DiskPoolsClient to instances of DiskPoolsServer.
// Don't use this type directly, use NewDiskPoolsServerTransport instead.
type DiskPoolsServerTransport struct {
	srv                                              *DiskPoolsServer
	beginCreateOrUpdate                              *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientCreateOrUpdateResponse]]
	beginDeallocate                                  *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientDeallocateResponse]]
	beginDelete                                      *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientDeleteResponse]]
	newListByResourceGroupPager                      *tracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListByResourceGroupResponse]]
	newListBySubscriptionPager                       *tracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListBySubscriptionResponse]]
	newListOutboundNetworkDependenciesEndpointsPager *tracker[azfake.PagerResponder[armstoragepool.DiskPoolsClientListOutboundNetworkDependenciesEndpointsResponse]]
	beginStart                                       *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientStartResponse]]
	beginUpdate                                      *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientUpdateResponse]]
	beginUpgrade                                     *tracker[azfake.PollerResponder[armstoragepool.DiskPoolsClientUpgradeResponse]]
}

// Do implements the policy.Transporter interface for DiskPoolsServerTransport.
func (d *DiskPoolsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiskPoolsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DiskPoolsClient.BeginDeallocate":
		resp, err = d.dispatchBeginDeallocate(req)
	case "DiskPoolsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DiskPoolsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DiskPoolsClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	case "DiskPoolsClient.NewListBySubscriptionPager":
		resp, err = d.dispatchNewListBySubscriptionPager(req)
	case "DiskPoolsClient.NewListOutboundNetworkDependenciesEndpointsPager":
		resp, err = d.dispatchNewListOutboundNetworkDependenciesEndpointsPager(req)
	case "DiskPoolsClient.BeginStart":
		resp, err = d.dispatchBeginStart(req)
	case "DiskPoolsClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	case "DiskPoolsClient.BeginUpgrade":
		resp, err = d.dispatchBeginUpgrade(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragepool.DiskPoolCreate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, diskPoolNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginDeallocate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDeallocate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeallocate not implemented")}
	}
	beginDeallocate := d.beginDeallocate.get(req)
	if beginDeallocate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deallocate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDeallocate(req.Context(), resourceGroupNameParam, diskPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeallocate = &respr
		d.beginDeallocate.add(req, beginDeallocate)
	}

	resp, err := server.PollerResponderNext(beginDeallocate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginDeallocate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeallocate) {
		d.beginDeallocate.remove(req)
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, diskPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, diskPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiskPool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armstoragepool.DiskPoolsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := d.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		d.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armstoragepool.DiskPoolsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		d.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchNewListOutboundNetworkDependenciesEndpointsPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListOutboundNetworkDependenciesEndpointsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOutboundNetworkDependenciesEndpointsPager not implemented")}
	}
	newListOutboundNetworkDependenciesEndpointsPager := d.newListOutboundNetworkDependenciesEndpointsPager.get(req)
	if newListOutboundNetworkDependenciesEndpointsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundNetworkDependenciesEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListOutboundNetworkDependenciesEndpointsPager(resourceGroupNameParam, diskPoolNameParam, nil)
		newListOutboundNetworkDependenciesEndpointsPager = &resp
		d.newListOutboundNetworkDependenciesEndpointsPager.add(req, newListOutboundNetworkDependenciesEndpointsPager)
		server.PagerResponderInjectNextLinks(newListOutboundNetworkDependenciesEndpointsPager, req, func(page *armstoragepool.DiskPoolsClientListOutboundNetworkDependenciesEndpointsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOutboundNetworkDependenciesEndpointsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOutboundNetworkDependenciesEndpointsPager) {
		d.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
	}
	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if d.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := d.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginStart(req.Context(), resourceGroupNameParam, diskPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		d.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		d.beginStart.remove(req)
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstoragepool.DiskPoolUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, diskPoolNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}

func (d *DiskPoolsServerTransport) dispatchBeginUpgrade(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpgrade == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpgrade not implemented")}
	}
	beginUpgrade := d.beginUpgrade.get(req)
	if beginUpgrade == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StoragePool/diskPools/(?P<diskPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/upgrade`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		diskPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diskPoolName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpgrade(req.Context(), resourceGroupNameParam, diskPoolNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpgrade = &respr
		d.beginUpgrade.add(req, beginUpgrade)
	}

	resp, err := server.PollerResponderNext(beginUpgrade, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpgrade.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpgrade) {
		d.beginUpgrade.remove(req)
	}

	return resp, nil
}
