//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// VulnerabilityAssessmentBaselineServer is a fake server for instances of the armsql.VulnerabilityAssessmentBaselineClient type.
type VulnerabilityAssessmentBaselineServer struct {
	// Get is the fake for method VulnerabilityAssessmentBaselineClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, options *armsql.VulnerabilityAssessmentBaselineClientGetOptions) (resp azfake.Responder[armsql.VulnerabilityAssessmentBaselineClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLVulnerabilityAssessmentPager is the fake for method VulnerabilityAssessmentBaselineClient.NewListBySQLVulnerabilityAssessmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLVulnerabilityAssessmentPager func(resourceGroupName string, serverName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentOptions) (resp azfake.PagerResponder[armsql.VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse])
}

// NewVulnerabilityAssessmentBaselineServerTransport creates a new instance of VulnerabilityAssessmentBaselineServerTransport with the provided implementation.
// The returned VulnerabilityAssessmentBaselineServerTransport instance is connected to an instance of armsql.VulnerabilityAssessmentBaselineClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVulnerabilityAssessmentBaselineServerTransport(srv *VulnerabilityAssessmentBaselineServer) *VulnerabilityAssessmentBaselineServerTransport {
	return &VulnerabilityAssessmentBaselineServerTransport{
		srv:                                      srv,
		newListBySQLVulnerabilityAssessmentPager: newTracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse]](),
	}
}

// VulnerabilityAssessmentBaselineServerTransport connects instances of armsql.VulnerabilityAssessmentBaselineClient to instances of VulnerabilityAssessmentBaselineServer.
// Don't use this type directly, use NewVulnerabilityAssessmentBaselineServerTransport instead.
type VulnerabilityAssessmentBaselineServerTransport struct {
	srv                                      *VulnerabilityAssessmentBaselineServer
	newListBySQLVulnerabilityAssessmentPager *tracker[azfake.PagerResponder[armsql.VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse]]
}

// Do implements the policy.Transporter interface for VulnerabilityAssessmentBaselineServerTransport.
func (v *VulnerabilityAssessmentBaselineServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VulnerabilityAssessmentBaselineClient.Get":
		resp, err = v.dispatchGet(req)
	case "VulnerabilityAssessmentBaselineClient.NewListBySQLVulnerabilityAssessmentPager":
		resp, err = v.dispatchNewListBySQLVulnerabilityAssessmentPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VulnerabilityAssessmentBaselineServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentBaselineSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VulnerabilityAssessmentBaselineServerTransport) dispatchNewListBySQLVulnerabilityAssessmentPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListBySQLVulnerabilityAssessmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLVulnerabilityAssessmentPager not implemented")}
	}
	newListBySQLVulnerabilityAssessmentPager := v.newListBySQLVulnerabilityAssessmentPager.get(req)
	if newListBySQLVulnerabilityAssessmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListBySQLVulnerabilityAssessmentPager(resourceGroupNameParam, serverNameParam, vulnerabilityAssessmentNameParam, nil)
		newListBySQLVulnerabilityAssessmentPager = &resp
		v.newListBySQLVulnerabilityAssessmentPager.add(req, newListBySQLVulnerabilityAssessmentPager)
		server.PagerResponderInjectNextLinks(newListBySQLVulnerabilityAssessmentPager, req, func(page *armsql.VulnerabilityAssessmentBaselineClientListBySQLVulnerabilityAssessmentResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLVulnerabilityAssessmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListBySQLVulnerabilityAssessmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLVulnerabilityAssessmentPager) {
		v.newListBySQLVulnerabilityAssessmentPager.remove(req)
	}
	return resp, nil
}
