//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseColumnsServer is a fake server for instances of the armsql.DatabaseColumnsClient type.
type DatabaseColumnsServer struct {
	// Get is the fake for method DatabaseColumnsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, columnName string, options *armsql.DatabaseColumnsClientGetOptions) (resp azfake.Responder[armsql.DatabaseColumnsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method DatabaseColumnsClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, serverName string, databaseName string, options *armsql.DatabaseColumnsClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.DatabaseColumnsClientListByDatabaseResponse])

	// NewListByTablePager is the fake for method DatabaseColumnsClient.NewListByTablePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTablePager func(resourceGroupName string, serverName string, databaseName string, schemaName string, tableName string, options *armsql.DatabaseColumnsClientListByTableOptions) (resp azfake.PagerResponder[armsql.DatabaseColumnsClientListByTableResponse])
}

// NewDatabaseColumnsServerTransport creates a new instance of DatabaseColumnsServerTransport with the provided implementation.
// The returned DatabaseColumnsServerTransport instance is connected to an instance of armsql.DatabaseColumnsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseColumnsServerTransport(srv *DatabaseColumnsServer) *DatabaseColumnsServerTransport {
	return &DatabaseColumnsServerTransport{
		srv:                    srv,
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.DatabaseColumnsClientListByDatabaseResponse]](),
		newListByTablePager:    newTracker[azfake.PagerResponder[armsql.DatabaseColumnsClientListByTableResponse]](),
	}
}

// DatabaseColumnsServerTransport connects instances of armsql.DatabaseColumnsClient to instances of DatabaseColumnsServer.
// Don't use this type directly, use NewDatabaseColumnsServerTransport instead.
type DatabaseColumnsServerTransport struct {
	srv                    *DatabaseColumnsServer
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.DatabaseColumnsClientListByDatabaseResponse]]
	newListByTablePager    *tracker[azfake.PagerResponder[armsql.DatabaseColumnsClientListByTableResponse]]
}

// Do implements the policy.Transporter interface for DatabaseColumnsServerTransport.
func (d *DatabaseColumnsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseColumnsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabaseColumnsClient.NewListByDatabasePager":
		resp, err = d.dispatchNewListByDatabasePager(req)
	case "DatabaseColumnsClient.NewListByTablePager":
		resp, err = d.dispatchNewListByTablePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseColumnsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas/(?P<schemaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/columns/(?P<columnName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	schemaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("schemaName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	columnNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("columnName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, schemaNameParam, tableNameParam, columnNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseColumn, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseColumnsServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := d.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/columns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		schemaEscaped := qp["schema"]
		schemaParam := make([]string, len(schemaEscaped))
		for i, v := range schemaEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			schemaParam[i] = u
		}
		tableEscaped := qp["table"]
		tableParam := make([]string, len(tableEscaped))
		for i, v := range tableEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			tableParam[i] = u
		}
		columnEscaped := qp["column"]
		columnParam := make([]string, len(columnEscaped))
		for i, v := range columnEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			columnParam[i] = u
		}
		orderByEscaped := qp["orderBy"]
		orderByParam := make([]string, len(orderByEscaped))
		for i, v := range orderByEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			orderByParam[i] = u
		}
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armsql.DatabaseColumnsClientListByDatabaseOptions
		if len(schemaParam) > 0 || len(tableParam) > 0 || len(columnParam) > 0 || len(orderByParam) > 0 || skiptokenParam != nil {
			options = &armsql.DatabaseColumnsClientListByDatabaseOptions{
				Schema:    schemaParam,
				Table:     tableParam,
				Column:    columnParam,
				OrderBy:   orderByParam,
				Skiptoken: skiptokenParam,
			}
		}
		resp := d.srv.NewListByDatabasePager(resourceGroupNameParam, serverNameParam, databaseNameParam, options)
		newListByDatabasePager = &resp
		d.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.DatabaseColumnsClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		d.newListByDatabasePager.remove(req)
	}
	return resp, nil
}

func (d *DatabaseColumnsServerTransport) dispatchNewListByTablePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByTablePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTablePager not implemented")}
	}
	newListByTablePager := d.newListByTablePager.get(req)
	if newListByTablePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/schemas/(?P<schemaName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/columns`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		schemaNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("schemaName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armsql.DatabaseColumnsClientListByTableOptions
		if filterParam != nil {
			options = &armsql.DatabaseColumnsClientListByTableOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListByTablePager(resourceGroupNameParam, serverNameParam, databaseNameParam, schemaNameParam, tableNameParam, options)
		newListByTablePager = &resp
		d.newListByTablePager.add(req, newListByTablePager)
		server.PagerResponderInjectNextLinks(newListByTablePager, req, func(page *armsql.DatabaseColumnsClientListByTableResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTablePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByTablePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTablePager) {
		d.newListByTablePager.remove(req)
	}
	return resp, nil
}
