//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineListByBaseline.json
func ExampleDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient_NewListByBaselinePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient().NewListByBaselinePager("vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult = armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListResult{
		// 	Value: []*armsql.DatabaseSQLVulnerabilityAssessmentRuleBaseline{
		// 		{
		// 			Name: to.Ptr("default"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/default/baselines/default/rules/VA1001"),
		// 			Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties{
		// 				Results: [][]*string{
		// 					[]*string{
		// 						to.Ptr("userA"),
		// 						to.Ptr("SELECT")},
		// 						[]*string{
		// 							to.Ptr("userB"),
		// 							to.Ptr("SELECT")},
		// 							[]*string{
		// 								to.Ptr("userC"),
		// 								to.Ptr("SELECT")}},
		// 							},
		// 						},
		// 						{
		// 							Name: to.Ptr("default"),
		// 							Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines"),
		// 							ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/default/baselines/default/rules/VA1002"),
		// 							Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties{
		// 								Results: [][]*string{
		// 									[]*string{
		// 										to.Ptr("userA"),
		// 										to.Ptr("SELECT")},
		// 										[]*string{
		// 											to.Ptr("userB"),
		// 											to.Ptr("SELECT")},
		// 											[]*string{
		// 												to.Ptr("userC"),
		// 												to.Ptr("SELECT")}},
		// 											},
		// 									}},
		// 								}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineGet.json
func ExampleDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient().Get(ctx, "vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, "VA1001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseSQLVulnerabilityAssessmentRuleBaseline = armsql.DatabaseSQLVulnerabilityAssessmentRuleBaseline{
	// 	Name: to.Ptr("VA1001"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselineRules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/default/baselines/default/rules/VA1001"),
	// 	Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties{
	// 		Results: [][]*string{
	// 			[]*string{
	// 				to.Ptr("userA"),
	// 				to.Ptr("SELECT")},
	// 				[]*string{
	// 					to.Ptr("userB"),
	// 					to.Ptr("SELECT")},
	// 					[]*string{
	// 						to.Ptr("userC"),
	// 						to.Ptr("SELECT")}},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineCreate.json
func ExampleDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, "VA1001", armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInput{
		Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineInputProperties{
			LatestScan: to.Ptr(false),
			Results: [][]*string{
				{
					to.Ptr("userA"),
					to.Ptr("SELECT")},
				{
					to.Ptr("userB"),
					to.Ptr("SELECT")},
				{
					to.Ptr("userC"),
					to.Ptr("SELECT")}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseSQLVulnerabilityAssessmentRuleBaseline = armsql.DatabaseSQLVulnerabilityAssessmentRuleBaseline{
	// 	Name: to.Ptr("Scan123"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/rules/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/default/baselines/default/rules/VA1001"),
	// 	Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineProperties{
	// 		Results: [][]*string{
	// 			[]*string{
	// 				to.Ptr("userA"),
	// 				to.Ptr("SELECT")},
	// 				[]*string{
	// 					to.Ptr("userB"),
	// 					to.Ptr("SELECT")},
	// 					[]*string{
	// 						to.Ptr("userC"),
	// 						to.Ptr("SELECT")}},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentRuleBaselineDelete.json
func ExampleDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDatabaseSQLVulnerabilityAssessmentRuleBaselinesClient().Delete(ctx, "vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, "VA1001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
