//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineListBySqlVulnerabilityAssessment.json
func ExampleDatabaseSQLVulnerabilityAssessmentBaselinesClient_NewListBySQLVulnerabilityAssessmentPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseSQLVulnerabilityAssessmentBaselinesClient().NewListBySQLVulnerabilityAssessmentPager("vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DatabaseSQLVulnerabilityAssessmentBaselineSetListResult = armsql.DatabaseSQLVulnerabilityAssessmentBaselineSetListResult{
		// 	Value: []*armsql.DatabaseSQLVulnerabilityAssessmentBaselineSet{
		// 		{
		// 			Name: to.Ptr("Default"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/Default/baselines/Default"),
		// 			Properties: &armsql.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties{
		// 				Results: map[string][][]*string{
		// 					"VA1020": [][]*string{
		// 					},
		// 					"VA1054": [][]*string{
		// 					},
		// 					"VA1095": [][]*string{
		// 					},
		// 					"VA1096": [][]*string{
		// 					},
		// 					"VA1097": [][]*string{
		// 					},
		// 					"VA1099": [][]*string{
		// 					},
		// 					"VA1143": [][]*string{
		// 						[]*string{
		// 							to.Ptr("True")}},
		// 							"VA1219": [][]*string{
		// 								[]*string{
		// 									to.Ptr("False")}},
		// 									"VA1221": [][]*string{
		// 									},
		// 									"VA1223": [][]*string{
		// 									},
		// 									"VA1224": [][]*string{
		// 									},
		// 									"VA1246": [][]*string{
		// 									},
		// 									"VA1248": [][]*string{
		// 									},
		// 									"VA1258": [][]*string{
		// 									},
		// 									"VA1281": [][]*string{
		// 									},
		// 									"VA1282": [][]*string{
		// 									},
		// 									"VA2020": [][]*string{
		// 									},
		// 									"VA2033": [][]*string{
		// 									},
		// 									"VA2062": [][]*string{
		// 									},
		// 									"VA2064": [][]*string{
		// 									},
		// 									"VA2108": [][]*string{
		// 									},
		// 									"VA2109": [][]*string{
		// 									},
		// 									"VA2129": [][]*string{
		// 									},
		// 									"VA2130": [][]*string{
		// 									},
		// 								},
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineGet.json
func ExampleDatabaseSQLVulnerabilityAssessmentBaselinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentBaselinesClient().Get(ctx, "vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseSQLVulnerabilityAssessmentBaselineSet = armsql.DatabaseSQLVulnerabilityAssessmentBaselineSet{
	// 	Name: to.Ptr("Default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/Default/baselines/Default"),
	// 	Properties: &armsql.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties{
	// 		Results: map[string][][]*string{
	// 			"VA1020": [][]*string{
	// 			},
	// 			"VA1054": [][]*string{
	// 			},
	// 			"VA1095": [][]*string{
	// 			},
	// 			"VA1096": [][]*string{
	// 			},
	// 			"VA1097": [][]*string{
	// 			},
	// 			"VA1099": [][]*string{
	// 			},
	// 			"VA1143": [][]*string{
	// 				[]*string{
	// 					to.Ptr("True")}},
	// 					"VA1219": [][]*string{
	// 						[]*string{
	// 							to.Ptr("False")}},
	// 							"VA1221": [][]*string{
	// 							},
	// 							"VA1223": [][]*string{
	// 							},
	// 							"VA1224": [][]*string{
	// 							},
	// 							"VA1246": [][]*string{
	// 							},
	// 							"VA1248": [][]*string{
	// 							},
	// 							"VA1258": [][]*string{
	// 							},
	// 							"VA1281": [][]*string{
	// 							},
	// 							"VA1282": [][]*string{
	// 							},
	// 							"VA2020": [][]*string{
	// 							},
	// 							"VA2033": [][]*string{
	// 							},
	// 							"VA2062": [][]*string{
	// 							},
	// 							"VA2064": [][]*string{
	// 							},
	// 							"VA2108": [][]*string{
	// 							},
	// 							"VA2109": [][]*string{
	// 							},
	// 							"VA2129": [][]*string{
	// 							},
	// 							"VA2130": [][]*string{
	// 							},
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineAddLatest.json
func ExampleDatabaseSQLVulnerabilityAssessmentBaselinesClient_CreateOrUpdate_addADatabasesVulnerabilityAssessmentRuleBaselineFromTheLatestScanResult() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentBaselinesClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput{
		Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties{
			LatestScan: to.Ptr(true),
			Results:    map[string][][]*string{},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseSQLVulnerabilityAssessmentBaselineSet = armsql.DatabaseSQLVulnerabilityAssessmentBaselineSet{
	// 	Name: to.Ptr("Default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/Default/baselines/Default"),
	// 	Properties: &armsql.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties{
	// 		Results: map[string][][]*string{
	// 			"VA1020": [][]*string{
	// 			},
	// 			"VA1054": [][]*string{
	// 			},
	// 			"VA1095": [][]*string{
	// 			},
	// 			"VA1096": [][]*string{
	// 			},
	// 			"VA1097": [][]*string{
	// 			},
	// 			"VA1099": [][]*string{
	// 			},
	// 			"VA1143": [][]*string{
	// 				[]*string{
	// 					to.Ptr("True")}},
	// 					"VA1219": [][]*string{
	// 						[]*string{
	// 							to.Ptr("False")}},
	// 							"VA1221": [][]*string{
	// 							},
	// 							"VA1223": [][]*string{
	// 							},
	// 							"VA1224": [][]*string{
	// 							},
	// 							"VA1246": [][]*string{
	// 							},
	// 							"VA1248": [][]*string{
	// 							},
	// 							"VA1258": [][]*string{
	// 							},
	// 							"VA1281": [][]*string{
	// 							},
	// 							"VA1282": [][]*string{
	// 							},
	// 							"VA2020": [][]*string{
	// 							},
	// 							"VA2033": [][]*string{
	// 							},
	// 							"VA2062": [][]*string{
	// 							},
	// 							"VA2064": [][]*string{
	// 							},
	// 							"VA2108": [][]*string{
	// 							},
	// 							"VA2109": [][]*string{
	// 							},
	// 							"VA2129": [][]*string{
	// 							},
	// 							"VA2130": [][]*string{
	// 							},
	// 						},
	// 					},
	// 				}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/01e99457ccf5613a95d5b2960d31a12f84018863/specification/sql/resource-manager/Microsoft.Sql/preview/2022-11-01-preview/examples/DatabaseSqlVulnerabilityAssessmentBaselineAdd.json
func ExampleDatabaseSQLVulnerabilityAssessmentBaselinesClient_CreateOrUpdate_addADatabasesVulnerabilityAssessmentRuleBaselineList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseSQLVulnerabilityAssessmentBaselinesClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, armsql.BaselineNameDefault, armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput{
		Properties: &armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInputProperties{
			LatestScan: to.Ptr(false),
			Results: map[string][][]*string{
				"VA2063": {
					{
						to.Ptr("AllowAll"),
						to.Ptr("0.0.0.0"),
						to.Ptr("255.255.255.255")}},
				"VA2065": {
					{
						to.Ptr("AllowAll"),
						to.Ptr("0.0.0.0"),
						to.Ptr("255.255.255.255")}},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseSQLVulnerabilityAssessmentBaselineSet = armsql.DatabaseSQLVulnerabilityAssessmentBaselineSet{
	// 	Name: to.Ptr("Default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/sqlVulnerabilityAssessments/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityaseessmenttest-6440/databases/testdb/sqlVulnerabilityAssessments/Default/baselines/Default"),
	// 	Properties: &armsql.DatabaseSQLVulnerabilityAssessmentBaselineSetProperties{
	// 		Results: map[string][][]*string{
	// 			"VA2063": [][]*string{
	// 				[]*string{
	// 					to.Ptr("AllowAll"),
	// 					to.Ptr("0.0.0.0"),
	// 					to.Ptr("255.255.255.255")}},
	// 					"VA2065": [][]*string{
	// 						[]*string{
	// 							to.Ptr("AllowAll"),
	// 							to.Ptr("0.0.0.0"),
	// 							to.Ptr("255.255.255.255")}},
	// 						},
	// 					},
	// 				}
}
