//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/servicefabric/armservicefabric/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ClusterVersionsServer is a fake server for instances of the armservicefabric.ClusterVersionsClient type.
type ClusterVersionsServer struct {
	// Get is the fake for method ClusterVersionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, location string, clusterVersion string, options *armservicefabric.ClusterVersionsClientGetOptions) (resp azfake.Responder[armservicefabric.ClusterVersionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByEnvironment is the fake for method ClusterVersionsClient.GetByEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	GetByEnvironment func(ctx context.Context, location string, environment armservicefabric.ClusterVersionsEnvironment, clusterVersion string, options *armservicefabric.ClusterVersionsClientGetByEnvironmentOptions) (resp azfake.Responder[armservicefabric.ClusterVersionsClientGetByEnvironmentResponse], errResp azfake.ErrorResponder)

	// List is the fake for method ClusterVersionsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, location string, options *armservicefabric.ClusterVersionsClientListOptions) (resp azfake.Responder[armservicefabric.ClusterVersionsClientListResponse], errResp azfake.ErrorResponder)

	// ListByEnvironment is the fake for method ClusterVersionsClient.ListByEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	ListByEnvironment func(ctx context.Context, location string, environment armservicefabric.ClusterVersionsEnvironment, options *armservicefabric.ClusterVersionsClientListByEnvironmentOptions) (resp azfake.Responder[armservicefabric.ClusterVersionsClientListByEnvironmentResponse], errResp azfake.ErrorResponder)
}

// NewClusterVersionsServerTransport creates a new instance of ClusterVersionsServerTransport with the provided implementation.
// The returned ClusterVersionsServerTransport instance is connected to an instance of armservicefabric.ClusterVersionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewClusterVersionsServerTransport(srv *ClusterVersionsServer) *ClusterVersionsServerTransport {
	return &ClusterVersionsServerTransport{srv: srv}
}

// ClusterVersionsServerTransport connects instances of armservicefabric.ClusterVersionsClient to instances of ClusterVersionsServer.
// Don't use this type directly, use NewClusterVersionsServerTransport instead.
type ClusterVersionsServerTransport struct {
	srv *ClusterVersionsServer
}

// Do implements the policy.Transporter interface for ClusterVersionsServerTransport.
func (c *ClusterVersionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ClusterVersionsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ClusterVersionsClient.GetByEnvironment":
		resp, err = c.dispatchGetByEnvironment(req)
	case "ClusterVersionsClient.List":
		resp, err = c.dispatchList(req)
	case "ClusterVersionsClient.ListByEnvironment":
		resp, err = c.dispatchListByEnvironment(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ClusterVersionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceFabric/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusterVersions/(?P<clusterVersion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	clusterVersionParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterVersion")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), locationParam, clusterVersionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterCodeVersionsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClusterVersionsServerTransport) dispatchGetByEnvironment(req *http.Request) (*http.Response, error) {
	if c.srv.GetByEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceFabric/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/environments/(?P<environment>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusterVersions/(?P<clusterVersion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	environmentParam, err := parseWithCast(matches[regex.SubexpIndex("environment")], func(v string) (armservicefabric.ClusterVersionsEnvironment, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicefabric.ClusterVersionsEnvironment(p), nil
	})
	if err != nil {
		return nil, err
	}
	clusterVersionParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterVersion")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetByEnvironment(req.Context(), locationParam, environmentParam, clusterVersionParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterCodeVersionsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClusterVersionsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if c.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceFabric/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusterVersions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.List(req.Context(), locationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterCodeVersionsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClusterVersionsServerTransport) dispatchListByEnvironment(req *http.Request) (*http.Response, error) {
	if c.srv.ListByEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ServiceFabric/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/environments/(?P<environment>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clusterVersions`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	environmentParam, err := parseWithCast(matches[regex.SubexpIndex("environment")], func(v string) (armservicefabric.ClusterVersionsEnvironment, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armservicefabric.ClusterVersionsEnvironment(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.ListByEnvironment(req.Context(), locationParam, environmentParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClusterCodeVersionsListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
