//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/serialconsole/armserialconsole"
	"net/http"
	"net/url"
	"regexp"
)

// SerialPortsServer is a fake server for instances of the armserialconsole.SerialPortsClient type.
type SerialPortsServer struct {
	// Connect is the fake for method SerialPortsClient.Connect
	// HTTP status codes to indicate success: http.StatusOK
	Connect func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourceType string, parentResource string, serialPort string, options *armserialconsole.SerialPortsClientConnectOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientConnectResponse], errResp azfake.ErrorResponder)

	// Create is the fake for method SerialPortsClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourceType string, parentResource string, serialPort string, parameters armserialconsole.SerialPort, options *armserialconsole.SerialPortsClientCreateOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SerialPortsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourceType string, parentResource string, serialPort string, options *armserialconsole.SerialPortsClientDeleteOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SerialPortsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourceType string, parentResource string, serialPort string, options *armserialconsole.SerialPortsClientGetOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SerialPortsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourceType string, parentResource string, options *armserialconsole.SerialPortsClientListOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientListResponse], errResp azfake.ErrorResponder)

	// ListBySubscriptions is the fake for method SerialPortsClient.ListBySubscriptions
	// HTTP status codes to indicate success: http.StatusOK
	ListBySubscriptions func(ctx context.Context, options *armserialconsole.SerialPortsClientListBySubscriptionsOptions) (resp azfake.Responder[armserialconsole.SerialPortsClientListBySubscriptionsResponse], errResp azfake.ErrorResponder)
}

// NewSerialPortsServerTransport creates a new instance of SerialPortsServerTransport with the provided implementation.
// The returned SerialPortsServerTransport instance is connected to an instance of armserialconsole.SerialPortsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSerialPortsServerTransport(srv *SerialPortsServer) *SerialPortsServerTransport {
	return &SerialPortsServerTransport{srv: srv}
}

// SerialPortsServerTransport connects instances of armserialconsole.SerialPortsClient to instances of SerialPortsServer.
// Don't use this type directly, use NewSerialPortsServerTransport instead.
type SerialPortsServerTransport struct {
	srv *SerialPortsServer
}

// Do implements the policy.Transporter interface for SerialPortsServerTransport.
func (s *SerialPortsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SerialPortsClient.Connect":
		resp, err = s.dispatchConnect(req)
	case "SerialPortsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SerialPortsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SerialPortsClient.Get":
		resp, err = s.dispatchGet(req)
	case "SerialPortsClient.List":
		resp, err = s.dispatchList(req)
	case "SerialPortsClient.ListBySubscriptions":
		resp, err = s.dispatchListBySubscriptions(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchConnect(req *http.Request) (*http.Response, error) {
	if s.srv.Connect == nil {
		return nil, &nonRetriableError{errors.New("fake for method Connect not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts/(?P<serialPort>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connect`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResource")])
	if err != nil {
		return nil, err
	}
	serialPortParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialPort")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Connect(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourceTypeParam, parentResourceParam, serialPortParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SerialPortConnectResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts/(?P<serialPort>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armserialconsole.SerialPort](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResource")])
	if err != nil {
		return nil, err
	}
	serialPortParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialPort")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourceTypeParam, parentResourceParam, serialPortParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SerialPort, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts/(?P<serialPort>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResource")])
	if err != nil {
		return nil, err
	}
	serialPortParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialPort")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourceTypeParam, parentResourceParam, serialPortParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts/(?P<serialPort>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResource")])
	if err != nil {
		return nil, err
	}
	serialPortParam, err := url.PathUnescape(matches[regex.SubexpIndex("serialPort")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourceTypeParam, parentResourceParam, serialPortParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SerialPort, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResource>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResource")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), resourceGroupNameParam, resourceProviderNamespaceParam, parentResourceTypeParam, parentResourceParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SerialPortListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SerialPortsServerTransport) dispatchListBySubscriptions(req *http.Request) (*http.Response, error) {
	if s.srv.ListBySubscriptions == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListBySubscriptions not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SerialConsole/serialPorts`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := s.srv.ListBySubscriptions(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SerialPortListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
