//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// OperatorsServer is a fake server for instances of the armsecurity.OperatorsClient type.
type OperatorsServer struct {
	// CreateOrUpdate is the fake for method OperatorsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, pricingName string, securityOperatorName string, options *armsecurity.OperatorsClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.OperatorsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method OperatorsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, pricingName string, securityOperatorName string, options *armsecurity.OperatorsClientDeleteOptions) (resp azfake.Responder[armsecurity.OperatorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method OperatorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, pricingName string, securityOperatorName string, options *armsecurity.OperatorsClientGetOptions) (resp azfake.Responder[armsecurity.OperatorsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method OperatorsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, pricingName string, options *armsecurity.OperatorsClientListOptions) (resp azfake.Responder[armsecurity.OperatorsClientListResponse], errResp azfake.ErrorResponder)
}

// NewOperatorsServerTransport creates a new instance of OperatorsServerTransport with the provided implementation.
// The returned OperatorsServerTransport instance is connected to an instance of armsecurity.OperatorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewOperatorsServerTransport(srv *OperatorsServer) *OperatorsServerTransport {
	return &OperatorsServerTransport{srv: srv}
}

// OperatorsServerTransport connects instances of armsecurity.OperatorsClient to instances of OperatorsServer.
// Don't use this type directly, use NewOperatorsServerTransport instead.
type OperatorsServerTransport struct {
	srv *OperatorsServer
}

// Do implements the policy.Transporter interface for OperatorsServerTransport.
func (o *OperatorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "OperatorsClient.CreateOrUpdate":
		resp, err = o.dispatchCreateOrUpdate(req)
	case "OperatorsClient.Delete":
		resp, err = o.dispatchDelete(req)
	case "OperatorsClient.Get":
		resp, err = o.dispatchGet(req)
	case "OperatorsClient.List":
		resp, err = o.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (o *OperatorsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if o.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securityOperators/(?P<securityOperatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	securityOperatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("securityOperatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.CreateOrUpdate(req.Context(), pricingNameParam, securityOperatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperatorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *OperatorsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if o.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securityOperators/(?P<securityOperatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	securityOperatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("securityOperatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Delete(req.Context(), pricingNameParam, securityOperatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *OperatorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if o.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securityOperators/(?P<securityOperatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	securityOperatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("securityOperatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.Get(req.Context(), pricingNameParam, securityOperatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperatorResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (o *OperatorsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if o.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/pricings/(?P<pricingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securityOperators`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	pricingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("pricingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := o.srv.List(req.Context(), pricingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).OperatorList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
