//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlocks

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagementLocksClient contains the methods for the ManagementLocks group.
// Don't use this type directly, use NewManagementLocksClient() instead.
type ManagementLocksClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagementLocksClient creates a new instance of ManagementLocksClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagementLocksClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementLocksClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementLocksClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdateAtResourceGroupLevel - When you apply a lock at a parent scope, all child resources inherit the same lock.
// To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group to lock.
//   - lockName - The lock name. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - The management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions) (ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.CreateOrUpdateAtResourceGroupLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	resp, err := client.createOrUpdateAtResourceGroupLevelHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtResourceGroupLevelCreateRequest creates the CreateOrUpdateAtResourceGroupLevel request.
func (client *ManagementLocksClient) createOrUpdateAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtResourceGroupLevelHandleResponse handles the CreateOrUpdateAtResourceGroupLevel response.
func (client *ManagementLocksClient) createOrUpdateAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtResourceLevel - When you apply a lock at a parent scope, all child resources inherit the same lock. To
// create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group containing the resource to lock.
//   - resourceProviderNamespace - The resource provider namespace of the resource to lock.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the resource to lock.
//   - resourceName - The name of the resource to lock.
//   - lockName - The name of lock. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - Parameters for creating or updating a management lock.
//   - options - ManagementLocksClientCreateOrUpdateAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtResourceLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceLevelOptions) (ManagementLocksClientCreateOrUpdateAtResourceLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.CreateOrUpdateAtResourceLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	resp, err := client.createOrUpdateAtResourceLevelHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtResourceLevelCreateRequest creates the CreateOrUpdateAtResourceLevel request.
func (client *ManagementLocksClient) createOrUpdateAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtResourceLevelHandleResponse handles the CreateOrUpdateAtResourceLevel response.
func (client *ManagementLocksClient) createOrUpdateAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtResourceLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtSubscriptionLevel - When you apply a lock at a parent scope, all child resources inherit the same lock.
// To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - lockName - The name of lock. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - The management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtSubscriptionLevel(ctx context.Context, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions) (ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.CreateOrUpdateAtSubscriptionLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtSubscriptionLevelCreateRequest(ctx, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	resp, err := client.createOrUpdateAtSubscriptionLevelHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtSubscriptionLevelCreateRequest creates the CreateOrUpdateAtSubscriptionLevel request.
func (client *ManagementLocksClient) createOrUpdateAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtSubscriptionLevelHandleResponse handles the CreateOrUpdateAtSubscriptionLevel response.
func (client *ManagementLocksClient) createOrUpdateAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateByScope - Create or update a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - scope - The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions,
//     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for
//     resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
//     for
//     resources.
//   - lockName - The name of lock.
//   - parameters - Create or update management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateByScopeOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateByScope
//     method.
func (client *ManagementLocksClient) CreateOrUpdateByScope(ctx context.Context, scope string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateByScopeOptions) (ManagementLocksClientCreateOrUpdateByScopeResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.CreateOrUpdateByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateByScopeCreateRequest(ctx, scope, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	resp, err := client.createOrUpdateByScopeHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateByScopeCreateRequest creates the CreateOrUpdateByScope request.
func (client *ManagementLocksClient) createOrUpdateByScopeCreateRequest(ctx context.Context, scope string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateByScopeHandleResponse handles the CreateOrUpdateByScope response.
func (client *ManagementLocksClient) createOrUpdateByScopeHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateByScopeResponse, error) {
	result := ManagementLocksClientCreateOrUpdateByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	return result, nil
}

// DeleteAtResourceGroupLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group containing the lock.
//   - lockName - The name of lock to delete.
//   - options - ManagementLocksClientDeleteAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) DeleteAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientDeleteAtResourceGroupLevelOptions) (ManagementLocksClientDeleteAtResourceGroupLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.DeleteAtResourceGroupLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, err
	}
	return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, nil
}

// deleteAtResourceGroupLevelCreateRequest creates the DeleteAtResourceGroupLevel request.
func (client *ManagementLocksClient) deleteAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientDeleteAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAtResourceLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group containing the resource with the lock to delete.
//   - resourceProviderNamespace - The resource provider namespace of the resource with the lock to delete.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the resource with the lock to delete.
//   - resourceName - The name of the resource with the lock to delete.
//   - lockName - The name of the lock to delete.
//   - options - ManagementLocksClientDeleteAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtResourceLevel
//     method.
func (client *ManagementLocksClient) DeleteAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientDeleteAtResourceLevelOptions) (ManagementLocksClientDeleteAtResourceLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.DeleteAtResourceLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, err
	}
	return ManagementLocksClientDeleteAtResourceLevelResponse{}, nil
}

// deleteAtResourceLevelCreateRequest creates the DeleteAtResourceLevel request.
func (client *ManagementLocksClient) deleteAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientDeleteAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAtSubscriptionLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - lockName - The name of lock to delete.
//   - options - ManagementLocksClientDeleteAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) DeleteAtSubscriptionLevel(ctx context.Context, lockName string, options *ManagementLocksClientDeleteAtSubscriptionLevelOptions) (ManagementLocksClientDeleteAtSubscriptionLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.DeleteAtSubscriptionLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtSubscriptionLevelCreateRequest(ctx, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, err
	}
	return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, nil
}

// deleteAtSubscriptionLevelCreateRequest creates the DeleteAtSubscriptionLevel request.
func (client *ManagementLocksClient) deleteAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, options *ManagementLocksClientDeleteAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteByScope - Delete a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - scope - The scope for the lock.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientDeleteByScopeOptions contains the optional parameters for the ManagementLocksClient.DeleteByScope
//     method.
func (client *ManagementLocksClient) DeleteByScope(ctx context.Context, scope string, lockName string, options *ManagementLocksClientDeleteByScopeOptions) (ManagementLocksClientDeleteByScopeResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.DeleteByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteByScopeCreateRequest(ctx, scope, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientDeleteByScopeResponse{}, err
	}
	return ManagementLocksClientDeleteByScopeResponse{}, nil
}

// deleteByScopeCreateRequest creates the DeleteByScope request.
func (client *ManagementLocksClient) deleteByScopeCreateRequest(ctx context.Context, scope string, lockName string, options *ManagementLocksClientDeleteByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetAtResourceGroupLevel - Gets a management lock at the resource group level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the locked resource group.
//   - lockName - The name of the lock to get.
//   - options - ManagementLocksClientGetAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) GetAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientGetAtResourceGroupLevelOptions) (ManagementLocksClientGetAtResourceGroupLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.GetAtResourceGroupLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	resp, err := client.getAtResourceGroupLevelHandleResponse(httpResp)
	return resp, err
}

// getAtResourceGroupLevelCreateRequest creates the GetAtResourceGroupLevel request.
func (client *ManagementLocksClient) getAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientGetAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceGroupLevelHandleResponse handles the GetAtResourceGroupLevel response.
func (client *ManagementLocksClient) getAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientGetAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// GetAtResourceLevel - Get the management lock of a resource or any level below resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group.
//   - resourceProviderNamespace - The namespace of the resource provider.
//   - parentResourcePath - An extra path parameter needed in some services, like SQL Databases.
//   - resourceType - The type of the resource.
//   - resourceName - The name of the resource.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientGetAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtResourceLevel
//     method.
func (client *ManagementLocksClient) GetAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientGetAtResourceLevelOptions) (ManagementLocksClientGetAtResourceLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.GetAtResourceLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	resp, err := client.getAtResourceLevelHandleResponse(httpResp)
	return resp, err
}

// getAtResourceLevelCreateRequest creates the GetAtResourceLevel request.
func (client *ManagementLocksClient) getAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientGetAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceLevelHandleResponse handles the GetAtResourceLevel response.
func (client *ManagementLocksClient) getAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtResourceLevelResponse, error) {
	result := ManagementLocksClientGetAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	return result, nil
}

// GetAtSubscriptionLevel - Gets a management lock at the subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - lockName - The name of the lock to get.
//   - options - ManagementLocksClientGetAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) GetAtSubscriptionLevel(ctx context.Context, lockName string, options *ManagementLocksClientGetAtSubscriptionLevelOptions) (ManagementLocksClientGetAtSubscriptionLevelResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.GetAtSubscriptionLevel"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtSubscriptionLevelCreateRequest(ctx, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	resp, err := client.getAtSubscriptionLevelHandleResponse(httpResp)
	return resp, err
}

// getAtSubscriptionLevelCreateRequest creates the GetAtSubscriptionLevel request.
func (client *ManagementLocksClient) getAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, options *ManagementLocksClientGetAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtSubscriptionLevelHandleResponse handles the GetAtSubscriptionLevel response.
func (client *ManagementLocksClient) getAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientGetAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// GetByScope - Get a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-05-01
//   - scope - The scope for the lock.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientGetByScopeOptions contains the optional parameters for the ManagementLocksClient.GetByScope
//     method.
func (client *ManagementLocksClient) GetByScope(ctx context.Context, scope string, lockName string, options *ManagementLocksClientGetByScopeOptions) (ManagementLocksClientGetByScopeResponse, error) {
	var err error
	const operationName = "ManagementLocksClient.GetByScope"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getByScopeCreateRequest(ctx, scope, lockName, options)
	if err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	resp, err := client.getByScopeHandleResponse(httpResp)
	return resp, err
}

// getByScopeCreateRequest creates the GetByScope request.
func (client *ManagementLocksClient) getByScopeCreateRequest(ctx context.Context, scope string, lockName string, options *ManagementLocksClientGetByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByScopeHandleResponse handles the GetByScope response.
func (client *ManagementLocksClient) getByScopeHandleResponse(resp *http.Response) (ManagementLocksClientGetByScopeResponse, error) {
	result := ManagementLocksClientGetByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	return result, nil
}

// NewListAtResourceGroupLevelPager - Gets all the management locks for a resource group.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group containing the locks to get.
//   - options - ManagementLocksClientListAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtResourceGroupLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtResourceGroupLevelPager(resourceGroupName string, options *ManagementLocksClientListAtResourceGroupLevelOptions) *runtime.Pager[ManagementLocksClientListAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtResourceGroupLevelResponse]{
		More: func(page ManagementLocksClientListAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtResourceGroupLevelResponse) (ManagementLocksClientListAtResourceGroupLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementLocksClient.NewListAtResourceGroupLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return ManagementLocksClientListAtResourceGroupLevelResponse{}, err
			}
			return client.listAtResourceGroupLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtResourceGroupLevelCreateRequest creates the ListAtResourceGroupLevel request.
func (client *ManagementLocksClient) listAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementLocksClientListAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtResourceGroupLevelHandleResponse handles the ListAtResourceGroupLevel response.
func (client *ManagementLocksClient) listAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientListAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListAtResourceLevelPager - Gets all the management locks for a resource or any level below resource.
//
// Generated from API version 2020-05-01
//   - resourceGroupName - The name of the resource group containing the locked resource. The name is case insensitive.
//   - resourceProviderNamespace - The namespace of the resource provider.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the locked resource.
//   - resourceName - The name of the locked resource.
//   - options - ManagementLocksClientListAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtResourceLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtResourceLevelPager(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *ManagementLocksClientListAtResourceLevelOptions) *runtime.Pager[ManagementLocksClientListAtResourceLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtResourceLevelResponse]{
		More: func(page ManagementLocksClientListAtResourceLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtResourceLevelResponse) (ManagementLocksClientListAtResourceLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementLocksClient.NewListAtResourceLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, options)
			}, nil)
			if err != nil {
				return ManagementLocksClientListAtResourceLevelResponse{}, err
			}
			return client.listAtResourceLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtResourceLevelCreateRequest creates the ListAtResourceLevel request.
func (client *ManagementLocksClient) listAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *ManagementLocksClientListAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtResourceLevelHandleResponse handles the ListAtResourceLevel response.
func (client *ManagementLocksClient) listAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtResourceLevelResponse, error) {
	result := ManagementLocksClientListAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtResourceLevelResponse{}, err
	}
	return result, nil
}

// NewListAtSubscriptionLevelPager - Gets all the management locks for a subscription.
//
// Generated from API version 2020-05-01
//   - options - ManagementLocksClientListAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtSubscriptionLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtSubscriptionLevelPager(options *ManagementLocksClientListAtSubscriptionLevelOptions) *runtime.Pager[ManagementLocksClientListAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtSubscriptionLevelResponse]{
		More: func(page ManagementLocksClientListAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtSubscriptionLevelResponse) (ManagementLocksClientListAtSubscriptionLevelResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementLocksClient.NewListAtSubscriptionLevelPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAtSubscriptionLevelCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ManagementLocksClientListAtSubscriptionLevelResponse{}, err
			}
			return client.listAtSubscriptionLevelHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAtSubscriptionLevelCreateRequest creates the ListAtSubscriptionLevel request.
func (client *ManagementLocksClient) listAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementLocksClientListAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtSubscriptionLevelHandleResponse handles the ListAtSubscriptionLevel response.
func (client *ManagementLocksClient) listAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientListAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListByScopePager - Gets all the management locks for a scope.
//
// Generated from API version 2020-05-01
//   - scope - The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions,
//     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for
//     resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
//     for
//     resources.
//   - options - ManagementLocksClientListByScopeOptions contains the optional parameters for the ManagementLocksClient.NewListByScopePager
//     method.
func (client *ManagementLocksClient) NewListByScopePager(scope string, options *ManagementLocksClientListByScopeOptions) *runtime.Pager[ManagementLocksClientListByScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListByScopeResponse]{
		More: func(page ManagementLocksClientListByScopeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListByScopeResponse) (ManagementLocksClientListByScopeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ManagementLocksClient.NewListByScopePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByScopeCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return ManagementLocksClientListByScopeResponse{}, err
			}
			return client.listByScopeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByScopeCreateRequest creates the ListByScope request.
func (client *ManagementLocksClient) listByScopeCreateRequest(ctx context.Context, scope string, options *ManagementLocksClientListByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByScopeHandleResponse handles the ListByScope response.
func (client *ManagementLocksClient) listByScopeHandleResponse(resp *http.Response) (ManagementLocksClientListByScopeResponse, error) {
	result := ManagementLocksClientListByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListByScopeResponse{}, err
	}
	return result, nil
}
