//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdeploymentstacks_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armdeploymentstacks"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackResourceGroupList.json
func ExampleClient_NewListAtResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListAtResourceGroupPager("deploymentStacksRG", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentStackListResult = armdeploymentstacks.DeploymentStackListResult{
		// 	Value: []*armdeploymentstacks.DeploymentStack{
		// 		{
		// 			Name: to.Ptr("simpleDeploymentStack"),
		// 			Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
		// 			SystemData: &armdeploymentstacks.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 				ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 					ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 					ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 					Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 				},
		// 				DenySettings: &armdeploymentstacks.DenySettings{
		// 					ApplyToChildScopes: to.Ptr(false),
		// 					ExcludedActions: []*string{
		// 						to.Ptr("action")},
		// 						ExcludedPrincipals: []*string{
		// 							to.Ptr("principal")},
		// 							Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 						},
		// 						Duration: to.Ptr("PT1D12H"),
		// 						Outputs: map[string]any{
		// 							"myOut": "myVal",
		// 						},
		// 						Parameters: map[string]any{
		// 							"parameter1":map[string]any{
		// 								"value": "a string",
		// 							},
		// 						},
		// 					},
		// 					Tags: map[string]*string{
		// 						"tagkey": to.Ptr("tagVal"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("simpleDeploymentStack2"),
		// 					Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack2"),
		// 					SystemData: &armdeploymentstacks.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 						CreatedBy: to.Ptr("string"),
		// 						CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("string"),
		// 						LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 					},
		// 					Location: to.Ptr("eastus"),
		// 					Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 						ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 							ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 							ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 							Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 						},
		// 						DenySettings: &armdeploymentstacks.DenySettings{
		// 							ApplyToChildScopes: to.Ptr(false),
		// 							ExcludedActions: []*string{
		// 								to.Ptr("action")},
		// 								ExcludedPrincipals: []*string{
		// 									to.Ptr("principal")},
		// 									Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 								},
		// 								DeploymentID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deployments/simpleDeploymentStack2-20210301-3f41c"),
		// 								Duration: to.Ptr("PT1D12H"),
		// 								Outputs: map[string]any{
		// 									"myOut": "myVal",
		// 								},
		// 								Parameters: map[string]any{
		// 									"parameter1":map[string]any{
		// 										"value": "a string",
		// 									},
		// 								},
		// 								ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
		// 								Resources: []*armdeploymentstacks.ManagedResourceReference{
		// 									{
		// 										ID: to.Ptr("/subscriptions/00000000-2222-2222-2222-000000000000/resourceGroups/templateSpecsRG/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 									},
		// 									{
		// 										ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 								}},
		// 							},
		// 							Tags: map[string]*string{
		// 								"tagkey": to.Ptr("tagVal"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackSubscriptionList.json
func ExampleClient_NewListAtSubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListAtSubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentStackListResult = armdeploymentstacks.DeploymentStackListResult{
		// 	Value: []*armdeploymentstacks.DeploymentStack{
		// 		{
		// 			Name: to.Ptr("simpleDeploymentStack"),
		// 			Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
		// 			SystemData: &armdeploymentstacks.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 				ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 					ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 					ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 					Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 				},
		// 				DenySettings: &armdeploymentstacks.DenySettings{
		// 					ApplyToChildScopes: to.Ptr(false),
		// 					ExcludedActions: []*string{
		// 						to.Ptr("action")},
		// 						ExcludedPrincipals: []*string{
		// 							to.Ptr("principal")},
		// 							Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 						},
		// 						Duration: to.Ptr("PT1D12H"),
		// 						Outputs: map[string]any{
		// 							"myOut": "myVal",
		// 						},
		// 						Parameters: map[string]any{
		// 							"parameter1":map[string]any{
		// 								"value": "a string",
		// 							},
		// 						},
		// 					},
		// 					Tags: map[string]*string{
		// 						"tagkey": to.Ptr("tagVal"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("simpleDeploymentStack2"),
		// 					Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack2"),
		// 					SystemData: &armdeploymentstacks.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 						CreatedBy: to.Ptr("string"),
		// 						CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("string"),
		// 						LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 					},
		// 					Location: to.Ptr("eastus"),
		// 					Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 						ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 							ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 							ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 							Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 						},
		// 						DenySettings: &armdeploymentstacks.DenySettings{
		// 							ApplyToChildScopes: to.Ptr(false),
		// 							ExcludedActions: []*string{
		// 								to.Ptr("action")},
		// 								ExcludedPrincipals: []*string{
		// 									to.Ptr("principal")},
		// 									Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 								},
		// 								DeploymentID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deployments/simpleDeploymentStack2-20210301-3f41c"),
		// 								Duration: to.Ptr("PT1D12H"),
		// 								Outputs: map[string]any{
		// 									"myOut": "myVal",
		// 								},
		// 								Parameters: map[string]any{
		// 									"parameter1":map[string]any{
		// 										"value": "a string",
		// 									},
		// 								},
		// 								ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
		// 								Resources: []*armdeploymentstacks.ManagedResourceReference{
		// 									{
		// 										ID: to.Ptr("/subscriptions/00000000-2222-2222-2222-000000000000/resourceGroups/templateSpecsRG/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 									},
		// 									{
		// 										ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 								}},
		// 							},
		// 							Tags: map[string]*string{
		// 								"tagkey": to.Ptr("tagVal"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackManagementGroupList.json
func ExampleClient_NewListAtManagementGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewClient().NewListAtManagementGroupPager("myMg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DeploymentStackListResult = armdeploymentstacks.DeploymentStackListResult{
		// 	Value: []*armdeploymentstacks.DeploymentStack{
		// 		{
		// 			Name: to.Ptr("simpleDeploymentStack"),
		// 			Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
		// 			SystemData: &armdeploymentstacks.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 				CreatedBy: to.Ptr("string"),
		// 				CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("string"),
		// 				LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 				ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 					ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 					ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 					Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 				},
		// 				DenySettings: &armdeploymentstacks.DenySettings{
		// 					ApplyToChildScopes: to.Ptr(false),
		// 					ExcludedActions: []*string{
		// 						to.Ptr("action")},
		// 						ExcludedPrincipals: []*string{
		// 							to.Ptr("principal")},
		// 							Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 						},
		// 						Duration: to.Ptr("PT1D12H"),
		// 						Outputs: map[string]any{
		// 							"myOut": "myVal",
		// 						},
		// 						Parameters: map[string]any{
		// 							"parameter1":map[string]any{
		// 								"value": "a string",
		// 							},
		// 						},
		// 					},
		// 					Tags: map[string]*string{
		// 						"tagkey": to.Ptr("tagVal"),
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("simpleDeploymentStack2"),
		// 					Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
		// 					ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack2"),
		// 					SystemData: &armdeploymentstacks.SystemData{
		// 						CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
		// 						CreatedBy: to.Ptr("string"),
		// 						CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 						LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
		// 						LastModifiedBy: to.Ptr("string"),
		// 						LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
		// 					},
		// 					Location: to.Ptr("eastus"),
		// 					Properties: &armdeploymentstacks.DeploymentStackProperties{
		// 						ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
		// 							ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
		// 							ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 							Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
		// 						},
		// 						DenySettings: &armdeploymentstacks.DenySettings{
		// 							ApplyToChildScopes: to.Ptr(false),
		// 							ExcludedActions: []*string{
		// 								to.Ptr("action")},
		// 								ExcludedPrincipals: []*string{
		// 									to.Ptr("principal")},
		// 									Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
		// 								},
		// 								DeploymentID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deployments/simpleDeploymentStack2-20210301-3f41c"),
		// 								Duration: to.Ptr("PT1D12H"),
		// 								Outputs: map[string]any{
		// 									"myOut": "myVal",
		// 								},
		// 								Parameters: map[string]any{
		// 									"parameter1":map[string]any{
		// 										"value": "a string",
		// 									},
		// 								},
		// 								ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
		// 								Resources: []*armdeploymentstacks.ManagedResourceReference{
		// 									{
		// 										ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 									},
		// 									{
		// 										ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
		// 										DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
		// 										Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
		// 								}},
		// 							},
		// 							Tags: map[string]*string{
		// 								"tagkey": to.Ptr("tagVal"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackResourceGroupCreate.json
func ExampleClient_BeginCreateOrUpdateAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdateAtResourceGroup(ctx, "deploymentStacksRG", "simpleDeploymentStack", armdeploymentstacks.DeploymentStack{
		Location: to.Ptr("eastus"),
		Properties: &armdeploymentstacks.DeploymentStackProperties{
			ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
				ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
				ResourceGroups:   to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
				Resources:        to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
			},
			DenySettings: &armdeploymentstacks.DenySettings{
				ApplyToChildScopes: to.Ptr(false),
				ExcludedActions: []*string{
					to.Ptr("action")},
				ExcludedPrincipals: []*string{
					to.Ptr("principal")},
				Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
			},
			Parameters: map[string]any{
				"parameter1": map[string]any{
					"value": "a string",
				},
			},
		},
		Tags: map[string]*string{
			"tagkey": to.Ptr("tagVal"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackResourceGroupGet.json
func ExampleClient_GetAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetAtResourceGroup(ctx, "deploymentStacksRG", "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				DeploymentID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deployments/simpleDeploymentStack-20210301-3f41c"),
	// 				DeploymentScope: to.Ptr("/subscriptions/00000000-1111-1111-1111-000000000000"),
	// 				Duration: to.Ptr("PT1D12H"),
	// 				Outputs: map[string]any{
	// 					"myOut": "myVal",
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 				Resources: []*armdeploymentstacks.ManagedResourceReference{
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-2222-2222-2222-000000000000/resourceGroups/templateSpecsRG/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 				}},
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackResourceGroupDelete.json
func ExampleClient_BeginDeleteAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDeleteAtResourceGroup(ctx, "deploymentStacksRG", "simpleDeploymentStack", &armdeploymentstacks.ClientBeginDeleteAtResourceGroupOptions{UnmanageActionResources: nil,
		UnmanageActionResourceGroups: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackSubscriptionCreate.json
func ExampleClient_BeginCreateOrUpdateAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdateAtSubscription(ctx, "simpleDeploymentStack", armdeploymentstacks.DeploymentStack{
		Location: to.Ptr("eastus"),
		Properties: &armdeploymentstacks.DeploymentStackProperties{
			ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
				ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
				ResourceGroups:   to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
				Resources:        to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
			},
			DenySettings: &armdeploymentstacks.DenySettings{
				ApplyToChildScopes: to.Ptr(false),
				ExcludedActions: []*string{
					to.Ptr("action")},
				ExcludedPrincipals: []*string{
					to.Ptr("principal")},
				Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
			},
			Parameters: map[string]any{
				"parameter1": map[string]any{
					"value": "a string",
				},
			},
		},
		Tags: map[string]*string{
			"tagkey": to.Ptr("tagVal"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackSubscriptionGet.json
func ExampleClient_GetAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetAtSubscription(ctx, "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				DeploymentID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/deployments/simpleDeploymentStack-20210301-3f41c"),
	// 				DeploymentScope: to.Ptr("/subscriptions/00000000-1111-1111-1111-000000000000"),
	// 				Duration: to.Ptr("PT1D12H"),
	// 				Outputs: map[string]any{
	// 					"myOut": "myVal",
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 				Resources: []*armdeploymentstacks.ManagedResourceReference{
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-2222-2222-2222-000000000000/resourceGroups/templateSpecsRG/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 					},
	// 					{
	// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 				}},
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackSubscriptionDelete.json
func ExampleClient_BeginDeleteAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDeleteAtSubscription(ctx, "simpleDeploymentStack", &armdeploymentstacks.ClientBeginDeleteAtSubscriptionOptions{UnmanageActionResources: nil,
		UnmanageActionResourceGroups: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackManagementGroupCreate.json
func ExampleClient_BeginCreateOrUpdateAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginCreateOrUpdateAtManagementGroup(ctx, "myMg", "simpleDeploymentStack", armdeploymentstacks.DeploymentStack{
		Location: to.Ptr("eastus"),
		Properties: &armdeploymentstacks.DeploymentStackProperties{
			ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
				ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
				ResourceGroups:   to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
				Resources:        to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
			},
			DenySettings: &armdeploymentstacks.DenySettings{
				ApplyToChildScopes: to.Ptr(false),
				ExcludedActions: []*string{
					to.Ptr("action")},
				ExcludedPrincipals: []*string{
					to.Ptr("principal")},
				Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
			},
			Parameters: map[string]any{
				"parameter1": map[string]any{
					"value": "a string",
				},
			},
		},
		Tags: map[string]*string{
			"tagkey": to.Ptr("tagVal"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackManagementGroupGet.json
func ExampleClient_GetAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().GetAtManagementGroup(ctx, "myMg", "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStack = armdeploymentstacks.DeploymentStack{
	// 	Name: to.Ptr("simpleDeploymentStack"),
	// 	Type: to.Ptr("Microsoft.Resources/deploymentStacks"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deploymentStacks/simpleDeploymentStack"),
	// 	SystemData: &armdeploymentstacks.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-01T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-02T02:03:01.197Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armdeploymentstacks.CreatedByTypeApplication),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armdeploymentstacks.DeploymentStackProperties{
	// 		Description: to.Ptr("my Description"),
	// 		ActionOnUnmanage: &armdeploymentstacks.DeploymentStackPropertiesActionOnUnmanage{
	// 			ManagementGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDetach),
	// 			ResourceGroups: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 			Resources: to.Ptr(armdeploymentstacks.DeploymentStacksDeleteDetachEnumDelete),
	// 		},
	// 		DenySettings: &armdeploymentstacks.DenySettings{
	// 			ApplyToChildScopes: to.Ptr(false),
	// 			ExcludedActions: []*string{
	// 				to.Ptr("action")},
	// 				ExcludedPrincipals: []*string{
	// 					to.Ptr("principal")},
	// 					Mode: to.Ptr(armdeploymentstacks.DenySettingsModeDenyDelete),
	// 				},
	// 				DeploymentID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/deployments/simpleDeploymentStack-20210301-3f41c"),
	// 				DeploymentScope: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg"),
	// 				Duration: to.Ptr("PT1D12H"),
	// 				Outputs: map[string]any{
	// 					"myOut": "myVal",
	// 				},
	// 				Parameters: map[string]any{
	// 					"parameter1":map[string]any{
	// 						"value": "a string",
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armdeploymentstacks.DeploymentStackProvisioningStateSucceeded),
	// 				Resources: []*armdeploymentstacks.ManagedResourceReference{
	// 					{
	// 						ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 					},
	// 					{
	// 						ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
	// 						DenyStatus: to.Ptr(armdeploymentstacks.DenyStatusModeDenyDelete),
	// 						Status: to.Ptr(armdeploymentstacks.ResourceStatusModeManaged),
	// 				}},
	// 			},
	// 			Tags: map[string]*string{
	// 				"tagkey": to.Ptr("tagVal"),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackManagementGroupDelete.json
func ExampleClient_BeginDeleteAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewClient().BeginDeleteAtManagementGroup(ctx, "myMg", "simpleDeploymentStack", &armdeploymentstacks.ClientBeginDeleteAtManagementGroupOptions{UnmanageActionResources: nil,
		UnmanageActionResourceGroups:   nil,
		UnmanageActionManagementGroups: nil,
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackExportTemplate.json
func ExampleClient_ExportTemplateAtResourceGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ExportTemplateAtResourceGroup(ctx, "deploymentStacksRG", "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStackTemplateDefinition = armdeploymentstacks.DeploymentStackTemplateDefinition{
	// 	Template: map[string]any{
	// 		"$schema": "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
	// 		"contentVersion": "1.0.0.0",
	// 		"functions":[]any{
	// 		},
	// 		"metadata":map[string]any{
	// 			"_generator":map[string]any{
	// 				"name": "bicep",
	// 				"templateHash": "1201162276450656794",
	// 				"version": "0.4.1008.15138",
	// 			},
	// 		},
	// 		"outputs":map[string]any{
	// 			"myOut":map[string]any{
	// 				"type": "int",
	// 				"value": float64(1),
	// 			},
	// 		},
	// 		"resources":[]any{
	// 		},
	// 	},
	// 	TemplateLink: &armdeploymentstacks.TemplateLink{
	// 		ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/deploymentStacksRG/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackSubscriptionExportTemplate.json
func ExampleClient_ExportTemplateAtSubscription() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ExportTemplateAtSubscription(ctx, "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStackTemplateDefinition = armdeploymentstacks.DeploymentStackTemplateDefinition{
	// 	Template: map[string]any{
	// 		"$schema": "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
	// 		"contentVersion": "1.0.0.0",
	// 		"functions":[]any{
	// 		},
	// 		"metadata":map[string]any{
	// 			"_generator":map[string]any{
	// 				"name": "bicep",
	// 				"templateHash": "1201162276450656794",
	// 				"version": "0.4.1008.15138",
	// 			},
	// 		},
	// 		"outputs":map[string]any{
	// 			"myOut":map[string]any{
	// 				"type": "int",
	// 				"value": float64(1),
	// 			},
	// 		},
	// 		"resources":[]any{
	// 		},
	// 	},
	// 	TemplateLink: &armdeploymentstacks.TemplateLink{
	// 		ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/ca162308f1010bfb85b9c85021e863e7bd397a1f/specification/resources/resource-manager/Microsoft.Resources/preview/2022-08-01-preview/examples/DeploymentStackManagementGroupExportTemplate.json
func ExampleClient_ExportTemplateAtManagementGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdeploymentstacks.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewClient().ExportTemplateAtManagementGroup(ctx, "myMg", "simpleDeploymentStack", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DeploymentStackTemplateDefinition = armdeploymentstacks.DeploymentStackTemplateDefinition{
	// 	Template: map[string]any{
	// 		"$schema": "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",
	// 		"contentVersion": "1.0.0.0",
	// 		"functions":[]any{
	// 		},
	// 		"metadata":map[string]any{
	// 			"_generator":map[string]any{
	// 				"name": "bicep",
	// 				"templateHash": "1201162276450656794",
	// 				"version": "0.4.1008.15138",
	// 			},
	// 		},
	// 		"outputs":map[string]any{
	// 			"myOut":map[string]any{
	// 				"type": "int",
	// 				"value": float64(1),
	// 			},
	// 		},
	// 		"resources":[]any{
	// 		},
	// 	},
	// 	TemplateLink: &armdeploymentstacks.TemplateLink{
	// 		ID: to.Ptr("/providers/Microsoft.Management/managementGroups/myMg/providers/Microsoft.Resources/templateSpecs/templateSpec/versions/1.0"),
	// 	},
	// }
}
